/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/08 13:00:54 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgwindow.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.2 $
    Status:           $State: Exp $
*/

#ifndef PG_WINDOW_H
#define PG_WINDOW_H

#ifdef SWIG
%include "swigcommon.h"
%module pgwindow
%{
#include "pgwindow.h"
%}
#endif

#include "pgstaticframe.h"
#include "pgbutton.h"
#include "pglabel.h"
#include <string>

/**
	@author Alexander Pipelka

	@short A window inside the program (not a windowing environment window)

	Creates a window entirely inside ParaGUI. This window can be modal or non-modal.
	Non-modal windows can be brought in front of others by clicking the titlebar.
*/

class DECLSPEC PG_Window : public PG_StaticFrame  {
public:
	
	/** */
	PG_Window(PG_Widget* parent, const PG_Rect& r, char* windowtext, bool modal = false, const char* style="Window");
	
	/** */
	~PG_Window();

	void LoadThemeStyle(const char* widgettype);

	void SetColorTitlebar(Uint32 color);
	
protected:

	/** */
	void eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst);

	/** */
	void eventSizeWindow(int w, int h);
	
	/** */
	bool eventButtonClick(int id, PG_Widget* widget);

	/** */
	bool eventMouseButtonDown(const SDL_MouseButtonEvent* button);

	/** */
	bool eventMouseButtonUp(const SDL_MouseButtonEvent* button);
	
	/** */
	bool eventMouseMotion(const SDL_MouseMotionEvent* motion);

private:

	PG_Rect my_rectTitlebar;
	SDL_Surface* my_srfTitlebar;
	PG_Gradient my_gradientTitlebar;
	SDL_Color my_colorTitlebar;

	Uint8 my_heightTitlebar;
	SDL_Surface* my_backgroundTitlebar;
	int my_backmodeTitlebar;
	int my_blendTitlebar;
	int my_bordersizeTitlebar;
	
	PG_Button* my_buttonClose;
	PG_Button* my_buttonMinimize;

	bool my_moveMode;
	Uint8 my_moveTransparency;
	PG_Point my_moveDelta;
	bool my_showCloseButton;

private: // disable the copy operators
	PG_Window(const PG_Window&);
	PG_Window& operator=(const PG_Window&);

	PG_Label* my_labelTitle;
};

#endif // PG_WINDOW_H
