// defaults.h.in
/*

Copyright (C) 1996 John W. Eaton

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if !defined (octave_defaults_h)
#define octave_defaults_h 1

#include <string>

#include "pathsearch.h"

#ifndef DEFAULT_PAGER
#define DEFAULT_PAGER "less"
#endif

#ifndef OCTAVE_PREFIX
#define OCTAVE_PREFIX "/usr/local"
#endif

#ifndef OCTAVE_EXEC_PREFIX
#define OCTAVE_EXEC_PREFIX "/usr/local"
#endif

#ifndef OCTAVE_DATADIR
#define OCTAVE_DATADIR "/usr/local/share"
#endif

#ifndef OCTAVE_LIBEXECDIR
#define OCTAVE_LIBEXECDIR "/usr/local/libexec"
#endif

#ifndef OCTAVE_LIBDIR
#define OCTAVE_LIBDIR "/usr/local/lib"
#endif

#ifndef OCTAVE_OCTLIBDIR
#define OCTAVE_OCTLIBDIR "/usr/local/lib/octave-2.0.16"
#endif

#ifndef OCTAVE_BINDIR
#define OCTAVE_BINDIR "/usr/local/bin"
#endif

#ifndef OCTAVE_INFODIR
#define OCTAVE_INFODIR "/usr/local/info"
#endif

#ifndef OCTAVE_INFOFILE
#define OCTAVE_INFOFILE "/usr/local/info/octave.info"
#endif

#ifndef OCTAVE_FCNFILEDIR
#define OCTAVE_FCNFILEDIR "/usr/local/share/octave/2.0.16/m"
#endif

#ifndef OCTAVE_LOCALFCNFILEDIR
#define OCTAVE_LOCALFCNFILEDIR "/usr/local/share/octave/site/m"
#endif

#ifndef OCTAVE_LOCALSTARTUPFILEDIR
#define OCTAVE_LOCALSTARTUPFILEDIR OCTAVE_LOCALFCNFILEDIR "/startup"
#endif

#ifndef OCTAVE_STARTUPFILEDIR
#define OCTAVE_STARTUPFILEDIR OCTAVE_FCNFILEDIR "/startup"
#endif

#ifndef OCTAVE_LOCALFCNFILEPATH
#define OCTAVE_LOCALFCNFILEPATH "/usr/local/share/octave/site/m//"
#endif

#ifndef OCTAVE_ARCHLIBDIR
#define OCTAVE_ARCHLIBDIR "/usr/local/libexec/octave/2.0.16/exec/sparc-unknown-openbsd3.8"
#endif

#ifndef OCTAVE_LOCALARCHLIBDIR
#define OCTAVE_LOCALARCHLIBDIR "/usr/local/libexec/octave/site/exec/sparc-unknown-openbsd3.8"
#endif

#ifndef OCTAVE_OCTFILEDIR
#define OCTAVE_OCTFILEDIR "/usr/local/libexec/octave/2.0.16/oct/sparc-unknown-openbsd3.8"
#endif

#ifndef OCTAVE_LOCALOCTFILEPATH
#define OCTAVE_LOCALOCTFILEPATH "/usr/local/libexec/octave/site/oct/sparc-unknown-openbsd3.8//"
#endif

#ifndef OCTAVE_FCNFILEPATH
#define OCTAVE_FCNFILEPATH ".:/usr/local/libexec/octave/site/oct/sparc-unknown-openbsd3.8//:/usr/local/share/octave/site/m//:/usr/local/libexec/octave/2.0.16/oct/sparc-unknown-openbsd3.8//:/usr/local/share/octave/2.0.16/m//"
#endif

#ifndef OCTAVE_IMAGEPATH
#define OCTAVE_IMAGEPATH ".:/usr/local/share/octave/2.0.16/imagelib//"
#endif

#ifndef CANONICAL_HOST_TYPE
#define CANONICAL_HOST_TYPE "sparc-unknown-openbsd3.8"
#endif

extern string Voctave_home;

extern string Vbin_dir;
extern string Vlib_dir;
extern string Vinfo_dir;
extern string Vdata_dir;
extern string Vlibexec_dir;
extern string Varch_lib_dir;
extern string Vlocal_arch_lib_dir;
extern string Vfcn_file_dir;

// The path that will be searched for programs that we execute.
// (--exec-path path)
extern string Vexec_path;

// And the cached directory path corresponding to Vload_path.
extern dir_path Vload_path_dir_path;

// Name of the editor to be invoked by the edit_history command.
extern string Veditor;

extern string Vimagepath;

extern string Vlocal_site_defaults_file;
extern string Vsite_defaults_file;

extern void install_defaults (void);

extern void symbols_of_defaults (void);

#endif

/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; page-delimiter: "^/\\*" ***
;;; End: ***
*/
