/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef _ERL_LOCKING_H
#define _ERL_LOCKING_H

#ifdef __WIN32__
#include <windows.h>
#include <winbase.h>

#elif VXWORKS
#include <vxWorks.h>
#include <semLib.h>

#else /* unix */

#ifdef _REENTRANT
#ifdef PTHREADS
extern int erl_init_pthreads(void *x, long y);
#define erl_init(x,y) erl_init_pthreads(x,y)

#elif STHREADS
extern int erl_init_sthreads(void *x, long y);
#define erl_init(x,y) erl_init_sthreads(x,y)

#else /* unspecified threads */
extern int erl_init_pthreads(void *x, long y);
#define erl_init(x,y) erl_init_pthreads(x,y)

#endif /* threads */
#endif /* _REENTRANT */
#endif  /* unix */

#ifndef erl_init
extern void erl_init_nothreads(void *x, long y);
#define erl_init(x,y) erl_init_nothreads(x,y)
#endif /* erl_init */

typedef struct erl_mutex_s {
#ifdef __WIN32__
  HANDLE lock;

#elif VXWORKS
  SEM_ID lock;

#else /* unix */
  void *lock;
#endif 
} erl_mutex_t;

extern int erl_init_locking(void);
extern erl_mutex_t *erl_mutex_create(void);
extern int erl_mutex_free(erl_mutex_t *l, int nblock);
extern int erl_mutex_lock(erl_mutex_t *l, int nblock);
extern int erl_mutex_unlock(erl_mutex_t *l);

#endif /* _ERL_LOCKING_H */
