### Name: print.trellis
### Title: Print Trellis Objects
### Aliases: print.trellis
### Keywords: hplot

### ** Examples

data(singer)
p11 <- histogram( ~ height | voice.part, data = singer, xlab="Height")
p12 <- densityplot( ~ height | voice.part, data = singer, xlab = "Height")
p2 <- histogram( ~ height, data = singer, xlab = "Height")
data(sunspot)
p3 <- xyplot(sunspot~1:37, aspect="xy", type = "l")
## simple positioning by split
print(p11, split=c(1,1,1,2), more=TRUE)
print(p2, split=c(1,2,1,2))

## Combining split and position:
print(p11, position = c(0,0,.75,.75), split=c(1,1,1,2), more=TRUE)
print(p12, position = c(0,0,.75,.75), split=c(1,2,1,2), more=TRUE)
print(p3, position = c(.5,.75,1,1), more=FALSE)

## Using seekViewport
data(longley)

## repeat same plot, with different polynomial fits in each panel
xyplot(Armed.Forces ~ Year, longley, index.cond = list(rep(1, 6)),
       panel = function(x, y, panel.counter, ...)
       {
           panel.xyplot(x, y, ...)
           fm <- lm(y ~ poly(x, panel.counter))
           llines(x, predict(fm))
       })

## Not run: 
##D grid::seekViewport("panel.1")
##D cat("Click somewhere inside the first panel:\n")
##D ltext(grid::grid.locator(), lab = "linear")
## End(Not run)

grid::seekViewport("panel.1")
grid::grid.text("linear")

grid::seekViewport("panel.2")
grid::grid.text("quadratic")

grid::seekViewport("panel.3")
grid::grid.text("cubic")

grid::seekViewport("panel.4")
grid::grid.text("degree 4")

grid::seekViewport("panel.5")
grid::grid.text("degree 5")

grid::seekViewport("panel.6")
grid::grid.text("degree 6")



