### Name: order
### Title: Ordering Permutation
### Aliases: order sort.list
### Keywords: univar manip

### ** Examples

(ii <- order(x <- c(1,1,3:1,1:4,3), y <- c(9,9:1), z <-c(2,1:9)))
## 6  5  2  1  7  4 10  8  3  9
rbind(x,y,z)[,ii] # shows the reordering (ties via 2nd & 3rd arg)

## Suppose we wanted descending order on y. A simple solution is
rbind(x,y,z)[, order(x, -y, z)]
## For character vectors we can make use of rank:
cy <- as.character(y)
rbind(x,y,z)[, order(x, -rank(y), z)]

## rearrange matched vectors so that the first is in ascending order
x <- c(5:1, 6:8, 12:9)
y <- (x - 5)^2
o <- order(x)
rbind(x[o], y[o])

## tests of na.last
a <- c(4, 3, 2, NA, 1)
b <- c(4, NA, 2, 7, 1)
z <- cbind(a, b)
(o <- order(a, b)); z[o, ]
(o <- order(a, b, na.last = FALSE)); z[o, ]
(o <- order(a, b, na.last = NA)); z[o, ]

## Not run: 
##D ##  speed examples for long vectors: timings are immediately after gc()
##D x <- factor(sample(letters, 1e6, replace=TRUE))
##D system.time(o <- sort.list(x)) ## 4 secs
##D stopifnot(!is.unsorted(x[o]))
##D system.time(o <- sort.list(x, method="quick", na.last=NA)) # 0.4 sec
##D stopifnot(!is.unsorted(x[o]))
##D system.time(o <- sort.list(x, method="radix")) # 0.04 sec
##D stopifnot(!is.unsorted(x[o]))
##D xx <- sample(1:26, 1e7, replace=TRUE)
##D system.time(o <- sort.list(xx, method="radix")) # 0.4 sec
##D xx <- sample(1:100000, 1e7, replace=TRUE)
##D system.time(o <- sort.list(xx, method="radix")) # 4 sec
## End(Not run)


