
;;; record types

(define-record-type sql-date :sql-date
  (make-sql-date year month day)
  sql-date?
  (year sql-date-year sql-date-year!)
  (month sql-date-month sql-date-month!)
  (day sql-date-day sql-date-day!))

(define-exported-binding "sql-date-record-type" :sql-date)

(define-record-type sql-time :sql-time
  (make-sql-time hour minute second)
  sql-time?
  (hour sql-time-hour sql-time-hour!)
  (minute sql-time-minute sql-time-minute!)
  (second sql-time-second sql-time-second!))

(define-exported-binding "sql-time-record-type" :sql-time)

(define-record-type sql-timestamp :sql-timestamp
  (make-sql-timestamp year month day hour minute second fraction)
  sql-timestamp?
  (year sql-timestamp-year sql-timestamp-year!)
  (month sql-timestamp-month sql-timestamp-month!)
  (day sql-timestamp-day sql-timestamp-day!)
  (hour sql-timestamp-hour sql-timestamp-hour!)
  (minute sql-timestamp-minute sql-timestamp-minute!)
  (second sql-timestamp-second sql-timestamp-second!)
  (fraction sql-timestamp-fraction sql-timestamp-fraction!))

(define-exported-binding "sql-timestamp-record-type" :sql-timestamp)

(define-record-type sql-numeric :sql-numeric
  (make-sql-numeric precision scale sign value)
  sql-numeric?
  (precision sql-precision sql-precision!)
  (scale sql-scale sql-scale!)
  (sign sql-sign sql-sign!)
  (value sql-value sql-value!))

;;; handle type identifiers from sql.h
(define handle-type-env  1)
(define handle-type-dbc  2)
(define handle-type-stmt 3)
(define handle-type-desc 4)

;;; options for SQLFreeStmt from sql.h
(define sql-disconnect-opt-close 0)
(define sql-disconnect-opt-drop 1)
(define sql-disconnect-opt-unbind 2)
(define sql-disconnect-opt-reset-params 3)

;;; options for SQLDataSource from sql.h
(define sql-datasources-fetch-next  1)
(define sql-datasources-fetch-first 2)

;;; C type identifier

(define sql-type-c-char 1)
(define sql-type-c-long 4)
(define sql-type-c-short 5)
(define sql-type-c-float 7)
(define sql-type-c-double 8)
(define sql-type-c-numeric 2)
(define sql-type-c-default 99)
(define sql-type-c-date 9)
(define sql-type-c-time 10)
(define sql-type-c-timestamp 11)
(define sql-type-c-binary -2)
(define sql-type-c-bit -7)

;;; ODBC type identifier

(define sql-type-unknown 0)
(define sql-type-char 1)
(define sql-type-numeric 2)
(define sql-type-decimal 3)
(define sql-type-integer 4)
(define sql-type-smallint 5)
(define sql-type-float 6)
(define sql-type-real 7)
(define sql-type-double 8)
(define sql-type-datetime 9)
(define sql-type-varchar 12)
(define sql-type-date 91)
(define sql-type-time 92)
(define sql-type-timestamp 93)

;;;; just for testing purposes, will disappear soon
;(define open-db
;  (lambda (server user auth)
;	 (let* ((env-handle  (odbc-alloc-environment-handle))
;			  (conn-handle (odbc-alloc-connection-handle env-handle)))
;		(odbc-sql-connect conn-handle server user auth))))

;(define list-datasources
;  (lambda ()
;	 (let ((env-handle (odbc-alloc-environment-handle)))
;		(odbc-sql-data-sources env-handle sql-datasources-fetch-first))))

;(define list-drivers
;  (lambda ()
;	 (let ((env-handle (odbc-alloc-environment-handle)))
;		(odbc-sql-drivers env-handle))))

;(define free-handle
;  (lambda (handle handle-type)
;	 (odbc-sql-free-handle handle-type handle)))

;(define free-environment-handle
;  (lambda (handle)
;	 (free-handle handle handle-type-env)))

;(define free-connection-handle
;  (lambda (handle)
;	 (free-handle handle handle-type-dbc)))

;(define free-statement-handle
;  (lambda (handle)
;	 (free-handle handle handle-type-stmt)))

;(define free-description-handle
;  (lambda (handle)
;	 (free-handle handle handle-type-desc)))

;;; PART 1

(import-lambda-definition odbc-alloc-environment-handle
								  ()
								  "odbc_alloc_environment_handle")

(import-lambda-definition odbc-alloc-connection-handle
								  (env-handle)
								  "odbc_alloc_connection_handle")

(import-lambda-definition odbc-alloc-statement-handle
								  (db-handle)
								  "odbc_alloc_statement_handle")

(import-lambda-definition odbc-sql-connect
								  (conn-handle server-name user-name auth)
								  "odbc_sql_connect")

;;; PART 2

(import-lambda-definition odbc-sql-data-sources
								  (env-handle direction)
								  "odbc_sql_data_sources")

(import-lambda-definition odbc-sql-drivers
								  (env-handle)
								  "odbc_sql_drivers")

(import-lambda-definition odbc-sql-get-info-int
								  (conn-handle info-key)
								  "odbc_sql_get_info_int")

(import-lambda-definition odbc-sql-get-info-string
								  (conn-handle info-key)
								  "odbc_sql_get_info_string")

(import-lambda-definition odbc-sql-get-func-exists
								  (conn-handle fun-id)
								  "odbc_sql_get_func_exists")

(import-lambda-definition odbc-sql-get-type-info
								  (stmt-handle data-type)
								  "odbc_sql_get_type_info")

;;; PART 3

(import-lambda-definition odbc-sql-set-connect-attr-int
								  (conn-handle attribute value)
								  "odbc_sql_set_connect_attr_int")

(import-lambda-definition odbc-sql-set-connect-attr-string
								  (conn-handle attribute value)
								  "odbc_sql_set_connect_attr_string")

(import-lambda-definition odbc-sql-get-connect-attr-string
								  (conn-handle attribute)
								  "odbc_sql_get_connect_attr_string")

(import-lambda-definition odbc-sql-get-connect-attr-int
								  (conn-handle attribute)
								  "odbc_sql_get_connect_attr_int")

(import-lambda-definition odbc-sql-set-env-attr-int
								  (env-handle attribute value)
								  "odbc_sql_set_env_attr_int")

(import-lambda-definition odbc-sql-get-env-attr-int
								  (env-handle attribute value)
								  "odbc_sql_get_env_attr_int")

(import-lambda-definition odbc-sql-set-stmt-attr-int
								  (stmt-handle attribute value)
								  "odbc_sql_set_stmt_attr_int")

(import-lambda-definition odbc-sql-set-stmt-attr-string
								  (stmt-handle attribute value)
								  "odbc_sql_set_stmt_attr_string")

(import-lambda-definition odbc-sql-get-stmt-attr-int
								  (stmt-handle attribute)
								  "odbc_sql_get_stmt_attr_int")

(import-lambda-definition odbc-sql-get-stmt-attr-string
								  (stmt-handle attribute)
								  "odbc_sql_get_stmt_attr_string")

;;; PART 4

;;; PART 5

(import-lambda-definition odbc-sql-prepare
								  (stmt-handle stmt-txt)
								  "odbc_sql_prepare")

(import-lambda-definition odbc-sql-bind-parameter-exec-out
								  (stmt-handle param-vals)
								  "odbc_sql_bind_parameter_exec_out")

;;; PART 6
(import-lambda-definition odbc-sql-execute
								  (stmt-handle)
								  "odbc_sql_execute")

(import-lambda-definition odbc-sql-execute-direct
								  (stmt-handle stmt-txt)
								  "odbc_sql_execute_direct")


;;; PART 7
(import-lambda-definition odbc-sql-get-data
								  (stmt-handle column-number target-type)
								  "odbc_sql_get_data")

(import-lambda-definition odbc-sql-fetch
								  (stmt-handle)
								  "odbc_sql_fetch")

;;; PART 8

;;; PART 9

(import-lambda-definition odbc-sql-free-statement
								  (stmt-handle option)
								  "odbc_sql_free_statement")

(import-lambda-definition odbc-sql-close-cursor
								  (stmt-handle)
								  "odbc_sql_close_cursor")

(import-lambda-definition odbc-sql-cancel
								  (stmt-handle)
								  "odbc_sql_cancel")

;;; PART 10

(import-lambda-definition odbc-sql-disconnect
								  (conn-handle)
								  "odbc_sql_disconnect")

(import-lambda-definition odbc-sql-free-handle
								  (handle-type handle)
								  "odbc_sql_free_handle")
