/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFNumber;
import java.io.IOException;
import java.io.Writer;

public class PDFReal
extends PDFNumber {
    float val;
    byte fractdigits;
    public static final float PDF_SMALLEST = 0.0f;
    public static final float PDF_SMALLEST_2 = 0.0f;
    static final float LOG10 = (float)Math.log(10.0);
    private double[] pow10table = new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10};
    private String nulls = "0000000000";

    public PDFReal(double init) {
        this((float)init);
    }

    public PDFReal(float init) {
        if (Math.abs(init) < 0.0f) {
            this.val = init;
            this.fractdigits = 0;
            return;
        }
        this.val = Math.abs(init) < 0.0f ? (init > 0.0f ? 0.0f : -0.0f) : init;
        this.fractdigits = (float)((int)init) == init ? (byte)0 : (byte)Math.max(0, 6 - (byte)Math.floor(Math.log(Math.abs(this.val)) / (double)LOG10));
    }

    public PDFReal(int init) {
        this.val = init;
        this.fractdigits = 0;
    }

    public PDFReal(String init) {
        this.val = Float.parseFloat(init);
        int i = init.indexOf(46) + 1;
        this.fractdigits = i > 0 ? (byte)Math.min(init.length() - i, this.pow10table.length) : (byte)0;
    }

    public boolean equals(Object obj) {
        return obj instanceof PDFReal && this.val == ((PDFReal)obj).val;
    }

    public boolean equiv(Object obj) {
        return obj instanceof PDFReal && (double)Math.abs(this.val - ((PDFReal)obj).val) < 1.0E-5;
    }

    public float floatValue() {
        return this.val;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.val);
    }

    public String toString() {
        long lval = (long)this.val;
        String s = Long.toString(lval);
        String frac = "";
        if (this.fractdigits > 0) {
            double dval;
            int numdigits = this.fractdigits > 10 ? 10 : (int)this.fractdigits;
            StringBuffer sb = new StringBuffer(s);
            if (this.val < 0.0f) {
                dval = (double)lval - (double)this.val;
                if (lval == 0L) {
                    sb.insert(0, '-');
                }
            } else {
                dval = (double)this.val - (double)lval;
            }
            dval = dval * this.pow10table[numdigits - 1] + 0.5;
            frac = Long.toString((long)dval);
            sb.append('.');
            if (numdigits > frac.length()) {
                sb.append(this.nulls.substring(10 - numdigits + frac.length()));
            }
            sb.append(frac);
            while (sb.charAt(sb.length() - 1) == '0') {
                sb.setLength(sb.length() - 1);
            }
            if (sb.charAt(sb.length() - 1) == '.') {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        return s;
    }

    public double value() {
        return this.val;
    }

    public void write(Writer out) throws IOException {
        out.write(this.toString());
    }
}

