/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/09 09:40:10 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgstaticframe.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.5 $
    Status:           $State: Exp $
*/

#ifndef PG_STATICFRAME_H
#define PG_STATICFRAME_H

#ifdef SWIG
%include "swigcommon.h"
%module pgstaticframe
%{
#include "pgstaticframe.h"
%}
#endif

#include "pggradientwidget.h"

/**
	@author Alexander Pipelka

	@short A static (non-resizeable) frame.

	Intended to be used as a parent for other widgets. Only handles background
	for the time being.
*/

class DECLSPEC PG_StaticFrame : public PG_GradientWidget  {
public:

	/**  */
	PG_StaticFrame(PG_Widget* parent, const PG_Rect& r, const char* style = "GradientWidget");

	/**  */
	~PG_StaticFrame();

	/**  */
	void LoadThemeStyle(const char* widgettype);

	/**  */
	void LoadThemeStyle(const char* widgettype, const char* objectname);

	/**  */
	bool LoadBackground(const char* filename);

	/**  */
	void SetBackground(SDL_Surface* image);

	void SetTransparency(Uint8 t);

	/**  */
	void FreeImage();

protected:

	/** */
	void eventSizeWindow(int w, int h);

	void eventDraw(SDL_Surface* surface, const PG_Rect& rect);

	/** */
	void eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst);

private:

	SDL_Surface* my_image;
	SDL_Surface* my_cachesurface;
	SDL_Color my_backgroundcolor;

	bool my_freeimage;
	bool my_simplebackground;
	bool my_nocache;
};

#endif // PG_STATICFRAME_H
