<?php

require_once dirname(__FILE__) . '/week.php';

/**
 * This class represent a workweek fbview of mulitple free busy information.
 *
 * Copyright 2003-2005 Mike Cochrane <mike@graftonhall.co.nz>
 * Copyright 2004-2005 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information.
 *
 * $Horde: kronolith/lib/FBView/workweek.php,v 1.7.10.1 2005/01/03 12:25:40 jan Exp $
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @author  Jan Schneider <jan@horde.org>
 * @package Kronolith
 */
class Kronolith_FreeBusy_View_workweek extends Kronolith_FreeBusy_View_week {

    var $view = 'workweek';

    var $_days = 5;

    function _getBlocks($member, $periods, $blockfile, $label)
    {
        $template = &new Horde_Template();
        $template->set('label', '');

        $count = 0;
        $blocks = '';
        foreach ($periods as $start => $end) {
            if ($start < $this->_endStamp && $end > $this->_startStamp) {

                $start_day = floor(($start - $this->_startStamp) / (24 * 3600));
                $start_hour = intval(strftime('%H', $start));
                $start_min = intval(strftime('%M', $start));

                $left  = 20 * $start_day;
                if ($start_hour >= 9 && $start_hour < 18) {
                    $left += ($start_hour - 9) * (20 / 9);
                    $left += ($start_min / 60) * (20 / 9);
                } elseif ($start_hour >= 18) {
                    $left += 20;
                }
                $left = max(0, $left);

                $end_day = floor(($end - $this->_startStamp) / (24 * 3600));
                $end_hour = intval(strftime('%H', $end));
                $end_min = intval(strftime('%M', $end));

                $right = 20 * $end_day;
                if ($end_hour >= 9 && $end_hour < 18) {
                    $right += ($end_hour - 9) * (20 / 9);
                    $right += ($end_min / 60) * (20 / 9);
                } elseif ($end_hour >= 18) {
                    $right += 20;
                }
                $right = min(100, $right);

                $template->set('left', $left);
                $template->set('width', $right - $left);
                $template->set('top', $count++ * 15);
                $template->set('label', $label);

                $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/' . $blockfile);
            }
        }

        // Indicate if we don't know the free busy info for any periods
        $start = $member->getStart();
        $end   = $member->getEnd();
        if ($start > $this->_startStamp) {
            if ($start >= $this->_endStamp) {
                $right = 100;
            } else {
                $start_day = floor(($start - $this->_startStamp) / (24 * 3600));
                $start_hour = intval(strftime('%H', $start));
                $start_min = intval(strftime('%M', $start));

                $right = 20 * $start_day;
                if ($start_hour >= 9 && $start_hour < 18) {
                    $right += ($start_hour - 9) * (20 / 9);
                    $right += ($start_min / 60) * (20 / 9);
                } elseif ($start_hour >= 18) {
                    $right += 20;
                }
            }
            $left  = 0;

            $template->set('left', $left);
            $template->set('width', min($right - $left, 100));
            $template->set('top', $count++ * 15);

            $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/unknownblock.tpl');
        } else if ($end <= $this->_endStamp) {
            if ($end <= $this->_startStamp) {
                $left = 0;
            } else {
                $end_day = floor(($end - $this->_startStamp) / (24 * 3600));
                $end_hour = intval(strftime('%H', $end));
                $end_min = intval(strftime('%M', $end));

                $left = 20 * $end_day;
                if ($end_hour >= 9 && $end_hour < 18) {
                    $left += ($end_hour - 9) * (20 / 9);
                    $left += ($end_min / 60) * (20 / 9);
                } elseif ($end_hour >= 18) {
                    $left += 20;
                }
                $left = min(100, $left);
            }
            $right  = 100;

            $template->set('left', $left);
            $template->set('width', min($right - $left, 100));
            $template->set('top', $count++ * 15);

            $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/unknownblock.tpl');
        }

        // overlay the grid
        $template->set('top', $count++ * 15);
        $columns = $this->_days * floor(($this->_endHour - $this->_startHour) / 3);
        $template->set('columns', range(1, $columns));
        $template->set('width', 100 / $columns);
        $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/linesblock.tpl');

        return $blocks;
    }

}
