/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.catalina.Deployer;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterDeployer;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.deploy.FileChangeListener;
import org.apache.catalina.cluster.deploy.FileMessage;
import org.apache.catalina.cluster.deploy.FileMessageFactory;
import org.apache.catalina.cluster.deploy.UndeployMessage;
import org.apache.catalina.cluster.deploy.WarWatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FarmWarDeployer
implements ClusterDeployer,
FileChangeListener {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$deploy$FarmWarDeployer == null ? (class$org$apache$catalina$cluster$deploy$FarmWarDeployer = FarmWarDeployer.class$("org.apache.catalina.cluster.deploy.FarmWarDeployer")) : class$org$apache$catalina$cluster$deploy$FarmWarDeployer));
    protected CatalinaCluster cluster = null;
    protected Deployer deployer = null;
    protected boolean started = false;
    protected HashMap fileFactories = new HashMap();
    protected String deployDir;
    protected String tempDir;
    protected String watchDir;
    protected boolean watchEnabled = false;
    protected WarWatcher watcher = null;
    static /* synthetic */ Class class$org$apache$catalina$cluster$deploy$FarmWarDeployer;

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.getCluster().addClusterListener(this);
        if (this.watchEnabled) {
            this.watcher = new WarWatcher(this, new File(this.getWatchDir()), 5000L);
            Thread t = new Thread(this.watcher);
            t.start();
            log.info((Object)("Cluster deployment is watching " + this.getWatchDir() + " for changes."));
        }
        this.started = true;
        log.info((Object)"Cluster FarmWarDeployer started.");
    }

    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        if (this.watcher != null) {
            this.watcher.stop();
        }
        log.info((Object)"Cluster FarmWarDeployer stopped.");
    }

    public void cleanDeployDir() {
        throw new UnsupportedOperationException("Method cleanDeployDir() not yet implemented.");
    }

    public void messageReceived(ClusterMessage msg) {
        block9: {
            try {
                if (msg instanceof FileMessage && msg != null) {
                    FileMessage fmsg = (FileMessage)msg;
                    FileMessageFactory factory = this.getFactory(fmsg);
                    if (!factory.writeMessage(fmsg)) break block9;
                    String name = factory.getFile().getName();
                    if (!name.endsWith(".war")) {
                        name = name + ".war";
                    }
                    File deployable = new File(this.getDeployDir(), name);
                    factory.getFile().renameTo(deployable);
                    try {
                        if (this.getDeployer().findDeployedApp(fmsg.getContextPath()) != null) {
                            this.getDeployer().remove(fmsg.getContextPath(), true);
                        }
                    }
                    catch (Exception x) {
                        log.info((Object)"Error removing existing context before installing a new one.", (Throwable)x);
                    }
                    this.getDeployer().install(fmsg.getContextPath(), deployable.toURL());
                    this.removeFactory(fmsg);
                    break block9;
                }
                if (msg instanceof UndeployMessage && msg != null) {
                    UndeployMessage umsg = (UndeployMessage)msg;
                    if (this.getDeployer().findDeployedApp(umsg.getContextPath()) != null) {
                        this.getDeployer().remove(umsg.getContextPath(), umsg.getUndeploy());
                    }
                }
            }
            catch (IOException x) {
                log.error((Object)"Unable to read farm deploy file message.", (Throwable)x);
            }
        }
    }

    public synchronized FileMessageFactory getFactory(FileMessage msg) throws FileNotFoundException, IOException {
        File tmpFile = new File(msg.getFileName());
        File writeToFile = new File(this.getTempDir(), tmpFile.getName());
        FileMessageFactory factory = (FileMessageFactory)this.fileFactories.get(msg.getFileName());
        if (factory == null) {
            factory = FileMessageFactory.getInstance(writeToFile, true);
            this.fileFactories.put(msg.getFileName(), factory);
        }
        return factory;
    }

    public void removeFactory(FileMessage msg) {
        this.fileFactories.remove(msg.getFileName());
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof FileMessage || msg instanceof UndeployMessage;
    }

    public void install(String contextPath, URL war) throws IOException {
        if (this.getDeployer().findDeployedApp(contextPath) != null) {
            this.getDeployer().remove(contextPath, true);
        }
        this.getDeployer().install(contextPath, war);
        Member[] members = this.getCluster().getMembers();
        Member localMember = this.getCluster().getLocalMember();
        FileMessageFactory factory = FileMessageFactory.getInstance(new File(war.getFile()), false);
        FileMessage msg = new FileMessage(localMember, war.getFile(), contextPath);
        msg = factory.readMessage(msg);
        while (msg != null) {
            for (int i = 0; i < members.length; ++i) {
                this.getCluster().send(msg, members[i]);
            }
            msg = factory.readMessage(msg);
        }
    }

    public void remove(String contextPath, boolean undeploy) throws IOException {
        log.info((Object)("Cluster wide remove of web app " + contextPath));
        if (this.getDeployer().findDeployedApp(contextPath) != null) {
            this.getDeployer().remove(contextPath, undeploy);
        }
        Member[] members = this.getCluster().getMembers();
        Member localMember = this.getCluster().getLocalMember();
        UndeployMessage msg = new UndeployMessage(localMember, System.currentTimeMillis(), "Undeploy:" + contextPath + ":" + System.currentTimeMillis(), contextPath, undeploy);
        this.cluster.send(msg);
    }

    public void fileModified(File newWar) {
        try {
            File deployWar = new File(this.getDeployDir(), newWar.getName());
            this.copy(newWar, deployWar);
            String contextName = "/" + deployWar.getName().substring(0, deployWar.getName().lastIndexOf(".war"));
            log.info((Object)("Installing webapp[" + contextName + "] from " + deployWar.getAbsolutePath()));
            try {
                this.remove(contextName, true);
            }
            catch (Exception x) {
                log.error((Object)"No removal", (Throwable)x);
            }
            this.install(contextName, deployWar.toURL());
        }
        catch (Exception x) {
            log.error((Object)"Unable to install WAR file", (Throwable)x);
        }
    }

    public void fileRemoved(File removeWar) {
        try {
            String contextName = "/" + removeWar.getName().substring(0, removeWar.getName().lastIndexOf(".war"));
            log.info((Object)("Removing webapp[" + contextName + "]"));
            this.remove(contextName, true);
        }
        catch (Exception x) {
            log.error((Object)"Unable to remove WAR file", (Throwable)x);
        }
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public boolean equals(Object listener) {
        return super.equals(listener);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public String getWatchDir() {
        return this.watchDir;
    }

    public void setWatchDir(String watchDir) {
        this.watchDir = watchDir;
    }

    public boolean isWatchEnabled() {
        return this.watchEnabled;
    }

    public boolean getWatchEnabled() {
        return this.watchEnabled;
    }

    public void setWatchEnabled(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
    }

    private boolean copy(File from, File to) {
        try {
            int len;
            if (!to.exists()) {
                to.createNewFile();
            }
            FileInputStream is = new FileInputStream(from);
            FileOutputStream os = new FileOutputStream(to, false);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            log.error((Object)("Unable to copy file from:" + from + " to:" + to), (Throwable)e);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

