/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Obstacle;
import org.eclipse.draw2d.graph.Segment;
import org.eclipse.draw2d.graph.Vertex;

public class Path {
    private static final Point CURRENT = new Point();
    private static final double EPSILON = 1.04;
    private static final Point NEXT = new Point();
    private static final double OVAL_CONSTANT = 1.13;
    public Object data;
    List grownSegments;
    List segments = new ArrayList();
    List excludedObstacles;
    public boolean isDirty = true;
    boolean isInverted = false;
    boolean isMarked = false;
    PointList points;
    PointList bendpoints;
    private double prevCostRatio;
    private SegmentStack stack;
    Vertex start;
    Vertex end;
    private Path subPath;
    double threshold;
    Set visibleObstacles;
    Set visibleVertices;

    public Path() {
        this.grownSegments = new ArrayList();
        this.points = new PointList();
        this.visibleVertices = new HashSet();
        this.stack = new SegmentStack();
        this.visibleObstacles = new HashSet();
        this.excludedObstacles = new ArrayList();
    }

    public Path(Object data) {
        this();
        this.data = data;
    }

    public Path(Point start, Point end) {
        this(new Vertex(start, null), new Vertex(end, null));
    }

    Path(Vertex start, Vertex end) {
        this();
        this.start = start;
        this.end = end;
    }

    private void addAllSegmentsBetween(Obstacle source, Obstacle target) {
        this.addConnectingSegment(new Segment(source.bottomLeft, target.bottomLeft), source, target, false, false);
        this.addConnectingSegment(new Segment(source.bottomRight, target.bottomRight), source, target, true, true);
        this.addConnectingSegment(new Segment(source.topLeft, target.topLeft), source, target, true, true);
        this.addConnectingSegment(new Segment(source.topRight, target.topRight), source, target, false, false);
        if (source.bottom() == target.bottom()) {
            this.addConnectingSegment(new Segment(source.bottomLeft, target.bottomRight), source, target, false, true);
            this.addConnectingSegment(new Segment(source.bottomRight, target.bottomLeft), source, target, true, false);
        }
        if (source.y == target.y) {
            this.addConnectingSegment(new Segment(source.topLeft, target.topRight), source, target, true, false);
            this.addConnectingSegment(new Segment(source.topRight, target.topLeft), source, target, false, true);
        }
        if (source.x == target.x) {
            this.addConnectingSegment(new Segment(source.bottomLeft, target.topLeft), source, target, false, true);
            this.addConnectingSegment(new Segment(source.topLeft, target.bottomLeft), source, target, true, false);
        }
        if (source.right() == target.right()) {
            this.addConnectingSegment(new Segment(source.bottomRight, target.topRight), source, target, true, false);
            this.addConnectingSegment(new Segment(source.topRight, target.bottomRight), source, target, false, true);
        }
    }

    private void addConnectingSegment(Segment segment, Obstacle o1, Obstacle o2, boolean checkTopRight1, boolean checkTopRight2) {
        if (this.threshold != 0.0 && (segment.end.getDistance(this.end) + segment.end.getDistance(this.start) > this.threshold || segment.start.getDistance(this.end) + segment.start.getDistance(this.start) > this.threshold)) {
            return;
        }
        if (o2.containsProper(segment.start) || o1.containsProper(segment.end)) {
            return;
        }
        if (checkTopRight1 && segment.intersects(o1.x, o1.bottom() - 1, o1.right() - 1, o1.y)) {
            return;
        }
        if (checkTopRight2 && segment.intersects(o2.x, o2.bottom() - 1, o2.right() - 1, o2.y)) {
            return;
        }
        if (!checkTopRight1 && segment.intersects(o1.x, o1.y, o1.right() - 1, o1.bottom() - 1)) {
            return;
        }
        if (!checkTopRight2 && segment.intersects(o2.x, o2.y, o2.right() - 1, o2.bottom() - 1)) {
            return;
        }
        this.stack.push(o1);
        this.stack.push(o2);
        this.stack.push(segment);
    }

    private void addObstacle(Obstacle newObs) {
        this.visibleObstacles.add(newObs);
        Iterator oItr = new HashSet(this.visibleObstacles).iterator();
        while (oItr.hasNext()) {
            Obstacle currObs = (Obstacle)oItr.next();
            if (newObs == currObs) continue;
            this.addSegmentsFor(newObs, currObs);
        }
        this.addPerimiterSegments(newObs);
        this.addSegmentsFor(this.start, newObs);
        this.addSegmentsFor(this.end, newObs);
    }

    private void addPerimiterSegments(Obstacle obs) {
        Segment seg = new Segment(obs.topLeft, obs.topRight);
        this.stack.push(obs);
        this.stack.push(null);
        this.stack.push(seg);
        seg = new Segment(obs.topRight, obs.bottomRight);
        this.stack.push(obs);
        this.stack.push(null);
        this.stack.push(seg);
        seg = new Segment(obs.bottomRight, obs.bottomLeft);
        this.stack.push(obs);
        this.stack.push(null);
        this.stack.push(seg);
        seg = new Segment(obs.bottomLeft, obs.topLeft);
        this.stack.push(obs);
        this.stack.push(null);
        this.stack.push(seg);
    }

    private void addSegment(Segment segment, Obstacle exclude1, Obstacle exclude2, List allObstacles) {
        if (this.threshold != 0.0 && (segment.end.getDistance(this.end) + segment.end.getDistance(this.start) > this.threshold || segment.start.getDistance(this.end) + segment.start.getDistance(this.start) > this.threshold)) {
            return;
        }
        int i = 0;
        while (i < allObstacles.size()) {
            Obstacle obs = (Obstacle)allObstacles.get(i);
            if (obs != exclude1 && obs != exclude2 && !obs.exclude && (segment.intersects(obs.x, obs.y, obs.right() - 1, obs.bottom() - 1) || segment.intersects(obs.x, obs.bottom() - 1, obs.right() - 1, obs.y) || obs.containsProper(segment.start) || obs.containsProper(segment.end))) {
                if (!this.visibleObstacles.contains(obs)) {
                    this.addObstacle(obs);
                }
                return;
            }
            ++i;
        }
        this.linkVertices(segment);
    }

    private void addSegmentsFor(Obstacle source, Obstacle target) {
        if (source.intersects(target)) {
            this.addAllSegmentsBetween(source, target);
        } else if (target.bottom() - 1 < source.y) {
            this.addSegmentsTargetAboveSource(source, target);
        } else if (source.bottom() - 1 < target.y) {
            this.addSegmentsTargetAboveSource(target, source);
        } else if (target.right() - 1 < source.x) {
            this.addSegmentsTargetBesideSource(source, target);
        } else {
            this.addSegmentsTargetBesideSource(target, source);
        }
    }

    private void addSegmentsFor(Vertex vertex, Obstacle obs) {
        Segment seg = null;
        Segment seg2 = null;
        switch (obs.getPosition(vertex)) {
            case 12: 
            case 17: {
                seg = new Segment(vertex, obs.topLeft);
                seg2 = new Segment(vertex, obs.bottomRight);
                break;
            }
            case 9: 
            case 20: {
                seg = new Segment(vertex, obs.topRight);
                seg2 = new Segment(vertex, obs.bottomLeft);
                break;
            }
            case 1: {
                seg = new Segment(vertex, obs.topLeft);
                seg2 = new Segment(vertex, obs.topRight);
                break;
            }
            case 16: {
                seg = new Segment(vertex, obs.bottomRight);
                seg2 = new Segment(vertex, obs.topRight);
                break;
            }
            case 4: {
                seg = new Segment(vertex, obs.bottomRight);
                seg2 = new Segment(vertex, obs.bottomLeft);
                break;
            }
            case 8: {
                seg = new Segment(vertex, obs.topLeft);
                seg2 = new Segment(vertex, obs.bottomLeft);
                break;
            }
            default: {
                if (vertex.x == obs.x) {
                    seg = new Segment(vertex, obs.topLeft);
                    seg2 = new Segment(vertex, obs.bottomLeft);
                    break;
                }
                if (vertex.y == obs.y) {
                    seg = new Segment(vertex, obs.topLeft);
                    seg2 = new Segment(vertex, obs.topRight);
                    break;
                }
                if (vertex.y == obs.bottom() - 1) {
                    seg = new Segment(vertex, obs.bottomLeft);
                    seg2 = new Segment(vertex, obs.bottomRight);
                    break;
                }
                if (vertex.x == obs.right() - 1) {
                    seg = new Segment(vertex, obs.topRight);
                    seg2 = new Segment(vertex, obs.bottomRight);
                    break;
                }
                throw new RuntimeException("Unexpected vertex conditions");
            }
        }
        this.stack.push(obs);
        this.stack.push(null);
        this.stack.push(seg);
        this.stack.push(obs);
        this.stack.push(null);
        this.stack.push(seg2);
    }

    private void addSegmentsTargetAboveSource(Obstacle source, Obstacle target) {
        Segment seg = null;
        Segment seg2 = null;
        if (target.x > source.x) {
            seg = new Segment(source.topLeft, target.topLeft);
            seg2 = target.x < source.right() - 1 ? new Segment(source.topRight, target.bottomLeft) : new Segment(source.bottomRight, target.topLeft);
        } else if (source.x == target.x) {
            seg = new Segment(source.topLeft, target.bottomLeft);
            seg2 = new Segment(source.topRight, target.bottomLeft);
        } else {
            seg = new Segment(source.bottomLeft, target.bottomLeft);
            seg2 = new Segment(source.topRight, target.bottomLeft);
        }
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg);
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg2);
        seg = null;
        seg2 = null;
        if (target.right() < source.right()) {
            seg = new Segment(source.topRight, target.topRight);
            seg2 = target.right() - 1 > source.x ? new Segment(source.topLeft, target.bottomRight) : new Segment(source.bottomLeft, target.topRight);
        } else if (source.right() == target.right()) {
            seg = new Segment(source.topRight, target.bottomRight);
            seg2 = new Segment(source.topLeft, target.bottomRight);
        } else {
            seg = new Segment(source.bottomRight, target.bottomRight);
            seg2 = new Segment(source.topLeft, target.bottomRight);
        }
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg);
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg2);
    }

    private void addSegmentsTargetBesideSource(Obstacle source, Obstacle target) {
        Segment seg = null;
        Segment seg2 = null;
        if (target.y > source.y) {
            seg = new Segment(source.topLeft, target.topLeft);
            seg2 = target.y < source.bottom() - 1 ? new Segment(source.bottomLeft, target.topRight) : new Segment(source.bottomRight, target.topLeft);
        } else if (source.y == target.y) {
            seg = new Segment(source.topLeft, target.topRight);
            seg2 = new Segment(source.bottomLeft, target.topRight);
        } else {
            seg = new Segment(source.topRight, target.topRight);
            seg2 = new Segment(source.bottomLeft, target.topRight);
        }
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg);
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg2);
        seg = null;
        seg2 = null;
        if (target.bottom() < source.bottom()) {
            seg = new Segment(source.bottomLeft, target.bottomLeft);
            seg2 = target.bottom() - 1 > source.y ? new Segment(source.topLeft, target.bottomRight) : new Segment(source.topRight, target.bottomLeft);
        } else if (source.bottom() == target.bottom()) {
            seg = new Segment(source.bottomLeft, target.bottomRight);
            seg2 = new Segment(source.topLeft, target.bottomRight);
        } else {
            seg = new Segment(source.bottomRight, target.bottomRight);
            seg2 = new Segment(source.topLeft, target.bottomRight);
        }
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg);
        this.stack.push(source);
        this.stack.push(target);
        this.stack.push(seg2);
    }

    void cleanup() {
        this.visibleVertices.clear();
    }

    private void createVisibilityGraph(List allObstacles) {
        this.stack.push(null);
        this.stack.push(null);
        this.stack.push(new Segment(this.start, this.end));
        while (!this.stack.isEmpty()) {
            this.addSegment(this.stack.pop(), this.stack.popObstacle(), this.stack.popObstacle(), allObstacles);
        }
    }

    private boolean determineShortestPath() {
        if (!this.labelGraph()) {
            return false;
        }
        Vertex vertex = this.end;
        this.prevCostRatio = this.end.cost / this.start.getDistance(this.end);
        while (!vertex.equals(this.start)) {
            Vertex nextVertex = vertex.label;
            if (nextVertex == null) {
                return false;
            }
            Segment s = new Segment(nextVertex, vertex);
            this.segments.add(s);
            vertex = nextVertex;
        }
        Collections.reverse(this.segments);
        return true;
    }

    void fullReset() {
        this.visibleVertices.clear();
        this.segments.clear();
        if (this.prevCostRatio == 0.0) {
            double distance = this.start.getDistance(this.end);
            this.threshold = distance * 1.13;
        } else {
            this.threshold = this.prevCostRatio * 1.04 * this.start.getDistance(this.end);
        }
        this.visibleObstacles.clear();
        this.resetPartial();
    }

    boolean generateShortestPath(List allObstacles) {
        this.createVisibilityGraph(allObstacles);
        if (this.visibleVertices.size() == 0) {
            return false;
        }
        return this.determineShortestPath();
    }

    public PointList getBendPoints() {
        return this.bendpoints;
    }

    public Point getEndPoint() {
        return this.end;
    }

    public PointList getPoints() {
        return this.points;
    }

    public Point getStartPoint() {
        return this.start;
    }

    Path getSubPath(Segment currentSegment) {
        Path newPath = new Path(currentSegment.start, this.end);
        newPath.grownSegments = new ArrayList(this.grownSegments.subList(this.grownSegments.indexOf(currentSegment), this.grownSegments.size()));
        this.grownSegments = new ArrayList(this.grownSegments.subList(0, this.grownSegments.indexOf(currentSegment) + 1));
        this.end = currentSegment.end;
        this.subPath = newPath;
        return newPath;
    }

    boolean isObstacleVisible(Obstacle obs) {
        return this.visibleObstacles.contains(obs);
    }

    private boolean labelGraph() {
        int numPermanentNodes = 1;
        Vertex vertex = this.start;
        Vertex neighborVertex = null;
        vertex.isPermanent = true;
        while (numPermanentNodes != this.visibleVertices.size()) {
            List neighbors = vertex.neighbors;
            if (neighbors == null) {
                return false;
            }
            int i = 0;
            while (i < neighbors.size()) {
                neighborVertex = (Vertex)neighbors.get(i);
                if (!neighborVertex.isPermanent) {
                    double newCost = vertex.cost + vertex.getDistance(neighborVertex);
                    if (neighborVertex.label == null) {
                        neighborVertex.label = vertex;
                        neighborVertex.cost = newCost;
                    } else if (neighborVertex.cost > newCost) {
                        neighborVertex.label = vertex;
                        neighborVertex.cost = newCost;
                    }
                }
                ++i;
            }
            double smallestCost = 0.0;
            Vertex tempVertex = null;
            Iterator v = this.visibleVertices.iterator();
            while (v.hasNext()) {
                tempVertex = (Vertex)v.next();
                if (tempVertex.isPermanent || tempVertex.label == null || !(tempVertex.cost < smallestCost) && smallestCost != 0.0) continue;
                smallestCost = tempVertex.cost;
                vertex = tempVertex;
            }
            vertex.isPermanent = true;
            ++numPermanentNodes;
        }
        return true;
    }

    private void linkVertices(Segment segment) {
        if (segment.start.neighbors == null) {
            segment.start.neighbors = new ArrayList();
        }
        if (segment.end.neighbors == null) {
            segment.end.neighbors = new ArrayList();
        }
        if (!segment.start.neighbors.contains(segment.end)) {
            segment.start.neighbors.add(segment.end);
            segment.end.neighbors.add(segment.start);
        }
        this.visibleVertices.add(segment.start);
        this.visibleVertices.add(segment.end);
    }

    void reconnectSubPaths() {
        if (this.subPath != null) {
            this.subPath.reconnectSubPaths();
            Segment changedSegment = (Segment)this.subPath.grownSegments.remove(0);
            Segment oldSegment = (Segment)this.grownSegments.get(this.grownSegments.size() - 1);
            oldSegment.end = changedSegment.end;
            this.grownSegments.addAll(this.subPath.grownSegments);
            this.subPath.points.removePoint(0);
            this.points.removePoint(this.points.size() - 1);
            this.points.addAll(this.subPath.points);
            this.visibleObstacles.addAll(this.subPath.visibleObstacles);
            this.end = this.subPath.end;
            this.subPath = null;
        }
    }

    void refreshExcludedObstacles(List allObstacles) {
        this.excludedObstacles.clear();
        int i = 0;
        while (i < allObstacles.size()) {
            Obstacle o = (Obstacle)allObstacles.get(i);
            o.exclude = false;
            if (o.contains(this.start) && o.containsProper(this.start)) {
                o.exclude = true;
            }
            if (o.contains(this.end) && o.containsProper(this.end)) {
                o.exclude = true;
            }
            if (o.exclude && !this.excludedObstacles.contains(o)) {
                this.excludedObstacles.add(o);
            }
            ++i;
        }
    }

    void resetPartial() {
        this.isMarked = false;
        this.isInverted = false;
        this.subPath = null;
        this.isDirty = false;
        this.grownSegments.clear();
        this.points.removeAllPoints();
    }

    void invertPriorVertices(Segment currentSegment) {
        int stop = this.grownSegments.indexOf(currentSegment);
        int i = 0;
        while (i < stop) {
            Vertex vertex = ((Segment)this.grownSegments.get((int)i)).end;
            vertex.type = vertex.type == 1 ? 2 : 1;
            ++i;
        }
    }

    public void setBendPoints(PointList bendPoints) {
        this.bendpoints = bendPoints;
        this.isDirty = true;
    }

    public void setEndPoint(Point end) {
        if (end.equals(this.end)) {
            return;
        }
        this.end = new Vertex(end, null);
        this.isDirty = true;
    }

    public void setStartPoint(Point start) {
        if (start.equals(this.start)) {
            return;
        }
        this.start = new Vertex(start, null);
        this.isDirty = true;
    }

    boolean testAndSet(Obstacle obs) {
        if (this.isDirty) {
            return false;
        }
        if (this.excludedObstacles.contains(obs)) {
            return false;
        }
        Segment seg1 = new Segment(obs.topLeft, obs.bottomRight);
        Segment seg2 = new Segment(obs.topRight, obs.bottomLeft);
        int s = 0;
        while (s < this.points.size() - 1) {
            this.points.getPoint(CURRENT, s);
            this.points.getPoint(NEXT, s + 1);
            if (seg1.intersects(CURRENT, NEXT) || seg2.intersects(CURRENT, NEXT) || obs.contains(CURRENT) || obs.contains(NEXT)) {
                this.isDirty = true;
                return true;
            }
            ++s;
        }
        return false;
    }

    private static class SegmentStack
    extends ArrayList {
        SegmentStack() {
        }

        Segment pop() {
            return (Segment)this.remove(this.size() - 1);
        }

        Obstacle popObstacle() {
            return (Obstacle)this.remove(this.size() - 1);
        }

        void push(Object obj) {
            this.add(obj);
        }
    }
}

