/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class ModelImporterPage
extends WizardPage
implements Listener {
    public static final int CAUSE_UNKNOWN = 0;
    public static final int CAUSE_BACK = 1;
    public static final int CAUSE_NEXT = 2;
    public static final int CAUSE_FINISH = 3;
    public static final int CAUSE_CANCEL = 4;
    protected ModelImporter modelImporter;
    protected boolean neverVisible = true;
    protected boolean forwardDirection = true;
    protected boolean handlingEvent = true;

    public ModelImporterPage(ModelImporter modelImporter, String pageName) {
        super(pageName);
        this.modelImporter = modelImporter;
        this.setPageComplete(false);
    }

    public void dispose() {
        this.modelImporter = null;
        super.dispose();
    }

    public ModelImporter getModelImporter() {
        return this.modelImporter;
    }

    protected void pageActivated(boolean firstTime, int cause) {
    }

    protected void pageDeactivated(int cause) {
    }

    public IWizardPage getNextPage() {
        this.forwardDirection = true;
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        this.forwardDirection = false;
        return super.getPreviousPage();
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null;
    }

    public boolean isHandlingEvent() {
        return this.handlingEvent;
    }

    public void setHandlingEvent(boolean handlingEvent) {
        this.handlingEvent = handlingEvent;
    }

    public void handleEvent(Event event) {
        if (this.isHandlingEvent()) {
            this.doHandleEvent(event);
        }
    }

    protected void doHandleEvent(Event event) {
    }

    protected void handleStatus(IStatus status) {
        this.handleStatus(status, null, null, null);
    }

    protected void handleStatus(IStatus status, String message, String dialogTitle, String dialogMessage) {
        if (status.isOK()) {
            this.handleOKStatus(status, message, dialogTitle, dialogMessage);
        } else {
            this.handleNotOKStatus(status, this.decodeAction(status), message, dialogTitle, dialogMessage);
        }
    }

    protected ImporterUtil.DecodedAction decodeAction(IStatus status) {
        int actionCode = ImporterUtil.computeActionCode(status);
        return ImporterUtil.decodeAction(actionCode);
    }

    protected void handleOKStatus(IStatus status, String message, String dialogTitle, String dialogMessage) {
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    protected void handleNotOKStatus(IStatus status, ImporterUtil.DecodedAction decodedAction, String message, String dialogTitle, String dialogMessage) {
        int messageType = 0;
        switch (status.getSeverity()) {
            case 1: {
                messageType = 1;
                if (dialogTitle != null) break;
                ImporterPlugin.INSTANCE.getString("_UI_DialogInformation_title");
                break;
            }
            case 2: {
                messageType = 2;
                if (dialogTitle != null) break;
                dialogTitle = ImporterPlugin.INSTANCE.getString("_UI_DialogWarning_title");
                break;
            }
            case 4: {
                messageType = 3;
                if (dialogTitle != null) break;
                dialogTitle = ImporterPlugin.INSTANCE.getString("_UI_DialogError_title");
            }
        }
        if (message == null) {
            message = status.getMessage();
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        switch (decodedAction.message) {
            case 2: {
                this.setMessage(message);
                break;
            }
            case 0: 
            case 4: {
                if (messageType == 3) {
                    this.setErrorMessage(message);
                    break;
                }
                this.setMessage(message, messageType);
                break;
            }
            case 8: {
                this.setErrorMessage(message);
            }
        }
        switch (decodedAction.dialog) {
            case 0: 
            case 512: {
                if (status.getChildren().length <= 0) break;
                ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (IStatus)status);
                break;
            }
            case 1024: {
                ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (IStatus)status);
                break;
            }
            case 2048: {
                new ErrorDialog(this.getShell(), dialogTitle, dialogMessage, status, 7){

                    protected Image getImage() {
                        return this.getErrorImage();
                    }
                }.open();
            }
        }
    }
}

