/* This is -*- C -*- */
/* $Id: guppi-plug-in.h,v 1.15 2001/11/19 05:40:52 trow Exp $ */

/*
 * guppi-plug-in.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLUG_IN_H
#define _INC_GUPPI_PLUG_IN_H

/* #include <gtk/gtk.h> */
#include <gtk/gtkobject.h>
#include  "guppi-defs.h"

BEGIN_GUPPI_DECLS

#define GUPPI_PLUG_IN_MAGIC_NUMBER 0xb0bee003
typedef struct _GuppiPlugIn GuppiPlugIn;
typedef struct _GuppiPlugInClass GuppiPlugInClass;

struct _GuppiPlugIn {
  GtkObject parent;
  guint32 magic_number;
  const gchar *load_path;
  gpointer reserved;
  gpointer spec;
};

struct _GuppiPlugInClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_PLUG_IN (guppi_plug_in_get_type())
#define GUPPI_PLUG_IN(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLUG_IN,GuppiPlugIn))
#define GUPPI_PLUG_IN0(obj) ((obj) ? (GUPPI_PLUG_IN(obj)) : NULL)
#define GUPPI_PLUG_IN_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLUG_IN,GuppiPlugInClass))
#define GUPPI_IS_PLUG_IN(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLUG_IN))
#define GUPPI_IS_PLUG_IN0(obj) (((obj) == NULL) || (GUPPI_IS_PLUG_IN(obj)))
#define GUPPI_IS_PLUG_IN_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLUG_IN))

GtkType guppi_plug_in_get_type (void);

GuppiPlugIn *guppi_plug_in_new (void);
GuppiPlugIn *guppi_plug_in_load (const gchar * path);

const gchar *guppi_plug_in_type (GuppiPlugIn *);
const gchar *guppi_plug_in_code (GuppiPlugIn *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_PLUG_IN_H */

/* $Id: guppi-plug-in.h,v 1.15 2001/11/19 05:40:52 trow Exp $ */
