#TRUSTED a6c9479fafa2bc166558258963e7ec6a13536e210b9d7d7efad8523fce0edb885084ec33e4fe5a521cb727056527a2268883ef0ece096e6993da4f2a50dc61b83129396a156d4153f5c413c74528c0046916db71a8decc1bef813133d4a30d72d6975b7896303ad1601b421f25f019d56cd95c28c5c68e540a279ea4ba46b3bde80ba2a945b5be7c3fee8b4b016f59633256a0f06a75944d639e299c4245d8a0681d2aa23228b2f509512e8cff66e9cc3ee4351be8f1747a874ab12a6c0efc3991a9f65259285273f8e7a1fef1659a1dd847a101a48cf37affcbad52a2eba64d8f5419a23f814f2738d5180a2cc164ba44aa4b4fdb6f24f817cbba6ed5fe6c1a0d4e5830e3f5824ee98341e2fcdd4bd46b48ebf3dbf3301704caf31754e5d964b81324b198145aae3d69e5cb147a9db795694ccc9d1067e136422e0b5bc0684afe713c3da4e652129afc659f845128ae486fff5638c1554deae3809fe23b3529894db23f5011cc4cdeca5162d25b2dc5ccb5b5c35d3ca782cbe3b3c8e66f3062515af0361962c6ea845d9787efe960c43aaad533dd9600560c7e0d4e18929e906265832edb425f57efd571b237ec9334c975d3224e79470db82996baf6f0c2763dbe118431314710785c0a960bfddab5b2a465fa284fc1e280b983d4b26d33969bf72fff740d72f3474441d95854dc420efd4a03a0eb53abb42ed8ed6339ba25
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15886);
 script_version ("1.2");
 name["english"] = "Hydra: SNMP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SNMP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SNMP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_udp_ports(161, 32789);
 script_dependencies("hydra_options.nasl", "snmp_default_communities.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("SNMP/port");
if (port) exit(0);
# Yes! We exit if we know the port, and thus some common community name
port = 161;
if (! get_udp_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
if (s)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "snmp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/snmp/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SNMP communities:\n' + report);
