/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-matrix.h                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : m-matrix.c header file                                   *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Notes        : Source code addapted from CTI PET Systems, Inc.          *
 *                Original code 2.2 10/19/93  Copyright 1989-1993          *
 *                                                                         *
 *                Changed code for swapping & the use of my data types     *
 *                with machine independency as purpose                     *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-matrix.h,v 1.1.1.1 2000/10/28 16:52:11 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __M_MATRIX_H__
#define __M_MATRIX_H__

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

#define         MatBLKSIZE 512
#define         MatFirstDirBlk 2

struct MatDir {
        Int32 matnum;
        Int32 strtblk;
        Int32 endblk;
        Int32 matstat;
};

typedef struct matdir {
        Int32 nmats;
        Int32 nmax;
        struct MatDir *entry;
} *Mat_dir;

struct Matval {
        Int32 frame, plane, gate, data, bed;
        };

#define TotalCounts   0
#define UnknownCalib  TotalCounts + 1
#define MDC_ECAT_COUNTS   UnknownCalib + 1
#define MCi_ML                MDC_ECAT_COUNTS + 1
#define LmrGlu        MCi_ML + 1              /* vax compatibility */
#define LmrGlu_mMole  LmrGlu + 1
#define LmrGlu_mGram  LmrGlu_mMole + 1
#define NCi_ML                LmrGlu_mGram + 1
#define WELL_COUNTS   NCi_ML + 1
#define BECQUERELS    WELL_COUNTS + 1   



typedef struct mat_main_header {
	char		original_file_name[20];
	Int16		sw_version;
	Int16		data_type;
	Int16		system_type;
	Int16		file_type;
	char		node_id[10];
	Int16		scan_start_day,
			scan_start_month,
			scan_start_year,
			scan_start_hour,
			scan_start_minute,
			scan_start_second;
	char		isotope_code[8];
	float		isotope_halflife;
	char		radiopharmaceutical[32];
	float		gantry_tilt,
			gantry_rotation,
			bed_elevation;
	Int16		rot_source_speed,
			wobble_speed,
			transm_source_type;
	float		axial_fov,
			transaxial_fov;
	Int16		transaxial_samp_mode,
			coin_samp_mode,
			axial_samp_mode;
	float		calibration_factor;
	Int16		calibration_units,
			compression_code;
	char		study_name[12],
			patient_id[16],
			patient_name[32],
			patient_sex,
			patient_age[10],
			patient_height[10],
			patient_weight[10],
			patient_dexterity,
			physician_name[32],
			operator_name[32],
			study_description[32];
	Int16		acquisition_type,
			bed_type,
			septa_type;
	char		facility_name[20];
	Int16		num_planes,
			num_frames,
			num_gates,
			num_bed_pos;
	float		init_bed_position,
			bed_offset[15],
			plane_separation;
	Int16		lwr_sctr_thres,
			lwr_true_thres,
			upr_true_thres;
	float		collimator;
	char		user_process_code[10];
	Int16		acquisition_mode;

} Main_header;

#define MH_64_SIZE 446

typedef struct mat_scan_subheader {
	Int16		data_type,
			dimension_1,
			dimension_2,
			smoothing,
			processing_code;
	float		sample_distance,
			isotope_halflife;
	Int16		frame_duration_sec;
	Int32		gate_duration,
			r_wave_offset;
	float		scale_factor;
	Int16		scan_min,
			scan_max;
	Int32		prompts,
			delayed,
			multiples,
			net_trues;
	float		cor_singles[16],
			uncor_singles[16],
			tot_avg_cor,
			tot_avg_uncor;
	Int32		total_coin_rate,
			frame_start_time,
			frame_duration;
	float		loss_correction_fctr;
	Int32		phy_planes[8];

} Scan_subheader;

#define SSH_64_SIZE 236

typedef struct mat_image_subheader {
	Int16		data_type,
			num_dimensions,
			dimension_1,
			dimension_2;
	float		x_origin,
			y_origin,
			recon_scale,	/* Image ZOOM from reconstruction */
			quant_scale;	/* Scale Factor */
	Int16		image_min,
			image_max;
	float		pixel_size,
			slice_width;
	Int32		frame_duration,
			frame_start_time;
	Int16		slice_location,
			recon_start_hour,
			recon_start_minute,
			recon_start_sec;
	Int32		gate_duration;
	Int16		filter_code;
	Int32		scan_matrix_num,
			norm_matrix_num,
			atten_cor_matrix_num;
	float		image_rotation,
			plane_eff_corr_fctr,
			decay_corr_fctr,
			loss_corr_fctr,
			intrinsic_tilt ;
	Int16		processing_code,
			quant_units,
			recon_start_day,
			recon_start_month,
			recon_start_year;
	float		ecat_calibration_fctr,
			well_counter_cal_fctr,
			filter_params[6];
	char		annotation[40];

} Image_subheader;

#define ISH_64_SIZE 172

typedef struct mat_norm_subheader {
	Int16		data_type,
			dimension_1,
			dimension_2;
	float		scale_factor;
	Int16		norm_hour,
			norm_minute,
			norm_second,
			norm_day,
			norm_month,
			norm_year;
	float		fov_source_width;
	float		ecat_calib_factor;

} Norm_subheader; 

#define NSH_64_SIZE 30

typedef struct mat_attn_subheader {
	Int16		data_type,
			attenuation_type,
			dimension_1,
			dimension_2;
	float		scale_factor,
			x_origin,
			y_origin,
			x_radius,
			y_radius,
			tilt_angle,
			attenuation_coeff,
			sample_distance;

} Attn_subheader;

#define ASH_64_SIZE 40

typedef struct matdirnode {
        Int32 matnum;
        Int32 strtblk;
        Int32 endblk;
        Int32 matstat;
        struct matdirnode *next;
} MatDirNode;

typedef struct matdirlist {
        Int32 nmats;
        MatDirNode *first;
        MatDirNode *last;
} MatDirList;

typedef struct matrixdata {
        Int32 mat_type;
        Int32 matnum;
        Uint8 *shptr;
        Uint8 *data_ptr;
        Int32 nviews;
        Int32 nelements;
        Int32 nblks;
        Int32 data_type;
} MatrixData;

typedef struct matrix_file {
        Main_header *mhptr;
        MatDirList  *dirlist;
        FILE        *fptr;
        Int32       mode;
        char        *fname[80];
} MatrixFile;

typedef struct matdirblk {
        Int32 nfree, nextblk, prvblk, nused;
        struct MatDir matdir[31];
} MatDirBlk;

#define BYTE_TYPE       1
#define VAX_I2          2
#define VAX_I4          3
#define VAX_R4          4
#define IEEE_R4         5
#define M68K_I2         6
#define M68K_I4         7
#define SUN_I2  M68K_I2
#define SUN_I4  M68K_I4
#define SUN_R4  IEEE_R4

#define RAW_DATA        1
#define IMAGE_DATA      2
#define ATTN_DATA       3
#define NORM_DATA       4
#define SUN_READ        1
#define SUN_WRITE       2
#define ACS_READ        3
#define ACS_WRITE       4
#define SUN_CREATE      5

#define ACQM_NORMAL      0  /* normal acquisition mode */
#define ACQM_RODTRN      1  /* rod transmission mode */
#define ACQM_RODTRN_KEEP 2  /* rod transmission mode keep all sinograms */
#define ACQM_DWIN_KEEP   3  /* dual window mode keep all sinograms */
#define ACQM_DWIN        4  /* dual window mode */
#define ACQM_SIMULT      5  /* simultaneous transmission/ emission mode */

/* eNlf: BEGIN - unnecessary, avoid conflicts! */
/* #define ERROR   -1                          */
/* #define OK 0                                */
/* eNlf: END   - unnecessary, avoid conflicts! */

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
Int32 MdcSWAW( Uint16 from[], Uint16 to[], Int32 length);
Int32 MdcSWAB( Uint8  from[], Uint8  to[], Int32 length);
FILE *mat_open(char *fname, char *fmode);
void mat_close(FILE *fptr);
Int32 mat_rblk(FILE *fptr, Int32 blkno, Uint8 *bufr, Int32 nblks);
Int32 mat_list(FILE *fptr, struct MatDir mlist[], Int32 lmax);
Int32 mat_numcod(Int32 frame, Int32 plane, Int32 gate, Int32 data, Int32 bed);
Int32 mat_numdoc( Int32 matnum, struct Matval *matval);
Int32 mat_lookup(FILE *fptr, Int32 matnum, struct MatDir *entry);
Int32 mat_read_main_header(FILE *fptr, Main_header *h);
Int32 mat_read_matrix_data(FILE *fptr, Int32 blk, Int32 nblks, Int16 bufr[]);
Int32 mat_read_mat_data(FILE *fptr, Int32 strtblk, Int32 nblks, Uint8 *dptr, Int32 dtype);
Int32 mat_read_scan_subheader(FILE *fptr, Int32 blknum, Scan_subheader *h);
Int32 mat_read_image_subheader(FILE *fptr, Int32 blknum, Image_subheader *h);
float get_vax_float(Uint16 bufr[], Int32 off);
Int32 get_vax_long(Uint16 bufr[], Int32 off);
Mat_dir mat_read_dir(FILE *fptr, Uint8 *selector);
Int32 mat_wblk(FILE *fptr, Int32 blkno, Uint8 *bufr, Int32 nblks);
FILE *mat_create(char *fname, Main_header *mhead);
Int32 mat_enter(FILE *fptr, Int32 matnum, Int32 nblks);
Int32 mat_write_image(FILE *fptr, Int32 matnum, Image_subheader *header,
                    Uint16 *data, Int32 data_size);
Int32 mat_write_scan(FILE *fptr, Int32 matnum, Scan_subheader *header,
                   Uint16 *data, Int32 data_size);
Int32 mat_write_attn(FILE *fptr, Int32 matnum, Attn_subheader *header, float *data, Int32 data_size);
Int32 mat_write_norm(FILE *fptr, Int32 matnum, Norm_subheader *header, float *data, Int32 data_size);
Int32 mat_write_idata(FILE *fptr, Int32 blk, Uint8 *data, Int32 size);
Int32 mat_write_fdata(FILE *fptr, Int32 blk, float *data, Int32 size);
Int32 matrix_selector(Int32 matnum, Int32 ranges[2][5]);
Int32 decode_selector(char *s1, Int32 ranges[2][5]);
Int32 str_find(char *s1, char *s2);
Int32 str_replace(char *s1, char *s2, char *s3, char *s4);
Int32 string_replace(char *s1, char *s2, char *s3, char *s4);
Int32 fix_selector(char *s1, char *s2);
char* next_word(char *s, char *w);
Int32 hostftovaxf(float f_orig, Uint16 number[]);
Int32 mat_write_main_header(FILE *fptr, Main_header *header);
Int32 mat_write_image_subheader(FILE *fptr, Int32 blknum, Image_subheader *header);
Int32 hostltovaxl(Int32 in, Uint16 out[2]);
Int32 mat_write_scan_subheader(FILE *fptr, Int32 blknum, Scan_subheader *header);
Int32 mat_write_attn_subheader(FILE *fptr, Int32 blknum, Attn_subheader *header);
Int32 mat_write_norm_subheader(FILE *fptr, Int32 blknum, Norm_subheader *header);
Int32 mat_read_attn_subheader(FILE *fptr, Int32 blknum, Attn_subheader *header);
Int32 mat_read_norm_subheader(FILE *fptr, Int32 blknum, Norm_subheader *header);
Int32 write_matrix_data(FILE *fptr, Int32 strtblk, Int32 nblks, Uint8 *dptr, Int32 dtype);
double  mat_qs(double *X, double *Z, Int32 lod);
double  mat_max(double *X, Int32 lod);
double  mat_min(double *X, Int32 lod);

#endif

