import chart_object
import object_set
import types
import theme
import pychart_util
import color_doc
from pychart_types import *

blackify_colors = 1

class T(chart_object.T):
    __doc__ = color_doc.doc
    keys={
        "r" : (NumType, 0.0, "The intensity of red. The value is between 0 and 1."),
        "g" : (NumType, 0.0, "The intensity of green. The value is between 0 and 1."),
        "b" : (NumType, 0.0, "The intensity of blue. The value is between 0 and 1.")
        }
##AUTOMATICALLY GENERATED
##END AUTOMATICALLY GENERATED
    def __str__(self):
        s = name_table().lookup(self)
        if s:
            return s
        if self.r == self.g and self.r == self.b:
            return "<color:grayscale=%f>" % self.r
        else:
            return "<color:r=%f,g=%f,b=%f>" % (self.r, self.g, self.b)
        
standards = object_set.T()
def _intern(r,g,b):
    c = T(r = r, g = g, b = b)
    standards.add(c)
    return c

def gray_scale(g):
    """Generate a grayscale color.T object. G=0 produces white, G=1.0
    produces black."""
    return T(r=g,g=g,b=g)

# generated automatically from rgb.txt

snow = _intern(r=1.000000,g=0.980392,b=0.980392)
ghostwhite = _intern(r=0.972549,g=0.972549,b=1.000000)
whitesmoke = _intern(r=0.960784,g=0.960784,b=0.960784)
gainsboro = _intern(r=0.862745,g=0.862745,b=0.862745)
floralwhite = _intern(r=1.000000,g=0.980392,b=0.941176)
oldlace = _intern(r=0.992157,g=0.960784,b=0.901961)
linen = _intern(r=0.980392,g=0.941176,b=0.901961)
antiquewhite = _intern(r=0.980392,g=0.921569,b=0.843137)
papayawhip = _intern(r=1.000000,g=0.937255,b=0.835294)
blanchedalmond = _intern(r=1.000000,g=0.921569,b=0.803922)
bisque = _intern(r=1.000000,g=0.894118,b=0.768627)
peachpuff = _intern(r=1.000000,g=0.854902,b=0.725490)
navajowhite = _intern(r=1.000000,g=0.870588,b=0.678431)
moccasin = _intern(r=1.000000,g=0.894118,b=0.709804)
cornsilk = _intern(r=1.000000,g=0.972549,b=0.862745)
ivory = _intern(r=1.000000,g=1.000000,b=0.941176)
lemonchiffon = _intern(r=1.000000,g=0.980392,b=0.803922)
seashell = _intern(r=1.000000,g=0.960784,b=0.933333)
honeydew = _intern(r=0.941176,g=1.000000,b=0.941176)
mintcream = _intern(r=0.960784,g=1.000000,b=0.980392)
azure = _intern(r=0.941176,g=1.000000,b=1.000000)
aliceblue = _intern(r=0.941176,g=0.972549,b=1.000000)
lavender = _intern(r=0.901961,g=0.901961,b=0.980392)
lavenderblush = _intern(r=1.000000,g=0.941176,b=0.960784)
mistyrose = _intern(r=1.000000,g=0.894118,b=0.882353)
white = _intern(r=1.000000,g=1.000000,b=1.000000)
black = _intern(r=0.000000,g=0.000000,b=0.000000)
darkslategray = _intern(r=0.184314,g=0.309804,b=0.309804)
dimgray = _intern(r=0.411765,g=0.411765,b=0.411765)
slategray = _intern(r=0.439216,g=0.501961,b=0.564706)
lightslategray = _intern(r=0.466667,g=0.533333,b=0.600000)
gray = _intern(r=0.745098,g=0.745098,b=0.745098)
lightgray = _intern(r=0.827451,g=0.827451,b=0.827451)
midnightblue = _intern(r=0.098039,g=0.098039,b=0.439216)
navy = _intern(r=0.000000,g=0.000000,b=0.501961)
navyblue = _intern(r=0.000000,g=0.000000,b=0.501961)
cornflowerblue = _intern(r=0.392157,g=0.584314,b=0.929412)
darkslateblue = _intern(r=0.282353,g=0.239216,b=0.545098)
slateblue = _intern(r=0.415686,g=0.352941,b=0.803922)
mediumslateblue = _intern(r=0.482353,g=0.407843,b=0.933333)
lightslateblue = _intern(r=0.517647,g=0.439216,b=1.000000)
mediumblue = _intern(r=0.000000,g=0.000000,b=0.803922)
royalblue = _intern(r=0.254902,g=0.411765,b=0.882353)
blue = _intern(r=0.000000,g=0.000000,b=1.000000)
dodgerblue = _intern(r=0.117647,g=0.564706,b=1.000000)
deepskyblue = _intern(r=0.000000,g=0.749020,b=1.000000)
skyblue = _intern(r=0.529412,g=0.807843,b=0.921569)
lightskyblue = _intern(r=0.529412,g=0.807843,b=0.980392)
steelblue = _intern(r=0.274510,g=0.509804,b=0.705882)
lightsteelblue = _intern(r=0.690196,g=0.768627,b=0.870588)
lightblue = _intern(r=0.678431,g=0.847059,b=0.901961)
powderblue = _intern(r=0.690196,g=0.878431,b=0.901961)
paleturquoise = _intern(r=0.686275,g=0.933333,b=0.933333)
darkturquoise = _intern(r=0.000000,g=0.807843,b=0.819608)
mediumturquoise = _intern(r=0.282353,g=0.819608,b=0.800000)
turquoise = _intern(r=0.250980,g=0.878431,b=0.815686)
cyan = _intern(r=0.000000,g=1.000000,b=1.000000)
lightcyan = _intern(r=0.878431,g=1.000000,b=1.000000)
cadetblue = _intern(r=0.372549,g=0.619608,b=0.627451)
mediumaquamarine = _intern(r=0.400000,g=0.803922,b=0.666667)
aquamarine = _intern(r=0.498039,g=1.000000,b=0.831373)
darkgreen = _intern(r=0.000000,g=0.392157,b=0.000000)
darkolivegreen = _intern(r=0.333333,g=0.419608,b=0.184314)
darkseagreen = _intern(r=0.560784,g=0.737255,b=0.560784)
seagreen = _intern(r=0.180392,g=0.545098,b=0.341176)
mediumseagreen = _intern(r=0.235294,g=0.701961,b=0.443137)
lightseagreen = _intern(r=0.125490,g=0.698039,b=0.666667)
palegreen = _intern(r=0.596078,g=0.984314,b=0.596078)
springgreen = _intern(r=0.000000,g=1.000000,b=0.498039)
lawngreen = _intern(r=0.486275,g=0.988235,b=0.000000)
green = _intern(r=0.000000,g=1.000000,b=0.000000)
chartreuse = _intern(r=0.498039,g=1.000000,b=0.000000)
mediumspringgreen = _intern(r=0.000000,g=0.980392,b=0.603922)
greenyellow = _intern(r=0.678431,g=1.000000,b=0.184314)
limegreen = _intern(r=0.196078,g=0.803922,b=0.196078)
yellowgreen = _intern(r=0.603922,g=0.803922,b=0.196078)
forestgreen = _intern(r=0.133333,g=0.545098,b=0.133333)
olivedrab = _intern(r=0.419608,g=0.556863,b=0.137255)
darkkhaki = _intern(r=0.741176,g=0.717647,b=0.419608)
khaki = _intern(r=0.941176,g=0.901961,b=0.549020)
palegoldenrod = _intern(r=0.933333,g=0.909804,b=0.666667)
lightgoldenrodyellow = _intern(r=0.980392,g=0.980392,b=0.823529)
lightyellow = _intern(r=1.000000,g=1.000000,b=0.878431)
yellow = _intern(r=1.000000,g=1.000000,b=0.000000)
gold = _intern(r=1.000000,g=0.843137,b=0.000000)
lightgoldenrod = _intern(r=0.933333,g=0.866667,b=0.509804)
goldenrod = _intern(r=0.854902,g=0.647059,b=0.125490)
darkgoldenrod = _intern(r=0.721569,g=0.525490,b=0.043137)
rosybrown = _intern(r=0.737255,g=0.560784,b=0.560784)
indianred = _intern(r=0.803922,g=0.360784,b=0.360784)
saddlebrown = _intern(r=0.545098,g=0.270588,b=0.074510)
sienna = _intern(r=0.627451,g=0.321569,b=0.176471)
peru = _intern(r=0.803922,g=0.521569,b=0.247059)
burlywood = _intern(r=0.870588,g=0.721569,b=0.529412)
beige = _intern(r=0.960784,g=0.960784,b=0.862745)
wheat = _intern(r=0.960784,g=0.870588,b=0.701961)
sandybrown = _intern(r=0.956863,g=0.643137,b=0.376471)
tan = _intern(r=0.823529,g=0.705882,b=0.549020)
chocolate = _intern(r=0.823529,g=0.411765,b=0.117647)
firebrick = _intern(r=0.698039,g=0.133333,b=0.133333)
brown = _intern(r=0.647059,g=0.164706,b=0.164706)
darksalmon = _intern(r=0.913725,g=0.588235,b=0.478431)
salmon = _intern(r=0.980392,g=0.501961,b=0.447059)
lightsalmon = _intern(r=1.000000,g=0.627451,b=0.478431)
orange = _intern(r=1.000000,g=0.647059,b=0.000000)
darkorange = _intern(r=1.000000,g=0.549020,b=0.000000)
coral = _intern(r=1.000000,g=0.498039,b=0.313725)
lightcoral = _intern(r=0.941176,g=0.501961,b=0.501961)
tomato = _intern(r=1.000000,g=0.388235,b=0.278431)
orangered = _intern(r=1.000000,g=0.270588,b=0.000000)
red = _intern(r=1.000000,g=0.000000,b=0.000000)
hotpink = _intern(r=1.000000,g=0.411765,b=0.705882)
deeppink = _intern(r=1.000000,g=0.078431,b=0.576471)
pink = _intern(r=1.000000,g=0.752941,b=0.796078)
lightpink = _intern(r=1.000000,g=0.713725,b=0.756863)
palevioletred = _intern(r=0.858824,g=0.439216,b=0.576471)
maroon = _intern(r=0.690196,g=0.188235,b=0.376471)
mediumvioletred = _intern(r=0.780392,g=0.082353,b=0.521569)
violetred = _intern(r=0.815686,g=0.125490,b=0.564706)
magenta = _intern(r=1.000000,g=0.000000,b=1.000000)
violet = _intern(r=0.933333,g=0.509804,b=0.933333)
plum = _intern(r=0.866667,g=0.627451,b=0.866667)
orchid = _intern(r=0.854902,g=0.439216,b=0.839216)
mediumorchid = _intern(r=0.729412,g=0.333333,b=0.827451)
darkorchid = _intern(r=0.600000,g=0.196078,b=0.800000)
darkviolet = _intern(r=0.580392,g=0.000000,b=0.827451)
blueviolet = _intern(r=0.541176,g=0.168627,b=0.886275)
purple = _intern(r=0.627451,g=0.125490,b=0.941176)
mediumpurple = _intern(r=0.576471,g=0.439216,b=0.858824)
thistle = _intern(r=0.847059,g=0.749020,b=0.847059)
snow1 = _intern(r=1.000000,g=0.980392,b=0.980392)
snow2 = _intern(r=0.933333,g=0.913725,b=0.913725)
snow3 = _intern(r=0.803922,g=0.788235,b=0.788235)
snow4 = _intern(r=0.545098,g=0.537255,b=0.537255)
seashell1 = _intern(r=1.000000,g=0.960784,b=0.933333)
seashell2 = _intern(r=0.933333,g=0.898039,b=0.870588)
seashell3 = _intern(r=0.803922,g=0.772549,b=0.749020)
seashell4 = _intern(r=0.545098,g=0.525490,b=0.509804)
antiquewhite1 = _intern(r=1.000000,g=0.937255,b=0.858824)
antiquewhite2 = _intern(r=0.933333,g=0.874510,b=0.800000)
antiquewhite3 = _intern(r=0.803922,g=0.752941,b=0.690196)
antiquewhite4 = _intern(r=0.545098,g=0.513725,b=0.470588)
bisque1 = _intern(r=1.000000,g=0.894118,b=0.768627)
bisque2 = _intern(r=0.933333,g=0.835294,b=0.717647)
bisque3 = _intern(r=0.803922,g=0.717647,b=0.619608)
bisque4 = _intern(r=0.545098,g=0.490196,b=0.419608)
peachpuff1 = _intern(r=1.000000,g=0.854902,b=0.725490)
peachpuff2 = _intern(r=0.933333,g=0.796078,b=0.678431)
peachpuff3 = _intern(r=0.803922,g=0.686275,b=0.584314)
peachpuff4 = _intern(r=0.545098,g=0.466667,b=0.396078)
navajowhite1 = _intern(r=1.000000,g=0.870588,b=0.678431)
navajowhite2 = _intern(r=0.933333,g=0.811765,b=0.631373)
navajowhite3 = _intern(r=0.803922,g=0.701961,b=0.545098)
navajowhite4 = _intern(r=0.545098,g=0.474510,b=0.368627)
lemonchiffon1 = _intern(r=1.000000,g=0.980392,b=0.803922)
lemonchiffon2 = _intern(r=0.933333,g=0.913725,b=0.749020)
lemonchiffon3 = _intern(r=0.803922,g=0.788235,b=0.647059)
lemonchiffon4 = _intern(r=0.545098,g=0.537255,b=0.439216)
cornsilk1 = _intern(r=1.000000,g=0.972549,b=0.862745)
cornsilk2 = _intern(r=0.933333,g=0.909804,b=0.803922)
cornsilk3 = _intern(r=0.803922,g=0.784314,b=0.694118)
cornsilk4 = _intern(r=0.545098,g=0.533333,b=0.470588)
ivory1 = _intern(r=1.000000,g=1.000000,b=0.941176)
ivory2 = _intern(r=0.933333,g=0.933333,b=0.878431)
ivory3 = _intern(r=0.803922,g=0.803922,b=0.756863)
ivory4 = _intern(r=0.545098,g=0.545098,b=0.513725)
honeydew1 = _intern(r=0.941176,g=1.000000,b=0.941176)
honeydew2 = _intern(r=0.878431,g=0.933333,b=0.878431)
honeydew3 = _intern(r=0.756863,g=0.803922,b=0.756863)
honeydew4 = _intern(r=0.513725,g=0.545098,b=0.513725)
lavenderblush1 = _intern(r=1.000000,g=0.941176,b=0.960784)
lavenderblush2 = _intern(r=0.933333,g=0.878431,b=0.898039)
lavenderblush3 = _intern(r=0.803922,g=0.756863,b=0.772549)
lavenderblush4 = _intern(r=0.545098,g=0.513725,b=0.525490)
mistyrose1 = _intern(r=1.000000,g=0.894118,b=0.882353)
mistyrose2 = _intern(r=0.933333,g=0.835294,b=0.823529)
mistyrose3 = _intern(r=0.803922,g=0.717647,b=0.709804)
mistyrose4 = _intern(r=0.545098,g=0.490196,b=0.482353)
azure1 = _intern(r=0.941176,g=1.000000,b=1.000000)
azure2 = _intern(r=0.878431,g=0.933333,b=0.933333)
azure3 = _intern(r=0.756863,g=0.803922,b=0.803922)
azure4 = _intern(r=0.513725,g=0.545098,b=0.545098)
slateblue1 = _intern(r=0.513725,g=0.435294,b=1.000000)
slateblue2 = _intern(r=0.478431,g=0.403922,b=0.933333)
slateblue3 = _intern(r=0.411765,g=0.349020,b=0.803922)
slateblue4 = _intern(r=0.278431,g=0.235294,b=0.545098)
royalblue1 = _intern(r=0.282353,g=0.462745,b=1.000000)
royalblue2 = _intern(r=0.262745,g=0.431373,b=0.933333)
royalblue3 = _intern(r=0.227451,g=0.372549,b=0.803922)
royalblue4 = _intern(r=0.152941,g=0.250980,b=0.545098)
blue1 = _intern(r=0.000000,g=0.000000,b=1.000000)
blue2 = _intern(r=0.000000,g=0.000000,b=0.933333)
blue3 = _intern(r=0.000000,g=0.000000,b=0.803922)
blue4 = _intern(r=0.000000,g=0.000000,b=0.545098)
dodgerblue1 = _intern(r=0.117647,g=0.564706,b=1.000000)
dodgerblue2 = _intern(r=0.109804,g=0.525490,b=0.933333)
dodgerblue3 = _intern(r=0.094118,g=0.454902,b=0.803922)
dodgerblue4 = _intern(r=0.062745,g=0.305882,b=0.545098)
steelblue1 = _intern(r=0.388235,g=0.721569,b=1.000000)
steelblue2 = _intern(r=0.360784,g=0.674510,b=0.933333)
steelblue3 = _intern(r=0.309804,g=0.580392,b=0.803922)
steelblue4 = _intern(r=0.211765,g=0.392157,b=0.545098)
deepskyblue1 = _intern(r=0.000000,g=0.749020,b=1.000000)
deepskyblue2 = _intern(r=0.000000,g=0.698039,b=0.933333)
deepskyblue3 = _intern(r=0.000000,g=0.603922,b=0.803922)
deepskyblue4 = _intern(r=0.000000,g=0.407843,b=0.545098)
skyblue1 = _intern(r=0.529412,g=0.807843,b=1.000000)
skyblue2 = _intern(r=0.494118,g=0.752941,b=0.933333)
skyblue3 = _intern(r=0.423529,g=0.650980,b=0.803922)
skyblue4 = _intern(r=0.290196,g=0.439216,b=0.545098)
lightskyblue1 = _intern(r=0.690196,g=0.886275,b=1.000000)
lightskyblue2 = _intern(r=0.643137,g=0.827451,b=0.933333)
lightskyblue3 = _intern(r=0.552941,g=0.713725,b=0.803922)
lightskyblue4 = _intern(r=0.376471,g=0.482353,b=0.545098)
slategray1 = _intern(r=0.776471,g=0.886275,b=1.000000)
slategray2 = _intern(r=0.725490,g=0.827451,b=0.933333)
slategray3 = _intern(r=0.623529,g=0.713725,b=0.803922)
slategray4 = _intern(r=0.423529,g=0.482353,b=0.545098)
lightsteelblue1 = _intern(r=0.792157,g=0.882353,b=1.000000)
lightsteelblue2 = _intern(r=0.737255,g=0.823529,b=0.933333)
lightsteelblue3 = _intern(r=0.635294,g=0.709804,b=0.803922)
lightsteelblue4 = _intern(r=0.431373,g=0.482353,b=0.545098)
lightblue1 = _intern(r=0.749020,g=0.937255,b=1.000000)
lightblue2 = _intern(r=0.698039,g=0.874510,b=0.933333)
lightblue3 = _intern(r=0.603922,g=0.752941,b=0.803922)
lightblue4 = _intern(r=0.407843,g=0.513725,b=0.545098)
lightcyan1 = _intern(r=0.878431,g=1.000000,b=1.000000)
lightcyan2 = _intern(r=0.819608,g=0.933333,b=0.933333)
lightcyan3 = _intern(r=0.705882,g=0.803922,b=0.803922)
lightcyan4 = _intern(r=0.478431,g=0.545098,b=0.545098)
paleturquoise1 = _intern(r=0.733333,g=1.000000,b=1.000000)
paleturquoise2 = _intern(r=0.682353,g=0.933333,b=0.933333)
paleturquoise3 = _intern(r=0.588235,g=0.803922,b=0.803922)
paleturquoise4 = _intern(r=0.400000,g=0.545098,b=0.545098)
cadetblue1 = _intern(r=0.596078,g=0.960784,b=1.000000)
cadetblue2 = _intern(r=0.556863,g=0.898039,b=0.933333)
cadetblue3 = _intern(r=0.478431,g=0.772549,b=0.803922)
cadetblue4 = _intern(r=0.325490,g=0.525490,b=0.545098)
turquoise1 = _intern(r=0.000000,g=0.960784,b=1.000000)
turquoise2 = _intern(r=0.000000,g=0.898039,b=0.933333)
turquoise3 = _intern(r=0.000000,g=0.772549,b=0.803922)
turquoise4 = _intern(r=0.000000,g=0.525490,b=0.545098)
cyan1 = _intern(r=0.000000,g=1.000000,b=1.000000)
cyan2 = _intern(r=0.000000,g=0.933333,b=0.933333)
cyan3 = _intern(r=0.000000,g=0.803922,b=0.803922)
cyan4 = _intern(r=0.000000,g=0.545098,b=0.545098)
darkslategray1 = _intern(r=0.592157,g=1.000000,b=1.000000)
darkslategray2 = _intern(r=0.552941,g=0.933333,b=0.933333)
darkslategray3 = _intern(r=0.474510,g=0.803922,b=0.803922)
darkslategray4 = _intern(r=0.321569,g=0.545098,b=0.545098)
aquamarine1 = _intern(r=0.498039,g=1.000000,b=0.831373)
aquamarine2 = _intern(r=0.462745,g=0.933333,b=0.776471)
aquamarine3 = _intern(r=0.400000,g=0.803922,b=0.666667)
aquamarine4 = _intern(r=0.270588,g=0.545098,b=0.454902)
darkseagreen1 = _intern(r=0.756863,g=1.000000,b=0.756863)
darkseagreen2 = _intern(r=0.705882,g=0.933333,b=0.705882)
darkseagreen3 = _intern(r=0.607843,g=0.803922,b=0.607843)
darkseagreen4 = _intern(r=0.411765,g=0.545098,b=0.411765)
seagreen1 = _intern(r=0.329412,g=1.000000,b=0.623529)
seagreen2 = _intern(r=0.305882,g=0.933333,b=0.580392)
seagreen3 = _intern(r=0.262745,g=0.803922,b=0.501961)
seagreen4 = _intern(r=0.180392,g=0.545098,b=0.341176)
palegreen1 = _intern(r=0.603922,g=1.000000,b=0.603922)
palegreen2 = _intern(r=0.564706,g=0.933333,b=0.564706)
palegreen3 = _intern(r=0.486275,g=0.803922,b=0.486275)
palegreen4 = _intern(r=0.329412,g=0.545098,b=0.329412)
springgreen1 = _intern(r=0.000000,g=1.000000,b=0.498039)
springgreen2 = _intern(r=0.000000,g=0.933333,b=0.462745)
springgreen3 = _intern(r=0.000000,g=0.803922,b=0.400000)
springgreen4 = _intern(r=0.000000,g=0.545098,b=0.270588)
green1 = _intern(r=0.000000,g=1.000000,b=0.000000)
green2 = _intern(r=0.000000,g=0.933333,b=0.000000)
green3 = _intern(r=0.000000,g=0.803922,b=0.000000)
green4 = _intern(r=0.000000,g=0.545098,b=0.000000)
chartreuse1 = _intern(r=0.498039,g=1.000000,b=0.000000)
chartreuse2 = _intern(r=0.462745,g=0.933333,b=0.000000)
chartreuse3 = _intern(r=0.400000,g=0.803922,b=0.000000)
chartreuse4 = _intern(r=0.270588,g=0.545098,b=0.000000)
olivedrab1 = _intern(r=0.752941,g=1.000000,b=0.243137)
olivedrab2 = _intern(r=0.701961,g=0.933333,b=0.227451)
olivedrab3 = _intern(r=0.603922,g=0.803922,b=0.196078)
olivedrab4 = _intern(r=0.411765,g=0.545098,b=0.133333)
darkolivegreen1 = _intern(r=0.792157,g=1.000000,b=0.439216)
darkolivegreen2 = _intern(r=0.737255,g=0.933333,b=0.407843)
darkolivegreen3 = _intern(r=0.635294,g=0.803922,b=0.352941)
darkolivegreen4 = _intern(r=0.431373,g=0.545098,b=0.239216)
khaki1 = _intern(r=1.000000,g=0.964706,b=0.560784)
khaki2 = _intern(r=0.933333,g=0.901961,b=0.521569)
khaki3 = _intern(r=0.803922,g=0.776471,b=0.450980)
khaki4 = _intern(r=0.545098,g=0.525490,b=0.305882)
lightgoldenrod1 = _intern(r=1.000000,g=0.925490,b=0.545098)
lightgoldenrod2 = _intern(r=0.933333,g=0.862745,b=0.509804)
lightgoldenrod3 = _intern(r=0.803922,g=0.745098,b=0.439216)
lightgoldenrod4 = _intern(r=0.545098,g=0.505882,b=0.298039)
lightyellow1 = _intern(r=1.000000,g=1.000000,b=0.878431)
lightyellow2 = _intern(r=0.933333,g=0.933333,b=0.819608)
lightyellow3 = _intern(r=0.803922,g=0.803922,b=0.705882)
lightyellow4 = _intern(r=0.545098,g=0.545098,b=0.478431)
yellow1 = _intern(r=1.000000,g=1.000000,b=0.000000)
yellow2 = _intern(r=0.933333,g=0.933333,b=0.000000)
yellow3 = _intern(r=0.803922,g=0.803922,b=0.000000)
yellow4 = _intern(r=0.545098,g=0.545098,b=0.000000)
gold1 = _intern(r=1.000000,g=0.843137,b=0.000000)
gold2 = _intern(r=0.933333,g=0.788235,b=0.000000)
gold3 = _intern(r=0.803922,g=0.678431,b=0.000000)
gold4 = _intern(r=0.545098,g=0.458824,b=0.000000)
goldenrod1 = _intern(r=1.000000,g=0.756863,b=0.145098)
goldenrod2 = _intern(r=0.933333,g=0.705882,b=0.133333)
goldenrod3 = _intern(r=0.803922,g=0.607843,b=0.113725)
goldenrod4 = _intern(r=0.545098,g=0.411765,b=0.078431)
darkgoldenrod1 = _intern(r=1.000000,g=0.725490,b=0.058824)
darkgoldenrod2 = _intern(r=0.933333,g=0.678431,b=0.054902)
darkgoldenrod3 = _intern(r=0.803922,g=0.584314,b=0.047059)
darkgoldenrod4 = _intern(r=0.545098,g=0.396078,b=0.031373)
rosybrown1 = _intern(r=1.000000,g=0.756863,b=0.756863)
rosybrown2 = _intern(r=0.933333,g=0.705882,b=0.705882)
rosybrown3 = _intern(r=0.803922,g=0.607843,b=0.607843)
rosybrown4 = _intern(r=0.545098,g=0.411765,b=0.411765)
indianred1 = _intern(r=1.000000,g=0.415686,b=0.415686)
indianred2 = _intern(r=0.933333,g=0.388235,b=0.388235)
indianred3 = _intern(r=0.803922,g=0.333333,b=0.333333)
indianred4 = _intern(r=0.545098,g=0.227451,b=0.227451)
sienna1 = _intern(r=1.000000,g=0.509804,b=0.278431)
sienna2 = _intern(r=0.933333,g=0.474510,b=0.258824)
sienna3 = _intern(r=0.803922,g=0.407843,b=0.223529)
sienna4 = _intern(r=0.545098,g=0.278431,b=0.149020)
burlywood1 = _intern(r=1.000000,g=0.827451,b=0.607843)
burlywood2 = _intern(r=0.933333,g=0.772549,b=0.568627)
burlywood3 = _intern(r=0.803922,g=0.666667,b=0.490196)
burlywood4 = _intern(r=0.545098,g=0.450980,b=0.333333)
wheat1 = _intern(r=1.000000,g=0.905882,b=0.729412)
wheat2 = _intern(r=0.933333,g=0.847059,b=0.682353)
wheat3 = _intern(r=0.803922,g=0.729412,b=0.588235)
wheat4 = _intern(r=0.545098,g=0.494118,b=0.400000)
tan1 = _intern(r=1.000000,g=0.647059,b=0.309804)
tan2 = _intern(r=0.933333,g=0.603922,b=0.286275)
tan3 = _intern(r=0.803922,g=0.521569,b=0.247059)
tan4 = _intern(r=0.545098,g=0.352941,b=0.168627)
chocolate1 = _intern(r=1.000000,g=0.498039,b=0.141176)
chocolate2 = _intern(r=0.933333,g=0.462745,b=0.129412)
chocolate3 = _intern(r=0.803922,g=0.400000,b=0.113725)
chocolate4 = _intern(r=0.545098,g=0.270588,b=0.074510)
firebrick1 = _intern(r=1.000000,g=0.188235,b=0.188235)
firebrick2 = _intern(r=0.933333,g=0.172549,b=0.172549)
firebrick3 = _intern(r=0.803922,g=0.149020,b=0.149020)
firebrick4 = _intern(r=0.545098,g=0.101961,b=0.101961)
brown1 = _intern(r=1.000000,g=0.250980,b=0.250980)
brown2 = _intern(r=0.933333,g=0.231373,b=0.231373)
brown3 = _intern(r=0.803922,g=0.200000,b=0.200000)
brown4 = _intern(r=0.545098,g=0.137255,b=0.137255)
salmon1 = _intern(r=1.000000,g=0.549020,b=0.411765)
salmon2 = _intern(r=0.933333,g=0.509804,b=0.384314)
salmon3 = _intern(r=0.803922,g=0.439216,b=0.329412)
salmon4 = _intern(r=0.545098,g=0.298039,b=0.223529)
lightsalmon1 = _intern(r=1.000000,g=0.627451,b=0.478431)
lightsalmon2 = _intern(r=0.933333,g=0.584314,b=0.447059)
lightsalmon3 = _intern(r=0.803922,g=0.505882,b=0.384314)
lightsalmon4 = _intern(r=0.545098,g=0.341176,b=0.258824)
orange1 = _intern(r=1.000000,g=0.647059,b=0.000000)
orange2 = _intern(r=0.933333,g=0.603922,b=0.000000)
orange3 = _intern(r=0.803922,g=0.521569,b=0.000000)
orange4 = _intern(r=0.545098,g=0.352941,b=0.000000)
darkorange1 = _intern(r=1.000000,g=0.498039,b=0.000000)
darkorange2 = _intern(r=0.933333,g=0.462745,b=0.000000)
darkorange3 = _intern(r=0.803922,g=0.400000,b=0.000000)
darkorange4 = _intern(r=0.545098,g=0.270588,b=0.000000)
coral1 = _intern(r=1.000000,g=0.447059,b=0.337255)
coral2 = _intern(r=0.933333,g=0.415686,b=0.313725)
coral3 = _intern(r=0.803922,g=0.356863,b=0.270588)
coral4 = _intern(r=0.545098,g=0.243137,b=0.184314)
tomato1 = _intern(r=1.000000,g=0.388235,b=0.278431)
tomato2 = _intern(r=0.933333,g=0.360784,b=0.258824)
tomato3 = _intern(r=0.803922,g=0.309804,b=0.223529)
tomato4 = _intern(r=0.545098,g=0.211765,b=0.149020)
orangered1 = _intern(r=1.000000,g=0.270588,b=0.000000)
orangered2 = _intern(r=0.933333,g=0.250980,b=0.000000)
orangered3 = _intern(r=0.803922,g=0.215686,b=0.000000)
orangered4 = _intern(r=0.545098,g=0.145098,b=0.000000)
red1 = _intern(r=1.000000,g=0.000000,b=0.000000)
red2 = _intern(r=0.933333,g=0.000000,b=0.000000)
red3 = _intern(r=0.803922,g=0.000000,b=0.000000)
red4 = _intern(r=0.545098,g=0.000000,b=0.000000)
deeppink1 = _intern(r=1.000000,g=0.078431,b=0.576471)
deeppink2 = _intern(r=0.933333,g=0.070588,b=0.537255)
deeppink3 = _intern(r=0.803922,g=0.062745,b=0.462745)
deeppink4 = _intern(r=0.545098,g=0.039216,b=0.313725)
hotpink1 = _intern(r=1.000000,g=0.431373,b=0.705882)
hotpink2 = _intern(r=0.933333,g=0.415686,b=0.654902)
hotpink3 = _intern(r=0.803922,g=0.376471,b=0.564706)
hotpink4 = _intern(r=0.545098,g=0.227451,b=0.384314)
pink1 = _intern(r=1.000000,g=0.709804,b=0.772549)
pink2 = _intern(r=0.933333,g=0.662745,b=0.721569)
pink3 = _intern(r=0.803922,g=0.568627,b=0.619608)
pink4 = _intern(r=0.545098,g=0.388235,b=0.423529)
lightpink1 = _intern(r=1.000000,g=0.682353,b=0.725490)
lightpink2 = _intern(r=0.933333,g=0.635294,b=0.678431)
lightpink3 = _intern(r=0.803922,g=0.549020,b=0.584314)
lightpink4 = _intern(r=0.545098,g=0.372549,b=0.396078)
palevioletred1 = _intern(r=1.000000,g=0.509804,b=0.670588)
palevioletred2 = _intern(r=0.933333,g=0.474510,b=0.623529)
palevioletred3 = _intern(r=0.803922,g=0.407843,b=0.537255)
palevioletred4 = _intern(r=0.545098,g=0.278431,b=0.364706)
maroon1 = _intern(r=1.000000,g=0.203922,b=0.701961)
maroon2 = _intern(r=0.933333,g=0.188235,b=0.654902)
maroon3 = _intern(r=0.803922,g=0.160784,b=0.564706)
maroon4 = _intern(r=0.545098,g=0.109804,b=0.384314)
violetred1 = _intern(r=1.000000,g=0.243137,b=0.588235)
violetred2 = _intern(r=0.933333,g=0.227451,b=0.549020)
violetred3 = _intern(r=0.803922,g=0.196078,b=0.470588)
violetred4 = _intern(r=0.545098,g=0.133333,b=0.321569)
magenta1 = _intern(r=1.000000,g=0.000000,b=1.000000)
magenta2 = _intern(r=0.933333,g=0.000000,b=0.933333)
magenta3 = _intern(r=0.803922,g=0.000000,b=0.803922)
magenta4 = _intern(r=0.545098,g=0.000000,b=0.545098)
orchid1 = _intern(r=1.000000,g=0.513725,b=0.980392)
orchid2 = _intern(r=0.933333,g=0.478431,b=0.913725)
orchid3 = _intern(r=0.803922,g=0.411765,b=0.788235)
orchid4 = _intern(r=0.545098,g=0.278431,b=0.537255)
plum1 = _intern(r=1.000000,g=0.733333,b=1.000000)
plum2 = _intern(r=0.933333,g=0.682353,b=0.933333)
plum3 = _intern(r=0.803922,g=0.588235,b=0.803922)
plum4 = _intern(r=0.545098,g=0.400000,b=0.545098)
mediumorchid1 = _intern(r=0.878431,g=0.400000,b=1.000000)
mediumorchid2 = _intern(r=0.819608,g=0.372549,b=0.933333)
mediumorchid3 = _intern(r=0.705882,g=0.321569,b=0.803922)
mediumorchid4 = _intern(r=0.478431,g=0.215686,b=0.545098)
darkorchid1 = _intern(r=0.749020,g=0.243137,b=1.000000)
darkorchid2 = _intern(r=0.698039,g=0.227451,b=0.933333)
darkorchid3 = _intern(r=0.603922,g=0.196078,b=0.803922)
darkorchid4 = _intern(r=0.407843,g=0.133333,b=0.545098)
purple1 = _intern(r=0.607843,g=0.188235,b=1.000000)
purple2 = _intern(r=0.568627,g=0.172549,b=0.933333)
purple3 = _intern(r=0.490196,g=0.149020,b=0.803922)
purple4 = _intern(r=0.333333,g=0.101961,b=0.545098)
mediumpurple1 = _intern(r=0.670588,g=0.509804,b=1.000000)
mediumpurple2 = _intern(r=0.623529,g=0.474510,b=0.933333)
mediumpurple3 = _intern(r=0.537255,g=0.407843,b=0.803922)
mediumpurple4 = _intern(r=0.364706,g=0.278431,b=0.545098)
thistle1 = _intern(r=1.000000,g=0.882353,b=1.000000)
thistle2 = _intern(r=0.933333,g=0.823529,b=0.933333)
thistle3 = _intern(r=0.803922,g=0.709804,b=0.803922)
thistle4 = _intern(r=0.545098,g=0.482353,b=0.545098)
gray00 = _intern(r=0.000000,g=0.000000,b=0.000000)
gray01 = _intern(r=0.011765,g=0.011765,b=0.011765)
gray02 = _intern(r=0.019608,g=0.019608,b=0.019608)
gray03 = _intern(r=0.031373,g=0.031373,b=0.031373)
gray04 = _intern(r=0.039216,g=0.039216,b=0.039216)
gray05 = _intern(r=0.050980,g=0.050980,b=0.050980)
gray06 = _intern(r=0.058824,g=0.058824,b=0.058824)
gray07 = _intern(r=0.070588,g=0.070588,b=0.070588)
gray08 = _intern(r=0.078431,g=0.078431,b=0.078431)
gray09 = _intern(r=0.090196,g=0.090196,b=0.090196)
gray10 = _intern(r=0.101961,g=0.101961,b=0.101961)
gray11 = _intern(r=0.109804,g=0.109804,b=0.109804)
gray12 = _intern(r=0.121569,g=0.121569,b=0.121569)
gray13 = _intern(r=0.129412,g=0.129412,b=0.129412)
gray14 = _intern(r=0.141176,g=0.141176,b=0.141176)
gray15 = _intern(r=0.149020,g=0.149020,b=0.149020)
gray16 = _intern(r=0.160784,g=0.160784,b=0.160784)
gray17 = _intern(r=0.168627,g=0.168627,b=0.168627)
gray18 = _intern(r=0.180392,g=0.180392,b=0.180392)
gray19 = _intern(r=0.188235,g=0.188235,b=0.188235)
gray20 = _intern(r=0.200000,g=0.200000,b=0.200000)
gray21 = _intern(r=0.211765,g=0.211765,b=0.211765)
gray22 = _intern(r=0.219608,g=0.219608,b=0.219608)
gray23 = _intern(r=0.231373,g=0.231373,b=0.231373)
gray24 = _intern(r=0.239216,g=0.239216,b=0.239216)
gray25 = _intern(r=0.250980,g=0.250980,b=0.250980)
gray26 = _intern(r=0.258824,g=0.258824,b=0.258824)
gray27 = _intern(r=0.270588,g=0.270588,b=0.270588)
gray28 = _intern(r=0.278431,g=0.278431,b=0.278431)
gray29 = _intern(r=0.290196,g=0.290196,b=0.290196)
gray30 = _intern(r=0.301961,g=0.301961,b=0.301961)
gray31 = _intern(r=0.309804,g=0.309804,b=0.309804)
gray32 = _intern(r=0.321569,g=0.321569,b=0.321569)
gray33 = _intern(r=0.329412,g=0.329412,b=0.329412)
gray34 = _intern(r=0.341176,g=0.341176,b=0.341176)
gray35 = _intern(r=0.349020,g=0.349020,b=0.349020)
gray36 = _intern(r=0.360784,g=0.360784,b=0.360784)
gray37 = _intern(r=0.368627,g=0.368627,b=0.368627)
gray38 = _intern(r=0.380392,g=0.380392,b=0.380392)
gray39 = _intern(r=0.388235,g=0.388235,b=0.388235)
gray40 = _intern(r=0.400000,g=0.400000,b=0.400000)
gray41 = _intern(r=0.411765,g=0.411765,b=0.411765)
gray42 = _intern(r=0.419608,g=0.419608,b=0.419608)
gray43 = _intern(r=0.431373,g=0.431373,b=0.431373)
gray44 = _intern(r=0.439216,g=0.439216,b=0.439216)
gray45 = _intern(r=0.450980,g=0.450980,b=0.450980)
gray46 = _intern(r=0.458824,g=0.458824,b=0.458824)
gray47 = _intern(r=0.470588,g=0.470588,b=0.470588)
gray48 = _intern(r=0.478431,g=0.478431,b=0.478431)
gray49 = _intern(r=0.490196,g=0.490196,b=0.490196)
gray50 = _intern(r=0.498039,g=0.498039,b=0.498039)
gray51 = _intern(r=0.509804,g=0.509804,b=0.509804)
gray52 = _intern(r=0.521569,g=0.521569,b=0.521569)
gray53 = _intern(r=0.529412,g=0.529412,b=0.529412)
gray54 = _intern(r=0.541176,g=0.541176,b=0.541176)
gray55 = _intern(r=0.549020,g=0.549020,b=0.549020)
gray56 = _intern(r=0.560784,g=0.560784,b=0.560784)
gray57 = _intern(r=0.568627,g=0.568627,b=0.568627)
gray58 = _intern(r=0.580392,g=0.580392,b=0.580392)
gray59 = _intern(r=0.588235,g=0.588235,b=0.588235)
gray60 = _intern(r=0.600000,g=0.600000,b=0.600000)
gray61 = _intern(r=0.611765,g=0.611765,b=0.611765)
gray62 = _intern(r=0.619608,g=0.619608,b=0.619608)
gray63 = _intern(r=0.631373,g=0.631373,b=0.631373)
gray64 = _intern(r=0.639216,g=0.639216,b=0.639216)
gray65 = _intern(r=0.650980,g=0.650980,b=0.650980)
gray66 = _intern(r=0.658824,g=0.658824,b=0.658824)
gray67 = _intern(r=0.670588,g=0.670588,b=0.670588)
gray68 = _intern(r=0.678431,g=0.678431,b=0.678431)
gray69 = _intern(r=0.690196,g=0.690196,b=0.690196)
gray70 = _intern(r=0.701961,g=0.701961,b=0.701961)
gray71 = _intern(r=0.709804,g=0.709804,b=0.709804)
gray72 = _intern(r=0.721569,g=0.721569,b=0.721569)
gray73 = _intern(r=0.729412,g=0.729412,b=0.729412)
gray74 = _intern(r=0.741176,g=0.741176,b=0.741176)
gray75 = _intern(r=0.749020,g=0.749020,b=0.749020)
gray76 = _intern(r=0.760784,g=0.760784,b=0.760784)
gray77 = _intern(r=0.768627,g=0.768627,b=0.768627)
gray78 = _intern(r=0.780392,g=0.780392,b=0.780392)
gray79 = _intern(r=0.788235,g=0.788235,b=0.788235)
gray80 = _intern(r=0.800000,g=0.800000,b=0.800000)
gray81 = _intern(r=0.811765,g=0.811765,b=0.811765)
gray82 = _intern(r=0.819608,g=0.819608,b=0.819608)
gray83 = _intern(r=0.831373,g=0.831373,b=0.831373)
gray84 = _intern(r=0.839216,g=0.839216,b=0.839216)
gray85 = _intern(r=0.850980,g=0.850980,b=0.850980)
gray86 = _intern(r=0.858824,g=0.858824,b=0.858824)
gray87 = _intern(r=0.870588,g=0.870588,b=0.870588)
gray88 = _intern(r=0.878431,g=0.878431,b=0.878431)
gray89 = _intern(r=0.890196,g=0.890196,b=0.890196)
gray90 = _intern(r=0.898039,g=0.898039,b=0.898039)
gray91 = _intern(r=0.909804,g=0.909804,b=0.909804)
gray92 = _intern(r=0.921569,g=0.921569,b=0.921569)
gray93 = _intern(r=0.929412,g=0.929412,b=0.929412)
gray94 = _intern(r=0.941176,g=0.941176,b=0.941176)
gray95 = _intern(r=0.949020,g=0.949020,b=0.949020)
gray96 = _intern(r=0.960784,g=0.960784,b=0.960784)
gray97 = _intern(r=0.968627,g=0.968627,b=0.968627)
gray98 = _intern(r=0.980392,g=0.980392,b=0.980392)
gray99 = _intern(r=0.988235,g=0.988235,b=0.988235)
gray100 = _intern(r=1.000000,g=1.000000,b=1.000000)
darkgray = _intern(r=0.662745,g=0.662745,b=0.662745)
darkblue = _intern(r=0.000000,g=0.000000,b=0.545098)
darkcyan = _intern(r=0.000000,g=0.545098,b=0.545098)
darkmagenta = _intern(r=0.545098,g=0.000000,b=0.545098)
darkred = _intern(r=0.545098,g=0.000000,b=0.000000)
lightgreen = _intern(r=0.564706,g=0.933333,b=0.564706)
default = black

_name_table = None
def name_table():
    global _name_table
    if not _name_table:
        _name_table = pychart_util.symbol_lookup_table(globals(), standards)
    return _name_table
