/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/22 09:34:40 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pglistboxitem.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.2 $
    Status:           $State: Exp $
*/

#ifndef PG_LISTBOXITEM_H
#define PG_LISTBOXITEM_H

#ifdef SWIG
%include "swigcommon.h"
%module pglistboxitem
%{
#include "pglistboxitem.h"
%}
#endif


#include "pglistboxbaseitem.h"

class PG_ListBox;

class DECLSPEC PG_ListBoxItem : public PG_ListBoxBaseItem {
public:

	/** */
	PG_ListBoxItem(int height, char* text = NULL, SDL_Surface* icon = NULL, void* userdata = NULL, const char* style="ListBox");

	/** */
	~PG_ListBoxItem();

	/** */
	void LoadThemeStyle(const char* widgettype, const char* objectname);

protected:

	/** */
	void eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst);
	
	/** */
	void eventSizeWindow(int w, int h);

private:

	PG_Gradient* my_gradient[3];
	SDL_Surface* my_background[3];
	SDL_Surface* my_srfHover;
	SDL_Surface* my_srfSelected;

	int my_bkmode[3];
	Uint8 my_blend[3];
};

#endif	// PG_LISTBOXITEM_H
