/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleElement.h,v 1.3 2004/09/12 01:05:54 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __RULEELEMENT_HH_FLAG__
#define __RULEELEMENT_HH_FLAG__

#include <fwbuilder/Group.h>
#include <fwbuilder/Address.h>
#include <fwbuilder/Service.h>
#include <fwbuilder/Interval.h>
#include <fwbuilder/ObjectGroup.h>
#include <fwbuilder/ServiceGroup.h>
#include <fwbuilder/IntervalGroup.h>

#ifdef _WIN32
// disable "warning C4250: 'libfwbuilder::RuleElementTDst' : inherits 'libfwbuilder::RuleElement::addRef' via dominance"
#  pragma warning(disable:4250)
#endif

namespace libfwbuilder
{

class Rule; 
class FWReference;

class RuleElement : virtual public FWObject {

protected:

    void      _initialize(const FWObject *root);

public:
    RuleElement();
    RuleElement(const FWObject *root);
    DECLARE_FWOBJECT_SUBTYPE(RuleElement);

    virtual void fromXML(xmlNodePtr parent) throw(FWException);

    void      setAnyElement();
    void      reset();
    virtual   std::string  getAnyElementId();
    bool      isAny();

    /**
     * Adds reference object pointing to 'obj' as a child of 'this'. If
     * RuleElement contained "any", it is removed
     */
    virtual void addRef(FWObject *obj);
    
    /**
     * Removes reference to given object among children of 'this'. If
     * this object was the last one, appropriate "any" object is added
     * instead
     */
    virtual void removeRef(FWObject *obj);

    bool   getNeg();
    void   setNeg(bool flag);
    void   toggleNeg();

};

class RuleElementSrc : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementSrc);
    RuleElementSrc();
    RuleElementSrc(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementDst : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementDst);
    RuleElementDst();
    RuleElementDst(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementSrv : public ServiceGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementSrv);
    RuleElementSrv();
    RuleElementSrv(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementInterval : public IntervalGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementInterval);
    RuleElementInterval();
    RuleElementInterval(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementOSrc : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementOSrc);
    RuleElementOSrc();
    RuleElementOSrc(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementODst : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementODst);
    RuleElementODst();
    RuleElementODst(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementOSrv : public ServiceGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementOSrv);
    RuleElementOSrv();
    RuleElementOSrv(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementTSrc : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementTSrc);
    RuleElementTSrc();
    RuleElementTSrc(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementTDst : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementTDst);
    RuleElementTDst();
    RuleElementTDst(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

class RuleElementTSrv : public ServiceGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementTSrv);
    RuleElementTSrv();
    RuleElementTSrv(const FWObject *root);
    virtual   std::string  getAnyElementId();
};

}

#endif




