<?php
/**
 * This class represent a single day fbview of mulitple free busy information.
 *
 * Copyright 2003-2005 Mike Cochrane <mike@graftonhall.co.nz>
 * Copyright 2004-2005 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information.
 *
 * $Horde: kronolith/lib/FBView/day.php,v 1.13.4.1 2005/01/03 12:25:40 jan Exp $
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @author  Jan Schneider <jan@horde.org>
 * @package Kronolith
 */
class Kronolith_FreeBusy_View_day extends Kronolith_FreeBusy_View {

    var $view = 'day';

    function _getBlocks($member, $periods, $blockfile, $label)
    {
        $template = &new Horde_Template();
        $template->set('label', $label);

        $count = 0;
        $blocks = '';
        foreach ($periods as $start => $end) {
            if ($start <= $this->_endStamp && $end >= $this->_startStamp) {
                $left  = max(0, 100 * (($start - $this->_startStamp) / ($this->_endStamp - $this->_startStamp)));
                $right = max(0, 100 * (($end - $this->_startStamp) / ($this->_endStamp - $this->_startStamp)));
                $width = $right - $left;

                $template->set('left', $left);
                $template->set('width', min($width, 100 - $left) );
                $template->set('top', $count++ * 15);
                $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/' . $blockfile);
            }
        }

        if ($member->getEnd() < $this->_endStamp) {
            $left  = max(0, 100 * (($member->getEnd() - $this->_startStamp) / ($this->_endStamp - $this->_startStamp)));
            $right = 100;
            $width = $right - $left;

            $template->set('left', $left);
            $template->set('width', $width);
            $template->set('top', $count++ * 15);
            $template->set('label', _("Unknown"));
            $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/unknownblock.tpl');
        } elseif ($member->getStart() > $this->_startStamp) {
            $left  = 0;
            $right = min(100, 100 * (($member->getStart() - $this->_startStamp) / ($this->_endStamp - $this->_startStamp)));
            $width = $right - $left;

            $template->set('left', $left);
            $template->set('width', $width);
            $template->set('top', $count++ * 15);
            $template->set('label', _("Unknown"));
            $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/unknownblock.tpl');
        }

        $template->set('top', $count++ * 15);
        $template->set('columns', range($this->_startHour, $this->_endHour - 1));
        $template->set('width', 100 / ($this->_endHour - $this->_startHour));
        $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/linesblock.tpl');

        return $blocks;
    }

    function _title()
    {
        global $registry, $prefs;

        return Horde::link('', _("Previous Day"), 'smallheader', null, 'return switchTimestamp(' . ($this->_day - 86400) . ');') .
            Horde::img('nav/left.png', '<', null, $registry->getImageDir('horde')) .
            '</a>' .
            strftime($prefs->getValue('date_format'), $this->_startStamp) .
            Horde::link('', _("Next Day"), 'smallheader', null, 'return switchTimestamp(' . ($this->_day + 86400) . ');') .
            Horde::img('nav/right.png', '>', null, $registry->getImageDir('horde')) .
            '</a>';
    }

    function _hours()
    {
        $hours_html = '<table width="100%" cellpadding="0" cellspacing="0" style="text-align:center; border-collapse:collapse"><tr>';
        $width = 100 / ($this->_endHour - $this->_startHour);
        for ($i = $this->_startHour; $i < $this->_endHour; $i++) {
            $hour = strftime('%H:00', mktime($i));
            $hours_html .= '<td style="border-left:1px solid black; border-right:1px solid black; width:' .
                $width . '%">' . $hour . '</td>';
        }
        $hours_html .= '</tr></table>';

        return $hours_html;
    }

    function _render($day = null)
    {
        global $prefs;

        if (is_null($day)) {
            $day = time();
        }
        $this->_day = $day;
        $this->_startStamp = mktime($this->_startHour, 0, 0, date('n', $day), date('j', $day), date('Y', $day));
        $this->_endStamp   = mktime($this->_endHour, 0, 0, date('n', $day), date('j', $day), date('Y', $day));
    }

}
