#ifdef __cplusplus
extern "C" {
#endif

/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/

#ifndef STRESS_H
#define STRESS_H

#include "defs.h"

#define DFLT_ITERATIONS 200 

#define DFLT_TOLERANCE 1e-4

 /* some possible values for 'num_pivots_stress' */
#define num_pivots_stress 40
#define num_pivots_smart_ini   0
#define num_pivots_no_ini   50

 /* relevant when using sparse distance matrix
  * when optimizing within subspace it can be set to 0
  * otherwise, recommended value is above zero (usually around 3-6)
  * some possible values for 'neighborhood_radius'
  */
#define neighborhood_radius_unrestricted  4
#define neighborhood_radius_subspace 0


 /* Full dense stress optimization (equivalent to Kamada-Kawai's energy) */
 /* Slowest and most accurate optimization */
extern int stress_majorization_kD_mkernel(
		vtx_data * graph,    /* Input graph in sparse representation */
		int n,               /* Number of nodes */
		int nedges_graph,    /* Number of edges */
		double ** coords,    /* coordinates of nodes (output layout)  */
		int dim,             /* dimemsionality of layout */
		int smart_ini,       /* smart initialization*/
		int model,           /* model*/
		int maxi             /* max iterations*/
);


#endif

#ifdef __cplusplus
}
#endif
