-- A level for Enigma
-- Name:        Mirror cabinet
-- Filename:    ralf13.lua
-- Copyright: 	(C) Jun 2003 Ralf Westram
-- Contact: 	amgine@reallysoft.de
-- License: 	GPL v2.0 or above

dofile(enigma.FindDataFile("levels/ralf.lua"))

--debug_mode()

level={
   "####################",
   "#  xxxx #r##r#rr#r##",
   "#       r/  / /  /r#",
   "#       @ ll#l#ll ##",
   "#o      @ l % % l ##",
   "o#      @/l%r#r%l/#.",
   "#O    a @ l ### l r#",
   "o#      @/l%r#r%l/#.",
   "#o      @ l % % l ##",
   "#       @ ll#l#ll ##",
   "#       r/  / /  /r#",
   "#  xxxx #r##r#r##r##",
   "####################",
}

mirrors=0
function named_mirror(x,y)
   mirrors=mirrors+1
   set_stone("st-mirror-p\\m",x,y,{name="mirr"..mirrors})
end

switches=0
function mirror_switch(x,y)
   switches=switches+1
   local funcn = "swit_"..switches
    dostring(funcn.." = function() switch("..switches..") end")
   set_stone("st-switch",x,y,{action="callback",target=funcn});
end

function switch(num)
   enigma.SendMessage(enigma.GetNamedObject("mirr"..num), "turn", 0)
end

cells={}

cells["!"] = cell{floor="fl-space"}
cells[" "] = cell{floor="fl-black"}
cells["#"] = cell{parent=cells[" "],stone="st-glass"}
cells["@"] = cell{parent=cells[" "],stone="st-grate1"}

cells["/"] = cell{parent=cells[" "],stone="st-mirror-p/m"}
cells["%"] = cell{parent={cells[" "],named_mirror}}
cells["x"] = cell{parent={cells[" "],mirror_switch}}

cells["a"] = cell{parent=cells[" "],actor={"ac-whiteball", {player=0, controllers=1}}}
cells["o"] = cell{oxyd}
cells["."] = cell{parent=cells[" "],stone={"st-laser-w", {on=1}}}
cells["O"] = cell{parent=cells[" "],stone="st-fakeoxyd"}

cells["l"] = cell{parent=cells[" "],stone="st-rotator-left"}
cells["r"] = cell{parent=cells[" "],stone="st-rotator-right"}

rs_create_world(level,cells)
