/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-files.h                                                     *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : m-files.c header file                                    *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-files.h,v 1.1.1.1 2000/10/28 16:52:07 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __M_FILES_H__
#define __M_FILES_H__

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

#define MdcSplitPath(x,y,z)    MdcMySplitPath(x,&y,&z)
#define MdcMergePath(x,y,z)    MdcMyMergePath(x,y,&z)
#define MdcFileClose(fp)       { if (fp != NULL) fclose(fp); fp=NULL; }

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
int MdcOpenFile(FILEINFO *fi, char *path);
int MdcReadFile(FILEINFO *fi, int filenr);
int MdcWriteFile(FILEINFO *fi, int format, int prefixnr);
int MdcDecompressFile(char *path);
char *MdcCheckFI(FILEINFO *fi);
void MdcStringCopy(char *s1, char *s2, Uint32 length);
int MdcFileSize(FILE *fp);
int MdcFileExists(char *fname);
int MdcGetFrmt(FILEINFO *fi);
Uint8 *MdcGetImgBuffer(Uint32 bytes);
char *MdcHandleTruncated(FILEINFO *fi, Uint32 images, int remap);
int MdcWriteLine(IMG_DATA *id, Uint8 *buf, int type, FILE *fp);
int MdcWriteDoublePixel(double pix, int type, FILE *fp);
int MdcGetStructID(FILEINFO *fi);
void MdcInitID(IMG_DATA *id);
void MdcResetIDs(FILEINFO *fi);
int MdcGetStructAD(FILEINFO *fi);
void MdcInitAD(ACQ_DATA *acq);
void MdcInitFI(FILEINFO *fi, char *path);
void MdcFreeIDs(FILEINFO *fi);
void MdcCleanUpFI(FILEINFO *fi);
char *MdcGetFname(char path[]);
char *MdcGetExtension(char path[]);
char *MdcGetLastPathSlash(char *path);
void MdcMySplitPath(char path[], char **dir, char **fname);
void MdcMyMergePath(char path[], char *dir, char **fname);
void MdcNewExt(char dest[], char *src, char *ext);
void MdcPrefix(int n);
void MdcNewName(char dest[], char *src, char *ext);
void MdcDefaultName(Int8 format, char dest[], char *src);
void MdcRenameFile(char *name);
void MdcFillImgPos(FILEINFO *fi, Uint32 nr, Uint32 plane, float translation);
void MdcFillImgOrient(FILEINFO *fi, Uint32 nr);
Int8 MdcGetPatSliceOrient(FILEINFO *fi, Uint32 i);
Int8 MdcTryPatSliceOrient(char *pat_orient);

#endif

