import glimmer
import string
import sys
import os
sys.argv=[]
sys.argv.append("null")
from gtk import *
import _gtk
import _gnome
import _gnomeui
from gnome.ui import *
import gnome.config

def populate_dir_listing(path):
   import dircache
   import string
   filelist.set_column_title(0, path)
   filelist.clear()
   dirlisting = dircache.listdir(path)
   dirlisting = dirlisting[:]
   dircache.annotate(path, dirlisting)
   dotfiles = []
   dotfiles = [".", ""]
   filelist.append(dotfiles)
   dotfiles = ["..", ""]
   filelist.append(dotfiles)
   num = 0
   dlen = len(dirlisting)
   filelist.freeze()
   while num < dlen:
      if string.count(dirlisting[num], "/") > 0:
         if showdots.active:
            dname = []
            dname.append(dirlisting[num])
            dname.append("")
            filelist.append(dname)
         else:
            if dirlisting[num][0] != '.':
               dname = []
               dname.append(dirlisting[num])
               dname.append("")
               filelist.append(dname)
      num = num + 1
   num = 0
   while num < dlen:
      if string.count(dirlisting[num], "/") <= 0:
         if showdots.active:
            dname = []
            dname.append(dirlisting[num])
            dname.append("")
            filelist.append(dname)
         else:
            if dirlisting[num][0] != '.':
               dname = []
               dname.append(dirlisting[num])
               dname.append("")
               filelist.append(dname)
      num = num + 1
   del dircache
   del string
   filelist.thaw()

def select_row_callback(clist, row, col, event, data):
   import glimmer
   import string
   dir = filelist.get_column_title(0)
   text = filelist.get_text(row, 0)
   if string.count(text, "/") > 0:
      dir = dir + text
      populate_dir_listing(dir)
   elif text == ".":
      dir = dir
      populate_dir_listing(dir)
   elif text == "..":
      i = string.rfind(dir, "/")
      if i > 1:
         dir = dir[0:i]
         i = string.rfind(dir, "/")
         if i > 1:
            dir = dir[0:i+1]
         else:
            dir = "/"
      else:
         dir = "/"
      populate_dir_listing(dir)
   else:
      filename = dir + text
      glimmer.open_file(filename)
   del glimmer
   del string

def toggle_file_selector(obj, checkmenuitem, fbox):
   if checkmenuitem.active:
      glimmer.add_paned_object(fbox._o, "FileSelector", 0)
      glimmer.unref_paned_object("FileSelector");
   else:
      glimmer.ref_paned_object("FileSelector");
      glimmer.remove_paned_object("FileSelector")

def close_file_selector(button, citem, fbox):
   citem.destroy()
   glimmer.remove_paned_object("FileSelector")

def popup_options(button, popupmenu):
   popupmenu.popup(None, None, None, 1, 0)

def set_show_hidden_files(obj, checkmenuitem, flist):
   gnome.config.set_bool("/glimmer/FileSelector/show_hidden", checkmenuitem.active)
   gnome.config.sync()
   flist.select_row(0, 0)

showhidden = gnome.config.get_bool("/glimmer/FileSelector/show_hidden=true")
currentdir = os.path.abspath(".")
filebox = GtkVBox(FALSE, 0)
filebox.show()
titleframe = GtkFrame()
filebox.pack_start(titleframe, FALSE, FALSE, 2)
titleframe.show()
buttonbox = GtkHBox(FALSE, 0)
titleframe.add(buttonbox)
buttonbox.show()
optionsbutton = GtkButton()
optionsbutton.set_relief(RELIEF_NONE)
buttonbox.pack_start(optionsbutton, FALSE, FALSE, 2)
optionsbutton.show()
optionsbuttonbox = GtkHBox(FALSE, 0)
optionsbutton.add(optionsbuttonbox)
optionsbuttonbox.pack_start(GtkLabel("File Selector "), FALSE, FALSE, 0)
optionsbuttonbox.pack_start(GtkArrow(ARROW_DOWN), FALSE, FALSE, 0)
optionsbuttonbox.show_all()

optionmenu = GtkMenu()
optionmenu.show()
args = (optionmenu, )
_gtk.gtk_signal_connect(optionsbutton._o, "clicked", popup_options, args)
showdots = GtkCheckMenuItem("Show Hidden Files")
optionmenu.append(showdots)
showdots.set_active(showhidden)
showdots.show()
closebutton = GtkButton()
closebutton.set_relief(RELIEF_NONE)
closebutton.add(GnomeStock("Close"))
closebutton.set_usize(22, 22)
buttonbox.pack_end(closebutton, FALSE, FALSE, 2)
closebutton.show_all()
filewindow = GtkScrolledWindow()
filebox.pack_start(filewindow, TRUE, TRUE, 2)
filewindow.set_usize(130, 500)
filewindow.show()
filelist = GtkCList(1)
filewindow.add(filelist)
filelist.show()
filelist.column_titles_show(1)
filelist.set_column_title(0, currentdir)
glimmer.add_paned_object(filebox._o, "FileSelector", 0)
populate_dir_listing(currentdir)
checkitem = GtkCheckMenuItem("File Selector")
checkitem.set_active(TRUE)
checkitem.show()
glimmer.add_widget_to_menu("_View/Status Bar", checkitem._o)

args = (showdots, filelist, )
_gtk.gtk_signal_connect(showdots._o, "toggled", set_show_hidden_files, args)

args = (checkitem, filebox, )
_gtk.gtk_signal_connect(checkitem._o, "toggled", toggle_file_selector, args)
args = (checkitem, filebox, )
_gtk.gtk_signal_connect(closebutton._o, "clicked", close_file_selector, args)
args = (None, )
_gtk.gtk_signal_connect(filelist._o, "select_row", select_row_callback, args)
