;; Silver/theme.jl

;; Copyright (C) 2003 Dj-Death (Lionel Landwerlin) <djdeath@gmx.fr>

;; This theme is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; It is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with sawfish; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;; configuration options

;; main options
(defgroup Silver "Silver Theme"
  :group appearance)

(defcustom Silver:title-font 
  (get-font "-b&h-lucida-bold-r-normal-*-*-120-*-*-p-*-iso8859-1")
  "Font for window titles."
  :group (appearance Silver)
  :type font)

(defcustom Silver:title_height '24
  "Text is justified in window titles."
  :type (get-int)
  :group (appearance Silver))

(let*
    ( ;; *** fonts & colors ********************************************
     (font-colors Silver:title-font)
     
     ;; Buttons
     (close-image (list (make-image "button_close_off.png")
			(make-image "button_close.png")
			(make-image "button_close_pre.png")
			(make-image "button_close_click.png")))
     (max-image (list (make-image "button_max_off.png")
		      (make-image "button_max.png")
		      (make-image "button_max_pre.png")
		      (make-image "button_max_click.png")))
     (menu-image (list (make-image "button_menu_off.png")
		       (make-image "button_menu.png")
		       (make-image "button_menu_pre.png")
		       (make-image "button_menu_click.png")))
     (min-image (list (make-image "button_min_off.png")
		      (make-image "button_min.png")
		      (make-image "button_min_pre.png")
		      (make-image "button_min_click.png")))
     
     ;; Title
     (title-image (list (make-image "title_off.png")
			(make-image "title.png")))
     
     ;; Top
     (top-left-image (list (make-image "top_left_off.png")
			   (make-image "top_left.png")))
     (top-right-image (list (make-image "top_right_off.png")
			    (make-image "top_right.png")))
     (top-left-shaded-image (list (make-image "top_left_shade_off.png")
				  (make-image "top_left_shade.png")))
     (top-right-shaded-image (list (make-image "top_right_shade_off.png")
				   (make-image "top_right_shade.png")))
     
     ;; bottom
     (bottom-left-image (list (make-image "bottom_left_off.png")
			      (make-image "bottom_left.png")))
     (bottom-middle-image (list (make-image "bottom_middle_off.png")
				(make-image "bottom_middle.png")))
     (bottom-right-image (list (make-image "bottom_right_off.png")
			       (make-image "bottom_right.png")))
     
     ;; Border
     (border-left-image (list (make-image "border_left_off.png")
			      (make-image "border_left.png")))
     (border-right-image (list (make-image "border_right_off.png")
			       (make-image "border_right.png")))
     
     (frame `(
	      ((background . ,top-left-image)
	       (top-edge . ,(- 0 Silver:title_height))
	       (left-edge . -4)
	       (height . ,Silver:title_height)
	       (class . title))
	      ((background . ,title-image)
	       (foreground . ,font-colors)
	       (text . ,window-name)
	       (x-justify . center)
	       (y-justify . center)
	       (left-edge . 18)
	       (right-edge . 52)
	       (top-edge . ,(- 0 Silver:title_height))
	       (height . ,Silver:title_height)
	       (cursor . left_ptr)
	       (class . title))
	      ((background . ,top-right-image)
	       (right-edge . -4)
	       (top-edge . ,(- 0 Silver:title_height))
	       (height . ,Silver:title_height)
	       (class . title))
	      
	      ((background . ,border-left-image)
	       (left-edge . -4)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . left-border))
	      ((background . ,border-right-image)
	       (right-edge . -4)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . right-border))
	      
	      ((background . ,bottom-left-image)
	       (left-edge . -4)
	       (bottom-edge . -4)
	       (class . bottom-left-corner))
	      ((background . ,bottom-middle-image)
	       (left-edge . +6)
	       (right-edge . +6)
	       (bottom-edge . -4)
	       (class . bottom-border))
	      ((background . ,bottom-right-image)
	       (right-edge . -4)
	       (bottom-edge . -4)
	       (class . bottom-right-corner))
	      
	      ((background . ,close-image)
	       (right-edge . 1)
	       (top-edge . ,(- 0 Silver:title_height))
	       (height . ,Silver:title_height)
	       (cursor . left_ptr)
	       (class . close-button))
	      ((background . ,max-image)
	       (right-edge . 18)
	       (top-edge . ,(- 0 Silver:title_height))
	       (height . ,Silver:title_height)
	       (cursor . left_ptr)
	       (class . maximize-button))
	      ((background . ,min-image)
	       (right-edge . 35)
	       (top-edge . ,(- 0 Silver:title_height))
	       (height . ,Silver:title_height)
	       (cursor . left_ptr)
	       (class . iconify-button))
	      ((background . ,menu-image)
	       (left-edge . 1)
	       (top-edge . ,(- 0 Silver:title_height))
	       (height . ,Silver:title_height)
	       (cursor . hand2)
	       (class . menu-button))
	      ))
     
     (shaded-frame `(
		     ((background . ,top-left-shaded-image)
		      (top-edge . ,(- 0 Silver:title_height))
		      (left-edge . -4)
		      (height . ,Silver:title_height)
		      (class . title))
		     ((background . ,title-image)
		      (foreground . ,font-colors)
		      (text . ,window-name)
		      (x-justify . center)
		      (y-justify . center)
		      (left-edge . 18)
		      (right-edge . 52)
		      (top-edge . ,(- 0 Silver:title_height))
		      (height . ,Silver:title_height)
		      (cursor . left_ptr)
		      (class . title))
		     ((background . ,top-right-shaded-image)
		      (right-edge . -4)
		      (top-edge . ,(- 0 Silver:title_height))
		      (height . ,Silver:title_height)
		      (class . title))
		     
		     ((background . ,close-image)
		      (right-edge . 1)
		      (top-edge . ,(- 0 Silver:title_height))
		      (height . ,Silver:title_height)
		      (cursor . left_ptr)
		      (class . close-button))
		     ((background . ,max-image)
		      (right-edge . 18)
		      (top-edge . ,(- 0 Silver:title_height))
		      (height . ,Silver:title_height)
		      (cursor . left_ptr)
		      (class . maximize-button))
		     ((background . ,min-image)
		      (right-edge . 35)
		      (top-edge . ,(- 0 Silver:title_height))
		      (height . ,Silver:title_height)
		      (cursor . left_ptr)
		      (class . iconify-button))
		     ((background . ,menu-image)
		      (left-edge . 1)
		      (top-edge . ,(- 0 Silver:title_height))
		      (height . ,Silver:title_height)
		      (cursor . hand2)
		      (class . menu-button))
		     ))
		     
     
     (transient-frame `(
			((background . ,top-left-image)
			 (top-edge . ,(- 0 Silver:title_height))
			 (left-edge . -4)
			 (height . ,Silver:title_height)
			 (class . title))
			((background . ,title-image)
			 (foreground . ,font-colors)
			 (text . ,window-name)
			 (x-justify . center)
			 (y-justify . center)
			 (left-edge . 18)
			 (right-edge . 18)
			 (top-edge . ,(- 0 Silver:title_height))
			 (height . ,Silver:title_height)
			 (cursor . left_ptr)
			 (class . title))
			((background . ,top-right-image)
			 (right-edge . -4)
			 (top-edge . ,(- 0 Silver:title_height))
			 (height . ,Silver:title_height)
			 (class . title))
			
			((background . ,border-left-image)
			 (left-edge . -4)
			 (top-edge . 0)
			 (bottom-edge . 0)
			 (class . left-border))
			((background . ,border-right-image)
			 (right-edge . -4)
			 (top-edge . 0)
			 (bottom-edge . 0)
			 (class . right-border))
			
			((background . ,bottom-left-image)
			 (left-edge . -4)
			 (bottom-edge . -4)
			 (class . bottom-left-corner))
			((background . ,bottom-middle-image)
			 (left-edge . 6)
			 (right-edge . 6)
			 (bottom-edge . -4)
			 (class . bottom-border))
			((background . ,bottom-right-image)
			 (right-edge . -4)
			 (bottom-edge . -4)
			 (class . bottom-right-corner))
			
			((background . ,close-image)
			 (right-edge . 1)
			 (top-edge . ,(- 0 Silver:title_height))
			 (height . ,Silver:title_height)
			 (cursor . left_ptr)
			 (class . close-button))
			((background . ,menu-image)
			 (left-edge . 1)
			 (top-edge . ,(- 0 Silver:title_height))
			 (height . ,Silver:title_height)
			 (cursor . hand2)
			 (class . menu-button))
			))
     
     (shaded-transient-frame `(
			       ((background . ,top-left-shaded-image)
				(top-edge . ,(- 0 Silver:title_height))
				(left-edge . -4)
				(height . ,Silver:title_height)
				(class . title))
			       ((background . ,title-image)
				(foreground . ,font-colors)
				(text . ,window-name)
				(x-justify . center)
				(y-justify . center)
				(left-edge . 18)
				(right-edge . 18)
				(top-edge . ,(- 0 Silver:title_height))
				(height . ,Silver:title_height)
				(cursor . left_ptr)
				(class . title))
			       ((background . ,top-right-shaded-image)
				(right-edge . -4)
				(top-edge . ,(- 0 Silver:title_height))
				(height . ,Silver:title_height)
				(class . title))
			       
			       ((background . ,close-image)
				(right-edge . 1)
				(top-edge . ,(- 0 Silver:title_height))
				(height . ,Silver:title_height)
				(cursor . left_ptr)
				(class . close-button))
			       ((background . ,menu-image)
				(left-edge . 1)
				(top-edge . ,(- 0 Silver:title_height))
				(height . ,Silver:title_height)
				(cursor . hand2)
				(class . menu-button))
			       ))
     
     )
  
  (add-frame-style 'Silver
		   (lambda (w type)
		     (cond 
		      ((eq type 'transient) transient-frame)
		      ((eq type 'shaded-transient) shaded-transient-frame)
		      ((eq type 'shaded) shaded-frame)
		      ((eq type 'unframed) nil-frame)
		      (t frame)))
		   )
  )
  
