/* valaarraytype.c generated by valac, the Vala compiler
 * generated from valaarraytype.vala, do not modify */

/* valaarraytype.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;
typedef struct _ValaReferenceTypePrivate ValaReferenceTypePrivate;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;
typedef struct _ValaArrayTypePrivate ValaArrayTypePrivate;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_ARRAY_LENGTH_FIELD (vala_array_length_field_get_type ())
#define VALA_ARRAY_LENGTH_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthField))
#define VALA_ARRAY_LENGTH_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldClass))
#define VALA_IS_ARRAY_LENGTH_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD))
#define VALA_IS_ARRAY_LENGTH_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_LENGTH_FIELD))
#define VALA_ARRAY_LENGTH_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldClass))

typedef struct _ValaArrayLengthField ValaArrayLengthField;
typedef struct _ValaArrayLengthFieldClass ValaArrayLengthFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_ARRAY_RESIZE_METHOD (vala_array_resize_method_get_type ())
#define VALA_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethod))
#define VALA_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))
#define VALA_IS_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_IS_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_ARRAY_RESIZE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))

typedef struct _ValaArrayResizeMethod ValaArrayResizeMethod;
typedef struct _ValaArrayResizeMethodClass ValaArrayResizeMethodClass;

#define VALA_TYPE_ARRAY_MOVE_METHOD (vala_array_move_method_get_type ())
#define VALA_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethod))
#define VALA_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))
#define VALA_IS_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_IS_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_ARRAY_MOVE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))

typedef struct _ValaArrayMoveMethod ValaArrayMoveMethod;
typedef struct _ValaArrayMoveMethodClass ValaArrayMoveMethodClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_INTEGER_TYPE (vala_integer_type_get_type ())
#define VALA_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerType))
#define VALA_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))
#define VALA_IS_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_TYPE))
#define VALA_IS_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_TYPE))
#define VALA_INTEGER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))

typedef struct _ValaIntegerType ValaIntegerType;
typedef struct _ValaIntegerTypeClass ValaIntegerTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaDataType {
	ValaCodeNode parent_instance;
	ValaDataTypePrivate * priv;
};

struct _ValaDataTypeClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cname) (ValaDataType* self);
	char* (*get_cdeclarator_suffix) (ValaDataType* self);
	char* (*get_lower_case_cname) (ValaDataType* self, const char* infix);
	char* (*to_qualified_string) (ValaDataType* self, ValaScope* scope);
	ValaDataType* (*copy) (ValaDataType* self);
	gboolean (*equals) (ValaDataType* self, ValaDataType* type2);
	gboolean (*stricter) (ValaDataType* self, ValaDataType* type2);
	gboolean (*compatible) (ValaDataType* self, ValaDataType* target_type);
	gboolean (*is_invokable) (ValaDataType* self);
	ValaDataType* (*get_return_type) (ValaDataType* self);
	ValaList* (*get_parameters) (ValaDataType* self);
	gboolean (*is_reference_type_or_type_parameter) (ValaDataType* self);
	gboolean (*is_array) (ValaDataType* self);
	ValaList* (*get_symbols) (ValaDataType* self);
	ValaSymbol* (*get_member) (ValaDataType* self, const char* member_name);
	ValaSymbol* (*get_pointer_member) (ValaDataType* self, const char* member_name);
	gboolean (*is_real_struct_type) (ValaDataType* self);
	char* (*get_type_id) (ValaDataType* self);
	gboolean (*is_disposable) (ValaDataType* self);
	ValaDataType* (*get_actual_type) (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
};

struct _ValaReferenceType {
	ValaDataType parent_instance;
	ValaReferenceTypePrivate * priv;
};

struct _ValaReferenceTypeClass {
	ValaDataTypeClass parent_class;
};

struct _ValaArrayType {
	ValaReferenceType parent_instance;
	ValaArrayTypePrivate * priv;
};

struct _ValaArrayTypeClass {
	ValaReferenceTypeClass parent_class;
};

struct _ValaArrayTypePrivate {
	gboolean _invalid_syntax;
	gboolean _inline_allocated;
	gboolean _fixed_length;
	gint _length;
	gint _rank;
	ValaDataType* _element_type;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_array_type_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_access_get_type (void) G_GNUC_CONST;
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_array_length_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_array_resize_method_get_type (void) G_GNUC_CONST;
GType vala_array_move_method_get_type (void) G_GNUC_CONST;
#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY
};
ValaReferenceType* vala_reference_type_construct (GType object_type);
void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value);
void vala_array_type_set_rank (ValaArrayType* self, gint value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
GType vala_namespace_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaArrayLengthField* vala_array_length_field_new (ValaSourceReference* source_reference);
ValaArrayLengthField* vala_array_length_field_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gint vala_array_type_get_rank (ValaArrayType* self);
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
ValaIntegerType* vala_integer_type_new (ValaStruct* type_symbol, const char* literal_value, const char* literal_type_name);
ValaIntegerType* vala_integer_type_construct (GType object_type, ValaStruct* type_symbol, const char* literal_value, const char* literal_type_name);
GType vala_value_type_get_type (void) G_GNUC_CONST;
GType vala_integer_type_get_type (void) G_GNUC_CONST;
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
ValaArrayResizeMethod* vala_array_resize_method_new (ValaSourceReference* source_reference);
ValaArrayResizeMethod* vala_array_resize_method_construct (GType object_type, ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_new (ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_void_type_get_type (void) G_GNUC_CONST;
void vala_method_set_return_type (ValaMethod* self, ValaDataType* value);
void vala_method_set_cname (ValaMethod* self, const char* cname);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value);
ValaArrayMoveMethod* vala_array_move_method_new (ValaSourceReference* source_reference);
ValaArrayMoveMethod* vala_array_move_method_construct (GType object_type, ValaSourceReference* source_reference);
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_floating_reference (ValaDataType* self);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
gboolean vala_array_type_get_inline_allocated (ValaArrayType* self);
void vala_array_type_set_inline_allocated (ValaArrayType* self, gboolean value);
gboolean vala_array_type_get_fixed_length (ValaArrayType* self);
void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value);
gint vala_array_type_get_length (ValaArrayType* self);
void vala_array_type_set_length (ValaArrayType* self, gint value);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
char* vala_data_type_get_cname (ValaDataType* self);
static char* vala_array_type_real_get_cname (ValaDataType* base);
static char* vala_array_type_real_get_cdeclarator_suffix (ValaDataType* base);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
char* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope);
static char* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
char* vala_data_type_get_type_id (ValaDataType* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
GType vala_pointer_type_get_type (void) G_GNUC_CONST;
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
ValaList* vala_data_type_get_symbols (ValaDataType* self);
static ValaList* vala_array_type_real_get_symbols (ValaDataType* base);
gboolean vala_array_type_get_invalid_syntax (ValaArrayType* self);
void vala_report_error (ValaSourceReference* source, const char* message);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static gboolean vala_array_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static char* vala_array_type_real_get_type_id (ValaDataType* base);
GType vala_generic_type_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_has_type_arguments (ValaDataType* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_array_type_set_invalid_syntax (ValaArrayType* self, gboolean value);
static void vala_array_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	ValaArrayType* self;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) vala_reference_type_construct (object_type);
	vala_array_type_set_element_type (self, element_type);
	vala_array_type_set_rank (self, rank);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}


static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name) {
	ValaArrayType * self;
	ValaSymbol* result = NULL;
	ValaCodeContext* _tmp0_;
	gboolean _tmp1_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	if ((_tmp1_ = vala_code_context_get_profile (_tmp0_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp0_), _tmp1_)) {
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp3_;
		ValaCodeContext* _tmp2_;
		ValaSymbol* _tmp5_;
		result = (_tmp5_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp4_ = vala_scope_lookup (vala_symbol_get_scope (_tmp3_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (_tmp2_ = vala_code_context_get ())), "Dova")), "Array"), member_name), _vala_code_node_unref0 (_tmp4_), _vala_code_node_unref0 (_tmp3_), _vala_code_context_unref0 (_tmp2_), _tmp5_);
		return result;
	} else {
		if (_vala_strcmp0 (member_name, "length") == 0) {
			result = (ValaSymbol*) vala_array_type_get_length_field (self);
			return result;
		} else {
			if (_vala_strcmp0 (member_name, "move") == 0) {
				result = (ValaSymbol*) vala_array_type_get_move_method (self);
				return result;
			} else {
				if (_vala_strcmp0 (member_name, "resize") == 0) {
					result = (ValaSymbol*) vala_array_type_get_resize_method (self);
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self) {
	ValaArrayLengthField* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->length_field == NULL) {
		ValaArrayLengthField* _tmp0_;
		ValaNamespace* root_symbol;
		self->priv->length_field = (_tmp0_ = vala_array_length_field_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _vala_code_node_unref0 (self->priv->length_field), _tmp0_);
		vala_symbol_set_access ((ValaSymbol*) self->priv->length_field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		root_symbol = _vala_code_node_ref0 (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))));
		if (self->priv->_rank > 1) {
			ValaStruct* _tmp1_;
			ValaValueType* _tmp2_;
			ValaValueType* integer;
			ValaArrayType* _tmp3_;
			integer = (_tmp2_ = (ValaValueType*) vala_integer_type_new (_tmp1_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL), _vala_code_node_unref0 (_tmp1_), _tmp2_);
			vala_variable_set_variable_type ((ValaVariable*) self->priv->length_field, (ValaDataType*) (_tmp3_ = vala_array_type_new ((ValaDataType*) integer, 1, vala_code_node_get_source_reference ((ValaCodeNode*) self))));
			_vala_code_node_unref0 (_tmp3_);
			_vala_code_node_unref0 (integer);
		} else {
			ValaIntegerType* _tmp5_;
			ValaStruct* _tmp4_;
			vala_variable_set_variable_type ((ValaVariable*) self->priv->length_field, (ValaDataType*) (_tmp5_ = vala_integer_type_new (_tmp4_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL)));
			_vala_code_node_unref0 (_tmp5_);
			_vala_code_node_unref0 (_tmp4_);
		}
		_vala_code_node_unref0 (root_symbol);
	}
	result = _vala_code_node_ref0 (self->priv->length_field);
	return result;
}


static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self) {
	ValaArrayResizeMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->resize_method == NULL) {
		ValaArrayResizeMethod* _tmp0_;
		ValaVoidType* _tmp1_;
		ValaNamespace* root_symbol;
		ValaStruct* _tmp2_;
		ValaIntegerType* _tmp3_;
		ValaIntegerType* int_type;
		ValaFormalParameter* _tmp4_;
		self->priv->resize_method = (_tmp0_ = vala_array_resize_method_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _vala_code_node_unref0 (self->priv->resize_method), _tmp0_);
		vala_method_set_return_type ((ValaMethod*) self->priv->resize_method, (ValaDataType*) (_tmp1_ = vala_void_type_new (NULL)));
		_vala_code_node_unref0 (_tmp1_);
		vala_symbol_set_access ((ValaSymbol*) self->priv->resize_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->resize_method, "g_renew");
		root_symbol = _vala_code_node_ref0 (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))));
		int_type = (_tmp3_ = vala_integer_type_new (_tmp2_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL), _vala_code_node_unref0 (_tmp2_), _tmp3_);
		vala_method_add_parameter ((ValaMethod*) self->priv->resize_method, _tmp4_ = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL));
		_vala_code_node_unref0 (_tmp4_);
		vala_method_set_returns_modified_pointer ((ValaMethod*) self->priv->resize_method, TRUE);
		_vala_code_node_unref0 (int_type);
		_vala_code_node_unref0 (root_symbol);
	}
	result = _vala_code_node_ref0 (self->priv->resize_method);
	return result;
}


static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self) {
	ValaArrayMoveMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->move_method == NULL) {
		ValaArrayMoveMethod* _tmp0_;
		ValaVoidType* _tmp1_;
		ValaNamespace* root_symbol;
		ValaStruct* _tmp2_;
		ValaIntegerType* _tmp3_;
		ValaIntegerType* int_type;
		ValaFormalParameter* _tmp4_;
		ValaFormalParameter* _tmp5_;
		ValaFormalParameter* _tmp6_;
		self->priv->move_method = (_tmp0_ = vala_array_move_method_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _vala_code_node_unref0 (self->priv->move_method), _tmp0_);
		vala_method_set_return_type ((ValaMethod*) self->priv->move_method, (ValaDataType*) (_tmp1_ = vala_void_type_new (NULL)));
		_vala_code_node_unref0 (_tmp1_);
		vala_symbol_set_access ((ValaSymbol*) self->priv->move_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->move_method, "_vala_array_move");
		root_symbol = _vala_code_node_ref0 (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))));
		int_type = (_tmp3_ = vala_integer_type_new (_tmp2_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL), _vala_code_node_unref0 (_tmp2_), _tmp3_);
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp4_ = vala_formal_parameter_new ("src", (ValaDataType*) int_type, NULL));
		_vala_code_node_unref0 (_tmp4_);
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp5_ = vala_formal_parameter_new ("dest", (ValaDataType*) int_type, NULL));
		_vala_code_node_unref0 (_tmp5_);
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp6_ = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (int_type);
		_vala_code_node_unref0 (root_symbol);
	}
	result = _vala_code_node_ref0 (self->priv->move_method);
	return result;
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	ValaDataType* _tmp0_;
	ValaArrayType* _tmp1_;
	ValaArrayType* _result_;
	self = (ValaArrayType*) base;
	_result_ = (_tmp1_ = vala_array_type_new (_tmp0_ = vala_data_type_copy (vala_array_type_get_element_type (self)), self->priv->_rank, vala_code_node_get_source_reference ((ValaCodeNode*) self)), _vala_code_node_unref0 (_tmp0_), _tmp1_);
	vala_data_type_set_value_owned ((ValaDataType*) _result_, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) _result_, vala_data_type_get_nullable ((ValaDataType*) self));
	vala_data_type_set_floating_reference ((ValaDataType*) _result_, vala_data_type_get_floating_reference ((ValaDataType*) self));
	vala_array_type_set_inline_allocated (_result_, self->priv->_inline_allocated);
	if (self->priv->_fixed_length) {
		vala_array_type_set_fixed_length (_result_, TRUE);
		vala_array_type_set_length (_result_, self->priv->_length);
	}
	result = (ValaDataType*) _result_;
	return result;
}


static char* vala_array_type_real_get_cname (ValaDataType* base) {
	ValaArrayType * self;
	char* result = NULL;
	self = (ValaArrayType*) base;
	if (self->priv->_inline_allocated) {
		result = vala_data_type_get_cname (vala_array_type_get_element_type (self));
		return result;
	} else {
		ValaCodeContext* _tmp0_;
		gboolean _tmp1_;
		if ((_tmp1_ = vala_code_context_get_profile (_tmp0_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp0_), _tmp1_)) {
			result = g_strdup ("DovaArray*");
			return result;
		} else {
			char* _tmp2_;
			char* _tmp3_;
			result = (_tmp3_ = g_strconcat (_tmp2_ = vala_data_type_get_cname (vala_array_type_get_element_type (self)), "*", NULL), _g_free0 (_tmp2_), _tmp3_);
			return result;
		}
	}
}


static char* vala_array_type_real_get_cdeclarator_suffix (ValaDataType* base) {
	ValaArrayType * self;
	char* result = NULL;
	self = (ValaArrayType*) base;
	if (self->priv->_fixed_length) {
		result = g_strdup_printf ("[%d]", self->priv->_length);
		return result;
	} else {
		if (self->priv->_inline_allocated) {
			result = g_strdup ("[]");
			return result;
		} else {
			result = g_strdup ("");
			return result;
		}
	}
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static char* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaArrayType * self;
	char* result = NULL;
	const char* _tmp0_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp3_;
	self = (ValaArrayType*) base;
	_tmp0_ = NULL;
	if (vala_data_type_get_nullable ((ValaDataType*) self)) {
		_tmp0_ = "?";
	} else {
		_tmp0_ = "";
	}
	result = (_tmp3_ = g_strdup_printf ("%s[%s]%s", _tmp1_ = vala_data_type_to_qualified_string (vala_array_type_get_element_type (self), scope), _tmp2_ = g_strnfill ((gsize) (self->priv->_rank - 1), ','), _tmp0_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	return result;
}


static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaArrayType * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	char* _tmp1_;
	gboolean _tmp2_;
	char* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_ = FALSE;
	ValaDataType* _tmp10_;
	ValaArrayType* target_array_type;
	gboolean _tmp11_ = FALSE;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = vala_data_type_get_type_id (target_type), "G_TYPE_VALUE") == 0, _g_free0 (_tmp1_), _tmp2_)) {
		ValaSymbol* _tmp4_;
		ValaCodeContext* _tmp3_;
		_tmp0_ = VALA_SYMBOL (vala_data_type_get_data_type (vala_array_type_get_element_type (self))) == (_tmp4_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (_tmp3_ = vala_code_context_get ())), "string"));
		_vala_code_node_unref0 (_tmp4_);
		_vala_code_context_unref0 (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if ((_tmp6_ = _vala_strcmp0 (_tmp5_ = vala_data_type_get_type_id (target_type), "G_TYPE_VARIANT") == 0, _g_free0 (_tmp5_), _tmp6_)) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		if (vala_data_type_get_data_type (target_type) != NULL) {
			ValaAttribute* _tmp9_;
			_tmp8_ = (_tmp9_ = vala_code_node_get_attribute ((ValaCodeNode*) vala_data_type_get_data_type (target_type), "PointerType")) != NULL;
			_vala_code_node_unref0 (_tmp9_);
		} else {
			_tmp8_ = FALSE;
		}
		_tmp7_ = _tmp8_;
	}
	if (_tmp7_) {
		result = TRUE;
		return result;
	}
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		result = TRUE;
		return result;
	}
	target_array_type = _vala_code_node_ref0 ((_tmp10_ = target_type, VALA_IS_ARRAY_TYPE (_tmp10_) ? ((ValaArrayType*) _tmp10_) : NULL));
	if (target_array_type == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	if (target_array_type->priv->_rank != self->priv->_rank) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	if (vala_data_type_compatible (vala_array_type_get_element_type (self), vala_array_type_get_element_type (target_array_type))) {
		_tmp11_ = vala_data_type_compatible (vala_array_type_get_element_type (target_array_type), vala_array_type_get_element_type (self));
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = TRUE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (target_array_type);
	return result;
}


static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_array_type_get_element_type (self), visitor);
}


static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_array_type_get_element_type (self) == old_type) {
		vala_array_type_set_element_type (self, new_type);
	}
}


static ValaList* vala_array_type_real_get_symbols (ValaDataType* base) {
	ValaArrayType * self;
	ValaList* result = NULL;
	self = (ValaArrayType*) base;
	result = vala_data_type_get_symbols (vala_array_type_get_element_type (self));
	return result;
}


static gboolean vala_array_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (self->priv->_invalid_syntax) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "syntax error, no expression allowed between array brackets");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	result = vala_code_node_check ((ValaCodeNode*) vala_array_type_get_element_type (self), analyzer);
	return result;
}


static char* vala_array_type_real_get_type_id (ValaDataType* base) {
	ValaArrayType * self;
	char* result = NULL;
	ValaSymbol* _tmp1_;
	ValaCodeContext* _tmp0_;
	gboolean _tmp2_;
	self = (ValaArrayType*) base;
	if ((_tmp2_ = VALA_SYMBOL (vala_data_type_get_data_type (vala_array_type_get_element_type (self))) == (_tmp1_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (_tmp0_ = vala_code_context_get ())), "string")), _vala_code_node_unref0 (_tmp1_), _vala_code_context_unref0 (_tmp0_), _tmp2_)) {
		result = g_strdup ("G_TYPE_STRV");
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaArrayType* _result_;
	gboolean _tmp1_ = FALSE;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (node_reference != NULL, NULL);
	if (derived_instance_type == NULL) {
		_tmp0_ = method_access == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = _vala_code_node_ref0 ((ValaDataType*) self);
		return result;
	}
	_result_ = _vala_code_node_ref0 (self);
	if (VALA_IS_GENERIC_TYPE (vala_array_type_get_element_type (self))) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_data_type_has_type_arguments (vala_array_type_get_element_type (self));
	}
	if (_tmp1_) {
		ValaArrayType* _tmp2_;
		ValaDataType* _tmp3_;
		_result_ = (_tmp2_ = VALA_ARRAY_TYPE (vala_data_type_copy ((ValaDataType*) _result_)), _vala_code_node_unref0 (_result_), _tmp2_);
		vala_array_type_set_element_type (_result_, _tmp3_ = vala_data_type_get_actual_type (vala_array_type_get_element_type (_result_), derived_instance_type, method_access, node_reference));
		_vala_code_node_unref0 (_tmp3_);
	}
	result = (ValaDataType*) _result_;
	return result;
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_element_type;
	return result;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_element_type = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_element_type), _tmp0_);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_element_type, (ValaCodeNode*) self);
}


gboolean vala_array_type_get_invalid_syntax (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_invalid_syntax;
	return result;
}


void vala_array_type_set_invalid_syntax (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_invalid_syntax = value;
}


gboolean vala_array_type_get_inline_allocated (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inline_allocated;
	return result;
}


void vala_array_type_set_inline_allocated (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_inline_allocated = value;
}


gboolean vala_array_type_get_fixed_length (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fixed_length;
	return result;
}


void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_fixed_length = value;
}


gint vala_array_type_get_length (ValaArrayType* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_length;
	return result;
}


void vala_array_type_set_length (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_array_type_real_get_member;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_array_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_cdeclarator_suffix = vala_array_type_real_get_cdeclarator_suffix;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_array_type_real_is_array;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_array_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_array_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type_or_type_parameter = vala_array_type_real_is_reference_type_or_type_parameter;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_type_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_type_real_replace_type;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_array_type_real_get_symbols;
	VALA_CODE_NODE_CLASS (klass)->check = vala_array_type_real_check;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_array_type_real_get_type_id;
	VALA_DATA_TYPE_CLASS (klass)->get_actual_type = vala_array_type_real_get_actual_type;
}


static void vala_array_type_instance_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_finalize (ValaCodeNode* obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->length_field);
	_vala_code_node_unref0 (self->priv->resize_method);
	_vala_code_node_unref0 (self->priv->move_method);
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}


/**
 * An array type.
 */
GType vala_array_type_get_type (void) {
	static volatile gsize vala_array_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
		GType vala_array_type_type_id;
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_type_type_id__volatile, vala_array_type_type_id);
	}
	return vala_array_type_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




