/* gcomment.c generated by valac, the Vala compiler
 * generated from gcomment.vala, do not modify */

/* gcomment.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <valagee.h>
#include <valadoc.h>
#include <gobject/gvaluecollector.h>


#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
typedef struct _GtkdocHeaderPrivate GtkdocHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocParamSpecHeader GtkdocParamSpecHeader;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;
typedef struct _GtkdocGCommentPrivate GtkdocGCommentPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocParamSpecGComment GtkdocParamSpecGComment;

struct _GtkdocHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar** annotations;
	gint annotations_length1;
	gchar* value;
	gdouble pos;
	gboolean block;
	GtkdocHeaderPrivate * priv;
};

struct _GtkdocHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocHeader *self);
};

struct _GtkdocParamSpecHeader {
	GParamSpec parent_instance;
};

struct _GtkdocGComment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* symbol;
	gchar** symbol_annotations;
	gint symbol_annotations_length1;
	ValaList* headers;
	gboolean short_description;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	gchar** returns_annotations;
	gint returns_annotations_length1;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	gboolean is_section;
	GtkdocGCommentPrivate * priv;
};

struct _GtkdocGCommentClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGComment *self);
};

struct _GtkdocParamSpecGComment {
	GParamSpec parent_instance;
};


static gpointer gtkdoc_header_parent_class = NULL;
static gpointer gtkdoc_gcomment_parent_class = NULL;

gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
gint gtkdoc_header_cmp (GtkdocHeader* self,
                        GtkdocHeader* header);
static void gtkdoc_header_finalize (GtkdocHeader * obj);
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
gchar* gtkdoc_gcomment_to_string (GtkdocGComment* self);
gchar* gtkdoc_commentize (const gchar* comment);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
GtkdocGComment* gtkdoc_gcomment_new (void);
GtkdocGComment* gtkdoc_gcomment_construct (GType object_type);
static void gtkdoc_gcomment_finalize (GtkdocGComment * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GtkdocHeader*
gtkdoc_header_construct (GType object_type,
                         const gchar* name,
                         const gchar* value,
                         gdouble pos,
                         gboolean block)
{
	GtkdocHeader* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocHeader*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp1_;
	self->pos = pos;
	self->block = block;
	return self;
}


GtkdocHeader*
gtkdoc_header_new (const gchar* name,
                   const gchar* value,
                   gdouble pos,
                   gboolean block)
{
	return gtkdoc_header_construct (GTKDOC_TYPE_HEADER, name, value, pos, block);
}


gint
gtkdoc_header_cmp (GtkdocHeader* self,
                   GtkdocHeader* header)
{
	gint result = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (header != NULL, 0);
	_tmp0_ = self->pos;
	_tmp1_ = header->pos;
	if (_tmp0_ > _tmp1_) {
		result = 1;
		return result;
	} else {
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp2_ = self->pos;
		_tmp3_ = header->pos;
		if (_tmp2_ < _tmp3_) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}


static void
gtkdoc_value_header_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_value_header_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_header_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_value_header_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_header_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_value_header_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_value_header_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocHeader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_header_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_value_header_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	GtkdocHeader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_header_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_param_spec_header (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	GtkdocParamSpecHeader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_HEADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_value_get_header (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_value_set_header (GValue* value,
                         gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_header_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}


void
gtkdoc_value_take_header (GValue* value,
                          gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}


static void
gtkdoc_header_class_init (GtkdocHeaderClass * klass)
{
	gtkdoc_header_parent_class = g_type_class_peek_parent (klass);
	((GtkdocHeaderClass *) klass)->finalize = gtkdoc_header_finalize;
}


static void
gtkdoc_header_instance_init (GtkdocHeader * self)
{
	self->ref_count = 1;
}


static void
gtkdoc_header_finalize (GtkdocHeader * obj)
{
	GtkdocHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_HEADER, GtkdocHeader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->value);
}


GType
gtkdoc_header_get_type (void)
{
	static volatile gsize gtkdoc_header_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_header_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_header_init, gtkdoc_value_header_free_value, gtkdoc_value_header_copy_value, gtkdoc_value_header_peek_pointer, "p", gtkdoc_value_header_collect_value, "p", gtkdoc_value_header_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocHeader), 0, (GInstanceInitFunc) gtkdoc_header_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_header_type_id;
		gtkdoc_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_header_type_id__volatile, gtkdoc_header_type_id);
	}
	return gtkdoc_header_type_id__volatile;
}


gpointer
gtkdoc_header_ref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_header_unref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_HEADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


gchar*
gtkdoc_gcomment_to_string (GtkdocGComment* self)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	ValaList* _tmp21_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_;
	const gchar* _tmp62_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	gboolean _tmp72_ = FALSE;
	const gchar* _tmp73_;
	ValaList* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	GString* _tmp114_;
	GString* _tmp115_;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp2_ = self->is_section;
	if (_tmp2_) {
		_tmp1_ = "SECTION:%s";
	} else {
		_tmp1_ = "%s:";
	}
	_tmp3_ = builder;
	_tmp4_ = self->symbol;
	_tmp5_ = g_strdup_printf (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	g_string_append_printf (_tmp3_, "/**\n * %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp8_ = self->symbol_annotations;
	_tmp8__length1 = self->symbol_annotations_length1;
	if (_tmp8_ != NULL) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = self->symbol_annotations;
		_tmp9__length1 = self->symbol_annotations_length1;
		_tmp7_ = _tmp9__length1 > 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = self->symbol_annotations;
		_tmp10__length1 = self->symbol_annotations_length1;
		{
			gchar** annotation_collection = NULL;
			gint annotation_collection_length1 = 0;
			gint _annotation_collection_size_ = 0;
			gint annotation_it = 0;
			annotation_collection = _tmp10_;
			annotation_collection_length1 = _tmp10__length1;
			for (annotation_it = 0; annotation_it < _tmp10__length1; annotation_it = annotation_it + 1) {
				gchar* _tmp11_;
				gchar* annotation = NULL;
				_tmp11_ = g_strdup (annotation_collection[annotation_it]);
				annotation = _tmp11_;
				{
					GString* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = builder;
					_tmp13_ = annotation;
					g_string_append_printf (_tmp12_, " (%s)", _tmp13_);
					_g_free0 (annotation);
				}
			}
		}
	}
	_tmp15_ = self->short_description;
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = self->brief_comment;
		_tmp14_ = _tmp16_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GString* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = builder;
		_tmp18_ = self->brief_comment;
		_tmp19_ = gtkdoc_commentize (_tmp18_);
		_tmp20_ = _tmp19_;
		g_string_append_printf (_tmp17_, "\n * @short_description: %s", _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = self->headers;
	vala_list_sort (_tmp21_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp22_;
		ValaList* _tmp23_;
		gint _header_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _header_index = 0;
		_tmp22_ = self->headers;
		_tmp23_ = _vala_iterable_ref0 (_tmp22_);
		_header_list = _tmp23_;
		_tmp24_ = _header_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_header_size = _tmp26_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			GString* _tmp33_;
			GtkdocHeader* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
			GtkdocHeader* _tmp37_;
			gchar** _tmp38_;
			gint _tmp38__length1;
			GtkdocHeader* _tmp47_;
			const gchar* _tmp48_;
			_tmp27_ = _header_index;
			_header_index = _tmp27_ + 1;
			_tmp28_ = _header_index;
			_tmp29_ = _header_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _header_list;
			_tmp31_ = _header_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			header = (GtkdocHeader*) _tmp32_;
			_tmp33_ = builder;
			_tmp34_ = header;
			_tmp35_ = _tmp34_->name;
			g_string_append_printf (_tmp33_, "\n * @%s:", _tmp35_);
			_tmp37_ = header;
			_tmp38_ = _tmp37_->annotations;
			_tmp38__length1 = _tmp37_->annotations_length1;
			if (_tmp38_ != NULL) {
				GtkdocHeader* _tmp39_;
				gchar** _tmp40_;
				gint _tmp40__length1;
				_tmp39_ = header;
				_tmp40_ = _tmp39_->annotations;
				_tmp40__length1 = _tmp39_->annotations_length1;
				_tmp36_ = _tmp40__length1 > 0;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				GtkdocHeader* _tmp41_;
				gchar** _tmp42_;
				gint _tmp42__length1;
				GString* _tmp46_;
				_tmp41_ = header;
				_tmp42_ = _tmp41_->annotations;
				_tmp42__length1 = _tmp41_->annotations_length1;
				{
					gchar** annotation_collection = NULL;
					gint annotation_collection_length1 = 0;
					gint _annotation_collection_size_ = 0;
					gint annotation_it = 0;
					annotation_collection = _tmp42_;
					annotation_collection_length1 = _tmp42__length1;
					for (annotation_it = 0; annotation_it < _tmp42__length1; annotation_it = annotation_it + 1) {
						gchar* _tmp43_;
						gchar* annotation = NULL;
						_tmp43_ = g_strdup (annotation_collection[annotation_it]);
						annotation = _tmp43_;
						{
							GString* _tmp44_;
							const gchar* _tmp45_;
							_tmp44_ = builder;
							_tmp45_ = annotation;
							g_string_append_printf (_tmp44_, " (%s)", _tmp45_);
							_g_free0 (annotation);
						}
					}
				}
				_tmp46_ = builder;
				g_string_append_c (_tmp46_, ':');
			}
			_tmp47_ = header;
			_tmp48_ = _tmp47_->value;
			if (_tmp48_ != NULL) {
				GString* _tmp49_;
				GString* _tmp50_;
				GtkdocHeader* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = builder;
				g_string_append_c (_tmp49_, ' ');
				_tmp50_ = builder;
				_tmp51_ = header;
				_tmp52_ = _tmp51_->value;
				_tmp53_ = gtkdoc_commentize (_tmp52_);
				_tmp54_ = _tmp53_;
				g_string_append (_tmp50_, _tmp54_);
				_g_free0 (_tmp54_);
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp56_ = self->short_description;
	if (!_tmp56_) {
		const gchar* _tmp57_;
		_tmp57_ = self->brief_comment;
		_tmp55_ = _tmp57_ != NULL;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		GString* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp58_ = builder;
		_tmp59_ = self->brief_comment;
		_tmp60_ = gtkdoc_commentize (_tmp59_);
		_tmp61_ = _tmp60_;
		g_string_append_printf (_tmp58_, "\n * \n * %s", _tmp61_);
		_g_free0 (_tmp61_);
	}
	_tmp62_ = self->long_comment;
	if (_tmp62_ != NULL) {
		GString* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp63_ = builder;
		_tmp64_ = self->long_comment;
		_tmp65_ = gtkdoc_commentize (_tmp64_);
		_tmp66_ = _tmp65_;
		g_string_append_printf (_tmp63_, "\n * \n * %s", _tmp66_);
		_g_free0 (_tmp66_);
	}
	_tmp67_ = self->see_also;
	_tmp67__length1 = self->see_also_length1;
	if (_tmp67__length1 > 0) {
		GString* _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp68_ = builder;
		_tmp69_ = self->see_also;
		_tmp69__length1 = self->see_also_length1;
		_tmp70_ = _vala_g_strjoinv (", ", _tmp69_, _tmp69__length1);
		_tmp71_ = _tmp70_;
		g_string_append_printf (_tmp68_, "\n * \n * <emphasis>See also</emphasis>: %s", _tmp71_);
		_g_free0 (_tmp71_);
	}
	_tmp73_ = self->returns;
	if (_tmp73_ != NULL) {
		_tmp72_ = TRUE;
	} else {
		gchar** _tmp74_;
		gint _tmp74__length1;
		_tmp74_ = self->returns_annotations;
		_tmp74__length1 = self->returns_annotations_length1;
		_tmp72_ = _tmp74__length1 > 0;
	}
	if (_tmp72_) {
		GString* _tmp75_;
		gchar** _tmp76_;
		gint _tmp76__length1;
		GString* _tmp83_;
		const gchar* _tmp84_;
		_tmp75_ = builder;
		g_string_append (_tmp75_, "\n * \n * Returns:");
		_tmp76_ = self->returns_annotations;
		_tmp76__length1 = self->returns_annotations_length1;
		if (_tmp76_ != NULL) {
			gchar** _tmp77_;
			gint _tmp77__length1;
			gchar** _tmp81_;
			gint _tmp81__length1;
			_tmp77_ = self->returns_annotations;
			_tmp77__length1 = self->returns_annotations_length1;
			{
				gchar** annotation_collection = NULL;
				gint annotation_collection_length1 = 0;
				gint _annotation_collection_size_ = 0;
				gint annotation_it = 0;
				annotation_collection = _tmp77_;
				annotation_collection_length1 = _tmp77__length1;
				for (annotation_it = 0; annotation_it < _tmp77__length1; annotation_it = annotation_it + 1) {
					gchar* _tmp78_;
					gchar* annotation = NULL;
					_tmp78_ = g_strdup (annotation_collection[annotation_it]);
					annotation = _tmp78_;
					{
						GString* _tmp79_;
						const gchar* _tmp80_;
						_tmp79_ = builder;
						_tmp80_ = annotation;
						g_string_append_printf (_tmp79_, " (%s)", _tmp80_);
						_g_free0 (annotation);
					}
				}
			}
			_tmp81_ = self->returns_annotations;
			_tmp81__length1 = self->returns_annotations_length1;
			if (_tmp81__length1 > 0) {
				GString* _tmp82_;
				_tmp82_ = builder;
				g_string_append_c (_tmp82_, ':');
			}
		}
		_tmp83_ = builder;
		g_string_append_c (_tmp83_, ' ');
		_tmp84_ = self->returns;
		if (_tmp84_ != NULL) {
			GString* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			_tmp85_ = builder;
			_tmp86_ = self->returns;
			_tmp87_ = gtkdoc_commentize (_tmp86_);
			_tmp88_ = _tmp87_;
			g_string_append (_tmp85_, _tmp88_);
			_g_free0 (_tmp88_);
		}
	}
	_tmp89_ = self->versioning;
	_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_ > 0) {
		GString* _tmp92_;
		_tmp92_ = builder;
		g_string_append (_tmp92_, "\n *");
		{
			ValaList* _version_list = NULL;
			ValaList* _tmp93_;
			ValaList* _tmp94_;
			gint _version_size = 0;
			ValaList* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			gint _version_index = 0;
			_tmp93_ = self->versioning;
			_tmp94_ = _vala_iterable_ref0 (_tmp93_);
			_version_list = _tmp94_;
			_tmp95_ = _version_list;
			_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
			_tmp97_ = _tmp96_;
			_version_size = _tmp97_;
			_version_index = -1;
			while (TRUE) {
				gint _tmp98_;
				gint _tmp99_;
				gint _tmp100_;
				GtkdocHeader* version = NULL;
				ValaList* _tmp101_;
				gint _tmp102_;
				gpointer _tmp103_;
				GString* _tmp104_;
				GtkdocHeader* _tmp105_;
				const gchar* _tmp106_;
				GtkdocHeader* _tmp107_;
				const gchar* _tmp108_;
				_tmp98_ = _version_index;
				_version_index = _tmp98_ + 1;
				_tmp99_ = _version_index;
				_tmp100_ = _version_size;
				if (!(_tmp99_ < _tmp100_)) {
					break;
				}
				_tmp101_ = _version_list;
				_tmp102_ = _version_index;
				_tmp103_ = vala_list_get (_tmp101_, _tmp102_);
				version = (GtkdocHeader*) _tmp103_;
				_tmp104_ = builder;
				_tmp105_ = version;
				_tmp106_ = _tmp105_->name;
				g_string_append_printf (_tmp104_, "\n * %s:", _tmp106_);
				_tmp107_ = version;
				_tmp108_ = _tmp107_->value;
				if (_tmp108_ != NULL) {
					GString* _tmp109_;
					GtkdocHeader* _tmp110_;
					const gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					_tmp109_ = builder;
					_tmp110_ = version;
					_tmp111_ = _tmp110_->value;
					_tmp112_ = gtkdoc_commentize (_tmp111_);
					_tmp113_ = _tmp112_;
					g_string_append_printf (_tmp109_, " %s", _tmp113_);
					_g_free0 (_tmp113_);
				}
				_gtkdoc_header_unref0 (version);
			}
			_vala_iterable_unref0 (_version_list);
		}
	}
	_tmp114_ = builder;
	g_string_append (_tmp114_, "\n */");
	_tmp115_ = builder;
	_tmp116_ = _tmp115_->str;
	_tmp117_ = g_strdup (_tmp116_);
	result = _tmp117_;
	_g_string_free0 (builder);
	return result;
}


gchar*
gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                            ValadocErrorReporter* reporter)
{
	gchar* result = NULL;
	gchar* deprecated = NULL;
	gchar* since = NULL;
	GString* builder = NULL;
	GString* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp28_;
	const gchar* _tmp31_;
	ValaList* _tmp34_;
	gboolean _tmp35_ = FALSE;
	ValaList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	const gchar* _tmp61_;
	GString* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	deprecated = NULL;
	since = NULL;
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _header_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _header_index = 0;
		_tmp0_ = self->versioning;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_header_list = _tmp1_;
		_tmp2_ = _header_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_header_size = _tmp4_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkdocHeader* _tmp11_;
			const gchar* _tmp12_;
			_tmp5_ = _header_index;
			_header_index = _tmp5_ + 1;
			_tmp6_ = _header_index;
			_tmp7_ = _header_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _header_list;
			_tmp9_ = _header_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			header = (GtkdocHeader*) _tmp10_;
			_tmp11_ = header;
			_tmp12_ = _tmp11_->name;
			if (g_strcmp0 (_tmp12_, "Deprecated") == 0) {
				GtkdocHeader* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = header;
				_tmp14_ = _tmp13_->value;
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (deprecated);
				deprecated = _tmp15_;
			} else {
				GtkdocHeader* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = header;
				_tmp17_ = _tmp16_->name;
				if (g_strcmp0 (_tmp17_, "Since") == 0) {
					GtkdocHeader* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp18_ = header;
					_tmp19_ = _tmp18_->value;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (since);
					since = _tmp20_;
				} else {
					GtkdocHeader* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = header;
					_tmp22_ = _tmp21_->name;
					valadoc_error_reporter_simple_warning (reporter, "GtkDoc", "Unknown versioning tag '%s'", _tmp22_);
				}
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp23_ = g_string_new ("");
	builder = _tmp23_;
	_tmp24_ = deprecated;
	if (_tmp24_ != NULL) {
		GString* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp25_ = builder;
		_tmp26_ = self->symbol;
		_tmp27_ = deprecated;
		g_string_append_printf (_tmp25_, "<warning><para><literal>%s</literal> is deprecated and should not be u" \
"sed in newly-written code. %s</para></warning>", _tmp26_, _tmp27_);
	}
	_tmp28_ = self->brief_comment;
	if (_tmp28_ != NULL) {
		GString* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = builder;
		_tmp30_ = self->brief_comment;
		g_string_append_printf (_tmp29_, "<para>%s</para>", _tmp30_);
	}
	_tmp31_ = self->long_comment;
	if (_tmp31_ != NULL) {
		GString* _tmp32_;
		const gchar* _tmp33_;
		_tmp32_ = builder;
		_tmp33_ = self->long_comment;
		g_string_append (_tmp32_, _tmp33_);
	}
	_tmp34_ = self->headers;
	vala_list_sort (_tmp34_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	_tmp36_ = self->headers;
	_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		_tmp35_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = self->returns;
		_tmp35_ = _tmp39_ != NULL;
	}
	if (_tmp35_) {
		GString* _tmp40_;
		const gchar* _tmp57_;
		GString* _tmp60_;
		_tmp40_ = builder;
		g_string_append (_tmp40_, "<variablelist role=\"params\">");
		{
			ValaList* _header_list = NULL;
			ValaList* _tmp41_;
			ValaList* _tmp42_;
			gint _header_size = 0;
			ValaList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _header_index = 0;
			_tmp41_ = self->headers;
			_tmp42_ = _vala_iterable_ref0 (_tmp41_);
			_header_list = _tmp42_;
			_tmp43_ = _header_list;
			_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_header_size = _tmp45_;
			_header_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				GtkdocHeader* header = NULL;
				ValaList* _tmp49_;
				gint _tmp50_;
				gpointer _tmp51_;
				GString* _tmp52_;
				GtkdocHeader* _tmp53_;
				const gchar* _tmp54_;
				GtkdocHeader* _tmp55_;
				const gchar* _tmp56_;
				_tmp46_ = _header_index;
				_header_index = _tmp46_ + 1;
				_tmp47_ = _header_index;
				_tmp48_ = _header_size;
				if (!(_tmp47_ < _tmp48_)) {
					break;
				}
				_tmp49_ = _header_list;
				_tmp50_ = _header_index;
				_tmp51_ = vala_list_get (_tmp49_, _tmp50_);
				header = (GtkdocHeader*) _tmp51_;
				_tmp52_ = builder;
				_tmp53_ = header;
				_tmp54_ = _tmp53_->name;
				_tmp55_ = header;
				_tmp56_ = _tmp55_->value;
				g_string_append_printf (_tmp52_, "<varlistentry><term><parameter>%s</parameter>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp54_, _tmp56_);
				_gtkdoc_header_unref0 (header);
			}
			_vala_iterable_unref0 (_header_list);
		}
		_tmp57_ = self->returns;
		if (_tmp57_ != NULL) {
			GString* _tmp58_;
			const gchar* _tmp59_;
			_tmp58_ = builder;
			_tmp59_ = self->returns;
			g_string_append_printf (_tmp58_, "<varlistentry><term><emphasis>Returns</emphasis>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp59_);
		}
		_tmp60_ = builder;
		g_string_append (_tmp60_, "</variablelist>");
	}
	_tmp61_ = since;
	if (_tmp61_ != NULL) {
		GString* _tmp62_;
		const gchar* _tmp63_;
		_tmp62_ = builder;
		_tmp63_ = since;
		g_string_append_printf (_tmp62_, "<para role=\"since\">Since %s</para>", _tmp63_);
	}
	_tmp64_ = builder;
	_tmp65_ = _tmp64_->str;
	_tmp66_ = g_strdup (_tmp65_);
	result = _tmp66_;
	_g_string_free0 (builder);
	_g_free0 (since);
	_g_free0 (deprecated);
	return result;
}


GtkdocGComment*
gtkdoc_gcomment_construct (GType object_type)
{
	GtkdocGComment* self = NULL;
	self = (GtkdocGComment*) g_type_create_instance (object_type);
	return self;
}


GtkdocGComment*
gtkdoc_gcomment_new (void)
{
	return gtkdoc_gcomment_construct (GTKDOC_TYPE_GCOMMENT);
}


static void
gtkdoc_value_gcomment_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
gtkdoc_value_gcomment_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_gcomment_unref (value->data[0].v_pointer);
	}
}


static void
gtkdoc_value_gcomment_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_gcomment_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
gtkdoc_value_gcomment_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
gtkdoc_value_gcomment_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocGComment * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_gcomment_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
gtkdoc_value_gcomment_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	GtkdocGComment ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_gcomment_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
gtkdoc_param_spec_gcomment (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	GtkdocParamSpecGComment* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_GCOMMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
gtkdoc_value_get_gcomment (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT), NULL);
	return value->data[0].v_pointer;
}


void
gtkdoc_value_set_gcomment (GValue* value,
                           gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_gcomment_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}


void
gtkdoc_value_take_gcomment (GValue* value,
                            gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}


static void
gtkdoc_gcomment_class_init (GtkdocGCommentClass * klass)
{
	gtkdoc_gcomment_parent_class = g_type_class_peek_parent (klass);
	((GtkdocGCommentClass *) klass)->finalize = gtkdoc_gcomment_finalize;
}


static void
gtkdoc_gcomment_instance_init (GtkdocGComment * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->headers = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	self->ref_count = 1;
}


static void
gtkdoc_gcomment_finalize (GtkdocGComment * obj)
{
	GtkdocGComment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_GCOMMENT, GtkdocGComment);
	g_signal_handlers_destroy (self);
	_g_free0 (self->symbol);
	self->symbol_annotations = (_vala_array_free (self->symbol_annotations, self->symbol_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->headers);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	self->returns_annotations = (_vala_array_free (self->returns_annotations, self->returns_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
}


GType
gtkdoc_gcomment_get_type (void)
{
	static volatile gsize gtkdoc_gcomment_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_gcomment_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_gcomment_init, gtkdoc_value_gcomment_free_value, gtkdoc_value_gcomment_copy_value, gtkdoc_value_gcomment_peek_pointer, "p", gtkdoc_value_gcomment_collect_value, "p", gtkdoc_value_gcomment_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocGCommentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_gcomment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGComment), 0, (GInstanceInitFunc) gtkdoc_gcomment_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_gcomment_type_id;
		gtkdoc_gcomment_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocGComment", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_gcomment_type_id__volatile, gtkdoc_gcomment_type_id);
	}
	return gtkdoc_gcomment_type_id__volatile;
}


gpointer
gtkdoc_gcomment_ref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
gtkdoc_gcomment_unref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_GCOMMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



