/* hashset.c generated by valac, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define VALA_TYPE_ITERABLE (vala_iterable_get_type ())
#define VALA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERABLE, ValaIterable))
#define VALA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERABLE, ValaIterableClass))
#define VALA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERABLE))
#define VALA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERABLE))
#define VALA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERABLE, ValaIterableClass))

typedef struct _ValaIterable ValaIterable;
typedef struct _ValaIterableClass ValaIterableClass;
typedef struct _ValaIterablePrivate ValaIterablePrivate;

#define VALA_TYPE_ITERATOR (vala_iterator_get_type ())
#define VALA_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERATOR, ValaIterator))
#define VALA_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERATOR, ValaIteratorClass))
#define VALA_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERATOR))
#define VALA_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERATOR))
#define VALA_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERATOR, ValaIteratorClass))

typedef struct _ValaIterator ValaIterator;
typedef struct _ValaIteratorClass ValaIteratorClass;

#define VALA_TYPE_COLLECTION (vala_collection_get_type ())
#define VALA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COLLECTION, ValaCollection))
#define VALA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COLLECTION, ValaCollectionClass))
#define VALA_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COLLECTION))
#define VALA_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COLLECTION))
#define VALA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COLLECTION, ValaCollectionClass))

typedef struct _ValaCollection ValaCollection;
typedef struct _ValaCollectionClass ValaCollectionClass;
typedef struct _ValaCollectionPrivate ValaCollectionPrivate;

#define VALA_TYPE_SET (vala_set_get_type ())
#define VALA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SET, ValaSet))
#define VALA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SET, ValaSetClass))
#define VALA_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SET))
#define VALA_IS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SET))
#define VALA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SET, ValaSetClass))

typedef struct _ValaSet ValaSet;
typedef struct _ValaSetClass ValaSetClass;
typedef struct _ValaSetPrivate ValaSetPrivate;

#define VALA_TYPE_HASH_SET (vala_hash_set_get_type ())
#define VALA_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_HASH_SET, ValaHashSet))
#define VALA_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_HASH_SET, ValaHashSetClass))
#define VALA_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_HASH_SET))
#define VALA_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_HASH_SET))
#define VALA_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_HASH_SET, ValaHashSetClass))

typedef struct _ValaHashSet ValaHashSet;
typedef struct _ValaHashSetClass ValaHashSetClass;
typedef struct _ValaHashSetPrivate ValaHashSetPrivate;
typedef struct _ValaHashSetNode ValaHashSetNode;

#define VALA_HASH_SET_TYPE_ITERATOR (vala_hash_set_iterator_get_type ())
#define VALA_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIterator))
#define VALA_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIteratorClass))
#define VALA_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_SET_TYPE_ITERATOR))
#define VALA_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_SET_TYPE_ITERATOR))
#define VALA_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIteratorClass))

typedef struct _ValaHashSetIterator ValaHashSetIterator;
typedef struct _ValaHashSetIteratorClass ValaHashSetIteratorClass;
#define _vala_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (vala_hash_set_node_free (var), NULL)))
typedef struct _ValaIteratorPrivate ValaIteratorPrivate;
typedef struct _ValaHashSetIteratorPrivate ValaHashSetIteratorPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaIterable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIterablePrivate * priv;
};

struct _ValaIterableClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterable *self);
	GType (*get_element_type) (ValaIterable* self);
	ValaIterator* (*iterator) (ValaIterable* self);
};

struct _ValaCollection {
	ValaIterable parent_instance;
	ValaCollectionPrivate * priv;
};

struct _ValaCollectionClass {
	ValaIterableClass parent_class;
	gboolean (*contains) (ValaCollection* self, gconstpointer item);
	gboolean (*add) (ValaCollection* self, gconstpointer item);
	gboolean (*remove) (ValaCollection* self, gconstpointer item);
	void (*clear) (ValaCollection* self);
	gint (*get_size) (ValaCollection* self);
};

struct _ValaSet {
	ValaCollection parent_instance;
	ValaSetPrivate * priv;
};

struct _ValaSetClass {
	ValaCollectionClass parent_class;
};

struct _ValaHashSet {
	ValaSet parent_instance;
	ValaHashSetPrivate * priv;
};

struct _ValaHashSetClass {
	ValaSetClass parent_class;
};

struct _ValaHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _array_size;
	gint _nnodes;
	ValaHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
	GHashFunc _hash_func;
	GEqualFunc _equal_func;
};

struct _ValaHashSetNode {
	gpointer key;
	ValaHashSetNode* next;
	guint key_hash;
};

struct _ValaIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIteratorPrivate * priv;
};

struct _ValaIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterator *self);
	gboolean (*next) (ValaIterator* self);
	gpointer (*get) (ValaIterator* self);
};

struct _ValaHashSetIterator {
	ValaIterator parent_instance;
	ValaHashSetIteratorPrivate * priv;
};

struct _ValaHashSetIteratorClass {
	ValaIteratorClass parent_class;
};

struct _ValaHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	ValaHashSet* _set;
	gint _index;
	ValaHashSetNode* _node;
	gint _stamp;
};


static gpointer vala_hash_set_parent_class = NULL;
static gpointer vala_hash_set_iterator_parent_class = NULL;

gpointer vala_iterable_ref (gpointer instance);
void vala_iterable_unref (gpointer instance);
GParamSpec* vala_param_spec_iterable (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterable (GValue* value, gpointer v_object);
void vala_value_take_iterable (GValue* value, gpointer v_object);
gpointer vala_value_get_iterable (const GValue* value);
GType vala_iterable_get_type (void) G_GNUC_CONST;
gpointer vala_iterator_ref (gpointer instance);
void vala_iterator_unref (gpointer instance);
GParamSpec* vala_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterator (GValue* value, gpointer v_object);
void vala_value_take_iterator (GValue* value, gpointer v_object);
gpointer vala_value_get_iterator (const GValue* value);
GType vala_iterator_get_type (void) G_GNUC_CONST;
GType vala_collection_get_type (void) G_GNUC_CONST;
GType vala_set_get_type (void) G_GNUC_CONST;
GType vala_hash_set_get_type (void) G_GNUC_CONST;
static void vala_hash_set_node_free (ValaHashSetNode* self);
#define VALA_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_HASH_SET, ValaHashSetPrivate))
enum  {
	VALA_HASH_SET_DUMMY_PROPERTY
};
void vala_collection_clear (ValaCollection* self);
#define VALA_HASH_SET_MIN_SIZE 11
#define VALA_HASH_SET_MAX_SIZE 13845163
ValaHashSet* vala_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
ValaHashSet* vala_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
ValaSet* vala_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
void vala_hash_set_set_hash_func (ValaHashSet* self, GHashFunc value);
void vala_hash_set_set_equal_func (ValaHashSet* self, GEqualFunc value);
static ValaHashSetNode** vala_hash_set_lookup_node (ValaHashSet* self, gconstpointer key);
static gboolean vala_hash_set_real_contains (ValaCollection* base, gconstpointer key);
static GType vala_hash_set_real_get_element_type (ValaIterable* base);
static ValaIterator* vala_hash_set_real_iterator (ValaIterable* base);
static ValaHashSetIterator* vala_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set);
static ValaHashSetIterator* vala_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set);
static GType vala_hash_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_hash_set_real_add (ValaCollection* base, gconstpointer key);
static ValaHashSetNode* vala_hash_set_node_new (gpointer k, guint hash);
static ValaHashSetNode* vala_hash_set_node_new (gpointer k, guint hash);
static void vala_hash_set_resize (ValaHashSet* self);
static gboolean vala_hash_set_real_remove (ValaCollection* base, gconstpointer key);
static void vala_hash_set_real_clear (ValaCollection* base);
static void vala_hash_set_node_instance_init (ValaHashSetNode * self);
#define VALA_HASH_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIteratorPrivate))
enum  {
	VALA_HASH_SET_ITERATOR_DUMMY_PROPERTY
};
ValaIterator* vala_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void vala_hash_set_iterator_set_set (ValaHashSetIterator* self, ValaHashSet* value);
static gboolean vala_hash_set_iterator_real_next (ValaIterator* base);
static gpointer vala_hash_set_iterator_real_get (ValaIterator* base);
static void vala_hash_set_iterator_finalize (ValaIterator* obj);
static void vala_hash_set_finalize (ValaIterable* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ValaHashSet* vala_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	ValaHashSet* self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ValaHashSetNode** _tmp3_ = NULL;
	self = (ValaHashSet*) vala_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = hash_func;
	vala_hash_set_set_hash_func (self, _tmp0_);
	_tmp1_ = equal_func;
	vala_hash_set_set_equal_func (self, _tmp1_);
	self->priv->_array_size = VALA_HASH_SET_MIN_SIZE;
	_tmp2_ = self->priv->_array_size;
	_tmp3_ = g_new0 (ValaHashSetNode*, _tmp2_ + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
	self->priv->_nodes = _tmp3_;
	self->priv->_nodes_length1 = _tmp2_;
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
	return self;
}


ValaHashSet* vala_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	return vala_hash_set_construct (VALA_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
}


static ValaHashSetNode** vala_hash_set_lookup_node (ValaHashSet* self, gconstpointer key) {
	ValaHashSetNode** result = NULL;
	guint hash_value = 0U;
	GHashFunc _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	ValaHashSetNode** node = NULL;
	ValaHashSetNode** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint _tmp4_ = 0U;
	gint _tmp5_ = 0;
	ValaHashSetNode** _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hash_func;
	_tmp1_ = key;
	_tmp2_ = _tmp0_ (_tmp1_);
	hash_value = _tmp2_;
	_tmp3_ = self->priv->_nodes;
	_tmp3__length1 = self->priv->_nodes_length1;
	_tmp4_ = hash_value;
	_tmp5_ = self->priv->_array_size;
	node = &_tmp3_[_tmp4_ % _tmp5_];
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		ValaHashSetNode** _tmp7_ = NULL;
		gboolean _tmp18_ = FALSE;
		ValaHashSetNode** _tmp19_ = NULL;
		_tmp7_ = node;
		if ((*_tmp7_) != NULL) {
			gboolean _tmp8_ = FALSE;
			guint _tmp9_ = 0U;
			ValaHashSetNode** _tmp10_ = NULL;
			guint _tmp11_ = 0U;
			gboolean _tmp17_ = FALSE;
			_tmp9_ = hash_value;
			_tmp10_ = node;
			_tmp11_ = (*_tmp10_)->key_hash;
			if (_tmp9_ != _tmp11_) {
				_tmp8_ = TRUE;
			} else {
				GEqualFunc _tmp12_ = NULL;
				ValaHashSetNode** _tmp13_ = NULL;
				gconstpointer _tmp14_ = NULL;
				gconstpointer _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				_tmp12_ = self->priv->_equal_func;
				_tmp13_ = node;
				_tmp14_ = (*_tmp13_)->key;
				_tmp15_ = key;
				_tmp16_ = _tmp12_ (_tmp14_, _tmp15_);
				_tmp8_ = !_tmp16_;
			}
			_tmp17_ = _tmp8_;
			_tmp6_ = _tmp17_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp18_ = _tmp6_;
		if (!_tmp18_) {
			break;
		}
		_tmp19_ = node;
		node = &(*_tmp19_)->next;
	}
	_tmp20_ = node;
	result = _tmp20_;
	return result;
}


static gboolean vala_hash_set_real_contains (ValaCollection* base, gconstpointer key) {
	ValaHashSet * self;
	gboolean result = FALSE;
	ValaHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	ValaHashSetNode** _tmp1_ = NULL;
	self = (ValaHashSet*) base;
	_tmp0_ = key;
	_tmp1_ = vala_hash_set_lookup_node (self, _tmp0_);
	node = _tmp1_;
	result = (*node) != NULL;
	return result;
}


static GType vala_hash_set_real_get_element_type (ValaIterable* base) {
	ValaHashSet * self;
	GType result = 0UL;
	self = (ValaHashSet*) base;
	result = self->priv->g_type;
	return result;
}


static ValaIterator* vala_hash_set_real_iterator (ValaIterable* base) {
	ValaHashSet * self;
	ValaIterator* result = NULL;
	ValaHashSetIterator* _tmp0_ = NULL;
	self = (ValaHashSet*) base;
	_tmp0_ = vala_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (ValaIterator*) _tmp0_;
	return result;
}


static gboolean vala_hash_set_real_add (ValaCollection* base, gconstpointer key) {
	ValaHashSet * self;
	gboolean result = FALSE;
	ValaHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	ValaHashSetNode** _tmp1_ = NULL;
	ValaHashSetNode** _tmp2_ = NULL;
	self = (ValaHashSet*) base;
	_tmp0_ = key;
	_tmp1_ = vala_hash_set_lookup_node (self, _tmp0_);
	node = _tmp1_;
	_tmp2_ = node;
	if ((*_tmp2_) != NULL) {
		result = FALSE;
		return result;
	} else {
		guint hash_value = 0U;
		GHashFunc _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		ValaHashSetNode** _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		ValaHashSetNode* _tmp10_ = NULL;
		ValaHashSetNode* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp3_ = self->priv->_hash_func;
		_tmp4_ = key;
		_tmp5_ = _tmp3_ (_tmp4_);
		hash_value = _tmp5_;
		_tmp6_ = node;
		_tmp7_ = key;
		_tmp8_ = ((_tmp7_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp7_) : ((gpointer) _tmp7_);
		_tmp9_ = hash_value;
		_tmp10_ = vala_hash_set_node_new (_tmp8_, _tmp9_);
		*_tmp6_ = _tmp10_;
		_tmp11_ = *_tmp6_;
		_tmp12_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp12_ + 1;
		vala_hash_set_resize (self);
		_tmp13_ = self->priv->_stamp;
		self->priv->_stamp = _tmp13_ + 1;
		result = TRUE;
		return result;
	}
}


static gboolean vala_hash_set_real_remove (ValaCollection* base, gconstpointer key) {
	ValaHashSet * self;
	gboolean result = FALSE;
	ValaHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	ValaHashSetNode** _tmp1_ = NULL;
	ValaHashSetNode** _tmp2_ = NULL;
	self = (ValaHashSet*) base;
	_tmp0_ = key;
	_tmp1_ = vala_hash_set_lookup_node (self, _tmp0_);
	node = _tmp1_;
	_tmp2_ = node;
	if ((*_tmp2_) != NULL) {
		ValaHashSetNode* next = NULL;
		ValaHashSetNode** _tmp3_ = NULL;
		ValaHashSetNode* _tmp4_ = NULL;
		ValaHashSetNode** _tmp5_ = NULL;
		ValaHashSetNode** _tmp6_ = NULL;
		ValaHashSetNode** _tmp7_ = NULL;
		ValaHashSetNode* _tmp8_ = NULL;
		ValaHashSetNode* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp3_ = node;
		_tmp4_ = (*_tmp3_)->next;
		(*_tmp3_)->next = NULL;
		next = _tmp4_;
		_tmp5_ = node;
		(((*_tmp5_)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp5_)->key = (self->priv->g_destroy_func ((*_tmp5_)->key), NULL));
		(*_tmp5_)->key = NULL;
		_tmp6_ = node;
		vala_hash_set_node_free (*_tmp6_);
		_tmp7_ = node;
		_tmp8_ = next;
		next = NULL;
		*_tmp7_ = _tmp8_;
		_tmp9_ = *_tmp7_;
		_tmp10_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp10_ - 1;
		vala_hash_set_resize (self);
		_tmp11_ = self->priv->_stamp;
		self->priv->_stamp = _tmp11_ + 1;
		result = TRUE;
		_vala_hash_set_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}


static void vala_hash_set_real_clear (ValaCollection* base) {
	ValaHashSet * self;
	self = (ValaHashSet*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				ValaHashSetNode* node = NULL;
				ValaHashSetNode** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				ValaHashSetNode* _tmp7_ = NULL;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_array_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->_nodes;
				_tmp5__length1 = self->priv->_nodes_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp5_[_tmp6_] = NULL;
				node = _tmp7_;
				while (TRUE) {
					ValaHashSetNode* _tmp8_ = NULL;
					ValaHashSetNode* next = NULL;
					ValaHashSetNode* _tmp9_ = NULL;
					ValaHashSetNode* _tmp10_ = NULL;
					ValaHashSetNode* _tmp11_ = NULL;
					ValaHashSetNode* _tmp12_ = NULL;
					_tmp8_ = node;
					if (!(_tmp8_ != NULL)) {
						break;
					}
					_tmp9_ = node;
					_tmp10_ = _tmp9_->next;
					_tmp9_->next = NULL;
					next = _tmp10_;
					_tmp11_ = node;
					((_tmp11_->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_->key = (self->priv->g_destroy_func (_tmp11_->key), NULL));
					_tmp11_->key = NULL;
					_tmp12_ = next;
					next = NULL;
					_vala_hash_set_node_free0 (node);
					node = _tmp12_;
					_vala_hash_set_node_free0 (next);
				}
				_vala_hash_set_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	vala_hash_set_resize (self);
}


static void vala_hash_set_resize (ValaHashSet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_array_size;
	_tmp3_ = self->priv->_nnodes;
	if (_tmp2_ >= (3 * _tmp3_)) {
		gint _tmp4_ = 0;
		_tmp4_ = self->priv->_array_size;
		_tmp1_ = _tmp4_ >= VALA_HASH_SET_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = self->priv->_array_size;
		_tmp8_ = self->priv->_nnodes;
		if ((3 * _tmp7_) <= _tmp8_) {
			gint _tmp9_ = 0;
			_tmp9_ = self->priv->_array_size;
			_tmp6_ = _tmp9_ < VALA_HASH_SET_MAX_SIZE;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp10_ = _tmp6_;
		_tmp0_ = _tmp10_;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		gint new_array_size = 0;
		gint _tmp12_ = 0;
		guint _tmp13_ = 0U;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		ValaHashSetNode** new_nodes = NULL;
		gint _tmp16_ = 0;
		ValaHashSetNode** _tmp17_ = NULL;
		gint new_nodes_length1 = 0;
		gint _new_nodes_size_ = 0;
		ValaHashSetNode** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gint _tmp44_ = 0;
		_tmp12_ = self->priv->_nnodes;
		_tmp13_ = g_spaced_primes_closest ((guint) _tmp12_);
		new_array_size = (gint) _tmp13_;
		_tmp14_ = new_array_size;
		_tmp15_ = CLAMP (_tmp14_, VALA_HASH_SET_MIN_SIZE, VALA_HASH_SET_MAX_SIZE);
		new_array_size = _tmp15_;
		_tmp16_ = new_array_size;
		_tmp17_ = g_new0 (ValaHashSetNode*, _tmp16_ + 1);
		new_nodes = _tmp17_;
		new_nodes_length1 = _tmp16_;
		_new_nodes_size_ = new_nodes_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_ = FALSE;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					ValaHashSetNode* node = NULL;
					ValaHashSetNode* next = NULL;
					_tmp19_ = _tmp18_;
					if (!_tmp19_) {
						gint _tmp20_ = 0;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = self->priv->_array_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					next = NULL;
					{
						ValaHashSetNode** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						ValaHashSetNode* _tmp25_ = NULL;
						gboolean _tmp26_ = FALSE;
						_tmp23_ = self->priv->_nodes;
						_tmp23__length1 = self->priv->_nodes_length1;
						_tmp24_ = i;
						_tmp25_ = _tmp23_[_tmp24_];
						_tmp23_[_tmp24_] = NULL;
						_vala_hash_set_node_free0 (node);
						node = _tmp25_;
						_tmp26_ = TRUE;
						while (TRUE) {
							gboolean _tmp27_ = FALSE;
							ValaHashSetNode* _tmp29_ = NULL;
							ValaHashSetNode* _tmp30_ = NULL;
							ValaHashSetNode* _tmp31_ = NULL;
							guint hash_val = 0U;
							ValaHashSetNode* _tmp32_ = NULL;
							guint _tmp33_ = 0U;
							gint _tmp34_ = 0;
							ValaHashSetNode* _tmp35_ = NULL;
							ValaHashSetNode** _tmp36_ = NULL;
							gint _tmp36__length1 = 0;
							guint _tmp37_ = 0U;
							ValaHashSetNode* _tmp38_ = NULL;
							ValaHashSetNode** _tmp39_ = NULL;
							gint _tmp39__length1 = 0;
							guint _tmp40_ = 0U;
							ValaHashSetNode* _tmp41_ = NULL;
							ValaHashSetNode* _tmp42_ = NULL;
							_tmp27_ = _tmp26_;
							if (!_tmp27_) {
								ValaHashSetNode* _tmp28_ = NULL;
								_tmp28_ = next;
								next = NULL;
								_vala_hash_set_node_free0 (node);
								node = _tmp28_;
							}
							_tmp26_ = FALSE;
							_tmp29_ = node;
							if (!(_tmp29_ != NULL)) {
								break;
							}
							_tmp30_ = node;
							_tmp31_ = _tmp30_->next;
							_tmp30_->next = NULL;
							_vala_hash_set_node_free0 (next);
							next = _tmp31_;
							_tmp32_ = node;
							_tmp33_ = _tmp32_->key_hash;
							_tmp34_ = new_array_size;
							hash_val = _tmp33_ % _tmp34_;
							_tmp35_ = node;
							_tmp36_ = new_nodes;
							_tmp36__length1 = new_nodes_length1;
							_tmp37_ = hash_val;
							_tmp38_ = _tmp36_[_tmp37_];
							_tmp36_[_tmp37_] = NULL;
							_vala_hash_set_node_free0 (_tmp35_->next);
							_tmp35_->next = _tmp38_;
							_tmp39_ = new_nodes;
							_tmp39__length1 = new_nodes_length1;
							_tmp40_ = hash_val;
							_tmp41_ = node;
							node = NULL;
							_vala_hash_set_node_free0 (_tmp39_[_tmp40_]);
							_tmp39_[_tmp40_] = _tmp41_;
							_tmp42_ = _tmp39_[_tmp40_];
						}
					}
					_vala_hash_set_node_free0 (next);
					_vala_hash_set_node_free0 (node);
				}
			}
		}
		_tmp43_ = new_nodes;
		_tmp43__length1 = new_nodes_length1;
		new_nodes = NULL;
		new_nodes_length1 = 0;
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
		self->priv->_nodes = _tmp43_;
		self->priv->_nodes_length1 = _tmp43__length1;
		self->priv->__nodes_size_ = self->priv->_nodes_length1;
		_tmp44_ = new_array_size;
		self->priv->_array_size = _tmp44_;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
	}
}


static gint vala_hash_set_real_get_size (ValaCollection* base) {
	gint result;
	ValaHashSet* self;
	gint _tmp0_ = 0;
	self = (ValaHashSet*) base;
	_tmp0_ = self->priv->_nnodes;
	result = _tmp0_;
	return result;
}


void vala_hash_set_set_hash_func (ValaHashSet* self, GHashFunc value) {
	GHashFunc _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hash_func = _tmp0_;
}


void vala_hash_set_set_equal_func (ValaHashSet* self, GEqualFunc value) {
	GEqualFunc _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_equal_func = _tmp0_;
}


static ValaHashSetNode* vala_hash_set_node_new (gpointer k, guint hash) {
	ValaHashSetNode* self;
	gpointer _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = g_slice_new0 (ValaHashSetNode);
	vala_hash_set_node_instance_init (self);
	_tmp0_ = k;
	k = NULL;
	self->key = _tmp0_;
	_tmp1_ = hash;
	self->key_hash = _tmp1_;
	return self;
}


static void vala_hash_set_node_instance_init (ValaHashSetNode * self) {
}


static void vala_hash_set_node_free (ValaHashSetNode* self) {
	_vala_hash_set_node_free0 (self->next);
	g_slice_free (ValaHashSetNode, self);
}


static ValaHashSetIterator* vala_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set) {
	ValaHashSetIterator* self = NULL;
	ValaHashSet* _tmp0_ = NULL;
	g_return_val_if_fail (set != NULL, NULL);
	self = (ValaHashSetIterator*) vala_iterator_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = set;
	vala_hash_set_iterator_set_set (self, _tmp0_);
	return self;
}


static ValaHashSetIterator* vala_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set) {
	return vala_hash_set_iterator_construct (VALA_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static gboolean vala_hash_set_iterator_real_next (ValaIterator* base) {
	ValaHashSetIterator * self;
	gboolean result = FALSE;
	ValaHashSetNode* _tmp0_ = NULL;
	ValaHashSetNode* _tmp14_ = NULL;
	self = (ValaHashSetIterator*) base;
	_tmp0_ = self->priv->_node;
	if (_tmp0_ != NULL) {
		ValaHashSetNode* _tmp1_ = NULL;
		ValaHashSetNode* _tmp2_ = NULL;
		_tmp1_ = self->priv->_node;
		_tmp2_ = _tmp1_->next;
		self->priv->_node = _tmp2_;
	}
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		ValaHashSetNode* _tmp4_ = NULL;
		gboolean _tmp8_ = FALSE;
		gint _tmp9_ = 0;
		ValaHashSet* _tmp10_ = NULL;
		ValaHashSetNode** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp12_ = 0;
		ValaHashSetNode* _tmp13_ = NULL;
		_tmp4_ = self->priv->_node;
		if (_tmp4_ == NULL) {
			gint _tmp5_ = 0;
			ValaHashSet* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			_tmp5_ = self->priv->_index;
			_tmp6_ = self->priv->_set;
			_tmp7_ = _tmp6_->priv->_array_size;
			_tmp3_ = (_tmp5_ + 1) < _tmp7_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp8_ = _tmp3_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = self->priv->_index;
		self->priv->_index = _tmp9_ + 1;
		_tmp10_ = self->priv->_set;
		_tmp11_ = _tmp10_->priv->_nodes;
		_tmp11__length1 = _tmp10_->priv->_nodes_length1;
		_tmp12_ = self->priv->_index;
		_tmp13_ = _tmp11_[_tmp12_];
		self->priv->_node = _tmp13_;
	}
	_tmp14_ = self->priv->_node;
	result = _tmp14_ != NULL;
	return result;
}


static gpointer vala_hash_set_iterator_real_get (ValaIterator* base) {
	ValaHashSetIterator * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	ValaHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ValaHashSetNode* _tmp3_ = NULL;
	ValaHashSetNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (ValaHashSetIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_set;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
	_tmp3_ = self->priv->_node;
	_vala_assert (_tmp3_ != NULL, "_node != null");
	_tmp4_ = self->priv->_node;
	_tmp5_ = _tmp4_->key;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	result = _tmp6_;
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vala_hash_set_iterator_set_set (ValaHashSetIterator* self, ValaHashSet* value) {
	ValaHashSet* _tmp0_ = NULL;
	ValaHashSet* _tmp1_ = NULL;
	ValaHashSet* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	_vala_iterable_unref0 (self->priv->_set);
	self->priv->_set = _tmp1_;
	_tmp2_ = self->priv->_set;
	_tmp3_ = _tmp2_->priv->_stamp;
	self->priv->_stamp = _tmp3_;
}


static void vala_hash_set_iterator_class_init (ValaHashSetIteratorClass * klass) {
	vala_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERATOR_CLASS (klass)->finalize = vala_hash_set_iterator_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashSetIteratorPrivate));
	VALA_ITERATOR_CLASS (klass)->next = vala_hash_set_iterator_real_next;
	VALA_ITERATOR_CLASS (klass)->get = vala_hash_set_iterator_real_get;
}


static void vala_hash_set_iterator_instance_init (ValaHashSetIterator * self) {
	self->priv = VALA_HASH_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->priv->_stamp = 0;
}


static void vala_hash_set_iterator_finalize (ValaIterator* obj) {
	ValaHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIterator);
	_vala_iterable_unref0 (self->priv->_set);
	VALA_ITERATOR_CLASS (vala_hash_set_iterator_parent_class)->finalize (obj);
}


static GType vala_hash_set_iterator_get_type (void) {
	static volatile gsize vala_hash_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashSetIterator), 0, (GInstanceInitFunc) vala_hash_set_iterator_instance_init, NULL };
		GType vala_hash_set_iterator_type_id;
		vala_hash_set_iterator_type_id = g_type_register_static (VALA_TYPE_ITERATOR, "ValaHashSetIterator", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_set_iterator_type_id__volatile, vala_hash_set_iterator_type_id);
	}
	return vala_hash_set_iterator_type_id__volatile;
}


static void vala_hash_set_class_init (ValaHashSetClass * klass) {
	vala_hash_set_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERABLE_CLASS (klass)->finalize = vala_hash_set_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashSetPrivate));
	VALA_COLLECTION_CLASS (klass)->contains = vala_hash_set_real_contains;
	VALA_ITERABLE_CLASS (klass)->get_element_type = vala_hash_set_real_get_element_type;
	VALA_ITERABLE_CLASS (klass)->iterator = vala_hash_set_real_iterator;
	VALA_COLLECTION_CLASS (klass)->add = vala_hash_set_real_add;
	VALA_COLLECTION_CLASS (klass)->remove = vala_hash_set_real_remove;
	VALA_COLLECTION_CLASS (klass)->clear = vala_hash_set_real_clear;
	VALA_COLLECTION_CLASS (klass)->get_size = vala_hash_set_real_get_size;
}


static void vala_hash_set_instance_init (ValaHashSet * self) {
	self->priv = VALA_HASH_SET_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void vala_hash_set_finalize (ValaIterable* obj) {
	ValaHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_HASH_SET, ValaHashSet);
	vala_collection_clear ((ValaCollection*) self);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
	VALA_ITERABLE_CLASS (vala_hash_set_parent_class)->finalize (obj);
}


/**
 * Hashtable implementation of the Set interface.
 */
GType vala_hash_set_get_type (void) {
	static volatile gsize vala_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashSet), 0, (GInstanceInitFunc) vala_hash_set_instance_init, NULL };
		GType vala_hash_set_type_id;
		vala_hash_set_type_id = g_type_register_static (VALA_TYPE_SET, "ValaHashSet", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_set_type_id__volatile, vala_hash_set_type_id);
	}
	return vala_hash_set_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



