/* tracker-metadata-tile.c generated by valac, the Vala compiler
 * generated from tracker-metadata-tile.gs, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_TRACKER_METADATA_TILE (tracker_metadata_tile_get_type ())
#define TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTile))
#define TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))
#define IS_TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_METADATA_TILE))
#define IS_TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_METADATA_TILE))
#define TRACKER_METADATA_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))

typedef struct _TrackerMetadataTile TrackerMetadataTile;
typedef struct _TrackerMetadataTileClass TrackerMetadataTileClass;
typedef struct _TrackerMetadataTilePrivate TrackerMetadataTilePrivate;

#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResultGridPrivate TrackerResultGridPrivate;

#define TYPE_RESULT_COLUMNS (result_columns_get_type ())

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Music,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerMetadataTile {
	GtkEventBox parent_instance;
	TrackerMetadataTilePrivate * priv;
	char* uri;
	Categories category;
	GtkImage* image;
	GtkLinkButton* name_link;
	GtkLinkButton* path_link;
	GtkTable* table;
	char* sparql;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* info_label1;
	GtkLabel* info_value1;
	GtkLabel* info_label2;
	GtkLabel* info_value2;
	GtkLabel* info_label3;
	GtkLabel* info_value3;
	GtkLabel* info_label4;
	GtkLabel* info_value4;
	GtkLabel* info_label5;
	GtkLabel* info_value5;
	GtkLabel* info_label6;
	GtkLabel* info_value6;
	GtkLabel* info_label7;
	GtkLabel* info_value7;
	GtkLabel* info_label8;
	GtkLabel* info_value8;
};

struct _TrackerMetadataTileClass {
	GtkEventBoxClass parent_class;
};

struct _TrackerMetadataTilePrivate {
	TrackerResultGrid* _result_grid;
	TrackerQuery* _Query;
};

struct _TrackerResultGrid {
	GtkScrolledWindow parent_instance;
	TrackerResultGridPrivate * priv;
	GtkListStore* store;
	GtkIconView* iconview;
};

struct _TrackerResultGridClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	RESULT_COLUMNS_Id,
	RESULT_COLUMNS_Uri,
	RESULT_COLUMNS_Icon,
	RESULT_COLUMNS_DisplayName,
	RESULT_COLUMNS_Mime,
	RESULT_COLUMNS_Category,
	RESULT_COLUMNS_Snippet,
	RESULT_COLUMNS_IsDirectory,
	RESULT_COLUMNS_Path,
	RESULT_COLUMNS_NumOfCols
} ResultColumns;


static gpointer tracker_metadata_tile_parent_class = NULL;

GType tracker_metadata_tile_get_type (void);
GType categories_get_type (void);
GType tracker_result_grid_get_type (void);
GType tracker_query_get_type (void);
#define TRACKER_METADATA_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTilePrivate))
enum  {
	TRACKER_METADATA_TILE_DUMMY_PROPERTY,
	TRACKER_METADATA_TILE_QUERY,
	TRACKER_METADATA_TILE_RESULT_GRID
};
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, GdkEventExpose* e);
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e);
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e);
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self);
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const char* val);
char* tracker_utils_FormatFileSize (gint64 size);
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size);
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const char* val);
TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self);
char** tracker_query_Query (TrackerQuery* self, const char* sparql, int* result_length1, int* result_length2);
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const char* uri, const char* mime);
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayMusicDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const char* uri);
GType result_columns_get_type (void);
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, GtkTreePath* path);
TrackerMetadataTile* tracker_metadata_tile_new (void);
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type);
void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value);
TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self);
static void _lambda6_ (GtkTreePath* path, TrackerMetadataTile* self);
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, GtkTreePath* path, gpointer self);
void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value);
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, GdkEventExpose* event, gpointer self);
static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_metadata_tile_finalize (GObject* obj);
static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 157 "tracker-metadata-tile.gs"
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, GdkEventExpose* e) {
#line 199 "tracker-metadata-tile.c"
	gboolean result = FALSE;
	cairo_t* cr;
	GtkStyle* style;
	GdkColor step1;
	GdkColor step2;
	double w = 0.0;
	double h = 0.0;
	cairo_pattern_t* pat;
#line 157 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "tracker-metadata-tile.gs"
	cr = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
#line 161 "tracker-metadata-tile.gs"
	style = _g_object_ref0 (gtk_widget_get_style ((GtkWidget*) self));
#line 162 "tracker-metadata-tile.gs"
	step1 = style->bg[GTK_STATE_NORMAL];
#line 163 "tracker-metadata-tile.gs"
	step2 = style->bg[GTK_STATE_SELECTED];
#line 166 "tracker-metadata-tile.gs"
	w = (double) ((GtkWidget*) self)->allocation.width;
#line 167 "tracker-metadata-tile.gs"
	h = (double) ((GtkWidget*) self)->allocation.height;
#line 170 "tracker-metadata-tile.gs"
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
#line 171 "tracker-metadata-tile.gs"
	gdk_cairo_set_source_color (cr, &step1);
#line 172 "tracker-metadata-tile.gs"
	cairo_paint (cr);
#line 173 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 0);
#line 174 "tracker-metadata-tile.gs"
	cairo_set_line_width (cr, 1.0);
#line 175 "tracker-metadata-tile.gs"
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
#line 178 "tracker-metadata-tile.gs"
	pat = cairo_pattern_create_linear (0.0, 0.0, 0.0, h);
#line 180 "tracker-metadata-tile.gs"
	cairo_pattern_add_color_stop_rgba (pat, 0.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.05);
#line 182 "tracker-metadata-tile.gs"
	cairo_pattern_add_color_stop_rgba (pat, 1.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.5);
#line 184 "tracker-metadata-tile.gs"
	cairo_rectangle (cr, (double) 0, (double) 0, w, h);
#line 185 "tracker-metadata-tile.gs"
	cairo_set_source (cr, pat);
#line 186 "tracker-metadata-tile.gs"
	cairo_fill (cr);
#line 189 "tracker-metadata-tile.gs"
	cairo_set_source_rgba (cr, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.7);
#line 190 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 0);
#line 191 "tracker-metadata-tile.gs"
	cairo_line_to (cr, w, (double) 0);
#line 192 "tracker-metadata-tile.gs"
	cairo_stroke (cr);
#line 195 "tracker-metadata-tile.gs"
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.5);
#line 196 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 1);
#line 197 "tracker-metadata-tile.gs"
	cairo_line_to (cr, w, (double) 1);
#line 198 "tracker-metadata-tile.gs"
	cairo_stroke (cr);
#line 262 "tracker-metadata-tile.c"
	result = GTK_WIDGET_CLASS (tracker_metadata_tile_parent_class)->expose_event ((GtkWidget*) GTK_EVENT_BOX (self), e);
	_cairo_destroy0 (cr);
	_g_object_unref0 (style);
	_cairo_pattern_destroy0 (pat);
#line 200 "tracker-metadata-tile.gs"
	return result;
#line 269 "tracker-metadata-tile.c"
}


#line 203 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e) {
#line 203 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 203 "tracker-metadata-tile.gs"
	g_return_if_fail (lab != NULL);
#line 204 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 205 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
#line 283 "tracker-metadata-tile.c"
	} else {
#line 207 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 287 "tracker-metadata-tile.c"
	}
}


#line 209 "tracker-metadata-tile.gs"
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e) {
#line 294 "tracker-metadata-tile.c"
	GtkLabel* result = NULL;
	GtkLabel* l;
#line 209 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "tracker-metadata-tile.gs"
	g_return_val_if_fail (s != NULL, NULL);
#line 210 "tracker-metadata-tile.gs"
	l = g_object_ref_sink ((GtkLabel*) gtk_label_new (s));
#line 211 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) l, "xalign", (float) 0, NULL);
#line 212 "tracker-metadata-tile.gs"
	gtk_label_set_use_markup (l, TRUE);
#line 214 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 215 "tracker-metadata-tile.gs"
		gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
#line 311 "tracker-metadata-tile.c"
	}
	result = l;
#line 217 "tracker-metadata-tile.gs"
	return result;
#line 316 "tracker-metadata-tile.c"
}


#line 220 "tracker-metadata-tile.gs"
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self) {
#line 220 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 221 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value1, "");
#line 222 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value2, "");
#line 223 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value3, "");
#line 224 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value4, "");
#line 225 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value5, "");
#line 226 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value6, "");
#line 227 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, "");
#line 228 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, "");
#line 229 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, "");
#line 231 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, "");
#line 232 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, "");
#line 233 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->path_link, "");
#line 234 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->path_link, "");
#line 236 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->name_link, FALSE);
#line 237 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, FALSE);
#line 354 "tracker-metadata-tile.c"
}


#line 239 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const char* val) {
#line 360 "tracker-metadata-tile.c"
	char* val1;
#line 239 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 239 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 239 "tracker-metadata-tile.gs"
	g_return_if_fail (val != NULL);
#line 240 "tracker-metadata-tile.gs"
	val1 = g_strdup_printf ("<b>%s</b>", val);
#line 241 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 242 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 374 "tracker-metadata-tile.c"
	_g_free0 (val1);
}


#line 244 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size) {
#line 381 "tracker-metadata-tile.c"
	char* _tmp0_;
	char* _tmp1_;
	char* val1;
#line 244 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 244 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 245 "tracker-metadata-tile.gs"
	val1 = (_tmp1_ = g_strdup_printf ("<b>%s</b>", _tmp0_ = tracker_utils_FormatFileSize (size)), _g_free0 (_tmp0_), _tmp1_);
#line 246 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 247 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 395 "tracker-metadata-tile.c"
	_g_free0 (val1);
}


#line 250 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const char* val) {
#line 402 "tracker-metadata-tile.c"
	char* value;
	char** _tmp1_;
	gint _values_size_;
	gint values_length1;
	char** _tmp0_;
	char** values;
	char** _tmp4_;
	gint _escapes_size_;
	gint escapes_length1;
	char** _tmp3_;
	char** escapes;
	char* _tmp5_;
	char* val1;
#line 250 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 250 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 250 "tracker-metadata-tile.gs"
	g_return_if_fail (val != NULL);
#line 251 "tracker-metadata-tile.gs"
	value = g_strdup (val);
#line 424 "tracker-metadata-tile.c"
	values = (_tmp1_ = _tmp0_ = g_strsplit (val, ":", 0), values_length1 = _vala_array_length (_tmp0_), _values_size_ = values_length1, _tmp1_);
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 255 "tracker-metadata-tile.gs"
		s_collection = values;
#line 432 "tracker-metadata-tile.c"
		s_collection_length1 = values_length1;
		for (s_it = 0; s_it < values_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp2_;
#line 256 "tracker-metadata-tile.gs"
				value = (_tmp2_ = g_strdup (s), _g_free0 (value), _tmp2_);
#line 441 "tracker-metadata-tile.c"
				_g_free0 (s);
			}
		}
	}
	escapes = (_tmp4_ = _tmp3_ = g_strsplit (value, "%20", 0), escapes_length1 = _vala_array_length (_tmp3_), _escapes_size_ = escapes_length1, _tmp4_);
#line 259 "tracker-metadata-tile.gs"
	value = (_tmp5_ = g_strdup (""), _g_free0 (value), _tmp5_);
#line 449 "tracker-metadata-tile.c"
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 260 "tracker-metadata-tile.gs"
		s_collection = escapes;
#line 456 "tracker-metadata-tile.c"
		s_collection_length1 = escapes_length1;
		for (s_it = 0; s_it < escapes_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp7_;
				char* _tmp6_;
#line 261 "tracker-metadata-tile.gs"
				value = (_tmp7_ = g_strconcat (value, _tmp6_ = g_strconcat (s, " ", NULL), NULL), _g_free0 (value), _tmp7_);
#line 466 "tracker-metadata-tile.c"
				_g_free0 (_tmp6_);
				_g_free0 (s);
			}
		}
	}
#line 263 "tracker-metadata-tile.gs"
	val1 = g_strdup_printf ("<b>%s</b>", value);
#line 264 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 265 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 478 "tracker-metadata-tile.c"
	_g_free0 (value);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	escapes = (_vala_array_free (escapes, escapes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (val1);
}


#line 1048 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 488 "tracker-metadata-tile.c"
	gboolean result = FALSE;
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 494 "tracker-metadata-tile.c"
	result = strstr (self, needle) != NULL;
#line 1049 "glib-2.0.vapi"
	return result;
#line 498 "tracker-metadata-tile.c"
}


#line 270 "tracker-metadata-tile.gs"
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const char* uri) {
#line 504 "tracker-metadata-tile.c"
	Categories result = 0;
	char* query;
	char** _tmp2_;
	gint results_length2;
	gint results_length1;
	gint _tmp1_;
	gint _tmp0_;
	char** results;
	char* res;
#line 270 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, 0);
#line 270 "tracker-metadata-tile.gs"
	g_return_val_if_fail (uri != NULL, 0);
#line 271 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("select rdf:type(?s) where { ?s nie:url \"%s\" }", uri);
#line 520 "tracker-metadata-tile.c"
	results = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), results_length1 = _tmp0_, results_length2 = _tmp1_, _tmp2_);
#line 273 "tracker-metadata-tile.gs"
	res = g_strdup ("");
#line 524 "tracker-metadata-tile.c"
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 274 "tracker-metadata-tile.gs"
		s_collection = results;
#line 531 "tracker-metadata-tile.c"
		s_collection_length1 = results_length1 * results_length2;
		for (s_it = 0; s_it < (results_length1 * results_length2); s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp3_;
#line 275 "tracker-metadata-tile.gs"
				res = (_tmp3_ = g_strconcat (res, s, NULL), _g_free0 (res), _tmp3_);
#line 540 "tracker-metadata-tile.c"
				_g_free0 (s);
			}
		}
	}
#line 277 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Video")) {
#line 547 "tracker-metadata-tile.c"
		result = CATEGORIES_Video;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
#line 277 "tracker-metadata-tile.gs"
		return result;
#line 554 "tracker-metadata-tile.c"
	}
#line 278 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Image")) {
#line 558 "tracker-metadata-tile.c"
		result = CATEGORIES_Image;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
#line 278 "tracker-metadata-tile.gs"
		return result;
#line 565 "tracker-metadata-tile.c"
	}
#line 279 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Audio")) {
#line 569 "tracker-metadata-tile.c"
		result = CATEGORIES_Music;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
#line 279 "tracker-metadata-tile.gs"
		return result;
#line 576 "tracker-metadata-tile.c"
	}
#line 280 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Document")) {
#line 580 "tracker-metadata-tile.c"
		result = CATEGORIES_Document;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
#line 280 "tracker-metadata-tile.gs"
		return result;
#line 587 "tracker-metadata-tile.c"
	}
#line 281 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Software")) {
#line 591 "tracker-metadata-tile.c"
		result = CATEGORIES_Application;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
#line 281 "tracker-metadata-tile.gs"
		return result;
#line 598 "tracker-metadata-tile.c"
	}
#line 282 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Folder")) {
#line 602 "tracker-metadata-tile.c"
		result = CATEGORIES_Folder;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
#line 282 "tracker-metadata-tile.gs"
		return result;
#line 609 "tracker-metadata-tile.c"
	}
	result = CATEGORIES_File;
	_g_free0 (query);
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (res);
#line 284 "tracker-metadata-tile.gs"
	return result;
#line 617 "tracker-metadata-tile.c"
}


#line 287 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const char* uri, const char* mime) {
#line 623 "tracker-metadata-tile.c"
	GError * _inner_error_;
	GFile* file;
	char* filepath;
	GFile* displaypath;
	char* _tmp0_;
	char* _tmp1_;
	GtkLabel* link_label;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
#line 287 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 287 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 287 "tracker-metadata-tile.gs"
	g_return_if_fail (mime != NULL);
#line 639 "tracker-metadata-tile.c"
	_inner_error_ = NULL;
#line 288 "tracker-metadata-tile.gs"
	file = g_file_new_for_uri (uri);
#line 289 "tracker-metadata-tile.gs"
	filepath = g_file_get_basename (file);
#line 290 "tracker-metadata-tile.gs"
	displaypath = g_file_get_parent (file);
#line 292 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, uri);
#line 293 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, filepath);
#line 294 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->path_link, _tmp0_ = g_file_get_uri (displaypath));
#line 653 "tracker-metadata-tile.c"
	_g_free0 (_tmp0_);
#line 295 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->path_link, _tmp1_ = g_file_get_path (displaypath));
#line 657 "tracker-metadata-tile.c"
	_g_free0 (_tmp1_);
	link_label = NULL;
#line 298 "tracker-metadata-tile.gs"
	link_label = (_tmp2_ = _g_object_ref0 (GTK_LABEL (gtk_bin_get_child ((GtkBin*) self->path_link))), _g_object_unref0 (link_label), _tmp2_);
#line 299 "tracker-metadata-tile.gs"
	gtk_label_set_ellipsize (link_label, PANGO_ELLIPSIZE_MIDDLE);
#line 301 "tracker-metadata-tile.gs"
	link_label = (_tmp3_ = _g_object_ref0 (GTK_LABEL (gtk_bin_get_child ((GtkBin*) self->name_link))), _g_object_unref0 (link_label), _tmp3_);
#line 302 "tracker-metadata-tile.gs"
	gtk_label_set_ellipsize (link_label, PANGO_ELLIPSIZE_MIDDLE);
#line 304 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value1, mime);
#line 670 "tracker-metadata-tile.c"
	{
		GFileInfo* info;
		GTimeVal tm = {0};
		char* _tmp4_;
		char* _tmp5_;
		char* val3;
#line 307 "tracker-metadata-tile.gs"
		info = g_file_query_info (file, "standard::size,time::modified", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 679 "tracker-metadata-tile.c"
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
#line 310 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelSizeValue (self, self->info_value2, g_file_info_get_size (info));
#line 313 "tracker-metadata-tile.gs"
		g_file_info_get_modification_time (info, &tm);
#line 315 "tracker-metadata-tile.gs"
		val3 = (_tmp5_ = g_strdup_printf ("<b>%s</b>", _tmp4_ = g_time_val_to_iso8601 (&tm)), _g_free0 (_tmp4_), _tmp5_);
#line 317 "tracker-metadata-tile.gs"
		gtk_label_set_markup (self->info_value3, val3);
#line 691 "tracker-metadata-tile.c"
		_g_object_unref0 (info);
		_g_free0 (val3);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 320 "tracker-metadata-tile.gs"
			g_print ("Could not get file info for %s\n", uri);
#line 704 "tracker-metadata-tile.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (filepath);
		_g_object_unref0 (displaypath);
		_g_object_unref0 (link_label);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (filepath);
	_g_object_unref0 (displaypath);
	_g_object_unref0 (link_label);
}


#line 323 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const char* uri) {
#line 727 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 323 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 323 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 324 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("select nfo:height(?s) nfo:width(?s) Where { ?s nie:url \"%s\" }", uri);
#line 741 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 327 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Height:"));
#line 328 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Width:"));
#line 330 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 331 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 332 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 753 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 336 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayMusicDetails (TrackerMetadataTile* self, const char* uri) {
#line 762 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 336 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 336 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 337 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("select nie:title(?s) nmm:performer(?s) nmm:musicAlbum(?s) Where { ?s n" \
"ie:url \"%s\" }", uri);
#line 776 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 340 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Title:"));
#line 341 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Artist:"));
#line 342 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Album:"));
#line 344 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 345 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 346 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelUrnValue (self, self->info_value5, _result_[1]);
#line 347 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelUrnValue (self, self->info_value6, _result_[2]);
#line 792 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 349 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const char* uri) {
#line 801 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 349 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 349 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 350 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("select nfo:height(?s) nfo:width(?s) nfo:duration (?s) Where { ?s nie:u" \
"rl \"%s\" }", uri);
#line 815 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 353 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Height:"));
#line 354 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Width:"));
#line 355 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Duration:"));
#line 357 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 358 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 359 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 360 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
#line 831 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 362 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const char* uri) {
#line 840 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 362 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 362 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 363 "tracker-metadata-tile.gs"
	query = g_strdup_printf ("select nie:title(?s) nco:creator(?s) nfo:pageCount (?s) Where { ?s nie" \
":url \"%s\" }", uri);
#line 854 "tracker-metadata-tile.c"
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 366 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Title:"));
#line 367 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Author:"));
#line 368 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Page count:"));
#line 370 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 371 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 372 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 373 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
#line 870 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 375 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const char* uri) {
#line 375 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 375 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 376 "tracker-metadata-tile.gs"
	return;
#line 885 "tracker-metadata-tile.c"
}


#line 378 "tracker-metadata-tile.gs"
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, GtkTreePath* path) {
#line 891 "tracker-metadata-tile.c"
	GtkTreeIter iter = {0};
	const char* id;
	const char* uri;
	const char* mime;
	GdkPixbuf* icon;
	Categories cat;
#line 378 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 379 "tracker-metadata-tile.gs"
	tracker_metadata_tile_ClearLabels (self);
#line 381 "tracker-metadata-tile.gs"
	if (path == NULL) {
#line 382 "tracker-metadata-tile.gs"
		gtk_image_set_from_icon_name (self->image, "text-x-generic", GTK_ICON_SIZE_DIALOG);
#line 383 "tracker-metadata-tile.gs"
		return;
#line 908 "tracker-metadata-tile.c"
	}
#line 385 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->name_link, TRUE);
#line 386 "tracker-metadata-tile.gs"
	gtk_widget_set_sensitive ((GtkWidget*) self->path_link, TRUE);
#line 914 "tracker-metadata-tile.c"
	id = NULL;
	uri = NULL;
	mime = NULL;
	icon = NULL;
#line 392 "tracker-metadata-tile.gs"
	gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_result_grid->store, &iter, path);
#line 393 "tracker-metadata-tile.gs"
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_result_grid->store, &iter, RESULT_COLUMNS_Id, &id, RESULT_COLUMNS_Uri, &uri, RESULT_COLUMNS_Mime, &mime, RESULT_COLUMNS_Icon, &icon, -1);
#line 397 "tracker-metadata-tile.gs"
	cat = tracker_metadata_tile_GetCategory (self, uri);
#line 399 "tracker-metadata-tile.gs"
	if (cat != CATEGORIES_Application) {
#line 400 "tracker-metadata-tile.gs"
		tracker_metadata_tile_DisplayFileDetails (self, uri, mime);
#line 401 "tracker-metadata-tile.gs"
		gtk_image_set_from_pixbuf (self->image, icon);
#line 931 "tracker-metadata-tile.c"
	}
#line 403 "tracker-metadata-tile.gs"
	switch (cat) {
#line 935 "tracker-metadata-tile.c"
		case CATEGORIES_Application:
		{
#line 404 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayApplicationDetails (self, uri);
#line 403 "tracker-metadata-tile.gs"
			break;
#line 942 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Music:
		{
#line 405 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayMusicDetails (self, uri);
#line 403 "tracker-metadata-tile.gs"
			break;
#line 950 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Video:
		{
#line 406 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayVideoDetails (self, uri);
#line 403 "tracker-metadata-tile.gs"
			break;
#line 958 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Image:
		{
#line 407 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayImageDetails (self, uri);
#line 403 "tracker-metadata-tile.gs"
			break;
#line 966 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Document:
		{
#line 408 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayDocumentDetails (self, uri);
#line 403 "tracker-metadata-tile.gs"
			break;
#line 974 "tracker-metadata-tile.c"
		}
		default:
		{
			_g_object_unref0 (icon);
#line 409 "tracker-metadata-tile.gs"
			return;
#line 403 "tracker-metadata-tile.gs"
			break;
#line 983 "tracker-metadata-tile.c"
		}
	}
	_g_object_unref0 (icon);
}


#line 30 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type) {
#line 992 "tracker-metadata-tile.c"
	TrackerMetadataTile * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 30 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_new (void) {
#line 30 "tracker-metadata-tile.gs"
	return tracker_metadata_tile_construct (TYPE_TRACKER_METADATA_TILE);
#line 1003 "tracker-metadata-tile.c"
}


TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Query;
#line 71 "tracker-metadata-tile.gs"
	return result;
#line 1013 "tracker-metadata-tile.c"
}


void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Query = value;
	g_object_notify ((GObject *) self, "Query");
}


TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self) {
	TrackerResultGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_result_grid;
#line 75 "tracker-metadata-tile.gs"
	return result;
#line 1030 "tracker-metadata-tile.c"
}


#line 80 "tracker-metadata-tile.gs"
static void _lambda6_ (GtkTreePath* path, TrackerMetadataTile* self) {
#line 81 "tracker-metadata-tile.gs"
	tracker_metadata_tile_LoadUri (self, path);
#line 1038 "tracker-metadata-tile.c"
}


#line 80 "tracker-metadata-tile.gs"
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, GtkTreePath* path, gpointer self) {
#line 1044 "tracker-metadata-tile.c"
	_lambda6_ (path, self);
}


void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value) {
	g_return_if_fail (self != NULL);
#line 77 "tracker-metadata-tile.gs"
	if (value != NULL) {
#line 1053 "tracker-metadata-tile.c"
		TrackerResultGrid* _tmp0_;
#line 78 "tracker-metadata-tile.gs"
		self->priv->_result_grid = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_result_grid), _tmp0_);
#line 80 "tracker-metadata-tile.gs"
		g_signal_connect_object (self->priv->_result_grid, "selection-changed", (GCallback) __lambda6__tracker_result_grid_selection_changed, self, 0);
#line 1059 "tracker-metadata-tile.c"
	}
	g_object_notify ((GObject *) self, "ResultGrid");
}


#line 157 "tracker-metadata-tile.gs"
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, GdkEventExpose* event, gpointer self) {
#line 1067 "tracker-metadata-tile.c"
	return tracker_metadata_tile_expose (self, event);
}


static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TrackerMetadataTile * self;
	parent_class = G_OBJECT_CLASS (tracker_metadata_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_METADATA_TILE (obj);
	{
		GtkTable* _tmp0_;
		GtkImage* _tmp1_;
		GtkLinkButton* _tmp2_;
		GtkLabel* _tmp3_;
		GtkLinkButton* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		GtkLabel* _tmp7_;
		GtkLabel* _tmp8_;
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		char* _tmp18_;
#line 86 "tracker-metadata-tile.gs"
		gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
#line 88 "tracker-metadata-tile.gs"
		g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) _tracker_metadata_tile_expose_gtk_widget_expose_event, self, 0);
#line 90 "tracker-metadata-tile.gs"
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
#line 92 "tracker-metadata-tile.gs"
		self->table = (_tmp0_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 5, (guint) 7, FALSE)), _g_object_unref0 (self->table), _tmp0_);
#line 93 "tracker-metadata-tile.gs"
		gtk_table_set_col_spacings (self->table, (guint) 3);
#line 94 "tracker-metadata-tile.gs"
		gtk_table_set_row_spacings (self->table, (guint) 3);
#line 98 "tracker-metadata-tile.gs"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->table);
#line 100 "tracker-metadata-tile.gs"
		self->image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("text-x-generic", GTK_ICON_SIZE_DIALOG)), _g_object_unref0 (self->image), _tmp1_);
#line 101 "tracker-metadata-tile.gs"
		gtk_image_set_pixel_size (self->image, 75);
#line 102 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->image, (guint) 0, (guint) 1, (guint) 0, (guint) 5, GTK_FILL, GTK_FILL, (guint) 12, (guint) 0);
#line 104 "tracker-metadata-tile.gs"
		self->name_link = (_tmp2_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->name_link), _tmp2_);
#line 105 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->name_link, "xalign", (float) 0, NULL);
#line 106 "tracker-metadata-tile.gs"
		self->name_label = (_tmp3_ = tracker_metadata_tile_CreateLabel (self, N_ ("Name:"), FALSE), _g_object_unref0 (self->name_label), _tmp3_);
#line 107 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->name_label, 1, 2, 0, 1, FALSE);
#line 108 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->name_link, (guint) 2, (guint) 3, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 110 "tracker-metadata-tile.gs"
		self->path_link = (_tmp4_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->path_link), _tmp4_);
#line 111 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->path_link, "xalign", (float) 0, NULL);
#line 112 "tracker-metadata-tile.gs"
		self->path_label = (_tmp5_ = tracker_metadata_tile_CreateLabel (self, N_ ("Folder:"), FALSE), _g_object_unref0 (self->path_label), _tmp5_);
#line 113 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->path_label, 3, 4, 0, 1, FALSE);
#line 114 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->path_link, (guint) 4, (guint) 7, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 116 "tracker-metadata-tile.gs"
		self->info_label1 = (_tmp6_ = tracker_metadata_tile_CreateLabel (self, N_ ("Type:"), FALSE), _g_object_unref0 (self->info_label1), _tmp6_);
#line 117 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label1, 1, 2, 1, 2, FALSE);
#line 119 "tracker-metadata-tile.gs"
		self->info_value1 = (_tmp7_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value1), _tmp7_);
#line 120 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value1, 2, 3, 1, 2, TRUE);
#line 122 "tracker-metadata-tile.gs"
		self->info_label2 = (_tmp8_ = tracker_metadata_tile_CreateLabel (self, N_ ("Size:"), FALSE), _g_object_unref0 (self->info_label2), _tmp8_);
#line 123 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label2, 3, 4, 1, 2, FALSE);
#line 125 "tracker-metadata-tile.gs"
		self->info_value2 = (_tmp9_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value2), _tmp9_);
#line 126 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value2, 4, 5, 1, 2, TRUE);
#line 128 "tracker-metadata-tile.gs"
		self->info_label3 = (_tmp10_ = tracker_metadata_tile_CreateLabel (self, N_ ("Modified:"), FALSE), _g_object_unref0 (self->info_label3), _tmp10_);
#line 129 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label3, 5, 6, 1, 2, FALSE);
#line 131 "tracker-metadata-tile.gs"
		self->info_value3 = (_tmp11_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value3), _tmp11_);
#line 132 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value3, 6, 7, 1, 2, TRUE);
#line 134 "tracker-metadata-tile.gs"
		self->info_label4 = (_tmp12_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label4), _tmp12_);
#line 135 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label4, 1, 2, 2, 3, FALSE);
#line 137 "tracker-metadata-tile.gs"
		self->info_value4 = (_tmp13_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value4), _tmp13_);
#line 138 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value4, 2, 3, 2, 3, TRUE);
#line 140 "tracker-metadata-tile.gs"
		self->info_label5 = (_tmp14_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label5), _tmp14_);
#line 141 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label5, 3, 4, 2, 3, FALSE);
#line 143 "tracker-metadata-tile.gs"
		self->info_value5 = (_tmp15_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value5), _tmp15_);
#line 144 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value5, 4, 5, 2, 3, TRUE);
#line 146 "tracker-metadata-tile.gs"
		self->info_label6 = (_tmp16_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label6), _tmp16_);
#line 147 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label6, 5, 6, 2, 3, FALSE);
#line 149 "tracker-metadata-tile.gs"
		self->info_value6 = (_tmp17_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value6), _tmp17_);
#line 150 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value6, 6, 7, 2, 3, TRUE);
#line 152 "tracker-metadata-tile.gs"
		self->sparql = (_tmp18_ = g_strdup ("SELECT ?mimetype WHERE {<%s> nie:mimeType ?mimetype.}"), _g_free0 (self->sparql), _tmp18_);
#line 154 "tracker-metadata-tile.gs"
		tracker_metadata_tile_ClearLabels (self);
#line 1191 "tracker-metadata-tile.c"
	}
	return obj;
}


static void tracker_metadata_tile_class_init (TrackerMetadataTileClass * klass) {
	tracker_metadata_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMetadataTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_metadata_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_metadata_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_metadata_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_metadata_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_RESULT_GRID, g_param_spec_object ("ResultGrid", "ResultGrid", "ResultGrid", TYPE_TRACKER_RESULT_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_metadata_tile_instance_init (TrackerMetadataTile * self) {
	self->priv = TRACKER_METADATA_TILE_GET_PRIVATE (self);
}


static void tracker_metadata_tile_finalize (GObject* obj) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (obj);
	_g_free0 (self->uri);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->name_link);
	_g_object_unref0 (self->path_link);
	_g_object_unref0 (self->table);
	_g_free0 (self->sparql);
	_g_object_unref0 (self->name_label);
	_g_object_unref0 (self->path_label);
	_g_object_unref0 (self->info_label1);
	_g_object_unref0 (self->info_value1);
	_g_object_unref0 (self->info_label2);
	_g_object_unref0 (self->info_value2);
	_g_object_unref0 (self->info_label3);
	_g_object_unref0 (self->info_value3);
	_g_object_unref0 (self->info_label4);
	_g_object_unref0 (self->info_value4);
	_g_object_unref0 (self->info_label5);
	_g_object_unref0 (self->info_value5);
	_g_object_unref0 (self->info_label6);
	_g_object_unref0 (self->info_value6);
	_g_object_unref0 (self->info_label7);
	_g_object_unref0 (self->info_value7);
	_g_object_unref0 (self->info_label8);
	_g_object_unref0 (self->info_value8);
	_g_object_unref0 (self->priv->_result_grid);
	G_OBJECT_CLASS (tracker_metadata_tile_parent_class)->finalize (obj);
}


GType tracker_metadata_tile_get_type (void) {
	static volatile gsize tracker_metadata_tile_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_metadata_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMetadataTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_metadata_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMetadataTile), 0, (GInstanceInitFunc) tracker_metadata_tile_instance_init, NULL };
		GType tracker_metadata_tile_type_id;
		tracker_metadata_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "TrackerMetadataTile", &g_define_type_info, 0);
		g_once_init_leave (&tracker_metadata_tile_type_id__volatile, tracker_metadata_tile_type_id);
	}
	return tracker_metadata_tile_type_id__volatile;
}


static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		g_value_set_object (value, tracker_metadata_tile_get_Query (self));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		g_value_set_object (value, tracker_metadata_tile_get_ResultGrid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		tracker_metadata_tile_set_Query (self, g_value_get_object (value));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		tracker_metadata_tile_set_ResultGrid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




