/* tracker-bus.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-bus.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tracker-sparql.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <dbus/dbus.h>
#include <config.h>
#include <libtracker-bus/tracker-bus-fd-cursor.h>
#include <tracker-bus-fd-update.h>
#include <tracker-bus-array-update.h>


#define TRACKER_BUS_TYPE_RESOURCES (tracker_bus_resources_get_type ())
#define TRACKER_BUS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_RESOURCES, TrackerBusResources))
#define TRACKER_BUS_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_RESOURCES))
#define TRACKER_BUS_RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BUS_TYPE_RESOURCES, TrackerBusResourcesIface))

typedef struct _TrackerBusResources TrackerBusResources;
typedef struct _TrackerBusResourcesIface TrackerBusResourcesIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerBusResourcesDBusProxy TrackerBusResourcesDBusProxy;
typedef DBusGProxyClass TrackerBusResourcesDBusProxyClass;
typedef struct _TrackerBusResourcesDBusProxySparqlQueryAsyncData TrackerBusResourcesDBusProxySparqlQueryAsyncData;
typedef struct _TrackerBusResourcesDBusProxySparqlUpdateAsyncData TrackerBusResourcesDBusProxySparqlUpdateAsyncData;
typedef struct _TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData;
typedef struct _TrackerBusResourcesDBusProxyLoadAsyncData TrackerBusResourcesDBusProxyLoadAsyncData;

#define TRACKER_BUS_TYPE_STATISTICS (tracker_bus_statistics_get_type ())
#define TRACKER_BUS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_STATISTICS, TrackerBusStatistics))
#define TRACKER_BUS_IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_STATISTICS))
#define TRACKER_BUS_STATISTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BUS_TYPE_STATISTICS, TrackerBusStatisticsIface))

typedef struct _TrackerBusStatistics TrackerBusStatistics;
typedef struct _TrackerBusStatisticsIface TrackerBusStatisticsIface;
typedef struct _TrackerBusStatisticsDBusProxy TrackerBusStatisticsDBusProxy;
typedef DBusGProxyClass TrackerBusStatisticsDBusProxyClass;
typedef struct _TrackerBusStatisticsDBusProxyGet_asyncData TrackerBusStatisticsDBusProxyGet_asyncData;

#define TRACKER_BUS_TYPE_CONNECTION (tracker_bus_connection_get_type ())
#define TRACKER_BUS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection))
#define TRACKER_BUS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnectionClass))
#define TRACKER_BUS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_CONNECTION))
#define TRACKER_BUS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_CONNECTION))
#define TRACKER_BUS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnectionClass))

typedef struct _TrackerBusConnection TrackerBusConnection;
typedef struct _TrackerBusConnectionClass TrackerBusConnectionClass;
typedef struct _TrackerBusConnectionPrivate TrackerBusConnectionPrivate;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_BUS_TYPE_ARRAY_CURSOR (tracker_bus_array_cursor_get_type ())
#define TRACKER_BUS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor))
#define TRACKER_BUS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))
#define TRACKER_BUS_IS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_IS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_ARRAY_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))

typedef struct _TrackerBusArrayCursor TrackerBusArrayCursor;
typedef struct _TrackerBusArrayCursorClass TrackerBusArrayCursorClass;
typedef struct _TrackerBusConnectionQueryAsyncData TrackerBusConnectionQueryAsyncData;
typedef struct _TrackerBusConnectionUpdateAsyncData TrackerBusConnectionUpdateAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerBusConnectionUpdateBlankAsyncData TrackerBusConnectionUpdateBlankAsyncData;
typedef struct _TrackerBusConnectionLoadAsyncData TrackerBusConnectionLoadAsyncData;
typedef struct _TrackerBusConnectionStatisticsAsyncData TrackerBusConnectionStatisticsAsyncData;

struct _TrackerBusResourcesIface {
	GTypeInterface parent_iface;
	char** (*sparql_query) (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error);
	void (*sparql_query_async) (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (TrackerBusResources* self, const char* query, GError** error);
	void (*sparql_update_async) (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
	void (*batch_sparql_update) (TrackerBusResources* self, const char* query, GError** error);
	void (*batch_sparql_update_async) (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*batch_sparql_update_finish) (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerBusResources* self, const char* uri, GError** error);
	void (*load_async) (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _TrackerBusResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerBusResourcesDBusProxySparqlQueryAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusResourcesDBusProxySparqlUpdateAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusResourcesDBusProxyLoadAsyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusStatisticsIface {
	GTypeInterface parent_iface;
	char** (*Get) (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error);
	void (*Get_async) (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*Get_finish) (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _TrackerBusStatisticsDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerBusStatisticsDBusProxyGet_asyncData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _TrackerBusConnection {
	TrackerSparqlConnection parent_instance;
	TrackerBusConnectionPrivate * priv;
};

struct _TrackerBusConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerBusConnectionQueryAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	char* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	char** results;
	gint _tmp1_;
	gint _tmp2_;
	gint results_length1;
	gint results_length2;
	char** _tmp3_;
	gboolean _tmp4_;
	char** _tmp5_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionUpdateAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionUpdateBlankAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	GVariant* res;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionLoadAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	GFile* file;
	GCancellable* cancellable;
	char* _tmp0_;
	gboolean _tmp1_;
	GError * e;
	GError * _inner_error_;
};

struct _TrackerBusConnectionStatisticsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerBusConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	char** results;
	gint _tmp0_;
	gint _tmp1_;
	gint results_length1;
	gint results_length2;
	char** _tmp2_;
	gboolean _tmp3_;
	char** _tmp4_;
	GError * e;
	GError * _inner_error_;
};


static DBusGConnection* tracker_bus_connection_connection;
static DBusGConnection* tracker_bus_connection_connection = NULL;
static TrackerBusResources* tracker_bus_connection_resources_object;
static TrackerBusResources* tracker_bus_connection_resources_object = NULL;
static TrackerBusStatistics* tracker_bus_connection_statistics_object;
static TrackerBusStatistics* tracker_bus_connection_statistics_object = NULL;
static gboolean tracker_bus_connection_initialized;
static gboolean tracker_bus_connection_initialized = FALSE;
static gboolean tracker_bus_connection_use_steroids;
static gboolean tracker_bus_connection_use_steroids = FALSE;
static gpointer tracker_bus_connection_parent_class = NULL;

TrackerBusResources* tracker_bus_resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType tracker_bus_resources_get_type (void) G_GNUC_CONST;
char** tracker_bus_resources_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error);
void tracker_bus_resources_sparql_query_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** tracker_bus_resources_sparql_query_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
void tracker_bus_resources_sparql_update (TrackerBusResources* self, const char* query, GError** error);
void tracker_bus_resources_sparql_update_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_bus_resources_sparql_update_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
void tracker_bus_resources_batch_sparql_update (TrackerBusResources* self, const char* query, GError** error);
void tracker_bus_resources_batch_sparql_update_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_bus_resources_batch_sparql_update_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
void tracker_bus_resources_load (TrackerBusResources* self, const char* uri, GError** error);
void tracker_bus_resources_load_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_bus_resources_load_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void tracker_bus_resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _tracker_bus_resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult tracker_bus_resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_tracker_bus_resources_introspect (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_property_get_all (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_sparql_query_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_tracker_bus_resources_batch_sparql_update (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_batch_sparql_update_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_batch_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_tracker_bus_resources_load (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_resources_load_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_resources_load_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType tracker_bus_resources_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult tracker_bus_resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TRACKER_BUS_RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static char** tracker_bus_resources_dbus_proxy_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_resources_dbus_proxy_sparql_query_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_sparql_query_async_ready (DBusPendingCall* pending, void* user_data);
static char** tracker_bus_resources_dbus_proxy_sparql_query_async_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_resources_dbus_proxy_sparql_update (TrackerBusResources* self, const char* query, GError** error);
static void tracker_bus_resources_dbus_proxy_sparql_update_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_sparql_update_async_ready (DBusPendingCall* pending, void* user_data);
static void tracker_bus_resources_dbus_proxy_sparql_update_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void tracker_bus_resources_dbus_proxy_batch_sparql_update (TrackerBusResources* self, const char* query, GError** error);
static void tracker_bus_resources_dbus_proxy_batch_sparql_update_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_batch_sparql_update_async_ready (DBusPendingCall* pending, void* user_data);
static void tracker_bus_resources_dbus_proxy_batch_sparql_update_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void tracker_bus_resources_dbus_proxy_load (TrackerBusResources* self, const char* uri, GError** error);
static void tracker_bus_resources_dbus_proxy_load_async_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_resources_dbus_proxy_load_async_ready (DBusPendingCall* pending, void* user_data);
static void tracker_bus_resources_dbus_proxy_load_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error);
static void tracker_bus_resources_dbus_proxy_tracker_bus_resources__interface_init (TrackerBusResourcesIface* iface);
static void tracker_bus_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_bus_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
TrackerBusStatistics* tracker_bus_statistics_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType tracker_bus_statistics_get_type (void) G_GNUC_CONST;
char** tracker_bus_statistics_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error);
void tracker_bus_statistics_Get_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** tracker_bus_statistics_Get_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
void tracker_bus_statistics_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _tracker_bus_statistics_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult tracker_bus_statistics_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_tracker_bus_statistics_introspect (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_statistics_property_get_all (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_statistics_Get (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_tracker_bus_statistics_Get_async (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_tracker_bus_statistics_Get_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType tracker_bus_statistics_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult tracker_bus_statistics_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TRACKER_BUS_STATISTICS_DBUS_PROXY_DUMMY_PROPERTY
};
static char** tracker_bus_statistics_dbus_proxy_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_statistics_dbus_proxy_Get_async_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_statistics_dbus_proxy_Get_async_ready (DBusPendingCall* pending, void* user_data);
static char** tracker_bus_statistics_dbus_proxy_Get_async_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void tracker_bus_statistics_dbus_proxy_tracker_bus_statistics__interface_init (TrackerBusStatisticsIface* iface);
static void tracker_bus_statistics_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_bus_statistics_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
TrackerSparqlCursor* tracker_bus_fd_query (DBusGConnection* connection, const char* query, GCancellable* cancellable, GError** error);
GType tracker_bus_connection_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_BUS_CONNECTION_DUMMY_PROPERTY
};
TrackerBusConnection* tracker_bus_connection_new (void);
TrackerBusConnection* tracker_bus_connection_construct (GType object_type);
TrackerBusArrayCursor* tracker_bus_array_cursor_new (char** results, int results_length1, int results_length2, gint rows, gint cols);
TrackerBusArrayCursor* tracker_bus_array_cursor_construct (GType object_type, char** results, int results_length1, int results_length2, gint rows, gint cols);
GType tracker_bus_array_cursor_get_type (void) G_GNUC_CONST;
static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_query_async_data_free (gpointer _data);
static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* data);
static void tracker_bus_connection_real_update (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_update_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* data);
static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* data);
static void tracker_bus_connection_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_load_async_data_free (gpointer _data);
static void tracker_bus_connection_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* data);
static TrackerSparqlCursor* tracker_bus_connection_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_bus_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_bus_connection_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* data);
static void tracker_bus_connection_finalize (GObject* obj);
TrackerSparqlConnection* module_init (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _tracker_bus_resources_dbus_path_vtable = {_tracker_bus_resources_dbus_unregister, tracker_bus_resources_dbus_message};
static const _DBusObjectVTable _tracker_bus_resources_dbus_vtable = {tracker_bus_resources_dbus_register_object};
static const DBusObjectPathVTable _tracker_bus_statistics_dbus_path_vtable = {_tracker_bus_statistics_dbus_unregister, tracker_bus_statistics_dbus_message};
static const _DBusObjectVTable _tracker_bus_statistics_dbus_vtable = {tracker_bus_statistics_dbus_register_object};


char** tracker_bus_resources_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_query (self, query, result_length1, result_length2, error);
}


void tracker_bus_resources_sparql_query_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_query_async (self, query, _callback_, _user_data_);
}


char** tracker_bus_resources_sparql_query_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_query_finish (self, _res_, result_length1, result_length2, error);
}


void tracker_bus_resources_sparql_update (TrackerBusResources* self, const char* query, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_update (self, query, error);
}


void tracker_bus_resources_sparql_update_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_update_async (self, query, _callback_, _user_data_);
}


void tracker_bus_resources_sparql_update_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->sparql_update_finish (self, _res_, error);
}


void tracker_bus_resources_batch_sparql_update (TrackerBusResources* self, const char* query, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->batch_sparql_update (self, query, error);
}


void tracker_bus_resources_batch_sparql_update_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->batch_sparql_update_async (self, query, _callback_, _user_data_);
}


void tracker_bus_resources_batch_sparql_update_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->batch_sparql_update_finish (self, _res_, error);
}


void tracker_bus_resources_load (TrackerBusResources* self, const char* uri, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->load (self, uri, error);
}


void tracker_bus_resources_load_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->load_async (self, uri, _callback_, _user_data_);
}


void tracker_bus_resources_load_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BUS_RESOURCES_GET_INTERFACE (self)->load_finish (self, _res_, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _tracker_bus_resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_tracker_bus_resources_introspect (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"BatchSparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"BatchSparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"Load\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"Load\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_property_get_all (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query = NULL;
	const char* _tmp1_;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp2_;
	DBusMessageIter _tmp3_;
	int _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp1_);
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_resources_sparql_query (self, query, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	_tmp2_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp3_);
	for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
		DBusMessageIter _tmp5_;
		int _tmp6_;
		dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_ARRAY, "s", &_tmp5_);
		for (_tmp6_ = 0; _tmp6_ < result_length2; _tmp6_++) {
			const char* _tmp7_;
			_tmp7_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp5_, DBUS_TYPE_STRING, &_tmp7_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&_tmp3_, &_tmp5_);
	}
	dbus_message_iter_close_container (&iter, &_tmp3_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_query_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp8_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp8_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_sparql_query_async (self, query, (GAsyncReadyCallback) _dbus_tracker_bus_resources_sparql_query_async_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_sparql_query_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp9_;
	DBusMessageIter _tmp10_;
	int _tmp11_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_resources_sparql_query_finish ((TrackerBusResources*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp9_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp10_);
	for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
		DBusMessageIter _tmp12_;
		int _tmp13_;
		dbus_message_iter_open_container (&_tmp10_, DBUS_TYPE_ARRAY, "s", &_tmp12_);
		for (_tmp13_ = 0; _tmp13_ < result_length2; _tmp13_++) {
			const char* _tmp14_;
			_tmp14_ = *_tmp9_;
			dbus_message_iter_append_basic (&_tmp12_, DBUS_TYPE_STRING, &_tmp14_);
			_tmp9_++;
		}
		dbus_message_iter_close_container (&_tmp10_, &_tmp12_);
	}
	dbus_message_iter_close_container (&iter, &_tmp10_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query = NULL;
	const char* _tmp15_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp15_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp15_);
	tracker_bus_resources_sparql_update (self, query, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_sparql_update_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp16_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp16_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_sparql_update_async (self, query, (GAsyncReadyCallback) _dbus_tracker_bus_resources_sparql_update_async_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	tracker_bus_resources_sparql_update_finish ((TrackerBusResources*) source_object, _res_, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_tracker_bus_resources_batch_sparql_update (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query = NULL;
	const char* _tmp17_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp17_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp17_);
	tracker_bus_resources_batch_sparql_update (self, query, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_batch_sparql_update_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp18_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp18_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp18_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_batch_sparql_update_async (self, query, (GAsyncReadyCallback) _dbus_tracker_bus_resources_batch_sparql_update_async_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_batch_sparql_update_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	tracker_bus_resources_batch_sparql_update_finish ((TrackerBusResources*) source_object, _res_, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_tracker_bus_resources_load (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* uri = NULL;
	const char* _tmp19_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp19_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp19_);
	tracker_bus_resources_load (self, uri, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (uri);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_resources_load_async (TrackerBusResources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* uri = NULL;
	const char* _tmp20_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp20_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp20_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_resources_load_async (self, uri, (GAsyncReadyCallback) _dbus_tracker_bus_resources_load_async_ready, _user_data_);
	_g_free0 (uri);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_resources_load_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	tracker_bus_resources_load_finish ((TrackerBusResources*) source_object, _res_, &error);
	if (error) {
		if (error->domain == TRACKER_SPARQL_ERROR) {
			switch (error->code) {
				case TRACKER_SPARQL_ERROR_PARSE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Parse", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_CLASS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownClass", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.UnknownProperty", error->message);
				break;
				case TRACKER_SPARQL_ERROR_TYPE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Type", error->message);
				break;
				case TRACKER_SPARQL_ERROR_CONSTRAINT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Constraint", error->message);
				break;
				case TRACKER_SPARQL_ERROR_NO_SPACE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.NoSpace", error->message);
				break;
				case TRACKER_SPARQL_ERROR_INTERNAL:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Internal", error->message);
				break;
				case TRACKER_SPARQL_ERROR_UNSUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark.Unsupported", error->message);
				break;
			}
		} else if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult tracker_bus_resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_tracker_bus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_tracker_bus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_tracker_bus_resources_sparql_query (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_tracker_bus_resources_sparql_query_async (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_tracker_bus_resources_sparql_update (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_tracker_bus_resources_sparql_update_async (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "BatchSparqlUpdate")) {
		result = _dbus_tracker_bus_resources_batch_sparql_update (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "BatchSparqlUpdate")) {
		result = _dbus_tracker_bus_resources_batch_sparql_update_async (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "Load")) {
		result = _dbus_tracker_bus_resources_load (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "Load")) {
		result = _dbus_tracker_bus_resources_load_async (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void tracker_bus_resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_tracker_bus_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void tracker_bus_resources_base_init (TrackerBusResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TRACKER_BUS_TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_tracker_bus_resources_dbus_vtable));
	}
}


GType tracker_bus_resources_get_type (void) {
	static volatile gsize tracker_bus_resources_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusResourcesIface), (GBaseInitFunc) tracker_bus_resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_bus_resources_type_id;
		tracker_bus_resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBusResources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_bus_resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (tracker_bus_resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &tracker_bus_resources_dbus_proxy_get_type);
		g_once_init_leave (&tracker_bus_resources_type_id__volatile, tracker_bus_resources_type_id);
	}
	return tracker_bus_resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBusResourcesDBusProxy, tracker_bus_resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BUS_TYPE_RESOURCES, tracker_bus_resources_dbus_proxy_tracker_bus_resources__interface_init) );
TrackerBusResources* tracker_bus_resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TrackerBusResources* self;
	self = g_object_new (tracker_bus_resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* tracker_bus_resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (tracker_bus_resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), tracker_bus_resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult tracker_bus_resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void tracker_bus_resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((TrackerBusResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), tracker_bus_resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (tracker_bus_resources_dbus_proxy_parent_class)->dispose (self);
}


static void tracker_bus_resources_dbus_proxy_class_init (TrackerBusResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = tracker_bus_resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = tracker_bus_resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = tracker_bus_resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_bus_resources_dbus_proxy_set_property;
}


static void tracker_bus_resources_dbus_proxy_init (TrackerBusResourcesDBusProxy* self) {
}


static char** tracker_bus_resources_dbus_proxy_sparql_query (TrackerBusResources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp21_;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp22_;
	int _tmp22__length;
	int _tmp22__size;
	int _tmp22__length1;
	DBusMessageIter _tmp23_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp21_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp21_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, 2147483647, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp26_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp26_ = _dbus_error.name + 64;
			if (strcmp (_tmp26_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp26_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp26_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp26_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp26_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp26_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp26_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp26_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp27_;
			_edomain = DBUS_GERROR;
			_tmp27_ = _dbus_error.name + 27;
			if (strcmp (_tmp27_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp27_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp27_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp27_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp27_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp27_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp27_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp27_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp27_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp27_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp27_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp27_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp27_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp27_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp27_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp27_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp27_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp27_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp27_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp27_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp27_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp27_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp27_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp27_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp27_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp27_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp27_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp27_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp27_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp27_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp27_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp27_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp27_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp22_ = g_new (char*, 5);
	_tmp22__length = 0;
	_tmp22__size = 4;
	_tmp22__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp23_);
	for (; dbus_message_iter_get_arg_type (&_tmp23_); _tmp22__length1++) {
		int _tmp22__length2;
		DBusMessageIter _tmp24_;
		_tmp22__length2 = 0;
		dbus_message_iter_recurse (&_tmp23_, &_tmp24_);
		for (; dbus_message_iter_get_arg_type (&_tmp24_); _tmp22__length2++) {
			const char* _tmp25_;
			if (_tmp22__size == _tmp22__length) {
				_tmp22__size = 2 * _tmp22__size;
				_tmp22_ = g_renew (char*, _tmp22_, _tmp22__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp24_, &_tmp25_);
			dbus_message_iter_next (&_tmp24_);
			_tmp22_[_tmp22__length++] = g_strdup (_tmp25_);
		}
		_result_length2 = _tmp22__length2;
		dbus_message_iter_next (&_tmp23_);
	}
	_result_length1 = _tmp22__length1;
	_tmp22_[_tmp22__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp22_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_resources_dbus_proxy_sparql_query_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp28_;
	TrackerBusResourcesDBusProxySparqlQueryAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp28_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp28_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, 2147483647);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxySparqlQueryAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_sparql_query_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_sparql_query_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxySparqlQueryAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxySparqlQueryAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static char** tracker_bus_resources_dbus_proxy_sparql_query_async_finish (TrackerBusResources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	TrackerBusResourcesDBusProxySparqlQueryAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp36_;
	int _tmp36__length;
	int _tmp36__size;
	int _tmp36__length1;
	DBusMessageIter _tmp37_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp33_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp33_ = _dbus_error.name + 64;
			if (strcmp (_tmp33_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp33_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp33_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp33_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp33_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp33_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp33_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp33_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp34_;
			_edomain = DBUS_GERROR;
			_tmp34_ = _dbus_error.name + 27;
			if (strcmp (_tmp34_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp34_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp34_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp34_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp34_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp34_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp34_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp34_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp34_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp34_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp34_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp34_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp34_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp34_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp34_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp34_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp34_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp34_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp34_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp34_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp34_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp34_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp34_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp34_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp34_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp34_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp34_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp34_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp34_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp34_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp34_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp34_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp34_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp36_ = g_new (char*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp37_);
	for (; dbus_message_iter_get_arg_type (&_tmp37_); _tmp36__length1++) {
		int _tmp36__length2;
		DBusMessageIter _tmp38_;
		_tmp36__length2 = 0;
		dbus_message_iter_recurse (&_tmp37_, &_tmp38_);
		for (; dbus_message_iter_get_arg_type (&_tmp38_); _tmp36__length2++) {
			const char* _tmp39_;
			if (_tmp36__size == _tmp36__length) {
				_tmp36__size = 2 * _tmp36__size;
				_tmp36_ = g_renew (char*, _tmp36_, _tmp36__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp38_, &_tmp39_);
			dbus_message_iter_next (&_tmp38_);
			_tmp36_[_tmp36__length++] = g_strdup (_tmp39_);
		}
		_result_length2 = _tmp36__length2;
		dbus_message_iter_next (&_tmp37_);
	}
	_result_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp36_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_resources_dbus_proxy_sparql_update (TrackerBusResources* self, const char* query, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp40_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp40_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp40_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, 2147483647, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp41_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp41_ = _dbus_error.name + 64;
			if (strcmp (_tmp41_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp41_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp41_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp41_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp41_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp41_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp41_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp41_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp42_;
			_edomain = DBUS_GERROR;
			_tmp42_ = _dbus_error.name + 27;
			if (strcmp (_tmp42_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp42_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp42_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp42_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp42_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp42_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp42_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp42_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp42_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp42_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp42_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp42_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp42_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp42_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp42_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp42_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp42_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp42_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp42_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp42_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp42_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp42_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp42_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp42_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp42_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp42_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp42_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp42_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp42_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp42_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp42_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp42_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp42_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_sparql_update_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp43_;
	TrackerBusResourcesDBusProxySparqlUpdateAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp43_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp43_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, 2147483647);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxySparqlUpdateAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_sparql_update_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_sparql_update_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxySparqlUpdateAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxySparqlUpdateAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void tracker_bus_resources_dbus_proxy_sparql_update_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TrackerBusResourcesDBusProxySparqlUpdateAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp44_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp44_ = _dbus_error.name + 64;
			if (strcmp (_tmp44_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp44_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp44_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp44_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp44_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp44_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp44_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp44_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp45_;
			_edomain = DBUS_GERROR;
			_tmp45_ = _dbus_error.name + 27;
			if (strcmp (_tmp45_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp45_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp45_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp45_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp45_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp45_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp45_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp45_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp45_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp45_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp45_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp45_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp45_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp45_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp45_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp45_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp45_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp45_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp45_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp45_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp45_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp45_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp45_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp45_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp45_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp45_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp45_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp45_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp45_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp45_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp45_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp45_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp45_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_batch_sparql_update (TrackerBusResources* self, const char* query, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp47_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "BatchSparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp47_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp47_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, 2147483647, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp48_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp48_ = _dbus_error.name + 64;
			if (strcmp (_tmp48_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp48_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp48_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp48_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp48_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp48_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp48_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp48_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp49_;
			_edomain = DBUS_GERROR;
			_tmp49_ = _dbus_error.name + 27;
			if (strcmp (_tmp49_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp49_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp49_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp49_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp49_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp49_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp49_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp49_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp49_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp49_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp49_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp49_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp49_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp49_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp49_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp49_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp49_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp49_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp49_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp49_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp49_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp49_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp49_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp49_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp49_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp49_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp49_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp49_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp49_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp49_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp49_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp49_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp49_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_batch_sparql_update_async_async (TrackerBusResources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp50_;
	TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "BatchSparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp50_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp50_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, 2147483647);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_batch_sparql_update_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_batch_sparql_update_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void tracker_bus_resources_dbus_proxy_batch_sparql_update_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TrackerBusResourcesDBusProxyBatchSparqlUpdateAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp51_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp51_ = _dbus_error.name + 64;
			if (strcmp (_tmp51_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp51_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp51_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp51_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp51_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp51_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp51_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp51_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp52_;
			_edomain = DBUS_GERROR;
			_tmp52_ = _dbus_error.name + 27;
			if (strcmp (_tmp52_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp52_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp52_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp52_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp52_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp52_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp52_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp52_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp52_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp52_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp52_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp52_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp52_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp52_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp52_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp52_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp52_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp52_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp52_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp52_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp52_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp52_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp52_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp52_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp52_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp52_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp52_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp52_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp52_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp52_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp52_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp52_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp52_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_load (TrackerBusResources* self, const char* uri, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp54_;
	if (((TrackerBusResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "Load");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp54_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp54_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, 2147483647, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp55_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp55_ = _dbus_error.name + 64;
			if (strcmp (_tmp55_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp55_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp55_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp55_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp55_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp55_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp55_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp55_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp56_;
			_edomain = DBUS_GERROR;
			_tmp56_ = _dbus_error.name + 27;
			if (strcmp (_tmp56_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp56_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp56_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp56_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp56_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp56_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp56_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp56_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp56_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp56_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp56_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp56_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp56_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp56_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp56_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp56_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp56_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp56_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp56_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp56_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp56_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp56_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp56_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp56_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp56_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp56_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp56_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp56_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp56_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp56_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp56_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp56_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp56_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_load_async_async (TrackerBusResources* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp57_;
	TrackerBusResourcesDBusProxyLoadAsyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "Load");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp57_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp57_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, 2147483647);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusResourcesDBusProxyLoadAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_resources_dbus_proxy_load_async_ready, _data_, NULL);
}


static void tracker_bus_resources_dbus_proxy_load_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusResourcesDBusProxyLoadAsyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusResourcesDBusProxyLoadAsyncData, _data_);
	dbus_pending_call_unref (pending);
}


static void tracker_bus_resources_dbus_proxy_load_async_finish (TrackerBusResources* self, GAsyncResult* _res_, GError** error) {
	TrackerBusResourcesDBusProxyLoadAsyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.GLib.UnmappedError.TrackerSparqlErrorQuark") == _dbus_error.name) {
			const char* _tmp58_;
			_edomain = TRACKER_SPARQL_ERROR;
			_tmp58_ = _dbus_error.name + 64;
			if (strcmp (_tmp58_, "Parse") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_PARSE;
			} else if (strcmp (_tmp58_, "UnknownClass") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_CLASS;
			} else if (strcmp (_tmp58_, "UnknownProperty") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY;
			} else if (strcmp (_tmp58_, "Type") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_TYPE;
			} else if (strcmp (_tmp58_, "Constraint") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_CONSTRAINT;
			} else if (strcmp (_tmp58_, "NoSpace") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_NO_SPACE;
			} else if (strcmp (_tmp58_, "Internal") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_INTERNAL;
			} else if (strcmp (_tmp58_, "Unsupported") == 0) {
				_ecode = TRACKER_SPARQL_ERROR_UNSUPPORTED;
			}
		} else if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp59_;
			_edomain = DBUS_GERROR;
			_tmp59_ = _dbus_error.name + 27;
			if (strcmp (_tmp59_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp59_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp59_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp59_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp59_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp59_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp59_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp59_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp59_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp59_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp59_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp59_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp59_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp59_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp59_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp59_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp59_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp59_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp59_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp59_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp59_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp59_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp59_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp59_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp59_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp59_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp59_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp59_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp59_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp59_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp59_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp59_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp59_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void tracker_bus_resources_dbus_proxy_tracker_bus_resources__interface_init (TrackerBusResourcesIface* iface) {
	iface->sparql_query = tracker_bus_resources_dbus_proxy_sparql_query;
	iface->sparql_query_async = tracker_bus_resources_dbus_proxy_sparql_query_async_async;
	iface->sparql_query_finish = tracker_bus_resources_dbus_proxy_sparql_query_async_finish;
	iface->sparql_update = tracker_bus_resources_dbus_proxy_sparql_update;
	iface->sparql_update_async = tracker_bus_resources_dbus_proxy_sparql_update_async_async;
	iface->sparql_update_finish = tracker_bus_resources_dbus_proxy_sparql_update_async_finish;
	iface->batch_sparql_update = tracker_bus_resources_dbus_proxy_batch_sparql_update;
	iface->batch_sparql_update_async = tracker_bus_resources_dbus_proxy_batch_sparql_update_async_async;
	iface->batch_sparql_update_finish = tracker_bus_resources_dbus_proxy_batch_sparql_update_async_finish;
	iface->load = tracker_bus_resources_dbus_proxy_load;
	iface->load_async = tracker_bus_resources_dbus_proxy_load_async_async;
	iface->load_finish = tracker_bus_resources_dbus_proxy_load_async_finish;
}


static void tracker_bus_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void tracker_bus_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** tracker_bus_statistics_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_STATISTICS_GET_INTERFACE (self)->Get (self, result_length1, result_length2, error);
}


void tracker_bus_statistics_Get_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BUS_STATISTICS_GET_INTERFACE (self)->Get_async (self, _callback_, _user_data_);
}


char** tracker_bus_statistics_Get_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return TRACKER_BUS_STATISTICS_GET_INTERFACE (self)->Get_finish (self, _res_, result_length1, result_length2, error);
}


void _tracker_bus_statistics_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_tracker_bus_statistics_introspect (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Statistics\">\n  <method name=\"Get\">\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"Get_async\">\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_statistics_property_get_all (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp61_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp61_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp61_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Statistics") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_statistics_Get (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp62_;
	DBusMessageIter _tmp63_;
	int _tmp64_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_statistics_Get (self, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp62_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp63_);
	for (_tmp64_ = 0; _tmp64_ < result_length1; _tmp64_++) {
		DBusMessageIter _tmp65_;
		int _tmp66_;
		dbus_message_iter_open_container (&_tmp63_, DBUS_TYPE_ARRAY, "s", &_tmp65_);
		for (_tmp66_ = 0; _tmp66_ < result_length2; _tmp66_++) {
			const char* _tmp67_;
			_tmp67_ = *_tmp62_;
			dbus_message_iter_append_basic (&_tmp65_, DBUS_TYPE_STRING, &_tmp67_);
			_tmp62_++;
		}
		dbus_message_iter_close_container (&_tmp63_, &_tmp65_);
	}
	dbus_message_iter_close_container (&iter, &_tmp63_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_tracker_bus_statistics_Get_async (TrackerBusStatistics* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	tracker_bus_statistics_Get_async (self, (GAsyncReadyCallback) _dbus_tracker_bus_statistics_Get_async_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_tracker_bus_statistics_Get_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp68_;
	DBusMessageIter _tmp69_;
	int _tmp70_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = tracker_bus_statistics_Get_finish ((TrackerBusStatistics*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp68_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp69_);
	for (_tmp70_ = 0; _tmp70_ < result_length1; _tmp70_++) {
		DBusMessageIter _tmp71_;
		int _tmp72_;
		dbus_message_iter_open_container (&_tmp69_, DBUS_TYPE_ARRAY, "s", &_tmp71_);
		for (_tmp72_ = 0; _tmp72_ < result_length2; _tmp72_++) {
			const char* _tmp73_;
			_tmp73_ = *_tmp68_;
			dbus_message_iter_append_basic (&_tmp71_, DBUS_TYPE_STRING, &_tmp73_);
			_tmp68_++;
		}
		dbus_message_iter_close_container (&_tmp69_, &_tmp71_);
	}
	dbus_message_iter_close_container (&iter, &_tmp69_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult tracker_bus_statistics_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_tracker_bus_statistics_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_tracker_bus_statistics_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Statistics", "Get")) {
		result = _dbus_tracker_bus_statistics_Get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Statistics", "Get_async")) {
		result = _dbus_tracker_bus_statistics_Get_async (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void tracker_bus_statistics_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_tracker_bus_statistics_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void tracker_bus_statistics_base_init (TrackerBusStatisticsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TRACKER_BUS_TYPE_STATISTICS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_tracker_bus_statistics_dbus_vtable));
	}
}


GType tracker_bus_statistics_get_type (void) {
	static volatile gsize tracker_bus_statistics_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_statistics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusStatisticsIface), (GBaseInitFunc) tracker_bus_statistics_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_bus_statistics_type_id;
		tracker_bus_statistics_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBusStatistics", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_bus_statistics_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (tracker_bus_statistics_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &tracker_bus_statistics_dbus_proxy_get_type);
		g_once_init_leave (&tracker_bus_statistics_type_id__volatile, tracker_bus_statistics_type_id);
	}
	return tracker_bus_statistics_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBusStatisticsDBusProxy, tracker_bus_statistics_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BUS_TYPE_STATISTICS, tracker_bus_statistics_dbus_proxy_tracker_bus_statistics__interface_init) );
TrackerBusStatistics* tracker_bus_statistics_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TrackerBusStatistics* self;
	self = g_object_new (tracker_bus_statistics_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Statistics", NULL);
	return self;
}


static GObject* tracker_bus_statistics_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (tracker_bus_statistics_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), tracker_bus_statistics_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult tracker_bus_statistics_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void tracker_bus_statistics_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TrackerBusStatisticsDBusProxy*) self)->disposed) {
		return;
	}
	((TrackerBusStatisticsDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), tracker_bus_statistics_dbus_proxy_filter, self);
	G_OBJECT_CLASS (tracker_bus_statistics_dbus_proxy_parent_class)->dispose (self);
}


static void tracker_bus_statistics_dbus_proxy_class_init (TrackerBusStatisticsDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = tracker_bus_statistics_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = tracker_bus_statistics_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = tracker_bus_statistics_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_bus_statistics_dbus_proxy_set_property;
}


static void tracker_bus_statistics_dbus_proxy_init (TrackerBusStatisticsDBusProxy* self) {
}


static char** tracker_bus_statistics_dbus_proxy_Get (TrackerBusStatistics* self, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp74_;
	int _tmp74__length;
	int _tmp74__size;
	int _tmp74__length1;
	DBusMessageIter _tmp75_;
	if (((TrackerBusStatisticsDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Statistics", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp78_;
			_edomain = DBUS_GERROR;
			_tmp78_ = _dbus_error.name + 27;
			if (strcmp (_tmp78_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp78_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp78_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp78_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp78_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp78_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp78_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp78_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp78_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp78_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp78_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp78_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp78_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp78_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp78_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp78_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp78_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp78_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp78_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp78_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp78_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp78_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp78_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp78_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp78_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp78_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp78_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp78_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp78_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp78_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp78_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp78_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp78_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp74_ = g_new (char*, 5);
	_tmp74__length = 0;
	_tmp74__size = 4;
	_tmp74__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp75_);
	for (; dbus_message_iter_get_arg_type (&_tmp75_); _tmp74__length1++) {
		int _tmp74__length2;
		DBusMessageIter _tmp76_;
		_tmp74__length2 = 0;
		dbus_message_iter_recurse (&_tmp75_, &_tmp76_);
		for (; dbus_message_iter_get_arg_type (&_tmp76_); _tmp74__length2++) {
			const char* _tmp77_;
			if (_tmp74__size == _tmp74__length) {
				_tmp74__size = 2 * _tmp74__size;
				_tmp74_ = g_renew (char*, _tmp74_, _tmp74__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp76_, &_tmp77_);
			dbus_message_iter_next (&_tmp76_);
			_tmp74_[_tmp74__length++] = g_strdup (_tmp77_);
		}
		_result_length2 = _tmp74__length2;
		dbus_message_iter_next (&_tmp75_);
	}
	_result_length1 = _tmp74__length1;
	_tmp74_[_tmp74__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp74_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_statistics_dbus_proxy_Get_async_async (TrackerBusStatistics* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	TrackerBusStatisticsDBusProxyGet_asyncData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Statistics", "Get_async");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (TrackerBusStatisticsDBusProxyGet_asyncData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, tracker_bus_statistics_dbus_proxy_Get_async_ready, _data_, NULL);
}


static void tracker_bus_statistics_dbus_proxy_Get_async_ready (DBusPendingCall* pending, void* user_data) {
	TrackerBusStatisticsDBusProxyGet_asyncData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (TrackerBusStatisticsDBusProxyGet_asyncData, _data_);
	dbus_pending_call_unref (pending);
}


static char** tracker_bus_statistics_dbus_proxy_Get_async_finish (TrackerBusStatistics* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	TrackerBusStatisticsDBusProxyGet_asyncData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp84_;
	int _tmp84__length;
	int _tmp84__size;
	int _tmp84__length1;
	DBusMessageIter _tmp85_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp83_;
			_edomain = DBUS_GERROR;
			_tmp83_ = _dbus_error.name + 27;
			if (strcmp (_tmp83_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp83_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp83_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp83_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp83_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp83_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp83_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp83_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp83_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp83_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp83_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp83_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp83_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp83_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp83_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp83_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp83_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp83_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp83_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp83_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp83_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp83_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp83_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp83_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp83_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp83_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp83_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp83_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp83_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp83_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp83_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp83_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp83_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp84_ = g_new (char*, 5);
	_tmp84__length = 0;
	_tmp84__size = 4;
	_tmp84__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp85_);
	for (; dbus_message_iter_get_arg_type (&_tmp85_); _tmp84__length1++) {
		int _tmp84__length2;
		DBusMessageIter _tmp86_;
		_tmp84__length2 = 0;
		dbus_message_iter_recurse (&_tmp85_, &_tmp86_);
		for (; dbus_message_iter_get_arg_type (&_tmp86_); _tmp84__length2++) {
			const char* _tmp87_;
			if (_tmp84__size == _tmp84__length) {
				_tmp84__size = 2 * _tmp84__size;
				_tmp84_ = g_renew (char*, _tmp84_, _tmp84__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp86_, &_tmp87_);
			dbus_message_iter_next (&_tmp86_);
			_tmp84_[_tmp84__length++] = g_strdup (_tmp87_);
		}
		_result_length2 = _tmp84__length2;
		dbus_message_iter_next (&_tmp85_);
	}
	_result_length1 = _tmp84__length1;
	_tmp84_[_tmp84__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp84_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void tracker_bus_statistics_dbus_proxy_tracker_bus_statistics__interface_init (TrackerBusStatisticsIface* iface) {
	iface->Get = tracker_bus_statistics_dbus_proxy_Get;
	iface->Get_async = tracker_bus_statistics_dbus_proxy_Get_async_async;
	iface->Get_finish = tracker_bus_statistics_dbus_proxy_Get_async_finish;
}


static void tracker_bus_statistics_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void tracker_bus_statistics_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


TrackerBusConnection* tracker_bus_connection_construct (GType object_type) {
	GError * _inner_error_;
	TrackerBusConnection * self;
	_inner_error_ = NULL;
	g_return_val_if_fail (!tracker_bus_connection_initialized, NULL);
	self = (TrackerBusConnection*) tracker_sparql_connection_construct (object_type);
	tracker_bus_connection_initialized = TRUE;
	{
		const char* _tmp1_;
		DBusGConnection* _tmp2_;
		DBusGConnection* _tmp3_;
		TrackerBusResources* _tmp4_;
		TrackerBusStatistics* _tmp5_;
		if (g_strcmp0 (HAVE_DBUS_FD_PASSING_IN_VALA, "1") == 0) {
			char* env_backend;
			gboolean _tmp0_ = FALSE;
			env_backend = g_strdup (g_getenv ("TRACKER_BUS_BACKEND"));
			if (env_backend == NULL) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = g_ascii_strcasecmp (env_backend, "dbus-glib") != 0;
			}
			if (_tmp0_) {
				tracker_bus_connection_use_steroids = TRUE;
			}
			_g_free0 (env_backend);
		}
		_tmp1_ = NULL;
		if (tracker_bus_connection_use_steroids) {
			_tmp1_ = "yes";
		} else {
			_tmp1_ = "no";
		}
		g_debug ("tracker-bus.vala:69: Using steroids = %s", _tmp1_);
		_tmp2_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		tracker_bus_connection_connection = (_tmp3_ = _tmp2_, _dbus_g_connection_unref0 (tracker_bus_connection_connection), _tmp3_);
		tracker_bus_connection_resources_object = (_tmp4_ = tracker_bus_resources_dbus_proxy_new (tracker_bus_connection_connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_RESOURCES), _g_object_unref0 (tracker_bus_connection_resources_object), _tmp4_);
		tracker_bus_connection_statistics_object = (_tmp5_ = tracker_bus_statistics_dbus_proxy_new (tracker_bus_connection_connection, TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATISTICS), _g_object_unref0 (tracker_bus_connection_statistics_object), _tmp5_);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("tracker-bus.vala:81: Could not connect to D-Bus service:'%s': %s", TRACKER_DBUS_INTERFACE_RESOURCES, e->message);
			tracker_bus_connection_initialized = FALSE;
			_g_error_free0 (e);
			return self;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	tracker_bus_connection_initialized = TRUE;
	return self;
}


TrackerBusConnection* tracker_bus_connection_new (void) {
	return tracker_bus_connection_construct (TRACKER_BUS_TYPE_CONNECTION);
}


static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	{
		if (tracker_bus_connection_use_steroids) {
			TrackerSparqlCursor* _tmp0_;
			_tmp0_ = tracker_bus_fd_query (tracker_bus_connection_connection, sparql, cancellable, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch1_dbus_gerror;
				}
				goto __finally1;
			}
			result = _tmp0_;
			return result;
		} else {
			gint results_length1;
			gint results_length2;
			char** _tmp3_;
			gint _tmp1_;
			gint _tmp2_;
			char** results;
			gboolean _tmp4_ = FALSE;
			char** _tmp5_;
			results = (_tmp3_ = tracker_bus_resources_sparql_query (tracker_bus_connection_resources_object, sparql, &_tmp1_, &_tmp2_, &_inner_error_), results_length1 = _tmp1_, results_length2 = _tmp2_, _tmp3_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch1_dbus_gerror;
				}
				goto __finally1;
			}
			if (cancellable != NULL) {
				_tmp4_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
				{
					results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch1_dbus_gerror;
					}
					goto __finally1;
				}
			}
			result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((_tmp5_ = results, results = NULL, _tmp5_), results_length1, results_length2, results_length1, results_length2);
			results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
			return result;
			results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally1;
			}
			_g_error_free0 (e);
		}
	}
	__finally1:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_bus_connection_real_query_async_data_free (gpointer _data) {
	TrackerBusConnectionQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionQueryAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionQueryAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_query_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_bus_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerBusConnectionQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_bus_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionQueryAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_query_async_co (data);
}


static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			if (tracker_bus_connection_use_steroids) {
				data->_state_ = 1;
				tracker_bus_fd_query_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_query_async_ready, data);
				return FALSE;
				_state_1:
				data->_tmp0_ = tracker_bus_fd_query_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch2_dbus_gerror;
					}
					goto __finally2;
				}
				data->result = data->_tmp0_;
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				data->_state_ = 2;
				tracker_bus_resources_sparql_query_async (tracker_bus_connection_resources_object, data->sparql, tracker_bus_connection_query_async_ready, data);
				return FALSE;
				_state_2:
				data->results = (data->_tmp3_ = tracker_bus_resources_sparql_query_finish (tracker_bus_connection_resources_object, data->_res_, &data->_tmp1_, &data->_tmp2_, &data->_inner_error_), data->results_length1 = data->_tmp1_, data->results_length2 = data->_tmp2_, data->_tmp3_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch2_dbus_gerror;
					}
					goto __finally2;
				}
				if (data->cancellable != NULL) {
					data->_tmp4_ = g_cancellable_is_cancelled (data->cancellable);
				} else {
					data->_tmp4_ = FALSE;
				}
				if (data->_tmp4_) {
					data->_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
					{
						data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch2_dbus_gerror;
						}
						goto __finally2;
					}
				}
				data->result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((data->_tmp5_ = data->results, data->results = NULL, data->_tmp5_), data->results_length1, data->results_length2, data->results_length1, data->results_length2);
				data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
			}
		}
		goto __finally2;
		__catch2_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally2;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally2:
		{
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_bus_connection_real_update (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_if_fail (sparql != NULL);
	_inner_error_ = NULL;
	{
		if (tracker_bus_connection_use_steroids) {
			if (priority >= G_PRIORITY_DEFAULT) {
				tracker_bus_fd_sparql_update (tracker_bus_connection_connection, sparql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					goto __finally3;
				}
			} else {
				tracker_bus_fd_sparql_batch_update (tracker_bus_connection_connection, sparql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					goto __finally3;
				}
			}
		} else {
			gboolean _tmp0_ = FALSE;
			if (priority >= G_PRIORITY_DEFAULT) {
				tracker_bus_resources_sparql_update (tracker_bus_connection_resources_object, sparql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					goto __finally3;
				}
			} else {
				tracker_bus_resources_batch_sparql_update (tracker_bus_connection_resources_object, sparql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					goto __finally3;
				}
			}
			if (cancellable != NULL) {
				_tmp0_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
				{
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					goto __finally3;
				}
			}
		}
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally3;
			}
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_bus_connection_real_update_async_data_free (gpointer _data) {
	TrackerBusConnectionUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionUpdateAsyncData, data);
}


static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_update_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_update_async_co (_data_);
}


static void tracker_bus_connection_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerBusConnectionUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_bus_connection_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionUpdateAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_update_async_co (data);
}


static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			if (tracker_bus_connection_use_steroids) {
				if (data->priority >= G_PRIORITY_DEFAULT) {
					data->_state_ = 3;
					tracker_bus_fd_sparql_update_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_async_ready, data);
					return FALSE;
					_state_3:
					tracker_bus_fd_sparql_update_finish (data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch4_dbus_gerror;
						}
						goto __finally4;
					}
				} else {
					data->_state_ = 4;
					tracker_bus_fd_sparql_batch_update_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_async_ready, data);
					return FALSE;
					_state_4:
					tracker_bus_fd_sparql_batch_update_finish (data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch4_dbus_gerror;
						}
						goto __finally4;
					}
				}
			} else {
				if (data->priority >= G_PRIORITY_DEFAULT) {
					data->_state_ = 5;
					tracker_bus_resources_sparql_update_async (tracker_bus_connection_resources_object, data->sparql, tracker_bus_connection_update_async_ready, data);
					return FALSE;
					_state_5:
					tracker_bus_resources_sparql_update_finish (tracker_bus_connection_resources_object, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch4_dbus_gerror;
						}
						goto __finally4;
					}
				} else {
					data->_state_ = 6;
					tracker_bus_resources_batch_sparql_update_async (tracker_bus_connection_resources_object, data->sparql, tracker_bus_connection_update_async_ready, data);
					return FALSE;
					_state_6:
					tracker_bus_resources_batch_sparql_update_finish (tracker_bus_connection_resources_object, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch4_dbus_gerror;
						}
						goto __finally4;
					}
				}
				if (data->cancellable != NULL) {
					data->_tmp0_ = g_cancellable_is_cancelled (data->cancellable);
				} else {
					data->_tmp0_ = FALSE;
				}
				if (data->_tmp0_) {
					data->_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
					{
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch4_dbus_gerror;
						}
						goto __finally4;
					}
				}
			}
		}
		goto __finally4;
		__catch4_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally4;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally4:
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	GVariant* result = NULL;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	_inner_error_ = NULL;
	{
		GVariant* res;
		res = NULL;
		if (tracker_bus_connection_use_steroids) {
			GVariant* _tmp0_;
			GVariant* _tmp1_;
			_tmp0_ = tracker_bus_fd_sparql_update_blank (tracker_bus_connection_connection, sparql, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_variant_unref0 (res);
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch5_dbus_gerror;
				}
				goto __finally5;
			}
			res = (_tmp1_ = _tmp0_, _g_variant_unref0 (res), _tmp1_);
		} else {
			GVariant* _tmp2_;
			GVariant* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = tracker_bus_array_sparql_update_blank (tracker_bus_connection_connection, sparql, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_variant_unref0 (res);
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch5_dbus_gerror;
				}
				goto __finally5;
			}
			res = (_tmp3_ = _tmp2_, _g_variant_unref0 (res), _tmp3_);
			if (cancellable != NULL) {
				_tmp4_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
				{
					_g_variant_unref0 (res);
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch5_dbus_gerror;
					}
					goto __finally5;
				}
			}
		}
		result = res;
		return result;
	}
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally5;
			}
			_g_error_free0 (e);
		}
	}
	__finally5:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data) {
	TrackerBusConnectionUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionUpdateBlankAsyncData, data);
}


static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_update_blank_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_update_blank_async_co (_data_);
}


static GVariant* tracker_bus_connection_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_bus_connection_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_update_blank_async_co (data);
}


static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->res = NULL;
			if (tracker_bus_connection_use_steroids) {
				data->_state_ = 7;
				tracker_bus_fd_sparql_update_blank_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_blank_async_ready, data);
				return FALSE;
				_state_7:
				data->_tmp0_ = tracker_bus_fd_sparql_update_blank_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_variant_unref0 (data->res);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch6_dbus_gerror;
					}
					goto __finally6;
				}
				data->res = (data->_tmp1_ = data->_tmp0_, _g_variant_unref0 (data->res), data->_tmp1_);
			} else {
				data->_state_ = 8;
				tracker_bus_array_sparql_update_blank_async (tracker_bus_connection_connection, data->sparql, data->cancellable, tracker_bus_connection_update_blank_async_ready, data);
				return FALSE;
				_state_8:
				data->_tmp2_ = tracker_bus_array_sparql_update_blank_finish (data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_variant_unref0 (data->res);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch6_dbus_gerror;
					}
					goto __finally6;
				}
				data->res = (data->_tmp3_ = data->_tmp2_, _g_variant_unref0 (data->res), data->_tmp3_);
				if (data->cancellable != NULL) {
					data->_tmp4_ = g_cancellable_is_cancelled (data->cancellable);
				} else {
					data->_tmp4_ = FALSE;
				}
				if (data->_tmp4_) {
					data->_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
					{
						_g_variant_unref0 (data->res);
						if (data->_inner_error_->domain == DBUS_GERROR) {
							goto __catch6_dbus_gerror;
						}
						goto __finally6;
					}
				}
			}
			data->result = data->res;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_variant_unref0 (data->res);
		}
		goto __finally6;
		__catch6_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally6;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally6:
		{
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_bus_connection_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	g_return_if_fail (file != NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		gboolean _tmp1_ = FALSE;
		tracker_bus_resources_load (tracker_bus_connection_resources_object, _tmp0_ = g_file_get_uri (file), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch7_dbus_gerror;
			}
			goto __finally7;
		}
		if (cancellable != NULL) {
			_tmp1_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
			{
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch7_dbus_gerror;
				}
				goto __finally7;
			}
		}
	}
	goto __finally7;
	__catch7_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally7;
			}
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_bus_connection_real_load_async_data_free (gpointer _data) {
	TrackerBusConnectionLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionLoadAsyncData, data);
}


static void tracker_bus_connection_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionLoadAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_load_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_load_async_co (_data_);
}


static void tracker_bus_connection_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerBusConnectionLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_bus_connection_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionLoadAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_load_async_co (data);
}


static gboolean tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 9:
		goto _state_9;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->_state_ = 9;
			tracker_bus_resources_load_async (tracker_bus_connection_resources_object, data->_tmp0_ = g_file_get_uri (data->file), tracker_bus_connection_load_async_ready, data);
			return FALSE;
			_state_9:
			tracker_bus_resources_load_finish (tracker_bus_connection_resources_object, data->_res_, &data->_inner_error_);
			_g_free0 (data->_tmp0_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch8_dbus_gerror;
				}
				goto __finally8;
			}
			if (data->cancellable != NULL) {
				data->_tmp1_ = g_cancellable_is_cancelled (data->cancellable);
			} else {
				data->_tmp1_ = FALSE;
			}
			if (data->_tmp1_) {
				data->_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
				{
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch8_dbus_gerror;
					}
					goto __finally8;
				}
			}
		}
		goto __finally8;
		__catch8_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally8;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally8:
		if (data->_inner_error_ != NULL) {
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static TrackerSparqlCursor* tracker_bus_connection_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerBusConnection * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_;
	self = (TrackerBusConnection*) base;
	_inner_error_ = NULL;
	{
		gint results_length1;
		gint results_length2;
		char** _tmp2_;
		gint _tmp0_;
		gint _tmp1_;
		char** results;
		gboolean _tmp3_ = FALSE;
		char** _tmp4_;
		results = (_tmp2_ = tracker_bus_statistics_Get (tracker_bus_connection_statistics_object, &_tmp0_, &_tmp1_, &_inner_error_), results_length1 = _tmp0_, results_length2 = _tmp1_, _tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch9_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (cancellable != NULL) {
			_tmp3_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
			{
				results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch9_dbus_gerror;
				}
				goto __finally9;
			}
		}
		result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((_tmp4_ = results, results = NULL, _tmp4_), results_length1, results_length2, results_length1, results_length2);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		return result;
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally9;
	__catch9_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
			{
				_g_error_free0 (e);
				goto __finally9;
			}
			_g_error_free0 (e);
		}
	}
	__finally9:
	{
		if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static void tracker_bus_connection_real_statistics_async_data_free (gpointer _data) {
	TrackerBusConnectionStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerBusConnectionStatisticsAsyncData, data);
}


static void tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerBusConnection * self;
	TrackerBusConnectionStatisticsAsyncData* _data_;
	self = (TrackerBusConnection*) base;
	_data_ = g_slice_new0 (TrackerBusConnectionStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_bus_connection_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_bus_connection_real_statistics_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_bus_connection_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_bus_connection_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerBusConnectionStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_bus_connection_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerBusConnectionStatisticsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_bus_connection_real_statistics_async_co (data);
}


static gboolean tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->_state_ = 10;
			tracker_bus_statistics_Get_async (tracker_bus_connection_statistics_object, tracker_bus_connection_statistics_async_ready, data);
			return FALSE;
			_state_10:
			data->results = (data->_tmp2_ = tracker_bus_statistics_Get_finish (tracker_bus_connection_statistics_object, data->_res_, &data->_tmp0_, &data->_tmp1_, &data->_inner_error_), data->results_length1 = data->_tmp0_, data->results_length2 = data->_tmp1_, data->_tmp2_);
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == DBUS_GERROR) {
					goto __catch10_dbus_gerror;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			if (data->cancellable != NULL) {
				data->_tmp3_ = g_cancellable_is_cancelled (data->cancellable);
			} else {
				data->_tmp3_ = FALSE;
			}
			if (data->_tmp3_) {
				data->_inner_error_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
				{
					data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch10_dbus_gerror;
					}
					goto __finally10;
				}
			}
			data->result = (TrackerSparqlCursor*) tracker_bus_array_cursor_new ((data->_tmp4_ = data->results, data->results = NULL, data->_tmp4_), data->results_length1, data->results_length2, data->results_length1, data->results_length2);
			data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
		}
		goto __finally10;
		__catch10_dbus_gerror:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->_inner_error_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
				{
					_g_error_free0 (data->e);
					goto __finally10;
				}
				_g_error_free0 (data->e);
			}
		}
		__finally10:
		{
			if ((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void tracker_bus_connection_class_init (TrackerBusConnectionClass * klass) {
	tracker_bus_connection_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_bus_connection_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_bus_connection_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_bus_connection_real_query_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_bus_connection_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_bus_connection_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_bus_connection_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_bus_connection_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_bus_connection_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_bus_connection_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_bus_connection_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_bus_connection_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_bus_connection_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_bus_connection_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_bus_connection_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_bus_connection_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_connection_finalize;
}


static void tracker_bus_connection_instance_init (TrackerBusConnection * self) {
}


static void tracker_bus_connection_finalize (GObject* obj) {
	TrackerBusConnection * self;
	self = TRACKER_BUS_CONNECTION (obj);
	{
		tracker_bus_connection_initialized = FALSE;
	}
	G_OBJECT_CLASS (tracker_bus_connection_parent_class)->finalize (obj);
}


GType tracker_bus_connection_get_type (void) {
	static volatile gsize tracker_bus_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_bus_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBusConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusConnection), 0, (GInstanceInitFunc) tracker_bus_connection_instance_init, NULL };
		GType tracker_bus_connection_type_id;
		tracker_bus_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerBusConnection", &g_define_type_info, 0);
		g_once_init_leave (&tracker_bus_connection_type_id__volatile, tracker_bus_connection_type_id);
	}
	return tracker_bus_connection_type_id__volatile;
}


TrackerSparqlConnection* module_init (void) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* plugin;
	plugin = (TrackerSparqlConnection*) tracker_bus_connection_new ();
	result = plugin;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




