/* gkr-backend.c generated by valac 0.20.1.64-fa28c, the Vala compiler
 * generated from gkr-backend.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsecret/secret.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gcr/gcr-base.h>
#include <seahorse-internal.h>
#include <glib/gi18n-lib.h>
#include <config.h>


#define SEAHORSE_GKR_TYPE_MY_SERVICE (seahorse_gkr_my_service_get_type ())
#define SEAHORSE_GKR_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyService))
#define SEAHORSE_GKR_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))
#define SEAHORSE_GKR_IS_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_IS_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_MY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))

typedef struct _SeahorseGkrMyService SeahorseGkrMyService;
typedef struct _SeahorseGkrMyServiceClass SeahorseGkrMyServiceClass;
typedef struct _SeahorseGkrMyServicePrivate SeahorseGkrMyServicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SeahorseGkrMyService {
	SecretService parent_instance;
	SeahorseGkrMyServicePrivate * priv;
};

struct _SeahorseGkrMyServiceClass {
	SecretServiceClass parent_class;
};

struct _SeahorseGkrBackendPrivate {
	SecretService* _service;
	GHashTable* _keyrings;
	GHashTable* _aliases;
	GtkActionGroup* _actions;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseGkrBackend * self;
	gchar* name;
};

struct _SeahorseGkrBackendActionsPrivate {
	SeahorseGkrBackend* _backend;
	gboolean _initialized;
};


static gpointer seahorse_gkr_my_service_parent_class = NULL;
static gpointer seahorse_gkr_backend_parent_class = NULL;
static SeahorseGkrBackend* seahorse_gkr_backend__instance;
static SeahorseGkrBackend* seahorse_gkr_backend__instance = NULL;
static GcrCollectionIface* seahorse_gkr_backend_gcr_collection_parent_iface = NULL;
static SeahorseBackendIface* seahorse_gkr_backend_seahorse_backend_parent_iface = NULL;
static gpointer seahorse_gkr_backend_actions_parent_class = NULL;
static GWeakRef seahorse_gkr_backend_actions__instance;
static GWeakRef seahorse_gkr_backend_actions__instance = {0};

GType seahorse_gkr_my_service_get_type (void) G_GNUC_CONST;
enum  {
	SEAHORSE_GKR_MY_SERVICE_DUMMY_PROPERTY
};
static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base);
static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base);
SeahorseGkrMyService* seahorse_gkr_my_service_new (void);
SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type);
#define SEAHORSE_GKR_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackendPrivate))
enum  {
	SEAHORSE_GKR_BACKEND_DUMMY_PROPERTY,
	SEAHORSE_GKR_BACKEND_NAME,
	SEAHORSE_GKR_BACKEND_LABEL,
	SEAHORSE_GKR_BACKEND_DESCRIPTION,
	SEAHORSE_GKR_BACKEND_ACTIONS,
	SEAHORSE_GKR_BACKEND_ALIASES,
	SEAHORSE_GKR_BACKEND_SERVICE
};
static void seahorse_gkr_backend_real_dispose (GObject* base);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static guint seahorse_gkr_backend_real_get_length (GcrCollection* base);
static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base);
static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base, GObject* object);
static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base, const gchar* uri);
static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self, const gchar* name);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self);
static GObject * seahorse_gkr_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend___lambda13_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res);
static void ___lambda14_ (SeahorseGkrBackend* self, GParamSpec* pspec);
static void ____lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda15_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res);
static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __seahorse_gkr_backend___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_backend_finalize (GObject* obj);
static void _vala_seahorse_gkr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define SEAHORSE_GKR_BACKEND_ACTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActionsPrivate))
enum  {
	SEAHORSE_GKR_BACKEND_ACTIONS_DUMMY_PROPERTY,
	SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND
};
static void seahorse_gkr_backend_actions_on_new_keyring (GtkAction* action);
static void _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_gkr_backend_actions_on_new_item (GtkAction* action);
static void _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback (GtkAction* action, gpointer self);
#define SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_UI "\"<ui>\n" \
"\t\t\t<popup name='SeahorseGkrBackend'>\n" \
"\t\t\t\t<menuitem action='keyring-new'/>\n" \
"\t\t\t</popup>\n" \
"\t\t</ui>"
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend);
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type, SeahorseGkrBackend* backend);
static GObject * seahorse_gkr_backend_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend_actions___lambda12_ (SeahorseGkrBackendActions* self, GParamSpec* pspec);
static void __seahorse_gkr_backend_actions___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void seahorse_gkr_backend_actions_finalize (GObject* obj);
static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GtkActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS[2] = {{"keyring-new", NULL, "New password keyring", "", "Used to store application and network passwords", (GCallback) _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback}, {"keyring-item-new", NULL, "New password...", "", "Safely store a password or secret.", (GCallback) _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback}};
static const GtkActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW[2] = {{"keyring-new", "folder", "Password Keyring", "", "Used to store application and network passwords", (GCallback) _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback}, {"keyring-item-new", SEAHORSE_ICON_PASSWORD, "Stored Password", "", "Safely store a password or secret.", (GCallback) _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback}};

static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base) {
	SeahorseGkrMyService * self;
	GType result = 0UL;
#line 26 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrMyService*) base;
#line 27 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = SEAHORSE_GKR_TYPE_KEYRING;
#line 27 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 167 "gkr-backend.c"
}


static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base) {
	SeahorseGkrMyService * self;
	GType result = 0UL;
#line 30 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrMyService*) base;
#line 31 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = SEAHORSE_GKR_TYPE_ITEM;
#line 31 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 180 "gkr-backend.c"
}


SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type) {
	SeahorseGkrMyService * self = NULL;
#line 25 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrMyService*) g_object_new (object_type, NULL);
#line 25 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return self;
#line 190 "gkr-backend.c"
}


SeahorseGkrMyService* seahorse_gkr_my_service_new (void) {
#line 25 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return seahorse_gkr_my_service_construct (SEAHORSE_GKR_TYPE_MY_SERVICE);
#line 197 "gkr-backend.c"
}


static void seahorse_gkr_my_service_class_init (SeahorseGkrMyServiceClass * klass) {
#line 25 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_my_service_parent_class = g_type_class_peek_parent (klass);
#line 25 "/data/projects/seahorse/gkr/gkr-backend.vala"
	SECRET_SERVICE_CLASS (klass)->get_collection_gtype = seahorse_gkr_my_service_real_get_collection_gtype;
#line 25 "/data/projects/seahorse/gkr/gkr-backend.vala"
	SECRET_SERVICE_CLASS (klass)->get_item_gtype = seahorse_gkr_my_service_real_get_item_gtype;
#line 208 "gkr-backend.c"
}


static void seahorse_gkr_my_service_instance_init (SeahorseGkrMyService * self) {
}


GType seahorse_gkr_my_service_get_type (void) {
	static volatile gsize seahorse_gkr_my_service_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_my_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrMyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_my_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrMyService), 0, (GInstanceInitFunc) seahorse_gkr_my_service_instance_init, NULL };
		GType seahorse_gkr_my_service_type_id;
		seahorse_gkr_my_service_type_id = g_type_register_static (secret_service_get_type (), "SeahorseGkrMyService", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_my_service_type_id__volatile, seahorse_gkr_my_service_type_id);
	}
	return seahorse_gkr_my_service_type_id__volatile;
}


static void seahorse_gkr_backend_real_dispose (GObject* base) {
	SeahorseGkrBackend * self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
#line 93 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 94 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_aliases;
#line 94 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_hash_table_remove_all (_tmp0_);
#line 95 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = self->priv->_keyrings;
#line 95 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_hash_table_remove_all (_tmp1_);
#line 96 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = self->priv->_actions;
#line 96 "/data/projects/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_set_sensitive (_tmp2_, FALSE);
#line 97 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 249 "gkr-backend.c"
}


static void _g_free0_ (gpointer var) {
#line 101 "/data/projects/seahorse/gkr/gkr-backend.vala"
	var = (g_free (var), NULL);
#line 256 "gkr-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 263 "gkr-backend.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 270 "gkr-backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_list_free (self);
#line 279 "gkr-backend.c"
}


void seahorse_gkr_backend_refresh_collections (SeahorseGkrBackend* self) {
	GHashTable* seen = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* keyrings = NULL;
	SecretService* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gchar* object_path = NULL;
	GList* _tmp5_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp25_ = NULL;
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 101 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = g_str_hash;
#line 101 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_str_equal;
#line 101 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
#line 101 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seen = _tmp2_;
#line 102 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_service;
#line 102 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = secret_service_get_collections (_tmp3_);
#line 102 "/data/projects/seahorse/gkr/gkr-backend.vala"
	keyrings = _tmp4_;
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = keyrings;
#line 313 "gkr-backend.c"
	{
		GList* keyring_collection = NULL;
		GList* keyring_it = NULL;
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
		keyring_collection = _tmp5_;
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
		for (keyring_it = keyring_collection; keyring_it != NULL; keyring_it = keyring_it->next) {
#line 321 "gkr-backend.c"
			SecretCollection* _tmp6_ = NULL;
			SecretCollection* keyring = NULL;
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp6_ = _g_object_ref0 ((SecretCollection*) keyring_it->data);
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
			keyring = _tmp6_;
#line 328 "gkr-backend.c"
			{
				SecretCollection* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				GHashTable* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GHashTable* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				GHashTable* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gconstpointer _tmp18_ = NULL;
#line 106 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp7_ = keyring;
#line 106 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp8_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp7_);
#line 106 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp9_ = g_strdup (_tmp8_);
#line 106 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_g_free0 (object_path);
#line 106 "/data/projects/seahorse/gkr/gkr-backend.vala"
				object_path = _tmp9_;
#line 109 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp10_ = self->priv->_aliases;
#line 109 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp11_ = g_hash_table_lookup (_tmp10_, "session");
#line 109 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp12_ = object_path;
#line 109 "/data/projects/seahorse/gkr/gkr-backend.vala"
				if (g_strcmp0 ((const gchar*) _tmp11_, _tmp12_) == 0) {
#line 110 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_g_object_unref0 (keyring);
#line 110 "/data/projects/seahorse/gkr/gkr-backend.vala"
					continue;
#line 364 "gkr-backend.c"
				}
#line 112 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp13_ = seen;
#line 112 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp14_ = object_path;
#line 112 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp15_ = g_strdup (_tmp14_);
#line 112 "/data/projects/seahorse/gkr/gkr-backend.vala"
				g_hash_table_add (_tmp13_, _tmp15_);
#line 113 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp16_ = self->priv->_keyrings;
#line 113 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp17_ = object_path;
#line 113 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
#line 113 "/data/projects/seahorse/gkr/gkr-backend.vala"
				if (((SeahorseGkrKeyring*) _tmp18_) == NULL) {
#line 382 "gkr-backend.c"
					GHashTable* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					SecretCollection* _tmp22_ = NULL;
					SeahorseGkrKeyring* _tmp23_ = NULL;
					SecretCollection* _tmp24_ = NULL;
#line 114 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_tmp19_ = self->priv->_keyrings;
#line 114 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_tmp20_ = object_path;
#line 114 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_tmp21_ = g_strdup (_tmp20_);
#line 114 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_tmp22_ = keyring;
#line 114 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
#line 114 "/data/projects/seahorse/gkr/gkr-backend.vala"
					g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
#line 115 "/data/projects/seahorse/gkr/gkr-backend.vala"
					_tmp24_ = keyring;
#line 115 "/data/projects/seahorse/gkr/gkr-backend.vala"
					gcr_collection_emit_added ((GcrCollection*) self, (GObject*) _tmp24_);
#line 405 "gkr-backend.c"
				}
#line 105 "/data/projects/seahorse/gkr/gkr-backend.vala"
				_g_object_unref0 (keyring);
#line 409 "gkr-backend.c"
			}
		}
	}
#line 120 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp25_ = self->priv->_keyrings;
#line 120 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_hash_table_iter_init (&iter, _tmp25_);
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
	while (TRUE) {
#line 419 "gkr-backend.c"
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		gchar* _tmp28_ = NULL;
		GHashTable* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp27_ = g_hash_table_iter_next (&iter, &_tmp26_, NULL);
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_free0 (object_path);
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp28_ = g_strdup (_tmp26_);
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
		object_path = _tmp28_;
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
		if (!_tmp27_) {
#line 121 "/data/projects/seahorse/gkr/gkr-backend.vala"
			break;
#line 438 "gkr-backend.c"
		}
#line 122 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp29_ = seen;
#line 122 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp30_ = object_path;
#line 122 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp31_ = g_hash_table_lookup (_tmp29_, _tmp30_);
#line 122 "/data/projects/seahorse/gkr/gkr-backend.vala"
		if (((const gchar*) _tmp31_) == NULL) {
#line 448 "gkr-backend.c"
			SeahorseGkrKeyring* keyring = NULL;
			GHashTable* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gconstpointer _tmp34_ = NULL;
			SeahorseGkrKeyring* _tmp35_ = NULL;
			SeahorseGkrKeyring* _tmp36_ = NULL;
#line 123 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp32_ = self->priv->_keyrings;
#line 123 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp33_ = object_path;
#line 123 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
#line 123 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp35_ = _g_object_ref0 ((SeahorseGkrKeyring*) _tmp34_);
#line 123 "/data/projects/seahorse/gkr/gkr-backend.vala"
			keyring = _tmp35_;
#line 124 "/data/projects/seahorse/gkr/gkr-backend.vala"
			g_hash_table_iter_remove (&iter);
#line 125 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp36_ = keyring;
#line 125 "/data/projects/seahorse/gkr/gkr-backend.vala"
			gcr_collection_emit_removed ((GcrCollection*) self, (GObject*) _tmp36_);
#line 122 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_g_object_unref0 (keyring);
#line 473 "gkr-backend.c"
		}
	}
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_free0 (object_path);
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	__g_list_free__g_object_unref0_0 (keyrings);
#line 100 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (seen);
#line 482 "gkr-backend.c"
}


static guint seahorse_gkr_backend_real_get_length (GcrCollection* base) {
	SeahorseGkrBackend * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 130 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 131 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_keyrings;
#line 131 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_hash_table_size (_tmp0_);
#line 131 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp1_;
#line 131 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 501 "gkr-backend.c"
}


static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base) {
	SeahorseGkrBackend * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
#line 134 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 135 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend_get_keyrings (self);
#line 135 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 135 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 517 "gkr-backend.c"
}


static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base, GObject* object) {
	SeahorseGkrBackend * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
#line 138 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 138 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 139 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = object;
#line 139 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING)) {
#line 533 "gkr-backend.c"
		SeahorseGkrKeyring* keyring = NULL;
		GObject* _tmp1_ = NULL;
		SeahorseGkrKeyring* _tmp2_ = NULL;
		GHashTable* _tmp3_ = NULL;
		SeahorseGkrKeyring* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		SeahorseGkrKeyring* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 140 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp1_ = object;
#line 140 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
#line 140 "/data/projects/seahorse/gkr/gkr-backend.vala"
		keyring = _tmp2_;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp3_ = self->priv->_keyrings;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp4_ = keyring;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp5_ = seahorse_place_get_uri ((SeahorsePlace*) _tmp4_);
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp6_ = _tmp5_;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp7_ = _tmp6_;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp8_ = g_hash_table_lookup (_tmp3_, _tmp7_);
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp9_ = keyring;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp10_ = ((SeahorseGkrKeyring*) _tmp8_) == _tmp9_;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_free0 (_tmp7_);
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		result = _tmp10_;
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_object_unref0 (keyring);
#line 141 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return result;
#line 575 "gkr-backend.c"
	}
#line 143 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = FALSE;
#line 143 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 581 "gkr-backend.c"
}


static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base, const gchar* uri) {
	SeahorseGkrBackend * self;
	SeahorsePlace* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	SeahorsePlace* _tmp3_ = NULL;
#line 146 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 146 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 147 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_keyrings;
#line 147 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = uri;
#line 147 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 147 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = _g_object_ref0 ((SeahorsePlace*) ((SeahorseGkrKeyring*) _tmp2_));
#line 147 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp3_;
#line 147 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 608 "gkr-backend.c"
}


void seahorse_gkr_backend_initialize (void) {
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	SeahorseGkrBackend* _tmp3_ = NULL;
#line 151 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend__instance;
#line 151 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (_tmp0_ == NULL);
#line 152 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_gkr_backend_new ();
#line 152 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _tmp1_;
#line 152 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_backend_register ((SeahorseBackend*) _tmp2_);
#line 152 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 153 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_backend__instance;
#line 153 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (_tmp3_ != NULL);
#line 633 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_instance (void) {
	SeahorseGkrBackend* result = NULL;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
#line 157 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend__instance;
#line 157 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 158 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_gkr_backend__instance;
#line 158 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 158 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp2_;
#line 158 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 654 "gkr-backend.c"
}


GList* seahorse_gkr_backend_get_keyrings (SeahorseGkrBackend* self) {
	GList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 161 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_keyrings;
#line 162 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_hash_table_get_values (_tmp0_);
#line 162 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp1_;
#line 162 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 672 "gkr-backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return _data1_;
#line 681 "gkr-backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 690 "gkr-backend.c"
		SeahorseGkrBackend * self;
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
		self = _data1_->self;
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_free0 (_data1_->name);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_object_unref0 (self);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 700 "gkr-backend.c"
	}
}


static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrBackend * self;
	GError * _inner_error_ = NULL;
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = _data1_->self;
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (res != NULL);
#line 712 "gkr-backend.c"
	{
		gchar* object_path = NULL;
		SecretService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 170 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp0_ = self->priv->_service;
#line 170 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp1_ = res;
#line 170 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp2_ = secret_service_read_alias_dbus_path_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 170 "/data/projects/seahorse/gkr/gkr-backend.vala"
		object_path = _tmp2_;
#line 170 "/data/projects/seahorse/gkr/gkr-backend.vala"
		if (_inner_error_ != NULL) {
#line 728 "gkr-backend.c"
			goto __catch0_g_error;
		}
#line 171 "/data/projects/seahorse/gkr/gkr-backend.vala"
		if (object_path != NULL) {
#line 733 "gkr-backend.c"
			GHashTable* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 172 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp3_ = self->priv->_aliases;
#line 172 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp4_ = _data1_->name;
#line 172 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 172 "/data/projects/seahorse/gkr/gkr-backend.vala"
			_tmp6_ = g_strdup (object_path);
#line 172 "/data/projects/seahorse/gkr/gkr-backend.vala"
			g_hash_table_insert (_tmp3_, _tmp5_, _tmp6_);
#line 173 "/data/projects/seahorse/gkr/gkr-backend.vala"
			g_object_notify ((GObject*) self, "aliases");
#line 750 "gkr-backend.c"
		}
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_free0 (object_path);
#line 754 "gkr-backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		err = _inner_error_;
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_inner_error_ = NULL;
#line 176 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp7_ = _data1_->name;
#line 176 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp8_ = err;
#line 176 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp9_ = _tmp8_->message;
#line 176 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_warning ("gkr-backend.vala:176: Couldn't read secret service alias %s: %s", _tmp7_, _tmp9_);
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_error_free0 (err);
#line 777 "gkr-backend.c"
	}
	__finally0:
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (_inner_error_ != NULL) {
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_clear_error (&_inner_error_);
#line 169 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return;
#line 788 "gkr-backend.c"
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	__lambda3_ (self, source_object, res);
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	block1_data_unref (self);
#line 798 "gkr-backend.c"
}


static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self, const gchar* name) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	SecretService* _tmp2_ = NULL;
	SecretService* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (name != NULL);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_data1_->_ref_count_ = 1;
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_data1_->self = g_object_ref (self);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = name;
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_free0 (_data1_->name);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_data1_->name = _tmp1_;
#line 166 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = self->priv->_service;
#line 166 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (_tmp2_ == NULL) {
#line 167 "/data/projects/seahorse/gkr/gkr-backend.vala"
		block1_data_unref (_data1_);
#line 167 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_data1_ = NULL;
#line 167 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return;
#line 837 "gkr-backend.c"
	}
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_service;
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = _data1_->name;
#line 168 "/data/projects/seahorse/gkr/gkr-backend.vala"
	secret_service_read_alias_dbus_path (_tmp3_, _tmp4_, NULL, ___lambda3__gasync_ready_callback, block1_data_ref (_data1_));
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	block1_data_unref (_data1_);
#line 165 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_data1_ = NULL;
#line 849 "gkr-backend.c"
}


static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self) {
#line 182 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 183 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_read_alias (self, "default");
#line 184 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_read_alias (self, "session");
#line 185 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_read_alias (self, "login");
#line 862 "gkr-backend.c"
}


void seahorse_gkr_backend_refresh (SeahorseGkrBackend* self) {
#line 188 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 189 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_refresh_aliases (self);
#line 190 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_refresh_collections (self);
#line 873 "gkr-backend.c"
}


gboolean seahorse_gkr_backend_has_alias (SeahorseGkrBackend* self, const gchar* alias, SeahorseGkrKeyring* keyring) {
	gboolean result = FALSE;
	gchar* object_path = NULL;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
#line 192 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 192 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (alias != NULL, FALSE);
#line 192 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (keyring != NULL, FALSE);
#line 194 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = keyring;
#line 194 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp0_);
#line 194 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 194 "/data/projects/seahorse/gkr/gkr-backend.vala"
	object_path = _tmp2_;
#line 195 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_aliases;
#line 195 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = alias;
#line 195 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
#line 195 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = g_strcmp0 ((const gchar*) _tmp5_, object_path) == 0;
#line 195 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_free0 (object_path);
#line 195 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 912 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_construct (GType object_type) {
	SeahorseGkrBackend * self = NULL;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) g_object_new (object_type, NULL);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return self;
#line 922 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_new (void) {
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return seahorse_gkr_backend_construct (SEAHORSE_GKR_TYPE_BACKEND);
#line 929 "gkr-backend.c"
}


static const gchar* seahorse_gkr_backend_real_get_name (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
#line 37 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 37 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = SEAHORSE_GKR_NAME;
#line 37 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 942 "gkr-backend.c"
}


static const gchar* seahorse_gkr_backend_real_get_label (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	const gchar* _tmp0_ = NULL;
#line 41 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 41 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = _ ("Passwords");
#line 41 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 41 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 958 "gkr-backend.c"
}


static const gchar* seahorse_gkr_backend_real_get_description (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	const gchar* _tmp0_ = NULL;
#line 45 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 45 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = _ ("Stored personal passwords, credentials and secrets");
#line 45 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 45 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 974 "gkr-backend.c"
}


static GtkActionGroup* seahorse_gkr_backend_real_get_actions (SeahorseBackend* base) {
	GtkActionGroup* result;
	SeahorseGkrBackend* self;
	GtkActionGroup* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
#line 49 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 49 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_actions;
#line 49 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 49 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp1_;
#line 49 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 993 "gkr-backend.c"
}


GHashTable* seahorse_gkr_backend_get_aliases (SeahorseGkrBackend* self) {
	GHashTable* result;
	GHashTable* _tmp0_ = NULL;
#line 53 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_aliases;
#line 53 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 53 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1008 "gkr-backend.c"
}


SecretService* seahorse_gkr_backend_get_service (SeahorseGkrBackend* self) {
	SecretService* result;
	SecretService* _tmp0_ = NULL;
#line 57 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_service;
#line 57 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 57 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1023 "gkr-backend.c"
}


static void ___lambda14_ (SeahorseGkrBackend* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 78 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (pspec != NULL);
#line 79 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = pspec;
#line 79 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _tmp0_->name;
#line 79 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (g_strcmp0 (_tmp1_, "collections") == 0) {
#line 80 "/data/projects/seahorse/gkr/gkr-backend.vala"
		seahorse_gkr_backend_refresh_collections (self);
#line 1040 "gkr-backend.c"
	}
}


static void ____lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 78 "/data/projects/seahorse/gkr/gkr-backend.vala"
	___lambda14_ (self, pspec);
#line 1048 "gkr-backend.c"
}


static void ___lambda15_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res) {
#line 82 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (res != NULL);
#line 83 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_refresh_collections (self);
#line 1057 "gkr-backend.c"
}


static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 82 "/data/projects/seahorse/gkr/gkr-backend.vala"
	___lambda15_ (self, source_object, res);
#line 82 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_unref (self);
#line 1066 "gkr-backend.c"
}


static void _seahorse_gkr_backend___lambda13_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 75 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (res != NULL);
#line 1074 "gkr-backend.c"
	{
		SecretService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		SecretService* _tmp2_ = NULL;
		SecretService* _tmp3_ = NULL;
		SecretService* _tmp4_ = NULL;
#line 77 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp1_ = res;
#line 77 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp2_ = secret_service_open_finish (_tmp1_, &_inner_error_);
#line 77 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp0_ = _tmp2_;
#line 77 "/data/projects/seahorse/gkr/gkr-backend.vala"
		if (_inner_error_ != NULL) {
#line 1089 "gkr-backend.c"
			goto __catch1_g_error;
		}
#line 77 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_object_unref0 (self->priv->_service);
#line 77 "/data/projects/seahorse/gkr/gkr-backend.vala"
		self->priv->_service = _tmp0_;
#line 78 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp3_ = self->priv->_service;
#line 78 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_signal_connect_object ((GObject*) _tmp3_, "notify", (GCallback) ____lambda14__g_object_notify, self, 0);
#line 82 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp4_ = self->priv->_service;
#line 82 "/data/projects/seahorse/gkr/gkr-backend.vala"
		secret_service_load_collections (_tmp4_, NULL, ____lambda15__gasync_ready_callback, g_object_ref (self));
#line 85 "/data/projects/seahorse/gkr/gkr-backend.vala"
		seahorse_gkr_backend_refresh_aliases (self);
#line 1106 "gkr-backend.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
		err = _inner_error_;
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_inner_error_ = NULL;
#line 87 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp5_ = err;
#line 87 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_tmp6_ = _tmp5_->message;
#line 87 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_warning ("gkr-backend.vala:87: couldn't connect to secret service: %s", _tmp6_);
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
		_g_error_free0 (err);
#line 1126 "gkr-backend.c"
	}
	__finally1:
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (_inner_error_ != NULL) {
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_clear_error (&_inner_error_);
#line 76 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return;
#line 1137 "gkr-backend.c"
	}
#line 89 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_notify ((GObject*) self, "service");
#line 1141 "gkr-backend.c"
}


static void __seahorse_gkr_backend___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 74 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_seahorse_gkr_backend___lambda13_ (self, source_object, res);
#line 74 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_unref (self);
#line 1150 "gkr-backend.c"
}


static GObject * seahorse_gkr_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackend * self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
#line 66 "/data/projects/seahorse/gkr/gkr-backend.vala"
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_parent_class);
#line 66 "/data/projects/seahorse/gkr/gkr-backend.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 66 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
#line 67 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend__instance;
#line 67 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (_tmp0_ == NULL);
#line 68 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _g_object_ref0 (self);
#line 68 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (seahorse_gkr_backend__instance);
#line 68 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend__instance = _tmp1_;
#line 70 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = seahorse_gkr_backend_actions_instance (self);
#line 70 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_actions);
#line 70 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv->_actions = _tmp2_;
#line 71 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = g_str_hash;
#line 71 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = g_str_equal;
#line 71 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
#line 71 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_keyrings);
#line 71 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv->_keyrings = _tmp5_;
#line 72 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp6_ = g_str_hash;
#line 72 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp7_ = g_str_equal;
#line 72 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_free0_);
#line 72 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_aliases);
#line 72 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv->_aliases = _tmp8_;
#line 74 "/data/projects/seahorse/gkr/gkr-backend.vala"
	secret_service_open (SEAHORSE_GKR_TYPE_MY_SERVICE, NULL, SECRET_SERVICE_OPEN_SESSION, NULL, __seahorse_gkr_backend___lambda13__gasync_ready_callback, g_object_ref (self));
#line 66 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return obj;
#line 1213 "gkr-backend.c"
}


static void seahorse_gkr_backend_class_init (SeahorseGkrBackendClass * klass) {
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_parent_class = g_type_class_peek_parent (klass);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrBackendPrivate));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->dispose = seahorse_gkr_backend_real_dispose;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_get_property;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_constructor;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_finalize;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS, g_param_spec_object ("actions", "actions", "actions", GTK_TYPE_ACTION_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ALIASES, g_param_spec_boxed ("aliases", "aliases", "aliases", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_SERVICE, g_param_spec_object ("service", "service", "service", secret_service_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1242 "gkr-backend.c"
}


static void seahorse_gkr_backend_gcr_collection_interface_init (GcrCollectionIface * iface) {
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->get_length = (guint (*)(GcrCollection*)) seahorse_gkr_backend_real_get_length;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->get_objects = (GList* (*)(GcrCollection*)) seahorse_gkr_backend_real_get_objects;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->contains = (gboolean (*)(GcrCollection*, GObject*)) seahorse_gkr_backend_real_contains;
#line 1255 "gkr-backend.c"
}


static void seahorse_gkr_backend_seahorse_backend_interface_init (SeahorseBackendIface * iface) {
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_seahorse_backend_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->lookup_place = (SeahorsePlace* (*)(SeahorseBackend*, const gchar*)) seahorse_gkr_backend_real_lookup_place;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->get_name = seahorse_gkr_backend_real_get_name;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->get_label = seahorse_gkr_backend_real_get_label;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->get_description = seahorse_gkr_backend_real_get_description;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	iface->get_actions = seahorse_gkr_backend_real_get_actions;
#line 1272 "gkr-backend.c"
}


static void seahorse_gkr_backend_instance_init (SeahorseGkrBackend * self) {
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv = SEAHORSE_GKR_BACKEND_GET_PRIVATE (self);
#line 1279 "gkr-backend.c"
}


static void seahorse_gkr_backend_finalize (GObject* obj) {
	SeahorseGkrBackend * self;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
#line 61 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_service);
#line 62 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_keyrings);
#line 63 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_aliases);
#line 64 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_actions);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->finalize (obj);
#line 1297 "gkr-backend.c"
}


GType seahorse_gkr_backend_get_type (void) {
	static volatile gsize seahorse_gkr_backend_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackend), 0, (GInstanceInitFunc) seahorse_gkr_backend_instance_init, NULL };
		static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_gkr_backend_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_backend_info = { (GInterfaceInitFunc) seahorse_gkr_backend_seahorse_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_backend_type_id;
		seahorse_gkr_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseGkrBackend", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_backend_type_id, gcr_collection_get_type (), &gcr_collection_info);
		g_type_add_interface_static (seahorse_gkr_backend_type_id, SEAHORSE_TYPE_BACKEND, &seahorse_backend_info);
		g_once_init_leave (&seahorse_gkr_backend_type_id__volatile, seahorse_gkr_backend_type_id);
	}
	return seahorse_gkr_backend_type_id__volatile;
}


static void _vala_seahorse_gkr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
	switch (property_id) {
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_NAME:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_set_string (value, seahorse_backend_get_name ((SeahorseBackend*) self));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_LABEL:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_set_string (value, seahorse_backend_get_label ((SeahorseBackend*) self));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_DESCRIPTION:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_set_string (value, seahorse_backend_get_description ((SeahorseBackend*) self));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ACTIONS:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_take_object (value, seahorse_backend_get_actions ((SeahorseBackend*) self));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ALIASES:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_set_boxed (value, seahorse_gkr_backend_get_aliases (self));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_SERVICE:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_set_object (value, seahorse_gkr_backend_get_service (self));
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 1358 "gkr-backend.c"
		default:
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 1364 "gkr-backend.c"
	}
}


static void _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback (GtkAction* action, gpointer self) {
#line 242 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_actions_on_new_keyring (action);
#line 1372 "gkr-backend.c"
}


static void _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback (GtkAction* action, gpointer self) {
#line 242 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_actions_on_new_item (action);
#line 1379 "gkr-backend.c"
}


static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type, SeahorseGkrBackend* backend) {
	SeahorseGkrBackendActions * self = NULL;
	SeahorseGkrBackend* _tmp0_ = NULL;
#line 230 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (backend != NULL, NULL);
#line 231 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = backend;
#line 231 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackendActions*) g_object_new (object_type, "name", "KeyringBackend", "backend", _tmp0_, NULL);
#line 230 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return self;
#line 1394 "gkr-backend.c"
}


static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend) {
#line 230 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return seahorse_gkr_backend_actions_construct (SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, backend);
#line 1401 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_on_new_keyring (GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	SeahorseGkrKeyringAdd* _tmp3_ = NULL;
	SeahorseGkrKeyringAdd* _tmp4_ = NULL;
#line 234 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (action != NULL);
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = action;
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_action_get_window (_tmp0_);
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _tmp1_;
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_keyring_add_new (_tmp2_);
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_ref_sink (_tmp3_);
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = _tmp3_;
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp4_);
#line 235 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 1429 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_on_new_item (GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	SeahorseGkrItemAdd* _tmp3_ = NULL;
	SeahorseGkrItemAdd* _tmp4_ = NULL;
#line 238 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (action != NULL);
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = action;
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_action_get_window (_tmp0_);
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _tmp1_;
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_item_add_new (_tmp2_);
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_ref_sink (_tmp3_);
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = _tmp3_;
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp4_);
#line 239 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 1457 "gkr-backend.c"
}


GtkActionGroup* seahorse_gkr_backend_actions_instance (SeahorseGkrBackend* backend) {
	GtkActionGroup* result = NULL;
	SeahorseGkrBackendActions* actions = NULL;
	GObject* _tmp0_ = NULL;
	SeahorseGkrBackendActions* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	SeahorseGkrBackendActions* _tmp3_ = NULL;
	SeahorseGkrBackendActions* _tmp4_ = NULL;
#line 263 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (backend != NULL, NULL);
#line 264 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = g_weak_ref_get (&seahorse_gkr_backend_actions__instance);
#line 264 "/data/projects/seahorse/gkr/gkr-backend.vala"
	actions = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 265 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = actions;
#line 265 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (_tmp1_ != NULL) {
#line 266 "/data/projects/seahorse/gkr/gkr-backend.vala"
		result = (GtkActionGroup*) actions;
#line 266 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return result;
#line 1483 "gkr-backend.c"
	}
#line 267 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = backend;
#line 267 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_backend_actions_new (_tmp2_);
#line 267 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (actions);
#line 267 "/data/projects/seahorse/gkr/gkr-backend.vala"
	actions = _tmp3_;
#line 268 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = actions;
#line 268 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_weak_ref_set (&seahorse_gkr_backend_actions__instance, (GObject*) _tmp4_);
#line 269 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = (GtkActionGroup*) actions;
#line 269 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1501 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_actions_get_backend (SeahorseGkrBackendActions* self) {
	SeahorseGkrBackend* result;
	SeahorseGkrBackend* _tmp0_ = NULL;
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_backend;
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1516 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_set_backend (SeahorseGkrBackendActions* self, SeahorseGkrBackend* value) {
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = value;
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_backend);
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv->_backend = _tmp1_;
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_notify ((GObject *) self, "backend");
#line 1535 "gkr-backend.c"
}


static void _seahorse_gkr_backend_actions___lambda12_ (SeahorseGkrBackendActions* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	SeahorseGkrBackend* _tmp3_ = NULL;
	SecretService* _tmp4_ = NULL;
	SecretService* _tmp5_ = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp6_ = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkActionGroup* _tmp8_ = NULL;
	GtkActionGroup* _tmp9_ = NULL;
#line 208 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (pspec != NULL);
#line 209 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = pspec;
#line 209 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _tmp0_->name;
#line 209 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (g_strcmp0 (_tmp1_, "service") == 0) {
#line 210 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return;
#line 1561 "gkr-backend.c"
	}
#line 211 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = self->priv->_initialized;
#line 211 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (_tmp2_) {
#line 212 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return;
#line 1569 "gkr-backend.c"
	}
#line 213 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_backend;
#line 213 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = seahorse_gkr_backend_get_service (_tmp3_);
#line 213 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = _tmp4_;
#line 213 "/data/projects/seahorse/gkr/gkr-backend.vala"
	if (_tmp5_ == NULL) {
#line 214 "/data/projects/seahorse/gkr/gkr-backend.vala"
		return;
#line 1581 "gkr-backend.c"
	}
#line 216 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv->_initialized = TRUE;
#line 217 "/data/projects/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_add_actions ((GtkActionGroup*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS, G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS), NULL);
#line 218 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_actions_register_definition ((SeahorseActions*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_UI);
#line 221 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp6_ = gtk_action_group_new ("gkr-generate");
#line 221 "/data/projects/seahorse/gkr/gkr-backend.vala"
	actions = _tmp6_;
#line 222 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp7_ = actions;
#line 222 "/data/projects/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_set_translation_domain (_tmp7_, GETTEXT_PACKAGE);
#line 223 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp8_ = actions;
#line 223 "/data/projects/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_add_actions (_tmp8_, SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW, G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW), NULL);
#line 224 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp9_ = actions;
#line 224 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_registry_register_object ((GObject*) _tmp9_, "generator");
#line 208 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (actions);
#line 1607 "gkr-backend.c"
}


static void __seahorse_gkr_backend_actions___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 208 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_seahorse_gkr_backend_actions___lambda12_ (self, pspec);
#line 1614 "gkr-backend.c"
}


static GObject * seahorse_gkr_backend_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackendActions * self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
#line 204 "/data/projects/seahorse/gkr/gkr-backend.vala"
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class);
#line 204 "/data/projects/seahorse/gkr/gkr-backend.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 204 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 205 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv->_initialized = FALSE;
#line 206 "/data/projects/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_set_translation_domain ((GtkActionGroup*) self, GETTEXT_PACKAGE);
#line 208 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_backend;
#line 208 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) __seahorse_gkr_backend_actions___lambda12__g_object_notify, self, G_CONNECT_AFTER);
#line 227 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = self->priv->_backend;
#line 227 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_notify ((GObject*) _tmp1_, "service");
#line 204 "/data/projects/seahorse/gkr/gkr-backend.vala"
	return obj;
#line 1644 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_class_init (SeahorseGkrBackendActionsClass * klass) {
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_actions_parent_class = g_type_class_peek_parent (klass);
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrBackendActionsPrivate));
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_actions_get_property;
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_backend_actions_set_property;
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_actions_constructor;
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_actions_finalize;
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND, g_param_spec_object ("backend", "backend", "backend", SEAHORSE_GKR_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1663 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_instance_init (SeahorseGkrBackendActions * self) {
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self->priv = SEAHORSE_GKR_BACKEND_ACTIONS_GET_PRIVATE (self);
#line 1670 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_finalize (GObject* obj) {
	SeahorseGkrBackendActions * self;
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 200 "/data/projects/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_backend);
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class)->finalize (obj);
#line 1682 "gkr-backend.c"
}


GType seahorse_gkr_backend_actions_get_type (void) {
	static volatile gsize seahorse_gkr_backend_actions_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_actions_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackendActions), 0, (GInstanceInitFunc) seahorse_gkr_backend_actions_instance_init, NULL };
		GType seahorse_gkr_backend_actions_type_id;
		seahorse_gkr_backend_actions_type_id = g_type_register_static (SEAHORSE_TYPE_ACTIONS, "SeahorseGkrBackendActions", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_backend_actions_type_id__volatile, seahorse_gkr_backend_actions_type_id);
	}
	return seahorse_gkr_backend_actions_type_id__volatile;
}


static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	switch (property_id) {
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND:
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		g_value_set_object (value, seahorse_gkr_backend_actions_get_backend (self));
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 1709 "gkr-backend.c"
		default:
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 1715 "gkr-backend.c"
	}
}


static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
	switch (property_id) {
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND:
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		seahorse_gkr_backend_actions_set_backend (self, g_value_get_object (value));
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 1731 "gkr-backend.c"
		default:
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 199 "/data/projects/seahorse/gkr/gkr-backend.vala"
		break;
#line 1737 "gkr-backend.c"
	}
}



