/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <glib-object.h>

#include "seahorse-common.h"

#define SEAHORSE_PGP_TYPE_SIGNATURE            (seahorse_pgp_signature_get_type ())

#define SEAHORSE_PGP_SIGNATURE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_PGP_TYPE_SIGNATURE, SeahorsePgpSignature))
#define SEAHORSE_PGP_SIGNATURE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_PGP_TYPE_SIGNATURE, SeahorsePgpSignatureClass))
#define SEAHORSE_PGP_IS_SIGNATURE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_PGP_TYPE_SIGNATURE))
#define SEAHORSE_PGP_IS_SIGNATURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_PGP_TYPE_SIGNATURE))
#define SEAHORSE_PGP_SIGNATURE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_PGP_TYPE_SIGNATURE, SeahorsePgpSignatureClass))

typedef struct _SeahorsePgpSignature SeahorsePgpSignature;
typedef struct _SeahorsePgpSignatureClass SeahorsePgpSignatureClass;
typedef struct _SeahorsePgpSignaturePrivate SeahorsePgpSignaturePrivate;

struct _SeahorsePgpSignature {
	GObject parent;
	SeahorsePgpSignaturePrivate *pv;
};

struct _SeahorsePgpSignatureClass {
	GObjectClass parent_class;
};

GType                  seahorse_pgp_signature_get_type       (void);

SeahorsePgpSignature*  seahorse_pgp_signature_new            (const gchar *keyid);

const gchar*           seahorse_pgp_signature_get_keyid      (SeahorsePgpSignature *self);

void                   seahorse_pgp_signature_set_keyid      (SeahorsePgpSignature *self,
                                                              const gchar *keyid);

guint                  seahorse_pgp_signature_get_flags      (SeahorsePgpSignature *self);

void                   seahorse_pgp_signature_set_flags      (SeahorsePgpSignature *self,
                                                              guint flags);

guint                  seahorse_pgp_signature_get_sigtype    (SeahorsePgpSignature *self);
