/* catalog.c generated by valac 0.23.3.6-62e8, the Vala compiler
 * generated from catalog.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libseahorse/seahorse-application.h"
#include "libseahorse/seahorse-prefs.h"
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _SeahorseCatalogPrivate {
	gchar* _ui_name;
	GtkBuilder* _builder;
	GtkUIManager* _ui_manager;
	GHashTable* _actions;
	GtkAction* _edit_delete;
	GtkAction* _properties_object;
	GtkAction* _file_export;
	GtkAction* _edit_copy;
	GList* _selection_actions;
	gboolean _disposed;
	GSettings* _settings;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseCatalog* self;
	GtkAboutDialog* about;
};


static gpointer seahorse_catalog_parent_class = NULL;

#define SEAHORSE_CATALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_TYPE_CATALOG, SeahorseCatalogPrivate))
enum  {
	SEAHORSE_CATALOG_DUMMY_PROPERTY,
	SEAHORSE_CATALOG_WINDOW,
	SEAHORSE_CATALOG_UI_NAME
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_catalog_on_key_export_file (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_key_export_file_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_key_export_clipboard (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_key_export_clipboard_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_object_delete (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_object_delete_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_properties_object (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_properties_object_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_properties_place (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_properties_place_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_app_preferences (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_app_preferences_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_app_about (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_app_about_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_help_show (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_help_show_gtk_action_callback (GtkAction* action, gpointer self);
static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self);
static SeahorsePlace* seahorse_catalog_real_get_focused_place (SeahorseCatalog* self);
static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self);
static void seahorse_catalog_real_dispose (GObject* base);
static GList* seahorse_catalog_lookup_actions_for_objects (SeahorseCatalog* self, GList* objects);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda9_ (Block1Data* _data1_, gint response);
static void ___lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self);
static GObject * seahorse_catalog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_catalog___lambda10_ (SeahorseCatalog* self, GtkWidget* widget);
static void __seahorse_catalog___lambda10__gtk_ui_manager_add_widget (GtkUIManager* _sender, GtkWidget* widget, gpointer self);
static void _seahorse_catalog___lambda11_ (SeahorseCatalog* self, GtkAction* action);
static void __seahorse_catalog___lambda11__gtk_ui_manager_pre_activate (GtkUIManager* _sender, GtkAction* action, gpointer self);
static void _seahorse_catalog___lambda12_ (SeahorseCatalog* self, GtkAction* action);
static void __seahorse_catalog___lambda12__gtk_ui_manager_post_activate (GtkUIManager* _sender, GtkAction* action, gpointer self);
static void seahorse_catalog_finalize (GObject* obj);
static void _vala_seahorse_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SEAHORSE_CATALOG_AUTHORS[10] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Jose Carlos Garcia Sogo <jsogo@users.sourceforge.net>", "Jean Schurger <yshark@schurger.org>", "Stef Walter <stef@memberwebs.com>", "Adam Schreiber <sadam@clemson.edu>", "", "Contributions:", "Albrecht Dreß <albrecht.dress@arcor.de>", "Jim Pharis <binbrain@gmail.com>", NULL};
static const gchar* SEAHORSE_CATALOG_DOCUMENTERS[4] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Adam Schreiber <sadam@clemson.edu>", "Milo Casagrande <milo_casagrande@yahoo.it>", NULL};
static const gchar* SEAHORSE_CATALOG_ARTISTS[3] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Stef Walter <stef@memberwebs.com>", NULL};
static const GtkActionEntry SEAHORSE_CATALOG_UI_ENTRIES[12] = {{"file-menu", NULL, "_File"}, {"file-export", GTK_STOCK_SAVE_AS, "E_xport...", NULL, "Export to a file", (GCallback) _seahorse_catalog_on_key_export_file_gtk_action_callback}, {"edit-menu", NULL, "_Edit"}, {"edit-export-clipboard", GTK_STOCK_COPY, NULL, "<control>C", "Copy to the clipboard", (GCallback) _seahorse_catalog_on_key_export_clipboard_gtk_action_callback}, {"edit-delete", GTK_STOCK_DELETE, "_Delete", NULL, "Delete selected items", (GCallback) _seahorse_catalog_on_object_delete_gtk_action_callback}, {"properties-object", GTK_STOCK_PROPERTIES, NULL, NULL, "Show the properties of this item", (GCallback) _seahorse_catalog_on_properties_object_gtk_action_callback}, {"properties-keyring", GTK_STOCK_PROPERTIES, NULL, NULL, "Show the properties of this keyring", (GCallback) _seahorse_catalog_on_properties_place_gtk_action_callback}, {"app-preferences", GTK_STOCK_PREFERENCES, "Prefere_nces", NULL, "Change preferences for this program", (GCallback) _seahorse_catalog_on_app_preferences_gtk_action_callback}, {"view-menu", NULL, "_View"}, {"help-menu", NULL, "_Help"}, {"app-about", GTK_STOCK_ABOUT, NULL, NULL, "About this program", (GCallback) _seahorse_catalog_on_app_about_gtk_action_callback}, {"help-show", GTK_STOCK_HELP, "_Contents", "F1", "Show Seahorse help", (GCallback) _seahorse_catalog_on_help_show_gtk_action_callback}};

static void _g_object_unref0_ (gpointer var) {
#line 41 "/data/src/seahorse/common/catalog.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 122 "catalog.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 41 "/data/src/seahorse/common/catalog.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 41 "/data/src/seahorse/common/catalog.vala"
	g_list_free (self);
#line 131 "catalog.c"
}


static void _seahorse_catalog_on_key_export_file_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_key_export_file (action, (SeahorseCatalog*) self);
#line 138 "catalog.c"
}


static void _seahorse_catalog_on_key_export_clipboard_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_key_export_clipboard (action, (SeahorseCatalog*) self);
#line 145 "catalog.c"
}


static void _seahorse_catalog_on_object_delete_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_object_delete (action, (SeahorseCatalog*) self);
#line 152 "catalog.c"
}


static void _seahorse_catalog_on_properties_object_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_properties_object (action, (SeahorseCatalog*) self);
#line 159 "catalog.c"
}


static void _seahorse_catalog_on_properties_place_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_properties_place (action, (SeahorseCatalog*) self);
#line 166 "catalog.c"
}


static void _seahorse_catalog_on_app_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_app_preferences (action, (SeahorseCatalog*) self);
#line 173 "catalog.c"
}


static void _seahorse_catalog_on_app_about_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_app_about (action, (SeahorseCatalog*) self);
#line 180 "catalog.c"
}


static void _seahorse_catalog_on_help_show_gtk_action_callback (GtkAction* action, gpointer self) {
#line 362 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_on_help_show (action, (SeahorseCatalog*) self);
#line 187 "catalog.c"
}


static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self) {
#line 45 "/data/src/seahorse/common/catalog.vala"
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_backends'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 45 "/data/src/seahorse/common/catalog.vala"
	return NULL;
#line 196 "catalog.c"
}


GList* seahorse_catalog_get_backends (SeahorseCatalog* self) {
#line 45 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/data/src/seahorse/common/catalog.vala"
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_backends (self);
#line 205 "catalog.c"
}


static SeahorsePlace* seahorse_catalog_real_get_focused_place (SeahorseCatalog* self) {
#line 46 "/data/src/seahorse/common/catalog.vala"
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_focused_place'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 46 "/data/src/seahorse/common/catalog.vala"
	return NULL;
#line 214 "catalog.c"
}


SeahorsePlace* seahorse_catalog_get_focused_place (SeahorseCatalog* self) {
#line 46 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/data/src/seahorse/common/catalog.vala"
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_focused_place (self);
#line 223 "catalog.c"
}


static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self) {
#line 47 "/data/src/seahorse/common/catalog.vala"
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_selected_objects'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 47 "/data/src/seahorse/common/catalog.vala"
	return NULL;
#line 232 "catalog.c"
}


GList* seahorse_catalog_get_selected_objects (SeahorseCatalog* self) {
#line 47 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/data/src/seahorse/common/catalog.vala"
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_selected_objects (self);
#line 241 "catalog.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 120 "/data/src/seahorse/common/catalog.vala"
	return self ? g_object_ref (self) : NULL;
#line 248 "catalog.c"
}


static void seahorse_catalog_real_dispose (GObject* base) {
	SeahorseCatalog * self;
	GList* _tmp0_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 114 "/data/src/seahorse/common/catalog.vala"
	self = (SeahorseCatalog*) base;
#line 115 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_copy);
#line 115 "/data/src/seahorse/common/catalog.vala"
	self->priv->_edit_copy = NULL;
#line 116 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_delete);
#line 116 "/data/src/seahorse/common/catalog.vala"
	self->priv->_edit_delete = NULL;
#line 117 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_file_export);
#line 117 "/data/src/seahorse/common/catalog.vala"
	self->priv->_file_export = NULL;
#line 118 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_properties_object);
#line 118 "/data/src/seahorse/common/catalog.vala"
	self->priv->_properties_object = NULL;
#line 120 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_selection_actions;
#line 277 "catalog.c"
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
#line 120 "/data/src/seahorse/common/catalog.vala"
		group_collection = _tmp0_;
#line 120 "/data/src/seahorse/common/catalog.vala"
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
#line 285 "catalog.c"
			GtkActionGroup* _tmp1_ = NULL;
			GtkActionGroup* group = NULL;
#line 120 "/data/src/seahorse/common/catalog.vala"
			_tmp1_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
#line 120 "/data/src/seahorse/common/catalog.vala"
			group = _tmp1_;
#line 292 "catalog.c"
			{
				GtkUIManager* _tmp2_ = NULL;
				GtkActionGroup* _tmp3_ = NULL;
#line 121 "/data/src/seahorse/common/catalog.vala"
				_tmp2_ = self->priv->_ui_manager;
#line 121 "/data/src/seahorse/common/catalog.vala"
				_tmp3_ = group;
#line 121 "/data/src/seahorse/common/catalog.vala"
				gtk_ui_manager_remove_action_group (_tmp2_, _tmp3_);
#line 120 "/data/src/seahorse/common/catalog.vala"
				_g_object_unref0 (group);
#line 304 "catalog.c"
			}
		}
	}
#line 122 "/data/src/seahorse/common/catalog.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
#line 122 "/data/src/seahorse/common/catalog.vala"
	self->priv->_selection_actions = NULL;
#line 124 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 124 "/data/src/seahorse/common/catalog.vala"
	self->priv->_ui_manager = NULL;
#line 125 "/data/src/seahorse/common/catalog.vala"
	_tmp4_ = self->priv->_actions;
#line 125 "/data/src/seahorse/common/catalog.vala"
	g_hash_table_remove_all (_tmp4_);
#line 127 "/data/src/seahorse/common/catalog.vala"
	_tmp5_ = self->priv->_disposed;
#line 127 "/data/src/seahorse/common/catalog.vala"
	if (!_tmp5_) {
#line 324 "catalog.c"
		gint width = 0;
		gint height = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GSettings* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GSettings* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GtkApplication* _tmp12_ = NULL;
#line 128 "/data/src/seahorse/common/catalog.vala"
		self->priv->_disposed = TRUE;
#line 131 "/data/src/seahorse/common/catalog.vala"
		gtk_window_get_size ((GtkWindow*) self, &_tmp6_, &_tmp7_);
#line 131 "/data/src/seahorse/common/catalog.vala"
		width = _tmp6_;
#line 131 "/data/src/seahorse/common/catalog.vala"
		height = _tmp7_;
#line 132 "/data/src/seahorse/common/catalog.vala"
		_tmp8_ = self->priv->_settings;
#line 132 "/data/src/seahorse/common/catalog.vala"
		_tmp9_ = width;
#line 132 "/data/src/seahorse/common/catalog.vala"
		g_settings_set_int (_tmp8_, "width", _tmp9_);
#line 133 "/data/src/seahorse/common/catalog.vala"
		_tmp10_ = self->priv->_settings;
#line 133 "/data/src/seahorse/common/catalog.vala"
		_tmp11_ = height;
#line 133 "/data/src/seahorse/common/catalog.vala"
		g_settings_set_int (_tmp10_, "height", _tmp11_);
#line 134 "/data/src/seahorse/common/catalog.vala"
		_tmp12_ = seahorse_application_get ();
#line 134 "/data/src/seahorse/common/catalog.vala"
		gtk_application_remove_window (_tmp12_, (GtkWindow*) self);
#line 358 "catalog.c"
	}
#line 137 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow));
#line 362 "catalog.c"
}


GtkBuilder* seahorse_catalog_get_builder (SeahorseCatalog* self) {
	GtkBuilder* result = NULL;
	GtkBuilder* _tmp0_ = NULL;
#line 169 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 170 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_builder;
#line 170 "/data/src/seahorse/common/catalog.vala"
	result = _tmp0_;
#line 170 "/data/src/seahorse/common/catalog.vala"
	return result;
#line 377 "catalog.c"
}


gconstpointer seahorse_catalog_get_widget (SeahorseCatalog* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* name) {
	gconstpointer result = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
#line 173 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 173 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 174 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_builder;
#line 174 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = name;
#line 174 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
#line 174 "/data/src/seahorse/common/catalog.vala"
	result = (gconstpointer) _tmp2_;
#line 174 "/data/src/seahorse/common/catalog.vala"
	return result;
#line 400 "catalog.c"
}


void seahorse_catalog_ensure_updated (SeahorseCatalog* self) {
	GtkUIManager* _tmp0_ = NULL;
#line 177 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 178 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 178 "/data/src/seahorse/common/catalog.vala"
	gtk_ui_manager_ensure_update (_tmp0_);
#line 412 "catalog.c"
}


void seahorse_catalog_include_actions (SeahorseCatalog* self, GtkActionGroup* group) {
	GtkUIManager* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GHashTable* _tmp17_ = NULL;
	GtkActionGroup* _tmp18_ = NULL;
	GtkActionGroup* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 181 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 181 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (group != NULL);
#line 182 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 182 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = group;
#line 182 "/data/src/seahorse/common/catalog.vala"
	gtk_ui_manager_insert_action_group (_tmp0_, _tmp1_, 10);
#line 184 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = group;
#line 184 "/data/src/seahorse/common/catalog.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, SEAHORSE_TYPE_ACTIONS)) {
#line 438 "catalog.c"
		SeahorseActions* actions = NULL;
		GtkActionGroup* _tmp3_ = NULL;
		SeahorseActions* _tmp4_ = NULL;
		SeahorseActions* _tmp5_ = NULL;
		gchar* definition = NULL;
		SeahorseActions* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 185 "/data/src/seahorse/common/catalog.vala"
		_tmp3_ = group;
#line 185 "/data/src/seahorse/common/catalog.vala"
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_TYPE_ACTIONS, SeahorseActions));
#line 185 "/data/src/seahorse/common/catalog.vala"
		actions = _tmp4_;
#line 186 "/data/src/seahorse/common/catalog.vala"
		_tmp5_ = actions;
#line 186 "/data/src/seahorse/common/catalog.vala"
		seahorse_actions_set_catalog (_tmp5_, self);
#line 188 "/data/src/seahorse/common/catalog.vala"
		_tmp6_ = actions;
#line 188 "/data/src/seahorse/common/catalog.vala"
		_tmp7_ = seahorse_actions_get_definition (_tmp6_);
#line 188 "/data/src/seahorse/common/catalog.vala"
		_tmp8_ = _tmp7_;
#line 188 "/data/src/seahorse/common/catalog.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 188 "/data/src/seahorse/common/catalog.vala"
		definition = _tmp9_;
#line 189 "/data/src/seahorse/common/catalog.vala"
		_tmp10_ = definition;
#line 189 "/data/src/seahorse/common/catalog.vala"
		if (_tmp10_ != NULL) {
#line 473 "catalog.c"
			{
				GtkUIManager* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 191 "/data/src/seahorse/common/catalog.vala"
				_tmp11_ = self->priv->_ui_manager;
#line 191 "/data/src/seahorse/common/catalog.vala"
				_tmp12_ = definition;
#line 191 "/data/src/seahorse/common/catalog.vala"
				gtk_ui_manager_add_ui_from_string (_tmp11_, _tmp12_, (gssize) (-1), &_inner_error_);
#line 191 "/data/src/seahorse/common/catalog.vala"
				if (_inner_error_ != NULL) {
#line 485 "catalog.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				SeahorseActions* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
#line 190 "/data/src/seahorse/common/catalog.vala"
				err = _inner_error_;
#line 190 "/data/src/seahorse/common/catalog.vala"
				_inner_error_ = NULL;
#line 193 "/data/src/seahorse/common/catalog.vala"
				_tmp13_ = actions;
#line 193 "/data/src/seahorse/common/catalog.vala"
				_tmp14_ = gtk_action_group_get_name ((GtkActionGroup*) _tmp13_);
#line 193 "/data/src/seahorse/common/catalog.vala"
				_tmp15_ = _tmp14_;
#line 193 "/data/src/seahorse/common/catalog.vala"
				_tmp16_ = definition;
#line 193 "/data/src/seahorse/common/catalog.vala"
				g_warning ("catalog.vala:193: couldn't add ui defintion for action group: %s: %s", _tmp15_, _tmp16_);
#line 190 "/data/src/seahorse/common/catalog.vala"
				_g_error_free0 (err);
#line 513 "catalog.c"
			}
			__finally0:
#line 190 "/data/src/seahorse/common/catalog.vala"
			if (_inner_error_ != NULL) {
#line 190 "/data/src/seahorse/common/catalog.vala"
				_g_free0 (definition);
#line 190 "/data/src/seahorse/common/catalog.vala"
				_g_object_unref0 (actions);
#line 190 "/data/src/seahorse/common/catalog.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 190 "/data/src/seahorse/common/catalog.vala"
				g_clear_error (&_inner_error_);
#line 190 "/data/src/seahorse/common/catalog.vala"
				return;
#line 528 "catalog.c"
			}
		}
#line 184 "/data/src/seahorse/common/catalog.vala"
		_g_free0 (definition);
#line 184 "/data/src/seahorse/common/catalog.vala"
		_g_object_unref0 (actions);
#line 535 "catalog.c"
	}
#line 199 "/data/src/seahorse/common/catalog.vala"
	_tmp17_ = self->priv->_actions;
#line 199 "/data/src/seahorse/common/catalog.vala"
	_tmp18_ = group;
#line 199 "/data/src/seahorse/common/catalog.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 199 "/data/src/seahorse/common/catalog.vala"
	g_hash_table_add (_tmp17_, _tmp19_);
#line 545 "catalog.c"
}


void seahorse_catalog_show_properties (SeahorseCatalog* self, GObject* obj) {
	GObject* _tmp0_ = NULL;
#line 202 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 202 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (obj != NULL);
#line 203 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = obj;
#line 203 "/data/src/seahorse/common/catalog.vala"
	seahorse_viewable_view (_tmp0_, (GtkWindow*) self);
#line 559 "catalog.c"
}


void seahorse_catalog_show_context_menu (SeahorseCatalog* self, const gchar* name, guint button, guint time) {
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
#line 206 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 206 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (name != NULL);
#line 210 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = name;
#line 210 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = g_strdup_printf ("/%s", _tmp0_);
#line 210 "/data/src/seahorse/common/catalog.vala"
	path = _tmp1_;
#line 211 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 211 "/data/src/seahorse/common/catalog.vala"
	_tmp3_ = path;
#line 211 "/data/src/seahorse/common/catalog.vala"
	_tmp4_ = gtk_ui_manager_get_widget (_tmp2_, _tmp3_);
#line 211 "/data/src/seahorse/common/catalog.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 211 "/data/src/seahorse/common/catalog.vala"
	menu = _tmp5_;
#line 213 "/data/src/seahorse/common/catalog.vala"
	_tmp6_ = menu;
#line 213 "/data/src/seahorse/common/catalog.vala"
	if (_tmp6_ == NULL) {
#line 214 "/data/src/seahorse/common/catalog.vala"
		_g_object_unref0 (menu);
#line 214 "/data/src/seahorse/common/catalog.vala"
		_g_free0 (path);
#line 214 "/data/src/seahorse/common/catalog.vala"
		return;
#line 604 "catalog.c"
	}
#line 215 "/data/src/seahorse/common/catalog.vala"
	_tmp7_ = menu;
#line 215 "/data/src/seahorse/common/catalog.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_MENU)) {
#line 610 "catalog.c"
		GtkWidget* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		GtkWidget* _tmp11_ = NULL;
#line 216 "/data/src/seahorse/common/catalog.vala"
		_tmp8_ = menu;
#line 216 "/data/src/seahorse/common/catalog.vala"
		_tmp9_ = button;
#line 216 "/data/src/seahorse/common/catalog.vala"
		_tmp10_ = time;
#line 216 "/data/src/seahorse/common/catalog.vala"
		gtk_menu_popup (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_MENU, GtkMenu), NULL, NULL, NULL, NULL, _tmp9_, (guint32) _tmp10_);
#line 217 "/data/src/seahorse/common/catalog.vala"
		_tmp11_ = menu;
#line 217 "/data/src/seahorse/common/catalog.vala"
		gtk_widget_show (_tmp11_);
#line 627 "catalog.c"
	} else {
		const gchar* _tmp12_ = NULL;
#line 219 "/data/src/seahorse/common/catalog.vala"
		_tmp12_ = name;
#line 219 "/data/src/seahorse/common/catalog.vala"
		g_warning ("catalog.vala:219: the object /%s isn't a menu", _tmp12_);
#line 634 "catalog.c"
	}
#line 206 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (menu);
#line 206 "/data/src/seahorse/common/catalog.vala"
	_g_free0 (path);
#line 640 "catalog.c"
}


static GList* seahorse_catalog_lookup_actions_for_objects (SeahorseCatalog* self, GList* objects) {
	GList* result = NULL;
	GHashTable* table = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp14_ = NULL;
	GList* results = NULL;
	GtkActionGroup* group = NULL;
#line 223 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 224 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = g_direct_hash;
#line 224 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = g_direct_equal;
#line 224 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, NULL);
#line 224 "/data/src/seahorse/common/catalog.vala"
	table = _tmp2_;
#line 225 "/data/src/seahorse/common/catalog.vala"
	_tmp3_ = objects;
#line 667 "catalog.c"
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
#line 225 "/data/src/seahorse/common/catalog.vala"
		object_collection = _tmp3_;
#line 225 "/data/src/seahorse/common/catalog.vala"
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
#line 675 "catalog.c"
			GObject* _tmp4_ = NULL;
			GObject* object = NULL;
#line 225 "/data/src/seahorse/common/catalog.vala"
			_tmp4_ = _g_object_ref0 ((GObject*) object_it->data);
#line 225 "/data/src/seahorse/common/catalog.vala"
			object = _tmp4_;
#line 682 "catalog.c"
			{
				GtkActionGroup* actions = NULL;
				GObject* _tmp5_ = NULL;
				GtkActionGroup* _tmp6_ = NULL;
				GHashTable* _tmp7_ = NULL;
				GtkActionGroup* _tmp8_ = NULL;
				gconstpointer _tmp9_ = NULL;
				GHashTable* _tmp11_ = NULL;
				GtkActionGroup* _tmp12_ = NULL;
				GtkActionGroup* _tmp13_ = NULL;
#line 226 "/data/src/seahorse/common/catalog.vala"
				actions = NULL;
#line 227 "/data/src/seahorse/common/catalog.vala"
				_tmp5_ = object;
#line 227 "/data/src/seahorse/common/catalog.vala"
				g_object_get (_tmp5_, "actions", &actions, NULL, NULL);
#line 228 "/data/src/seahorse/common/catalog.vala"
				_tmp6_ = actions;
#line 228 "/data/src/seahorse/common/catalog.vala"
				if (_tmp6_ == NULL) {
#line 229 "/data/src/seahorse/common/catalog.vala"
					_g_object_unref0 (actions);
#line 229 "/data/src/seahorse/common/catalog.vala"
					_g_object_unref0 (object);
#line 229 "/data/src/seahorse/common/catalog.vala"
					continue;
#line 709 "catalog.c"
				}
#line 230 "/data/src/seahorse/common/catalog.vala"
				_tmp7_ = self->priv->_actions;
#line 230 "/data/src/seahorse/common/catalog.vala"
				_tmp8_ = actions;
#line 230 "/data/src/seahorse/common/catalog.vala"
				_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
#line 230 "/data/src/seahorse/common/catalog.vala"
				if (((GtkActionGroup*) _tmp9_) == NULL) {
#line 719 "catalog.c"
					GtkActionGroup* _tmp10_ = NULL;
#line 231 "/data/src/seahorse/common/catalog.vala"
					_tmp10_ = actions;
#line 231 "/data/src/seahorse/common/catalog.vala"
					seahorse_catalog_include_actions (self, _tmp10_);
#line 725 "catalog.c"
				}
#line 232 "/data/src/seahorse/common/catalog.vala"
				_tmp11_ = self->priv->_actions;
#line 232 "/data/src/seahorse/common/catalog.vala"
				_tmp12_ = actions;
#line 232 "/data/src/seahorse/common/catalog.vala"
				_tmp13_ = _g_object_ref0 (_tmp12_);
#line 232 "/data/src/seahorse/common/catalog.vala"
				g_hash_table_add (_tmp11_, _tmp13_);
#line 225 "/data/src/seahorse/common/catalog.vala"
				_g_object_unref0 (actions);
#line 225 "/data/src/seahorse/common/catalog.vala"
				_g_object_unref0 (object);
#line 739 "catalog.c"
			}
		}
	}
#line 235 "/data/src/seahorse/common/catalog.vala"
	_tmp14_ = table;
#line 235 "/data/src/seahorse/common/catalog.vala"
	g_hash_table_iter_init (&iter, _tmp14_);
#line 236 "/data/src/seahorse/common/catalog.vala"
	results = NULL;
#line 238 "/data/src/seahorse/common/catalog.vala"
	while (TRUE) {
#line 751 "catalog.c"
		gconstpointer _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GtkActionGroup* _tmp17_ = NULL;
		GtkActionGroup* _tmp18_ = NULL;
		GtkActionGroup* _tmp19_ = NULL;
#line 238 "/data/src/seahorse/common/catalog.vala"
		_tmp16_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp15_), (gpointer*) NULL);
#line 238 "/data/src/seahorse/common/catalog.vala"
		_g_object_unref0 (group);
#line 238 "/data/src/seahorse/common/catalog.vala"
		_tmp17_ = _g_object_ref0 (_tmp15_);
#line 238 "/data/src/seahorse/common/catalog.vala"
		group = _tmp17_;
#line 238 "/data/src/seahorse/common/catalog.vala"
		if (!_tmp16_) {
#line 238 "/data/src/seahorse/common/catalog.vala"
			break;
#line 769 "catalog.c"
		}
#line 239 "/data/src/seahorse/common/catalog.vala"
		_tmp18_ = group;
#line 239 "/data/src/seahorse/common/catalog.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 239 "/data/src/seahorse/common/catalog.vala"
		results = g_list_prepend (results, _tmp19_);
#line 777 "catalog.c"
	}
#line 241 "/data/src/seahorse/common/catalog.vala"
	result = results;
#line 241 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (group);
#line 241 "/data/src/seahorse/common/catalog.vala"
	_g_hash_table_unref0 (table);
#line 241 "/data/src/seahorse/common/catalog.vala"
	return result;
#line 787 "catalog.c"
}


static void seahorse_catalog_on_app_preferences (GtkAction* action, SeahorseCatalog* self) {
#line 245 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 245 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 247 "/data/src/seahorse/common/catalog.vala"
	seahorse_prefs_show ((GtkWindow*) self, NULL);
#line 798 "catalog.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 277 "/data/src/seahorse/common/catalog.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 277 "/data/src/seahorse/common/catalog.vala"
	return _data1_;
#line 807 "catalog.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 277 "/data/src/seahorse/common/catalog.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 816 "catalog.c"
		SeahorseCatalog* self;
#line 277 "/data/src/seahorse/common/catalog.vala"
		self = _data1_->self;
#line 277 "/data/src/seahorse/common/catalog.vala"
		_g_object_unref0 (_data1_->about);
#line 277 "/data/src/seahorse/common/catalog.vala"
		_g_object_unref0 (self);
#line 277 "/data/src/seahorse/common/catalog.vala"
		g_slice_free (Block1Data, _data1_);
#line 826 "catalog.c"
	}
}


static void __lambda9_ (Block1Data* _data1_, gint response) {
	SeahorseCatalog* self;
#line 292 "/data/src/seahorse/common/catalog.vala"
	self = _data1_->self;
#line 293 "/data/src/seahorse/common/catalog.vala"
	gtk_widget_hide ((GtkWidget*) _data1_->about);
#line 837 "catalog.c"
}


static void ___lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 292 "/data/src/seahorse/common/catalog.vala"
	__lambda9_ (self, response_id);
#line 844 "catalog.c"
}


static void seahorse_catalog_on_app_about (GtkAction* action, SeahorseCatalog* self) {
	Block1Data* _data1_;
	GtkAboutDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 277 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 277 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 277 "/data/src/seahorse/common/catalog.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 277 "/data/src/seahorse/common/catalog.vala"
	_data1_->_ref_count_ = 1;
#line 277 "/data/src/seahorse/common/catalog.vala"
	_data1_->self = g_object_ref (self);
#line 280 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 280 "/data/src/seahorse/common/catalog.vala"
	g_object_ref_sink (_tmp0_);
#line 280 "/data/src/seahorse/common/catalog.vala"
	_data1_->about = _tmp0_;
#line 281 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_artists (_data1_->about, SEAHORSE_CATALOG_ARTISTS);
#line 282 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_authors (_data1_->about, SEAHORSE_CATALOG_AUTHORS);
#line 283 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_documenters (_data1_->about, SEAHORSE_CATALOG_DOCUMENTERS);
#line 284 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_version (_data1_->about, VERSION);
#line 285 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = _ ("Passwords and Keys");
#line 285 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_comments (_data1_->about, _tmp1_);
#line 286 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_copyright (_data1_->about, "Copyright \xc2\xa9 2002 - 2010 Seahorse Project");
#line 287 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = _ ("translator-credits");
#line 287 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_translator_credits (_data1_->about, _tmp2_);
#line 288 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_logo_icon_name (_data1_->about, "seahorse");
#line 289 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_website (_data1_->about, "http://www.gnome.org/projects/seahorse");
#line 290 "/data/src/seahorse/common/catalog.vala"
	_tmp3_ = _ ("Seahorse Project Homepage");
#line 290 "/data/src/seahorse/common/catalog.vala"
	gtk_about_dialog_set_website_label (_data1_->about, _tmp3_);
#line 292 "/data/src/seahorse/common/catalog.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->about, "response", (GCallback) ___lambda9__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 296 "/data/src/seahorse/common/catalog.vala"
	gtk_window_set_transient_for ((GtkWindow*) _data1_->about, (GtkWindow*) self);
#line 297 "/data/src/seahorse/common/catalog.vala"
	gtk_dialog_run ((GtkDialog*) _data1_->about);
#line 298 "/data/src/seahorse/common/catalog.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->about);
#line 277 "/data/src/seahorse/common/catalog.vala"
	block1_data_unref (_data1_);
#line 277 "/data/src/seahorse/common/catalog.vala"
	_data1_ = NULL;
#line 908 "catalog.c"
}


static void seahorse_catalog_on_object_delete (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
#line 302 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 302 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 918 "catalog.c"
	{
		GList* objects = NULL;
		GList* _tmp0_ = NULL;
#line 305 "/data/src/seahorse/common/catalog.vala"
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 305 "/data/src/seahorse/common/catalog.vala"
		objects = _tmp0_;
#line 306 "/data/src/seahorse/common/catalog.vala"
		seahorse_deletable_delete_with_prompt_wait (objects, (GtkWindow*) self, &_inner_error_);
#line 306 "/data/src/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 306 "/data/src/seahorse/common/catalog.vala"
			_g_list_free0 (objects);
#line 932 "catalog.c"
			goto __catch1_g_error;
		}
#line 304 "/data/src/seahorse/common/catalog.vala"
		_g_list_free0 (objects);
#line 937 "catalog.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 304 "/data/src/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 304 "/data/src/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 308 "/data/src/seahorse/common/catalog.vala"
		_tmp1_ = seahorse_catalog_get_window (self);
#line 308 "/data/src/seahorse/common/catalog.vala"
		_tmp2_ = _tmp1_;
#line 308 "/data/src/seahorse/common/catalog.vala"
		_tmp3_ = _ ("Cannot delete");
#line 308 "/data/src/seahorse/common/catalog.vala"
		_tmp4_ = err;
#line 308 "/data/src/seahorse/common/catalog.vala"
		_tmp5_ = _tmp4_->message;
#line 308 "/data/src/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) _tmp2_, _tmp3_, _tmp5_);
#line 304 "/data/src/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 966 "catalog.c"
	}
	__finally1:
#line 304 "/data/src/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 304 "/data/src/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 304 "/data/src/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 304 "/data/src/seahorse/common/catalog.vala"
		return;
#line 977 "catalog.c"
	}
}


static void seahorse_catalog_on_properties_object (GtkAction* action, SeahorseCatalog* self) {
	GList* objects = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 313 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 313 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 314 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 314 "/data/src/seahorse/common/catalog.vala"
	objects = _tmp0_;
#line 315 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = objects;
#line 315 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 315 "/data/src/seahorse/common/catalog.vala"
	if (_tmp2_ > ((guint) 0)) {
#line 1001 "catalog.c"
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
#line 316 "/data/src/seahorse/common/catalog.vala"
		_tmp3_ = objects;
#line 316 "/data/src/seahorse/common/catalog.vala"
		_tmp4_ = _tmp3_->data;
#line 316 "/data/src/seahorse/common/catalog.vala"
		seahorse_catalog_show_properties (self, (GObject*) _tmp4_);
#line 1010 "catalog.c"
	}
#line 313 "/data/src/seahorse/common/catalog.vala"
	_g_list_free0 (objects);
#line 1014 "catalog.c"
}


static void seahorse_catalog_on_properties_place (GtkAction* action, SeahorseCatalog* self) {
	SeahorsePlace* place = NULL;
	SeahorsePlace* _tmp0_ = NULL;
	SeahorsePlace* _tmp1_ = NULL;
#line 320 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 320 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 321 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = seahorse_catalog_get_focused_place (self);
#line 321 "/data/src/seahorse/common/catalog.vala"
	place = _tmp0_;
#line 322 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = place;
#line 322 "/data/src/seahorse/common/catalog.vala"
	if (_tmp1_ != NULL) {
#line 1034 "catalog.c"
		SeahorsePlace* _tmp2_ = NULL;
#line 323 "/data/src/seahorse/common/catalog.vala"
		_tmp2_ = place;
#line 323 "/data/src/seahorse/common/catalog.vala"
		seahorse_catalog_show_properties (self, (GObject*) _tmp2_);
#line 1040 "catalog.c"
	}
#line 320 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (place);
#line 1044 "catalog.c"
}


static void seahorse_catalog_on_key_export_file (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
#line 327 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 327 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 1054 "catalog.c"
	{
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
#line 329 "/data/src/seahorse/common/catalog.vala"
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 329 "/data/src/seahorse/common/catalog.vala"
		_tmp1_ = _tmp0_;
#line 329 "/data/src/seahorse/common/catalog.vala"
		seahorse_exportable_export_to_prompt_wait (_tmp1_, (GtkWindow*) self, &_inner_error_);
#line 329 "/data/src/seahorse/common/catalog.vala"
		_g_list_free0 (_tmp1_);
#line 329 "/data/src/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 1068 "catalog.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp2_ = NULL;
		GtkWindow* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 328 "/data/src/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 328 "/data/src/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 331 "/data/src/seahorse/common/catalog.vala"
		_tmp2_ = seahorse_catalog_get_window (self);
#line 331 "/data/src/seahorse/common/catalog.vala"
		_tmp3_ = _tmp2_;
#line 331 "/data/src/seahorse/common/catalog.vala"
		_tmp4_ = _ ("Couldn't export keys");
#line 331 "/data/src/seahorse/common/catalog.vala"
		_tmp5_ = err;
#line 331 "/data/src/seahorse/common/catalog.vala"
		_tmp6_ = _tmp5_->message;
#line 331 "/data/src/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) _tmp3_, _tmp4_, _tmp6_);
#line 328 "/data/src/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 1099 "catalog.c"
	}
	__finally2:
#line 328 "/data/src/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 328 "/data/src/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 328 "/data/src/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 328 "/data/src/seahorse/common/catalog.vala"
		return;
#line 1110 "catalog.c"
	}
}


static void seahorse_catalog_on_key_export_clipboard (GtkAction* action, SeahorseCatalog* self) {
	guint8* output = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	GtkClipboard* board = NULL;
	GtkClipboard* _tmp7_ = NULL;
	GtkClipboard* _tmp8_ = NULL;
	GtkClipboard* _tmp9_ = NULL;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guint8* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GError * _inner_error_ = NULL;
#line 336 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 336 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 1132 "catalog.c"
	{
		GList* objects = NULL;
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		size_t _tmp3_;
#line 339 "/data/src/seahorse/common/catalog.vala"
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 339 "/data/src/seahorse/common/catalog.vala"
		objects = _tmp0_;
#line 340 "/data/src/seahorse/common/catalog.vala"
		_tmp1_ = objects;
#line 340 "/data/src/seahorse/common/catalog.vala"
		seahorse_exportable_export_to_text_wait (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
#line 340 "/data/src/seahorse/common/catalog.vala"
		output = (g_free (output), NULL);
#line 340 "/data/src/seahorse/common/catalog.vala"
		output = _tmp2_;
#line 340 "/data/src/seahorse/common/catalog.vala"
		output_length1 = _tmp3_;
#line 340 "/data/src/seahorse/common/catalog.vala"
		_output_size_ = output_length1;
#line 340 "/data/src/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 340 "/data/src/seahorse/common/catalog.vala"
			_g_list_free0 (objects);
#line 1159 "catalog.c"
			goto __catch3_g_error;
		}
#line 338 "/data/src/seahorse/common/catalog.vala"
		_g_list_free0 (objects);
#line 1164 "catalog.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 338 "/data/src/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 338 "/data/src/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 342 "/data/src/seahorse/common/catalog.vala"
		_tmp4_ = _ ("Couldn't export data");
#line 342 "/data/src/seahorse/common/catalog.vala"
		_tmp5_ = err;
#line 342 "/data/src/seahorse/common/catalog.vala"
		_tmp6_ = _tmp5_->message;
#line 342 "/data/src/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) self, _tmp4_, _tmp6_);
#line 343 "/data/src/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 343 "/data/src/seahorse/common/catalog.vala"
		output = (g_free (output), NULL);
#line 343 "/data/src/seahorse/common/catalog.vala"
		return;
#line 1191 "catalog.c"
	}
	__finally3:
#line 338 "/data/src/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 338 "/data/src/seahorse/common/catalog.vala"
		output = (g_free (output), NULL);
#line 338 "/data/src/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 338 "/data/src/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 338 "/data/src/seahorse/common/catalog.vala"
		return;
#line 1204 "catalog.c"
	}
#line 348 "/data/src/seahorse/common/catalog.vala"
	_tmp7_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
#line 348 "/data/src/seahorse/common/catalog.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 348 "/data/src/seahorse/common/catalog.vala"
	board = _tmp8_;
#line 349 "/data/src/seahorse/common/catalog.vala"
	_tmp9_ = board;
#line 349 "/data/src/seahorse/common/catalog.vala"
	_tmp10_ = output;
#line 349 "/data/src/seahorse/common/catalog.vala"
	_tmp10__length1 = output_length1;
#line 349 "/data/src/seahorse/common/catalog.vala"
	_tmp11_ = output;
#line 349 "/data/src/seahorse/common/catalog.vala"
	_tmp11__length1 = output_length1;
#line 349 "/data/src/seahorse/common/catalog.vala"
	gtk_clipboard_set_text (_tmp9_, (const gchar*) _tmp10_, _tmp11__length1);
#line 336 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (board);
#line 336 "/data/src/seahorse/common/catalog.vala"
	output = (g_free (output), NULL);
#line 1228 "catalog.c"
}


static void seahorse_catalog_on_help_show (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
#line 353 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 353 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 1238 "catalog.c"
	{
		gchar* document = NULL;
		gchar* _tmp0_ = NULL;
#line 355 "/data/src/seahorse/common/catalog.vala"
		_tmp0_ = g_strdup_printf ("help:%s/introduction", PACKAGE);
#line 355 "/data/src/seahorse/common/catalog.vala"
		document = _tmp0_;
#line 356 "/data/src/seahorse/common/catalog.vala"
		g_app_info_launch_default_for_uri (document, NULL, &_inner_error_);
#line 356 "/data/src/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 356 "/data/src/seahorse/common/catalog.vala"
			_g_free0 (document);
#line 1252 "catalog.c"
			goto __catch4_g_error;
		}
#line 354 "/data/src/seahorse/common/catalog.vala"
		_g_free0 (document);
#line 1257 "catalog.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 354 "/data/src/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 354 "/data/src/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 358 "/data/src/seahorse/common/catalog.vala"
		_tmp1_ = _ ("Could not display help: %s");
#line 358 "/data/src/seahorse/common/catalog.vala"
		_tmp2_ = err;
#line 358 "/data/src/seahorse/common/catalog.vala"
		_tmp3_ = _tmp2_->message;
#line 358 "/data/src/seahorse/common/catalog.vala"
		seahorse_util_show_error ((GtkWidget*) self, _tmp1_, _tmp3_);
#line 354 "/data/src/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 1280 "catalog.c"
	}
	__finally4:
#line 354 "/data/src/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 354 "/data/src/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 354 "/data/src/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 354 "/data/src/seahorse/common/catalog.vala"
		return;
#line 1291 "catalog.c"
	}
}


SeahorseCatalog* seahorse_catalog_construct (GType object_type) {
	SeahorseCatalog * self = NULL;
#line 23 "/data/src/seahorse/common/catalog.vala"
	self = (SeahorseCatalog*) g_object_new (object_type, NULL);
#line 23 "/data/src/seahorse/common/catalog.vala"
	return self;
#line 1302 "catalog.c"
}


GtkWindow* seahorse_catalog_get_window (SeahorseCatalog* self) {
	GtkWindow* result;
#line 28 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/data/src/seahorse/common/catalog.vala"
	result = (GtkWindow*) self;
#line 28 "/data/src/seahorse/common/catalog.vala"
	return result;
#line 1314 "catalog.c"
}


const gchar* seahorse_catalog_get_ui_name (SeahorseCatalog* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 32 "/data/src/seahorse/common/catalog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_name;
#line 32 "/data/src/seahorse/common/catalog.vala"
	result = _tmp0_;
#line 32 "/data/src/seahorse/common/catalog.vala"
	return result;
#line 1329 "catalog.c"
}


static void seahorse_catalog_set_ui_name (SeahorseCatalog* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 32 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (self != NULL);
#line 32 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = value;
#line 32 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 32 "/data/src/seahorse/common/catalog.vala"
	_g_free0 (self->priv->_ui_name);
#line 32 "/data/src/seahorse/common/catalog.vala"
	self->priv->_ui_name = _tmp1_;
#line 32 "/data/src/seahorse/common/catalog.vala"
	g_object_notify ((GObject *) self, "ui-name");
#line 1348 "catalog.c"
}


static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self) {
	gboolean can_properties = FALSE;
	gboolean can_delete = FALSE;
	gboolean can_export = FALSE;
	GList* objects = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkAction* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkAction* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GtkAction* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GtkAction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GList* _tmp21_ = NULL;
	GList* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	GList* _tmp26_ = NULL;
#line 141 "/data/src/seahorse/common/catalog.vala"
	can_properties = FALSE;
#line 142 "/data/src/seahorse/common/catalog.vala"
	can_delete = FALSE;
#line 143 "/data/src/seahorse/common/catalog.vala"
	can_export = FALSE;
#line 145 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
#line 145 "/data/src/seahorse/common/catalog.vala"
	objects = _tmp0_;
#line 146 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = objects;
#line 1383 "catalog.c"
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
#line 146 "/data/src/seahorse/common/catalog.vala"
		object_collection = _tmp1_;
#line 146 "/data/src/seahorse/common/catalog.vala"
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
#line 1391 "catalog.c"
			GObject* object = NULL;
#line 146 "/data/src/seahorse/common/catalog.vala"
			object = (GObject*) object_it->data;
#line 1395 "catalog.c"
			{
				GObject* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				GObject* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				GObject* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
#line 147 "/data/src/seahorse/common/catalog.vala"
				_tmp2_ = object;
#line 147 "/data/src/seahorse/common/catalog.vala"
				_tmp3_ = seahorse_exportable_can_export (_tmp2_);
#line 147 "/data/src/seahorse/common/catalog.vala"
				if (_tmp3_) {
#line 148 "/data/src/seahorse/common/catalog.vala"
					can_export = TRUE;
#line 1414 "catalog.c"
				}
#line 149 "/data/src/seahorse/common/catalog.vala"
				_tmp4_ = object;
#line 149 "/data/src/seahorse/common/catalog.vala"
				_tmp5_ = seahorse_deletable_can_delete (_tmp4_);
#line 149 "/data/src/seahorse/common/catalog.vala"
				if (_tmp5_) {
#line 150 "/data/src/seahorse/common/catalog.vala"
					can_delete = TRUE;
#line 1424 "catalog.c"
				}
#line 151 "/data/src/seahorse/common/catalog.vala"
				_tmp6_ = object;
#line 151 "/data/src/seahorse/common/catalog.vala"
				_tmp7_ = seahorse_viewable_can_view (_tmp6_);
#line 151 "/data/src/seahorse/common/catalog.vala"
				if (_tmp7_) {
#line 152 "/data/src/seahorse/common/catalog.vala"
					can_properties = TRUE;
#line 1434 "catalog.c"
				}
#line 153 "/data/src/seahorse/common/catalog.vala"
				_tmp10_ = can_export;
#line 153 "/data/src/seahorse/common/catalog.vala"
				if (_tmp10_) {
#line 1440 "catalog.c"
					gboolean _tmp11_ = FALSE;
#line 153 "/data/src/seahorse/common/catalog.vala"
					_tmp11_ = can_delete;
#line 153 "/data/src/seahorse/common/catalog.vala"
					_tmp9_ = _tmp11_;
#line 1446 "catalog.c"
				} else {
#line 153 "/data/src/seahorse/common/catalog.vala"
					_tmp9_ = FALSE;
#line 1450 "catalog.c"
				}
#line 153 "/data/src/seahorse/common/catalog.vala"
				if (_tmp9_) {
#line 1454 "catalog.c"
					gboolean _tmp12_ = FALSE;
#line 153 "/data/src/seahorse/common/catalog.vala"
					_tmp12_ = can_properties;
#line 153 "/data/src/seahorse/common/catalog.vala"
					_tmp8_ = _tmp12_;
#line 1460 "catalog.c"
				} else {
#line 153 "/data/src/seahorse/common/catalog.vala"
					_tmp8_ = FALSE;
#line 1464 "catalog.c"
				}
#line 153 "/data/src/seahorse/common/catalog.vala"
				if (_tmp8_) {
#line 154 "/data/src/seahorse/common/catalog.vala"
					break;
#line 1470 "catalog.c"
				}
			}
		}
	}
#line 157 "/data/src/seahorse/common/catalog.vala"
	_tmp13_ = self->priv->_properties_object;
#line 157 "/data/src/seahorse/common/catalog.vala"
	_tmp14_ = can_properties;
#line 157 "/data/src/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp13_, _tmp14_);
#line 158 "/data/src/seahorse/common/catalog.vala"
	_tmp15_ = self->priv->_edit_delete;
#line 158 "/data/src/seahorse/common/catalog.vala"
	_tmp16_ = can_delete;
#line 158 "/data/src/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp15_, _tmp16_);
#line 159 "/data/src/seahorse/common/catalog.vala"
	_tmp17_ = self->priv->_edit_copy;
#line 159 "/data/src/seahorse/common/catalog.vala"
	_tmp18_ = can_export;
#line 159 "/data/src/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp17_, _tmp18_);
#line 160 "/data/src/seahorse/common/catalog.vala"
	_tmp19_ = self->priv->_file_export;
#line 160 "/data/src/seahorse/common/catalog.vala"
	_tmp20_ = can_export;
#line 160 "/data/src/seahorse/common/catalog.vala"
	gtk_action_set_sensitive (_tmp19_, _tmp20_);
#line 162 "/data/src/seahorse/common/catalog.vala"
	_tmp21_ = self->priv->_selection_actions;
#line 1501 "catalog.c"
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
#line 162 "/data/src/seahorse/common/catalog.vala"
		group_collection = _tmp21_;
#line 162 "/data/src/seahorse/common/catalog.vala"
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
#line 1509 "catalog.c"
			GtkActionGroup* _tmp22_ = NULL;
			GtkActionGroup* group = NULL;
#line 162 "/data/src/seahorse/common/catalog.vala"
			_tmp22_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
#line 162 "/data/src/seahorse/common/catalog.vala"
			group = _tmp22_;
#line 1516 "catalog.c"
			{
				GtkActionGroup* _tmp23_ = NULL;
#line 163 "/data/src/seahorse/common/catalog.vala"
				_tmp23_ = group;
#line 163 "/data/src/seahorse/common/catalog.vala"
				gtk_action_group_set_visible (_tmp23_, FALSE);
#line 162 "/data/src/seahorse/common/catalog.vala"
				_g_object_unref0 (group);
#line 1525 "catalog.c"
			}
		}
	}
#line 164 "/data/src/seahorse/common/catalog.vala"
	_tmp24_ = objects;
#line 164 "/data/src/seahorse/common/catalog.vala"
	_tmp25_ = seahorse_catalog_lookup_actions_for_objects (self, _tmp24_);
#line 164 "/data/src/seahorse/common/catalog.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
#line 164 "/data/src/seahorse/common/catalog.vala"
	self->priv->_selection_actions = _tmp25_;
#line 165 "/data/src/seahorse/common/catalog.vala"
	_tmp26_ = self->priv->_selection_actions;
#line 1539 "catalog.c"
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
#line 165 "/data/src/seahorse/common/catalog.vala"
		group_collection = _tmp26_;
#line 165 "/data/src/seahorse/common/catalog.vala"
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
#line 1547 "catalog.c"
			GtkActionGroup* _tmp27_ = NULL;
			GtkActionGroup* group = NULL;
#line 165 "/data/src/seahorse/common/catalog.vala"
			_tmp27_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
#line 165 "/data/src/seahorse/common/catalog.vala"
			group = _tmp27_;
#line 1554 "catalog.c"
			{
				GtkActionGroup* _tmp28_ = NULL;
#line 166 "/data/src/seahorse/common/catalog.vala"
				_tmp28_ = group;
#line 166 "/data/src/seahorse/common/catalog.vala"
				gtk_action_group_set_visible (_tmp28_, TRUE);
#line 165 "/data/src/seahorse/common/catalog.vala"
				_g_object_unref0 (group);
#line 1563 "catalog.c"
			}
		}
	}
#line 140 "/data/src/seahorse/common/catalog.vala"
	_g_list_free0 (objects);
#line 1569 "catalog.c"
}


static void _seahorse_catalog___lambda10_ (SeahorseCatalog* self, GtkWidget* widget) {
	const gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	GObject* holder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
#line 55 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (widget != NULL);
#line 57 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = widget;
#line 57 "/data/src/seahorse/common/catalog.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_MENU_BAR)) {
#line 58 "/data/src/seahorse/common/catalog.vala"
		name = "menu-placeholder";
#line 1590 "catalog.c"
	} else {
		GtkWidget* _tmp1_ = NULL;
#line 59 "/data/src/seahorse/common/catalog.vala"
		_tmp1_ = widget;
#line 59 "/data/src/seahorse/common/catalog.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_TOOLBAR)) {
#line 60 "/data/src/seahorse/common/catalog.vala"
			name = "toolbar-placeholder";
#line 1599 "catalog.c"
		} else {
#line 62 "/data/src/seahorse/common/catalog.vala"
			name = NULL;
#line 1603 "catalog.c"
		}
	}
#line 63 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = self->priv->_builder;
#line 63 "/data/src/seahorse/common/catalog.vala"
	_tmp3_ = name;
#line 63 "/data/src/seahorse/common/catalog.vala"
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
#line 63 "/data/src/seahorse/common/catalog.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 63 "/data/src/seahorse/common/catalog.vala"
	holder = _tmp5_;
#line 64 "/data/src/seahorse/common/catalog.vala"
	_tmp6_ = holder;
#line 64 "/data/src/seahorse/common/catalog.vala"
	if (_tmp6_ != NULL) {
#line 1620 "catalog.c"
		GObject* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		GtkWidget* _tmp9_ = NULL;
#line 65 "/data/src/seahorse/common/catalog.vala"
		_tmp7_ = holder;
#line 65 "/data/src/seahorse/common/catalog.vala"
		_tmp8_ = widget;
#line 65 "/data/src/seahorse/common/catalog.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_CONTAINER, GtkContainer), _tmp8_);
#line 66 "/data/src/seahorse/common/catalog.vala"
		_tmp9_ = widget;
#line 66 "/data/src/seahorse/common/catalog.vala"
		gtk_widget_show (_tmp9_);
#line 1634 "catalog.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 68 "/data/src/seahorse/common/catalog.vala"
		_tmp10_ = name;
#line 68 "/data/src/seahorse/common/catalog.vala"
		g_warning ("catalog.vala:68: no place holder found for: %s", _tmp10_);
#line 1641 "catalog.c"
	}
#line 55 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (holder);
#line 1645 "catalog.c"
}


static void __seahorse_catalog___lambda10__gtk_ui_manager_add_widget (GtkUIManager* _sender, GtkWidget* widget, gpointer self) {
#line 55 "/data/src/seahorse/common/catalog.vala"
	_seahorse_catalog___lambda10_ ((SeahorseCatalog*) self, widget);
#line 1652 "catalog.c"
}


static void _seahorse_catalog___lambda11_ (SeahorseCatalog* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
#line 72 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 73 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = action;
#line 73 "/data/src/seahorse/common/catalog.vala"
	seahorse_action_pre_activate (_tmp0_, self, (GtkWindow*) self);
#line 1664 "catalog.c"
}


static void __seahorse_catalog___lambda11__gtk_ui_manager_pre_activate (GtkUIManager* _sender, GtkAction* action, gpointer self) {
#line 72 "/data/src/seahorse/common/catalog.vala"
	_seahorse_catalog___lambda11_ ((SeahorseCatalog*) self, action);
#line 1671 "catalog.c"
}


static void _seahorse_catalog___lambda12_ (SeahorseCatalog* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
#line 76 "/data/src/seahorse/common/catalog.vala"
	g_return_if_fail (action != NULL);
#line 77 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = action;
#line 77 "/data/src/seahorse/common/catalog.vala"
	seahorse_action_post_activate (_tmp0_);
#line 1683 "catalog.c"
}


static void __seahorse_catalog___lambda12__gtk_ui_manager_post_activate (GtkUIManager* _sender, GtkAction* action, gpointer self) {
#line 76 "/data/src/seahorse/common/catalog.vala"
	_seahorse_catalog___lambda12_ ((SeahorseCatalog*) self, action);
#line 1690 "catalog.c"
}


static GObject * seahorse_catalog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseCatalog * self;
	const gchar* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GtkUIManager* _tmp5_ = NULL;
	GtkUIManager* _tmp6_ = NULL;
	GtkUIManager* _tmp7_ = NULL;
	GtkUIManager* _tmp8_ = NULL;
	gchar* key = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	gint width = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint height = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_ = 0;
	GtkUIManager* _tmp32_ = NULL;
	GtkAccelGroup* _tmp33_ = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp34_ = NULL;
	GtkActionGroup* _tmp35_ = NULL;
	GtkActionGroup* _tmp36_ = NULL;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp37_ = NULL;
	GtkAction* _tmp38_ = NULL;
	GtkAction* _tmp39_ = NULL;
	GtkAction* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GtkActionGroup* _tmp42_ = NULL;
	GtkAction* _tmp43_ = NULL;
	GtkAction* _tmp44_ = NULL;
	GtkActionGroup* _tmp45_ = NULL;
	GtkAction* _tmp46_ = NULL;
	GtkAction* _tmp47_ = NULL;
	GtkActionGroup* _tmp48_ = NULL;
	GtkAction* _tmp49_ = NULL;
	GtkAction* _tmp50_ = NULL;
	GtkActionGroup* _tmp51_ = NULL;
	GtkAction* _tmp52_ = NULL;
	GtkAction* _tmp53_ = NULL;
	GtkUIManager* _tmp54_ = NULL;
	GtkActionGroup* _tmp55_ = NULL;
	GtkApplication* _tmp56_ = NULL;
	GError * _inner_error_ = NULL;
#line 49 "/data/src/seahorse/common/catalog.vala"
	parent_class = G_OBJECT_CLASS (seahorse_catalog_parent_class);
#line 49 "/data/src/seahorse/common/catalog.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 49 "/data/src/seahorse/common/catalog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 50 "/data/src/seahorse/common/catalog.vala"
	_tmp0_ = self->priv->_ui_name;
#line 50 "/data/src/seahorse/common/catalog.vala"
	_tmp1_ = seahorse_util_load_built_contents ((GtkContainer*) self, _tmp0_);
#line 50 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_builder);
#line 50 "/data/src/seahorse/common/catalog.vala"
	self->priv->_builder = _tmp1_;
#line 52 "/data/src/seahorse/common/catalog.vala"
	_tmp2_ = g_direct_hash;
#line 52 "/data/src/seahorse/common/catalog.vala"
	_tmp3_ = g_direct_equal;
#line 52 "/data/src/seahorse/common/catalog.vala"
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, NULL);
#line 52 "/data/src/seahorse/common/catalog.vala"
	_g_hash_table_unref0 (self->priv->_actions);
#line 52 "/data/src/seahorse/common/catalog.vala"
	self->priv->_actions = _tmp4_;
#line 53 "/data/src/seahorse/common/catalog.vala"
	_tmp5_ = gtk_ui_manager_new ();
#line 53 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 53 "/data/src/seahorse/common/catalog.vala"
	self->priv->_ui_manager = _tmp5_;
#line 55 "/data/src/seahorse/common/catalog.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 55 "/data/src/seahorse/common/catalog.vala"
	g_signal_connect_object (_tmp6_, "add-widget", (GCallback) __seahorse_catalog___lambda10__gtk_ui_manager_add_widget, self, 0);
#line 72 "/data/src/seahorse/common/catalog.vala"
	_tmp7_ = self->priv->_ui_manager;
#line 72 "/data/src/seahorse/common/catalog.vala"
	g_signal_connect_object (_tmp7_, "pre-activate", (GCallback) __seahorse_catalog___lambda11__gtk_ui_manager_pre_activate, self, 0);
#line 76 "/data/src/seahorse/common/catalog.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 76 "/data/src/seahorse/common/catalog.vala"
	g_signal_connect_object (_tmp8_, "post-activate", (GCallback) __seahorse_catalog___lambda12__gtk_ui_manager_post_activate, self, 0);
#line 81 "/data/src/seahorse/common/catalog.vala"
	_tmp9_ = self->priv->_ui_name;
#line 81 "/data/src/seahorse/common/catalog.vala"
	_tmp10_ = g_strdup_printf ("/apps/seahorse/windows/%s/", _tmp9_);
#line 81 "/data/src/seahorse/common/catalog.vala"
	key = _tmp10_;
#line 82 "/data/src/seahorse/common/catalog.vala"
	_tmp11_ = key;
#line 82 "/data/src/seahorse/common/catalog.vala"
	_tmp12_ = g_settings_new_with_path ("org.gnome.seahorse.window", _tmp11_);
#line 82 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_settings);
#line 82 "/data/src/seahorse/common/catalog.vala"
	self->priv->_settings = _tmp12_;
#line 83 "/data/src/seahorse/common/catalog.vala"
	_tmp13_ = self->priv->_settings;
#line 83 "/data/src/seahorse/common/catalog.vala"
	_tmp14_ = g_settings_get_int (_tmp13_, "width");
#line 83 "/data/src/seahorse/common/catalog.vala"
	width = _tmp14_;
#line 84 "/data/src/seahorse/common/catalog.vala"
	_tmp15_ = self->priv->_settings;
#line 84 "/data/src/seahorse/common/catalog.vala"
	_tmp16_ = g_settings_get_int (_tmp15_, "height");
#line 84 "/data/src/seahorse/common/catalog.vala"
	height = _tmp16_;
#line 85 "/data/src/seahorse/common/catalog.vala"
	_tmp18_ = width;
#line 85 "/data/src/seahorse/common/catalog.vala"
	if (_tmp18_ > 0) {
#line 1820 "catalog.c"
		gint _tmp19_ = 0;
#line 85 "/data/src/seahorse/common/catalog.vala"
		_tmp19_ = height;
#line 85 "/data/src/seahorse/common/catalog.vala"
		_tmp17_ = _tmp19_ > 0;
#line 1826 "catalog.c"
	} else {
#line 85 "/data/src/seahorse/common/catalog.vala"
		_tmp17_ = FALSE;
#line 1830 "catalog.c"
	}
#line 85 "/data/src/seahorse/common/catalog.vala"
	if (_tmp17_) {
#line 1834 "catalog.c"
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 86 "/data/src/seahorse/common/catalog.vala"
		_tmp20_ = width;
#line 86 "/data/src/seahorse/common/catalog.vala"
		_tmp21_ = height;
#line 86 "/data/src/seahorse/common/catalog.vala"
		gtk_window_resize ((GtkWindow*) self, _tmp20_, _tmp21_);
#line 1843 "catalog.c"
	}
	{
		gchar* path = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		GtkUIManager* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 90 "/data/src/seahorse/common/catalog.vala"
		_tmp22_ = self->priv->_ui_name;
#line 90 "/data/src/seahorse/common/catalog.vala"
		_tmp23_ = g_strdup_printf ("seahorse-%s.ui", _tmp22_);
#line 90 "/data/src/seahorse/common/catalog.vala"
		_tmp24_ = _tmp23_;
#line 90 "/data/src/seahorse/common/catalog.vala"
		_tmp25_ = g_build_filename (UIDIR, _tmp24_, NULL);
#line 90 "/data/src/seahorse/common/catalog.vala"
		_tmp26_ = _tmp25_;
#line 90 "/data/src/seahorse/common/catalog.vala"
		_g_free0 (_tmp24_);
#line 90 "/data/src/seahorse/common/catalog.vala"
		path = _tmp26_;
#line 91 "/data/src/seahorse/common/catalog.vala"
		_tmp27_ = self->priv->_ui_manager;
#line 91 "/data/src/seahorse/common/catalog.vala"
		_tmp28_ = path;
#line 91 "/data/src/seahorse/common/catalog.vala"
		gtk_ui_manager_add_ui_from_file (_tmp27_, _tmp28_, &_inner_error_);
#line 91 "/data/src/seahorse/common/catalog.vala"
		if (_inner_error_ != NULL) {
#line 91 "/data/src/seahorse/common/catalog.vala"
			_g_free0 (path);
#line 1878 "catalog.c"
			goto __catch5_g_error;
		}
#line 89 "/data/src/seahorse/common/catalog.vala"
		_g_free0 (path);
#line 1883 "catalog.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
#line 89 "/data/src/seahorse/common/catalog.vala"
		err = _inner_error_;
#line 89 "/data/src/seahorse/common/catalog.vala"
		_inner_error_ = NULL;
#line 93 "/data/src/seahorse/common/catalog.vala"
		_tmp29_ = self->priv->_ui_name;
#line 93 "/data/src/seahorse/common/catalog.vala"
		_tmp30_ = err;
#line 93 "/data/src/seahorse/common/catalog.vala"
		_tmp31_ = _tmp30_->message;
#line 93 "/data/src/seahorse/common/catalog.vala"
		g_warning ("catalog.vala:93: couldn't load ui description for '%s': %s", _tmp29_, _tmp31_);
#line 89 "/data/src/seahorse/common/catalog.vala"
		_g_error_free0 (err);
#line 1906 "catalog.c"
	}
	__finally5:
#line 89 "/data/src/seahorse/common/catalog.vala"
	if (_inner_error_ != NULL) {
#line 89 "/data/src/seahorse/common/catalog.vala"
		_g_free0 (key);
#line 89 "/data/src/seahorse/common/catalog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/data/src/seahorse/common/catalog.vala"
		g_clear_error (&_inner_error_);
#line 1917 "catalog.c"
	}
#line 97 "/data/src/seahorse/common/catalog.vala"
	_tmp32_ = self->priv->_ui_manager;
#line 97 "/data/src/seahorse/common/catalog.vala"
	_tmp33_ = gtk_ui_manager_get_accel_group (_tmp32_);
#line 97 "/data/src/seahorse/common/catalog.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp33_);
#line 99 "/data/src/seahorse/common/catalog.vala"
	_tmp34_ = gtk_action_group_new ("main");
#line 99 "/data/src/seahorse/common/catalog.vala"
	actions = _tmp34_;
#line 100 "/data/src/seahorse/common/catalog.vala"
	_tmp35_ = actions;
#line 100 "/data/src/seahorse/common/catalog.vala"
	gtk_action_group_set_translation_domain (_tmp35_, GETTEXT_PACKAGE);
#line 101 "/data/src/seahorse/common/catalog.vala"
	_tmp36_ = actions;
#line 101 "/data/src/seahorse/common/catalog.vala"
	gtk_action_group_add_actions (_tmp36_, SEAHORSE_CATALOG_UI_ENTRIES, G_N_ELEMENTS (SEAHORSE_CATALOG_UI_ENTRIES), self);
#line 103 "/data/src/seahorse/common/catalog.vala"
	_tmp37_ = actions;
#line 103 "/data/src/seahorse/common/catalog.vala"
	_tmp38_ = gtk_action_group_get_action (_tmp37_, "app-preferences");
#line 103 "/data/src/seahorse/common/catalog.vala"
	_tmp39_ = _g_object_ref0 (_tmp38_);
#line 103 "/data/src/seahorse/common/catalog.vala"
	action = _tmp39_;
#line 104 "/data/src/seahorse/common/catalog.vala"
	_tmp40_ = action;
#line 104 "/data/src/seahorse/common/catalog.vala"
	_tmp41_ = seahorse_prefs_available ();
#line 104 "/data/src/seahorse/common/catalog.vala"
	gtk_action_set_visible (_tmp40_, _tmp41_);
#line 105 "/data/src/seahorse/common/catalog.vala"
	_tmp42_ = actions;
#line 105 "/data/src/seahorse/common/catalog.vala"
	_tmp43_ = gtk_action_group_get_action (_tmp42_, "edit-delete");
#line 105 "/data/src/seahorse/common/catalog.vala"
	_tmp44_ = _g_object_ref0 (_tmp43_);
#line 105 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_delete);
#line 105 "/data/src/seahorse/common/catalog.vala"
	self->priv->_edit_delete = _tmp44_;
#line 106 "/data/src/seahorse/common/catalog.vala"
	_tmp45_ = actions;
#line 106 "/data/src/seahorse/common/catalog.vala"
	_tmp46_ = gtk_action_group_get_action (_tmp45_, "properties-object");
#line 106 "/data/src/seahorse/common/catalog.vala"
	_tmp47_ = _g_object_ref0 (_tmp46_);
#line 106 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_properties_object);
#line 106 "/data/src/seahorse/common/catalog.vala"
	self->priv->_properties_object = _tmp47_;
#line 107 "/data/src/seahorse/common/catalog.vala"
	_tmp48_ = actions;
#line 107 "/data/src/seahorse/common/catalog.vala"
	_tmp49_ = gtk_action_group_get_action (_tmp48_, "edit-export-clipboard");
#line 107 "/data/src/seahorse/common/catalog.vala"
	_tmp50_ = _g_object_ref0 (_tmp49_);
#line 107 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_copy);
#line 107 "/data/src/seahorse/common/catalog.vala"
	self->priv->_edit_copy = _tmp50_;
#line 108 "/data/src/seahorse/common/catalog.vala"
	_tmp51_ = actions;
#line 108 "/data/src/seahorse/common/catalog.vala"
	_tmp52_ = gtk_action_group_get_action (_tmp51_, "file-export");
#line 108 "/data/src/seahorse/common/catalog.vala"
	_tmp53_ = _g_object_ref0 (_tmp52_);
#line 108 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_file_export);
#line 108 "/data/src/seahorse/common/catalog.vala"
	self->priv->_file_export = _tmp53_;
#line 109 "/data/src/seahorse/common/catalog.vala"
	_tmp54_ = self->priv->_ui_manager;
#line 109 "/data/src/seahorse/common/catalog.vala"
	_tmp55_ = actions;
#line 109 "/data/src/seahorse/common/catalog.vala"
	gtk_ui_manager_insert_action_group (_tmp54_, _tmp55_, 0);
#line 111 "/data/src/seahorse/common/catalog.vala"
	_tmp56_ = seahorse_application_get ();
#line 111 "/data/src/seahorse/common/catalog.vala"
	gtk_application_add_window (_tmp56_, (GtkWindow*) self);
#line 49 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (action);
#line 49 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (actions);
#line 49 "/data/src/seahorse/common/catalog.vala"
	_g_free0 (key);
#line 49 "/data/src/seahorse/common/catalog.vala"
	return obj;
#line 2009 "catalog.c"
}


static void seahorse_catalog_class_init (SeahorseCatalogClass * klass) {
#line 23 "/data/src/seahorse/common/catalog.vala"
	seahorse_catalog_parent_class = g_type_class_peek_parent (klass);
#line 23 "/data/src/seahorse/common/catalog.vala"
	g_type_class_add_private (klass, sizeof (SeahorseCatalogPrivate));
#line 23 "/data/src/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->get_backends = seahorse_catalog_real_get_backends;
#line 23 "/data/src/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->get_focused_place = seahorse_catalog_real_get_focused_place;
#line 23 "/data/src/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->get_selected_objects = seahorse_catalog_real_get_selected_objects;
#line 23 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->dispose = seahorse_catalog_real_dispose;
#line 23 "/data/src/seahorse/common/catalog.vala"
	SEAHORSE_CATALOG_CLASS (klass)->selection_changed = seahorse_catalog_real_selection_changed;
#line 23 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_catalog_get_property;
#line 23 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_catalog_set_property;
#line 23 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_catalog_constructor;
#line 23 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_catalog_finalize;
#line 23 "/data/src/seahorse/common/catalog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_WINDOW, g_param_spec_object ("window", "window", "window", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/data/src/seahorse/common/catalog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_UI_NAME, g_param_spec_string ("ui-name", "ui-name", "ui-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 23 "/data/src/seahorse/common/catalog.vala"
	g_signal_new ("selection_changed", SEAHORSE_TYPE_CATALOG, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SeahorseCatalogClass, selection_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2042 "catalog.c"
}


static void seahorse_catalog_instance_init (SeahorseCatalog * self) {
#line 23 "/data/src/seahorse/common/catalog.vala"
	self->priv = SEAHORSE_CATALOG_GET_PRIVATE (self);
#line 2049 "catalog.c"
}


static void seahorse_catalog_finalize (GObject* obj) {
	SeahorseCatalog * self;
#line 23 "/data/src/seahorse/common/catalog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 32 "/data/src/seahorse/common/catalog.vala"
	_g_free0 (self->priv->_ui_name);
#line 34 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_builder);
#line 35 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 36 "/data/src/seahorse/common/catalog.vala"
	_g_hash_table_unref0 (self->priv->_actions);
#line 37 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_delete);
#line 38 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_properties_object);
#line 39 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_file_export);
#line 40 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_edit_copy);
#line 41 "/data/src/seahorse/common/catalog.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
#line 43 "/data/src/seahorse/common/catalog.vala"
	_g_object_unref0 (self->priv->_settings);
#line 23 "/data/src/seahorse/common/catalog.vala"
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->finalize (obj);
#line 2079 "catalog.c"
}


GType seahorse_catalog_get_type (void) {
	static volatile gsize seahorse_catalog_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_catalog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseCatalogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_catalog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseCatalog), 0, (GInstanceInitFunc) seahorse_catalog_instance_init, NULL };
		GType seahorse_catalog_type_id;
		seahorse_catalog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "SeahorseCatalog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&seahorse_catalog_type_id__volatile, seahorse_catalog_type_id);
	}
	return seahorse_catalog_type_id__volatile;
}


static void _vala_seahorse_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 23 "/data/src/seahorse/common/catalog.vala"
	switch (property_id) {
#line 23 "/data/src/seahorse/common/catalog.vala"
		case SEAHORSE_CATALOG_WINDOW:
#line 23 "/data/src/seahorse/common/catalog.vala"
		g_value_set_object (value, seahorse_catalog_get_window (self));
#line 23 "/data/src/seahorse/common/catalog.vala"
		break;
#line 23 "/data/src/seahorse/common/catalog.vala"
		case SEAHORSE_CATALOG_UI_NAME:
#line 23 "/data/src/seahorse/common/catalog.vala"
		g_value_set_string (value, seahorse_catalog_get_ui_name (self));
#line 23 "/data/src/seahorse/common/catalog.vala"
		break;
#line 2112 "catalog.c"
		default:
#line 23 "/data/src/seahorse/common/catalog.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/data/src/seahorse/common/catalog.vala"
		break;
#line 2118 "catalog.c"
	}
}


static void _vala_seahorse_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
#line 23 "/data/src/seahorse/common/catalog.vala"
	switch (property_id) {
#line 23 "/data/src/seahorse/common/catalog.vala"
		case SEAHORSE_CATALOG_UI_NAME:
#line 23 "/data/src/seahorse/common/catalog.vala"
		seahorse_catalog_set_ui_name (self, g_value_get_string (value));
#line 23 "/data/src/seahorse/common/catalog.vala"
		break;
#line 2134 "catalog.c"
		default:
#line 23 "/data/src/seahorse/common/catalog.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/data/src/seahorse/common/catalog.vala"
		break;
#line 2140 "catalog.c"
	}
}



