/* pkcs11-request.c generated by valac 0.23.3.6-62e8, the Vala compiler
 * generated from pkcs11-request.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Red Hat Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Stef Walter <stefw@redhat.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-pkcs11.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gck/gck.h>
#include <gcr/gcr-base.h>
#include "libseahorse/seahorse-interaction.h"
#include <gio/gio.h>
#include "seahorse-common.h"
#include <glib/gi18n-lib.h>
#include "config.h"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

struct _SeahorsePkcs11RequestPrivate {
	SeahorsePkcs11PrivateKey* _private_key;
	GtkEntry* _name_entry;
	guint8* _encoded;
	gint _encoded_length1;
	gint __encoded_size_;
};

struct _Block3Data {
	int _ref_count_;
	SeahorsePkcs11Request* self;
	GcrCertificateRequest* req;
};

struct _Block4Data {
	int _ref_count_;
	SeahorsePkcs11Request* self;
	GtkWindow* parent;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GFile* file;
};


static gpointer seahorse_pkcs11_request_parent_class = NULL;
static gchar* seahorse_pkcs11_request_BAD_FILENAME_CHARS;
static gchar* seahorse_pkcs11_request_BAD_FILENAME_CHARS = NULL;

#define SEAHORSE_PKCS11_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11RequestPrivate))
enum  {
	SEAHORSE_PKCS11_REQUEST_DUMMY_PROPERTY,
	SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY
};
static void seahorse_pkcs11_request_real_response (GtkDialog* base, gint response_id);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda4_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void seahorse_pkcs11_request_save_certificate_request (SeahorsePkcs11Request* self, GcrCertificateRequest* req, GtkWindow* parent);
static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_pkcs11_request_update_response (SeahorsePkcs11Request* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda5_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
static void ____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GObject * seahorse_pkcs11_request_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_pkcs11_request___lambda6_ (SeahorsePkcs11Request* self);
static void __seahorse_pkcs11_request___lambda6__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void seahorse_pkcs11_request_finalize (GObject* obj);
static void _vala_seahorse_pkcs11_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_pkcs11_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void seahorse_pkcs11_request_prompt (GtkWindow* parent, GckObject* private_key) {
	SeahorsePkcs11Request* dialog = NULL;
	GtkWindow* _tmp0_ = NULL;
	GckObject* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
#line 64 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (private_key != NULL);
#line 66 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = parent;
#line 66 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp1_ = private_key;
#line 66 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp2_ = g_object_new (SEAHORSE_PKCS11_TYPE_REQUEST, "transient-for", _tmp0_, "private-key", _tmp1_, NULL);
#line 66 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp3_ = G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_;
#line 66 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	dialog = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
#line 68 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 66 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (dialog);
#line 130 "pkcs11-request.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return _data3_;
#line 139 "pkcs11-request.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 148 "pkcs11-request.c"
		SeahorsePkcs11Request* self;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self = _data3_->self;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (_data3_->req);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (self);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_slice_free (Block3Data, _data3_);
#line 158 "pkcs11-request.c"
	}
}


static void ___lambda4_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	SeahorsePkcs11Request* self;
	GError * _inner_error_ = NULL;
#line 80 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self = _data3_->self;
#line 80 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (res != NULL);
#line 170 "pkcs11-request.c"
	{
		GcrCertificateRequest* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GcrCertificateRequest* _tmp2_ = NULL;
		GtkWindow* _tmp3_ = NULL;
		GtkWindow* _tmp4_ = NULL;
#line 82 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp0_ = _data3_->req;
#line 82 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp1_ = res;
#line 82 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		gcr_certificate_request_complete_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 82 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		if (_inner_error_ != NULL) {
#line 185 "pkcs11-request.c"
			goto __catch5_g_error;
		}
#line 83 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp2_ = _data3_->req;
#line 83 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp3_ = gtk_window_get_transient_for ((GtkWindow*) self);
#line 83 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp4_ = _tmp3_;
#line 83 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		seahorse_pkcs11_request_save_certificate_request (self, _tmp2_, _tmp4_);
#line 196 "pkcs11-request.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp5_ = NULL;
		GtkWindow* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		err = _inner_error_;
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_inner_error_ = NULL;
#line 85 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp5_ = gtk_window_get_transient_for ((GtkWindow*) self);
#line 85 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp6_ = _tmp5_;
#line 85 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp7_ = _ ("Couldn't create certificate request");
#line 85 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp8_ = err;
#line 85 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp9_ = _tmp8_->message;
#line 85 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		seahorse_util_show_error ((GtkWidget*) _tmp6_, _tmp7_, _tmp9_);
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_error_free0 (err);
#line 225 "pkcs11-request.c"
	}
	__finally5:
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_inner_error_ != NULL) {
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_clear_error (&_inner_error_);
#line 81 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		return;
#line 236 "pkcs11-request.c"
	}
}


static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 80 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	___lambda4_ (self, source_object, res);
#line 80 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	block3_data_unref (self);
#line 246 "pkcs11-request.c"
}


static void seahorse_pkcs11_request_real_response (GtkDialog* base, gint response_id) {
	SeahorsePkcs11Request * self;
	gint _tmp0_ = 0;
#line 71 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self = (SeahorsePkcs11Request*) base;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = response_id;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 259 "pkcs11-request.c"
		Block3Data* _data3_;
		SeahorseInteraction* interaction = NULL;
		GtkWindow* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		SeahorseInteraction* _tmp3_ = NULL;
		GckSession* session = NULL;
		SeahorsePkcs11PrivateKey* _tmp4_ = NULL;
		GckSession* _tmp5_ = NULL;
		GckSession* _tmp6_ = NULL;
		SeahorseInteraction* _tmp7_ = NULL;
		SeahorsePkcs11PrivateKey* _tmp8_ = NULL;
		GcrCertificateRequest* _tmp9_ = NULL;
		GcrCertificateRequest* _tmp10_ = NULL;
		GtkEntry* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GcrCertificateRequest* _tmp13_ = NULL;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data3_ = g_slice_new0 (Block3Data);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data3_->_ref_count_ = 1;
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data3_->self = g_object_ref (self);
#line 73 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp1_ = gtk_window_get_transient_for ((GtkWindow*) self);
#line 73 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp2_ = _tmp1_;
#line 73 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp3_ = seahorse_interaction_new (_tmp2_);
#line 73 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		interaction = _tmp3_;
#line 74 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp4_ = self->priv->_private_key;
#line 74 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp5_ = gck_object_get_session ((GckObject*) _tmp4_);
#line 74 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		session = _tmp5_;
#line 75 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp6_ = session;
#line 75 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp7_ = interaction;
#line 75 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		gck_session_set_interaction (_tmp6_, (GTlsInteraction*) _tmp7_);
#line 77 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp8_ = self->priv->_private_key;
#line 77 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp9_ = gcr_certificate_request_prepare (GCR_CERTIFICATE_REQUEST_PKCS10, (GckObject*) _tmp8_);
#line 77 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data3_->req = _tmp9_;
#line 79 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp10_ = _data3_->req;
#line 79 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp11_ = self->priv->_name_entry;
#line 79 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp12_ = gtk_entry_get_text (_tmp11_);
#line 79 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		gcr_certificate_request_set_cn (_tmp10_, _tmp12_);
#line 80 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp13_ = _data3_->req;
#line 80 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		gcr_certificate_request_complete_async (_tmp13_, NULL, ____lambda4__gasync_ready_callback, block3_data_ref (_data3_));
#line 89 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		gtk_widget_hide ((GtkWidget*) self);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (session);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (interaction);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		block3_data_unref (_data3_);
#line 72 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data3_ = NULL;
#line 330 "pkcs11-request.c"
	}
}


static void seahorse_pkcs11_request_update_response (SeahorsePkcs11Request* self) {
	gchar* name = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 93 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (self != NULL);
#line 94 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = self->priv->_name_entry;
#line 94 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 94 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 94 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	name = _tmp2_;
#line 95 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, g_strcmp0 (name, "") != 0);
#line 93 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_free0 (name);
#line 354 "pkcs11-request.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return self ? g_object_ref (self) : NULL;
#line 361 "pkcs11-request.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return _data4_;
#line 370 "pkcs11-request.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 379 "pkcs11-request.c"
		SeahorsePkcs11Request* self;
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self = _data4_->self;
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (_data4_->parent);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (self);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_slice_free (Block4Data, _data4_);
#line 389 "pkcs11-request.c"
	}
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
#line 1123 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1123 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (delimiters != NULL, NULL);
#line 1124 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1124 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1125 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1125 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = delimiters;
#line 1125 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = new_delimiter;
#line 1125 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
#line 1126 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _result_;
#line 1126 "/opt/build/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 421 "pkcs11-request.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return _data5_;
#line 430 "pkcs11-request.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 439 "pkcs11-request.c"
		SeahorsePkcs11Request* self;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self = _data5_->_data4_->self;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (_data5_->file);
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		block4_data_unref (_data5_->_data4_);
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data5_->_data4_ = NULL;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_slice_free (Block5Data, _data5_);
#line 451 "pkcs11-request.c"
	}
}


static void ___lambda5_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	Block4Data* _data4_;
	SeahorsePkcs11Request* self;
	GError * _inner_error_ = NULL;
#line 142 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_data4_ = _data5_->_data4_;
#line 142 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self = _data4_->self;
#line 142 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (res != NULL);
#line 466 "pkcs11-request.c"
	{
		gchar* new_etag = NULL;
		GFile* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp0_ = _data5_->file;
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp1_ = res;
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_file_replace_contents_finish (_tmp0_, _tmp1_, &_tmp2_, &_inner_error_);
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_free0 (new_etag);
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		new_etag = _tmp2_;
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		if (_inner_error_ != NULL) {
#line 145 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
			_g_free0 (new_etag);
#line 486 "pkcs11-request.c"
			goto __catch6_g_error;
		}
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_free0 (new_etag);
#line 491 "pkcs11-request.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		err = _inner_error_;
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_inner_error_ = NULL;
#line 147 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp3_ = _data4_->parent;
#line 147 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp4_ = _ ("Couldn't save certificate request");
#line 147 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp5_ = err;
#line 147 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp6_ = _tmp5_->message;
#line 147 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		seahorse_util_show_error ((GtkWidget*) _tmp3_, _tmp4_, _tmp6_);
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_error_free0 (err);
#line 517 "pkcs11-request.c"
	}
	__finally6:
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_inner_error_ != NULL) {
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_clear_error (&_inner_error_);
#line 143 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		return;
#line 528 "pkcs11-request.c"
	}
}


static void ____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 140 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	___lambda5_ (self, source_object, res);
#line 140 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	block5_data_unref (self);
#line 538 "pkcs11-request.c"
}


static void seahorse_pkcs11_request_save_certificate_request (SeahorsePkcs11Request* self, GcrCertificateRequest* req, GtkWindow* parent) {
	Block4Data* _data4_;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkFileChooserDialog* chooser = NULL;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkFileFilter* der_filter = NULL;
	GtkFileFilter* _tmp7_ = NULL;
	GtkFileFilter* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkFileFilter* _tmp10_ = NULL;
	GtkFileFilter* _tmp11_ = NULL;
	GtkFileFilter* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileFilter* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_ = NULL;
	GtkFileChooserDialog* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileFilter* pem_filter = NULL;
	GtkFileFilter* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	GtkFileChooserDialog* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	gchar* label = NULL;
	SeahorsePkcs11PrivateKey* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GtkFileChooserDialog* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkFileChooserDialog* _tmp38_ = NULL;
	gint response = 0;
	GtkFileChooserDialog* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	GtkFileChooserDialog* _tmp54_ = NULL;
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (self != NULL);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (req != NULL);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_data4_->_ref_count_ = 1;
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_data4_->self = g_object_ref (self);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = parent;
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (_data4_->parent);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_data4_->parent = _tmp1_;
#line 102 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp2_ = _ ("Save certificate request");
#line 102 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp3_ = _data4_->parent;
#line 102 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
#line 102 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_object_ref_sink (_tmp4_);
#line 102 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	chooser = _tmp4_;
#line 107 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp5_ = chooser;
#line 107 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_dialog_set_default_response ((GtkDialog*) _tmp5_, (gint) GTK_RESPONSE_ACCEPT);
#line 108 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp6_ = chooser;
#line 108 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp6_, FALSE);
#line 110 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp7_ = gtk_file_filter_new ();
#line 110 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_object_ref_sink (_tmp7_);
#line 110 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	der_filter = _tmp7_;
#line 111 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp8_ = der_filter;
#line 111 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp9_ = _ ("Certificate request");
#line 111 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_buildable_set_name ((GtkBuildable*) _tmp8_, _tmp9_);
#line 112 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp10_ = der_filter;
#line 112 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_filter_add_mime_type (_tmp10_, "application/pkcs10");
#line 113 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp11_ = der_filter;
#line 113 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_filter_add_pattern (_tmp11_, "*.p10");
#line 114 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp12_ = der_filter;
#line 114 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_filter_add_pattern (_tmp12_, "*.csr");
#line 115 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp13_ = chooser;
#line 115 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp14_ = der_filter;
#line 115 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 115 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp13_, _tmp15_);
#line 116 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp16_ = chooser;
#line 116 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp17_ = der_filter;
#line 116 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp16_, _tmp17_);
#line 118 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp18_ = gtk_file_filter_new ();
#line 118 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_object_ref_sink (_tmp18_);
#line 118 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	pem_filter = _tmp18_;
#line 119 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp19_ = pem_filter;
#line 119 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp20_ = _ ("PEM encoded request");
#line 119 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_buildable_set_name ((GtkBuildable*) _tmp19_, _tmp20_);
#line 120 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp21_ = pem_filter;
#line 120 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_filter_add_mime_type (_tmp21_, "application/pkcs10+pem");
#line 121 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp22_ = pem_filter;
#line 121 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_filter_add_pattern (_tmp22_, "*.pem");
#line 122 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp23_ = chooser;
#line 122 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp24_ = pem_filter;
#line 122 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 122 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp23_, _tmp25_);
#line 125 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp26_ = self->priv->_private_key;
#line 125 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_object_get ((GObject*) _tmp26_, "label", &label, NULL);
#line 126 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp28_ = label;
#line 126 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_tmp28_ == NULL) {
#line 126 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp27_ = TRUE;
#line 703 "pkcs11-request.c"
	} else {
		const gchar* _tmp29_ = NULL;
#line 126 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp29_ = label;
#line 126 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp27_ = g_strcmp0 (_tmp29_, "") == 0;
#line 710 "pkcs11-request.c"
	}
#line 126 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_tmp27_) {
#line 714 "pkcs11-request.c"
		gchar* _tmp30_ = NULL;
#line 127 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp30_ = g_strdup ("Certificate Request");
#line 127 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_free0 (label);
#line 127 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		label = _tmp30_;
#line 722 "pkcs11-request.c"
	}
#line 128 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp31_ = label;
#line 128 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp32_ = g_strconcat (_tmp31_, ".csr", NULL);
#line 128 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	filename = _tmp32_;
#line 129 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp33_ = filename;
#line 129 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp34_ = seahorse_pkcs11_request_BAD_FILENAME_CHARS;
#line 129 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp35_ = string_delimit (_tmp33_, _tmp34_, '_');
#line 129 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_free0 (filename);
#line 129 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	filename = _tmp35_;
#line 130 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp36_ = chooser;
#line 130 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp37_ = filename;
#line 130 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp36_, _tmp37_);
#line 132 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp38_ = chooser;
#line 132 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp38_, TRUE);
#line 134 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp39_ = chooser;
#line 134 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp40_ = gtk_dialog_run ((GtkDialog*) _tmp39_);
#line 134 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	response = _tmp40_;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp41_ = response;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_tmp41_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 760 "pkcs11-request.c"
		Block5Data* _data5_;
		gboolean textual = FALSE;
		GtkFileChooserDialog* _tmp42_ = NULL;
		GtkFileFilter* _tmp43_ = NULL;
		GtkFileFilter* _tmp44_ = NULL;
		GcrCertificateRequest* _tmp45_ = NULL;
		gboolean _tmp46_ = FALSE;
		gsize _tmp47_;
		guint8* _tmp48_ = NULL;
		GtkFileChooserDialog* _tmp49_ = NULL;
		GFile* _tmp50_ = NULL;
		GFile* _tmp51_ = NULL;
		GFile* _tmp52_ = NULL;
		guint8* _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data5_ = g_slice_new0 (Block5Data);
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data5_->_ref_count_ = 1;
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data5_->_data4_ = block4_data_ref (_data4_);
#line 136 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp42_ = chooser;
#line 136 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp43_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp42_);
#line 136 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp44_ = pem_filter;
#line 136 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		textual = _tmp43_ == _tmp44_;
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp45_ = req;
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp46_ = textual;
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp48_ = gcr_certificate_request_encode (_tmp45_, _tmp46_, &_tmp47_);
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self->priv->_encoded = (g_free (self->priv->_encoded), NULL);
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self->priv->_encoded = _tmp48_;
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self->priv->_encoded_length1 = _tmp47_;
#line 137 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		self->priv->__encoded_size_ = self->priv->_encoded_length1;
#line 139 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp49_ = chooser;
#line 139 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp50_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp49_);
#line 139 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp51_ = _g_object_ref0 (_tmp50_);
#line 139 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data5_->file = _tmp51_;
#line 140 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp52_ = _data5_->file;
#line 140 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp53_ = self->priv->_encoded;
#line 140 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp53__length1 = self->priv->_encoded_length1;
#line 140 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_file_replace_contents_async (_tmp52_, _tmp53_, (gsize) _tmp53__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, ____lambda5__gasync_ready_callback, block5_data_ref (_data5_));
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		block5_data_unref (_data5_);
#line 135 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_data5_ = NULL;
#line 824 "pkcs11-request.c"
	}
#line 152 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp54_ = chooser;
#line 152 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp54_);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_free0 (filename);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_free0 (label);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (pem_filter);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (der_filter);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (chooser);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	block4_data_unref (_data4_);
#line 100 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_data4_ = NULL;
#line 844 "pkcs11-request.c"
}


SeahorsePkcs11Request* seahorse_pkcs11_request_construct (GType object_type) {
	SeahorsePkcs11Request * self = NULL;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self = (SeahorsePkcs11Request*) g_object_new (object_type, NULL);
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return self;
#line 854 "pkcs11-request.c"
}


SeahorsePkcs11Request* seahorse_pkcs11_request_new (void) {
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return seahorse_pkcs11_request_construct (SEAHORSE_PKCS11_TYPE_REQUEST);
#line 861 "pkcs11-request.c"
}


SeahorsePkcs11PrivateKey* seahorse_pkcs11_request_get_private_key (SeahorsePkcs11Request* self) {
	SeahorsePkcs11PrivateKey* result;
	SeahorsePkcs11PrivateKey* _tmp0_ = NULL;
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = self->priv->_private_key;
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	result = _tmp0_;
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return result;
#line 876 "pkcs11-request.c"
}


static void seahorse_pkcs11_request_set_private_key (SeahorsePkcs11Request* self, SeahorsePkcs11PrivateKey* value) {
	SeahorsePkcs11PrivateKey* _tmp0_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp1_ = NULL;
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (self != NULL);
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = value;
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (self->priv->_private_key);
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self->priv->_private_key = _tmp1_;
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_object_notify ((GObject *) self, "private-key");
#line 895 "pkcs11-request.c"
}


static void _seahorse_pkcs11_request___lambda6_ (SeahorsePkcs11Request* self) {
#line 52 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	seahorse_pkcs11_request_update_response (self);
#line 902 "pkcs11-request.c"
}


static void __seahorse_pkcs11_request___lambda6__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 52 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_seahorse_pkcs11_request___lambda6_ ((SeahorsePkcs11Request*) self);
#line 909 "pkcs11-request.c"
}


static GObject * seahorse_pkcs11_request_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Request * self;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	gchar* path = NULL;
	gchar* _tmp1_ = NULL;
	GtkBox* content = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkWidget* widget = NULL;
	GtkBuilder* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkEntry* _tmp15_ = NULL;
	GtkEntry* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_request_parent_class);
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
#line 36 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = gtk_builder_new ();
#line 36 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	builder = _tmp0_;
#line 37 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp1_ = g_strdup (UIDIR "seahorse-pkcs11-request.xml");
#line 37 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	path = _tmp1_;
#line 952 "pkcs11-request.c"
	{
		GtkBuilder* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 39 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp2_ = builder;
#line 39 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp3_ = path;
#line 39 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		gtk_builder_add_from_file (_tmp2_, _tmp3_, &_inner_error_);
#line 39 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		if (_inner_error_ != NULL) {
#line 964 "pkcs11-request.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp4_ = NULL;
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		err = _inner_error_;
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_inner_error_ = NULL;
#line 41 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_tmp4_ = path;
#line 41 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_warning ("pkcs11-request.vala:41: couldn't load ui file: %s", _tmp4_);
#line 42 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_error_free0 (err);
#line 42 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_free0 (path);
#line 42 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (builder);
#line 42 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		return obj;
#line 989 "pkcs11-request.c"
	}
	__finally7:
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	if (_inner_error_ != NULL) {
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_free0 (path);
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		_g_object_unref0 (builder);
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 38 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_clear_error (&_inner_error_);
#line 1002 "pkcs11-request.c"
	}
#line 45 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 46 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp5_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
#line 46 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 46 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	content = _tmp6_;
#line 47 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp7_ = builder;
#line 47 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp8_ = gtk_builder_get_object (_tmp7_, "pkcs11-request");
#line 47 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_WIDGET, GtkWidget));
#line 47 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	widget = _tmp9_;
#line 48 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp10_ = content;
#line 48 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp11_ = widget;
#line 48 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_container_add ((GtkContainer*) _tmp10_, _tmp11_);
#line 49 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp12_ = widget;
#line 49 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_widget_show (_tmp12_);
#line 51 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp13_ = builder;
#line 51 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp14_ = gtk_builder_get_object (_tmp13_, "request-name");
#line 51 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GTK_TYPE_ENTRY, GtkEntry));
#line 51 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (self->priv->_name_entry);
#line 51 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self->priv->_name_entry = _tmp15_;
#line 52 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp16_ = self->priv->_name_entry;
#line 52 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_signal_connect_object ((GtkEditable*) _tmp16_, "changed", (GCallback) __seahorse_pkcs11_request___lambda6__gtk_editable_changed, self, 0);
#line 55 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp17_ = _ ("Create");
#line 55 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, _tmp17_, GTK_RESPONSE_OK, NULL);
#line 57 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
#line 59 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	seahorse_pkcs11_request_update_response (self);
#line 61 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp18_ = self->priv->_private_key;
#line 61 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gck_object_get_type ()));
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (widget);
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (content);
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_free0 (path);
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (builder);
#line 35 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	return obj;
#line 1066 "pkcs11-request.c"
}


static void seahorse_pkcs11_request_class_init (SeahorsePkcs11RequestClass * klass) {
	gchar* _tmp0_ = NULL;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	seahorse_pkcs11_request_parent_class = g_type_class_peek_parent (klass);
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_type_class_add_private (klass, sizeof (SeahorsePkcs11RequestPrivate));
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	GTK_DIALOG_CLASS (klass)->response = seahorse_pkcs11_request_real_response;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_request_get_property;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_request_set_property;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_request_constructor;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_request_finalize;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY, g_param_spec_object ("private-key", "private-key", "private-key", SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 98 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_tmp0_ = g_strdup ("/\\<>|?*");
#line 98 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	seahorse_pkcs11_request_BAD_FILENAME_CHARS = _tmp0_;
#line 1092 "pkcs11-request.c"
}


static void seahorse_pkcs11_request_instance_init (SeahorsePkcs11Request * self) {
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self->priv = SEAHORSE_PKCS11_REQUEST_GET_PRIVATE (self);
#line 1099 "pkcs11-request.c"
}


static void seahorse_pkcs11_request_finalize (GObject* obj) {
	SeahorsePkcs11Request * self;
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
#line 30 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (self->priv->_private_key);
#line 32 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	_g_object_unref0 (self->priv->_name_entry);
#line 33 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	self->priv->_encoded = (g_free (self->priv->_encoded), NULL);
#line 64 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	G_OBJECT_CLASS (seahorse_pkcs11_request_parent_class)->finalize (obj);
#line 1115 "pkcs11-request.c"
}


GType seahorse_pkcs11_request_get_type (void) {
	static volatile gsize seahorse_pkcs11_request_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_pkcs11_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Request), 0, (GInstanceInitFunc) seahorse_pkcs11_request_instance_init, NULL };
		GType seahorse_pkcs11_request_type_id;
		seahorse_pkcs11_request_type_id = g_type_register_static (GTK_TYPE_DIALOG, "SeahorsePkcs11Request", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_pkcs11_request_type_id__volatile, seahorse_pkcs11_request_type_id);
	}
	return seahorse_pkcs11_request_type_id__volatile;
}


static void _vala_seahorse_pkcs11_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorsePkcs11Request * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	switch (property_id) {
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		case SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY:
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		g_value_set_object (value, seahorse_pkcs11_request_get_private_key (self));
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		break;
#line 1142 "pkcs11-request.c"
		default:
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		break;
#line 1148 "pkcs11-request.c"
	}
}


static void _vala_seahorse_pkcs11_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorsePkcs11Request * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_REQUEST, SeahorsePkcs11Request);
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
	switch (property_id) {
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		case SEAHORSE_PKCS11_REQUEST_PRIVATE_KEY:
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		seahorse_pkcs11_request_set_private_key (self, g_value_get_object (value));
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		break;
#line 1164 "pkcs11-request.c"
		default:
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/data/src/seahorse/pkcs11/pkcs11-request.vala"
		break;
#line 1170 "pkcs11-request.c"
	}
}



