%define pygtk2_version 2.5.3-2
%define gnome_python2_version 2.6.0-5

%define pyver %(python -c 'import sys ; print sys.version[:3]')
%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_pytho\n_lib()")}

Name:    sabayon
Version: 0.17
Release: 1
Summary: Tool to maintain user profiles in a GNOME desktop

Group:   Applications/System
License: GPL
URL:     http://www.gnome.org/projects/sabayon
Source:  http://ftp.gnome.org/pub/GNOME/sources/sabayon/%{version}/sabayon-%{version}.tar.bz2

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch: noarch

Requires: python-abi = %{pyver}
Requires: gamin-python
Requires: libxml2-python
Requires: pygtk2 >= %{pygtk2_version}
Requires: gnome-python2-gconf >= %{gnome_python2_version}

BuildRequires: python
BuildRequires: gettext
BuildRequires: desktop-file-utils
BuildRequires: usermode

Requires(post):  shadow-utils
Requires(preun): shadow-utils

%description
Sabayon is a tool to help sysadmins and user change and maintain the
default behaviour of the GNOME desktop.

%package  admin
Summary:  Graphical tools for Sabayon profile management
Group:    Applications/System
Requires: %{name} = %{version}-%{release}

Requires: xorg-x11-Xnest
Requires: shadow-utils

%description admin
The sabayon-admin package contains the graphical tools which a
sysadmin should use to manage Sabayon profiles.

%prep
%setup -q

%build
%configure					\
	--enable-consolehelper=yes		\
	 --with-prototype-user=%{name}-admin
make %{?_smp_mflags}
gzip -9 ChangeLog

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall PAM_PREFIX=$RPM_BUILD_ROOT%{_sysconfdir}

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/gconf/2
echo 'include "$(HOME)/.gconf.path.defaults"'  > $RPM_BUILD_ROOT%{_sysconfdir}/gconf/2/local-defaults.path
echo 'include "$(HOME)/.gconf.path.mandatory"' > $RPM_BUILD_ROOT%{_sysconfdir}/gconf/2/local-mandatory.path

desktop-file-install --vendor gnome --delete-original		\
  --dir $RPM_BUILD_ROOT%{_datadir}/applications			\
  --add-category X-Fedora-Extra					\
  $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop

%find_lang sabayon

%clean
rm -rf $RPM_BUILD_ROOT

%pre admin
/usr/sbin/groupadd -r %{name}-admin &>/dev/null || :
/usr/sbin/useradd  -r -s /sbin/nologin -c "Sabayon user" -g %{name}-admin %{name}-admin &>/dev/null || :
/usr/sbin/usermod -d "" %{name}-admin &>/dev/null || :

%postun admin
if [ $1 -eq 0 ]; then
  /usr/sbin/userdel  %{name}-admin &>/dev/null || :
  /usr/sbin/groupdel %{name}-admin &>/dev/null || :
fi

%files -f sabayon.lang
%defattr(-, root, root, 755)

%doc AUTHORS ChangeLog.gz NEWS README TODO ISSUES

%config(noreplace) %{_sysconfdir}/gconf/2/local-defaults.path
%config(noreplace) %{_sysconfdir}/gconf/2/local-mandatory.path
%config(noreplace) %{_sysconfdir}/X11/xinit/xinitrc.d/%{name}*

%{_sysconfdir}/desktop-profiles

%{_sbindir}/%{name}-apply

%{python_sitelib}/%{name}/__init__.py
%{python_sitelib}/%{name}/__init__.pyc
%ghost %{python_sitelib}/%{name}/__init__.pyo
%{python_sitelib}/%{name}/config.py
%{python_sitelib}/%{name}/config.pyc
%ghost %{python_sitelib}/%{name}/config.pyo
%{python_sitelib}/%{name}/dirmonitor.py
%{python_sitelib}/%{name}/dirmonitor.pyc
%ghost %{python_sitelib}/%{name}/dirmonitor.pyo
%{python_sitelib}/%{name}/storage.py
%{python_sitelib}/%{name}/storage.pyc
%ghost %{python_sitelib}/%{name}/storage.pyo
%{python_sitelib}/%{name}/userdb.py
%{python_sitelib}/%{name}/userdb.pyc
%ghost %{python_sitelib}/%{name}/userdb.pyo
%{python_sitelib}/%{name}/userprofile.py
%{python_sitelib}/%{name}/userprofile.pyc
%ghost %{python_sitelib}/%{name}/userprofile.pyo
%{python_sitelib}/%{name}/util.py
%{python_sitelib}/%{name}/util.pyc
%ghost %{python_sitelib}/%{name}/util.pyo

%{python_sitelib}/%{name}/sources/*.py
%{python_sitelib}/%{name}/sources/*.pyc
%ghost %{python_sitelib}/%{name}/sources/*.pyo

%files admin
%doc doc/index.html doc/testing.html doc/helping.html doc/developing.html
%doc doc/sabayon.css doc/*.jpg doc/*.gif

%config(noreplace) %{_sysconfdir}/pam.d/%{name}
%config(noreplace) %{_sysconfdir}/security/console.apps/%{name}

%{_bindir}/%{name}
%{_sbindir}/%{name}
%{_libexecdir}/%{name}*

%{_datadir}/%{name}/glade/%{name}.glade
%{_datadir}/applications/gnome-%{name}.desktop
%{_datadir}/pixmaps/%{name}.png

%{python_sitelib}/%{name}/aboutdialog.py
%{python_sitelib}/%{name}/aboutdialog.pyc
%ghost %{python_sitelib}/%{name}/aboutdialog.pyo
%{python_sitelib}/%{name}/editorwindow.py
%{python_sitelib}/%{name}/editorwindow.pyc
%ghost %{python_sitelib}/%{name}/editorwindow.pyo
%{python_sitelib}/%{name}/fileviewer.py
%{python_sitelib}/%{name}/fileviewer.pyc
%ghost %{python_sitelib}/%{name}/fileviewer.pyo
%{python_sitelib}/%{name}/gconfviewer.py
%{python_sitelib}/%{name}/gconfviewer.pyc
%ghost %{python_sitelib}/%{name}/gconfviewer.pyo
%{python_sitelib}/%{name}/monitorwindow.py
%{python_sitelib}/%{name}/monitorwindow.pyc
%ghost %{python_sitelib}/%{name}/monitorwindow.pyo
%{python_sitelib}/%{name}/profilesdialog.py
%{python_sitelib}/%{name}/profilesdialog.pyc
%ghost %{python_sitelib}/%{name}/profilesdialog.pyo
%{python_sitelib}/%{name}/protosession.py
%{python_sitelib}/%{name}/protosession.pyc
%ghost %{python_sitelib}/%{name}/protosession.pyo
%{python_sitelib}/%{name}/saveconfirm.py
%{python_sitelib}/%{name}/saveconfirm.pyc
%ghost %{python_sitelib}/%{name}/saveconfirm.pyo
%{python_sitelib}/%{name}/usermod.py
%{python_sitelib}/%{name}/usermod.pyc
%ghost %{python_sitelib}/%{name}/usermod.pyo
%{python_sitelib}/%{name}/userswindow.py
%{python_sitelib}/%{name}/userswindow.pyc
%ghost %{python_sitelib}/%{name}/userswindow.pyo

%changelog
* Thu Mar 24 2005 Mark McLoughlin <markmc@redhat.com> - 0.17-1
- Update to 0.17
- Pass --with-prototype-user=sabayon-admin to configure

* Mon Mar 21 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-8
- Add BuildRequires: usermode and pass --enable-consolehelper=yes
  to configure

* Mon Mar 21 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-7
- Move Xnest and shadow-utils requires to sabayon-admin
- Require libxml2-python

* Mon Mar 21 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-6
- Make noarch

* Mon Mar 21 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-5
- Add dirmonitor.py to base package

* Sun Mar 20 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-4
- Split the package into sabayon and sabayon-admin
- BuildRequires: gettext instead of gettext-devel

* Sat Mar 19 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-3
- Remove period at the end of the summary
- Specify full URL for source
- BuildRequires: python 
- Use %{_sysconfdir} everywhere
- Set the directory mode

* Fri Mar 18 2005 Mark McLoughlin <markmc@redhat.com> - 0.16-2
- BuildRequires: gettext-devel
- Add X-Fedora-Extra to .desktop file

* Wed Mar 16 2005 Mark McLoughlin <markmc@redhat.com>
- Various changes to bring in line with Fedora package guidelines

* Wed Feb  9 2005 Daniel Veillard <veillard@redhat.com>
- initial version
