/* rygel-mediathek-video-item-factory.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-mediathek-video-item-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY (rygel_mediathek_video_item_factory_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactory))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))

typedef struct _RygelMediathekVideoItemFactory RygelMediathekVideoItemFactory;
typedef struct _RygelMediathekVideoItemFactoryClass RygelMediathekVideoItemFactoryClass;
typedef struct _RygelMediathekVideoItemFactoryPrivate RygelMediathekVideoItemFactoryPrivate;

#define RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER (rygel_mediathek_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParser))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_PLAYLIST_PARSER, RygelMediathekPlaylistParserClass))

typedef struct _RygelMediathekPlaylistParser RygelMediathekPlaylistParser;
typedef struct _RygelMediathekPlaylistParserClass RygelMediathekPlaylistParserClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediathekVideoItemFactoryCreateData RygelMediathekVideoItemFactoryCreateData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER (rygel_mediathek_asx_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParser))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST_PARSER, RygelMediathekAsxPlaylistParserClass))

typedef struct _RygelMediathekAsxPlaylistParser RygelMediathekAsxPlaylistParser;
typedef struct _RygelMediathekAsxPlaylistParserClass RygelMediathekAsxPlaylistParserClass;

#define RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER (rygel_mediathek_mov_playlist_parser_get_type ())
#define RYGEL_MEDIATHEK_MOV_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER, RygelMediathekMovPlaylistParser))
#define RYGEL_MEDIATHEK_MOV_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER, RygelMediathekMovPlaylistParserClass))
#define RYGEL_MEDIATHEK_IS_MOV_PLAYLIST_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_IS_MOV_PLAYLIST_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER))
#define RYGEL_MEDIATHEK_MOV_PLAYLIST_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_MOV_PLAYLIST_PARSER, RygelMediathekMovPlaylistParserClass))

typedef struct _RygelMediathekMovPlaylistParser RygelMediathekMovPlaylistParser;
typedef struct _RygelMediathekMovPlaylistParserClass RygelMediathekMovPlaylistParserClass;

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR,
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekVideoItemFactory {
	GObject parent_instance;
	RygelMediathekVideoItemFactoryPrivate * priv;
};

struct _RygelMediathekVideoItemFactoryClass {
	GObjectClass parent_class;
};

struct _RygelMediathekVideoItemFactoryPrivate {
	RygelMediathekPlaylistParser* playlist_parser;
};

struct _RygelMediathekVideoItemFactoryCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekVideoItemFactory* self;
	RygelMediaContainer* parent;
	xmlNode* xml_item;
	RygelVideoItem* result;
	gchar* title;
	gchar* playlist_url;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeList* _tmp2_;
	GeeList* resolved_uris;
	gboolean _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* id;
	RygelVideoItem* _tmp6_;
	RygelVideoItem* item;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GeeList* _tmp12_;
	GeeList* _uri_list;
	gint _tmp13_;
	gint _uri_size;
	gint _uri_index;
	gpointer _tmp14_;
	gchar* uri;
	GError * _inner_error_;
};


static gpointer rygel_mediathek_video_item_factory_parent_class = NULL;
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_instance;
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_instance = NULL;

GQuark rygel_mediathek_video_item_error_quark (void);
GType rygel_mediathek_video_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_mediathek_playlist_parser_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryPrivate))
enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_DUMMY_PROPERTY
};
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV "wmv"
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_MP4 "mp4"
RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_get_default (void);
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_new (void);
static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_construct (GType object_type);
static void rygel_mediathek_video_item_factory_create_data_free (gpointer _data);
void rygel_mediathek_video_item_factory_create (RygelMediathekVideoItemFactory* self, RygelMediaContainer* parent, xmlNode* xml_item, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelVideoItem* rygel_mediathek_video_item_factory_create_finish (RygelMediathekVideoItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_mediathek_video_item_factory_create_co (RygelMediathekVideoItemFactoryCreateData* data);
static void rygel_mediathek_video_item_factory_extract_data_from_xml (RygelMediathekVideoItemFactory* self, xmlNode* item, gchar** title, gchar** playlist_url, GError** error);
void rygel_mediathek_playlist_parser_parse (RygelMediathekPlaylistParser* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* rygel_mediathek_playlist_parser_parse_finish (RygelMediathekPlaylistParser* self, GAsyncResult* _res_, GError** error);
static void rygel_mediathek_video_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_mediathek_playlist_parser_get_mime_type (RygelMediathekPlaylistParser* self);
SoupSessionAsync* rygel_mediathek_root_container_get_default_session (void);
RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_new (SoupSession* session);
RygelMediathekAsxPlaylistParser* rygel_mediathek_asx_playlist_parser_construct (GType object_type, SoupSession* session);
GType rygel_mediathek_asx_playlist_parser_get_type (void) G_GNUC_CONST;
RygelMediathekMovPlaylistParser* rygel_mediathek_mov_playlist_parser_new (SoupSession* session);
RygelMediathekMovPlaylistParser* rygel_mediathek_mov_playlist_parser_construct (GType object_type, SoupSession* session);
GType rygel_mediathek_mov_playlist_parser_get_type (void) G_GNUC_CONST;
static gboolean rygel_mediathek_video_item_factory_namespace_ok (RygelMediathekVideoItemFactory* self, xmlNode* node);
const gchar* rygel_mediathek_playlist_parser_get_playlist_suffix (RygelMediathekPlaylistParser* self);
static void rygel_mediathek_video_item_factory_finalize (GObject* obj);


GQuark rygel_mediathek_video_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_mediathek_video_item_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_get_default (void) {
	RygelMediathekVideoItemFactory* result = NULL;
	RygelMediathekVideoItemFactory* _tmp2_;
	if (rygel_mediathek_video_item_factory_instance == NULL) {
		RygelMediathekVideoItemFactory* _tmp0_ = NULL;
		RygelMediathekVideoItemFactory* _tmp1_;
		_tmp0_ = rygel_mediathek_video_item_factory_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (rygel_mediathek_video_item_factory_instance);
		rygel_mediathek_video_item_factory_instance = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_mediathek_video_item_factory_instance);
	result = _tmp2_;
	return result;
}


static void rygel_mediathek_video_item_factory_create_data_free (gpointer _data) {
	RygelMediathekVideoItemFactoryCreateData* data;
	data = _data;
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediathekVideoItemFactoryCreateData, data);
}


void rygel_mediathek_video_item_factory_create (RygelMediathekVideoItemFactory* self, RygelMediaContainer* parent, xmlNode* xml_item, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekVideoItemFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelMediathekVideoItemFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_video_item_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_video_item_factory_create_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->parent = _g_object_ref0 (parent);
	_data_->xml_item = xml_item;
	rygel_mediathek_video_item_factory_create_co (_data_);
}


RygelVideoItem* rygel_mediathek_video_item_factory_create_finish (RygelMediathekVideoItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelVideoItem* result;
	RygelMediathekVideoItemFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_mediathek_video_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediathekVideoItemFactoryCreateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_mediathek_video_item_factory_create_co (data);
}


static gboolean rygel_mediathek_video_item_factory_create_co (RygelMediathekVideoItemFactoryCreateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp1_ = NULL;
	rygel_mediathek_video_item_factory_extract_data_from_xml (data->self, data->xml_item, &data->_tmp0_, &data->_tmp1_, &data->_inner_error_);
	_g_free0 (data->title);
	data->title = data->_tmp0_;
	_g_free0 (data->playlist_url);
	data->playlist_url = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->playlist_url);
			_g_free0 (data->title);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->playlist_url);
			_g_free0 (data->title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 1;
	rygel_mediathek_playlist_parser_parse (data->self->priv->playlist_parser, data->playlist_url, rygel_mediathek_video_item_factory_create_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = rygel_mediathek_playlist_parser_parse_finish (data->self->priv->playlist_parser, data->_res_, &data->_inner_error_);
	data->resolved_uris = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->playlist_url);
			_g_free0 (data->title);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->playlist_url);
			_g_free0 (data->title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->resolved_uris == NULL) {
		data->_tmp3_ = TRUE;
	} else {
		data->_tmp4_ = gee_collection_get_size ((GeeCollection*) data->resolved_uris);
		data->_tmp3_ = data->_tmp4_ == 0;
	}
	if (data->_tmp3_) {
		data->result = NULL;
		_g_object_unref0 (data->resolved_uris);
		_g_free0 (data->playlist_url);
		_g_free0 (data->title);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, data->title, (gsize) (-1));
	data->id = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = rygel_video_item_new (data->id, data->parent, data->title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
	data->item = data->_tmp6_;
	data->_tmp7_ = NULL;
	data->_tmp7_ = rygel_mediathek_playlist_parser_get_mime_type (data->self->priv->playlist_parser);
	data->_tmp8_ = g_strdup (data->_tmp7_);
	data->_tmp9_ = data->_tmp8_;
	_g_free0 (((RygelMediaItem*) data->item)->mime_type);
	((RygelMediaItem*) data->item)->mime_type = data->_tmp9_;
	data->_tmp10_ = g_strdup ("ZDF - Second German TV Channel Streams");
	data->_tmp11_ = data->_tmp10_;
	_g_free0 (data->item->author);
	data->item->author = data->_tmp11_;
	{
		data->_tmp12_ = _g_object_ref0 (data->resolved_uris);
		data->_uri_list = data->_tmp12_;
		data->_tmp13_ = gee_collection_get_size ((GeeCollection*) data->_uri_list);
		data->_uri_size = data->_tmp13_;
		data->_uri_index = -1;
		while (TRUE) {
			data->_uri_index = data->_uri_index + 1;
			if (!(data->_uri_index < data->_uri_size)) {
				break;
			}
			data->_tmp14_ = NULL;
			data->_tmp14_ = gee_list_get (data->_uri_list, data->_uri_index);
			data->uri = (gchar*) data->_tmp14_;
			rygel_media_item_add_uri ((RygelMediaItem*) data->item, data->uri);
			_g_free0 (data->uri);
		}
		_g_object_unref0 (data->_uri_list);
	}
	data->result = data->item;
	_g_free0 (data->id);
	_g_object_unref0 (data->resolved_uris);
	_g_free0 (data->playlist_url);
	_g_free0 (data->title);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->item);
	_g_free0 (data->id);
	_g_object_unref0 (data->resolved_uris);
	_g_free0 (data->playlist_url);
	_g_free0 (data->title);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_construct (GType object_type) {
	RygelMediathekVideoItemFactory * self = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	gchar* _tmp1_;
	gchar* video_format;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	SoupSessionAsync* _tmp10_ = NULL;
	SoupSessionAsync* session;
	const gchar* _tmp11_;
	GQuark _tmp12_;
	GError * _inner_error_ = NULL;
	self = (RygelMediathekVideoItemFactory*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	_tmp1_ = g_strdup (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV);
	video_format = _tmp1_;
	_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) config, "ZDFMediathek", "video-format", &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) (-1));
	_tmp6_ = _tmp5_;
	_g_free0 (video_format);
	video_format = _tmp6_;
	_g_free0 (_tmp4_);
	if (g_strcmp0 (video_format, RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV) != 0) {
		_tmp7_ = g_strcmp0 (video_format, RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_MP4) != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = g_strdup (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV);
		_tmp9_ = _tmp8_;
		_g_free0 (video_format);
		video_format = _tmp9_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (video_format);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_debug ("rygel-mediathek-video-item-factory.vala:83: Exposing mediathek items i" \
"n format: %s", video_format);
	_tmp10_ = rygel_mediathek_root_container_get_default_session ();
	session = _tmp10_;
	_tmp11_ = video_format;
	_tmp12_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
	if (_tmp12_ == g_quark_from_string (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_WMV)) {
		switch (0) {
			default:
			{
				RygelMediathekAsxPlaylistParser* _tmp13_ = NULL;
				RygelMediathekPlaylistParser* _tmp14_;
				_tmp13_ = rygel_mediathek_asx_playlist_parser_new ((SoupSession*) session);
				_tmp14_ = (RygelMediathekPlaylistParser*) _tmp13_;
				_g_object_unref0 (self->priv->playlist_parser);
				self->priv->playlist_parser = _tmp14_;
				break;
			}
		}
	} else if (_tmp12_ == g_quark_from_string (RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_VIDEO_FORMAT_MP4)) {
		switch (0) {
			default:
			{
				RygelMediathekMovPlaylistParser* _tmp15_ = NULL;
				RygelMediathekPlaylistParser* _tmp16_;
				_tmp15_ = rygel_mediathek_mov_playlist_parser_new ((SoupSession*) session);
				_tmp16_ = (RygelMediathekPlaylistParser*) _tmp15_;
				_g_object_unref0 (self->priv->playlist_parser);
				self->priv->playlist_parser = _tmp16_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_g_object_unref0 (session);
	_g_free0 (video_format);
	_g_object_unref0 (config);
	return self;
}


static RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_new (void) {
	return rygel_mediathek_video_item_factory_construct (RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY);
}


static gboolean rygel_mediathek_video_item_factory_namespace_ok (RygelMediathekVideoItemFactory* self, xmlNode* node) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (node->ns != NULL) {
		_tmp0_ = g_strcmp0 (node->ns->prefix, "media") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void rygel_mediathek_video_item_factory_extract_data_from_xml (RygelMediathekVideoItemFactory* self, xmlNode* item, gchar** title, gchar** playlist_url, GError** error) {
	gchar* _title = NULL;
	gchar* _playlist_url = NULL;
	xmlNode* _tmp0_ = NULL;
	xmlNode* title_node;
	xmlNode* _tmp1_ = NULL;
	xmlNode* group;
	gboolean _tmp4_;
	xmlNode* _tmp6_ = NULL;
	xmlNode* content;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_xml_utils_get_element (item, "title", NULL);
	title_node = _tmp0_;
	_tmp1_ = rygel_xml_utils_get_element (item, "group", NULL);
	group = _tmp1_;
	if (title_node == NULL) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No 'title' element");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (group == NULL) {
		GError* _tmp3_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No 'group' element");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = rygel_mediathek_video_item_factory_namespace_ok (self, group);
	if (!_tmp4_) {
		GError* _tmp5_ = NULL;
		_tmp5_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "Invalid namespace");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = rygel_xml_utils_get_element (group, "content", NULL);
	content = _tmp6_;
	if (content == NULL) {
		GError* _tmp7_ = NULL;
		_tmp7_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "'group' has no 'content' element");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		xmlAttr* _tmp8_ = NULL;
		xmlAttr* url_attribute;
		gboolean _tmp9_ = FALSE;
		if (!(content != NULL)) {
			break;
		}
		_tmp8_ = xmlHasProp (content, "url");
		url_attribute = _tmp8_;
		if (url_attribute != NULL) {
			gboolean _tmp10_;
			_tmp10_ = rygel_mediathek_video_item_factory_namespace_ok (self, content);
			_tmp9_ = _tmp10_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* url;
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_;
			url = url_attribute->children->content;
			_tmp11_ = rygel_mediathek_playlist_parser_get_playlist_suffix (self->priv->playlist_parser);
			_tmp12_ = g_str_has_suffix (url, _tmp11_);
			if (_tmp12_) {
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strdup (url);
				_tmp14_ = _tmp13_;
				_g_free0 (_playlist_url);
				_playlist_url = _tmp14_;
				break;
			}
		}
		content = content->next;
	}
	if (_playlist_url == NULL) {
		GError* _tmp15_ = NULL;
		_tmp15_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "No URL found");
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = xmlNodeGetContent (title_node);
	_tmp17_ = _tmp16_;
	_g_free0 (_title);
	_title = _tmp17_;
	if (title) {
		*title = _title;
	} else {
		_g_free0 (_title);
	}
	if (playlist_url) {
		*playlist_url = _playlist_url;
	} else {
		_g_free0 (_playlist_url);
	}
}


static void rygel_mediathek_video_item_factory_class_init (RygelMediathekVideoItemFactoryClass * klass) {
	rygel_mediathek_video_item_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediathekVideoItemFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_video_item_factory_finalize;
}


static void rygel_mediathek_video_item_factory_instance_init (RygelMediathekVideoItemFactory * self) {
	self->priv = RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_PRIVATE (self);
}


static void rygel_mediathek_video_item_factory_finalize (GObject* obj) {
	RygelMediathekVideoItemFactory * self;
	self = RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY (obj);
	_g_object_unref0 (self->priv->playlist_parser);
	G_OBJECT_CLASS (rygel_mediathek_video_item_factory_parent_class)->finalize (obj);
}


GType rygel_mediathek_video_item_factory_get_type (void) {
	static volatile gsize rygel_mediathek_video_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_video_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekVideoItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_video_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekVideoItemFactory), 0, (GInstanceInitFunc) rygel_mediathek_video_item_factory_instance_init, NULL };
		GType rygel_mediathek_video_item_factory_type_id;
		rygel_mediathek_video_item_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediathekVideoItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mediathek_video_item_factory_type_id__volatile, rygel_mediathek_video_item_factory_type_id);
	}
	return rygel_mediathek_video_item_factory_type_id__volatile;
}



