/* rygel-cmdline-config.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-cmdline-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <gst/gst.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;
typedef struct _RygelCmdlineConfigPrivate RygelCmdlineConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()
typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	char* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelCmdlineConfig {
	GObject parent_instance;
	RygelCmdlineConfigPrivate * priv;
};

struct _RygelCmdlineConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static char* rygel_cmdline_config_iface;
static char* rygel_cmdline_config_iface = NULL;
static gint rygel_cmdline_config_port;
static gint rygel_cmdline_config_port = 0;
static gboolean rygel_cmdline_config_no_transcoding;
static gboolean rygel_cmdline_config_no_transcoding = FALSE;
static gboolean rygel_cmdline_config_no_mp3_trans;
static gboolean rygel_cmdline_config_no_mp3_trans = FALSE;
static gboolean rygel_cmdline_config_no_mp2ts_trans;
static gboolean rygel_cmdline_config_no_mp2ts_trans = FALSE;
static gboolean rygel_cmdline_config_no_lpcm_trans;
static gboolean rygel_cmdline_config_no_lpcm_trans = FALSE;
static gboolean rygel_cmdline_config_no_wmv_trans;
static gboolean rygel_cmdline_config_no_wmv_trans = FALSE;
static RygelLogLevel rygel_cmdline_config_log_level;
static RygelLogLevel rygel_cmdline_config_log_level = RYGEL_LOG_LEVEL_INVALID;
static char* rygel_cmdline_config_plugin_path;
static char* rygel_cmdline_config_plugin_path = NULL;
static gboolean rygel_cmdline_config_version;
static gboolean rygel_cmdline_config_version = FALSE;
static char** rygel_cmdline_config_disabled_plugins;
static char** rygel_cmdline_config_disabled_plugins = NULL;
static char** rygel_cmdline_config_plugin_titles;
static char** rygel_cmdline_config_plugin_titles = NULL;
static char** rygel_cmdline_config_plugin_options;
static char** rygel_cmdline_config_plugin_options = NULL;
static RygelCmdlineConfig* rygel_cmdline_config_config;
static RygelCmdlineConfig* rygel_cmdline_config_config = NULL;
static gpointer rygel_cmdline_config_parent_class = NULL;
static RygelConfigurationIface* rygel_cmdline_config_rygel_configuration_parent_iface = NULL;

GQuark rygel_cmdline_config_error_quark (void);
GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CMDLINE_CONFIG_DUMMY_PROPERTY
};
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
RygelCmdlineConfig* rygel_cmdline_config_new (void);
RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type);
void rygel_cmdline_config_parse_args (char*** args, int* args_length1, GError** error);
static gboolean rygel_cmdline_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
GQuark rygel_configuration_error_quark (void);
static char* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error);
static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
static RygelLogLevel rygel_cmdline_config_real_get_log_level (RygelConfiguration* base, GError** error);
static char* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error);
static char* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const char* section, GError** error);
static char* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error);
static void rygel_cmdline_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry RYGEL_CMDLINE_CONFIG_options[14] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_version, "Display version number", NULL}, {"network-interface", 'n', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_iface, "Network Interface", "INTERFACE"}, {"port", 'p', 0, G_OPTION_ARG_INT, &rygel_cmdline_config_port, "Port", "PORT"}, {"disable-transcoding", 't', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_transcoding, "Disable transcoding", NULL}, {"disable-mp3-transcoder", 'm', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_mp3_trans, "Disable MP3 transcoder", NULL}, {"disable-mp2ts-transcoder", 's', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_mp2ts_trans, "Disable mpeg2 transport stream transcoder", NULL}, {"disable-lpcm-transcoder", 'l', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_lpcm_trans, "Disable Linear PCM transcoder", NULL}, {"disable-wmv-transcoder", 'l', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_wmv_trans, "Disable WMV transcoder", NULL}, {"log-level", 'g', 0, G_OPTION_ARG_INT, &rygel_cmdline_config_log_level, "Log level. 1=critical,2=error,3=warning,4=message/info,5=debug", "N"}, {"plugin-path", 'u', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_plugin_path, "Plugin Path", "PLUGIN_PATH"}, {"disable-plugin", 'd', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_disabled_plugins, "Disable plugin", "PluginName"}, {"title", 'i', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_titles, "Set plugin titles", "PluginName:TITLE"}, {"plugin-option", 'o', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_options, "Set plugin options", "PluginName:OPTION:VALUE1[,VALUE2,..]"}, {NULL}};


GQuark rygel_cmdline_config_error_quark (void) {
	return g_quark_from_static_string ("rygel_cmdline_config_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 97 "rygel-cmdline-config.vala"
RygelCmdlineConfig* rygel_cmdline_config_get_default (void) {
#line 195 "rygel-cmdline-config.c"
	RygelCmdlineConfig* result = NULL;
#line 98 "rygel-cmdline-config.vala"
	if (rygel_cmdline_config_config == NULL) {
#line 199 "rygel-cmdline-config.c"
		RygelCmdlineConfig* _tmp0_;
#line 99 "rygel-cmdline-config.vala"
		rygel_cmdline_config_config = (_tmp0_ = rygel_cmdline_config_new (), _g_object_unref0 (rygel_cmdline_config_config), _tmp0_);
#line 203 "rygel-cmdline-config.c"
	}
	result = _g_object_ref0 (rygel_cmdline_config_config);
#line 102 "rygel-cmdline-config.vala"
	return result;
#line 208 "rygel-cmdline-config.c"
}


#line 105 "rygel-cmdline-config.vala"
void rygel_cmdline_config_parse_args (char*** args, int* args_length1, GError** error) {
#line 214 "rygel-cmdline-config.c"
	char* parameter_string;
	GOptionContext* opt_context;
	GError * _inner_error_ = NULL;
#line 108 "rygel-cmdline-config.vala"
	parameter_string = g_strdup ("- " PACKAGE_NAME);
#line 109 "rygel-cmdline-config.vala"
	opt_context = g_option_context_new (parameter_string);
#line 110 "rygel-cmdline-config.vala"
	g_option_context_set_help_enabled (opt_context, TRUE);
#line 111 "rygel-cmdline-config.vala"
	g_option_context_add_main_entries (opt_context, RYGEL_CMDLINE_CONFIG_options, NULL);
#line 112 "rygel-cmdline-config.vala"
	g_option_context_add_group (opt_context, gst_init_get_option_group ());
#line 113 "rygel-cmdline-config.vala"
	g_option_context_parse (opt_context, args_length1, args, &_inner_error_);
#line 230 "rygel-cmdline-config.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			return;
		} else {
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 115 "rygel-cmdline-config.vala"
	if (rygel_cmdline_config_version) {
#line 116 "rygel-cmdline-config.vala"
		fprintf (stdout, "%s\n", PACKAGE_STRING);
#line 249 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
		{
			if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_option_context_free0 (opt_context);
				_g_free0 (parameter_string);
				return;
			} else {
				_g_option_context_free0 (opt_context);
				_g_free0 (parameter_string);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_option_context_free0 (opt_context);
	_g_free0 (parameter_string);
}


#line 122 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
#line 273 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	{
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	return result;
}


#line 126 "rygel-cmdline-config.vala"
static char* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error) {
#line 289 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 127 "rygel-cmdline-config.vala"
	if (rygel_cmdline_config_iface == NULL) {
#line 296 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	}
	result = g_strdup (rygel_cmdline_config_iface);
#line 131 "rygel-cmdline-config.vala"
	return result;
#line 306 "rygel-cmdline-config.c"
}


#line 134 "rygel-cmdline-config.vala"
static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error) {
#line 312 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gint result = 0;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 135 "rygel-cmdline-config.vala"
	if (rygel_cmdline_config_port <= 0) {
#line 319 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = rygel_cmdline_config_port;
#line 139 "rygel-cmdline-config.vala"
	return result;
#line 329 "rygel-cmdline-config.c"
}


#line 142 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
#line 335 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 143 "rygel-cmdline-config.vala"
	if (!rygel_cmdline_config_no_transcoding) {
#line 342 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	} else {
		result = FALSE;
#line 146 "rygel-cmdline-config.vala"
		return result;
#line 352 "rygel-cmdline-config.c"
	}
}


#line 150 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
#line 359 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 151 "rygel-cmdline-config.vala"
	if (!rygel_cmdline_config_no_mp3_trans) {
#line 366 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	} else {
		result = FALSE;
#line 154 "rygel-cmdline-config.vala"
		return result;
#line 376 "rygel-cmdline-config.c"
	}
}


#line 158 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
#line 383 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 159 "rygel-cmdline-config.vala"
	if (!rygel_cmdline_config_no_mp2ts_trans) {
#line 390 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	} else {
		result = FALSE;
#line 162 "rygel-cmdline-config.vala"
		return result;
#line 400 "rygel-cmdline-config.c"
	}
}


#line 166 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
#line 407 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 167 "rygel-cmdline-config.vala"
	if (!rygel_cmdline_config_no_lpcm_trans) {
#line 414 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	} else {
		result = FALSE;
#line 170 "rygel-cmdline-config.vala"
		return result;
#line 424 "rygel-cmdline-config.c"
	}
}


#line 174 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
#line 431 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 175 "rygel-cmdline-config.vala"
	if (!rygel_cmdline_config_no_wmv_trans) {
#line 438 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	} else {
		result = FALSE;
#line 178 "rygel-cmdline-config.vala"
		return result;
#line 448 "rygel-cmdline-config.c"
	}
}


#line 182 "rygel-cmdline-config.vala"
static RygelLogLevel rygel_cmdline_config_real_get_log_level (RygelConfiguration* base, GError** error) {
#line 455 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	RygelLogLevel result = 0;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 183 "rygel-cmdline-config.vala"
	if (rygel_cmdline_config_log_level == RYGEL_LOG_LEVEL_INVALID) {
#line 462 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = rygel_cmdline_config_log_level;
#line 187 "rygel-cmdline-config.vala"
	return result;
#line 472 "rygel-cmdline-config.c"
}


#line 190 "rygel-cmdline-config.vala"
static char* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
#line 478 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 191 "rygel-cmdline-config.vala"
	if (rygel_cmdline_config_plugin_path == NULL) {
#line 485 "rygel-cmdline-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	}
	result = g_strdup (rygel_cmdline_config_plugin_path);
#line 195 "rygel-cmdline-config.vala"
	return result;
#line 495 "rygel-cmdline-config.c"
}


#line 198 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error) {
#line 501 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean disabled;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 198 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 199 "rygel-cmdline-config.vala"
	disabled = FALSE;
#line 511 "rygel-cmdline-config.c"
	{
		char** plugin_collection;
		int plugin_collection_length1;
		int plugin_it;
#line 200 "rygel-cmdline-config.vala"
		plugin_collection = rygel_cmdline_config_disabled_plugins;
#line 518 "rygel-cmdline-config.c"
		plugin_collection_length1 = _vala_array_length (rygel_cmdline_config_disabled_plugins);
		for (plugin_it = 0; plugin_it < _vala_array_length (rygel_cmdline_config_disabled_plugins); plugin_it = plugin_it + 1) {
			char* plugin;
			plugin = g_strdup (plugin_collection[plugin_it]);
			{
#line 201 "rygel-cmdline-config.vala"
				if (_vala_strcmp0 (plugin, section) == 0) {
#line 202 "rygel-cmdline-config.vala"
					disabled = TRUE;
#line 528 "rygel-cmdline-config.c"
					_g_free0 (plugin);
#line 203 "rygel-cmdline-config.vala"
					break;
#line 532 "rygel-cmdline-config.c"
				}
				_g_free0 (plugin);
			}
		}
	}
#line 207 "rygel-cmdline-config.vala"
	if (disabled) {
#line 540 "rygel-cmdline-config.c"
		result = FALSE;
#line 208 "rygel-cmdline-config.vala"
		return result;
#line 544 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
}


#line 214 "rygel-cmdline-config.vala"
static char* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const char* section, GError** error) {
#line 557 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	char* result = NULL;
	char* title;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 214 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 215 "rygel-cmdline-config.vala"
	title = NULL;
#line 567 "rygel-cmdline-config.c"
	{
		char** plugin_title_collection;
		int plugin_title_collection_length1;
		int plugin_title_it;
#line 216 "rygel-cmdline-config.vala"
		plugin_title_collection = rygel_cmdline_config_plugin_titles;
#line 574 "rygel-cmdline-config.c"
		plugin_title_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_titles);
		for (plugin_title_it = 0; plugin_title_it < _vala_array_length (rygel_cmdline_config_plugin_titles); plugin_title_it = plugin_title_it + 1) {
			char* plugin_title;
			plugin_title = g_strdup (plugin_title_collection[plugin_title_it]);
			{
				gint tokens_length1;
				gint _tokens_size_;
				char** _tmp1_;
				char** _tmp0_;
				char** tokens;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				tokens = (_tmp1_ = _tmp0_ = g_strsplit (plugin_title, ":", 2), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 218 "rygel-cmdline-config.vala"
				if (tokens[0] != NULL) {
#line 219 "rygel-cmdline-config.vala"
					_tmp3_ = tokens[1] != NULL;
#line 592 "rygel-cmdline-config.c"
				} else {
#line 218 "rygel-cmdline-config.vala"
					_tmp3_ = FALSE;
#line 596 "rygel-cmdline-config.c"
				}
#line 218 "rygel-cmdline-config.vala"
				if (_tmp3_) {
#line 220 "rygel-cmdline-config.vala"
					_tmp2_ = _vala_strcmp0 (tokens[0], section) == 0;
#line 602 "rygel-cmdline-config.c"
				} else {
#line 218 "rygel-cmdline-config.vala"
					_tmp2_ = FALSE;
#line 606 "rygel-cmdline-config.c"
				}
#line 218 "rygel-cmdline-config.vala"
				if (_tmp2_) {
#line 610 "rygel-cmdline-config.c"
					char* _tmp4_;
#line 221 "rygel-cmdline-config.vala"
					title = (_tmp4_ = g_strdup (tokens[1]), _g_free0 (title), _tmp4_);
#line 614 "rygel-cmdline-config.c"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (plugin_title);
#line 222 "rygel-cmdline-config.vala"
					break;
#line 619 "rygel-cmdline-config.c"
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (plugin_title);
			}
		}
	}
#line 226 "rygel-cmdline-config.vala"
	if (title != NULL) {
#line 628 "rygel-cmdline-config.c"
		result = title;
#line 227 "rygel-cmdline-config.vala"
		return result;
#line 632 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (title);
			return NULL;
		}
	}
	_g_free0 (title);
}


#line 235 "rygel-cmdline-config.vala"
static char* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 647 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	char* result = NULL;
	char* value;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 235 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 235 "rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 237 "rygel-cmdline-config.vala"
	value = NULL;
#line 659 "rygel-cmdline-config.c"
	{
		char** option_collection;
		int option_collection_length1;
		int option_it;
#line 238 "rygel-cmdline-config.vala"
		option_collection = rygel_cmdline_config_plugin_options;
#line 666 "rygel-cmdline-config.c"
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			char* option;
			option = g_strdup (option_collection[option_it]);
			{
				gint tokens_length1;
				gint _tokens_size_;
				char** _tmp1_;
				char** _tmp0_;
				char** tokens;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				tokens = (_tmp1_ = _tmp0_ = g_strsplit (option, ":", 3), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 240 "rygel-cmdline-config.vala"
				if (tokens[0] != NULL) {
#line 241 "rygel-cmdline-config.vala"
					_tmp5_ = tokens[1] != NULL;
#line 686 "rygel-cmdline-config.c"
				} else {
#line 240 "rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 690 "rygel-cmdline-config.c"
				}
#line 240 "rygel-cmdline-config.vala"
				if (_tmp5_) {
#line 242 "rygel-cmdline-config.vala"
					_tmp4_ = tokens[2] != NULL;
#line 696 "rygel-cmdline-config.c"
				} else {
#line 240 "rygel-cmdline-config.vala"
					_tmp4_ = FALSE;
#line 700 "rygel-cmdline-config.c"
				}
#line 240 "rygel-cmdline-config.vala"
				if (_tmp4_) {
#line 243 "rygel-cmdline-config.vala"
					_tmp3_ = _vala_strcmp0 (tokens[0], section) == 0;
#line 706 "rygel-cmdline-config.c"
				} else {
#line 240 "rygel-cmdline-config.vala"
					_tmp3_ = FALSE;
#line 710 "rygel-cmdline-config.c"
				}
#line 240 "rygel-cmdline-config.vala"
				if (_tmp3_) {
#line 244 "rygel-cmdline-config.vala"
					_tmp2_ = _vala_strcmp0 (tokens[1], key) == 0;
#line 716 "rygel-cmdline-config.c"
				} else {
#line 240 "rygel-cmdline-config.vala"
					_tmp2_ = FALSE;
#line 720 "rygel-cmdline-config.c"
				}
#line 240 "rygel-cmdline-config.vala"
				if (_tmp2_) {
#line 724 "rygel-cmdline-config.c"
					char* _tmp6_;
#line 245 "rygel-cmdline-config.vala"
					value = (_tmp6_ = g_strdup (tokens[2]), _g_free0 (value), _tmp6_);
#line 728 "rygel-cmdline-config.c"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
#line 246 "rygel-cmdline-config.vala"
					break;
#line 733 "rygel-cmdline-config.c"
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
#line 250 "rygel-cmdline-config.vala"
	if (value != NULL) {
#line 742 "rygel-cmdline-config.c"
		result = value;
#line 251 "rygel-cmdline-config.vala"
		return result;
#line 746 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (value);
			return NULL;
		}
	}
	_g_free0 (value);
}


#line 257 "rygel-cmdline-config.vala"
static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 761 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 257 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 257 "rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 260 "rygel-cmdline-config.vala"
	value = NULL;
#line 773 "rygel-cmdline-config.c"
	{
		char** option_collection;
		int option_collection_length1;
		int option_it;
#line 261 "rygel-cmdline-config.vala"
		option_collection = rygel_cmdline_config_plugin_options;
#line 780 "rygel-cmdline-config.c"
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			char* option;
			option = g_strdup (option_collection[option_it]);
			{
				gint tokens_length1;
				gint _tokens_size_;
				char** _tmp1_;
				char** _tmp0_;
				char** tokens;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				tokens = (_tmp1_ = _tmp0_ = g_strsplit (option, ":", 3), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 263 "rygel-cmdline-config.vala"
				if (tokens[0] != NULL) {
#line 264 "rygel-cmdline-config.vala"
					_tmp5_ = tokens[1] != NULL;
#line 800 "rygel-cmdline-config.c"
				} else {
#line 263 "rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 804 "rygel-cmdline-config.c"
				}
#line 263 "rygel-cmdline-config.vala"
				if (_tmp5_) {
#line 265 "rygel-cmdline-config.vala"
					_tmp4_ = tokens[2] != NULL;
#line 810 "rygel-cmdline-config.c"
				} else {
#line 263 "rygel-cmdline-config.vala"
					_tmp4_ = FALSE;
#line 814 "rygel-cmdline-config.c"
				}
#line 263 "rygel-cmdline-config.vala"
				if (_tmp4_) {
#line 266 "rygel-cmdline-config.vala"
					_tmp3_ = _vala_strcmp0 (tokens[0], section) == 0;
#line 820 "rygel-cmdline-config.c"
				} else {
#line 263 "rygel-cmdline-config.vala"
					_tmp3_ = FALSE;
#line 824 "rygel-cmdline-config.c"
				}
#line 263 "rygel-cmdline-config.vala"
				if (_tmp3_) {
#line 267 "rygel-cmdline-config.vala"
					_tmp2_ = _vala_strcmp0 (tokens[1], key) == 0;
#line 830 "rygel-cmdline-config.c"
				} else {
#line 263 "rygel-cmdline-config.vala"
					_tmp2_ = FALSE;
#line 834 "rygel-cmdline-config.c"
				}
#line 263 "rygel-cmdline-config.vala"
				if (_tmp2_) {
#line 838 "rygel-cmdline-config.c"
					GeeArrayList* _tmp6_;
#line 268 "rygel-cmdline-config.vala"
					value = (_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (value), _tmp6_);
#line 842 "rygel-cmdline-config.c"
					{
						char** _tmp7_;
						char** val_token_collection;
						int val_token_collection_length1;
						int val_token_it;
#line 269 "rygel-cmdline-config.vala"
						val_token_collection = _tmp7_ = g_strsplit (tokens[2], ",", -1);
#line 850 "rygel-cmdline-config.c"
						val_token_collection_length1 = _vala_array_length (_tmp7_);
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp7_); val_token_it = val_token_it + 1) {
							char* val_token;
							val_token = g_strdup (val_token_collection[val_token_it]);
							{
#line 270 "rygel-cmdline-config.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) value, val_token);
#line 858 "rygel-cmdline-config.c"
								_g_free0 (val_token);
							}
						}
#line 269 "rygel-cmdline-config.vala"
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
#line 864 "rygel-cmdline-config.c"
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
#line 272 "rygel-cmdline-config.vala"
					break;
#line 870 "rygel-cmdline-config.c"
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
#line 276 "rygel-cmdline-config.vala"
	if (value != NULL) {
#line 879 "rygel-cmdline-config.c"
		result = value;
#line 277 "rygel-cmdline-config.vala"
		return result;
#line 883 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (value);
			return NULL;
		}
	}
	_g_object_unref0 (value);
}


#line 283 "rygel-cmdline-config.vala"
static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error) {
#line 898 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gint result = 0;
	gint value;
	gboolean value_set;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 283 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 283 "rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 288 "rygel-cmdline-config.vala"
	value = 0;
#line 289 "rygel-cmdline-config.vala"
	value_set = FALSE;
#line 913 "rygel-cmdline-config.c"
	{
		char** option_collection;
		int option_collection_length1;
		int option_it;
#line 290 "rygel-cmdline-config.vala"
		option_collection = rygel_cmdline_config_plugin_options;
#line 920 "rygel-cmdline-config.c"
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			char* option;
			option = g_strdup (option_collection[option_it]);
			{
				gint tokens_length1;
				gint _tokens_size_;
				char** _tmp1_;
				char** _tmp0_;
				char** tokens;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				tokens = (_tmp1_ = _tmp0_ = g_strsplit (option, ":", 3), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 292 "rygel-cmdline-config.vala"
				if (tokens[0] != NULL) {
#line 293 "rygel-cmdline-config.vala"
					_tmp5_ = tokens[1] != NULL;
#line 940 "rygel-cmdline-config.c"
				} else {
#line 292 "rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 944 "rygel-cmdline-config.c"
				}
#line 292 "rygel-cmdline-config.vala"
				if (_tmp5_) {
#line 294 "rygel-cmdline-config.vala"
					_tmp4_ = tokens[2] != NULL;
#line 950 "rygel-cmdline-config.c"
				} else {
#line 292 "rygel-cmdline-config.vala"
					_tmp4_ = FALSE;
#line 954 "rygel-cmdline-config.c"
				}
#line 292 "rygel-cmdline-config.vala"
				if (_tmp4_) {
#line 295 "rygel-cmdline-config.vala"
					_tmp3_ = _vala_strcmp0 (tokens[0], section) == 0;
#line 960 "rygel-cmdline-config.c"
				} else {
#line 292 "rygel-cmdline-config.vala"
					_tmp3_ = FALSE;
#line 964 "rygel-cmdline-config.c"
				}
#line 292 "rygel-cmdline-config.vala"
				if (_tmp3_) {
#line 296 "rygel-cmdline-config.vala"
					_tmp2_ = _vala_strcmp0 (tokens[1], key) == 0;
#line 970 "rygel-cmdline-config.c"
				} else {
#line 292 "rygel-cmdline-config.vala"
					_tmp2_ = FALSE;
#line 974 "rygel-cmdline-config.c"
				}
#line 292 "rygel-cmdline-config.vala"
				if (_tmp2_) {
#line 978 "rygel-cmdline-config.c"
					gboolean _tmp6_ = FALSE;
#line 297 "rygel-cmdline-config.vala"
					value = atoi (tokens[2]);
#line 298 "rygel-cmdline-config.vala"
					if (value >= min) {
#line 298 "rygel-cmdline-config.vala"
						_tmp6_ = value <= max;
#line 986 "rygel-cmdline-config.c"
					} else {
#line 298 "rygel-cmdline-config.vala"
						_tmp6_ = FALSE;
#line 990 "rygel-cmdline-config.c"
					}
#line 298 "rygel-cmdline-config.vala"
					if (_tmp6_) {
#line 299 "rygel-cmdline-config.vala"
						value_set = TRUE;
#line 996 "rygel-cmdline-config.c"
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
#line 301 "rygel-cmdline-config.vala"
					break;
#line 1002 "rygel-cmdline-config.c"
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
#line 305 "rygel-cmdline-config.vala"
	if (value_set) {
#line 1011 "rygel-cmdline-config.c"
		result = value;
#line 306 "rygel-cmdline-config.vala"
		return result;
#line 1015 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
}


#line 312 "rygel-cmdline-config.vala"
static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1028 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 312 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 312 "rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 315 "rygel-cmdline-config.vala"
	value = NULL;
#line 1040 "rygel-cmdline-config.c"
	{
		char** option_collection;
		int option_collection_length1;
		int option_it;
#line 316 "rygel-cmdline-config.vala"
		option_collection = rygel_cmdline_config_plugin_options;
#line 1047 "rygel-cmdline-config.c"
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			char* option;
			option = g_strdup (option_collection[option_it]);
			{
				gint tokens_length1;
				gint _tokens_size_;
				char** _tmp1_;
				char** _tmp0_;
				char** tokens;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				tokens = (_tmp1_ = _tmp0_ = g_strsplit (option, ":", 3), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 318 "rygel-cmdline-config.vala"
				if (tokens[0] != NULL) {
#line 319 "rygel-cmdline-config.vala"
					_tmp5_ = tokens[1] != NULL;
#line 1067 "rygel-cmdline-config.c"
				} else {
#line 318 "rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 1071 "rygel-cmdline-config.c"
				}
#line 318 "rygel-cmdline-config.vala"
				if (_tmp5_) {
#line 320 "rygel-cmdline-config.vala"
					_tmp4_ = tokens[2] != NULL;
#line 1077 "rygel-cmdline-config.c"
				} else {
#line 318 "rygel-cmdline-config.vala"
					_tmp4_ = FALSE;
#line 1081 "rygel-cmdline-config.c"
				}
#line 318 "rygel-cmdline-config.vala"
				if (_tmp4_) {
#line 321 "rygel-cmdline-config.vala"
					_tmp3_ = _vala_strcmp0 (tokens[0], section) == 0;
#line 1087 "rygel-cmdline-config.c"
				} else {
#line 318 "rygel-cmdline-config.vala"
					_tmp3_ = FALSE;
#line 1091 "rygel-cmdline-config.c"
				}
#line 318 "rygel-cmdline-config.vala"
				if (_tmp3_) {
#line 322 "rygel-cmdline-config.vala"
					_tmp2_ = _vala_strcmp0 (tokens[1], key) == 0;
#line 1097 "rygel-cmdline-config.c"
				} else {
#line 318 "rygel-cmdline-config.vala"
					_tmp2_ = FALSE;
#line 1101 "rygel-cmdline-config.c"
				}
#line 318 "rygel-cmdline-config.vala"
				if (_tmp2_) {
#line 1105 "rygel-cmdline-config.c"
					GeeArrayList* _tmp6_;
#line 323 "rygel-cmdline-config.vala"
					value = (_tmp6_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL), _g_object_unref0 (value), _tmp6_);
#line 1109 "rygel-cmdline-config.c"
					{
						char** _tmp7_;
						char** val_token_collection;
						int val_token_collection_length1;
						int val_token_it;
#line 324 "rygel-cmdline-config.vala"
						val_token_collection = _tmp7_ = g_strsplit (tokens[2], ",", -1);
#line 1117 "rygel-cmdline-config.c"
						val_token_collection_length1 = _vala_array_length (_tmp7_);
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp7_); val_token_it = val_token_it + 1) {
							char* val_token;
							val_token = g_strdup (val_token_collection[val_token_it]);
							{
#line 325 "rygel-cmdline-config.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) value, GINT_TO_POINTER (atoi (val_token)));
#line 1125 "rygel-cmdline-config.c"
								_g_free0 (val_token);
							}
						}
#line 324 "rygel-cmdline-config.vala"
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1131 "rygel-cmdline-config.c"
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
#line 327 "rygel-cmdline-config.vala"
					break;
#line 1137 "rygel-cmdline-config.c"
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
#line 331 "rygel-cmdline-config.vala"
	if (value != NULL) {
#line 1146 "rygel-cmdline-config.c"
		result = value;
#line 332 "rygel-cmdline-config.vala"
		return result;
#line 1150 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (value);
			return NULL;
		}
	}
	_g_object_unref0 (value);
}


#line 1077 "glib-2.0.vapi"
static gboolean string_to_bool (const char* self) {
#line 1165 "rygel-cmdline-config.c"
	gboolean result = FALSE;
#line 1077 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1078 "glib-2.0.vapi"
	if (_vala_strcmp0 (self, "true") == 0) {
#line 1171 "rygel-cmdline-config.c"
		result = TRUE;
#line 1079 "glib-2.0.vapi"
		return result;
#line 1175 "rygel-cmdline-config.c"
	} else {
		result = FALSE;
#line 1081 "glib-2.0.vapi"
		return result;
#line 1180 "rygel-cmdline-config.c"
	}
}


#line 338 "rygel-cmdline-config.vala"
static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1187 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean value;
	gboolean value_set;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
#line 338 "rygel-cmdline-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 338 "rygel-cmdline-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 341 "rygel-cmdline-config.vala"
	value = FALSE;
#line 342 "rygel-cmdline-config.vala"
	value_set = FALSE;
#line 1202 "rygel-cmdline-config.c"
	{
		char** option_collection;
		int option_collection_length1;
		int option_it;
#line 343 "rygel-cmdline-config.vala"
		option_collection = rygel_cmdline_config_plugin_options;
#line 1209 "rygel-cmdline-config.c"
		option_collection_length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
		for (option_it = 0; option_it < _vala_array_length (rygel_cmdline_config_plugin_options); option_it = option_it + 1) {
			char* option;
			option = g_strdup (option_collection[option_it]);
			{
				gint tokens_length1;
				gint _tokens_size_;
				char** _tmp1_;
				char** _tmp0_;
				char** tokens;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				tokens = (_tmp1_ = _tmp0_ = g_strsplit (option, ":", 3), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 345 "rygel-cmdline-config.vala"
				if (tokens[0] != NULL) {
#line 346 "rygel-cmdline-config.vala"
					_tmp5_ = tokens[1] != NULL;
#line 1229 "rygel-cmdline-config.c"
				} else {
#line 345 "rygel-cmdline-config.vala"
					_tmp5_ = FALSE;
#line 1233 "rygel-cmdline-config.c"
				}
#line 345 "rygel-cmdline-config.vala"
				if (_tmp5_) {
#line 347 "rygel-cmdline-config.vala"
					_tmp4_ = tokens[2] != NULL;
#line 1239 "rygel-cmdline-config.c"
				} else {
#line 345 "rygel-cmdline-config.vala"
					_tmp4_ = FALSE;
#line 1243 "rygel-cmdline-config.c"
				}
#line 345 "rygel-cmdline-config.vala"
				if (_tmp4_) {
#line 348 "rygel-cmdline-config.vala"
					_tmp3_ = _vala_strcmp0 (tokens[0], section) == 0;
#line 1249 "rygel-cmdline-config.c"
				} else {
#line 345 "rygel-cmdline-config.vala"
					_tmp3_ = FALSE;
#line 1253 "rygel-cmdline-config.c"
				}
#line 345 "rygel-cmdline-config.vala"
				if (_tmp3_) {
#line 349 "rygel-cmdline-config.vala"
					_tmp2_ = _vala_strcmp0 (tokens[1], key) == 0;
#line 1259 "rygel-cmdline-config.c"
				} else {
#line 345 "rygel-cmdline-config.vala"
					_tmp2_ = FALSE;
#line 1263 "rygel-cmdline-config.c"
				}
#line 345 "rygel-cmdline-config.vala"
				if (_tmp2_) {
#line 350 "rygel-cmdline-config.vala"
					value = string_to_bool (tokens[2]);
#line 351 "rygel-cmdline-config.vala"
					value_set = TRUE;
#line 1271 "rygel-cmdline-config.c"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
#line 352 "rygel-cmdline-config.vala"
					break;
#line 1276 "rygel-cmdline-config.c"
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
#line 356 "rygel-cmdline-config.vala"
	if (value_set) {
#line 1285 "rygel-cmdline-config.c"
		result = value;
#line 357 "rygel-cmdline-config.vala"
		return result;
#line 1289 "rygel-cmdline-config.c"
	} else {
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
}


#line 34 "rygel-cmdline-config.vala"
RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type) {
#line 1302 "rygel-cmdline-config.c"
	RygelCmdlineConfig * self;
#line 34 "rygel-cmdline-config.vala"
	self = (RygelCmdlineConfig*) g_object_new (object_type, NULL);
#line 1306 "rygel-cmdline-config.c"
	return self;
}


#line 34 "rygel-cmdline-config.vala"
RygelCmdlineConfig* rygel_cmdline_config_new (void) {
#line 34 "rygel-cmdline-config.vala"
	return rygel_cmdline_config_construct (RYGEL_TYPE_CMDLINE_CONFIG);
#line 1315 "rygel-cmdline-config.c"
}


static void rygel_cmdline_config_class_init (RygelCmdlineConfigClass * klass) {
	rygel_cmdline_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_cmdline_config_finalize;
}


static void rygel_cmdline_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_cmdline_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = rygel_cmdline_config_real_get_upnp_enabled;
	iface->get_interface = rygel_cmdline_config_real_get_interface;
	iface->get_port = rygel_cmdline_config_real_get_port;
	iface->get_transcoding = rygel_cmdline_config_real_get_transcoding;
	iface->get_mp3_transcoder = rygel_cmdline_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = rygel_cmdline_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = rygel_cmdline_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = rygel_cmdline_config_real_get_wmv_transcoder;
	iface->get_log_level = rygel_cmdline_config_real_get_log_level;
	iface->get_plugin_path = rygel_cmdline_config_real_get_plugin_path;
	iface->get_enabled = rygel_cmdline_config_real_get_enabled;
	iface->get_title = rygel_cmdline_config_real_get_title;
	iface->get_string = rygel_cmdline_config_real_get_string;
	iface->get_string_list = rygel_cmdline_config_real_get_string_list;
	iface->get_int = rygel_cmdline_config_real_get_int;
	iface->get_int_list = rygel_cmdline_config_real_get_int_list;
	iface->get_bool = rygel_cmdline_config_real_get_bool;
}


static void rygel_cmdline_config_instance_init (RygelCmdlineConfig * self) {
}


static void rygel_cmdline_config_finalize (GObject* obj) {
	RygelCmdlineConfig * self;
	self = RYGEL_CMDLINE_CONFIG (obj);
	G_OBJECT_CLASS (rygel_cmdline_config_parent_class)->finalize (obj);
}


/**
 * Manages configuration from Commandline arguments.
 */
GType rygel_cmdline_config_get_type (void) {
	static volatile gsize rygel_cmdline_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_cmdline_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelCmdlineConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_cmdline_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelCmdlineConfig), 0, (GInstanceInitFunc) rygel_cmdline_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_cmdline_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_cmdline_config_type_id;
		rygel_cmdline_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelCmdlineConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_cmdline_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_cmdline_config_type_id__volatile, rygel_cmdline_config_type_id);
	}
	return rygel_cmdline_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




