/* rygel-tracker-metadata-values.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-tracker-metadata-values.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TRACKER_TYPE_METADATA_VALUES (rygel_tracker_metadata_values_get_type ())
#define RYGEL_TRACKER_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValues))
#define RYGEL_TRACKER_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesClass))
#define RYGEL_TRACKER_IS_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES))
#define RYGEL_TRACKER_IS_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_METADATA_VALUES))
#define RYGEL_TRACKER_METADATA_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesClass))

typedef struct _RygelTrackerMetadataValues RygelTrackerMetadataValues;
typedef struct _RygelTrackerMetadataValuesClass RygelTrackerMetadataValuesClass;
typedef struct _RygelTrackerMetadataValuesPrivate RygelTrackerMetadataValuesPrivate;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_CLASS_IFACE (rygel_tracker_resources_class_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_CLASS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_CLASS_IFACE, RygelTrackerResourcesClassIface))
#define RYGEL_TRACKER_IS_RESOURCES_CLASS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_CLASS_IFACE))
#define RYGEL_TRACKER_RESOURCES_CLASS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_CLASS_IFACE, RygelTrackerResourcesClassIfaceIface))

typedef struct _RygelTrackerResourcesClassIface RygelTrackerResourcesClassIface;
typedef struct _RygelTrackerResourcesClassIfaceIface RygelTrackerResourcesClassIfaceIface;
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerQueryTripletPrivate RygelTrackerQueryTripletPrivate;
typedef struct _RygelTrackerMetadataValuesFetchMetadataValuesData RygelTrackerMetadataValuesFetchMetadataValuesData;
typedef struct _RygelTrackerMetadataValuesFindObjectData RygelTrackerMetadataValuesFindObjectData;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _RygelTrackerMetadataValues {
	RygelSimpleContainer parent_instance;
	RygelTrackerMetadataValuesPrivate * priv;
	char** key_chain;
	gint key_chain_length1;
};

struct _RygelTrackerMetadataValuesClass {
	RygelSimpleContainerClass parent_class;
	char* (*create_id_for_title) (RygelTrackerMetadataValues* self, const char* title);
	char* (*create_title_for_value) (RygelTrackerMetadataValues* self, const char* value);
	char* (*create_filter) (RygelTrackerMetadataValues* self, const char* variable, const char* value);
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerResourcesClassIfaceIface {
	GTypeInterface parent_iface;
};

struct _RygelTrackerMetadataValuesPrivate {
	RygelTrackerItemFactory* item_factory;
	RygelTrackerResourcesIface* resources;
	RygelTrackerResourcesClassIface* resources_class;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	char* category;
	char* upnp_class;
	char* resources_class_path;
	char* upload_dir;
	GeeArrayList* key_chains;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const char* uri, char** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	char* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	char* order_by;
	gint offset;
	gint max_count;
	char** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerQueryTriplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryTripletPrivate * priv;
	char* subject;
	char* predicate;
	char* obj;
	RygelTrackerQueryTriplet* next;
};

struct _RygelTrackerQueryTripletClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQueryTriplet *self);
};

struct _RygelTrackerMetadataValuesFetchMetadataValuesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataValues* self;
	gint i;
	RygelTrackerQueryTriplets* triplets;
	gint num_keys;
	char** variables;
	gint variables_length1;
	gint _variables_size_;
	char** _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* subject;
	char* _tmp4_;
	char* _tmp5_;
	RygelTrackerQueryTriplet* _tmp6_;
	RygelTrackerQueryTriplet* _tmp7_;
	GeeArrayList* selected;
	char* last_variable;
	char* _tmp8_;
	RygelTrackerSelectionQuery* query;
	char* _tmp9_;
	GError * _error_;
	gboolean _tmp10_;
	char* value;
	char* title;
	char* id;
	RygelTrackerQueryTriplets* child_triplets;
	GeeArrayList* filters;
	char* filter;
	RygelTrackerQueryTriplet* _tmp11_;
	char* _tmp12_;
	RygelTrackerSearchContainer* container;
	GError * _inner_error_;
};

struct _RygelTrackerMetadataValuesFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataValues* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* _tmp0_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_metadata_values_parent_class = NULL;

GType rygel_tracker_metadata_values_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
RygelTrackerResourcesIface* rygel_tracker_resources_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_class_iface_get_type (void) G_GNUC_CONST;
RygelTrackerResourcesClassIface* rygel_tracker_resources_class_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
#define RYGEL_TRACKER_METADATA_VALUES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesPrivate))
enum  {
	RYGEL_TRACKER_METADATA_VALUES_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_METADATA_VALUES_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_METADATA_VALUES_ITEM_VARIABLE "?item"
RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, char** key_chain, int key_chain_length1);
static char** _vala_array_dup1 (char** self, int length);
static void rygel_tracker_metadata_values_create_proxies (RygelTrackerMetadataValues* self, GError** error);
static void rygel_tracker_metadata_values_fetch_metadata_values (RygelTrackerMetadataValues* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_metadata_values_fetch_metadata_values_finish (RygelTrackerMetadataValues* self, GAsyncResult* _res_);
static void rygel_tracker_metadata_values_hook_to_changes (RygelTrackerMetadataValues* self);
static void rygel_tracker_metadata_values_fetch_metadata_values_data_free (gpointer _data);
static void rygel_tracker_metadata_values_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_metadata_values_fetch_metadata_values_co (RygelTrackerMetadataValuesFetchMetadataValuesData* data);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const char* subject, const char* predicate, const char* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const char* subject, const char* predicate, const char* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
char* rygel_tracker_metadata_values_create_title_for_value (RygelTrackerMetadataValues* self, const char* value);
char* rygel_tracker_metadata_values_create_id_for_title (RygelTrackerMetadataValues* self, const char* title);
static gboolean rygel_tracker_metadata_values_is_child_id_unique (RygelTrackerMetadataValues* self, const char* child_id);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
char* rygel_tracker_metadata_values_create_filter (RygelTrackerMetadataValues* self, const char* variable, const char* value);
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void rygel_tracker_metadata_values_real_find_object_data_free (gpointer _data);
static void rygel_tracker_metadata_values_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_metadata_values_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_metadata_values_real_find_object_co (RygelTrackerMetadataValuesFindObjectData* data);
static gboolean rygel_tracker_metadata_values_is_our_child (RygelTrackerMetadataValues* self, const char* id);
static char* rygel_tracker_metadata_values_real_create_id_for_title (RygelTrackerMetadataValues* self, const char* title);
static char* rygel_tracker_metadata_values_real_create_title_for_value (RygelTrackerMetadataValues* self, const char* value);
static char* rygel_tracker_metadata_values_real_create_filter (RygelTrackerMetadataValues* self, const char* variable, const char* value);
static void _lambda0_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self);
static void __lambda0__rygel_tracker_resources_class_iface_subjects_added (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self);
static void _lambda1_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self);
static void __lambda1__rygel_tracker_resources_class_iface_subjects_removed (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self);
static void _lambda2_ (char** before, int before_length1, char** after, int after_length1, RygelTrackerMetadataValues* self);
static void __lambda2__rygel_tracker_resources_class_iface_subjects_changed (RygelTrackerResourcesClassIface* _sender, char** before, int before_length1, char** after, int after_length1, gpointer self);
static void rygel_tracker_metadata_values_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 47 "rygel-tracker-metadata-values.vala"
RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, char** key_chain, int key_chain_length1) {
#line 392 "rygel-tracker-metadata-values.c"
	RygelTrackerMetadataValues * self;
	RygelTrackerItemFactory* _tmp0_;
	char** _tmp1_;
	char** _tmp2_;
	GError * _inner_error_ = NULL;
#line 47 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 47 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 47 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 47 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (item_factory != NULL, NULL);
#line 52 "rygel-tracker-metadata-values.vala"
	self = (RygelTrackerMetadataValues*) rygel_simple_container_construct (object_type, id, parent, title);
#line 54 "rygel-tracker-metadata-values.vala"
	self->priv->item_factory = (_tmp0_ = _rygel_tracker_item_factory_ref0 (item_factory), _rygel_tracker_item_factory_unref0 (self->priv->item_factory), _tmp0_);
#line 55 "rygel-tracker-metadata-values.vala"
	self->key_chain = (_tmp2_ = (_tmp1_ = key_chain, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, key_chain_length1)), self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL), self->key_chain_length1 = key_chain_length1, _tmp2_);
#line 412 "rygel-tracker-metadata-values.c"
	{
#line 58 "rygel-tracker-metadata-values.vala"
		rygel_tracker_metadata_values_create_proxies (self, &_inner_error_);
#line 416 "rygel-tracker-metadata-values.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 60 "rygel-tracker-metadata-values.vala"
			g_critical (_ ("Failed to connect to session bus: %s"), _error_->message);
#line 435 "rygel-tracker-metadata-values.c"
			_g_error_free0 (_error_);
#line 62 "rygel-tracker-metadata-values.vala"
			return self;
#line 439 "rygel-tracker-metadata-values.c"
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 65 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 67 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_hook_to_changes (self);
#line 452 "rygel-tracker-metadata-values.c"
	return self;
}


static void rygel_tracker_metadata_values_fetch_metadata_values_data_free (gpointer _data) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelTrackerMetadataValuesFetchMetadataValuesData, data);
}


static void rygel_tracker_metadata_values_fetch_metadata_values (RygelTrackerMetadataValues* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* _data_;
	_data_ = g_slice_new0 (RygelTrackerMetadataValuesFetchMetadataValuesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_values_fetch_metadata_values);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_values_fetch_metadata_values_data_free);
	_data_->self = g_object_ref (self);
	rygel_tracker_metadata_values_fetch_metadata_values_co (_data_);
}


static void rygel_tracker_metadata_values_fetch_metadata_values_finish (RygelTrackerMetadataValues* self, GAsyncResult* _res_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_metadata_values_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_metadata_values_fetch_metadata_values_co (data);
}


#line 1177 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 491 "rygel-tracker-metadata-values.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 500 "rygel-tracker-metadata-values.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1179 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 508 "rygel-tracker-metadata-values.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1180 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 519 "rygel-tracker-metadata-values.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1180 "glib-2.0.vapi"
		return result;
#line 534 "rygel-tracker-metadata-values.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1182 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 545 "rygel-tracker-metadata-values.c"
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean rygel_tracker_metadata_values_fetch_metadata_values_co (RygelTrackerMetadataValuesFetchMetadataValuesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
	}
	_state_0:
#line 72 "rygel-tracker-metadata-values.vala"
	rygel_simple_container_clear ((RygelSimpleContainer*) data->self);
#line 570 "rygel-tracker-metadata-values.c"
	data->triplets = rygel_tracker_query_triplets_new ();
	data->num_keys = data->self->key_chain_length1 - 1;
	data->variables = (data->_tmp0_ = g_new0 (char*, data->num_keys + 1), data->variables_length1 = data->num_keys, data->_variables_size_ = data->variables_length1, data->_tmp0_);
	{
#line 80 "rygel-tracker-metadata-values.vala"
		data->i = 0;
#line 577 "rygel-tracker-metadata-values.c"
		data->_tmp1_ = TRUE;
#line 80 "rygel-tracker-metadata-values.vala"
		while (TRUE) {
#line 80 "rygel-tracker-metadata-values.vala"
			if (!data->_tmp1_) {
#line 80 "rygel-tracker-metadata-values.vala"
				data->i++;
#line 585 "rygel-tracker-metadata-values.c"
			}
#line 80 "rygel-tracker-metadata-values.vala"
			data->_tmp1_ = FALSE;
#line 80 "rygel-tracker-metadata-values.vala"
			if (!(data->i < data->num_keys)) {
#line 80 "rygel-tracker-metadata-values.vala"
				break;
#line 593 "rygel-tracker-metadata-values.c"
			}
#line 81 "rygel-tracker-metadata-values.vala"
			data->variables[data->i] = (data->_tmp3_ = g_strconcat ("?", data->_tmp2_ = string_replace (data->self->key_chain[data->i], ":", "_"), NULL), _g_free0 (data->variables[data->i]), data->_tmp3_);
#line 597 "rygel-tracker-metadata-values.c"
			_g_free0 (data->_tmp2_);
#line 84 "rygel-tracker-metadata-values.vala"
			if (data->i == 0) {
#line 85 "rygel-tracker-metadata-values.vala"
				data->subject = (data->_tmp4_ = g_strdup (RYGEL_TRACKER_METADATA_VALUES_ITEM_VARIABLE), _g_free0 (data->subject), data->_tmp4_);
#line 603 "rygel-tracker-metadata-values.c"
			} else {
#line 87 "rygel-tracker-metadata-values.vala"
				data->subject = (data->_tmp5_ = g_strdup (data->variables[data->i - 1]), _g_free0 (data->subject), data->_tmp5_);
#line 607 "rygel-tracker-metadata-values.c"
			}
#line 90 "rygel-tracker-metadata-values.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) data->triplets, data->_tmp6_ = rygel_tracker_query_triplet_new (data->subject, data->self->key_chain[data->i], data->variables[data->i]));
#line 611 "rygel-tracker-metadata-values.c"
			_rygel_tracker_query_triplet_unref0 (data->_tmp6_);
			_g_free0 (data->subject);
		}
	}
#line 95 "rygel-tracker-metadata-values.vala"
	gee_abstract_list_insert ((GeeAbstractList*) data->triplets, 0, data->_tmp7_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_METADATA_VALUES_ITEM_VARIABLE, "a", data->self->priv->item_factory->category));
#line 618 "rygel-tracker-metadata-values.c"
	_rygel_tracker_query_triplet_unref0 (data->_tmp7_);
	data->selected = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	data->last_variable = g_strdup (data->variables[data->num_keys - 1]);
#line 103 "rygel-tracker-metadata-values.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) data->selected, data->_tmp8_ = g_strconcat ("DISTINCT ", data->last_variable, NULL));
#line 624 "rygel-tracker-metadata-values.c"
	_g_free0 (data->_tmp8_);
	data->query = rygel_tracker_selection_query_new (data->selected, data->triplets, NULL, data->last_variable, 0, -1);
	{
		data->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_metadata_values_fetch_metadata_values_ready, data);
		return FALSE;
		_state_1:
#line 111 "rygel-tracker-metadata-values.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 634 "rygel-tracker-metadata-values.c"
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == DBUS_GERROR) {
				goto __catch3_dbus_gerror;
			}
			_rygel_tracker_query_unref0 (data->query);
			_g_free0 (data->last_variable);
			_g_object_unref0 (data->selected);
			data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->triplets);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 113 "rygel-tracker-metadata-values.vala"
			g_critical (_ ("Error getting all values for '%s': %s"), data->_tmp9_ = g_strjoinv (" -> ", data->self->key_chain), data->_error_->message);
#line 657 "rygel-tracker-metadata-values.c"
			_g_free0 (data->_tmp9_);
			_g_error_free0 (data->_error_);
			_rygel_tracker_query_unref0 (data->query);
			_g_free0 (data->last_variable);
			_g_object_unref0 (data->selected);
			data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->triplets);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->_error_);
		}
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		_rygel_tracker_query_unref0 (data->query);
		_g_free0 (data->last_variable);
		_g_object_unref0 (data->selected);
		data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (data->triplets);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
#line 121 "rygel-tracker-metadata-values.vala"
		data->i = 0;
#line 691 "rygel-tracker-metadata-values.c"
		data->_tmp10_ = TRUE;
#line 121 "rygel-tracker-metadata-values.vala"
		while (TRUE) {
#line 121 "rygel-tracker-metadata-values.vala"
			if (!data->_tmp10_) {
#line 121 "rygel-tracker-metadata-values.vala"
				data->i++;
#line 699 "rygel-tracker-metadata-values.c"
			}
#line 121 "rygel-tracker-metadata-values.vala"
			data->_tmp10_ = FALSE;
#line 121 "rygel-tracker-metadata-values.vala"
			if (!(data->i < data->query->result_length1)) {
#line 121 "rygel-tracker-metadata-values.vala"
				break;
#line 707 "rygel-tracker-metadata-values.c"
			}
			data->value = g_strdup (data->query->result[(data->i * data->query->result_length2) + 0]);
#line 124 "rygel-tracker-metadata-values.vala"
			if (_vala_strcmp0 (data->value, "") == 0) {
#line 712 "rygel-tracker-metadata-values.c"
				_g_free0 (data->value);
#line 125 "rygel-tracker-metadata-values.vala"
				continue;
#line 716 "rygel-tracker-metadata-values.c"
			}
			data->title = rygel_tracker_metadata_values_create_title_for_value (data->self, data->value);
			data->id = rygel_tracker_metadata_values_create_id_for_title (data->self, data->title);
#line 130 "rygel-tracker-metadata-values.vala"
			if (!rygel_tracker_metadata_values_is_child_id_unique (data->self, data->id)) {
#line 722 "rygel-tracker-metadata-values.c"
				_g_free0 (data->id);
				_g_free0 (data->title);
				_g_free0 (data->value);
#line 131 "rygel-tracker-metadata-values.vala"
				continue;
#line 728 "rygel-tracker-metadata-values.c"
			}
			data->child_triplets = rygel_tracker_query_triplets_new_clone (data->triplets);
			data->filters = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
			data->filter = (data->_tmp12_ = rygel_tracker_metadata_values_create_filter (data->self, (data->_tmp11_ = (RygelTrackerQueryTriplet*) gee_abstract_list_last ((GeeAbstractList*) data->child_triplets))->obj, data->value), _rygel_tracker_query_triplet_unref0 (data->_tmp11_), data->_tmp12_);
#line 141 "rygel-tracker-metadata-values.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) data->filters, data->filter);
#line 735 "rygel-tracker-metadata-values.c"
			data->container = rygel_tracker_search_container_new (data->id, (RygelMediaContainer*) data->self, data->title, data->self->priv->item_factory, data->child_triplets, data->filters);
#line 150 "rygel-tracker-metadata-values.vala"
			rygel_simple_container_add_child ((RygelSimpleContainer*) data->self, (RygelMediaObject*) data->container);
#line 739 "rygel-tracker-metadata-values.c"
			_g_object_unref0 (data->container);
			_g_free0 (data->filter);
			_g_object_unref0 (data->filters);
			_g_object_unref0 (data->child_triplets);
			_g_free0 (data->id);
			_g_free0 (data->title);
			_g_free0 (data->value);
		}
	}
#line 153 "rygel-tracker-metadata-values.vala"
	rygel_media_container_updated ((RygelMediaContainer*) data->self);
#line 751 "rygel-tracker-metadata-values.c"
	_rygel_tracker_query_unref0 (data->query);
	_g_free0 (data->last_variable);
	_g_object_unref0 (data->selected);
	data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->triplets);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_tracker_metadata_values_real_find_object_data_free (gpointer _data) {
	RygelTrackerMetadataValuesFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerMetadataValuesFindObjectData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_metadata_values_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataValues * self;
	RygelTrackerMetadataValuesFindObjectData* _data_;
	self = (RygelTrackerMetadataValues*) base;
	_data_ = g_slice_new0 (RygelTrackerMetadataValuesFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_values_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_values_real_find_object_data_free);
	_data_->self = g_object_ref (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_metadata_values_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_tracker_metadata_values_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerMetadataValuesFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_metadata_values_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_metadata_values_real_find_object_co (data);
}


static gboolean rygel_tracker_metadata_values_real_find_object_co (RygelTrackerMetadataValuesFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 2:
		goto _state_2;
	}
	_state_0:
#line 159 "rygel-tracker-metadata-values.vala"
	if (rygel_tracker_metadata_values_is_our_child (data->self, data->id)) {
#line 832 "rygel-tracker-metadata-values.c"
		data->_state_ = 2;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_metadata_values_parent_class)->find_object ((RygelMediaContainer*) RYGEL_SIMPLE_CONTAINER (data->self), data->id, data->cancellable, rygel_tracker_metadata_values_find_object_ready, data);
		return FALSE;
		_state_2:
		data->_tmp0_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_metadata_values_parent_class)->find_object_finish ((RygelMediaContainer*) RYGEL_SIMPLE_CONTAINER (data->self), data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp0_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	} else {
		data->result = NULL;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 166 "rygel-tracker-metadata-values.vala"
static char* rygel_tracker_metadata_values_real_create_id_for_title (RygelTrackerMetadataValues* self, const char* title) {
#line 887 "rygel-tracker-metadata-values.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
#line 166 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 895 "rygel-tracker-metadata-values.c"
	result = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ":", NULL), title, NULL), _g_free0 (_tmp0_), _tmp1_);
#line 167 "rygel-tracker-metadata-values.vala"
	return result;
#line 899 "rygel-tracker-metadata-values.c"
}


#line 47 "rygel-tracker-metadata-values.vala"
char* rygel_tracker_metadata_values_create_id_for_title (RygelTrackerMetadataValues* self, const char* title) {
#line 47 "rygel-tracker-metadata-values.vala"
	return RYGEL_TRACKER_METADATA_VALUES_GET_CLASS (self)->create_id_for_title (self, title);
#line 907 "rygel-tracker-metadata-values.c"
}


#line 170 "rygel-tracker-metadata-values.vala"
static char* rygel_tracker_metadata_values_real_create_title_for_value (RygelTrackerMetadataValues* self, const char* value) {
#line 913 "rygel-tracker-metadata-values.c"
	char* result = NULL;
#line 170 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 170 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 919 "rygel-tracker-metadata-values.c"
	result = g_strdup (value);
#line 171 "rygel-tracker-metadata-values.vala"
	return result;
#line 923 "rygel-tracker-metadata-values.c"
}


#line 47 "rygel-tracker-metadata-values.vala"
char* rygel_tracker_metadata_values_create_title_for_value (RygelTrackerMetadataValues* self, const char* value) {
#line 47 "rygel-tracker-metadata-values.vala"
	return RYGEL_TRACKER_METADATA_VALUES_GET_CLASS (self)->create_title_for_value (self, value);
#line 931 "rygel-tracker-metadata-values.c"
}


#line 174 "rygel-tracker-metadata-values.vala"
static char* rygel_tracker_metadata_values_real_create_filter (RygelTrackerMetadataValues* self, const char* variable, const char* value) {
#line 937 "rygel-tracker-metadata-values.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 174 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (variable != NULL, NULL);
#line 174 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 948 "rygel-tracker-metadata-values.c"
	result = (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (variable, " = \"", NULL), value, NULL), "\"", NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 175 "rygel-tracker-metadata-values.vala"
	return result;
#line 952 "rygel-tracker-metadata-values.c"
}


#line 47 "rygel-tracker-metadata-values.vala"
char* rygel_tracker_metadata_values_create_filter (RygelTrackerMetadataValues* self, const char* variable, const char* value) {
#line 47 "rygel-tracker-metadata-values.vala"
	return RYGEL_TRACKER_METADATA_VALUES_GET_CLASS (self)->create_filter (self, variable, value);
#line 960 "rygel-tracker-metadata-values.c"
}


#line 178 "rygel-tracker-metadata-values.vala"
static gboolean rygel_tracker_metadata_values_is_our_child (RygelTrackerMetadataValues* self, const char* id) {
#line 966 "rygel-tracker-metadata-values.c"
	gboolean result = FALSE;
	char* _tmp0_;
	gboolean _tmp1_;
#line 178 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 178 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 974 "rygel-tracker-metadata-values.c"
	result = (_tmp1_ = g_str_has_prefix (id, _tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ":", NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 179 "rygel-tracker-metadata-values.vala"
	return result;
#line 978 "rygel-tracker-metadata-values.c"
}


#line 182 "rygel-tracker-metadata-values.vala"
static void rygel_tracker_metadata_values_create_proxies (RygelTrackerMetadataValues* self, GError** error) {
#line 984 "rygel-tracker-metadata-values.c"
	DBusGConnection* connection;
	RygelTrackerResourcesIface* _tmp0_;
	RygelTrackerResourcesClassIface* _tmp1_;
	GError * _inner_error_ = NULL;
#line 182 "rygel-tracker-metadata-values.vala"
	g_return_if_fail (self != NULL);
#line 183 "rygel-tracker-metadata-values.vala"
	connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 993 "rygel-tracker-metadata-values.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 185 "rygel-tracker-metadata-values.vala"
	self->priv->resources = (_tmp0_ = rygel_tracker_resources_iface_dbus_proxy_new (connection, RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE, RYGEL_TRACKER_METADATA_VALUES_RESOURCES_PATH), _g_object_unref0 (self->priv->resources), _tmp0_);
#line 187 "rygel-tracker-metadata-values.vala"
	self->priv->resources_class = (_tmp1_ = rygel_tracker_resources_class_iface_dbus_proxy_new (connection, RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE, self->priv->item_factory->resources_class_path), _g_object_unref0 (self->priv->resources_class), _tmp1_);
#line 1008 "rygel-tracker-metadata-values.c"
	_dbus_g_connection_unref0 (connection);
}


#line 195 "rygel-tracker-metadata-values.vala"
static void _lambda0_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self) {
#line 196 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 1017 "rygel-tracker-metadata-values.c"
}


#line 195 "rygel-tracker-metadata-values.vala"
static void __lambda0__rygel_tracker_resources_class_iface_subjects_added (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self) {
#line 1023 "rygel-tracker-metadata-values.c"
	_lambda0_ (subjects, subjects_length1, self);
}


#line 198 "rygel-tracker-metadata-values.vala"
static void _lambda1_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self) {
#line 199 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 1032 "rygel-tracker-metadata-values.c"
}


#line 198 "rygel-tracker-metadata-values.vala"
static void __lambda1__rygel_tracker_resources_class_iface_subjects_removed (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self) {
#line 1038 "rygel-tracker-metadata-values.c"
	_lambda1_ (subjects, subjects_length1, self);
}


#line 201 "rygel-tracker-metadata-values.vala"
static void _lambda2_ (char** before, int before_length1, char** after, int after_length1, RygelTrackerMetadataValues* self) {
#line 202 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 1047 "rygel-tracker-metadata-values.c"
}


#line 201 "rygel-tracker-metadata-values.vala"
static void __lambda2__rygel_tracker_resources_class_iface_subjects_changed (RygelTrackerResourcesClassIface* _sender, char** before, int before_length1, char** after, int after_length1, gpointer self) {
#line 1053 "rygel-tracker-metadata-values.c"
	_lambda2_ (before, before_length1, after, after_length1, self);
}


#line 193 "rygel-tracker-metadata-values.vala"
static void rygel_tracker_metadata_values_hook_to_changes (RygelTrackerMetadataValues* self) {
#line 193 "rygel-tracker-metadata-values.vala"
	g_return_if_fail (self != NULL);
#line 195 "rygel-tracker-metadata-values.vala"
	g_signal_connect_object (self->priv->resources_class, "subjects-added", (GCallback) __lambda0__rygel_tracker_resources_class_iface_subjects_added, self, 0);
#line 198 "rygel-tracker-metadata-values.vala"
	g_signal_connect_object (self->priv->resources_class, "subjects-removed", (GCallback) __lambda1__rygel_tracker_resources_class_iface_subjects_removed, self, 0);
#line 201 "rygel-tracker-metadata-values.vala"
	g_signal_connect_object (self->priv->resources_class, "subjects-changed", (GCallback) __lambda2__rygel_tracker_resources_class_iface_subjects_changed, self, 0);
#line 1068 "rygel-tracker-metadata-values.c"
}


#line 206 "rygel-tracker-metadata-values.vala"
static gboolean rygel_tracker_metadata_values_is_child_id_unique (RygelTrackerMetadataValues* self, const char* child_id) {
#line 1074 "rygel-tracker-metadata-values.c"
	gboolean result = FALSE;
	gboolean unique;
#line 206 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (child_id != NULL, FALSE);
#line 207 "rygel-tracker-metadata-values.vala"
	unique = TRUE;
#line 1083 "rygel-tracker-metadata-values.c"
	{
		GeeIterator* _child_it;
#line 209 "rygel-tracker-metadata-values.vala"
		_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ((RygelSimpleContainer*) self)->children);
#line 209 "rygel-tracker-metadata-values.vala"
		while (TRUE) {
#line 1090 "rygel-tracker-metadata-values.c"
			RygelMediaObject* child;
#line 209 "rygel-tracker-metadata-values.vala"
			if (!gee_iterator_next (_child_it)) {
#line 209 "rygel-tracker-metadata-values.vala"
				break;
#line 1096 "rygel-tracker-metadata-values.c"
			}
#line 209 "rygel-tracker-metadata-values.vala"
			child = (RygelMediaObject*) gee_iterator_get (_child_it);
#line 210 "rygel-tracker-metadata-values.vala"
			if (_vala_strcmp0 (child->id, child_id) == 0) {
#line 211 "rygel-tracker-metadata-values.vala"
				unique = FALSE;
#line 1104 "rygel-tracker-metadata-values.c"
				_g_object_unref0 (child);
#line 213 "rygel-tracker-metadata-values.vala"
				break;
#line 1108 "rygel-tracker-metadata-values.c"
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	result = unique;
#line 217 "rygel-tracker-metadata-values.vala"
	return result;
#line 1117 "rygel-tracker-metadata-values.c"
}


static void rygel_tracker_metadata_values_class_init (RygelTrackerMetadataValuesClass * klass) {
	rygel_tracker_metadata_values_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerMetadataValuesPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_metadata_values_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_metadata_values_real_find_object_finish;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_id_for_title = rygel_tracker_metadata_values_real_create_id_for_title;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_title_for_value = rygel_tracker_metadata_values_real_create_title_for_value;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_filter = rygel_tracker_metadata_values_real_create_filter;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_metadata_values_finalize;
}


static void rygel_tracker_metadata_values_instance_init (RygelTrackerMetadataValues * self) {
	self->priv = RYGEL_TRACKER_METADATA_VALUES_GET_PRIVATE (self);
}


static void rygel_tracker_metadata_values_finalize (GObject* obj) {
	RygelTrackerMetadataValues * self;
	self = RYGEL_TRACKER_METADATA_VALUES (obj);
	_rygel_tracker_item_factory_unref0 (self->priv->item_factory);
	self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->resources);
	_g_object_unref0 (self->priv->resources_class);
	G_OBJECT_CLASS (rygel_tracker_metadata_values_parent_class)->finalize (obj);
}


/**
 * Container listing possible values of a particuler Tracker metadata key.
 */
GType rygel_tracker_metadata_values_get_type (void) {
	static volatile gsize rygel_tracker_metadata_values_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_metadata_values_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMetadataValuesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_metadata_values_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMetadataValues), 0, (GInstanceInitFunc) rygel_tracker_metadata_values_instance_init, NULL };
		GType rygel_tracker_metadata_values_type_id;
		rygel_tracker_metadata_values_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerMetadataValues", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_tracker_metadata_values_type_id__volatile, rygel_tracker_metadata_values_type_id);
	}
	return rygel_tracker_metadata_values_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




