/* rygel-search-criteria-parser.c generated by valac, the Vala compiler
 * generated from rygel-search-criteria-parser.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_OPENNING_BRACE (rygel_openning_brace_get_type ())
#define RYGEL_OPENNING_BRACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OPENNING_BRACE, RygelOpenningBrace))
#define RYGEL_OPENNING_BRACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OPENNING_BRACE, RygelOpenningBraceClass))
#define RYGEL_IS_OPENNING_BRACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OPENNING_BRACE))
#define RYGEL_IS_OPENNING_BRACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OPENNING_BRACE))
#define RYGEL_OPENNING_BRACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OPENNING_BRACE, RygelOpenningBraceClass))

typedef struct _RygelOpenningBrace RygelOpenningBrace;
typedef struct _RygelOpenningBraceClass RygelOpenningBraceClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())
typedef struct _RygelSearchCriteriaParserRunData RygelSearchCriteriaParserRunData;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;
typedef struct _RygelOpenningBracePrivate RygelOpenningBracePrivate;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	char* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchCriteriaParserPrivate {
	GeeLinkedList* exp_stack;
	GCancellable* _cancellable;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;

struct _RygelSearchCriteriaParserRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchCriteriaParser* self;
	GUPnPSearchCriteriaParser* parser;
	GError* _tmp0_;
	GError * err;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

struct _RygelOpenningBrace {
	RygelSearchExpression parent_instance;
	RygelOpenningBracePrivate * priv;
};

struct _RygelOpenningBraceClass {
	RygelSearchExpressionClass parent_class;
};


static gpointer rygel_search_criteria_parser_parent_class = NULL;
static RygelStateMachineIface* rygel_search_criteria_parser_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_openning_brace_parent_class = NULL;

GType rygel_state_machine_get_type (void);
GType rygel_search_criteria_parser_get_type (void);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void);
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserPrivate))
enum  {
	RYGEL_SEARCH_CRITERIA_PARSER_DUMMY_PROPERTY,
	RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE
};
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const char* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const char* str, GError** error);
static void rygel_search_criteria_parser_real_run_data_free (gpointer _data);
static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_search_criteria_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_search_criteria_parser_on_expression (RygelSearchCriteriaParser* self, GUPnPSearchCriteriaParser* parser, const char* property, GUPnPSearchCriteriaOp op, const char* value, void* err);
static gboolean _rygel_search_criteria_parser_on_expression_gupnp_search_criteria_parser_expression (GUPnPSearchCriteriaParser* _sender, const char* property, GUPnPSearchCriteriaOp op, const char* value, void* _error_, gpointer self);
RygelOpenningBrace* rygel_openning_brace_new (void);
RygelOpenningBrace* rygel_openning_brace_construct (GType object_type);
GType rygel_openning_brace_get_type (void);
static void _lambda4_ (RygelSearchCriteriaParser* self);
static void __lambda4__gupnp_search_criteria_parser_begin_parens (GUPnPSearchCriteriaParser* _sender, gpointer self);
static void rygel_search_criteria_parser_on_end_parens (RygelSearchCriteriaParser* self, GUPnPSearchCriteriaParser* parser);
static void _rygel_search_criteria_parser_on_end_parens_gupnp_search_criteria_parser_end_parens (GUPnPSearchCriteriaParser* _sender, gpointer self);
GType rygel_logical_operator_get_type (void);
static void rygel_search_criteria_parser_handle_logical_operator (RygelSearchCriteriaParser* self, RygelLogicalOperator lop);
static void _lambda5_ (RygelSearchCriteriaParser* self);
static void __lambda5__gupnp_search_criteria_parser_conjunction (GUPnPSearchCriteriaParser* _sender, gpointer self);
static void _lambda6_ (RygelSearchCriteriaParser* self);
static void __lambda6__gupnp_search_criteria_parser_disjunction (GUPnPSearchCriteriaParser* _sender, gpointer self);
static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* data);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void);
GType rygel_media_object_get_type (void);
GType rygel_logical_expression_get_type (void);
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
static void rygel_search_criteria_parser_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_OPENNING_BRACE_DUMMY_PROPERTY
};
static gboolean rygel_openning_brace_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
static char* rygel_openning_brace_real_to_string (RygelSearchExpression* base);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const char* str, GError** error) {
	RygelSearchCriteriaParser * self;
	char* _tmp0_;
	GeeLinkedList* _tmp1_;
	g_return_val_if_fail (str != NULL, NULL);
	self = (RygelSearchCriteriaParser*) g_object_new (object_type, NULL);
	self->str = (_tmp0_ = g_strdup (str), _g_free0 (self->str), _tmp0_);
	self->priv->exp_stack = (_tmp1_ = gee_linked_list_new (RYGEL_TYPE_SEARCH_EXPRESSION, (GBoxedCopyFunc) rygel_search_expression_ref, rygel_search_expression_unref, NULL), _g_object_unref0 (self->priv->exp_stack), _tmp1_);
	return self;
}


RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const char* str, GError** error) {
	return rygel_search_criteria_parser_construct (RYGEL_TYPE_SEARCH_CRITERIA_PARSER, str, error);
}


static void rygel_search_criteria_parser_real_run_data_free (gpointer _data) {
	RygelSearchCriteriaParserRunData* data;
	data = _data;
	g_slice_free (RygelSearchCriteriaParserRunData, data);
}


static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchCriteriaParser * self;
	RygelSearchCriteriaParserRunData* _data_;
	self = (RygelSearchCriteriaParser*) base;
	_data_ = g_slice_new0 (RygelSearchCriteriaParserRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_criteria_parser_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_criteria_parser_real_run_data_free);
	_data_->self = self;
	rygel_search_criteria_parser_real_run_co (_data_);
}


static void rygel_search_criteria_parser_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_search_criteria_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchCriteriaParserRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_search_criteria_parser_real_run_co (data);
}


static gboolean _rygel_search_criteria_parser_on_expression_gupnp_search_criteria_parser_expression (GUPnPSearchCriteriaParser* _sender, const char* property, GUPnPSearchCriteriaOp op, const char* value, void* _error_, gpointer self) {
	return rygel_search_criteria_parser_on_expression (self, _sender, property, op, value, _error_);
}


static void _lambda4_ (RygelSearchCriteriaParser* self) {
	RygelOpenningBrace* _tmp0_;
	gee_deque_offer_tail ((GeeDeque*) self->priv->exp_stack, (RygelSearchExpression*) (_tmp0_ = rygel_openning_brace_new ()));
	_rygel_search_expression_unref0 (_tmp0_);
}


static void __lambda4__gupnp_search_criteria_parser_begin_parens (GUPnPSearchCriteriaParser* _sender, gpointer self) {
	_lambda4_ (self);
}


static void _rygel_search_criteria_parser_on_end_parens_gupnp_search_criteria_parser_end_parens (GUPnPSearchCriteriaParser* _sender, gpointer self) {
	rygel_search_criteria_parser_on_end_parens (self, _sender);
}


static void _lambda5_ (RygelSearchCriteriaParser* self) {
	rygel_search_criteria_parser_handle_logical_operator (self, RYGEL_LOGICAL_OPERATOR_AND);
}


static void __lambda5__gupnp_search_criteria_parser_conjunction (GUPnPSearchCriteriaParser* _sender, gpointer self) {
	_lambda5_ (self);
}


static void _lambda6_ (RygelSearchCriteriaParser* self) {
	rygel_search_criteria_parser_handle_logical_operator (self, RYGEL_LOGICAL_OPERATOR_OR);
}


static void __lambda6__gupnp_search_criteria_parser_disjunction (GUPnPSearchCriteriaParser* _sender, gpointer self) {
	_lambda6_ (self);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			if (_vala_strcmp0 (data->self->str, "*") == 0) {
				g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
			}
			data->parser = gupnp_search_criteria_parser_new ();
			g_signal_connect_object (data->parser, "expression", (GCallback) _rygel_search_criteria_parser_on_expression_gupnp_search_criteria_parser_expression, data->self, 0);
			g_signal_connect_object (data->parser, "begin-parens", (GCallback) __lambda4__gupnp_search_criteria_parser_begin_parens, data->self, 0);
			g_signal_connect_object (data->parser, "end-parens", (GCallback) _rygel_search_criteria_parser_on_end_parens_gupnp_search_criteria_parser_end_parens, data->self, 0);
			g_signal_connect_object (data->parser, "conjunction", (GCallback) __lambda5__gupnp_search_criteria_parser_conjunction, data->self, 0);
			g_signal_connect_object (data->parser, "disjunction", (GCallback) __lambda6__gupnp_search_criteria_parser_disjunction, data->self, 0);
			{
				gupnp_search_criteria_parser_parse_text (data->parser, data->self->str, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch42_g_error;
					goto __finally42;
				}
			}
			goto __finally42;
			__catch42_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					data->self->err = (data->_tmp0_ = _g_error_copy0 (data->err), _g_error_free0 (data->self->err), data->_tmp0_);
					_g_error_free0 (data->err);
				}
			}
			__finally42:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->parser);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, data->_inner_error_->message);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
			_g_object_unref0 (data->parser);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static gboolean rygel_search_criteria_parser_on_expression (RygelSearchCriteriaParser* self, GUPnPSearchCriteriaParser* parser, const char* property, GUPnPSearchCriteriaOp op, const char* value, void* err) {
	gboolean result;
	RygelRelationalExpression* expression;
	char* _tmp0_;
	char* _tmp1_;
	RygelSearchExpression* stack_top;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parser != NULL, FALSE);
	g_return_val_if_fail (property != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	expression = rygel_relational_expression_new ();
	((RygelSearchExpression*) expression)->op = GINT_TO_POINTER (op);
	((RygelSearchExpression*) expression)->operand1 = (_tmp0_ = g_strdup (property), _g_free0 (((RygelSearchExpression*) expression)->operand1), _tmp0_);
	((RygelSearchExpression*) expression)->operand2 = (_tmp1_ = g_strdup (value), _g_free0 (((RygelSearchExpression*) expression)->operand2), _tmp1_);
	stack_top = (RygelSearchExpression*) gee_deque_peek_tail ((GeeDeque*) self->priv->exp_stack);
	if (stack_top == NULL) {
		if (self->expression == NULL) {
			RygelSearchExpression* _tmp2_;
			self->expression = (_tmp2_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) expression), _rygel_search_expression_unref0 (self->expression), _tmp2_);
		} else {
			if (RYGEL_IS_LOGICAL_EXPRESSION (self->expression)) {
				RygelSearchExpression* _tmp3_;
				RygelLogicalExpression* l_expression;
				gboolean _tmp4_ = FALSE;
				RygelSearchExpression* _tmp7_;
				l_expression = _rygel_search_expression_ref0 ((_tmp3_ = self->expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp3_) ? ((RygelLogicalExpression*) _tmp3_) : NULL));
				if (((RygelSearchExpression*) ((RygelSearchExpression*) l_expression)->operand2) != NULL) {
					_tmp4_ = RYGEL_IS_LOGICAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) l_expression)->operand2);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					RygelLogicalExpression* _tmp6_;
					RygelSearchExpression* _tmp5_;
					l_expression = (_tmp6_ = _rygel_search_expression_ref0 ((_tmp5_ = (RygelSearchExpression*) ((RygelSearchExpression*) l_expression)->operand2, RYGEL_IS_LOGICAL_EXPRESSION (_tmp5_) ? ((RygelLogicalExpression*) _tmp5_) : NULL)), _rygel_search_expression_unref0 (l_expression), _tmp6_);
				}
				((RygelSearchExpression*) l_expression)->operand2 = (_tmp7_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) l_expression)->operand2), _tmp7_);
				_rygel_search_expression_unref0 (l_expression);
			}
		}
	} else {
		if (RYGEL_IS_OPENNING_BRACE (stack_top)) {
			gee_deque_offer_tail ((GeeDeque*) self->priv->exp_stack, (RygelSearchExpression*) expression);
		} else {
			if (RYGEL_IS_LOGICAL_EXPRESSION (stack_top)) {
				RygelSearchExpression* _tmp8_;
				RygelLogicalExpression* l_expression;
				RygelSearchExpression* _tmp9_;
				l_expression = _rygel_search_expression_ref0 ((_tmp8_ = stack_top, RYGEL_IS_LOGICAL_EXPRESSION (_tmp8_) ? ((RygelLogicalExpression*) _tmp8_) : NULL));
				((RygelSearchExpression*) l_expression)->operand2 = (_tmp9_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) l_expression)->operand2), _tmp9_);
				_rygel_search_expression_unref0 (l_expression);
			}
		}
	}
	result = TRUE;
	_rygel_search_expression_unref0 (expression);
	_rygel_search_expression_unref0 (stack_top);
	return result;
}


static void rygel_search_criteria_parser_handle_logical_operator (RygelSearchCriteriaParser* self, RygelLogicalOperator lop) {
	RygelLogicalExpression* expression;
	RygelSearchExpression* stack_top;
	g_return_if_fail (self != NULL);
	expression = rygel_logical_expression_new ();
	((RygelSearchExpression*) expression)->op = GINT_TO_POINTER (lop);
	stack_top = (RygelSearchExpression*) gee_deque_peek_tail ((GeeDeque*) self->priv->exp_stack);
	if (stack_top != NULL) {
		gboolean _tmp0_ = FALSE;
		if (lop == RYGEL_LOGICAL_OPERATOR_AND) {
			_tmp0_ = RYGEL_IS_LOGICAL_EXPRESSION (stack_top);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			RygelSearchExpression* _tmp1_;
			RygelLogicalExpression* previous;
			RygelSearchExpression* _tmp2_;
			RygelSearchExpression* _tmp3_;
			previous = _rygel_search_expression_ref0 ((_tmp1_ = stack_top, RYGEL_IS_LOGICAL_EXPRESSION (_tmp1_) ? ((RygelLogicalExpression*) _tmp1_) : NULL));
			((RygelSearchExpression*) expression)->operand1 = (_tmp2_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) ((RygelSearchExpression*) previous)->operand2), _rygel_search_expression_unref0 (((RygelSearchExpression*) expression)->operand1), _tmp2_);
			((RygelSearchExpression*) previous)->operand2 = (_tmp3_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) previous)->operand2), _tmp3_);
			_rygel_search_expression_unref0 (previous);
		} else {
			RygelSearchExpression* _tmp4_;
			RygelSearchExpression* _tmp5_;
			RygelSearchExpression* _tmp6_;
			_tmp4_ = (RygelSearchExpression*) gee_deque_poll_tail ((GeeDeque*) self->priv->exp_stack);
			_rygel_search_expression_unref0 (_tmp4_);
			_tmp5_ = (RygelSearchExpression*) gee_deque_poll_tail ((GeeDeque*) self->priv->exp_stack);
			_rygel_search_expression_unref0 (_tmp5_);
			gee_deque_offer_tail ((GeeDeque*) self->priv->exp_stack, (RygelSearchExpression*) expression);
			((RygelSearchExpression*) expression)->operand1 = (_tmp6_ = _rygel_search_expression_ref0 (stack_top), _rygel_search_expression_unref0 (((RygelSearchExpression*) expression)->operand1), _tmp6_);
		}
	} else {
		gboolean _tmp7_ = FALSE;
		if (lop == RYGEL_LOGICAL_OPERATOR_AND) {
			_tmp7_ = RYGEL_IS_LOGICAL_EXPRESSION (self->expression);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			RygelSearchExpression* _tmp8_;
			RygelLogicalExpression* previous;
			RygelSearchExpression* _tmp9_;
			RygelSearchExpression* _tmp10_;
			previous = _rygel_search_expression_ref0 ((_tmp8_ = self->expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp8_) ? ((RygelLogicalExpression*) _tmp8_) : NULL));
			((RygelSearchExpression*) expression)->operand1 = (_tmp9_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) ((RygelSearchExpression*) previous)->operand2), _rygel_search_expression_unref0 (((RygelSearchExpression*) expression)->operand1), _tmp9_);
			((RygelSearchExpression*) previous)->operand2 = (_tmp10_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) previous)->operand2), _tmp10_);
			_rygel_search_expression_unref0 (previous);
		} else {
			RygelSearchExpression* _tmp11_;
			RygelSearchExpression* _tmp12_;
			((RygelSearchExpression*) expression)->operand1 = (_tmp11_ = _rygel_search_expression_ref0 (self->expression), _rygel_search_expression_unref0 (((RygelSearchExpression*) expression)->operand1), _tmp11_);
			self->expression = (_tmp12_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) expression), _rygel_search_expression_unref0 (self->expression), _tmp12_);
		}
	}
	_rygel_search_expression_unref0 (expression);
	_rygel_search_expression_unref0 (stack_top);
}


static void rygel_search_criteria_parser_on_end_parens (RygelSearchCriteriaParser* self, GUPnPSearchCriteriaParser* parser) {
	RygelSearchExpression* inner_exp;
	RygelSearchExpression* _tmp0_;
	RygelLogicalExpression* outer_exp;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	inner_exp = (RygelSearchExpression*) gee_deque_poll_tail ((GeeDeque*) self->priv->exp_stack);
	outer_exp = (_tmp0_ = (RygelSearchExpression*) gee_deque_peek_tail ((GeeDeque*) self->priv->exp_stack), RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL);
	if (outer_exp == NULL) {
		if (self->expression != NULL) {
			RygelLogicalExpression* _tmp2_;
			RygelSearchExpression* _tmp1_;
			outer_exp = (_tmp2_ = _rygel_search_expression_ref0 ((_tmp1_ = self->expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp1_) ? ((RygelLogicalExpression*) _tmp1_) : NULL)), _rygel_search_expression_unref0 (outer_exp), _tmp2_);
		} else {
			RygelSearchExpression* _tmp3_;
			self->expression = (_tmp3_ = _rygel_search_expression_ref0 (inner_exp), _rygel_search_expression_unref0 (self->expression), _tmp3_);
		}
	}
	if (outer_exp != NULL) {
		RygelSearchExpression* _tmp4_;
		((RygelSearchExpression*) outer_exp)->operand2 = (_tmp4_ = _rygel_search_expression_ref0 (inner_exp), _rygel_search_expression_unref0 (((RygelSearchExpression*) outer_exp)->operand2), _tmp4_);
	}
	_rygel_search_expression_unref0 (inner_exp);
	_rygel_search_expression_unref0 (outer_exp);
}


static GCancellable* rygel_search_criteria_parser_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelSearchCriteriaParser* self;
	self = (RygelSearchCriteriaParser*) base;
	result = self->priv->_cancellable;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_search_criteria_parser_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelSearchCriteriaParser* self;
	GCancellable* _tmp0_;
	self = (RygelSearchCriteriaParser*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_search_criteria_parser_class_init (RygelSearchCriteriaParserClass * klass) {
	rygel_search_criteria_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSearchCriteriaParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_search_criteria_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_search_criteria_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_criteria_parser_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE, "cancellable");
}


static void rygel_search_criteria_parser_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_search_criteria_parser_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_search_criteria_parser_real_run;
	iface->run_finish = rygel_search_criteria_parser_real_run_finish;
	iface->get_cancellable = rygel_search_criteria_parser_real_get_cancellable;
	iface->set_cancellable = rygel_search_criteria_parser_real_set_cancellable;
}


static void rygel_search_criteria_parser_instance_init (RygelSearchCriteriaParser * self) {
	self->priv = RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE (self);
}


static void rygel_search_criteria_parser_finalize (GObject* obj) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (obj);
	_g_free0 (self->str);
	_rygel_search_expression_unref0 (self->expression);
	_g_error_free0 (self->err);
	_g_object_unref0 (self->priv->exp_stack);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_search_criteria_parser_parent_class)->finalize (obj);
}


GType rygel_search_criteria_parser_get_type (void) {
	static GType rygel_search_criteria_parser_type_id = 0;
	if (rygel_search_criteria_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchCriteriaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_criteria_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearchCriteriaParser), 0, (GInstanceInitFunc) rygel_search_criteria_parser_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_search_criteria_parser_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		rygel_search_criteria_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSearchCriteriaParser", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_search_criteria_parser_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	}
	return rygel_search_criteria_parser_type_id;
}


static void rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (object);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (object);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean rygel_openning_brace_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
	RygelOpenningBrace * self;
	self = (RygelOpenningBrace*) base;
	g_return_val_if_fail (media_object != NULL, FALSE);
	g_assert_not_reached ();
}


static char* rygel_openning_brace_real_to_string (RygelSearchExpression* base) {
	RygelOpenningBrace * self;
	self = (RygelOpenningBrace*) base;
	g_assert_not_reached ();
}


RygelOpenningBrace* rygel_openning_brace_construct (GType object_type) {
	RygelOpenningBrace* self;
	self = (RygelOpenningBrace*) rygel_search_expression_construct (object_type, G_TYPE_POINTER, NULL, NULL, G_TYPE_POINTER, NULL, NULL, G_TYPE_POINTER, NULL, NULL);
	return self;
}


RygelOpenningBrace* rygel_openning_brace_new (void) {
	return rygel_openning_brace_construct (RYGEL_TYPE_OPENNING_BRACE);
}


static void rygel_openning_brace_class_init (RygelOpenningBraceClass * klass) {
	rygel_openning_brace_parent_class = g_type_class_peek_parent (klass);
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->satisfied_by = rygel_openning_brace_real_satisfied_by;
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->to_string = rygel_openning_brace_real_to_string;
}


static void rygel_openning_brace_instance_init (RygelOpenningBrace * self) {
}


GType rygel_openning_brace_get_type (void) {
	static GType rygel_openning_brace_type_id = 0;
	if (rygel_openning_brace_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelOpenningBraceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_openning_brace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelOpenningBrace), 0, (GInstanceInitFunc) rygel_openning_brace_instance_init, NULL };
		rygel_openning_brace_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelOpenningBrace", &g_define_type_info, 0);
	}
	return rygel_openning_brace_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




