/* rygel-media-db-container.c generated by valac, the Vala compiler
 * generated from rygel-media-db-container.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_DB_CONTAINER (rygel_media_db_container_get_type ())
#define RYGEL_MEDIA_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainer))
#define RYGEL_MEDIA_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainerClass))
#define RYGEL_IS_MEDIA_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER))
#define RYGEL_IS_MEDIA_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB_CONTAINER))
#define RYGEL_MEDIA_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainerClass))

typedef struct _RygelMediaDBContainer RygelMediaDBContainer;
typedef struct _RygelMediaDBContainerClass RygelMediaDBContainerClass;
typedef struct _RygelMediaDBContainerPrivate RygelMediaDBContainerPrivate;

#define RYGEL_TYPE_MEDIA_DB (rygel_media_db_get_type ())
#define RYGEL_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDB))
#define RYGEL_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))
#define RYGEL_IS_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_IS_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_MEDIA_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))

typedef struct _RygelMediaDB RygelMediaDB;
typedef struct _RygelMediaDBClass RygelMediaDBClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaDbContainerGetChildrenData RygelMediaDbContainerGetChildrenData;
typedef struct _RygelMediaDbContainerFindObjectData RygelMediaDbContainerFindObjectData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaDBContainerPrivate * priv;
	RygelMediaDB* media_db;
};

struct _RygelMediaDBContainerClass {
	RygelMediaContainerClass parent_class;
};

typedef enum  {
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
struct _RygelMediaDbContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaDBContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	GeeArrayList* children;
	GeeIterator* _child_it;
	RygelMediaObject* child;
	GError * _inner_error_;
};

struct _RygelMediaDbContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaDBContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* _tmp0_;
	GError * _inner_error_;
};


static gpointer rygel_media_db_container_parent_class = NULL;

GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_media_db_container_get_type (void);
GType rygel_media_db_get_type (void);
enum  {
	RYGEL_MEDIA_DB_CONTAINER_DUMMY_PROPERTY
};
GQuark rygel_database_error_quark (void);
gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error);
RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, guint child_count);
static void rygel_media_db_container_on_db_container_updated (RygelMediaDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated);
static void _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
RygelMediaDBContainer* rygel_media_db_container_new (RygelMediaDB* media_db, const char* id, const char* title);
RygelMediaDBContainer* rygel_media_db_container_construct (GType object_type, RygelMediaDB* media_db, const char* id, const char* title);
static void rygel_media_db_container_real_get_children_data_free (gpointer _data);
static void rygel_media_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_db_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error);
static gboolean rygel_media_db_container_real_get_children_co (RygelMediaDbContainerGetChildrenData* data);
static void rygel_media_db_container_real_find_object_data_free (gpointer _data);
static void rygel_media_db_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_db_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaObject* rygel_media_db_get_object (RygelMediaDB* self, const char* object_id, GError** error);
static gboolean rygel_media_db_container_real_find_object_co (RygelMediaDbContainerFindObjectData* data);
static void rygel_media_db_container_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	rygel_media_db_container_on_db_container_updated (self, _sender, container);
}


RygelMediaDBContainer* rygel_media_db_container_construct (GType object_type, RygelMediaDB* media_db, const char* id, const char* title) {
	GError * _inner_error_;
	RygelMediaDBContainer * self;
	gint count = 0;
	RygelMediaDB* _tmp1_;
	g_return_val_if_fail (media_db != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_inner_error_ = NULL;
	{
		gint _tmp0_;
		_tmp0_ = rygel_media_db_get_child_count (media_db, id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch54_rygel_database_error;
			}
			goto __finally54;
		}
		count = _tmp0_;
	}
	goto __finally54;
	__catch54_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_debug ("rygel-media-db-container.vala:31: Could not get child count from database: %s", e->message);
			count = 0;
			_g_error_free0 (e);
		}
	}
	__finally54:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self = (RygelMediaDBContainer*) rygel_media_container_construct (object_type, id, NULL, title, (guint) count);
	self->media_db = (_tmp1_ = _g_object_ref0 (media_db), _g_object_unref0 (self->media_db), _tmp1_);
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated, self, 0);
	return self;
}


RygelMediaDBContainer* rygel_media_db_container_new (RygelMediaDB* media_db, const char* id, const char* title) {
	return rygel_media_db_container_construct (RYGEL_TYPE_MEDIA_DB_CONTAINER, media_db, id, title);
}


static void rygel_media_db_container_on_db_container_updated (RygelMediaDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (container_updated != NULL);
	_inner_error_ = NULL;
	{
		gint _tmp0_;
		_tmp0_ = rygel_media_db_get_child_count (self->media_db, ((RygelMediaObject*) self)->id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			goto __finally55;
		}
		((RygelMediaContainer*) self)->child_count = (guint) _tmp0_;
	}
	goto __finally55;
	__catch55_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_debug ("rygel-media-db-container.vala:46: Could not get child count from database: %s", e->message);
			((RygelMediaContainer*) self)->child_count = (guint) 0;
			_g_error_free0 (e);
		}
	}
	__finally55:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_db_container_real_get_children_data_free (gpointer _data) {
	RygelMediaDbContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelMediaDbContainerGetChildrenData, data);
}


static void rygel_media_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaDBContainer * self;
	RygelMediaDbContainerGetChildrenData* _data_;
	self = (RygelMediaDBContainer*) base;
	_data_ = g_slice_new0 (RygelMediaDbContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_db_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_db_container_real_get_children_data_free);
	_data_->self = self;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_db_container_real_get_children_co (_data_);
}


static GeeList* rygel_media_db_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelMediaDbContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_db_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaDbContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_db_container_real_get_children_co (data);
}


static gboolean rygel_media_db_container_real_get_children_co (RygelMediaDbContainerGetChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->children = rygel_media_db_get_children (data->self->media_db, ((RygelMediaObject*) data->self)->id, (glong) data->offset, (glong) data->max_count, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			{
				data->_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->children);
				while (TRUE) {
					if (!gee_iterator_next (data->_child_it)) {
						break;
					}
					data->child = (RygelMediaObject*) gee_iterator_get (data->_child_it);
					data->child->parent = (RygelMediaContainer*) data->self;
					_g_object_unref0 (data->child);
				}
				_g_object_unref0 (data->_child_it);
			}
			data->result = (GeeList*) data->children;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->children);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_media_db_container_real_find_object_data_free (gpointer _data) {
	RygelMediaDbContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelMediaDbContainerFindObjectData, data);
}


static void rygel_media_db_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaDBContainer * self;
	RygelMediaDbContainerFindObjectData* _data_;
	self = (RygelMediaDBContainer*) base;
	_data_ = g_slice_new0 (RygelMediaDbContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_db_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_db_container_real_find_object_data_free);
	_data_->self = self;
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_db_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_db_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaDbContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_db_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaDbContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_db_container_real_find_object_co (data);
}


static gboolean rygel_media_db_container_real_find_object_co (RygelMediaDbContainerFindObjectData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->_tmp0_ = rygel_media_db_get_object (data->self->media_db, data->id, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp0_;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_media_db_container_class_init (RygelMediaDBContainerClass * klass) {
	rygel_media_db_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_db_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_db_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_db_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_db_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_db_container_finalize;
}


static void rygel_media_db_container_instance_init (RygelMediaDBContainer * self) {
}


static void rygel_media_db_container_finalize (GObject* obj) {
	RygelMediaDBContainer * self;
	self = RYGEL_MEDIA_DB_CONTAINER (obj);
	_g_object_unref0 (self->media_db);
	G_OBJECT_CLASS (rygel_media_db_container_parent_class)->finalize (obj);
}


GType rygel_media_db_container_get_type (void) {
	static GType rygel_media_db_container_type_id = 0;
	if (rygel_media_db_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDBContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_db_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDBContainer), 0, (GInstanceInitFunc) rygel_media_db_container_instance_init, NULL };
		rygel_media_db_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelMediaDBContainer", &g_define_type_info, 0);
	}
	return rygel_media_db_container_type_id;
}




