/* rygel-gst-sink.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-gst-sink.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gst/base/base.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <rygel-server.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
enum  {
	RYGEL_GST_SINK_0_PROPERTY,
	RYGEL_GST_SINK_NUM_PROPERTIES
};
static GParamSpec* rygel_gst_sink_properties[RYGEL_GST_SINK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

struct _RygelGstSinkPrivate {
	gint priority;
	gint64 bytes_sent;
	gint64 max_bytes;
	GMutex buffer_mutex;
	GCond buffer_condition;
	RygelDataSource* source;
	RygelHTTPSeekRequest* offsets;
	gboolean frozen;
};

struct _Block2Data {
	int _ref_count_;
	RygelGstSink* self;
	GstBuffer* buffer;
};

static gint RygelGstSink_private_offset;
static gpointer rygel_gst_sink_parent_class = NULL;

GType rygel_gst_sink_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelGstSink, g_object_unref)
#define RYGEL_GST_SINK_NAME "http-gst-sink"
#define RYGEL_GST_SINK_PAD_NAME "sink"
#define RYGEL_GST_SINK_MAX_BUFFERED_CHUNKS ((guint) 32)
#define RYGEL_GST_SINK_MIN_BUFFERED_CHUNKS ((guint) 4)
RygelGstSink* rygel_gst_sink_new (RygelDataSource* source,
                                  RygelHTTPSeekRequest* offsets);
RygelGstSink* rygel_gst_sink_construct (GType object_type,
                                        RygelDataSource* source,
                                        RygelHTTPSeekRequest* offsets);
static void rygel_gst_sink_on_cancelled (RygelGstSink* self);
static void _rygel_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                           gpointer self);
void rygel_gst_sink_freeze (RygelGstSink* self);
void rygel_gst_sink_thaw (RygelGstSink* self);
static GstFlowReturn rygel_gst_sink_real_render (GstBaseSink* base,
                                          GstBuffer* buffer);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block2Data* _data2_);
gboolean rygel_gst_sink_push_data (RygelGstSink* self,
                                   GstBuffer* buffer);
static gboolean ___lambda4__gsource_func (gpointer self);
static void rygel_gst_sink_finalize (GObject * obj);
static GType rygel_gst_sink_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
rygel_gst_sink_get_instance_private (RygelGstSink* self)
{
	return G_STRUCT_MEMBER_P (self, RygelGstSink_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_rygel_gst_sink_on_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                      gpointer self)
{
	rygel_gst_sink_on_cancelled ((RygelGstSink*) self);
}

RygelGstSink*
rygel_gst_sink_construct (GType object_type,
                          RygelDataSource* source,
                          RygelHTTPSeekRequest* offsets)
{
	RygelGstSink * self = NULL;
	RygelHTTPSeekRequest* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	RygelHTTPSeekRequest* _tmp3_;
	GCancellable* _tmp8_;
	g_return_val_if_fail (source != NULL, NULL);
	self = (RygelGstSink*) g_object_new (object_type, NULL);
	self->priv->bytes_sent = (gint64) 0;
	self->priv->max_bytes = G_MAXINT64;
	self->priv->source = source;
	_tmp0_ = _g_object_ref0 (offsets);
	_g_object_unref0 (self->priv->offsets);
	self->priv->offsets = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp1_;
	gst_base_sink_set_sync ((GstBaseSink*) self, FALSE);
	gst_object_set_name ((GstObject*) self, RYGEL_GST_SINK_NAME);
	self->priv->frozen = FALSE;
	_tmp3_ = self->priv->offsets;
	if (_tmp3_ != NULL) {
		RygelHTTPSeekRequest* _tmp4_;
		_tmp4_ = self->priv->offsets;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		RygelHTTPSeekRequest* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		_tmp5_ = self->priv->offsets;
		_tmp6_ = rygel_http_byte_seek_request_get_total_size (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp5_) : NULL);
		_tmp7_ = _tmp6_;
		self->priv->max_bytes = _tmp7_;
		if (self->priv->max_bytes == ((gint64) -1)) {
			self->priv->max_bytes = G_MAXINT64;
		}
	}
	_tmp8_ = self->cancellable;
	g_signal_connect_object (_tmp8_, "cancelled", (GCallback) _rygel_gst_sink_on_cancelled_g_cancellable_cancelled, self, 0);
	return self;
}

RygelGstSink*
rygel_gst_sink_new (RygelDataSource* source,
                    RygelHTTPSeekRequest* offsets)
{
	return rygel_gst_sink_construct (RYGEL_TYPE_GST_SINK, source, offsets);
}

void
rygel_gst_sink_freeze (RygelGstSink* self)
{
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->buffer_mutex);
	if (!self->priv->frozen) {
		self->priv->frozen = TRUE;
	}
	g_mutex_unlock (&self->priv->buffer_mutex);
}

void
rygel_gst_sink_thaw (RygelGstSink* self)
{
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->buffer_mutex);
	if (self->priv->frozen) {
		self->priv->frozen = FALSE;
		g_cond_broadcast (&self->priv->buffer_condition);
	}
	g_mutex_unlock (&self->priv->buffer_mutex);
}

static gpointer
_gst_buffer_ref0 (gpointer self)
{
	return self ? gst_buffer_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelGstSink* self;
		self = _data2_->self;
		_gst_buffer_unref0 (_data2_->buffer);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda4_ (Block2Data* _data2_)
{
	RygelGstSink* self;
	gboolean result = FALSE;
	self = _data2_->self;
	result = rygel_gst_sink_push_data (self, _data2_->buffer);
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

static GstFlowReturn
rygel_gst_sink_real_render (GstBaseSink* base,
                            GstBuffer* buffer)
{
	RygelGstSink * self;
	Block2Data* _data2_;
	GstBuffer* _tmp0_;
	GCancellable* _tmp3_;
	GstFlowReturn result = 0;
	self = (RygelGstSink*) base;
	g_return_val_if_fail (buffer != NULL, 0);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _gst_buffer_ref0 (buffer);
	_gst_buffer_unref0 (_data2_->buffer);
	_data2_->buffer = _tmp0_;
	g_mutex_lock (&self->priv->buffer_mutex);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		GCancellable* _tmp2_;
		_tmp2_ = self->cancellable;
		if (!g_cancellable_is_cancelled (_tmp2_)) {
			_tmp1_ = self->priv->frozen;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		g_cond_wait (&self->priv->buffer_condition, &self->priv->buffer_mutex);
	}
	g_mutex_unlock (&self->priv->buffer_mutex);
	_tmp3_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp3_)) {
		result = GST_FLOW_OK;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	g_idle_add_full (self->priv->priority, ___lambda4__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	result = GST_FLOW_OK;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

gboolean
rygel_gst_sink_push_data (RygelGstSink* self,
                          GstBuffer* buffer)
{
	gint64 left = 0LL;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	gsize bufsize = 0UL;
	gint64 to_send = 0LL;
	GstMapInfo info = {0};
	GstMapInfo _tmp2_ = {0};
	guint8* tmp = NULL;
	GstMapInfo _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint tmp_length1;
	gint _tmp_size_;
	RygelDataSource* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GstMapInfo _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (buffer != NULL, FALSE);
	left = self->priv->max_bytes - self->priv->bytes_sent;
	_tmp1_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = left <= ((gint64) 0);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	bufsize = gst_buffer_get_size (buffer);
	to_send = MIN ((gint64) bufsize, left);
	gst_buffer_map (buffer, &_tmp2_, GST_MAP_READ);
	info = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = _tmp3_.data;
	_tmp4__length1 = _tmp3_.size;
	tmp = _tmp4_ + 0;
	tmp_length1 = ((gint) to_send) - 0;
	_tmp_size_ = tmp_length1;
	_tmp5_ = self->priv->source;
	_tmp6_ = tmp;
	_tmp6__length1 = tmp_length1;
	g_signal_emit_by_name (_tmp5_, "data-available", _tmp6_, (gint) _tmp6__length1);
	self->priv->bytes_sent = self->priv->bytes_sent + to_send;
	_tmp7_ = info;
	gst_buffer_unmap (buffer, &_tmp7_);
	result = FALSE;
	return result;
}

static void
rygel_gst_sink_on_cancelled (RygelGstSink* self)
{
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->buffer_mutex);
	g_cond_broadcast (&self->priv->buffer_condition);
	g_mutex_unlock (&self->priv->buffer_mutex);
}

static void
rygel_gst_sink_class_init (RygelGstSinkClass * klass,
                           gpointer klass_data)
{
	GstCaps* caps = NULL;
	GstCaps* _tmp0_;
	GstPadTemplate* template = NULL;
	GstCaps* _tmp1_;
	GstPadTemplate* _tmp2_;
	GstPadTemplate* _tmp3_;
	rygel_gst_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelGstSink_private_offset);
	((GstBaseSinkClass *) klass)->render = (GstFlowReturn (*) (GstBaseSink*, GstBuffer*)) rygel_gst_sink_real_render;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_sink_finalize;
	_tmp0_ = gst_caps_new_any ();
	caps = _tmp0_;
	_tmp1_ = caps;
	_tmp2_ = gst_pad_template_new (RYGEL_GST_SINK_PAD_NAME, GST_PAD_SINK, GST_PAD_ALWAYS, _tmp1_);
	g_object_ref_sink (_tmp2_);
	template = _tmp2_;
	_tmp3_ = template;
	gst_element_class_add_pad_template (GST_ELEMENT_CLASS (klass), _tmp3_);
	_g_object_unref0 (template);
	_gst_caps_unref0 (caps);
}

static void
rygel_gst_sink_instance_init (RygelGstSink * self,
                              gpointer klass)
{
	self->priv = rygel_gst_sink_get_instance_private (self);
	g_mutex_init (&self->priv->buffer_mutex);
	g_cond_init (&self->priv->buffer_condition);
}

static void
rygel_gst_sink_finalize (GObject * obj)
{
	RygelGstSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_SINK, RygelGstSink);
	_g_object_unref0 (self->cancellable);
	_vala_clear_GMutex (&self->priv->buffer_mutex);
	_vala_clear_GCond (&self->priv->buffer_condition);
	_g_object_unref0 (self->priv->offsets);
	G_OBJECT_CLASS (rygel_gst_sink_parent_class)->finalize (obj);
}

static GType
rygel_gst_sink_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelGstSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstSink), 0, (GInstanceInitFunc) rygel_gst_sink_instance_init, NULL };
	GType rygel_gst_sink_type_id;
	rygel_gst_sink_type_id = g_type_register_static (gst_base_sink_get_type (), "RygelGstSink", &g_define_type_info, 0);
	RygelGstSink_private_offset = g_type_add_instance_private (rygel_gst_sink_type_id, sizeof (RygelGstSinkPrivate));
	return rygel_gst_sink_type_id;
}

GType
rygel_gst_sink_get_type (void)
{
	static volatile gsize rygel_gst_sink_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_sink_type_id__volatile)) {
		GType rygel_gst_sink_type_id;
		rygel_gst_sink_type_id = rygel_gst_sink_get_type_once ();
		g_once_init_leave (&rygel_gst_sink_type_id__volatile, rygel_gst_sink_type_id);
	}
	return rygel_gst_sink_type_id__volatile;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

