/* rygel-default-player-controller.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-default-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Atlantic PuffinPack AB.
 *
 * Author: Richard Röjfors <richard@puffinpack.se>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;

#define RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER (rygel_default_player_controller_get_type ())
#define RYGEL_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))

typedef struct _RygelDefaultPlayerController RygelDefaultPlayerController;
typedef struct _RygelDefaultPlayerControllerClass RygelDefaultPlayerControllerClass;
typedef struct _RygelDefaultPlayerControllerPrivate RygelDefaultPlayerControllerPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
enum  {
	RYGEL_DEFAULT_PLAYER_CONTROLLER_0_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_URI_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_CAN_PAUSE_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE_PROPERTY,
	RYGEL_DEFAULT_PLAYER_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
	gboolean (*get_can_pause) (RygelPlayerController* self);
};

struct _RygelDefaultPlayerController {
	GObject parent_instance;
	RygelDefaultPlayerControllerPrivate * priv;
};

struct _RygelDefaultPlayerControllerClass {
	GObjectClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, gint* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, gint* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, gint* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
	gchar* (*get_user_agent) (RygelMediaPlayer* self);
	void (*set_user_agent) (RygelMediaPlayer* self, const gchar* value);
};

struct _RygelDefaultPlayerControllerPrivate {
	RygelMediaPlayer* _player;
	gchar* _protocol_info;
	gchar* _uri;
	gchar* _metadata;
	gchar* _next_uri;
	gchar* _next_metadata;
	GList* playlist;
	guint timeout_id;
	guint default_image_timeout;
	RygelConfiguration* config;
	gchar* next_features;
	gchar* next_mime;
	GUPnPMediaCollection* next_collection;
	guint _n_tracks;
	guint _track;
	gchar* _playback_state;
	gchar* _play_mode;
};

static gint RygelDefaultPlayerController_private_offset;
static gpointer rygel_default_player_controller_parent_class = NULL;
static RygelPlayerControllerIface * rygel_default_player_controller_rygel_player_controller_parent_iface = NULL;

GType rygel_player_controller_get_type (void) G_GNUC_CONST;
GType rygel_default_player_controller_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelDefaultPlayerController, g_object_unref)
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT 15
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION "Renderer"
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY "image-timeout"
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE "<DIDL-Lite " "xmlns:dc=\"http://purl.org/dc/elements/1.1/\" " "xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" " "xmlns:dlna=\"urn:schemas-dlna-org:metadata-1-0/\" " "xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\">" "%s</DIDL-Lite>"
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
RygelDefaultPlayerController* rygel_default_player_controller_new (RygelMediaPlayer* player,
                                                                   const gchar* protocol_info);
RygelDefaultPlayerController* rygel_default_player_controller_construct (GType object_type,
                                                                         RygelMediaPlayer* player,
                                                                         const gchar* protocol_info);
static void rygel_default_player_controller_real_constructed (GObject* base);
static RygelMediaPlayer* rygel_default_player_controller_get_player (RygelDefaultPlayerController* self);
static void rygel_default_player_controller_notify_state_cb (RygelDefaultPlayerController* self,
                                                      GObject* player,
                                                      GParamSpec* p);
static void _rygel_default_player_controller_notify_state_cb_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static void rygel_default_player_controller_notify_uri_cb (RygelDefaultPlayerController* self,
                                                    GObject* player,
                                                    GParamSpec* p);
static void _rygel_default_player_controller_notify_uri_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void rygel_default_player_controller_notify_metadata_cb (RygelDefaultPlayerController* self,
                                                         GObject* player,
                                                         GParamSpec* p);
static void _rygel_default_player_controller_notify_metadata_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void rygel_default_player_controller_on_setting_changed (RygelDefaultPlayerController* self,
                                                         const gchar* section,
                                                         const gchar* key);
static void _rygel_default_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                              const gchar* section,
                                                                                              const gchar* key,
                                                                                              gpointer self);
static gboolean rygel_default_player_controller_real_next (RygelPlayerController* base);
guint rygel_player_controller_get_track (RygelPlayerController* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
void rygel_player_controller_set_track (RygelPlayerController* self,
                                        guint value);
gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self);
void rygel_player_controller_set_playlist_uri (RygelPlayerController* self,
                                               const gchar* uri,
                                               const gchar* metadata,
                                               GUPnPMediaCollection* collection);
gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self);
void rygel_player_controller_set_single_play_uri (RygelPlayerController* self,
                                                  const gchar* uri,
                                                  const gchar* metadata,
                                                  const gchar* mime,
                                                  const gchar* features);
void rygel_player_controller_set_next_uri (RygelPlayerController* self,
                                           const gchar* value);
void rygel_player_controller_set_next_metadata (RygelPlayerController* self,
                                                const gchar* value);
static gboolean rygel_default_player_controller_real_previous (RygelPlayerController* base);
static void rygel_default_player_controller_real_set_single_play_uri (RygelPlayerController* base,
                                                               const gchar* uri,
                                                               const gchar* metadata,
                                                               const gchar* mime,
                                                               const gchar* features);
gchar* rygel_player_controller_unescape (RygelPlayerController* self,
                                         const gchar* input);
void rygel_player_controller_set_metadata (RygelPlayerController* self,
                                           const gchar* value);
void rygel_player_controller_set_uri (RygelPlayerController* self,
                                      const gchar* value);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self,
                                       const gchar* value);
void rygel_media_player_set_content_features (RygelMediaPlayer* self,
                                              const gchar* value);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
void rygel_player_controller_set_track_metadata (RygelPlayerController* self,
                                                 const gchar* value);
gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
void rygel_player_controller_set_track_uri (RygelPlayerController* self,
                                            const gchar* value);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self,
                                           guint value);
static void rygel_default_player_controller_real_set_playlist_uri (RygelPlayerController* base,
                                                            const gchar* uri,
                                                            const gchar* metadata,
                                                            GUPnPMediaCollection* collection);
static void rygel_default_player_controller_apply_track (RygelDefaultPlayerController* self);
static void rygel_default_player_controller_real_set_next_single_play_uri (RygelPlayerController* base,
                                                                    const gchar* uri,
                                                                    const gchar* metadata,
                                                                    const gchar* mime,
                                                                    const gchar* features);
static void rygel_default_player_controller_real_set_next_playlist_uri (RygelPlayerController* base,
                                                                 const gchar* uri,
                                                                 const gchar* metadata,
                                                                 GUPnPMediaCollection* collection);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
static gboolean ___lambda5_ (RygelDefaultPlayerController* self);
gboolean rygel_player_controller_next (RygelPlayerController* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self,
                                                 const gchar* value);
static gboolean ____lambda5__gsource_func (gpointer self);
static void rygel_default_player_controller_setup_image_timeout (RygelDefaultPlayerController* self);
static gboolean rygel_default_player_controller_real_is_play_mode_valid (RygelPlayerController* base,
                                                                  const gchar* play_mode);
static const gchar* rygel_default_player_controller_get_protocol_info (RygelDefaultPlayerController* self);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
static gboolean __lambda6_ (RygelDefaultPlayerController* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void rygel_default_player_controller_set_player (RygelDefaultPlayerController* self,
                                                 RygelMediaPlayer* value);
static void rygel_default_player_controller_set_protocol_info (RygelDefaultPlayerController* self,
                                                        const gchar* value);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self,
                                            const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self,
                                 const gchar* value);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self,
                                      const gchar* value);
gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self,
                                                        gint* result_length1);
static void rygel_default_player_controller_finalize (GObject * obj);
static GType rygel_default_player_controller_get_type_once (void);
gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self);
gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self);
gboolean rygel_player_controller_get_can_pause (RygelPlayerController* self);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_player_controller_get_play_mode (RygelPlayerController* self);
static void _vala_rygel_default_player_controller_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
void rygel_player_controller_set_play_mode (RygelPlayerController* self,
                                            const gchar* value);
static void _vala_rygel_default_player_controller_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_default_player_controller_get_instance_private (RygelDefaultPlayerController* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDefaultPlayerController_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

RygelDefaultPlayerController*
rygel_default_player_controller_construct (GType object_type,
                                           RygelMediaPlayer* player,
                                           const gchar* protocol_info)
{
	RygelDefaultPlayerController * self = NULL;
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (protocol_info != NULL, NULL);
	self = (RygelDefaultPlayerController*) g_object_new (object_type, "player", player, "protocol-info", protocol_info, NULL);
	return self;
}

RygelDefaultPlayerController*
rygel_default_player_controller_new (RygelMediaPlayer* player,
                                     const gchar* protocol_info)
{
	return rygel_default_player_controller_construct (RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, player, protocol_info);
}

static void
_rygel_default_player_controller_notify_state_cb_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	rygel_default_player_controller_notify_state_cb ((RygelDefaultPlayerController*) self, _sender, pspec);
}

static void
_rygel_default_player_controller_notify_uri_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	rygel_default_player_controller_notify_uri_cb ((RygelDefaultPlayerController*) self, _sender, pspec);
}

static void
_rygel_default_player_controller_notify_metadata_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	rygel_default_player_controller_notify_metadata_cb ((RygelDefaultPlayerController*) self, _sender, pspec);
}

static void
_rygel_default_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                         const gchar* section,
                                                                                         const gchar* key,
                                                                                         gpointer self)
{
	rygel_default_player_controller_on_setting_changed ((RygelDefaultPlayerController*) self, section, key);
}

static void
rygel_default_player_controller_real_constructed (GObject* base)
{
	RygelDefaultPlayerController * self;
	RygelMediaPlayer* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	RygelMediaPlayer* _tmp2_;
	RygelMetaConfig* _tmp3_;
	RygelConfiguration* _tmp4_;
	self = (RygelDefaultPlayerController*) base;
	G_OBJECT_CLASS (rygel_default_player_controller_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::playback-state", (GCallback) _rygel_default_player_controller_notify_state_cb_g_object_notify, self, 0);
	_tmp1_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::uri", (GCallback) _rygel_default_player_controller_notify_uri_cb_g_object_notify, self, 0);
	_tmp2_ = self->priv->_player;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::metadata", (GCallback) _rygel_default_player_controller_notify_metadata_cb_g_object_notify, self, 0);
	_tmp3_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp3_;
	_tmp4_ = self->priv->config;
	g_signal_connect_object (_tmp4_, "setting-changed", (GCallback) _rygel_default_player_controller_on_setting_changed_rygel_configuration_setting_changed, self, 0);
	self->priv->default_image_timeout = (guint) RYGEL_DEFAULT_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
	rygel_default_player_controller_on_setting_changed (self, RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY);
}

static gboolean
rygel_default_player_controller_real_next (RygelPlayerController* base)
{
	RygelDefaultPlayerController * self;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean result = FALSE;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_player_controller_get_n_tracks ((RygelPlayerController*) self);
	_tmp3_ = _tmp2_;
	if (_tmp1_ < _tmp3_) {
		guint _tmp4_;
		guint _tmp5_;
		_tmp4_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
		_tmp5_ = _tmp4_;
		rygel_player_controller_set_track ((RygelPlayerController*) self, _tmp5_ + 1);
		result = TRUE;
		return result;
	}
	_tmp6_ = rygel_player_controller_get_next_uri ((RygelPlayerController*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp8_, "") != 0;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		GUPnPMediaCollection* _tmp10_;
		_tmp10_ = self->priv->next_collection;
		if (_tmp10_ != NULL) {
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GUPnPMediaCollection* _tmp17_;
			_tmp11_ = rygel_player_controller_get_next_uri ((RygelPlayerController*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = rygel_player_controller_get_next_metadata ((RygelPlayerController*) self);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->next_collection;
			rygel_player_controller_set_playlist_uri ((RygelPlayerController*) self, _tmp13_, _tmp16_, _tmp17_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp13_);
		} else {
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp18_ = rygel_player_controller_get_next_uri ((RygelPlayerController*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = rygel_player_controller_get_next_metadata ((RygelPlayerController*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->next_mime;
			_tmp25_ = self->priv->next_features;
			rygel_player_controller_set_single_play_uri ((RygelPlayerController*) self, _tmp20_, _tmp23_, _tmp24_, _tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
		}
		rygel_player_controller_set_next_uri ((RygelPlayerController*) self, "");
		rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, "");
		_g_free0 (self->priv->next_mime);
		self->priv->next_mime = NULL;
		_g_free0 (self->priv->next_features);
		self->priv->next_features = NULL;
		_g_object_unref0 (self->priv->next_collection);
		self->priv->next_collection = NULL;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
rygel_default_player_controller_real_previous (RygelPlayerController* base)
{
	RygelDefaultPlayerController * self;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean result = FALSE;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp3_ = _tmp2_;
	rygel_player_controller_set_track ((RygelPlayerController*) self, _tmp3_ - 1);
	result = TRUE;
	return result;
}

static void
rygel_default_player_controller_real_set_single_play_uri (RygelPlayerController* base,
                                                          const gchar* uri,
                                                          const gchar* metadata,
                                                          const gchar* mime,
                                                          const gchar* features)
{
	RygelDefaultPlayerController * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	RygelMediaPlayer* _tmp3_;
	const gchar* _tmp4_ = NULL;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp0_ = rygel_player_controller_unescape ((RygelPlayerController*) self, metadata);
	_tmp1_ = _tmp0_;
	rygel_player_controller_set_metadata ((RygelPlayerController*) self, _tmp1_);
	_g_free0 (_tmp1_);
	rygel_player_controller_set_uri ((RygelPlayerController*) self, uri);
	_tmp2_ = mime;
	if (_tmp2_ == NULL) {
		_tmp2_ = "";
	}
	_tmp3_ = self->priv->_player;
	rygel_media_player_set_mime_type (_tmp3_, _tmp2_);
	_tmp4_ = features;
	if (_tmp4_ == NULL) {
		_tmp4_ = "*";
	}
	_tmp5_ = self->priv->_player;
	rygel_media_player_set_content_features (_tmp5_, _tmp4_);
	_tmp6_ = rygel_player_controller_get_metadata ((RygelPlayerController*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	rygel_player_controller_set_track_metadata ((RygelPlayerController*) self, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = rygel_player_controller_get_uri ((RygelPlayerController*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	rygel_player_controller_set_track_uri ((RygelPlayerController*) self, _tmp11_);
	_g_free0 (_tmp11_);
	(self->priv->playlist == NULL) ? NULL : (self->priv->playlist = (_g_list_free__g_object_unref0_ (self->priv->playlist), NULL));
	self->priv->playlist = NULL;
	_tmp12_ = rygel_player_controller_get_uri ((RygelPlayerController*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strcmp0 (_tmp14_, "") == 0;
	_g_free0 (_tmp14_);
	if (_tmp15_) {
		rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, (guint) 0);
		rygel_player_controller_set_track ((RygelPlayerController*) self, (guint) 0);
	} else {
		rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, (guint) 1);
		rygel_player_controller_set_track ((RygelPlayerController*) self, (guint) 1);
	}
}

static void
rygel_default_player_controller_real_set_playlist_uri (RygelPlayerController* base,
                                                       const gchar* uri,
                                                       const gchar* metadata,
                                                       GUPnPMediaCollection* collection)
{
	RygelDefaultPlayerController * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean need_notify = FALSE;
	guint _tmp4_;
	guint _tmp5_;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (collection != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp0_ = rygel_player_controller_unescape ((RygelPlayerController*) self, metadata);
	_tmp1_ = _tmp0_;
	rygel_player_controller_set_metadata ((RygelPlayerController*) self, _tmp1_);
	_g_free0 (_tmp1_);
	rygel_player_controller_set_uri ((RygelPlayerController*) self, uri);
	_tmp2_ = gupnp_media_collection_get_items (collection);
	(self->priv->playlist == NULL) ? NULL : (self->priv->playlist = (_g_list_free__g_object_unref0_ (self->priv->playlist), NULL));
	self->priv->playlist = _tmp2_;
	_tmp3_ = self->priv->playlist;
	rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, g_list_length (_tmp3_));
	_tmp4_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp5_ = _tmp4_;
	need_notify = _tmp5_ != ((guint) 1);
	self->priv->_track = (guint) 1;
	rygel_default_player_controller_apply_track (self);
	if (need_notify) {
		g_object_notify ((GObject*) self, "track");
	}
}

static void
rygel_default_player_controller_real_set_next_single_play_uri (RygelPlayerController* base,
                                                               const gchar* uri,
                                                               const gchar* metadata,
                                                               const gchar* mime,
                                                               const gchar* features)
{
	RygelDefaultPlayerController * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	rygel_player_controller_set_next_uri ((RygelPlayerController*) self, uri);
	rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, metadata);
	_tmp0_ = g_strdup (mime);
	_g_free0 (self->priv->next_mime);
	self->priv->next_mime = _tmp0_;
	_tmp1_ = g_strdup (features);
	_g_free0 (self->priv->next_features);
	self->priv->next_features = _tmp1_;
	_g_object_unref0 (self->priv->next_collection);
	self->priv->next_collection = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_default_player_controller_real_set_next_playlist_uri (RygelPlayerController* base,
                                                            const gchar* uri,
                                                            const gchar* metadata,
                                                            GUPnPMediaCollection* collection)
{
	RygelDefaultPlayerController * self;
	GUPnPMediaCollection* _tmp0_;
	self = (RygelDefaultPlayerController*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (collection != NULL);
	rygel_player_controller_set_next_uri ((RygelPlayerController*) self, uri);
	rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, metadata);
	_g_free0 (self->priv->next_mime);
	self->priv->next_mime = NULL;
	_g_free0 (self->priv->next_features);
	self->priv->next_features = NULL;
	_tmp0_ = _g_object_ref0 (collection);
	_g_object_unref0 (self->priv->next_collection);
	self->priv->next_collection = _tmp0_;
}

static gboolean
___lambda5_ (RygelDefaultPlayerController* self)
{
	gboolean result = FALSE;
	if (!rygel_player_controller_next ((RygelPlayerController*) self)) {
		rygel_player_controller_set_playback_state ((RygelPlayerController*) self, "STOPPED");
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((RygelDefaultPlayerController*) self);
	return result;
}

static void
rygel_default_player_controller_notify_state_cb (RygelDefaultPlayerController* self,
                                                 GObject* player,
                                                 GParamSpec* p)
{
	gchar* state = NULL;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_player;
	_tmp1_ = rygel_media_player_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	state = _tmp2_;
	_tmp3_ = state;
	if (g_strcmp0 (_tmp3_, "EOS") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_playback_state;
		_tmp5_ = state;
		if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GQuark _tmp11_ = 0U;
			static GQuark _tmp10_label0 = 0;
			static GQuark _tmp10_label1 = 0;
			_tmp6_ = state;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->_playback_state);
			self->priv->_playback_state = _tmp7_;
			if (self->priv->timeout_id != ((guint) 0)) {
				g_source_remove (self->priv->timeout_id);
				self->priv->timeout_id = (guint) 0;
			}
			_tmp8_ = self->priv->_playback_state;
			_tmp9_ = _tmp8_;
			_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
			if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("PLAYING")))) {
				switch (0) {
					default:
					{
						rygel_default_player_controller_setup_image_timeout (self);
						break;
					}
				}
			} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("STOPPED")))) {
				switch (0) {
					default:
					{
						rygel_player_controller_set_track ((RygelPlayerController*) self, (guint) 1);
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						break;
					}
				}
			}
			g_object_notify ((GObject*) self, "playback-state");
		}
	}
	_g_free0 (state);
}

static gboolean
rygel_default_player_controller_real_is_play_mode_valid (RygelPlayerController* base,
                                                         const gchar* play_mode)
{
	RygelDefaultPlayerController * self;
	gboolean result = FALSE;
	self = (RygelDefaultPlayerController*) base;
	g_return_val_if_fail (play_mode != NULL, FALSE);
	result = g_strcmp0 (play_mode, "NORMAL") == 0;
	return result;
}

static void
rygel_default_player_controller_notify_uri_cb (RygelDefaultPlayerController* self,
                                               GObject* player,
                                               GParamSpec* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	g_object_notify ((GObject*) self, "track-uri");
}

static void
rygel_default_player_controller_notify_metadata_cb (RygelDefaultPlayerController* self,
                                                    GObject* player,
                                                    GParamSpec* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	g_object_notify ((GObject*) self, "track-metadata");
}

static void
rygel_default_player_controller_apply_track (RygelDefaultPlayerController* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playlist;
	if (_tmp0_ != NULL) {
		GUPnPDIDLLiteItem* item = NULL;
		GList* _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		GUPnPDIDLLiteItem* _tmp6_;
		GUPnPDIDLLiteResource* res = NULL;
		GUPnPDIDLLiteItem* _tmp7_;
		const gchar* _tmp8_;
		GUPnPDIDLLiteResource* _tmp9_;
		GUPnPDIDLLiteItem* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GUPnPDIDLLiteResource* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp1_ = self->priv->playlist;
		_tmp2_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_list_nth (_tmp1_, _tmp3_ - 1);
		_tmp5_ = _tmp4_->data;
		_tmp6_ = _g_object_ref0 ((GUPnPDIDLLiteItem*) _tmp5_);
		item = _tmp6_;
		_tmp7_ = item;
		_tmp8_ = self->priv->_protocol_info;
		_tmp9_ = gupnp_didl_lite_object_get_compat_resource ((GUPnPDIDLLiteObject*) _tmp7_, _tmp8_, TRUE);
		res = _tmp9_;
		_tmp10_ = item;
		_tmp11_ = gupnp_didl_lite_object_get_xml_string ((GUPnPDIDLLiteObject*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf (RYGEL_DEFAULT_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE, _tmp12_);
		_tmp14_ = _tmp13_;
		rygel_player_controller_set_track_metadata ((RygelPlayerController*) self, _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp15_ = res;
		_tmp16_ = gupnp_didl_lite_resource_get_uri (_tmp15_);
		rygel_player_controller_set_track_uri ((RygelPlayerController*) self, _tmp16_);
		_tmp17_ = rygel_player_controller_get_playback_state ((RygelPlayerController*) self);
		_tmp18_ = _tmp17_;
		if (g_strcmp0 (_tmp18_, "PLAYING") == 0) {
			rygel_default_player_controller_setup_image_timeout (self);
		}
		_g_object_unref0 (res);
		_g_object_unref0 (item);
	}
}

static gboolean
__lambda6_ (RygelDefaultPlayerController* self)
{
	gboolean result = FALSE;
	self->priv->timeout_id = (guint) 0;
	if (!rygel_player_controller_next ((RygelPlayerController*) self)) {
		rygel_player_controller_set_playback_state ((RygelPlayerController*) self, "STOPPED");
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((RygelDefaultPlayerController*) self);
	return result;
}

static void
rygel_default_player_controller_setup_image_timeout (RygelDefaultPlayerController* self)
{
	GList* _tmp0_;
	GUPnPDIDLLiteItem* item = NULL;
	GList* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GList* _tmp4_;
	gconstpointer _tmp5_;
	GUPnPDIDLLiteItem* _tmp6_;
	GUPnPDIDLLiteItem* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	glong lifetime = 0L;
	GUPnPDIDLLiteItem* _tmp10_;
	glong _tmp11_;
	glong _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playlist;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->playlist;
	_tmp2_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_list_nth (_tmp1_, _tmp3_ - 1);
	_tmp5_ = _tmp4_->data;
	_tmp6_ = _g_object_ref0 ((GUPnPDIDLLiteItem*) _tmp5_);
	item = _tmp6_;
	_tmp7_ = item;
	_tmp8_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (!g_str_has_prefix (_tmp9_, "object.item.image")) {
		_g_object_unref0 (item);
		return;
	}
	_tmp10_ = item;
	_tmp11_ = gupnp_didl_lite_item_get_lifetime (_tmp10_);
	_tmp12_ = _tmp11_;
	lifetime = _tmp12_;
	if (lifetime <= ((glong) 0)) {
		lifetime = (glong) self->priv->default_image_timeout;
	}
	g_debug ("rygel-default-player-controller.vala:438: Item is image, setup timer: " \
"%ld", lifetime);
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) lifetime, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (item);
}

static void
rygel_default_player_controller_on_setting_changed (RygelDefaultPlayerController* self,
                                                    const gchar* section,
                                                    const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (section, RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION) != 0) {
		_tmp0_ = g_strcmp0 (key, RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	{
		gint _tmp1_ = 0;
		RygelConfiguration* _tmp2_;
		_tmp2_ = self->priv->config;
		_tmp1_ = rygel_configuration_get_int (_tmp2_, RYGEL_DEFAULT_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_DEFAULT_PLAYER_CONTROLLER_TIMEOUT_KEY, 0, G_MAXINT, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->default_image_timeout = (guint) _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		self->priv->default_image_timeout = (guint) RYGEL_DEFAULT_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("rygel-default-player-controller.vala:464: New image timeout: %lu", (gulong) self->priv->default_image_timeout);
}

static RygelMediaPlayer*
rygel_default_player_controller_get_player (RygelDefaultPlayerController* self)
{
	RygelMediaPlayer* result;
	RygelMediaPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	result = _tmp0_;
	return result;
}

static void
rygel_default_player_controller_set_player (RygelDefaultPlayerController* self,
                                            RygelMediaPlayer* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_default_player_controller_get_player (self) != value) {
		RygelMediaPlayer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_player);
		self->priv->_player = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER_PROPERTY]);
	}
}

static const gchar*
rygel_default_player_controller_get_protocol_info (RygelDefaultPlayerController* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol_info;
	result = _tmp0_;
	return result;
}

static void
rygel_default_player_controller_set_protocol_info (RygelDefaultPlayerController* self,
                                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_default_player_controller_get_protocol_info (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_protocol_info);
		self->priv->_protocol_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO_PROPERTY]);
	}
}

static const gchar*
rygel_default_player_controller_real_get_playback_state (RygelPlayerController* base)
{
	const gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_playback_state;
	result = _tmp0_;
	return result;
}

static void
rygel_default_player_controller_real_set_playback_state (RygelPlayerController* base,
                                                         const gchar* value)
{
	RygelDefaultPlayerController* self;
	RygelMediaPlayer* _tmp0_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_player;
	rygel_media_player_set_playback_state (_tmp0_, value);
}

static guint
rygel_default_player_controller_real_get_n_tracks (RygelPlayerController* base)
{
	guint result;
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	result = self->priv->_n_tracks;
	return result;
}

static void
rygel_default_player_controller_real_set_n_tracks (RygelPlayerController* base,
                                                   guint value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (value != self->priv->_n_tracks) {
		self->priv->_n_tracks = value;
		g_object_notify ((GObject*) self, "n-tracks");
	}
}

static guint
rygel_default_player_controller_real_get_track (RygelPlayerController* base)
{
	guint result;
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	result = self->priv->_track;
	return result;
}

static void
rygel_default_player_controller_real_set_track (RygelPlayerController* base,
                                                guint value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (value != self->priv->_track) {
		self->priv->_track = value;
		rygel_default_player_controller_apply_track (self);
		g_object_notify ((GObject*) self, "track");
	}
}

static gchar*
rygel_default_player_controller_real_get_uri (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_default_player_controller_real_set_uri (RygelPlayerController* base,
                                              const gchar* value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (g_strcmp0 (value, rygel_default_player_controller_real_get_uri (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_URI_PROPERTY]);
	}
}

static gchar*
rygel_default_player_controller_real_get_metadata (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_default_player_controller_real_set_metadata (RygelPlayerController* base,
                                                   const gchar* value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (g_strcmp0 (value, rygel_default_player_controller_real_get_metadata (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_metadata);
		self->priv->_metadata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA_PROPERTY]);
	}
}

static gchar*
rygel_default_player_controller_real_get_track_uri (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_player;
	_tmp1_ = rygel_media_player_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		RygelMediaPlayer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = self->priv->_player;
		_tmp6_ = rygel_media_player_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) -1);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		result = _tmp10_;
		return result;
	} else {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("");
		result = _tmp11_;
		return result;
	}
}

static void
rygel_default_player_controller_real_set_track_uri (RygelPlayerController* base,
                                                    const gchar* value)
{
	RygelDefaultPlayerController* self;
	RygelMediaPlayer* _tmp0_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_player;
	rygel_media_player_set_uri (_tmp0_, value);
}

static gchar*
rygel_default_player_controller_real_get_track_metadata (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	gchar* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp5_;
	self = (RygelDefaultPlayerController*) base;
	_tmp1_ = self->priv->_player;
	_tmp2_ = rygel_media_player_get_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

static void
rygel_default_player_controller_real_set_track_metadata (RygelPlayerController* base,
                                                         const gchar* value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (g_str_has_prefix (value, "&lt;")) {
		RygelMediaPlayer* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->_player;
		_tmp1_ = rygel_player_controller_unescape ((RygelPlayerController*) self, value);
		_tmp2_ = _tmp1_;
		rygel_media_player_set_metadata (_tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		RygelMediaPlayer* _tmp3_;
		_tmp3_ = self->priv->_player;
		rygel_media_player_set_metadata (_tmp3_, value);
	}
}

static gchar*
rygel_default_player_controller_real_get_next_uri (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_next_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_default_player_controller_real_set_next_uri (RygelPlayerController* base,
                                                   const gchar* value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (g_strcmp0 (value, rygel_default_player_controller_real_get_next_uri (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_next_uri);
		self->priv->_next_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI_PROPERTY]);
	}
}

static gchar*
rygel_default_player_controller_real_get_next_metadata (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_next_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
rygel_default_player_controller_real_set_next_metadata (RygelPlayerController* base,
                                                        const gchar* value)
{
	RygelDefaultPlayerController* self;
	self = (RygelDefaultPlayerController*) base;
	if (g_strcmp0 (value, rygel_default_player_controller_real_get_next_metadata (base)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_next_metadata);
		self->priv->_next_metadata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA_PROPERTY]);
	}
}

static gboolean
rygel_default_player_controller_real_get_can_pause (RygelPlayerController* base)
{
	gboolean result;
	RygelDefaultPlayerController* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp5_ = FALSE;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	self = (RygelDefaultPlayerController*) base;
	_tmp1_ = rygel_player_controller_get_playback_state ((RygelPlayerController*) self);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "PLAYING") != 0) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = rygel_player_controller_get_playback_state ((RygelPlayerController*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "TRANSITIONING") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_player;
	_tmp7_ = rygel_media_player_get_mime_type (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = !g_str_has_prefix (_tmp9_, "image/");
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		_tmp5_ = TRUE;
	} else {
		GList* _tmp11_;
		_tmp11_ = self->priv->playlist;
		_tmp5_ = _tmp11_ != NULL;
	}
	result = _tmp5_;
	return result;
}

static gchar*
rygel_default_player_controller_real_get_current_transport_actions (RygelPlayerController* base)
{
	gchar* result;
	RygelDefaultPlayerController* self;
	gchar* actions = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	const gchar* _tmp17_;
	guint _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	guint _tmp25_;
	guint _tmp26_;
	RygelMediaPlayer* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	RygelMediaPlayer* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	RygelMediaPlayer* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gboolean _tmp45_;
	self = (RygelDefaultPlayerController*) base;
	actions = NULL;
	_tmp0_ = rygel_player_controller_get_playback_state ((RygelPlayerController*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("PLAYING")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("TRANSITIONING"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				RygelMediaPlayer* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp5_ = g_strdup ("Stop");
				_g_free0 (actions);
				actions = _tmp5_;
				_tmp7_ = self->priv->_player;
				_tmp8_ = rygel_media_player_get_mime_type (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_tmp11_ = !g_str_has_prefix (_tmp10_, "image/");
				_g_free0 (_tmp10_);
				if (_tmp11_) {
					_tmp6_ = TRUE;
				} else {
					GList* _tmp12_;
					_tmp12_ = self->priv->playlist;
					_tmp6_ = _tmp12_ != NULL;
				}
				if (_tmp6_) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = actions;
					_tmp14_ = g_strconcat (_tmp13_, ",Pause", NULL);
					_g_free0 (actions);
					actions = _tmp14_;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("Play");
				_g_free0 (actions);
				actions = _tmp15_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup ("Stop,Play");
				_g_free0 (actions);
				actions = _tmp16_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp17_ = actions;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("");
		result = _tmp18_;
		_g_free0 (actions);
		return result;
	}
	_tmp19_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = rygel_player_controller_get_n_tracks ((RygelPlayerController*) self);
	_tmp22_ = _tmp21_;
	if (_tmp20_ < _tmp22_) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = actions;
		_tmp24_ = g_strconcat (_tmp23_, ",Next", NULL);
		_g_free0 (actions);
		actions = _tmp24_;
	}
	_tmp25_ = rygel_player_controller_get_track ((RygelPlayerController*) self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > ((guint) 1)) {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = actions;
		_tmp28_ = g_strconcat (_tmp27_, ",Previous", NULL);
		_g_free0 (actions);
		actions = _tmp28_;
	}
	_tmp29_ = self->priv->_player;
	_tmp30_ = rygel_media_player_get_can_seek (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = actions;
		_tmp33_ = g_strconcat (_tmp32_, ",Seek,X_DLNA_SeekTime", NULL);
		_g_free0 (actions);
		actions = _tmp33_;
	}
	_tmp34_ = self->priv->_player;
	_tmp35_ = rygel_media_player_get_can_seek_bytes (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_) {
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp37_ = actions;
		_tmp38_ = g_strconcat (_tmp37_, ",X_DLNA_SeekByte", NULL);
		_g_free0 (actions);
		actions = _tmp38_;
	}
	_tmp41_ = self->priv->_player;
	_tmp42_ = rygel_media_player_get_mime_type (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_ != NULL;
	_g_free0 (_tmp44_);
	if (_tmp45_) {
		RygelMediaPlayer* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp46_ = self->priv->_player;
		_tmp47_ = rygel_media_player_get_mime_type (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		_tmp40_ = !g_str_has_prefix (_tmp49_, "image/");
		_g_free0 (_tmp49_);
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		RygelMediaPlayer* _tmp50_;
		gchar** _tmp51_;
		gint _tmp51__length1;
		gint _tmp52_ = 0;
		gchar** _tmp53_;
		gint _tmp53__length1;
		gchar** _tmp54_;
		gint _tmp54__length1;
		_tmp50_ = self->priv->_player;
		_tmp51_ = rygel_media_player_get_allowed_playback_speeds (_tmp50_, &_tmp52_);
		_tmp51__length1 = _tmp52_;
		_tmp53_ = _tmp51_;
		_tmp53__length1 = _tmp51__length1;
		_tmp54_ = _tmp53_;
		_tmp54__length1 = _tmp53__length1;
		_tmp39_ = _tmp53__length1 > 1;
		_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		gchar* play_speeds = NULL;
		gchar* _tmp55_;
		RygelMediaPlayer* _tmp56_;
		gchar** _tmp57_;
		gint _tmp57__length1;
		gint _tmp58_ = 0;
		gchar** _tmp59_;
		gint _tmp59__length1;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp55_ = g_strdup ("");
		play_speeds = _tmp55_;
		_tmp56_ = self->priv->_player;
		_tmp57_ = rygel_media_player_get_allowed_playback_speeds (_tmp56_, &_tmp58_);
		_tmp57__length1 = _tmp58_;
		_tmp59_ = _tmp57_;
		_tmp59__length1 = _tmp57__length1;
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
			speed_collection = _tmp59_;
			speed_collection_length1 = _tmp59__length1;
			for (speed_it = 0; speed_it < speed_collection_length1; speed_it = speed_it + 1) {
				gchar* _tmp60_;
				gchar* speed = NULL;
				_tmp60_ = g_strdup (speed_collection[speed_it]);
				speed = _tmp60_;
				{
					const gchar* _tmp61_;
					_tmp61_ = speed;
					if (g_strcmp0 (_tmp61_, "1") != 0) {
						const gchar* _tmp62_;
						_tmp62_ = play_speeds;
						if (g_strcmp0 (_tmp62_, "") == 0) {
							const gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp63_ = speed;
							_tmp64_ = g_strconcat (",X_DLNA_PS=", _tmp63_, NULL);
							_g_free0 (play_speeds);
							play_speeds = _tmp64_;
						} else {
							const gchar* _tmp65_;
							const gchar* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							_tmp65_ = play_speeds;
							_tmp66_ = speed;
							_tmp67_ = g_strconcat ("\\,", _tmp66_, NULL);
							_tmp68_ = _tmp67_;
							_tmp69_ = g_strconcat (_tmp65_, _tmp68_, NULL);
							_g_free0 (play_speeds);
							play_speeds = _tmp69_;
							_g_free0 (_tmp68_);
						}
					}
					_g_free0 (speed);
				}
			}
			speed_collection = (_vala_array_free (speed_collection, speed_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp70_ = actions;
		_tmp71_ = play_speeds;
		_tmp72_ = g_strconcat (_tmp70_, _tmp71_, NULL);
		_g_free0 (actions);
		actions = _tmp72_;
		_g_free0 (play_speeds);
	}
	result = actions;
	return result;
}

static const gchar*
rygel_default_player_controller_real_get_play_mode (RygelPlayerController* base)
{
	const gchar* result;
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_play_mode;
	result = _tmp0_;
	return result;
}

static void
rygel_default_player_controller_real_set_play_mode (RygelPlayerController* base,
                                                    const gchar* value)
{
	RygelDefaultPlayerController* self;
	const gchar* _tmp0_;
	self = (RygelDefaultPlayerController*) base;
	_tmp0_ = self->priv->_play_mode;
	if (g_strcmp0 (value, _tmp0_) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (value);
		_g_free0 (self->priv->_play_mode);
		self->priv->_play_mode = _tmp1_;
		g_object_notify ((GObject*) self, "play-mode");
	}
}

static void
rygel_default_player_controller_class_init (RygelDefaultPlayerControllerClass * klass,
                                            gpointer klass_data)
{
	rygel_default_player_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDefaultPlayerController_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_default_player_controller_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_default_player_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_default_player_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_default_player_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER_PROPERTY] = g_param_spec_object ("player", "player", "player", RYGEL_TYPE_MEDIA_PLAYER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO_PROPERTY] = g_param_spec_string ("protocol-info", "protocol-info", "protocol-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE_PROPERTY] = g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS_PROPERTY] = g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_PROPERTY] = g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_URI_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA_PROPERTY] = g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI_PROPERTY] = g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA_PROPERTY] = g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI_PROPERTY] = g_param_spec_string ("next-uri", "next-uri", "next-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA_PROPERTY] = g_param_spec_string ("next-metadata", "next-metadata", "next-metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_CAN_PAUSE_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_CAN_PAUSE_PROPERTY] = g_param_spec_boolean ("can-pause", "can-pause", "can-pause", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS_PROPERTY] = g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE_PROPERTY, rygel_default_player_controller_properties[RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE_PROPERTY] = g_param_spec_string ("play-mode", "play-mode", "play-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
rygel_default_player_controller_rygel_player_controller_interface_init (RygelPlayerControllerIface * iface,
                                                                        gpointer iface_data)
{
	rygel_default_player_controller_rygel_player_controller_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (RygelPlayerController*)) rygel_default_player_controller_real_next;
	iface->previous = (gboolean (*) (RygelPlayerController*)) rygel_default_player_controller_real_previous;
	iface->set_single_play_uri = (void (*) (RygelPlayerController*, const gchar*, const gchar*, const gchar*, const gchar*)) rygel_default_player_controller_real_set_single_play_uri;
	iface->set_playlist_uri = (void (*) (RygelPlayerController*, const gchar*, const gchar*, GUPnPMediaCollection*)) rygel_default_player_controller_real_set_playlist_uri;
	iface->set_next_single_play_uri = (void (*) (RygelPlayerController*, const gchar*, const gchar*, const gchar*, const gchar*)) rygel_default_player_controller_real_set_next_single_play_uri;
	iface->set_next_playlist_uri = (void (*) (RygelPlayerController*, const gchar*, const gchar*, GUPnPMediaCollection*)) rygel_default_player_controller_real_set_next_playlist_uri;
	iface->is_play_mode_valid = (gboolean (*) (RygelPlayerController*, const gchar*)) rygel_default_player_controller_real_is_play_mode_valid;
	iface->get_playback_state = rygel_default_player_controller_real_get_playback_state;
	iface->set_playback_state = rygel_default_player_controller_real_set_playback_state;
	iface->get_n_tracks = rygel_default_player_controller_real_get_n_tracks;
	iface->set_n_tracks = rygel_default_player_controller_real_set_n_tracks;
	iface->get_track = rygel_default_player_controller_real_get_track;
	iface->set_track = rygel_default_player_controller_real_set_track;
	iface->get_uri = rygel_default_player_controller_real_get_uri;
	iface->set_uri = rygel_default_player_controller_real_set_uri;
	iface->get_metadata = rygel_default_player_controller_real_get_metadata;
	iface->set_metadata = rygel_default_player_controller_real_set_metadata;
	iface->get_track_uri = rygel_default_player_controller_real_get_track_uri;
	iface->set_track_uri = rygel_default_player_controller_real_set_track_uri;
	iface->get_track_metadata = rygel_default_player_controller_real_get_track_metadata;
	iface->set_track_metadata = rygel_default_player_controller_real_set_track_metadata;
	iface->get_next_uri = rygel_default_player_controller_real_get_next_uri;
	iface->set_next_uri = rygel_default_player_controller_real_set_next_uri;
	iface->get_next_metadata = rygel_default_player_controller_real_get_next_metadata;
	iface->set_next_metadata = rygel_default_player_controller_real_set_next_metadata;
	iface->get_can_pause = rygel_default_player_controller_real_get_can_pause;
	iface->get_current_transport_actions = rygel_default_player_controller_real_get_current_transport_actions;
	iface->get_play_mode = rygel_default_player_controller_real_get_play_mode;
	iface->set_play_mode = rygel_default_player_controller_real_set_play_mode;
}

static void
rygel_default_player_controller_instance_init (RygelDefaultPlayerController * self,
                                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = rygel_default_player_controller_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_uri = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_metadata = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_next_uri = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_next_metadata = _tmp3_;
	self->priv->_n_tracks = 0U;
	self->priv->_track = 0U;
	_tmp4_ = g_strdup ("NO_MEDIA_PRESENT");
	self->priv->_playback_state = _tmp4_;
	_tmp5_ = g_strdup ("NORMAL");
	self->priv->_play_mode = _tmp5_;
}

static void
rygel_default_player_controller_finalize (GObject * obj)
{
	RygelDefaultPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController);
	_g_object_unref0 (self->priv->_player);
	_g_free0 (self->priv->_protocol_info);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_next_uri);
	_g_free0 (self->priv->_next_metadata);
	(self->priv->playlist == NULL) ? NULL : (self->priv->playlist = (_g_list_free__g_object_unref0_ (self->priv->playlist), NULL));
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->next_features);
	_g_free0 (self->priv->next_mime);
	_g_object_unref0 (self->priv->next_collection);
	_g_free0 (self->priv->_playback_state);
	_g_free0 (self->priv->_play_mode);
	G_OBJECT_CLASS (rygel_default_player_controller_parent_class)->finalize (obj);
}

/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
static GType
rygel_default_player_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelDefaultPlayerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_default_player_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDefaultPlayerController), 0, (GInstanceInitFunc) rygel_default_player_controller_instance_init, NULL };
	static const GInterfaceInfo rygel_player_controller_info = { (GInterfaceInitFunc) rygel_default_player_controller_rygel_player_controller_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_default_player_controller_type_id;
	rygel_default_player_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDefaultPlayerController", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_default_player_controller_type_id, RYGEL_TYPE_PLAYER_CONTROLLER, &rygel_player_controller_info);
	RygelDefaultPlayerController_private_offset = g_type_add_instance_private (rygel_default_player_controller_type_id, sizeof (RygelDefaultPlayerControllerPrivate));
	return rygel_default_player_controller_type_id;
}

GType
rygel_default_player_controller_get_type (void)
{
	static volatile gsize rygel_default_player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_default_player_controller_type_id__volatile)) {
		GType rygel_default_player_controller_type_id;
		rygel_default_player_controller_type_id = rygel_default_player_controller_get_type_once ();
		g_once_init_leave (&rygel_default_player_controller_type_id__volatile, rygel_default_player_controller_type_id);
	}
	return rygel_default_player_controller_type_id__volatile;
}

static void
_vala_rygel_default_player_controller_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	RygelDefaultPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController);
	switch (property_id) {
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER_PROPERTY:
		g_value_set_object (value, rygel_default_player_controller_get_player (self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO_PROPERTY:
		g_value_set_string (value, rygel_default_player_controller_get_protocol_info (self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE_PROPERTY:
		g_value_set_string (value, rygel_player_controller_get_playback_state ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS_PROPERTY:
		g_value_set_uint (value, rygel_player_controller_get_n_tracks ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_PROPERTY:
		g_value_set_uint (value, rygel_player_controller_get_track ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_URI_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_uri ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_metadata ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_track_uri ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_track_metadata ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_next_uri ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_next_metadata ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_CAN_PAUSE_PROPERTY:
		g_value_set_boolean (value, rygel_player_controller_get_can_pause ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS_PROPERTY:
		g_value_take_string (value, rygel_player_controller_get_current_transport_actions ((RygelPlayerController*) self));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE_PROPERTY:
		g_value_set_string (value, rygel_player_controller_get_play_mode ((RygelPlayerController*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_default_player_controller_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	RygelDefaultPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController);
	switch (property_id) {
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYER_PROPERTY:
		rygel_default_player_controller_set_player (self, g_value_get_object (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PROTOCOL_INFO_PROPERTY:
		rygel_default_player_controller_set_protocol_info (self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAYBACK_STATE_PROPERTY:
		rygel_player_controller_set_playback_state ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_N_TRACKS_PROPERTY:
		rygel_player_controller_set_n_tracks ((RygelPlayerController*) self, g_value_get_uint (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_PROPERTY:
		rygel_player_controller_set_track ((RygelPlayerController*) self, g_value_get_uint (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_URI_PROPERTY:
		rygel_player_controller_set_uri ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_METADATA_PROPERTY:
		rygel_player_controller_set_metadata ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_URI_PROPERTY:
		rygel_player_controller_set_track_uri ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_TRACK_METADATA_PROPERTY:
		rygel_player_controller_set_track_metadata ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_URI_PROPERTY:
		rygel_player_controller_set_next_uri ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_NEXT_METADATA_PROPERTY:
		rygel_player_controller_set_next_metadata ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		case RYGEL_DEFAULT_PLAYER_CONTROLLER_PLAY_MODE_PROPERTY:
		rygel_player_controller_set_play_mode ((RygelPlayerController*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

