/* rygel-root-device.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-root-device.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelRootDevicePrivate RygelRootDevicePrivate;
enum  {
	RYGEL_ROOT_DEVICE_0_PROPERTY,
	RYGEL_ROOT_DEVICE_SERVICES_PROPERTY,
	RYGEL_ROOT_DEVICE_NUM_PROPERTIES
};
static GParamSpec* rygel_root_device_properties[RYGEL_ROOT_DEVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

struct _RygelRootDevice {
	GUPnPRootDevice parent_instance;
	RygelRootDevicePrivate * priv;
};

struct _RygelRootDeviceClass {
	GUPnPRootDeviceClass parent_class;
};

struct _RygelRootDevicePrivate {
	GeeArrayList* _services;
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

static gint RygelRootDevice_private_offset;
static gpointer rygel_root_device_parent_class = NULL;
static GInitableIface * rygel_root_device_g_initable_parent_iface = NULL;

GType rygel_root_device_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelRootDevice, g_object_unref)
GType rygel_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlugin, g_object_unref)
RygelRootDevice* rygel_root_device_new (GUPnPContext* context,
                                        RygelPlugin* plugin,
                                        GUPnPXMLDoc* description_doc,
                                        const gchar* description_path,
                                        const gchar* description_dir,
                                        GError** error);
RygelRootDevice* rygel_root_device_construct (GType object_type,
                                              GUPnPContext* context,
                                              RygelPlugin* plugin,
                                              GUPnPXMLDoc* description_doc,
                                              const gchar* description_path,
                                              const gchar* description_dir,
                                              GError** error);
static gboolean rygel_root_device_real_init (GInitable* base,
                                      GCancellable* cancellable,
                                      GError** error);
void rygel_root_device_set_services (RygelRootDevice* self,
                                     GeeArrayList* value);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void rygel_value_set_resource_info (GValue* value,
                                    gpointer v_object);
void rygel_value_take_resource_info (GValue* value,
                                     gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelResourceInfo, rygel_resource_info_unref)
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
GeeArrayList* rygel_root_device_get_services (RygelRootDevice* self);
static void rygel_root_device_finalize (GObject * obj);
static GType rygel_root_device_get_type_once (void);
static void _vala_rygel_root_device_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_rygel_root_device_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
rygel_root_device_get_instance_private (RygelRootDevice* self)
{
	return G_STRUCT_MEMBER_P (self, RygelRootDevice_private_offset);
}

RygelRootDevice*
rygel_root_device_construct (GType object_type,
                             GUPnPContext* context,
                             RygelPlugin* plugin,
                             GUPnPXMLDoc* description_doc,
                             const gchar* description_path,
                             const gchar* description_dir,
                             GError** error)
{
	RygelRootDevice * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	g_return_val_if_fail (description_doc != NULL, NULL);
	g_return_val_if_fail (description_path != NULL, NULL);
	g_return_val_if_fail (description_dir != NULL, NULL);
	self = (RygelRootDevice*) g_object_new (object_type, "context", context, "resource-factory", plugin, "description-doc", description_doc, "description-path", description_path, "description-dir", description_dir, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

RygelRootDevice*
rygel_root_device_new (GUPnPContext* context,
                       RygelPlugin* plugin,
                       GUPnPXMLDoc* description_doc,
                       const gchar* description_path,
                       const gchar* description_dir,
                       GError** error)
{
	return rygel_root_device_construct (RYGEL_TYPE_ROOT_DEVICE, context, plugin, description_doc, description_path, description_dir, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
rygel_root_device_real_init (GInitable* base,
                             GCancellable* cancellable,
                             GError** error)
{
	RygelRootDevice * self;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	RygelPlugin* plugin = NULL;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelPlugin* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	self = (RygelRootDevice*) base;
	rygel_root_device_g_initable_parent_iface->init ((GInitable*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_root_device_get_type (), GUPnPRootDevice), cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp0_;
	}
	_tmp1_ = gee_array_list_new (gupnp_service_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp2_ = _tmp1_;
	rygel_root_device_set_services (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (RYGEL_IS_PLUGIN (_tmp4_) ? ((RygelPlugin*) _tmp4_) : NULL);
	plugin = _tmp5_;
	{
		GeeArrayList* _info_list = NULL;
		RygelPlugin* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _info_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _info_index = 0;
		_tmp6_ = plugin;
		_tmp7_ = rygel_plugin_get_resource_infos (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_info_list = _tmp9_;
		_tmp10_ = _info_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_info_size = _tmp12_;
		_info_index = -1;
		while (TRUE) {
			RygelResourceInfo* info = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			RygelResourceInfo* _tmp15_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp13_ = _info_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _info_index);
			info = (RygelResourceInfo*) _tmp14_;
			_tmp15_ = info;
			if (g_type_is_a (_tmp15_->type, gupnp_service_get_type ())) {
				GUPnPServiceInfo* service = NULL;
				RygelResourceInfo* _tmp16_;
				const gchar* _tmp17_;
				GUPnPServiceInfo* _tmp18_;
				GeeArrayList* _tmp19_;
				GUPnPServiceInfo* _tmp20_;
				_tmp16_ = info;
				_tmp17_ = _tmp16_->upnp_type;
				_tmp18_ = gupnp_device_info_get_service ((GUPnPDeviceInfo*) self, _tmp17_);
				service = _tmp18_;
				_tmp19_ = self->priv->_services;
				_tmp20_ = service;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				_g_object_unref0 (service);
			}
			_rygel_resource_info_unref0 (info);
		}
		_g_object_unref0 (_info_list);
	}
	result = TRUE;
	_g_object_unref0 (plugin);
	return result;
}

GeeArrayList*
rygel_root_device_get_services (RygelRootDevice* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_services;
	result = _tmp0_;
	return result;
}

void
rygel_root_device_set_services (RygelRootDevice* self,
                                GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_root_device_get_services (self) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_services);
		self->priv->_services = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_root_device_properties[RYGEL_ROOT_DEVICE_SERVICES_PROPERTY]);
	}
}

static void
rygel_root_device_class_init (RygelRootDeviceClass * klass,
                              gpointer klass_data)
{
	rygel_root_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelRootDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_root_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_root_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_root_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ROOT_DEVICE_SERVICES_PROPERTY, rygel_root_device_properties[RYGEL_ROOT_DEVICE_SERVICES_PROPERTY] = g_param_spec_object ("services", "services", "services", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_root_device_g_initable_interface_init (GInitableIface * iface,
                                             gpointer iface_data)
{
	rygel_root_device_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) rygel_root_device_real_init;
}

static void
rygel_root_device_instance_init (RygelRootDevice * self,
                                 gpointer klass)
{
	self->priv = rygel_root_device_get_instance_private (self);
}

static void
rygel_root_device_finalize (GObject * obj)
{
	RygelRootDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice);
	_g_object_unref0 (self->priv->_services);
	G_OBJECT_CLASS (rygel_root_device_parent_class)->finalize (obj);
}

/**
 * This represents a UPnP root device.
 *
 * Each Rygel plugin corresponds to one UPnP root device, so
 * each #RygelPlugin corresponds to one #RygelRootDevice.
 *
 * Rygel creates the #RygelRootDevice by calling
 * rygel_root_device_factory_create() with the plugin,
 * having first instantiated the #RygelRootDeviceFactory
 * for a #GUPnPContext.
 */
static GType
rygel_root_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDevice), 0, (GInstanceInitFunc) rygel_root_device_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_root_device_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_root_device_type_id;
	rygel_root_device_type_id = g_type_register_static (gupnp_root_device_get_type (), "RygelRootDevice", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_root_device_type_id, g_initable_get_type (), &g_initable_info);
	RygelRootDevice_private_offset = g_type_add_instance_private (rygel_root_device_type_id, sizeof (RygelRootDevicePrivate));
	return rygel_root_device_type_id;
}

GType
rygel_root_device_get_type (void)
{
	static volatile gsize rygel_root_device_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_type_id__volatile)) {
		GType rygel_root_device_type_id;
		rygel_root_device_type_id = rygel_root_device_get_type_once ();
		g_once_init_leave (&rygel_root_device_type_id__volatile, rygel_root_device_type_id);
	}
	return rygel_root_device_type_id__volatile;
}

static void
_vala_rygel_root_device_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	RygelRootDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_SERVICES_PROPERTY:
		g_value_set_object (value, rygel_root_device_get_services (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_root_device_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	RygelRootDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_SERVICES_PROPERTY:
		rygel_root_device_set_services (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

