/* rygel-media-export-playlist-root-container.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-media-export-playlist-root-container.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <rygel-server.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <rygel-db.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER (rygel_media_export_playlist_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))

typedef struct _RygelMediaExportPlaylistRootContainer RygelMediaExportPlaylistRootContainer;
typedef struct _RygelMediaExportPlaylistRootContainerClass RygelMediaExportPlaylistRootContainerClass;
typedef struct _RygelMediaExportPlaylistRootContainerPrivate RygelMediaExportPlaylistRootContainerPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CREATE_CLASSES_PROPERTY,
	RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_OCM_FLAGS_PROPERTY,
	RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_playlist_root_container_properties[RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportPlaylistRootContainerAddItemData RygelMediaExportPlaylistRootContainerAddItemData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediaExportPlaylistRootContainerRemoveItemData RygelMediaExportPlaylistRootContainerRemoveItemData;
typedef struct _RygelMediaExportPlaylistRootContainerAddContainerData RygelMediaExportPlaylistRootContainerAddContainerData;
typedef struct _RygelMediaExportPlaylistRootContainerRemoveContainerData RygelMediaExportPlaylistRootContainerRemoveContainerData;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	gint (*count_children) (RygelMediaExportDBContainer* self);
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportPlaylistRootContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportPlaylistRootContainerPrivate * priv;
};

struct _RygelMediaExportPlaylistRootContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportPlaylistRootContainerPrivate {
	GeeArrayList* _create_classes;
};

struct _RygelMediaExportPlaylistRootContainerAddItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportPlaylistRootContainer* self;
	RygelMediaFileItem* item;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_;
};

struct _RygelMediaExportPlaylistRootContainerRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportPlaylistRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_;
};

struct _RygelMediaExportPlaylistRootContainerAddContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportPlaylistRootContainer* self;
	RygelMediaContainer* container;
	GCancellable* cancellable;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RygelMediaExportMediaCache* _tmp12_;
	RygelMediaExportMediaCache* _tmp13_;
	GError* _inner_error0_;
};

struct _RygelMediaExportPlaylistRootContainerRemoveContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportPlaylistRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaExportMediaCache* _tmp0_;
	GError* _inner_error0_;
};

static gint RygelMediaExportPlaylistRootContainer_private_offset;
static gpointer rygel_media_export_playlist_root_container_parent_class = NULL;
static RygelWritableContainerIface * rygel_media_export_playlist_root_container_rygel_writable_container_parent_iface = NULL;

GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportDBContainer, g_object_unref)
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportMediaCache, g_object_unref)
GType rygel_media_export_playlist_root_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportPlaylistRootContainer, g_object_unref)
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_ID "virtual-parent:" RYGEL_PLAYLIST_ITEM_UPNP_CLASS
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_URI RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "playlist-root"
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_new (void);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_construct (GType object_type);
static void rygel_media_export_playlist_root_container_real_constructed (GObject* base);
static void rygel_media_export_playlist_root_container_real_add_item_data_free (gpointer _data);
static void rygel_media_export_playlist_root_container_real_add_item (RygelWritableContainer* base,
                                                               RygelMediaFileItem* item,
                                                               GCancellable* cancellable,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static gboolean rygel_media_export_playlist_root_container_real_add_item_co (RygelMediaExportPlaylistRootContainerAddItemData* _data_);
static void rygel_media_export_playlist_root_container_real_remove_item_data_free (gpointer _data);
static void rygel_media_export_playlist_root_container_real_remove_item (RygelWritableContainer* base,
                                                                  const gchar* id,
                                                                  GCancellable* cancellable,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gboolean rygel_media_export_playlist_root_container_real_remove_item_co (RygelMediaExportPlaylistRootContainerRemoveItemData* _data_);
static void rygel_media_export_playlist_root_container_real_add_container_data_free (gpointer _data);
static void rygel_media_export_playlist_root_container_real_add_container (RygelWritableContainer* base,
                                                                    RygelMediaContainer* container,
                                                                    GCancellable* cancellable,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static gboolean rygel_media_export_playlist_root_container_real_add_container_co (RygelMediaExportPlaylistRootContainerAddContainerData* _data_);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self,
                                                    RygelMediaContainer* container,
                                                    GError** error);
void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self,
                                                         RygelMediaObject* object,
                                                         gboolean guarded);
static void rygel_media_export_playlist_root_container_real_remove_container_data_free (gpointer _data);
static void rygel_media_export_playlist_root_container_real_remove_container (RygelWritableContainer* base,
                                                                       const gchar* id,
                                                                       GCancellable* cancellable,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
static gboolean rygel_media_export_playlist_root_container_real_remove_container_co (RygelMediaExportPlaylistRootContainerRemoveContainerData* _data_);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self,
                                                  const gchar* id,
                                                  GError** error);
static void rygel_media_export_playlist_root_container_finalize (GObject * obj);
static void _vala_rygel_media_export_playlist_root_container_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_rygel_media_export_playlist_root_container_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);

static inline gpointer
rygel_media_export_playlist_root_container_get_instance_private (RygelMediaExportPlaylistRootContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportPlaylistRootContainer_private_offset);
}

RygelMediaExportPlaylistRootContainer*
rygel_media_export_playlist_root_container_construct (GType object_type)
{
	RygelMediaExportPlaylistRootContainer * self = NULL;
	self = (RygelMediaExportPlaylistRootContainer*) g_object_new (object_type, "id", RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_ID, "title", _ ("Playlists"), "parent", NULL, "child-count", 0, NULL);
	return self;
}

RygelMediaExportPlaylistRootContainer*
rygel_media_export_playlist_root_container_new (void)
{
	return rygel_media_export_playlist_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER);
}

static void
rygel_media_export_playlist_root_container_real_constructed (GObject* base)
{
	RygelMediaExportPlaylistRootContainer * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	G_OBJECT_CLASS (rygel_media_export_playlist_root_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer));
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_writable_container_get_create_classes ((RygelWritableContainer*) self);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS);
	rygel_media_object_add_uri ((RygelMediaObject*) self, RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_URI);
}

static void
rygel_media_export_playlist_root_container_real_add_item_data_free (gpointer _data)
{
	RygelMediaExportPlaylistRootContainerAddItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportPlaylistRootContainerAddItemData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_media_export_playlist_root_container_real_add_item (RygelWritableContainer* base,
                                                          RygelMediaFileItem* item,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	RygelMediaExportPlaylistRootContainer * self;
	RygelMediaExportPlaylistRootContainerAddItemData* _data_;
	RygelMediaExportPlaylistRootContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportPlaylistRootContainerAddItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_playlist_root_container_real_add_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (item);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_export_playlist_root_container_real_add_item_co (_data_);
}

static void
rygel_media_export_playlist_root_container_add_item_finish (RygelWritableContainer* base,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	RygelMediaExportPlaylistRootContainerAddItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_media_export_playlist_root_container_real_add_item_co (RygelMediaExportPlaylistRootContainerAddItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_error_new (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, _ ("Can’t create items in %s"), _data_->_tmp1_);
	_data_->_inner_error0_ = _data_->_tmp2_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_playlist_root_container_real_remove_item_data_free (gpointer _data)
{
	RygelMediaExportPlaylistRootContainerRemoveItemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportPlaylistRootContainerRemoveItemData, _data_);
}

static void
rygel_media_export_playlist_root_container_real_remove_item (RygelWritableContainer* base,
                                                             const gchar* id,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	RygelMediaExportPlaylistRootContainer * self;
	RygelMediaExportPlaylistRootContainerRemoveItemData* _data_;
	RygelMediaExportPlaylistRootContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportPlaylistRootContainerRemoveItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_playlist_root_container_real_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_export_playlist_root_container_real_remove_item_co (_data_);
}

static void
rygel_media_export_playlist_root_container_remove_item_finish (RygelWritableContainer* base,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	RygelMediaExportPlaylistRootContainerRemoveItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_media_export_playlist_root_container_real_remove_item_co (RygelMediaExportPlaylistRootContainerRemoveItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_error_new (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, _ ("Can’t remove items in %s"), _data_->_tmp1_);
	_data_->_inner_error0_ = _data_->_tmp2_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_playlist_root_container_real_add_container_data_free (gpointer _data)
{
	RygelMediaExportPlaylistRootContainerAddContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportPlaylistRootContainerAddContainerData, _data_);
}

static void
rygel_media_export_playlist_root_container_real_add_container (RygelWritableContainer* base,
                                                               RygelMediaContainer* container,
                                                               GCancellable* cancellable,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	RygelMediaExportPlaylistRootContainer * self;
	RygelMediaExportPlaylistRootContainerAddContainerData* _data_;
	RygelMediaExportPlaylistRootContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportPlaylistRootContainerAddContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_playlist_root_container_real_add_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_export_playlist_root_container_real_add_container_co (_data_);
}

static void
rygel_media_export_playlist_root_container_add_container_finish (RygelWritableContainer* base,
                                                                 GAsyncResult* _res_,
                                                                 GError** error)
{
	RygelMediaExportPlaylistRootContainerAddContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_media_export_playlist_root_container_real_add_container_co (RygelMediaExportPlaylistRootContainerAddContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _data_->container);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (g_strcmp0 (_data_->_tmp2_, RYGEL_MEDIA_CONTAINER_PLAYLIST) != 0) {
		_data_->_tmp3_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _data_->container);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp4_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS) != 0;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = g_error_new (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, _ ("upnp:class not supported in %s"), _data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = gupnp_get_uuid ();
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = g_strconcat ("playlist:", _data_->_tmp9_, NULL);
	_data_->_tmp11_ = _data_->_tmp10_;
	rygel_media_object_set_id ((RygelMediaObject*) _data_->container, _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_g_free0 (_data_->_tmp9_);
	rygel_media_object_set_upnp_class ((RygelMediaObject*) _data_->container, RYGEL_MEDIA_CONTAINER_PLAYLIST);
	_data_->_tmp12_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
	rygel_media_export_media_cache_save_container (_data_->_tmp12_, _data_->container, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
	rygel_media_export_media_cache_make_object_guarded (_data_->_tmp13_, (RygelMediaObject*) _data_->container, TRUE);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_playlist_root_container_real_remove_container_data_free (gpointer _data)
{
	RygelMediaExportPlaylistRootContainerRemoveContainerData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportPlaylistRootContainerRemoveContainerData, _data_);
}

static void
rygel_media_export_playlist_root_container_real_remove_container (RygelWritableContainer* base,
                                                                  const gchar* id,
                                                                  GCancellable* cancellable,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	RygelMediaExportPlaylistRootContainer * self;
	RygelMediaExportPlaylistRootContainerRemoveContainerData* _data_;
	RygelMediaExportPlaylistRootContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportPlaylistRootContainerRemoveContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_playlist_root_container_real_remove_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_export_playlist_root_container_real_remove_container_co (_data_);
}

static void
rygel_media_export_playlist_root_container_remove_container_finish (RygelWritableContainer* base,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	RygelMediaExportPlaylistRootContainerRemoveContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_media_export_playlist_root_container_real_remove_container_co (RygelMediaExportPlaylistRootContainerRemoveContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
	rygel_media_export_media_cache_remove_by_id (_data_->_tmp0_, _data_->id, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GeeArrayList*
rygel_media_export_playlist_root_container_real_get_create_classes (RygelWritableContainer* base)
{
	GeeArrayList* result;
	RygelMediaExportPlaylistRootContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	_tmp0_ = self->priv->_create_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_media_export_playlist_root_container_real_set_create_classes (RygelWritableContainer* base,
                                                                    GeeArrayList* value)
{
	RygelMediaExportPlaylistRootContainer* self;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	if (rygel_media_export_playlist_root_container_real_get_create_classes (base) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_create_classes);
		self->priv->_create_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_export_playlist_root_container_properties[RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CREATE_CLASSES_PROPERTY]);
	}
}

static GUPnPOCMFlags
rygel_media_export_playlist_root_container_real_get_ocm_flags (RygelMediaObject* base)
{
	GUPnPOCMFlags result;
	RygelMediaExportPlaylistRootContainer* self;
	GUPnPOCMFlags flags = 0U;
	GUPnPOCMFlags _tmp0_;
	GUPnPOCMFlags _tmp1_;
	GUPnPOCMFlags _tmp2_;
	self = (RygelMediaExportPlaylistRootContainer*) base;
	_tmp0_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_export_playlist_root_container_parent_class)->get_ocm_flags ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer));
	flags = _tmp0_;
	_tmp1_ = flags;
	flags = _tmp1_ & (~(GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE));
	_tmp2_ = flags;
	result = _tmp2_;
	return result;
}

static void
rygel_media_export_playlist_root_container_class_init (RygelMediaExportPlaylistRootContainerClass * klass,
                                                       gpointer klass_data)
{
	rygel_media_export_playlist_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportPlaylistRootContainer_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_export_playlist_root_container_real_constructed;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_export_playlist_root_container_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_playlist_root_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_playlist_root_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_playlist_root_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CREATE_CLASSES_PROPERTY, rygel_media_export_playlist_root_container_properties[RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CREATE_CLASSES_PROPERTY] = g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_OCM_FLAGS_PROPERTY, rygel_media_export_playlist_root_container_properties[RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_OCM_FLAGS_PROPERTY] = g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_media_export_playlist_root_container_rygel_writable_container_interface_init (RygelWritableContainerIface * iface,
                                                                                    gpointer iface_data)
{
	rygel_media_export_playlist_root_container_rygel_writable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_item = (void (*) (RygelWritableContainer*, RygelMediaFileItem*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_playlist_root_container_real_add_item;
	iface->add_item_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_media_export_playlist_root_container_add_item_finish;
	iface->remove_item = (void (*) (RygelWritableContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_playlist_root_container_real_remove_item;
	iface->remove_item_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_media_export_playlist_root_container_remove_item_finish;
	iface->add_container = (void (*) (RygelWritableContainer*, RygelMediaContainer*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_playlist_root_container_real_add_container;
	iface->add_container_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_media_export_playlist_root_container_add_container_finish;
	iface->remove_container = (void (*) (RygelWritableContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_playlist_root_container_real_remove_container;
	iface->remove_container_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_media_export_playlist_root_container_remove_container_finish;
	iface->get_create_classes = rygel_media_export_playlist_root_container_real_get_create_classes;
	iface->set_create_classes = rygel_media_export_playlist_root_container_real_set_create_classes;
}

static void
rygel_media_export_playlist_root_container_instance_init (RygelMediaExportPlaylistRootContainer * self,
                                                          gpointer klass)
{
	self->priv = rygel_media_export_playlist_root_container_get_instance_private (self);
}

static void
rygel_media_export_playlist_root_container_finalize (GObject * obj)
{
	RygelMediaExportPlaylistRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer);
	_g_object_unref0 (self->priv->_create_classes);
	G_OBJECT_CLASS (rygel_media_export_playlist_root_container_parent_class)->finalize (obj);
}

/**
 * Special class for the toplevel virtual container which aggregates all
 * playlists.
 *
 * This is a special class compared to the the other virtual classes as it
 * allows the creation of subfolders to create server-side playlists.
 * It does not allow adding or removal of items, only container adding and
 * removal.
 */
GType
rygel_media_export_playlist_root_container_get_type (void)
{
	static volatile gsize rygel_media_export_playlist_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_playlist_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportPlaylistRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_playlist_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportPlaylistRootContainer), 0, (GInstanceInitFunc) rygel_media_export_playlist_root_container_instance_init, NULL };
		static const GInterfaceInfo rygel_writable_container_info = { (GInterfaceInitFunc) rygel_media_export_playlist_root_container_rygel_writable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_playlist_root_container_type_id;
		rygel_media_export_playlist_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportPlaylistRootContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_playlist_root_container_type_id, RYGEL_TYPE_WRITABLE_CONTAINER, &rygel_writable_container_info);
		RygelMediaExportPlaylistRootContainer_private_offset = g_type_add_instance_private (rygel_media_export_playlist_root_container_type_id, sizeof (RygelMediaExportPlaylistRootContainerPrivate));
		g_once_init_leave (&rygel_media_export_playlist_root_container_type_id__volatile, rygel_media_export_playlist_root_container_type_id);
	}
	return rygel_media_export_playlist_root_container_type_id__volatile;
}

static void
_vala_rygel_media_export_playlist_root_container_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	RygelMediaExportPlaylistRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CREATE_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_writable_container_get_create_classes ((RygelWritableContainer*) self));
		break;
		case RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_OCM_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_export_playlist_root_container_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	RygelMediaExportPlaylistRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CREATE_CLASSES_PROPERTY:
		rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

