/* rygel-external-plugin-factory.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-external-plugin-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gobject/gvaluecollector.h>

#define RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY (rygel_external_plugin_factory_get_type ())
#define RYGEL_EXTERNAL_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactory))
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactoryClass))
#define RYGEL_EXTERNAL_IS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY))
#define RYGEL_EXTERNAL_IS_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY))
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactoryClass))

typedef struct _RygelExternalPluginFactory RygelExternalPluginFactory;
typedef struct _RygelExternalPluginFactoryClass RygelExternalPluginFactoryClass;
#define _rygel_external_plugin_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_plugin_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalPluginFactoryPrivate RygelExternalPluginFactoryPrivate;

#define RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT (rygel_external_free_desktop_dbus_object_get_type ())
#define RYGEL_EXTERNAL_FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT, RygelExternalFreeDesktopDBusObject))
#define RYGEL_EXTERNAL_FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define RYGEL_EXTERNAL_FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT, RygelExternalFreeDesktopDBusObjectIface))

typedef struct _RygelExternalFreeDesktopDBusObject RygelExternalFreeDesktopDBusObject;
typedef struct _RygelExternalFreeDesktopDBusObjectIface RygelExternalFreeDesktopDBusObjectIface;

#define RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY (rygel_external_free_desktop_dbus_object_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_ICON_FACTORY (rygel_external_icon_factory_get_type ())
#define RYGEL_EXTERNAL_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactory))
#define RYGEL_EXTERNAL_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))

typedef struct _RygelExternalIconFactory RygelExternalIconFactory;
typedef struct _RygelExternalIconFactoryClass RygelExternalIconFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_external_icon_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_icon_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelExternalPluginFactoryLoadPluginsData RygelExternalPluginFactoryLoadPluginsData;
typedef struct _RygelExternalPluginFactoryLoadActivatablePluginsData RygelExternalPluginFactoryLoadActivatablePluginsData;
typedef struct _RygelExternalPluginFactoryLoadPluginNHandleErrorData RygelExternalPluginFactoryLoadPluginNHandleErrorData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES (rygel_external_free_desktop_properties_get_type ())
#define RYGEL_EXTERNAL_FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, RygelExternalFreeDesktopProperties))
#define RYGEL_EXTERNAL_FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES))
#define RYGEL_EXTERNAL_FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, RygelExternalFreeDesktopPropertiesIface))

typedef struct _RygelExternalFreeDesktopProperties RygelExternalFreeDesktopProperties;
typedef struct _RygelExternalFreeDesktopPropertiesIface RygelExternalFreeDesktopPropertiesIface;

#define RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES_PROXY (rygel_external_free_desktop_properties_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_PLUGIN (rygel_external_plugin_get_type ())
#define RYGEL_EXTERNAL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPlugin))
#define RYGEL_EXTERNAL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPluginClass))
#define RYGEL_EXTERNAL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN))
#define RYGEL_EXTERNAL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN))
#define RYGEL_EXTERNAL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPluginClass))

typedef struct _RygelExternalPlugin RygelExternalPlugin;
typedef struct _RygelExternalPluginClass RygelExternalPluginClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalPluginFactoryLoadPluginData RygelExternalPluginFactoryLoadPluginData;
typedef struct _RygelExternalParamSpecPluginFactory RygelExternalParamSpecPluginFactory;

struct _RygelExternalPluginFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalPluginFactoryPrivate * priv;
};

struct _RygelExternalPluginFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalPluginFactory *self);
};

struct _RygelExternalFreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (RygelExternalFreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (RygelExternalFreeDesktopDBusObject* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*list_activatable_names) (RygelExternalFreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (RygelExternalFreeDesktopDBusObject* self, GAsyncResult* _res_, gint* result_length1, GError** error);
};

struct _RygelExternalPluginFactoryPrivate {
	RygelExternalFreeDesktopDBusObject* dbus_obj;
	RygelPluginLoader* loader;
	RygelExternalIconFactory* icon_factory;
};

struct _RygelExternalPluginFactoryLoadPluginsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalPluginFactory* self;
	gchar** services;
	RygelExternalFreeDesktopDBusObject* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint services_length1;
	gint _services_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** service_collection;
	gint service_collection_length1;
	gint _service_collection_size_;
	gint service_it;
	gchar* _tmp4_;
	gchar* service;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	RygelPluginLoader* _tmp7_;
	const gchar* _tmp8_;
	RygelPlugin* _tmp9_;
	RygelPlugin* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _RygelExternalPluginFactoryLoadActivatablePluginsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalPluginFactory* self;
	gchar** services;
	RygelExternalFreeDesktopDBusObject* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint services_length1;
	gint _services_size_;
	gchar** service_collection;
	gint service_collection_length1;
	gint _service_collection_size_;
	gint service_it;
	gchar* _tmp3_;
	gchar* service;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	RygelPluginLoader* _tmp6_;
	const gchar* _tmp7_;
	RygelPlugin* _tmp8_;
	RygelPlugin* _tmp9_;
	const gchar* _tmp10_;
	RygelExternalFreeDesktopDBusObject* _tmp11_;
	GError* _inner_error0_;
};

struct _RygelExternalPluginFactoryLoadPluginNHandleErrorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalPluginFactory* self;
	gchar* service_name;
	GError* _error_;
	GError* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_;
};

struct _RygelExternalFreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (RygelExternalFreeDesktopProperties* self, const gchar* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (RygelExternalFreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _RygelExternalPluginFactoryLoadPluginData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalPluginFactory* self;
	gchar* service_name;
	RygelPluginLoader* _tmp0_;
	gchar* root_object;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelExternalFreeDesktopProperties* props;
	const gchar* _tmp5_;
	RygelExternalFreeDesktopProperties* _tmp6_;
	GHashTable* object_props;
	GHashTable* container_props;
	GHashTable* _tmp7_;
	RygelExternalFreeDesktopProperties* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	RygelExternalFreeDesktopProperties* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	RygelIconInfo* icon;
	RygelExternalIconFactory* _tmp15_;
	GHashTable* _tmp16_;
	RygelIconInfo* _tmp17_;
	gchar* title;
	GVariant* value;
	GHashTable* _tmp18_;
	gconstpointer _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	guint child_count;
	GHashTable* _tmp25_;
	gconstpointer _tmp26_;
	guint _tmp27_;
	gboolean searchable;
	GHashTable* _tmp28_;
	gconstpointer _tmp29_;
	gboolean _tmp30_;
	RygelExternalPlugin* plugin;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	RygelIconInfo* _tmp33_;
	RygelExternalPlugin* _tmp34_;
	RygelPluginLoader* _tmp35_;
	RygelExternalPlugin* _tmp36_;
	GError* err;
	GError* _tmp37_;
	const gchar* _tmp38_;
	GError* _inner_error0_;
};

struct _RygelExternalParamSpecPluginFactory {
	GParamSpec parent_instance;
};

extern RygelExternalPluginFactory* plugin_factory;
RygelExternalPluginFactory* plugin_factory = NULL;
static gint RygelExternalPluginFactory_private_offset;
static gpointer rygel_external_plugin_factory_parent_class = NULL;

gpointer rygel_external_plugin_factory_ref (gpointer instance);
void rygel_external_plugin_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_plugin_factory (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
void rygel_external_value_set_plugin_factory (GValue* value,
                                              gpointer v_object);
void rygel_external_value_take_plugin_factory (GValue* value,
                                               gpointer v_object);
gpointer rygel_external_value_get_plugin_factory (const GValue* value);
GType rygel_external_plugin_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelExternalPluginFactory, rygel_external_plugin_factory_unref)
void module_init (RygelPluginLoader* loader);
RygelExternalPluginFactory* rygel_external_plugin_factory_new (RygelPluginLoader* loader,
                                                               GError** error);
RygelExternalPluginFactory* rygel_external_plugin_factory_construct (GType object_type,
                                                                     RygelPluginLoader* loader,
                                                                     GError** error);
#define RYGEL_EXTERNAL_PLUGIN_MODULE_NAME "External"
GType rygel_external_free_desktop_dbus_object_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_free_desktop_dbus_object_register_object (void* object,
                                                               GDBusConnection* connection,
                                                               const gchar* path,
                                                               GError** error);
GType rygel_external_free_desktop_dbus_object_get_type (void) G_GNUC_CONST;
gpointer rygel_external_icon_factory_ref (gpointer instance);
void rygel_external_icon_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_icon_factory (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void rygel_external_value_set_icon_factory (GValue* value,
                                            gpointer v_object);
void rygel_external_value_take_icon_factory (GValue* value,
                                             gpointer v_object);
gpointer rygel_external_value_get_icon_factory (const GValue* value);
GType rygel_external_icon_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelExternalIconFactory, rygel_external_icon_factory_unref)
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX "org.gnome.UPnP.MediaServer2."
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_GRILO_UPNP_PREFIX RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX "grl_upnp"
RygelExternalIconFactory* rygel_external_icon_factory_new (void);
RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type);
#define RYGEL_EXTERNAL_FREE_DESKTOP_DBUS_SERVICE "org.freedesktop.DBus"
#define RYGEL_EXTERNAL_FREE_DESKTOP_DBUS_OBJECT_PATH "/org/freedesktop/DBus"
static void rygel_external_plugin_factory_load_plugins (RygelExternalPluginFactory* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugins_finish (RygelExternalPluginFactory* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void rygel_external_plugin_factory_load_plugins_data_free (gpointer _data);
static gboolean rygel_external_plugin_factory_load_plugins_co (RygelExternalPluginFactoryLoadPluginsData* _data_);
void rygel_external_free_desktop_dbus_object_list_names (RygelExternalFreeDesktopDBusObject* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
gchar** rygel_external_free_desktop_dbus_object_list_names_finish (RygelExternalFreeDesktopDBusObject* self,
                                                                   GAsyncResult* _res_,
                                                                   gint* result_length1,
                                                                   GError** error);
static void rygel_external_plugin_factory_load_plugins_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugin_n_handle_error (RygelExternalPluginFactory* self,
                                                               const gchar* service_name,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugin_n_handle_error_finish (RygelExternalPluginFactory* self,
                                                                      GAsyncResult* _res_);
static void rygel_external_plugin_factory_load_activatable_plugins (RygelExternalPluginFactory* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void rygel_external_plugin_factory_load_activatable_plugins_finish (RygelExternalPluginFactory* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static void rygel_external_plugin_factory_load_activatable_plugins_data_free (gpointer _data);
static gboolean rygel_external_plugin_factory_load_activatable_plugins_co (RygelExternalPluginFactoryLoadActivatablePluginsData* _data_);
void rygel_external_free_desktop_dbus_object_list_activatable_names (RygelExternalFreeDesktopDBusObject* self,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_);
gchar** rygel_external_free_desktop_dbus_object_list_activatable_names_finish (RygelExternalFreeDesktopDBusObject* self,
                                                                               GAsyncResult* _res_,
                                                                               gint* result_length1,
                                                                               GError** error);
static void rygel_external_plugin_factory_load_activatable_plugins_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void rygel_external_plugin_factory_name_owner_changed (RygelExternalPluginFactory* self,
                                                       RygelExternalFreeDesktopDBusObject* dbus_obj,
                                                       const gchar* name,
                                                       const gchar* old_owner,
                                                       const gchar* new_owner);
static void _rygel_external_plugin_factory_name_owner_changed_rygel_external_free_desktop_dbus_object_name_owner_changed (RygelExternalFreeDesktopDBusObject* _sender,
                                                                                                                   const gchar* name,
                                                                                                                   const gchar* old_owner,
                                                                                                                   const gchar* new_owner,
                                                                                                                   gpointer self);
static void rygel_external_plugin_factory_load_plugin_n_handle_error_data_free (gpointer _data);
static gboolean rygel_external_plugin_factory_load_plugin_n_handle_error_co (RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_);
static void rygel_external_plugin_factory_load_plugin (RygelExternalPluginFactory* self,
                                                const gchar* service_name,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugin_finish (RygelExternalPluginFactory* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void rygel_external_plugin_factory_load_plugin_n_handle_error_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugin_data_free (gpointer _data);
static gboolean rygel_external_plugin_factory_load_plugin_co (RygelExternalPluginFactoryLoadPluginData* _data_);
GType rygel_external_free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_free_desktop_properties_register_object (void* object,
                                                              GDBusConnection* connection,
                                                              const gchar* path,
                                                              GError** error);
GType rygel_external_free_desktop_properties_get_type (void) G_GNUC_CONST;
static void rygel_external_plugin_factory_load_plugin_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
void rygel_external_free_desktop_properties_get_all (RygelExternalFreeDesktopProperties* self,
                                                     const gchar* iface,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
GHashTable* rygel_external_free_desktop_properties_get_all_finish (RygelExternalFreeDesktopProperties* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE "org.gnome.UPnP.MediaObject2"
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE "org.gnome.UPnP.MediaContainer2"
void rygel_external_icon_factory_create (RygelExternalIconFactory* self,
                                         const gchar* service_name,
                                         GHashTable* container_props,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
static gchar* _variant_get25 (GVariant* value);
static guint _variant_get26 (GVariant* value);
static gboolean _variant_get27 (GVariant* value);
GType rygel_external_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelExternalPlugin, g_object_unref)
RygelExternalPlugin* rygel_external_plugin_new (const gchar* service_name,
                                                const gchar* title,
                                                guint child_count,
                                                gboolean searchable,
                                                const gchar* root_object,
                                                RygelIconInfo* icon,
                                                GError** error);
RygelExternalPlugin* rygel_external_plugin_construct (GType object_type,
                                                      const gchar* service_name,
                                                      const gchar* title,
                                                      guint child_count,
                                                      gboolean searchable,
                                                      const gchar* root_object,
                                                      RygelIconInfo* icon,
                                                      GError** error);
static void rygel_external_plugin_factory_finalize (RygelExternalPluginFactory * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

void
module_init (RygelPluginLoader* loader)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (loader != NULL);
	{
		RygelExternalPluginFactory* _tmp0_ = NULL;
		RygelExternalPluginFactory* _tmp1_;
		RygelExternalPluginFactory* _tmp2_;
		_tmp1_ = rygel_external_plugin_factory_new (loader, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_rygel_external_plugin_factory_unref0 (plugin_factory);
		plugin_factory = _tmp2_;
		_rygel_external_plugin_factory_unref0 (_tmp0_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		g_message (_ ("Module “%s” could not connect to D-Bus session bus. " "Ignoring…"), RYGEL_EXTERNAL_PLUGIN_MODULE_NAME);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline gpointer
rygel_external_plugin_factory_get_instance_private (RygelExternalPluginFactory* self)
{
	return G_STRUCT_MEMBER_P (self, RygelExternalPluginFactory_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelExternalPluginFactory*
rygel_external_plugin_factory_construct (GType object_type,
                                         RygelPluginLoader* loader,
                                         GError** error)
{
	RygelExternalPluginFactory* self = NULL;
	RygelExternalIconFactory* _tmp0_;
	RygelExternalFreeDesktopDBusObject* _tmp1_ = NULL;
	RygelExternalFreeDesktopDBusObject* _tmp2_;
	RygelExternalFreeDesktopDBusObject* _tmp3_;
	RygelPluginLoader* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (loader != NULL, NULL);
	self = (RygelExternalPluginFactory*) g_type_create_instance (object_type);
	_tmp0_ = rygel_external_icon_factory_new ();
	_rygel_external_icon_factory_unref0 (self->priv->icon_factory);
	self->priv->icon_factory = _tmp0_;
	_tmp2_ = (RygelExternalFreeDesktopDBusObject*) g_initable_new (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_EXTERNAL_FREE_DESKTOP_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_EXTERNAL_FREE_DESKTOP_DBUS_OBJECT_PATH, "g-interface-name", "org.freedesktop.DBus", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_DBUS_OBJECT, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp1_ = (RygelExternalFreeDesktopDBusObject*) _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_IO_ERROR) || (_inner_error0_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_rygel_external_plugin_factory_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->dbus_obj);
	self->priv->dbus_obj = _tmp3_;
	_tmp4_ = _g_object_ref0 (loader);
	_g_object_unref0 (self->priv->loader);
	self->priv->loader = _tmp4_;
	rygel_external_plugin_factory_load_plugins (self, NULL, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

RygelExternalPluginFactory*
rygel_external_plugin_factory_new (RygelPluginLoader* loader,
                                   GError** error)
{
	return rygel_external_plugin_factory_construct (RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, loader, error);
}

static void
rygel_external_plugin_factory_load_plugins_data_free (gpointer _data)
{
	RygelExternalPluginFactoryLoadPluginsData* _data_;
	_data_ = _data;
	_rygel_external_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalPluginFactoryLoadPluginsData, _data_);
}

static gpointer
_rygel_external_plugin_factory_ref0 (gpointer self)
{
	return self ? rygel_external_plugin_factory_ref (self) : NULL;
}

static void
rygel_external_plugin_factory_load_plugins (RygelExternalPluginFactory* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadPluginsData* _data_;
	RygelExternalPluginFactory* _tmp0_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadPluginsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_plugin_factory_load_plugins_data_free);
	_tmp0_ = _rygel_external_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	rygel_external_plugin_factory_load_plugins_co (_data_);
}

static void
rygel_external_plugin_factory_load_plugins_finish (RygelExternalPluginFactory* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	RygelExternalPluginFactoryLoadPluginsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_external_plugin_factory_load_plugins_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadPluginsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_plugin_factory_load_plugins_co (_data_);
}

static gboolean
rygel_external_plugin_factory_load_plugins_co (RygelExternalPluginFactoryLoadPluginsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->dbus_obj;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	rygel_external_free_desktop_dbus_object_list_names (_data_->_tmp0_, rygel_external_plugin_factory_load_plugins_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_external_free_desktop_dbus_object_list_names_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->services = _data_->_tmp2_;
	_data_->services_length1 = _data_->_tmp1_;
	_data_->_services_size_ = _data_->services_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->services;
	_data_->_tmp3__length1 = _data_->services_length1;
	{
		_data_->service_collection_length1 = 0;
		_data_->_service_collection_size_ = 0;
		_data_->service_collection = _data_->_tmp3_;
		_data_->service_collection_length1 = _data_->_tmp3__length1;
		for (_data_->service_it = 0; _data_->service_it < _data_->_tmp3__length1; _data_->service_it = _data_->service_it + 1) {
			_data_->_tmp4_ = g_strdup (_data_->service_collection[_data_->service_it]);
			_data_->service = _data_->_tmp4_;
			{
				_data_->_tmp6_ = _data_->service;
				if (g_str_has_prefix (_data_->_tmp6_, RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX)) {
					_data_->_tmp7_ = _data_->self->priv->loader;
					_data_->_tmp8_ = _data_->service;
					_data_->_tmp9_ = rygel_plugin_loader_get_plugin_by_name (_data_->_tmp7_, _data_->_tmp8_);
					_data_->_tmp10_ = _data_->_tmp9_;
					_data_->_tmp5_ = _data_->_tmp10_ == NULL;
					_g_object_unref0 (_data_->_tmp10_);
				} else {
					_data_->_tmp5_ = FALSE;
				}
				if (_data_->_tmp5_) {
					_data_->_tmp11_ = _data_->service;
					_data_->_state_ = 2;
					rygel_external_plugin_factory_load_plugin_n_handle_error (_data_->self, _data_->_tmp11_, rygel_external_plugin_factory_load_plugins_ready, _data_);
					return FALSE;
					_state_2:
					rygel_external_plugin_factory_load_plugin_n_handle_error_finish (_data_->self, _data_->_res_);
				}
				_g_free0 (_data_->service);
			}
		}
	}
	_data_->_state_ = 3;
	rygel_external_plugin_factory_load_activatable_plugins (_data_->self, rygel_external_plugin_factory_load_plugins_ready, _data_);
	return FALSE;
	_state_3:
	rygel_external_plugin_factory_load_activatable_plugins_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_plugin_factory_load_activatable_plugins_data_free (gpointer _data)
{
	RygelExternalPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = _data;
	_rygel_external_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalPluginFactoryLoadActivatablePluginsData, _data_);
}

static void
rygel_external_plugin_factory_load_activatable_plugins (RygelExternalPluginFactory* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadActivatablePluginsData* _data_;
	RygelExternalPluginFactory* _tmp0_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadActivatablePluginsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_plugin_factory_load_activatable_plugins_data_free);
	_tmp0_ = _rygel_external_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	rygel_external_plugin_factory_load_activatable_plugins_co (_data_);
}

static void
rygel_external_plugin_factory_load_activatable_plugins_finish (RygelExternalPluginFactory* self,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	RygelExternalPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_external_plugin_factory_load_activatable_plugins_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_plugin_factory_load_activatable_plugins_co (_data_);
}

static void
_rygel_external_plugin_factory_name_owner_changed_rygel_external_free_desktop_dbus_object_name_owner_changed (RygelExternalFreeDesktopDBusObject* _sender,
                                                                                                              const gchar* name,
                                                                                                              const gchar* old_owner,
                                                                                                              const gchar* new_owner,
                                                                                                              gpointer self)
{
	rygel_external_plugin_factory_name_owner_changed ((RygelExternalPluginFactory*) self, _sender, name, old_owner, new_owner);
}

static gboolean
rygel_external_plugin_factory_load_activatable_plugins_co (RygelExternalPluginFactoryLoadActivatablePluginsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->dbus_obj;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	rygel_external_free_desktop_dbus_object_list_activatable_names (_data_->_tmp0_, rygel_external_plugin_factory_load_activatable_plugins_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_external_free_desktop_dbus_object_list_activatable_names_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->services = _data_->_tmp2_;
	_data_->services_length1 = _data_->_tmp1_;
	_data_->_services_size_ = _data_->services_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->service_collection_length1 = 0;
		_data_->_service_collection_size_ = 0;
		_data_->service_collection = _data_->services;
		_data_->service_collection_length1 = _data_->services_length1;
		for (_data_->service_it = 0; _data_->service_it < _data_->services_length1; _data_->service_it = _data_->service_it + 1) {
			_data_->_tmp3_ = g_strdup (_data_->service_collection[_data_->service_it]);
			_data_->service = _data_->_tmp3_;
			{
				_data_->_tmp5_ = _data_->service;
				if (g_str_has_prefix (_data_->_tmp5_, RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX)) {
					_data_->_tmp6_ = _data_->self->priv->loader;
					_data_->_tmp7_ = _data_->service;
					_data_->_tmp8_ = rygel_plugin_loader_get_plugin_by_name (_data_->_tmp6_, _data_->_tmp7_);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp4_ = _data_->_tmp9_ == NULL;
					_g_object_unref0 (_data_->_tmp9_);
				} else {
					_data_->_tmp4_ = FALSE;
				}
				if (_data_->_tmp4_) {
					_data_->_tmp10_ = _data_->service;
					_data_->_state_ = 2;
					rygel_external_plugin_factory_load_plugin_n_handle_error (_data_->self, _data_->_tmp10_, rygel_external_plugin_factory_load_activatable_plugins_ready, _data_);
					return FALSE;
					_state_2:
					rygel_external_plugin_factory_load_plugin_n_handle_error_finish (_data_->self, _data_->_res_);
				}
				_g_free0 (_data_->service);
			}
		}
	}
	_data_->_tmp11_ = _data_->self->priv->dbus_obj;
	g_signal_connect (_data_->_tmp11_, "name-owner-changed", (GCallback) _rygel_external_plugin_factory_name_owner_changed_rygel_external_free_desktop_dbus_object_name_owner_changed, _data_->self);
	_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_plugin_factory_name_owner_changed (RygelExternalPluginFactory* self,
                                                  RygelExternalFreeDesktopDBusObject* dbus_obj,
                                                  const gchar* name,
                                                  const gchar* old_owner,
                                                  const gchar* new_owner)
{
	RygelPlugin* plugin = NULL;
	RygelPluginLoader* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (old_owner != NULL);
	g_return_if_fail (new_owner != NULL);
	_tmp0_ = self->priv->loader;
	_tmp1_ = rygel_plugin_loader_get_plugin_by_name (_tmp0_, name);
	plugin = _tmp1_;
	_tmp2_ = plugin;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		if (g_strcmp0 (old_owner, "") != 0) {
			_tmp3_ = g_strcmp0 (new_owner, "") == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			RygelPlugin* _tmp4_;
			g_debug ("rygel-external-plugin-factory.vala:95: Service '%s' going down, deacti" \
"vating it", name);
			_tmp4_ = plugin;
			rygel_plugin_set_active (_tmp4_, FALSE);
		} else {
			gboolean _tmp5_ = FALSE;
			if (g_strcmp0 (old_owner, "") == 0) {
				_tmp5_ = g_strcmp0 (new_owner, "") != 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				RygelPlugin* _tmp6_;
				g_debug ("rygel-external-plugin-factory.vala:99: Service '%s' up again, activati" \
"ng it", name);
				_tmp6_ = plugin;
				rygel_plugin_set_active (_tmp6_, TRUE);
			}
		}
	} else {
		if (g_str_has_prefix (name, RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX)) {
			rygel_external_plugin_factory_load_plugin_n_handle_error (self, name, NULL, NULL);
		}
	}
	_g_object_unref0 (plugin);
}

static void
rygel_external_plugin_factory_load_plugin_n_handle_error_data_free (gpointer _data)
{
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = _data;
	_g_free0 (_data_->service_name);
	_rygel_external_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalPluginFactoryLoadPluginNHandleErrorData, _data_);
}

static void
rygel_external_plugin_factory_load_plugin_n_handle_error (RygelExternalPluginFactory* self,
                                                          const gchar* service_name,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_;
	RygelExternalPluginFactory* _tmp0_;
	gchar* _tmp1_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadPluginNHandleErrorData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_plugin_factory_load_plugin_n_handle_error_data_free);
	_tmp0_ = _rygel_external_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp1_;
	rygel_external_plugin_factory_load_plugin_n_handle_error_co (_data_);
}

static void
rygel_external_plugin_factory_load_plugin_n_handle_error_finish (RygelExternalPluginFactory* self,
                                                                 GAsyncResult* _res_)
{
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_external_plugin_factory_load_plugin_n_handle_error_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_plugin_factory_load_plugin_n_handle_error_co (_data_);
}

static gboolean
rygel_external_plugin_factory_load_plugin_n_handle_error_co (RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		rygel_external_plugin_factory_load_plugin (_data_->self, _data_->service_name, rygel_external_plugin_factory_load_plugin_n_handle_error_ready, _data_);
		return FALSE;
		_state_1:
		rygel_external_plugin_factory_load_plugin_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->_error_;
		_data_->_tmp1_ = _data_->_tmp0_->message;
		g_warning ("rygel-external-plugin-factory.vala:112: Failed to load external plugin" \
" '%s': %s", _data_->service_name, _data_->_tmp1_);
		_g_error_free0 (_data_->_error_);
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_plugin_factory_load_plugin_data_free (gpointer _data)
{
	RygelExternalPluginFactoryLoadPluginData* _data_;
	_data_ = _data;
	_g_free0 (_data_->service_name);
	_rygel_external_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalPluginFactoryLoadPluginData, _data_);
}

static void
rygel_external_plugin_factory_load_plugin (RygelExternalPluginFactory* self,
                                           const gchar* service_name,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadPluginData* _data_;
	RygelExternalPluginFactory* _tmp0_;
	gchar* _tmp1_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadPluginData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_plugin_factory_load_plugin_data_free);
	_tmp0_ = _rygel_external_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp1_;
	rygel_external_plugin_factory_load_plugin_co (_data_);
}

static void
rygel_external_plugin_factory_load_plugin_finish (RygelExternalPluginFactory* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	RygelExternalPluginFactoryLoadPluginData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
rygel_external_plugin_factory_load_plugin_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	RygelExternalPluginFactoryLoadPluginData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_plugin_factory_load_plugin_co (_data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
_variant_get25 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static guint
_variant_get26 (GVariant* value)
{
	return g_variant_get_uint32 (value);
}

static gboolean
_variant_get27 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static gboolean
rygel_external_plugin_factory_load_plugin_co (RygelExternalPluginFactoryLoadPluginData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->loader;
	if (rygel_plugin_loader_plugin_disabled (_data_->_tmp0_, _data_->service_name)) {
		g_message ("rygel-external-plugin-factory.vala:121: Plugin '%s' disabled by user, " \
"ignoring..", _data_->service_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_str_has_prefix (_data_->service_name, RYGEL_EXTERNAL_PLUGIN_FACTORY_GRILO_UPNP_PREFIX)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = string_replace (_data_->service_name, ".", "/");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strconcat ("/", _data_->_tmp2_, NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->root_object = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->root_object;
	_data_->_state_ = 1;
	g_async_initable_new_async (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_plugin_factory_load_plugin_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp5_, "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = (RygelExternalFreeDesktopProperties*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
	_data_->props = (RygelExternalFreeDesktopProperties*) _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->root_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp8_ = _data_->props;
	_data_->_state_ = 2;
	rygel_external_free_desktop_properties_get_all (_data_->_tmp8_, RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE, rygel_external_plugin_factory_load_plugin_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp9_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp7_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp10_ = _data_->_tmp7_;
	_data_->_tmp7_ = NULL;
	_g_hash_table_unref0 (_data_->object_props);
	_data_->object_props = _data_->_tmp10_;
	_data_->_tmp12_ = _data_->props;
	_data_->_state_ = 3;
	rygel_external_free_desktop_properties_get_all (_data_->_tmp12_, RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE, rygel_external_plugin_factory_load_plugin_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp13_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp11_ = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp14_ = _data_->_tmp11_;
	_data_->_tmp11_ = NULL;
	_g_hash_table_unref0 (_data_->container_props);
	_data_->container_props = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->icon_factory;
	_data_->_tmp16_ = _data_->container_props;
	_data_->_state_ = 4;
	rygel_external_icon_factory_create (_data_->_tmp15_, _data_->service_name, _data_->_tmp16_, rygel_external_plugin_factory_load_plugin_ready, _data_);
	return FALSE;
	_state_4:
	_data_->_tmp17_ = rygel_external_icon_factory_create_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
	_data_->icon = _data_->_tmp17_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->_tmp11_);
			_g_hash_table_unref0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->_tmp11_);
			_g_hash_table_unref0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp18_ = _data_->object_props;
	_data_->_tmp19_ = g_hash_table_lookup (_data_->_tmp18_, "DisplayName");
	_data_->_tmp20_ = _g_variant_ref0 ((GVariant*) _data_->_tmp19_);
	_data_->value = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->value;
	if (_data_->_tmp21_ != NULL) {
		_data_->_tmp22_ = _data_->value;
		_data_->_tmp23_ = _variant_get25 (_data_->_tmp22_);
		_g_free0 (_data_->title);
		_data_->title = _data_->_tmp23_;
	} else {
		_data_->_tmp24_ = g_strdup (_data_->service_name);
		_g_free0 (_data_->title);
		_data_->title = _data_->_tmp24_;
	}
	_data_->_tmp25_ = _data_->container_props;
	_data_->_tmp26_ = g_hash_table_lookup (_data_->_tmp25_, "ChildCount");
	_data_->_tmp27_ = _variant_get26 ((GVariant*) _data_->_tmp26_);
	_data_->child_count = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->container_props;
	_data_->_tmp29_ = g_hash_table_lookup (_data_->_tmp28_, "Searchable");
	_data_->_tmp30_ = _variant_get27 ((GVariant*) _data_->_tmp29_);
	_data_->searchable = _data_->_tmp30_;
	{
		_data_->_tmp31_ = _data_->title;
		_data_->_tmp32_ = _data_->root_object;
		_data_->_tmp33_ = _data_->icon;
		_data_->_tmp34_ = rygel_external_plugin_new (_data_->service_name, _data_->_tmp31_, _data_->child_count, _data_->searchable, _data_->_tmp32_, _data_->_tmp33_, &_data_->_inner_error0_);
		_data_->plugin = _data_->_tmp34_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch5_g_error;
		}
		_data_->_tmp35_ = _data_->self->priv->loader;
		_data_->_tmp36_ = _data_->plugin;
		rygel_plugin_loader_add_plugin (_data_->_tmp35_, (RygelPlugin*) _data_->_tmp36_);
		_g_object_unref0 (_data_->plugin);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp37_ = _data_->err;
		_data_->_tmp38_ = _data_->_tmp37_->message;
		g_critical ("Failed to create root container for '%s': %s. " "Ignoring", _data_->service_name, _data_->_tmp38_);
		_g_error_free0 (_data_->err);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_IO_ERROR) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_variant_unref0 (_data_->value);
			_g_free0 (_data_->title);
			_rygel_icon_info_unref0 (_data_->icon);
			_g_hash_table_unref0 (_data_->_tmp11_);
			_g_hash_table_unref0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_variant_unref0 (_data_->value);
			_g_free0 (_data_->title);
			_rygel_icon_info_unref0 (_data_->icon);
			_g_hash_table_unref0 (_data_->_tmp11_);
			_g_hash_table_unref0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->container_props);
			_g_hash_table_unref0 (_data_->object_props);
			_g_object_unref0 (_data_->props);
			_g_free0 (_data_->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_variant_unref0 (_data_->value);
	_g_free0 (_data_->title);
	_rygel_icon_info_unref0 (_data_->icon);
	_g_hash_table_unref0 (_data_->_tmp11_);
	_g_hash_table_unref0 (_data_->_tmp7_);
	_g_hash_table_unref0 (_data_->container_props);
	_g_hash_table_unref0 (_data_->object_props);
	_g_object_unref0 (_data_->props);
	_g_free0 (_data_->root_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_value_plugin_factory_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_external_value_plugin_factory_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_external_plugin_factory_unref (value->data[0].v_pointer);
	}
}

static void
rygel_external_value_plugin_factory_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_plugin_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_external_value_plugin_factory_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_external_value_plugin_factory_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelExternalPluginFactory * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_plugin_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_external_value_plugin_factory_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	RygelExternalPluginFactory ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_plugin_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_external_param_spec_plugin_factory (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	RygelExternalParamSpecPluginFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_external_value_get_plugin_factory (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY), NULL);
	return value->data[0].v_pointer;
}

void
rygel_external_value_set_plugin_factory (GValue* value,
                                         gpointer v_object)
{
	RygelExternalPluginFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_plugin_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_plugin_factory_unref (old);
	}
}

void
rygel_external_value_take_plugin_factory (GValue* value,
                                          gpointer v_object)
{
	RygelExternalPluginFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_plugin_factory_unref (old);
	}
}

static void
rygel_external_plugin_factory_class_init (RygelExternalPluginFactoryClass * klass,
                                          gpointer klass_data)
{
	rygel_external_plugin_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelExternalPluginFactoryClass *) klass)->finalize = rygel_external_plugin_factory_finalize;
	g_type_class_adjust_private_offset (klass, &RygelExternalPluginFactory_private_offset);
}

static void
rygel_external_plugin_factory_instance_init (RygelExternalPluginFactory * self,
                                             gpointer klass)
{
	self->priv = rygel_external_plugin_factory_get_instance_private (self);
	self->ref_count = 1;
}

static void
rygel_external_plugin_factory_finalize (RygelExternalPluginFactory * obj)
{
	RygelExternalPluginFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactory);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dbus_obj);
	_g_object_unref0 (self->priv->loader);
	_rygel_external_icon_factory_unref0 (self->priv->icon_factory);
}

GType
rygel_external_plugin_factory_get_type (void)
{
	static volatile gsize rygel_external_plugin_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_plugin_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_plugin_factory_init, rygel_external_value_plugin_factory_free_value, rygel_external_value_plugin_factory_copy_value, rygel_external_value_plugin_factory_peek_pointer, "p", rygel_external_value_plugin_factory_collect_value, "p", rygel_external_value_plugin_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalPluginFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_plugin_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalPluginFactory), 0, (GInstanceInitFunc) rygel_external_plugin_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_plugin_factory_type_id;
		rygel_external_plugin_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalPluginFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		RygelExternalPluginFactory_private_offset = g_type_add_instance_private (rygel_external_plugin_factory_type_id, sizeof (RygelExternalPluginFactoryPrivate));
		g_once_init_leave (&rygel_external_plugin_factory_type_id__volatile, rygel_external_plugin_factory_type_id);
	}
	return rygel_external_plugin_factory_type_id__volatile;
}

gpointer
rygel_external_plugin_factory_ref (gpointer instance)
{
	RygelExternalPluginFactory * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_external_plugin_factory_unref (gpointer instance)
{
	RygelExternalPluginFactory * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_PLUGIN_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

