/* rygel-plugin.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <config.h>

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5,
	RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT = 1 << 6
} RygelPluginCapabilities;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
enum  {
	RYGEL_PLUGIN_0_PROPERTY,
	RYGEL_PLUGIN_CAPABILITIES_PROPERTY,
	RYGEL_PLUGIN_NAME_PROPERTY,
	RYGEL_PLUGIN_TITLE_PROPERTY,
	RYGEL_PLUGIN_DESCRIPTION_PROPERTY,
	RYGEL_PLUGIN_DESC_PATH_PROPERTY,
	RYGEL_PLUGIN_ACTIVE_PROPERTY,
	RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY,
	RYGEL_PLUGIN_ICON_INFOS_PROPERTY,
	RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY,
	RYGEL_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* rygel_plugin_properties[RYGEL_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT (rygel_basic_management_get_type ())
#define RYGEL_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement))
#define RYGEL_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))
#define RYGEL_IS_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_IS_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_BASIC_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))

typedef struct _RygelBasicManagement RygelBasicManagement;
typedef struct _RygelBasicManagementClass RygelBasicManagementClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ENERGY_MANAGEMENT (rygel_energy_management_get_type ())
#define RYGEL_ENERGY_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagement))
#define RYGEL_ENERGY_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementClass))
#define RYGEL_IS_ENERGY_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT))
#define RYGEL_IS_ENERGY_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENERGY_MANAGEMENT))
#define RYGEL_ENERGY_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementClass))

typedef struct _RygelEnergyManagement RygelEnergyManagement;
typedef struct _RygelEnergyManagementClass RygelEnergyManagementClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
	void (*apply_hacks) (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
};

struct _RygelPluginPrivate {
	RygelPluginCapabilities _capabilities;
	gchar* _name;
	gchar* _title;
	gchar* _description;
	gchar* _desc_path;
	gboolean _active;
	GeeArrayList* _resource_infos;
	GeeArrayList* _icon_infos;
	GeeArrayList* _default_icons;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error) G_GNUC_DEPRECATED;
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()
struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

static gint RygelPlugin_private_offset;
static gpointer rygel_plugin_parent_class = NULL;

GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlugin, g_object_unref)
GType rygel_root_device_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelRootDevice, g_object_unref)
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void rygel_value_set_resource_info (GValue* value,
                                    gpointer v_object);
void rygel_value_take_resource_info (GValue* value,
                                     gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelResourceInfo, rygel_resource_info_unref)
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void rygel_value_set_icon_info (GValue* value,
                                gpointer v_object);
void rygel_value_take_icon_info (GValue* value,
                                 gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelIconInfo, rygel_icon_info_unref)
#define RYGEL_PLUGIN_PNG_EXT "png"
#define RYGEL_PLUGIN_JPG_EXT "jpg"
#define RYGEL_PLUGIN_ICON_BIG "file://" BIG_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_SMALL "file://" SMALL_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_PNG_MIME "image/png"
#define RYGEL_PLUGIN_ICON_JPG_MIME "image/jpeg"
#define RYGEL_PLUGIN_ICON_PNG_DEPTH 24
#define RYGEL_PLUGIN_ICON_JPG_DEPTH 24
#define RYGEL_PLUGIN_ICON_BIG_WIDTH 120
#define RYGEL_PLUGIN_ICON_BIG_HEIGHT 120
#define RYGEL_PLUGIN_ICON_SMALL_WIDTH 48
#define RYGEL_PLUGIN_ICON_SMALL_HEIGHT 48
RygelPlugin* rygel_plugin_new (const gchar* desc_path,
                               const gchar* name,
                               const gchar* title,
                               const gchar* description,
                               RygelPluginCapabilities capabilities);
RygelPlugin* rygel_plugin_construct (GType object_type,
                                     const gchar* desc_path,
                                     const gchar* name,
                                     const gchar* title,
                                     const gchar* description,
                                     RygelPluginCapabilities capabilities);
static void rygel_plugin_real_constructed (GObject* base);
void rygel_plugin_set_active (RygelPlugin* self,
                              gboolean value);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
void rygel_plugin_set_title (RygelPlugin* self,
                             const gchar* value);
static void rygel_plugin_set_resource_infos (RygelPlugin* self,
                                      GeeArrayList* value);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMetaConfig, g_object_unref)
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_bool (RygelConfiguration* self,
                                       const gchar* section,
                                       const gchar* key,
                                       GError** error);
#define RYGEL_BASIC_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:BasicManagement"
#define RYGEL_BASIC_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:BasicManagement:2"
#define RYGEL_BASIC_MANAGEMENT_DESCRIPTION_PATH "xml/BasicManagement2.xml"
GType rygel_basic_management_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelBasicManagement, g_object_unref)
RygelResourceInfo* rygel_resource_info_new (const gchar* upnp_id,
                                            const gchar* upnp_type,
                                            const gchar* description_path,
                                            GType type);
RygelResourceInfo* rygel_resource_info_construct (GType object_type,
                                                  const gchar* upnp_id,
                                                  const gchar* upnp_type,
                                                  const gchar* description_path,
                                                  GType type);
void rygel_plugin_add_resource (RygelPlugin* self,
                                RygelResourceInfo* resource_info);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
void rygel_plugin_set_capabilities (RygelPlugin* self,
                                    RygelPluginCapabilities value);
GQuark rygel_configuration_error_quark (void);
#define RYGEL_ENERGY_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:EnergyManagement"
#define RYGEL_ENERGY_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:EnergyManagement:1"
#define RYGEL_ENERGY_MANAGEMENT_DESCRIPTION_PATH "xml/EnergyManagement.xml"
GType rygel_energy_management_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelEnergyManagement, g_object_unref)
static void rygel_plugin_set_icon_infos (RygelPlugin* self,
                                  GeeArrayList* value);
static void rygel_plugin_set_default_icons (RygelPlugin* self,
                                     GeeArrayList* value);
static void rygel_plugin_add_default_icon (RygelPlugin* self,
                                    const gchar* mime_type,
                                    const gchar* file_extension,
                                    const gchar* uri,
                                    gint width,
                                    gint height,
                                    gint depth);
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
void rygel_plugin_add_icon (RygelPlugin* self,
                            RygelIconInfo* icon_info);
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
void rygel_plugin_apply_hacks (RygelPlugin* self,
                               RygelRootDevice* device,
                               const gchar* description_path,
                               GError** error);
static void rygel_plugin_real_apply_hacks (RygelPlugin* self,
                                    RygelRootDevice* device,
                                    const gchar* description_path,
                                    GError** error);
RygelIconInfo* rygel_icon_info_new (const gchar* mime_type,
                                    const gchar* file_extension);
RygelIconInfo* rygel_icon_info_construct (GType object_type,
                                          const gchar* mime_type,
                                          const gchar* file_extension);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
static void rygel_plugin_set_name (RygelPlugin* self,
                            const gchar* value);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
static void rygel_plugin_set_description (RygelPlugin* self,
                                   const gchar* value);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static void rygel_plugin_set_desc_path (RygelPlugin* self,
                                 const gchar* value);
gboolean rygel_plugin_get_active (RygelPlugin* self);
static void rygel_plugin_finalize (GObject * obj);
static void _vala_rygel_plugin_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_rygel_plugin_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

/**
 * RygelPluginCapabilities is a set of flags that represent various
 * capabilities of plugins.
 */
GType
rygel_plugin_capabilities_get_type (void)
{
	static volatile gsize rygel_plugin_capabilities_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_capabilities_type_id__volatile)) {
		static const GFlagsValue values[] = {{RYGEL_PLUGIN_CAPABILITIES_NONE, "RYGEL_PLUGIN_CAPABILITIES_NONE", "none"}, {RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD", "image-upload"}, {RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD", "video-upload"}, {RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD", "audio-upload"}, {RYGEL_PLUGIN_CAPABILITIES_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_UPLOAD", "upload"}, {RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES, "RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES", "track-changes"}, {RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS, "RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS", "create-containers"}, {RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS, "RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS", "diagnostics"}, {RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT, "RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT", "energy-management"}, {0, NULL, NULL}};
		GType rygel_plugin_capabilities_type_id;
		rygel_plugin_capabilities_type_id = g_flags_register_static ("RygelPluginCapabilities", values);
		g_once_init_leave (&rygel_plugin_capabilities_type_id__volatile, rygel_plugin_capabilities_type_id);
	}
	return rygel_plugin_capabilities_type_id__volatile;
}

static inline gpointer
rygel_plugin_get_instance_private (RygelPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlugin_private_offset);
}

/** 
     * Create an instance of the plugin.
     *
     * @param desc_path The path of a template file for an XML description of the UPnP service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP service provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelPlugin*
rygel_plugin_construct (GType object_type,
                        const gchar* desc_path,
                        const gchar* name,
                        const gchar* title,
                        const gchar* description,
                        RygelPluginCapabilities capabilities)
{
	RygelPlugin * self = NULL;
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelPlugin*) g_object_new (object_type, "desc-path", desc_path, "name", name, "title", title, "description", description, "capabilities", capabilities, NULL);
	return self;
}

RygelPlugin*
rygel_plugin_new (const gchar* desc_path,
                  const gchar* name,
                  const gchar* title,
                  const gchar* description,
                  RygelPluginCapabilities capabilities)
{
	return rygel_plugin_construct (RYGEL_TYPE_PLUGIN, desc_path, name, title, description, capabilities);
}

static void
rygel_plugin_real_constructed (GObject* base)
{
	RygelPlugin * self;
	const gchar* _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp4_;
	RygelMetaConfig* _tmp14_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	GError* _inner_error0_ = NULL;
	self = (RygelPlugin*) base;
	G_OBJECT_CLASS (rygel_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_resource_factory_get_type (), GUPnPResourceFactory));
	rygel_plugin_set_active (self, TRUE);
	_tmp0_ = self->priv->_title;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_name;
		rygel_plugin_set_title (self, _tmp1_);
	}
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_RESOURCE_INFO, (GBoxedCopyFunc) rygel_resource_info_ref, (GDestroyNotify) rygel_resource_info_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_plugin_set_resource_infos (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = rygel_meta_config_get_default ();
	config = _tmp4_;
	{
		gboolean _tmp5_ = FALSE;
		RygelMetaConfig* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = config;
		_tmp7_ = self->priv->_name;
		_tmp5_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp6_, _tmp7_, "diagnostics", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch48_g_error;
		}
		if (_tmp5_) {
			RygelResourceInfo* resource = NULL;
			RygelResourceInfo* _tmp8_;
			RygelResourceInfo* _tmp9_;
			RygelPluginCapabilities _tmp10_;
			_tmp8_ = rygel_resource_info_new (RYGEL_BASIC_MANAGEMENT_UPNP_ID, RYGEL_BASIC_MANAGEMENT_UPNP_TYPE, RYGEL_BASIC_MANAGEMENT_DESCRIPTION_PATH, RYGEL_TYPE_BASIC_MANAGEMENT);
			resource = _tmp8_;
			_tmp9_ = resource;
			rygel_plugin_add_resource (self, _tmp9_);
			_tmp10_ = self->priv->_capabilities;
			rygel_plugin_set_capabilities (self, _tmp10_ | RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS);
			_rygel_resource_info_unref0 (resource);
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = _error_;
		if (!g_error_matches (_tmp11_, RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET)) {
			GError* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = _error_;
			_tmp13_ = _tmp12_->message;
			g_warning ("rygel-plugin.vala:172: Failed to read configuration: %s", _tmp13_);
		}
		_g_error_free0 (_error_);
	}
	__finally48:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp14_ = rygel_meta_config_get_default ();
	_g_object_unref0 (config);
	config = _tmp14_;
	{
		gboolean _tmp15_ = FALSE;
		RygelMetaConfig* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = config;
		_tmp17_ = self->priv->_name;
		_tmp15_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp16_, _tmp17_, "energy-management", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch49_g_error;
		}
		if (_tmp15_) {
			RygelResourceInfo* resource = NULL;
			RygelResourceInfo* _tmp18_;
			RygelResourceInfo* _tmp19_;
			RygelPluginCapabilities _tmp20_;
			_tmp18_ = rygel_resource_info_new (RYGEL_ENERGY_MANAGEMENT_UPNP_ID, RYGEL_ENERGY_MANAGEMENT_UPNP_TYPE, RYGEL_ENERGY_MANAGEMENT_DESCRIPTION_PATH, RYGEL_TYPE_ENERGY_MANAGEMENT);
			resource = _tmp18_;
			_tmp19_ = resource;
			rygel_plugin_add_resource (self, _tmp19_);
			_tmp20_ = self->priv->_capabilities;
			rygel_plugin_set_capabilities (self, _tmp20_ | RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT);
			_rygel_resource_info_unref0 (resource);
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp21_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = _error_;
		if (!g_error_matches (_tmp21_, RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET)) {
			GError* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = _error_;
			_tmp23_ = _tmp22_->message;
			g_warning ("rygel-plugin.vala:190: Failed to read configuration: %s", _tmp23_);
		}
		_g_error_free0 (_error_);
	}
	__finally49:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp24_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp25_ = _tmp24_;
	rygel_plugin_set_icon_infos (self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp27_ = _tmp26_;
	rygel_plugin_set_default_icons (self, _tmp27_);
	_g_object_unref0 (_tmp27_);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
	_g_object_unref0 (config);
}

void
rygel_plugin_add_resource (RygelPlugin* self,
                           RygelResourceInfo* resource_info)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = self->priv->_resource_infos;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, resource_info);
	_tmp1_ = resource_info->upnp_type;
	gupnp_resource_factory_register_resource_type ((GUPnPResourceFactory*) self, _tmp1_, resource_info->type);
}

void
rygel_plugin_add_icon (RygelPlugin* self,
                       RygelIconInfo* icon_info)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	_tmp0_ = self->priv->_icon_infos;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, icon_info);
}

static void
rygel_plugin_real_apply_hacks (RygelPlugin* self,
                               RygelRootDevice* device,
                               const gchar* description_path,
                               GError** error)
{
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
}

void
rygel_plugin_apply_hacks (RygelPlugin* self,
                          RygelRootDevice* device,
                          const gchar* description_path,
                          GError** error)
{
	g_return_if_fail (self != NULL);
	RYGEL_PLUGIN_GET_CLASS (self)->apply_hacks (self, device, description_path, error);
}

static void
rygel_plugin_add_default_icon (RygelPlugin* self,
                               const gchar* mime_type,
                               const gchar* file_extension,
                               const gchar* uri,
                               gint width,
                               gint height,
                               gint depth)
{
	RygelIconInfo* icon = NULL;
	RygelIconInfo* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file_extension != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = rygel_icon_info_new (mime_type, file_extension);
	icon = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (icon->uri);
	icon->uri = _tmp1_;
	icon->width = width;
	icon->height = height;
	icon->depth = depth;
	_tmp2_ = self->priv->_default_icons;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, icon);
	_rygel_icon_info_unref0 (icon);
}

RygelPluginCapabilities
rygel_plugin_get_capabilities (RygelPlugin* self)
{
	RygelPluginCapabilities result;
	RygelPluginCapabilities _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_capabilities;
	result = _tmp0_;
	return result;
}

void
rygel_plugin_set_capabilities (RygelPlugin* self,
                               RygelPluginCapabilities value)
{
	g_return_if_fail (self != NULL);
	if (rygel_plugin_get_capabilities (self) != value) {
		self->priv->_capabilities = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_CAPABILITIES_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_name (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_name (RygelPlugin* self,
                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_plugin_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_NAME_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_title (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
rygel_plugin_set_title (RygelPlugin* self,
                        const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_plugin_get_title (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_TITLE_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_description (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_description (RygelPlugin* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_plugin_get_description (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_desc_path (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desc_path;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_desc_path (RygelPlugin* self,
                            const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_plugin_get_desc_path (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desc_path);
		self->priv->_desc_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_DESC_PATH_PROPERTY]);
	}
}

gboolean
rygel_plugin_get_active (RygelPlugin* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
rygel_plugin_set_active (RygelPlugin* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (rygel_plugin_get_active (self) != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_ACTIVE_PROPERTY]);
	}
}

GeeArrayList*
rygel_plugin_get_resource_infos (RygelPlugin* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_resource_infos;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_plugin_set_resource_infos (RygelPlugin* self,
                                 GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_plugin_get_resource_infos (self) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_resource_infos);
		self->priv->_resource_infos = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY]);
	}
}

GeeArrayList*
rygel_plugin_get_icon_infos (RygelPlugin* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_infos;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_icon_infos (RygelPlugin* self,
                             GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_plugin_get_icon_infos (self) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon_infos);
		self->priv->_icon_infos = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_ICON_INFOS_PROPERTY]);
	}
}

GeeArrayList*
rygel_plugin_get_default_icons (RygelPlugin* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_icons;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_default_icons (RygelPlugin* self,
                                GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_plugin_get_default_icons (self) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_icons);
		self->priv->_default_icons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY]);
	}
}

static void
rygel_plugin_class_init (RygelPluginClass * klass,
                         gpointer klass_data)
{
	rygel_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlugin_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_plugin_real_constructed;
	((RygelPluginClass *) klass)->apply_hacks = (void (*) (RygelPlugin*, RygelRootDevice*, const gchar*, GError**)) rygel_plugin_real_apply_hacks;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_CAPABILITIES_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_CAPABILITIES_PROPERTY] = g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_NAME_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_TITLE_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESCRIPTION_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESC_PATH_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_DESC_PATH_PROPERTY] = g_param_spec_string ("desc-path", "desc-path", "desc-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ACTIVE_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY] = g_param_spec_object ("resource-infos", "resource-infos", "resource-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ICON_INFOS_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_ICON_INFOS_PROPERTY] = g_param_spec_object ("icon-infos", "icon-infos", "icon-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY] = g_param_spec_object ("default-icons", "default-icons", "default-icons", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_plugin_instance_init (RygelPlugin * self,
                            gpointer klass)
{
	self->priv = rygel_plugin_get_instance_private (self);
}

static void
rygel_plugin_finalize (GObject * obj)
{
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN, RygelPlugin);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desc_path);
	_g_object_unref0 (self->priv->_resource_infos);
	_g_object_unref0 (self->priv->_icon_infos);
	_g_object_unref0 (self->priv->_default_icons);
	G_OBJECT_CLASS (rygel_plugin_parent_class)->finalize (obj);
}

/**
 * This represents a Rygel plugin.
 *
 * Plugin libraries should provide an object of this
 * class or a subclass in their module_init() function.
 *
 * It is generally convenient to derive from 
 * #RygelMediaRendererPlugin from librygel-renderer,
 * or from #RygelMediaServerPlugin from librygel-server.
 *
 * Plugins may change their behaviour based on their
 * configuration. See rygel_meta_config_get_default().
 */
GType
rygel_plugin_get_type (void)
{
	static volatile gsize rygel_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlugin), 0, (GInstanceInitFunc) rygel_plugin_instance_init, NULL };
		GType rygel_plugin_type_id;
		rygel_plugin_type_id = g_type_register_static (gupnp_resource_factory_get_type (), "RygelPlugin", &g_define_type_info, 0);
		RygelPlugin_private_offset = g_type_add_instance_private (rygel_plugin_type_id, sizeof (RygelPluginPrivate));
		g_once_init_leave (&rygel_plugin_type_id__volatile, rygel_plugin_type_id);
	}
	return rygel_plugin_type_id__volatile;
}

static void
_vala_rygel_plugin_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
	switch (property_id) {
		case RYGEL_PLUGIN_CAPABILITIES_PROPERTY:
		g_value_set_flags (value, rygel_plugin_get_capabilities (self));
		break;
		case RYGEL_PLUGIN_NAME_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_name (self));
		break;
		case RYGEL_PLUGIN_TITLE_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_title (self));
		break;
		case RYGEL_PLUGIN_DESCRIPTION_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_description (self));
		break;
		case RYGEL_PLUGIN_DESC_PATH_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_desc_path (self));
		break;
		case RYGEL_PLUGIN_ACTIVE_PROPERTY:
		g_value_set_boolean (value, rygel_plugin_get_active (self));
		break;
		case RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY:
		g_value_set_object (value, rygel_plugin_get_resource_infos (self));
		break;
		case RYGEL_PLUGIN_ICON_INFOS_PROPERTY:
		g_value_set_object (value, rygel_plugin_get_icon_infos (self));
		break;
		case RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY:
		g_value_set_object (value, rygel_plugin_get_default_icons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_plugin_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
	switch (property_id) {
		case RYGEL_PLUGIN_CAPABILITIES_PROPERTY:
		rygel_plugin_set_capabilities (self, g_value_get_flags (value));
		break;
		case RYGEL_PLUGIN_NAME_PROPERTY:
		rygel_plugin_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_TITLE_PROPERTY:
		rygel_plugin_set_title (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_DESCRIPTION_PROPERTY:
		rygel_plugin_set_description (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_DESC_PATH_PROPERTY:
		rygel_plugin_set_desc_path (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_ACTIVE_PROPERTY:
		rygel_plugin_set_active (self, g_value_get_boolean (value));
		break;
		case RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY:
		rygel_plugin_set_resource_infos (self, g_value_get_object (value));
		break;
		case RYGEL_PLUGIN_ICON_INFOS_PROPERTY:
		rygel_plugin_set_icon_infos (self, g_value_get_object (value));
		break;
		case RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY:
		rygel_plugin_set_default_icons (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

