/* rygel-http-get-handler.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from rygel-http-get-handler.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-core.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPGetHandlerPrivate {
	GCancellable* _cancellable;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_get_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerPrivate))
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY,
	RYGEL_HTTP_GET_HANDLER_CANCELLABLE
};
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER "transferMode.dlna.org"
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_BACKGROUND "Background"
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static void rygel_http_get_handler_real_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
gchar* rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self);
void rygel_client_hacks_modify_headers (RygelClientHacks* self, RygelHTTPRequest* request);
static gchar* rygel_http_get_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode);
static gboolean rygel_http_get_handler_real_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode);
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
static gint64 rygel_http_get_handler_real_get_resource_size (RygelHTTPGetHandler* self);
gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self);
static gint64 rygel_http_get_handler_real_get_resource_duration (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_byte_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_time_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_playspeed (RygelHTTPGetHandler* self);
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_get_handler_real_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
GCancellable* rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
static void rygel_http_get_handler_finalize (GObject* obj);
static void _vala_rygel_http_get_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_get_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Invokes the handler to add response headers to/for the given HTTP request
     */
static void rygel_http_get_handler_real_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
	gchar* mode = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelHTTPGet* _tmp7_ = NULL;
	SoupMessage* _tmp8_ = NULL;
	SoupMessageHeaders* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelHTTPGet* _tmp11_ = NULL;
	RygelClientHacks* _tmp12_ = NULL;
	g_return_if_fail (request != NULL);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER);
	_tmp4_ = g_strdup (_tmp3_);
	mode = _tmp4_;
	_tmp5_ = mode;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = rygel_http_get_handler_get_default_transfer_mode (self);
		_g_free0 (mode);
		mode = _tmp6_;
	}
	_tmp7_ = request;
	_tmp8_ = ((RygelHTTPRequest*) _tmp7_)->msg;
	_tmp9_ = _tmp8_->response_headers;
	_tmp10_ = mode;
	soup_message_headers_append (_tmp9_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER, _tmp10_);
	_tmp11_ = request;
	_tmp12_ = ((RygelHTTPRequest*) _tmp11_)->hack;
	if (_tmp12_ != NULL) {
		RygelHTTPGet* _tmp13_ = NULL;
		RygelClientHacks* _tmp14_ = NULL;
		RygelHTTPGet* _tmp15_ = NULL;
		_tmp13_ = request;
		_tmp14_ = ((RygelHTTPRequest*) _tmp13_)->hack;
		_tmp15_ = request;
		rygel_client_hacks_modify_headers (_tmp14_, (RygelHTTPRequest*) _tmp15_);
	}
	_g_free0 (mode);
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->add_response_headers (self, request, error);
}


/**
     * Returns the default transfer mode for the handler.
     * The default is "Interactive"
     */
static gchar* rygel_http_get_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = g_strdup (RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_INTERACTIVE);
	result = _tmp0_;
	return result;
}


gchar* rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->get_default_transfer_mode (self);
}


/**
     * Returns true if the handler supports the given transfer mode, false
     * otherwise.
     */
static gboolean rygel_http_get_handler_real_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode) {
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_supports_transfer_mode'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_transfer_mode (self, mode);
}


/**
     * Returns the resource size or -1 if not known.
     */
static gint64 rygel_http_get_handler_real_get_resource_size (RygelHTTPGetHandler* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_get_resource_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0LL;
}


gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->get_resource_size (self);
}


/**
     * Returns the resource duration (in microseconds) or -1 if not known.
     */
static gint64 rygel_http_get_handler_real_get_resource_duration (RygelHTTPGetHandler* self) {
	gint64 result = 0LL;
	result = (gint64) -1;
	return result;
}


gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->get_resource_duration (self);
}


/**
     * Returns true if the handler supports full random-access byte seek.
     */
static gboolean rygel_http_get_handler_real_supports_byte_seek (RygelHTTPGetHandler* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_byte_seek (self);
}


/**
     * Returns true if the handler supports full random-access time seek.
     */
static gboolean rygel_http_get_handler_real_supports_time_seek (RygelHTTPGetHandler* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_time_seek (self);
}


/**
     * Returns true if the handler supports any play speed requests.
     */
static gboolean rygel_http_get_handler_real_supports_playspeed (RygelHTTPGetHandler* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_playspeed (self);
}


/**
     * Create an HTTPResponse object that will render the body.
     */
static RygelHTTPResponse* rygel_http_get_handler_real_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_render_body'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->render_body (self, request, error);
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler * self = NULL;
	self = (RygelHTTPGetHandler*) g_object_new (object_type, NULL);
	return self;
}


GCancellable* rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self) {
	GCancellable* result;
	GCancellable* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetHandlerPrivate));
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = rygel_http_get_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->get_default_transfer_mode = rygel_http_get_handler_real_get_default_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = rygel_http_get_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = rygel_http_get_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_duration = rygel_http_get_handler_real_get_resource_duration;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = rygel_http_get_handler_real_supports_byte_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_time_seek = rygel_http_get_handler_real_supports_time_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_playspeed = rygel_http_get_handler_real_supports_playspeed;
	((RygelHTTPGetHandlerClass *) klass)->render_body = rygel_http_get_handler_real_render_body;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_get_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_get_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_GET_HANDLER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
	self->priv = RYGEL_HTTP_GET_HANDLER_GET_PRIVATE (self);
}


static void rygel_http_get_handler_finalize (GObject* obj) {
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_get_handler_parent_class)->finalize (obj);
}


/**
 * HTTP GET request handler interface.
 */
GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, NULL };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetHandler", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


static void _vala_rygel_http_get_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	switch (property_id) {
		case RYGEL_HTTP_GET_HANDLER_CANCELLABLE:
		g_value_set_object (value, rygel_http_get_handler_get_cancellable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_get_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	switch (property_id) {
		case RYGEL_HTTP_GET_HANDLER_CANCELLABLE:
		rygel_http_get_handler_set_cancellable (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



