/* rygel-media-export-harvesting-task.c generated by valac 0.32.0, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <rygel-server.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <rygel-db.h>
#include <gobject/gvaluecollector.h>


#define TYPE_FILE_QUEUE_ENTRY (file_queue_entry_get_type ())
#define FILE_QUEUE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_QUEUE_ENTRY, FileQueueEntry))
#define FILE_QUEUE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_QUEUE_ENTRY, FileQueueEntryClass))
#define IS_FILE_QUEUE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_QUEUE_ENTRY))
#define IS_FILE_QUEUE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_QUEUE_ENTRY))
#define FILE_QUEUE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_QUEUE_ENTRY, FileQueueEntryClass))

typedef struct _FileQueueEntry FileQueueEntry;
typedef struct _FileQueueEntryClass FileQueueEntryClass;
typedef struct _FileQueueEntryPrivate FileQueueEntryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecFileQueueEntry ParamSpecFileQueueEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;
#define _file_queue_entry_unref0(var) ((var == NULL) ? NULL : (var = (file_queue_entry_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;
typedef struct _RygelMediaExportTrackableDbContainerPrivate RygelMediaExportTrackableDbContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;

struct _FileQueueEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FileQueueEntryPrivate * priv;
	GFile* file;
	gboolean known;
	gchar* content_type;
};

struct _FileQueueEntryClass {
	GTypeClass parent_class;
	void (*finalize) (FileQueueEntry *self);
};

struct _ParamSpecFileQueueEntry {
	GParamSpec parent_instance;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	GTimer* timer;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GTimer* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	GFileInfo* info;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GFileInfo* _tmp5_;
	GFile* _tmp6_;
	RygelMediaContainer* _tmp7_;
	gboolean _tmp8_;
	GFileType _tmp9_;
	GQueue* _tmp10_;
	RygelMediaContainer* _tmp11_;
	RygelMediaContainer* _tmp12_;
	GError* _error_;
	RygelMediaExportMetadataExtractor* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError * _inner_error_;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	gint (*count_children) (RygelMediaExportDBContainer* self);
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportTrackableDbContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportTrackableDbContainerPrivate * priv;
};

struct _RygelMediaExportTrackableDbContainerClass {
	RygelMediaExportDBContainerClass parent_class;
	void (*remove_child) (RygelMediaExportTrackableDbContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelMediaExportTrackableDbContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelMediaExportTrackableDbContainer* self);
	void (*set_service_reset_token) (RygelMediaExportTrackableDbContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelMediaExportTrackableDbContainer* self);
};

struct _RygelMediaExportDummyContainer {
	RygelMediaExportTrackableDbContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelMediaExportTrackableDbContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GFile* directory;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	RygelMediaContainer* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFileEnumerator* enumerator;
	GFile* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GFileEnumerator* _tmp8_;
	GList* list;
	gboolean _tmp9_;
	GList* _tmp10_;
	gboolean _tmp11_;
	GList* _tmp12_;
	GFileEnumerator* _tmp13_;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	GList* _tmp16_;
	GList* _tmp17_;
	GFileEnumerator* _tmp18_;
	GCancellable* _tmp19_;
	GCancellable* _tmp20_;
	GError* err;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError * _inner_error_;
};

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer file_queue_entry_parent_class = NULL;
static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface* rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

gpointer file_queue_entry_ref (gpointer instance);
void file_queue_entry_unref (gpointer instance);
GParamSpec* param_spec_file_queue_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_file_queue_entry (GValue* value, gpointer v_object);
void value_take_file_queue_entry (GValue* value, gpointer v_object);
gpointer value_get_file_queue_entry (const GValue* value);
GType file_queue_entry_get_type (void) G_GNUC_CONST;
enum  {
	FILE_QUEUE_ENTRY_DUMMY_PROPERTY
};
FileQueueEntry* file_queue_entry_new (GFile* file, gboolean known, const gchar* content_type);
FileQueueEntry* file_queue_entry_construct (GType object_type, GFile* file, gboolean known, const gchar* content_type);
static void file_queue_entry_finalize (FileQueueEntry* obj);
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE
};
void rygel_media_export_metadata_extractor_stop (RygelMediaExportMetadataExtractor* self);
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GVariant* info);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GVariant* info, gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_);
void rygel_media_export_metadata_extractor_run (RygelMediaExportMetadataExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_metadata_extractor_run_finish (RygelMediaExportMetadataExtractor* self, GAsyncResult* _res_);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
gboolean rygel_media_export_harvester_is_eligible (GFile* file, GFileInfo* info);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file, const gchar* content_type);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_media_export_updatable_object_non_overriding_commit (RygelMediaExportUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_updatable_object_non_overriding_commit_finish (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
void rygel_media_export_media_cache_blacklist (RygelMediaExportMediaCache* self, GFile* file);
static void rygel_media_export_harvesting_task_finalize (GObject* obj);
static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FileQueueEntry* file_queue_entry_construct (GType object_type, GFile* file, gboolean known, const gchar* content_type) {
	FileQueueEntry* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (content_type != NULL, NULL);
	self = (FileQueueEntry*) g_type_create_instance (object_type);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = known;
	self->known = _tmp2_;
	_tmp3_ = content_type;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->content_type);
	self->content_type = _tmp4_;
	return self;
}


FileQueueEntry* file_queue_entry_new (GFile* file, gboolean known, const gchar* content_type) {
	return file_queue_entry_construct (TYPE_FILE_QUEUE_ENTRY, file, known, content_type);
}


static void value_file_queue_entry_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_file_queue_entry_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		file_queue_entry_unref (value->data[0].v_pointer);
	}
}


static void value_file_queue_entry_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = file_queue_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_file_queue_entry_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_file_queue_entry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FileQueueEntry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = file_queue_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_file_queue_entry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FileQueueEntry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = file_queue_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_file_queue_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecFileQueueEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FILE_QUEUE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_file_queue_entry (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY), NULL);
	return value->data[0].v_pointer;
}


void value_set_file_queue_entry (GValue* value, gpointer v_object) {
	FileQueueEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_QUEUE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		file_queue_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_queue_entry_unref (old);
	}
}


void value_take_file_queue_entry (GValue* value, gpointer v_object) {
	FileQueueEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_QUEUE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_queue_entry_unref (old);
	}
}


static void file_queue_entry_class_init (FileQueueEntryClass * klass) {
	file_queue_entry_parent_class = g_type_class_peek_parent (klass);
	((FileQueueEntryClass *) klass)->finalize = file_queue_entry_finalize;
}


static void file_queue_entry_instance_init (FileQueueEntry * self) {
	self->ref_count = 1;
}


static void file_queue_entry_finalize (FileQueueEntry* obj) {
	FileQueueEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_QUEUE_ENTRY, FileQueueEntry);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
	_g_free0 (self->content_type);
}


GType file_queue_entry_get_type (void) {
	static volatile gsize file_queue_entry_type_id__volatile = 0;
	if (g_once_init_enter (&file_queue_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_file_queue_entry_init, value_file_queue_entry_free_value, value_file_queue_entry_copy_value, value_file_queue_entry_peek_pointer, "p", value_file_queue_entry_collect_value, "p", value_file_queue_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FileQueueEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_queue_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileQueueEntry), 0, (GInstanceInitFunc) file_queue_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType file_queue_entry_type_id;
		file_queue_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FileQueueEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&file_queue_entry_type_id__volatile, file_queue_entry_type_id);
	}
	return file_queue_entry_type_id__volatile;
}


gpointer file_queue_entry_ref (gpointer instance) {
	FileQueueEntry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void file_queue_entry_unref (gpointer instance) {
	FileQueueEntry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILE_QUEUE_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GVariant* info, gpointer self) {
	rygel_media_export_harvesting_task_on_extracted_cb ((RygelMediaExportHarvestingTask*) self, file, info);
}


static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
	rygel_media_export_harvesting_task_on_extractor_error_cb ((RygelMediaExportHarvestingTask*) self, file, err);
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent) {
	RygelMediaExportHarvestingTask * self = NULL;
	RygelMediaExportMetadataExtractor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	RygelMediaContainer* _tmp4_ = NULL;
	RygelMediaExportMediaCache* _tmp5_ = NULL;
	RygelMediaExportMetadataExtractor* _tmp6_ = NULL;
	RygelMediaExportMetadataExtractor* _tmp7_ = NULL;
	GeeLinkedList* _tmp8_ = NULL;
	GQueue* _tmp9_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp10_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp11_ = NULL;
	GTimer* _tmp12_ = NULL;
	g_return_val_if_fail (monitor != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_media_export_metadata_extractor_new ();
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->origin);
	self->origin = _tmp2_;
	_tmp3_ = parent;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp4_;
	_tmp5_ = rygel_media_export_media_cache_get_default ();
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp5_;
	_tmp6_ = self->priv->extractor;
	g_signal_connect_object (_tmp6_, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
	_tmp7_ = self->priv->extractor;
	g_signal_connect_object (_tmp7_, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
	_tmp8_ = gee_linked_list_new (TYPE_FILE_QUEUE_ENTRY, (GBoxedCopyFunc) file_queue_entry_ref, file_queue_entry_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->files);
	self->priv->files = (GeeQueue*) _tmp8_;
	_tmp9_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->containers);
	self->priv->containers = _tmp9_;
	_tmp10_ = monitor;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp11_;
	_tmp12_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp12_;
	return self;
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent) {
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, monitor, file, parent);
}


void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	RygelMediaExportMetadataExtractor* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp3_ = _tmp2_;
	g_cancellable_cancel (_tmp3_);
	_tmp4_ = self->priv->extractor;
	rygel_media_export_metadata_extractor_stop (_tmp4_);
}


static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskRunData, _data_);
}


static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_ = NULL;
	self = (RygelMediaExportHarvestingTask*) base;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static void rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->timer;
	g_timer_reset (_data_->_tmp0_);
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->extractor;
		rygel_media_export_metadata_extractor_run (_data_->_tmp1_, NULL, NULL);
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->origin;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp2_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp4_, rygel_media_export_harvesting_task_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_file_query_info_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch57_g_error;
		}
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->origin;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->parent;
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = rygel_media_export_harvesting_task_process_file (_data_->self, _data_->_tmp6_, _data_->info, _data_->_tmp7_);
		if (_data_->_tmp8_) {
			_data_->_tmp9_ = 0;
			_data_->_tmp9_ = g_file_info_get_file_type (_data_->info);
			if (_data_->_tmp9_ != G_FILE_TYPE_DIRECTORY) {
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->self->priv->containers;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->self->priv->parent;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
				g_queue_push_tail (_data_->_tmp10_, _data_->_tmp12_);
			}
			rygel_media_export_harvesting_task_on_idle (_data_->self);
		} else {
			g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		}
		_g_object_unref0 (_data_->info);
	}
	goto __finally57;
	__catch57_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->priv->extractor;
		rygel_media_export_metadata_extractor_stop (_data_->_tmp13_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_error_;
		if (!g_error_matches (_data_->_tmp14_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _ ("Failed to harvest file %s: %s");
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->self->origin;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->_error_;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
			_g_free0 (_data_->_tmp18_);
		} else {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->self->origin;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_file_get_uri (_data_->_tmp21_);
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_;
			g_debug ("rygel-media-export-harvesting-task.vala:129: Harvesting of uri %s was " \
"cancelled", _data_->_tmp23_);
			_g_free0 (_data_->_tmp23_);
		}
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
	}
	__finally57:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check
     * @return true, if the file has been queued, false otherwise.
     */
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 timestamp = 0LL;
	gint64 size = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		RygelMediaExportMediaCache* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
		_tmp1_ = self->priv->cache;
		_tmp2_ = file;
		_tmp5_ = rygel_media_export_media_cache_exists (_tmp1_, _tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
		timestamp = _tmp3_;
		size = _tmp4_;
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch58_g_error;
		}
		if (_tmp0_) {
			gint64 mtime = 0LL;
			GFileInfo* _tmp6_ = NULL;
			guint64 _tmp7_ = 0ULL;
			gboolean _tmp8_ = FALSE;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			_tmp6_ = info;
			_tmp7_ = g_file_info_get_attribute_uint64 (_tmp6_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
			mtime = (gint64) _tmp7_;
			_tmp9_ = mtime;
			_tmp10_ = timestamp;
			if (_tmp9_ > _tmp10_) {
				_tmp8_ = TRUE;
			} else {
				GFileInfo* _tmp11_ = NULL;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				_tmp11_ = info;
				_tmp12_ = g_file_info_get_size (_tmp11_);
				_tmp13_ = size;
				_tmp8_ = _tmp12_ != _tmp13_;
			}
			if (_tmp8_) {
				FileQueueEntry* entry = NULL;
				GFile* _tmp14_ = NULL;
				GFileInfo* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				FileQueueEntry* _tmp17_ = NULL;
				GeeQueue* _tmp18_ = NULL;
				FileQueueEntry* _tmp19_ = NULL;
				_tmp14_ = file;
				_tmp15_ = info;
				_tmp16_ = g_file_info_get_content_type (_tmp15_);
				_tmp17_ = file_queue_entry_new (_tmp14_, TRUE, _tmp16_);
				entry = _tmp17_;
				_tmp18_ = self->priv->files;
				_tmp19_ = entry;
				gee_queue_offer (_tmp18_, _tmp19_);
				result = TRUE;
				_file_queue_entry_unref0 (entry);
				return result;
			}
		} else {
			FileQueueEntry* entry = NULL;
			GFile* _tmp20_ = NULL;
			GFileInfo* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			FileQueueEntry* _tmp23_ = NULL;
			GeeQueue* _tmp24_ = NULL;
			FileQueueEntry* _tmp25_ = NULL;
			_tmp20_ = file;
			_tmp21_ = info;
			_tmp22_ = g_file_info_get_content_type (_tmp21_);
			_tmp23_ = file_queue_entry_new (_tmp20_, FALSE, _tmp22_);
			entry = _tmp23_;
			_tmp24_ = self->priv->files;
			_tmp25_ = entry;
			gee_queue_offer (_tmp24_, _tmp25_);
			result = TRUE;
			_file_queue_entry_unref0 (entry);
			return result;
		}
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = _ ("Failed to query database: %s");
		_tmp27_ = _error_;
		_tmp28_ = _tmp27_->message;
		g_warning (_tmp26_, _tmp28_);
		_g_error_free0 (_error_);
	}
	__finally58:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent) {
	gboolean result = FALSE;
	GFileInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GFileInfo* _tmp2_ = NULL;
	GFileType _tmp3_ = 0;
	GFileInfo* _tmp11_ = NULL;
	GFileType _tmp12_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_is_hidden (_tmp0_);
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = info;
	_tmp3_ = g_file_info_get_file_type (_tmp2_);
	if (_tmp3_ == G_FILE_TYPE_DIRECTORY) {
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = file;
		_tmp5_ = g_file_get_child (_tmp4_, "VIDEO_TS");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_query_exists (_tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		if (_tmp8_) {
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* _tmp10_ = NULL;
			_tmp9_ = info;
			g_file_info_set_file_type (_tmp9_, G_FILE_TYPE_REGULAR);
			_tmp10_ = info;
			g_file_info_set_content_type (_tmp10_, "application/x-cd-image");
		}
	}
	_tmp11_ = info;
	_tmp12_ = g_file_info_get_file_type (_tmp11_);
	if (_tmp12_ == G_FILE_TYPE_DIRECTORY) {
		RygelMediaExportRecursiveFileMonitor* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		RygelMediaExportDummyContainer* container = NULL;
		GFile* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
		RygelMediaExportDummyContainer* _tmp17_ = NULL;
		GQueue* _tmp18_ = NULL;
		RygelMediaExportDummyContainer* _tmp19_ = NULL;
		RygelMediaContainer* _tmp20_ = NULL;
		RygelMediaExportDummyContainer* dummy_parent = NULL;
		RygelMediaContainer* _tmp21_ = NULL;
		RygelMediaExportDummyContainer* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		RygelMediaExportDummyContainer* _tmp24_ = NULL;
		_tmp13_ = self->priv->monitor;
		_tmp14_ = file;
		rygel_media_export_recursive_file_monitor_add (_tmp13_, _tmp14_, NULL, NULL);
		_tmp15_ = file;
		_tmp16_ = parent;
		_tmp17_ = rygel_media_export_dummy_container_new (_tmp15_, _tmp16_);
		container = _tmp17_;
		_tmp18_ = self->priv->containers;
		_tmp19_ = container;
		_tmp20_ = _g_object_ref0 ((RygelMediaContainer*) _tmp19_);
		g_queue_push_tail (_tmp18_, _tmp20_);
		_tmp21_ = parent;
		_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _tmp21_) : NULL);
		dummy_parent = _tmp22_;
		_tmp24_ = dummy_parent;
		if (_tmp24_ == NULL) {
			_tmp23_ = TRUE;
		} else {
			RygelMediaExportDummyContainer* _tmp25_ = NULL;
			GeeList* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			_tmp25_ = dummy_parent;
			_tmp26_ = _tmp25_->children;
			_tmp27_ = file;
			_tmp28_ = rygel_media_export_media_cache_get_id (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_collection_contains ((GeeCollection*) _tmp26_, _tmp29_);
			_tmp23_ = !_tmp30_;
			_g_free0 (_tmp29_);
		}
		if (_tmp23_) {
			RygelMediaContainer* _tmp31_ = NULL;
			RygelMediaExportDummyContainer* _tmp32_ = NULL;
			_tmp31_ = parent;
			_tmp32_ = container;
			rygel_trackable_container_add_child_tracked (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp31_) : NULL, (RygelMediaObject*) _tmp32_, NULL, NULL);
		}
		result = TRUE;
		_g_object_unref0 (dummy_parent);
		_g_object_unref0 (container);
		return result;
	} else {
		GFile* _tmp33_ = NULL;
		GFileInfo* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp33_ = file;
		_tmp34_ = info;
		_tmp35_ = rygel_media_export_harvester_is_eligible (_tmp33_, _tmp34_);
		if (_tmp35_) {
			GFile* _tmp36_ = NULL;
			GFileInfo* _tmp37_ = NULL;
			gboolean _tmp38_ = FALSE;
			_tmp36_ = file;
			_tmp37_ = info;
			_tmp38_ = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, _tmp36_, _tmp37_);
			result = _tmp38_;
			return result;
		}
		result = FALSE;
		return result;
	}
}


static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	RygelMediaExportDummyContainer* container = NULL;
	GQueue* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	RygelMediaContainer* _tmp7_ = NULL;
	RygelMediaExportDummyContainer* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = list;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_ = NULL;
		GCancellable* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->containers;
	_tmp6_ = g_queue_peek_head (_tmp5_);
	_tmp7_ = (RygelMediaContainer*) _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _tmp7_) : NULL);
	container = _tmp8_;
	_tmp9_ = list;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp9_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* _tmp10_ = NULL;
			GFileInfo* info = NULL;
			_tmp10_ = _g_object_ref0 ((GFileInfo*) info_it->data);
			info = _tmp10_;
			{
				GFile* file = NULL;
				RygelMediaExportDummyContainer* _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				GFileInfo* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				GFile* _tmp16_ = NULL;
				GFileInfo* _tmp17_ = NULL;
				RygelMediaExportDummyContainer* _tmp18_ = NULL;
				RygelMediaExportDummyContainer* _tmp19_ = NULL;
				GFile* _tmp20_ = NULL;
				_tmp11_ = container;
				_tmp12_ = _tmp11_->file;
				_tmp13_ = info;
				_tmp14_ = g_file_info_get_name (_tmp13_);
				_tmp15_ = g_file_get_child (_tmp12_, _tmp14_);
				file = _tmp15_;
				_tmp16_ = file;
				_tmp17_ = info;
				_tmp18_ = container;
				rygel_media_export_harvesting_task_process_file (self, _tmp16_, _tmp17_, (RygelMediaContainer*) _tmp18_);
				_tmp19_ = container;
				_tmp20_ = file;
				rygel_media_export_dummy_container_seen (_tmp19_, _tmp20_);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (container);
	return result;
}


static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, _data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_enumerate_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->containers;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_queue_peek_head (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = (RygelMediaContainer*) _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _data_->_tmp2_) : NULL)->file;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->directory = _data_->_tmp4_;
	{
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->directory;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp5_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp7_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_file_enumerate_children_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch59_g_error;
		}
		_data_->list = NULL;
		{
			_data_->_tmp9_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp9_) {
					_data_->_tmp10_ = NULL;
					_data_->_tmp10_ = _data_->list;
					_data_->_tmp11_ = FALSE;
					_data_->_tmp11_ = rygel_media_export_harvesting_task_process_children (_data_->self, _data_->_tmp10_);
					if (!_data_->_tmp11_) {
						break;
					}
				}
				_data_->_tmp9_ = FALSE;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->enumerator;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->_tmp14_;
				_data_->_state_ = 2;
				g_file_enumerator_next_files_async (_data_->_tmp13_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, _data_->_tmp15_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = g_file_enumerator_next_files_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
				_data_->_tmp12_ = _data_->_tmp16_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					__g_list_free__g_object_unref0_0 (_data_->list);
					_g_object_unref0 (_data_->enumerator);
					goto __catch59_g_error;
				}
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->_tmp12_;
				_data_->_tmp12_ = NULL;
				__g_list_free__g_object_unref0_0 (_data_->list);
				_data_->list = _data_->_tmp17_;
				__g_list_free__g_object_unref0_0 (_data_->_tmp12_);
			}
		}
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->enumerator;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_state_ = 3;
		g_file_enumerator_close_async (_data_->_tmp18_, G_PRIORITY_DEFAULT, _data_->_tmp20_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_3:
		g_file_enumerator_close_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			__g_list_free__g_object_unref0_0 (_data_->list);
			_g_object_unref0 (_data_->enumerator);
			goto __catch59_g_error;
		}
		__g_list_free__g_object_unref0_0 (_data_->list);
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally59;
	__catch59_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _ ("Failed to enumerate folder \"%s\": %s");
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->directory;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->err;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning (_data_->_tmp21_, _data_->_tmp24_, _data_->_tmp26_);
		_g_free0 (_data_->_tmp24_);
		_g_error_free0 (_data_->err);
	}
	__finally59:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	rygel_media_export_harvesting_task_cleanup_database (_data_->self);
	rygel_media_export_harvesting_task_do_update (_data_->self);
	_g_object_unref0 (_data_->directory);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self) {
	RygelMediaExportDummyContainer* container = NULL;
	GQueue* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaExportDummyContainer* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->containers;
	_tmp1_ = g_queue_peek_head (_tmp0_);
	_tmp2_ = (RygelMediaContainer*) _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _tmp2_) : NULL);
	container = _tmp3_;
	{
		{
			GeeList* _child_list = NULL;
			RygelMediaExportDummyContainer* _tmp4_ = NULL;
			GeeList* _tmp5_ = NULL;
			GeeList* _tmp6_ = NULL;
			gint _child_size = 0;
			GeeList* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _child_index = 0;
			_tmp4_ = container;
			_tmp5_ = _tmp4_->children;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_child_list = _tmp6_;
			_tmp7_ = _child_list;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_child_size = _tmp9_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gchar* child = NULL;
				GeeList* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gpointer _tmp15_ = NULL;
				RygelMediaExportMediaCache* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				_tmp10_ = _child_index;
				_child_index = _tmp10_ + 1;
				_tmp11_ = _child_index;
				_tmp12_ = _child_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _child_list;
				_tmp14_ = _child_index;
				_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
				child = (gchar*) _tmp15_;
				_tmp16_ = self->priv->cache;
				_tmp17_ = child;
				rygel_media_export_media_cache_remove_by_id (_tmp16_, _tmp17_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch60_rygel_database_database_error;
					}
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					_g_object_unref0 (container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (child);
			}
			_g_object_unref0 (_child_list);
		}
	}
	goto __finally60;
	__catch60_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp18_ = NULL;
		RygelMediaExportDummyContainer* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = _ ("Failed to get children of container %s: %s");
		_tmp19_ = container;
		_tmp20_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _error_;
		_tmp23_ = _tmp22_->message;
		g_warning (_tmp18_, _tmp21_, _tmp23_);
		_g_error_free0 (_error_);
	}
	__finally60:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (container);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (container);
}


static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
	if (_tmp2_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->files;
	_tmp4_ = gee_collection_get_is_empty ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		GeeQueue* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		FileQueueEntry* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		RygelMediaExportMetadataExtractor* _tmp12_ = NULL;
		GeeQueue* _tmp13_ = NULL;
		gpointer _tmp14_ = NULL;
		FileQueueEntry* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		GeeQueue* _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		FileQueueEntry* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp6_ = self->priv->files;
		_tmp7_ = gee_queue_peek (_tmp6_);
		_tmp8_ = (FileQueueEntry*) _tmp7_;
		_tmp9_ = _tmp8_->file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		g_debug ("rygel-media-export-harvesting-task.vala:291: Scheduling file %s for me" \
"ta-data extraction…", _tmp11_);
		_g_free0 (_tmp11_);
		_file_queue_entry_unref0 (_tmp8_);
		_tmp12_ = self->priv->extractor;
		_tmp13_ = self->priv->files;
		_tmp14_ = gee_queue_peek (_tmp13_);
		_tmp15_ = (FileQueueEntry*) _tmp14_;
		_tmp16_ = _tmp15_->file;
		_tmp17_ = self->priv->files;
		_tmp18_ = gee_queue_peek (_tmp17_);
		_tmp19_ = (FileQueueEntry*) _tmp18_;
		_tmp20_ = _tmp19_->content_type;
		rygel_media_export_metadata_extractor_extract (_tmp12_, _tmp16_, _tmp20_);
		_file_queue_entry_unref0 (_tmp19_);
		_file_queue_entry_unref0 (_tmp15_);
	} else {
		GQueue* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp21_ = self->priv->containers;
		_tmp22_ = g_queue_is_empty (_tmp21_);
		if (!_tmp22_) {
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
		} else {
			GFile* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			GTimer* _tmp26_ = NULL;
			gdouble _tmp27_ = 0.0;
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
			_tmp23_ = self->origin;
			_tmp24_ = g_file_get_uri (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->timer;
			_tmp27_ = g_timer_elapsed (_tmp26_, NULL);
			g_debug ("rygel-media-export-harvesting-task.vala:300: Harvesting of %s done in " \
"%f", _tmp25_, _tmp27_);
			_g_free0 (_tmp25_);
		}
	}
	result = FALSE;
	return result;
}


static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GVariant* info) {
	GFile* _tmp0_ = NULL;
	GeeQueue* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	FileQueueEntry* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GeeQueue* _tmp27_ = NULL;
	gpointer _tmp28_ = NULL;
	FileQueueEntry* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = self->priv->files;
	_tmp2_ = gee_queue_peek (_tmp1_);
	_tmp3_ = (FileQueueEntry*) _tmp2_;
	_tmp4_ = _tmp3_->file;
	_tmp5_ = g_file_equal (_tmp0_, _tmp4_);
	_tmp6_ = !_tmp5_;
	_file_queue_entry_unref0 (_tmp3_);
	if (_tmp6_) {
		g_debug ("rygel-media-export-harvesting-task.vala:311: Not for us, ignoring");
	}
	_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_cancellable_is_cancelled (_tmp8_);
	if (_tmp9_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	}
	{
		RygelMediaContainer* parent = NULL;
		GQueue* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		RygelMediaContainer* _tmp12_ = NULL;
		RygelMediaObject* item = NULL;
		GFile* _tmp13_ = NULL;
		GVariant* _tmp14_ = NULL;
		RygelMediaObject* _tmp15_ = NULL;
		_tmp10_ = self->priv->containers;
		_tmp11_ = g_queue_peek_head (_tmp10_);
		_tmp12_ = _g_object_ref0 ((RygelMediaContainer*) _tmp11_);
		parent = _tmp12_;
		_tmp13_ = file;
		_tmp14_ = info;
		_tmp15_ = rygel_media_export_item_factory_create_from_variant (parent, _tmp13_, _tmp14_, &_inner_error_);
		item = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (parent);
			goto __catch61_g_error;
		}
		if (item != NULL) {
			GeeQueue* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			FileQueueEntry* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			rygel_media_object_set_parent_ref (item, parent);
			_tmp16_ = self->priv->files;
			_tmp17_ = gee_queue_peek (_tmp16_);
			_tmp18_ = (FileQueueEntry*) _tmp17_;
			_tmp19_ = _tmp18_->known;
			_tmp20_ = _tmp19_;
			_file_queue_entry_unref0 (_tmp18_);
			if (_tmp20_) {
				rygel_media_export_updatable_object_non_overriding_commit (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT) ? ((RygelMediaExportUpdatableObject*) item) : NULL, NULL, NULL);
			} else {
				RygelTrackableContainer* container = NULL;
				RygelMediaContainer* _tmp21_ = NULL;
				RygelMediaContainer* _tmp22_ = NULL;
				RygelTrackableContainer* _tmp23_ = NULL;
				RygelTrackableContainer* _tmp24_ = NULL;
				_tmp21_ = rygel_media_object_get_parent (item);
				_tmp22_ = _tmp21_;
				_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp22_) : NULL);
				container = _tmp23_;
				_tmp24_ = container;
				rygel_trackable_container_add_child_tracked (_tmp24_, item, NULL, NULL);
				_g_object_unref0 (container);
			}
		}
		_g_object_unref0 (item);
		_g_object_unref0 (parent);
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = _error_;
		_tmp26_ = _tmp25_->message;
		g_warning ("rygel-media-export-harvesting-task.vala:336: Failed to extract meta-da" \
"ta for file %s", _tmp26_);
		_g_error_free0 (_error_);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp27_ = self->priv->files;
	_tmp28_ = gee_queue_poll (_tmp27_);
	_tmp29_ = (FileQueueEntry*) _tmp28_;
	_file_queue_entry_unref0 (_tmp29_);
	rygel_media_export_harvesting_task_do_update (self);
}


static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_) {
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaExportMediaCache* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GeeQueue* _tmp8_ = NULL;
	gpointer _tmp9_ = NULL;
	FileQueueEntry* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = _ ("Skipping URI %s; extraction completely failed: %s");
	_tmp1_ = file;
	_tmp2_ = g_file_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _error_;
	_tmp5_ = _tmp4_->message;
	g_warning (_tmp0_, _tmp3_, _tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = self->priv->cache;
	_tmp7_ = file;
	rygel_media_export_media_cache_blacklist (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->files;
	_tmp9_ = gee_queue_poll (_tmp8_);
	_tmp10_ = (FileQueueEntry*) _tmp9_;
	_file_queue_entry_unref0 (_tmp10_);
	rygel_media_export_harvesting_task_do_update (self);
}


/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self) {
	gboolean _tmp0_ = FALSE;
	GeeQueue* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->files;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GQueue* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->containers;
		_tmp5_ = g_queue_is_empty (_tmp4_);
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GQueue* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		RygelMediaContainer* _tmp8_ = NULL;
		_tmp6_ = self->priv->containers;
		_tmp7_ = g_queue_pop_head (_tmp6_);
		_tmp8_ = (RygelMediaContainer*) _tmp7_;
		_g_object_unref0 (_tmp8_);
	}
	rygel_media_export_harvesting_task_on_idle (self);
}


static GCancellable* rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_ = NULL;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass) {
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvestingTaskPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvesting_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvesting_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_export_harvesting_task_real_run;
	iface->run_finish = rygel_media_export_harvesting_task_real_run_finish;
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
}


static void rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE (self);
}


static void rygel_media_export_harvesting_task_finalize (GObject* obj) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportMetadataExtractor* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	_tmp0_ = self->priv->extractor;
	rygel_media_export_metadata_extractor_stop (_tmp0_);
	_g_object_unref0 (self->origin);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->cache);
	__g_queue_free__g_object_unref0_0 (self->priv->containers);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
}


GType rygel_media_export_harvesting_task_get_type (void) {
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}


static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



