/* rygel-item-updater.c generated by valac 0.32.0, the Vala compiler
 * generated from rygel-item-updater.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Krzesimir Nowak <krnowak@openismus.com>
 *         Doug Galligan <doug@sentosatech.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelItemUpdaterPrivate RygelItemUpdaterPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemUpdaterRunData RygelItemUpdaterRunData;
typedef struct _RygelItemUpdaterUpdateObjectData RygelItemUpdaterUpdateObjectData;
typedef struct _RygelItemUpdaterFetchObjectData RygelItemUpdaterFetchObjectData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelItemUpdater {
	GObject parent_instance;
	RygelItemUpdaterPrivate * priv;
};

struct _RygelItemUpdaterClass {
	GObjectClass parent_class;
};

struct _RygelItemUpdaterPrivate {
	gchar* object_id;
	gchar* current_tag_value;
	gchar* new_tag_value;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemUpdaterRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	GUPnPServiceAction* _tmp8_;
	GError* _tmp9_;
	gint _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _RygelItemUpdaterUpdateObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	GeeLinkedList* current_list;
	const gchar* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* new_list;
	const gchar* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeLinkedList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeLinkedList* _tmp15_;
	gint _tmp16_;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelMediaObject* _tmp19_;
	GeeLinkedList* _tmp20_;
	GeeLinkedList* _tmp21_;
	RygelContentDirectory* _tmp22_;
	RygelHTTPServer* _tmp23_;
	GUPnPDIDLLiteFragmentResult _tmp24_;
	GUPnPDIDLLiteFragmentResult _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError* _tmp35_;
	const gchar* _tmp36_;
	GError* _tmp37_;
	GError * _inner_error_;
};

struct _RygelItemUpdaterFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	RygelMediaObject* _tmp9_;
	GUPnPOCMFlags _tmp10_;
	GUPnPOCMFlags _tmp11_;
	gchar* msg;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelMediaContainer* _tmp20_;
	RygelMediaContainer* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gchar* _vala1_msg;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaContainer* _tmp31_;
	RygelMediaContainer* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _tmp35_;
	GError * _inner_error_;
};


static gpointer rygel_item_updater_parent_class = NULL;
static GRegex* rygel_item_updater_escape_regex;
static GRegex* rygel_item_updater_escape_regex = NULL;
static RygelStateMachineIface* rygel_item_updater_rygel_state_machine_parent_iface = NULL;

GType rygel_item_updater_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_UPDATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterPrivate))
enum  {
	RYGEL_ITEM_UPDATER_DUMMY_PROPERTY,
	RYGEL_ITEM_UPDATER_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
#define RYGEL_ITEM_UPDATER_QN_UPNP_DATE "dc:date"
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_item_updater_real_run_data_free (gpointer _data);
static void rygel_item_updater_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_updater_update_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_updater_update_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_item_updater_unescape (const gchar* value);
static gchar* rygel_item_updater_format_tag_values (const gchar* tag_values);
static void rygel_item_updater_check_date_tag (gchar** current_tag, int current_tag_length1, gchar** new_tag, int new_tag_length1, GError** error);
static void rygel_item_updater_check_date (const gchar* date_value, GError** error);
static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values);
static void rygel_item_updater_update_object_data_free (gpointer _data);
static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_);
static void rygel_item_updater_fetch_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_update_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static void rygel_item_updater_fetch_object_data_free (gpointer _data);
static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_updater_finalize (GObject* obj);
static void _vala_rygel_item_updater_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_updater_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
	g_boxed_free (gupnp_service_action_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemUpdater * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelContentDirectory* _tmp1_ = NULL;
	RygelContentDirectory* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemUpdater*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	_tmp2_ = content_dir;
	_tmp3_ = _tmp2_->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
	_tmp4_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp4_;
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}


RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_item_updater_construct (RYGEL_TYPE_ITEM_UPDATER, content_dir, action);
}


static void rygel_item_updater_real_run_data_free (gpointer _data) {
	RygelItemUpdaterRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterRunData, _data_);
}


static void rygel_item_updater_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdater * self;
	RygelItemUpdaterRunData* _data_;
	RygelItemUpdater* _tmp0_ = NULL;
	self = (RygelItemUpdater*) base;
	_data_ = g_slice_new0 (RygelItemUpdaterRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_real_run_co (_data_);
}


static void rygel_item_updater_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemUpdaterRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_updater_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_real_run_co (_data_);
}


static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->priv->action;
		gupnp_service_action_get (_data_->_tmp0_, "ObjectID", G_TYPE_STRING, &_data_->self->priv->object_id, "CurrentTagValue", G_TYPE_STRING, &_data_->self->priv->current_tag_value, "NewTagValue", G_TYPE_STRING, &_data_->self->priv->new_tag_value, NULL);
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->object_id;
		if (_data_->_tmp1_ == NULL) {
			_data_->_tmp2_ = NULL;
			_data_->_tmp2_ = _ ("Object ID missing");
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp2_);
			_data_->_inner_error_ = _data_->_tmp3_;
			goto __catch68_g_error;
		}
		_data_->_state_ = 1;
		rygel_item_updater_update_object (_data_->self, rygel_item_updater_run_ready, _data_);
		return FALSE;
		_state_1:
		rygel_item_updater_update_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch68_g_error;
		}
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->action;
		gupnp_service_action_return (_data_->_tmp4_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _ ("Successfully updated object '%s'");
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->object_id;
		g_debug (_data_->_tmp5_, _data_->_tmp6_);
	}
	goto __finally68;
	__catch68_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_error_;
		if (_data_->_tmp7_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->self->priv->action;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_error_;
			_data_->_tmp10_ = 0;
			_data_->_tmp10_ = _data_->_tmp9_->code;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_error_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			gupnp_service_action_return_error (_data_->_tmp8_, (guint) _data_->_tmp10_, _data_->_tmp12_);
		} else {
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->self->priv->action;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->_error_;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			gupnp_service_action_return_error (_data_->_tmp13_, (guint) 701, _data_->_tmp15_);
		}
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Failed to update object '%s': %s");
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->self->priv->object_id;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_error_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_);
		_g_error_free0 (_data_->_error_);
	}
	__finally68:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_item_updater_unescape (const gchar* value) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp1_ = rygel_item_updater_escape_regex;
		_tmp2_ = value;
		_tmp3_ = g_regex_replace (_tmp1_, _tmp2_, (gssize) -1, 0, "\\1", 0, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch69_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp4_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally69;
	__catch69_g_regex_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = value;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally69:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* rygel_item_updater_format_tag_values (const gchar* tag_values) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	g_return_val_if_fail (tag_values != NULL, NULL);
	_tmp1_ = tag_values;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		_tmp4_ = tag_values;
		_tmp5_ = string_get_char (_tmp4_, (glong) 0);
		_tmp0_ = _tmp5_ == ((gunichar) '<');
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** init_split = NULL;
		const gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint init_split_length1 = 0;
		gint _init_split_size_ = 0;
		gchar* tag_name = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* tag_value = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		gchar** _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		_tmp6_ = tag_values;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "</", 0);
		init_split = _tmp8_;
		init_split_length1 = _vala_array_length (_tmp7_);
		_init_split_size_ = init_split_length1;
		_tmp9_ = init_split;
		_tmp9__length1 = init_split_length1;
		_tmp10_ = _tmp9_[1];
		_tmp11_ = init_split;
		_tmp11__length1 = init_split_length1;
		_tmp12_ = _tmp11_[1];
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_substring (_tmp10_, (glong) 0, (glong) (_tmp14_ - 1));
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strstrip (_tmp16_);
		_tmp18_ = g_strdup (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp16_);
		tag_name = _tmp19_;
		_tmp20_ = init_split;
		_tmp20__length1 = init_split_length1;
		_tmp21_ = _tmp20_[0];
		_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, ">", 0);
		_tmp24_ = _tmp23_;
		_tmp24__length1 = _vala_array_length (_tmp22_);
		_tmp25_ = _tmp24_[1];
		_tmp26_ = g_strstrip (_tmp25_);
		_tmp27_ = g_strdup (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
		tag_value = _tmp28_;
		_tmp29_ = tag_name;
		g_debug ("rygel-item-updater.vala:113: Tag Name formatted :%s", _tmp29_);
		_tmp30_ = tag_value;
		g_debug ("rygel-item-updater.vala:114: Tag Value formatted :%s", _tmp30_);
		_tmp31_ = tag_name;
		_tmp32_ = tag_value;
		_tmp33_ = tag_name;
		_tmp34_ = g_strdup_printf ("<%s>%s</%s>", _tmp31_, _tmp32_, _tmp33_);
		result = _tmp34_;
		_g_free0 (tag_value);
		_g_free0 (tag_name);
		init_split = (_vala_array_free (init_split, init_split_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp35_ = tag_values;
	_tmp36_ = g_strdup (_tmp35_);
	result = _tmp36_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void rygel_item_updater_check_date_tag (gchar** current_tag, int current_tag_length1, gchar** new_tag, int new_tag_length1, GError** error) {
	gint date_index = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GError * _inner_error_ = NULL;
	date_index = -1;
	_tmp0_ = current_tag;
	_tmp0__length1 = current_tag_length1;
	{
		gchar** cur_str_collection = NULL;
		gint cur_str_collection_length1 = 0;
		gint _cur_str_collection_size_ = 0;
		gint cur_str_it = 0;
		cur_str_collection = _tmp0_;
		cur_str_collection_length1 = _tmp0__length1;
		for (cur_str_it = 0; cur_str_it < _tmp0__length1; cur_str_it = cur_str_it + 1) {
			const gchar* cur_str = NULL;
			cur_str = cur_str_collection[cur_str_it];
			{
				gint _tmp1_ = 0;
				const gchar* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				_tmp1_ = date_index;
				date_index = _tmp1_ + 1;
				_tmp2_ = cur_str;
				_tmp3_ = string_index_of (_tmp2_, RYGEL_ITEM_UPDATER_QN_UPNP_DATE, 0);
				if (_tmp3_ != -1) {
					gchar* date_val = NULL;
					gchar** _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
					gint _tmp5_ = 0;
					const gchar* _tmp6_ = NULL;
					gchar** _tmp7_ = NULL;
					gchar** _tmp8_ = NULL;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					const gchar* _tmp10_ = NULL;
					gchar** _tmp11_ = NULL;
					gchar** _tmp12_ = NULL;
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					_tmp4_ = new_tag;
					_tmp4__length1 = new_tag_length1;
					_tmp5_ = date_index;
					_tmp6_ = _tmp4_[_tmp5_];
					_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "</", 0);
					_tmp9_ = _tmp8_;
					_tmp9__length1 = _vala_array_length (_tmp7_);
					_tmp10_ = _tmp9_[0];
					_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, ">", 0);
					_tmp13_ = _tmp12_;
					_tmp13__length1 = _vala_array_length (_tmp11_);
					_tmp14_ = _tmp13_[1];
					_tmp15_ = g_strstrip (_tmp14_);
					_tmp16_ = g_strdup (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
					_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
					date_val = _tmp17_;
					_tmp18_ = date_val;
					rygel_item_updater_check_date (_tmp18_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (date_val);
						return;
					}
					_g_free0 (date_val);
					break;
				}
			}
		}
	}
	date_index = -1;
	_tmp19_ = new_tag;
	_tmp19__length1 = new_tag_length1;
	{
		gchar** new_str_collection = NULL;
		gint new_str_collection_length1 = 0;
		gint _new_str_collection_size_ = 0;
		gint new_str_it = 0;
		new_str_collection = _tmp19_;
		new_str_collection_length1 = _tmp19__length1;
		for (new_str_it = 0; new_str_it < _tmp19__length1; new_str_it = new_str_it + 1) {
			const gchar* new_str = NULL;
			new_str = new_str_collection[new_str_it];
			{
				gint _tmp20_ = 0;
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				_tmp20_ = date_index;
				date_index = _tmp20_ + 1;
				_tmp21_ = new_str;
				_tmp22_ = string_index_of (_tmp21_, RYGEL_ITEM_UPDATER_QN_UPNP_DATE, 0);
				if (_tmp22_ != -1) {
					gchar* date_val = NULL;
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gint _tmp24_ = 0;
					const gchar* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gchar** _tmp27_ = NULL;
					gchar** _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					const gchar* _tmp29_ = NULL;
					gchar** _tmp30_ = NULL;
					gchar** _tmp31_ = NULL;
					gchar** _tmp32_ = NULL;
					gint _tmp32__length1 = 0;
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					_tmp23_ = new_tag;
					_tmp23__length1 = new_tag_length1;
					_tmp24_ = date_index;
					_tmp25_ = _tmp23_[_tmp24_];
					_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "</", 0);
					_tmp28_ = _tmp27_;
					_tmp28__length1 = _vala_array_length (_tmp26_);
					_tmp29_ = _tmp28_[0];
					_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, ">", 0);
					_tmp32_ = _tmp31_;
					_tmp32__length1 = _vala_array_length (_tmp30_);
					_tmp33_ = _tmp32_[1];
					_tmp34_ = g_strstrip (_tmp33_);
					_tmp35_ = g_strdup (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
					_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
					date_val = _tmp36_;
					_tmp37_ = date_val;
					rygel_item_updater_check_date (_tmp37_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (date_val);
						return;
					}
					_g_free0 (date_val);
					break;
				}
			}
		}
	}
}


static void rygel_item_updater_check_date (const gchar* date_value, GError** error) {
	gint year = 0;
	gint month = 0;
	gint day = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GDate date = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (date_value != NULL);
	year = 0;
	month = 0;
	day = 0;
	_tmp0_ = date_value;
	_tmp1_ = sscanf (_tmp0_, "%4d-%02d-%02d", &year, &month, &day);
	if (_tmp1_ != 3) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = _ ("Invalid date format: %s");
		_tmp3_ = date_value;
		_tmp4_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _tmp2_, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	memset (&date, 0, sizeof (GDate));
	_tmp5_ = day;
	_tmp6_ = month;
	_tmp7_ = year;
	g_date_set_dmy (&date, (GDateDay) _tmp5_, (gint) ((GDateMonth) _tmp6_), (GDateYear) _tmp7_);
	_tmp8_ = g_date_valid (&date);
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp9_ = _ ("Invalid date: %s");
		_tmp10_ = date_value;
		_tmp11_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _tmp9_, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values) {
	GeeLinkedList* result = NULL;
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean escape = FALSE;
	gint token_start = 0;
	gint token_length = 0;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* stripped_values = NULL;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	GeeLinkedList* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = tag_values;
	if (_tmp1_ == NULL) {
		result = list;
		return result;
	}
	escape = FALSE;
	token_start = 0;
	token_length = 0;
	_tmp2_ = tag_values;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	{
		gint iter = 0;
		iter = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gchar c = '\0';
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gchar _tmp11_ = '\0';
				gboolean increase = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp35_ = FALSE;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = iter;
					iter = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = iter;
				_tmp8_ = len;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = tag_values;
				_tmp10_ = iter;
				_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
				c = _tmp11_;
				increase = TRUE;
				_tmp12_ = escape;
				if (_tmp12_) {
					escape = FALSE;
				} else {
					gchar _tmp13_ = '\0';
					_tmp13_ = c;
					switch (_tmp13_) {
						case '\\':
						{
							escape = TRUE;
							break;
						}
						case ',':
						{
							gchar* value = NULL;
							const gchar* _tmp14_ = NULL;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gchar* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							const gchar* _tmp19_ = NULL;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							GeeLinkedList* _tmp29_ = NULL;
							const gchar* _tmp30_ = NULL;
							gchar* _tmp31_ = NULL;
							gchar* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							_tmp14_ = tag_values;
							_tmp15_ = token_start;
							_tmp16_ = token_length;
							_tmp17_ = string_substring (_tmp14_, (glong) _tmp15_, (glong) _tmp16_);
							value = _tmp17_;
							_tmp19_ = value;
							_tmp20_ = strlen (_tmp19_);
							_tmp21_ = _tmp20_;
							if (_tmp21_ > 0) {
								const gchar* _tmp22_ = NULL;
								gchar _tmp23_ = '\0';
								_tmp22_ = value;
								_tmp23_ = string_get (_tmp22_, (glong) 0);
								_tmp18_ = _tmp23_ == '<';
							} else {
								_tmp18_ = FALSE;
							}
							if (_tmp18_) {
								const gchar* _tmp24_ = NULL;
								const gchar* _tmp25_ = NULL;
								gint _tmp26_ = 0;
								gint _tmp27_ = 0;
								gchar _tmp28_ = '\0';
								_tmp24_ = value;
								_tmp25_ = value;
								_tmp26_ = strlen (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = string_get (_tmp24_, (glong) (_tmp27_ - 1));
								if (!(_tmp28_ == '>')) {
									_g_free0 (value);
									break;
								}
							}
							_tmp29_ = list;
							_tmp30_ = value;
							_tmp31_ = rygel_item_updater_unescape (_tmp30_);
							_tmp32_ = _tmp31_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp32_);
							_g_free0 (_tmp32_);
							_tmp33_ = token_start;
							_tmp34_ = token_length;
							token_start = _tmp33_ + (_tmp34_ + 1);
							token_length = 0;
							increase = FALSE;
							_g_free0 (value);
							break;
						}
						default:
						break;
					}
				}
				_tmp35_ = increase;
				if (_tmp35_) {
					gint _tmp36_ = 0;
					_tmp36_ = token_length;
					token_length = _tmp36_ + 1;
				}
			}
		}
	}
	_tmp37_ = tag_values;
	_tmp38_ = token_start;
	_tmp39_ = string_substring (_tmp37_, (glong) _tmp38_, (glong) -1);
	_tmp40_ = _tmp39_;
	_tmp41_ = string_strip (_tmp40_);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp40_);
	stripped_values = _tmp42_;
	_tmp43_ = list;
	_tmp44_ = stripped_values;
	_tmp45_ = rygel_item_updater_unescape (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = rygel_item_updater_format_tag_values (_tmp46_);
	_tmp48_ = _tmp47_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp48_);
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	result = list;
	_g_free0 (stripped_values);
	return result;
}


static void rygel_item_updater_update_object_data_free (gpointer _data) {
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterUpdateObjectData, _data_);
}


static void rygel_item_updater_update_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdaterUpdateObjectData* _data_;
	RygelItemUpdater* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelItemUpdaterUpdateObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_update_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_update_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_update_object_co (_data_);
}


static void rygel_item_updater_update_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error) {
	RygelItemUpdaterUpdateObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_updater_update_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_update_object_co (_data_);
}


static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_item_updater_fetch_object (_data_->self, rygel_item_updater_update_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_item_updater_fetch_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->media_object = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->current_tag_value;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_item_updater_csv_split (_data_->_tmp1_);
	_data_->current_list = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->new_tag_value;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rygel_item_updater_csv_split (_data_->_tmp3_);
	_data_->new_list = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->current_list;
	_data_->_tmp6_ = 0;
	_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp5_);
	_data_->_tmp7_ = 0;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->new_list;
	_data_->_tmp9_ = 0;
	_data_->_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp8_);
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp7_ == _data_->_tmp10_) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->current_list;
		_data_->_tmp12_ = 0;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp11_, &_data_->_tmp12_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14__length1 = 0;
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp14__length1 = _data_->_tmp12_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->new_list;
		_data_->_tmp16_ = 0;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp15_, &_data_->_tmp16_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18__length1 = 0;
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp18__length1 = _data_->_tmp16_;
		rygel_item_updater_check_date_tag (_data_->_tmp14_, _data_->_tmp12_, _data_->_tmp18_, _data_->_tmp16_, &_data_->_inner_error_);
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->media_object;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->current_list;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->new_list;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->self->priv->content_dir;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->_tmp22_->http_server;
	_data_->_state_ = 2;
	rygel_media_object_apply_fragments (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp21_, _data_->_tmp23_, rygel_item_updater_update_object_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp24_ = 0;
	_data_->_tmp24_ = rygel_media_object_apply_fragments_finish (_data_->_tmp19_, _data_->_res_);
	_data_->_result_ = _data_->_tmp24_;
	_data_->_tmp25_ = 0;
	_data_->_tmp25_ = _data_->_result_;
	switch (_data_->_tmp25_) {
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK:
		{
			break;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_BAD_XML:
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_INVALID:
		{
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _ ("Bad current tag value.");
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE, _data_->_tmp26_);
			_data_->_inner_error_ = _data_->_tmp27_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_BAD_XML:
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_INVALID:
		{
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _ ("Bad new tag value.");
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _data_->_tmp28_);
			_data_->_inner_error_ = _data_->_tmp29_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_REQUIRED_TAG:
		{
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _ ("Tried to delete required tag.");
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG, _data_->_tmp30_);
			_data_->_inner_error_ = _data_->_tmp31_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_READONLY_TAG:
		{
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _ ("Tried to change read-only property.");
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG, _data_->_tmp32_);
			_data_->_inner_error_ = _data_->_tmp33_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_MISMATCH:
		{
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _ ("Parameter count mismatch.");
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH, _data_->_tmp34_);
			_data_->_inner_error_ = _data_->_tmp35_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		default:
		{
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _ ("Unknown error.");
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp36_);
			_data_->_inner_error_ = _data_->_tmp37_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->new_list);
	_g_object_unref0 (_data_->current_list);
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_item_updater_fetch_object_data_free (gpointer _data) {
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterFetchObjectData, _data_);
}


static void rygel_item_updater_fetch_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdaterFetchObjectData* _data_;
	RygelItemUpdater* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelItemUpdaterFetchObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_fetch_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_fetch_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_fetch_object_co (_data_);
}


static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemUpdaterFetchObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_updater_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_fetch_object_co (_data_);
}


static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->object_id;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp4_, rygel_item_updater_fetch_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_media_container_find_object_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	_data_->media_object = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->media_object;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("No such object");
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->media_object;
		_data_->_tmp10_ = 0;
		_data_->_tmp10_ = rygel_media_object_get_ocm_flags (_data_->_tmp9_);
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = _data_->_tmp10_;
		if (!((_data_->_tmp11_ & GUPNP_OCM_FLAGS_CHANGE_METADATA) == GUPNP_OCM_FLAGS_CHANGE_METADATA)) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _ ("Metadata modification of object %s not allowed");
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
			_data_->msg = _data_->_tmp13_;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->msg;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->media_object;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = rygel_media_object_get_id (_data_->_tmp15_);
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, _data_->_tmp14_, _data_->_tmp17_);
			_data_->_inner_error_ = _data_->_tmp18_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->msg);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->media_object;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = rygel_media_object_get_parent (_data_->_tmp19_);
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp22_ = FALSE;
			_data_->_tmp22_ = rygel_media_object_get_restricted ((RygelMediaObject*) _data_->_tmp21_);
			_data_->_tmp23_ = FALSE;
			_data_->_tmp23_ = _data_->_tmp22_;
			if (_data_->_tmp23_) {
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _ ("Metadata modification of object %s being a child of restricted object " \
"%s not allowed");
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
				_data_->_vala1_msg = _data_->_tmp25_;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->_vala1_msg;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->media_object;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = rygel_media_object_get_id (_data_->_tmp27_);
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->media_object;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = rygel_media_object_get_parent (_data_->_tmp30_);
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->_tmp31_;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp32_);
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->_tmp33_;
				_data_->_tmp35_ = NULL;
				_data_->_tmp35_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp26_, _data_->_tmp29_, _data_->_tmp34_);
				_data_->_inner_error_ = _data_->_tmp35_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_free0 (_data_->_vala1_msg);
				_g_object_unref0 (_data_->media_object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = _data_->media_object;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GCancellable* rygel_item_updater_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemUpdater* self;
	GCancellable* _tmp0_ = NULL;
	self = (RygelItemUpdater*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_item_updater_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemUpdater* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	self = (RygelItemUpdater*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_updater_class_init (RygelItemUpdaterClass * klass) {
	GError * _inner_error_ = NULL;
	rygel_item_updater_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemUpdaterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_updater_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_updater_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_updater_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_UPDATER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		_tmp1_ = g_regex_new ("\\\\(.)", 0, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch70_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_item_updater_escape_regex);
		rygel_item_updater_escape_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally70;
	__catch70_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally70:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_item_updater_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_updater_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_updater_real_run;
	iface->run_finish = rygel_item_updater_real_run_finish;
	iface->get_cancellable = rygel_item_updater_real_get_cancellable;
	iface->set_cancellable = rygel_item_updater_real_set_cancellable;
}


static void rygel_item_updater_instance_init (RygelItemUpdater * self) {
	self->priv = RYGEL_ITEM_UPDATER_GET_PRIVATE (self);
}


static void rygel_item_updater_finalize (GObject* obj) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	_g_free0 (self->priv->object_id);
	_g_free0 (self->priv->current_tag_value);
	_g_free0 (self->priv->new_tag_value);
	_g_object_unref0 (self->priv->content_dir);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_updater_parent_class)->finalize (obj);
}


/**
 * UpdateObject action implementation.
 */
GType rygel_item_updater_get_type (void) {
	static volatile gsize rygel_item_updater_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_updater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemUpdaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_updater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemUpdater), 0, (GInstanceInitFunc) rygel_item_updater_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_updater_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_updater_type_id;
		rygel_item_updater_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemUpdater", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_updater_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_updater_type_id__volatile, rygel_item_updater_type_id);
	}
	return rygel_item_updater_type_id__volatile;
}


static void _vala_rygel_item_updater_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	switch (property_id) {
		case RYGEL_ITEM_UPDATER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_item_updater_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	switch (property_id) {
		case RYGEL_ITEM_UPDATER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



