/* rygel-tracker-search-container.c generated by valac 0.27.1.26-9b1a5, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP (rygel_tracker_upn_pproperty_map_get_type ())
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMap))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))

typedef struct _RygelTrackerUPnPPropertyMap RygelTrackerUPnPPropertyMap;
typedef struct _RygelTrackerUPnPPropertyMapClass RygelTrackerUPnPPropertyMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerExecuteQueryData RygelTrackerSearchContainerExecuteQueryData;
typedef struct _RygelTrackerSearchContainerFindObjectData RygelTrackerSearchContainerFindObjectData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelTrackerSearchContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerSearchContainerPrivate {
	TrackerSparqlConnection* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaFileItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
	void (*add_resources) (RygelTrackerItemFactory* self, RygelMediaItem* item, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	RygelMediaObjects* _tmp5_;
	const gchar* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	GCancellable* _tmp9_;
	guint _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelMediaObjects* _tmp12_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerExecuteQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	gchar* sort_criteria;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp0_;
	RygelTrackerSelectionQuery* query;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	RygelTrackerSelectionQuery* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	RygelTrackerSelectionQuery* _tmp7_;
	TrackerSparqlConnection* _tmp8_;
	gboolean _tmp9_;
	RygelTrackerSelectionQuery* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	gboolean _tmp12_;
	gchar* id;
	RygelTrackerSelectionQuery* _tmp13_;
	TrackerSparqlCursor* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* uri;
	RygelTrackerSelectionQuery* _tmp19_;
	TrackerSparqlCursor* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	RygelMediaFileItem* item;
	RygelTrackerItemFactory* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	RygelTrackerSelectionQuery* _tmp26_;
	TrackerSparqlCursor* _tmp27_;
	RygelMediaFileItem* _tmp28_;
	RygelMediaObjects* _tmp29_;
	RygelMediaFileItem* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp2_;
	RygelRelationalExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	gchar* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	guint total_matches;
	RygelMediaObjects* results;
	RygelRelationalExpression* _tmp9_;
	GCancellable* _tmp10_;
	guint _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	RygelMediaObjects* _tmp16_;
	gpointer _tmp17_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp0_;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelTrackerSelectionQuery* _tmp4_;
	GeeArrayList* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	TrackerSparqlConnection* _tmp7_;
	gboolean _tmp8_;
	RygelTrackerSelectionQuery* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	gboolean _tmp11_;
	RygelTrackerSelectionQuery* _tmp12_;
	TrackerSparqlCursor* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	RygelTrackerItemFactory* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;
static GeeHashMap* rygel_tracker_search_container_update_id_hash;
static GeeHashMap* rygel_tracker_search_container_update_id_hash = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "nfo:fileLastModified"
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void __lambda4_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaObject* origin);
static void ___lambda4__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
GType rygel_tracker_upn_pproperty_map_get_type (void) G_GNUC_CONST;
RygelTrackerUPnPPropertyMap* rygel_tracker_upn_pproperty_map_get_property_map (void);
gchar* rygel_tracker_upn_pproperty_map_get (RygelTrackerUPnPPropertyMap* self, const gchar* property);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_);
void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, const gchar* sort_criteria, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_search_container_execute_query_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, const gchar* sort_criteria);
void rygel_tracker_query_execute (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn);
RygelMediaFileItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_);
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id);
static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self, const gchar* sort_criteria);
static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn);
gchar* rygel_tracker_query_escape_string (const gchar* literal);
gchar* rygel_tracker_query_escape_regex (const gchar* literal);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __lambda4_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaObject* origin) {
	RygelMediaObject* _tmp0_ = NULL;
	g_return_if_fail (container != NULL);
	g_return_if_fail (origin != NULL);
	_tmp0_ = origin;
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject)) {
		GeeHashMap* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		guint32 _tmp4_ = 0U;
		_tmp1_ = rygel_tracker_search_container_update_id_hash;
		_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = ((RygelMediaContainer*) self)->update_id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp3_, (gpointer) ((guintptr) ((guint) _tmp4_)));
	}
}


static void ___lambda4__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	__lambda4_ ((RygelTrackerSearchContainer*) self, container, object);
}


static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
	RygelTrackerSearchContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	RygelTrackerItemFactory* _tmp14_ = NULL;
	RygelTrackerItemFactory* _tmp15_ = NULL;
	GeeArrayList* variables = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	RygelTrackerQueryTriplets* our_triplets = NULL;
	RygelTrackerQueryTriplets* _tmp18_ = NULL;
	RygelTrackerQueryTriplets* _tmp22_ = NULL;
	RygelTrackerItemFactory* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	RygelTrackerQueryTriplet* _tmp25_ = NULL;
	RygelTrackerQueryTriplet* _tmp26_ = NULL;
	RygelTrackerUPnPPropertyMap* property_map = NULL;
	RygelTrackerUPnPPropertyMap* _tmp27_ = NULL;
	gchar* order_by = NULL;
	gchar* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	RygelTrackerQueryTriplets* _tmp47_ = NULL;
	GeeArrayList* _tmp48_ = NULL;
	RygelTrackerSelectionQuery* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	self = (RygelTrackerSearchContainer*) rygel_simple_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = rygel_tracker_search_container_update_id_hash;
	_tmp4_ = G_UNLIKELY (_tmp3_ == NULL);
	if (_tmp4_) {
		GeeHashMap* _tmp5_ = NULL;
		_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_tracker_search_container_update_id_hash);
		rygel_tracker_search_container_update_id_hash = _tmp5_;
	}
	_tmp6_ = rygel_tracker_search_container_update_id_hash;
	_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp8_);
	if (_tmp9_) {
		GeeHashMap* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		_tmp10_ = rygel_tracker_search_container_update_id_hash;
		_tmp11_ = rygel_media_object_get_id ((RygelMediaObject*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp12_);
		((RygelMediaContainer*) self)->update_id = (guint32) ((guint) ((guintptr) _tmp13_));
	}
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) ___lambda4__rygel_media_container_container_updated, self, 0);
	_tmp14_ = item_factory;
	_tmp15_ = _rygel_tracker_item_factory_ref0 (_tmp14_);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	self->item_factory = _tmp15_;
	_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	variables = _tmp16_;
	_tmp17_ = variables;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
	_tmp18_ = triplets;
	if (_tmp18_ != NULL) {
		RygelTrackerQueryTriplets* _tmp19_ = NULL;
		RygelTrackerQueryTriplets* _tmp20_ = NULL;
		_tmp19_ = triplets;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (our_triplets);
		our_triplets = _tmp20_;
	} else {
		RygelTrackerQueryTriplets* _tmp21_ = NULL;
		_tmp21_ = rygel_tracker_query_triplets_new ();
		_g_object_unref0 (our_triplets);
		our_triplets = _tmp21_;
	}
	_tmp22_ = our_triplets;
	_tmp23_ = item_factory;
	_tmp24_ = _tmp23_->category;
	_tmp25_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", _tmp24_);
	_tmp26_ = _tmp25_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp26_);
	_rygel_tracker_query_triplet_unref0 (_tmp26_);
	_tmp27_ = rygel_tracker_upn_pproperty_map_get_property_map ();
	property_map = _tmp27_;
	{
		GeeArrayList* _property_list = NULL;
		RygelTrackerItemFactory* _tmp28_ = NULL;
		GeeArrayList* _tmp29_ = NULL;
		GeeArrayList* _tmp30_ = NULL;
		gint _property_size = 0;
		GeeArrayList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _property_index = 0;
		_tmp28_ = self->item_factory;
		_tmp29_ = _tmp28_->properties;
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_property_list = _tmp30_;
		_tmp31_ = _property_list;
		_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_property_size = _tmp33_;
		_property_index = -1;
		while (TRUE) {
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gchar* property = NULL;
			GeeArrayList* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gpointer _tmp39_ = NULL;
			GeeArrayList* _tmp40_ = NULL;
			RygelTrackerUPnPPropertyMap* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			_tmp34_ = _property_index;
			_property_index = _tmp34_ + 1;
			_tmp35_ = _property_index;
			_tmp36_ = _property_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _property_list;
			_tmp38_ = _property_index;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp38_);
			property = (gchar*) _tmp39_;
			_tmp40_ = variables;
			_tmp41_ = property_map;
			_tmp42_ = property;
			_tmp43_ = rygel_tracker_upn_pproperty_map_get (_tmp41_, _tmp42_);
			_tmp44_ = _tmp43_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp44_);
			_g_free0 (_tmp44_);
			_g_free0 (property);
		}
		_g_object_unref0 (_property_list);
	}
	_tmp45_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")");
	order_by = _tmp45_;
	_tmp46_ = variables;
	_tmp47_ = our_triplets;
	_tmp48_ = filters;
	_tmp49_ = rygel_tracker_selection_query_new (_tmp46_, _tmp47_, _tmp48_, order_by, 0, -1);
	_rygel_tracker_query_unref0 (self->query);
	self->query = _tmp49_;
	{
		TrackerSparqlConnection* _tmp50_ = NULL;
		TrackerSparqlConnection* _tmp51_ = NULL;
		TrackerSparqlConnection* _tmp52_ = NULL;
		_tmp51_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp50_ = _tmp51_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp52_ = _tmp50_;
		_tmp50_ = NULL;
		_g_object_unref0 (self->priv->resources);
		self->priv->resources = _tmp52_;
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
		_g_object_unref0 (_tmp50_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp53_ = NULL;
		GError* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp53_ = _ ("Failed to get Tracker connection: %s");
		_tmp54_ = _error_;
		_tmp55_ = _tmp54_->message;
		g_critical (_tmp53_, _tmp55_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (order_by);
		_g_object_unref0 (property_map);
		_g_object_unref0 (our_triplets);
		_g_object_unref0 (variables);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (order_by);
	_g_object_unref0 (property_map);
	_g_object_unref0 (our_triplets);
	_g_object_unref0 (variables);
	return self;
}


RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
	return rygel_tracker_search_container_construct (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, id, parent, title, item_factory, triplets, filters);
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, _data_);
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = sort_criteria;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	((RygelSearchExpression*) _data_->expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup ("@parentID");
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->sort_criteria;
	_data_->_tmp7_ = 0U;
	_data_->_tmp7_ = _data_->offset;
	_data_->_tmp8_ = 0U;
	_data_->_tmp8_ = _data_->max_count;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->cancellable;
	_data_->_tmp10_ = 0U;
	_data_->_state_ = 1;
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->expression, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, rygel_tracker_search_container_get_children_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp10_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp10_;
	_data_->_tmp5_ = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_data_->result = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp5_);
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->_tmp5_);
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_search_container_execute_query_data_free (gpointer _data) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerExecuteQueryData, _data_);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, const gchar* sort_criteria, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerExecuteQueryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_execute_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_execute_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = sort_criteria;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp4_;
	_tmp5_ = offset;
	_data_->offset = _tmp5_;
	_tmp6_ = max_count;
	_data_->max_count = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_tracker_search_container_execute_query_co (_data_);
}


RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_execute_query_co (_data_);
}


static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->results = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->expression;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->offset;
	_data_->_tmp3_ = 0U;
	_data_->_tmp3_ = _data_->max_count;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->sort_criteria;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_tracker_search_container_create_query (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->_tmp1_) : NULL, (gint) _data_->_tmp2_, (gint) _data_->_tmp3_, _data_->_tmp4_);
	_data_->query = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->query;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->query;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_tmp8_, rygel_tracker_search_container_execute_query_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_rygel_tracker_query_unref0 (_data_->query);
			_g_object_unref0 (_data_->results);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		while (TRUE) {
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->query;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_tmp10_->result;
			_data_->_state_ = 2;
			tracker_sparql_cursor_next_async (_data_->_tmp11_, NULL, rygel_tracker_search_container_execute_query_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp12_ = FALSE;
			_data_->_tmp12_ = tracker_sparql_cursor_next_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp9_ = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_rygel_tracker_query_unref0 (_data_->query);
				_g_object_unref0 (_data_->results);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (!_data_->_tmp9_) {
				break;
			}
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->query;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->_tmp13_->result;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = tracker_sparql_cursor_get_string (_data_->_tmp14_, 0, NULL);
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
			_data_->id = _data_->_tmp16_;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->id;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = rygel_tracker_search_container_create_child_id_for_urn (_data_->self, _data_->_tmp17_);
			_g_free0 (_data_->id);
			_data_->id = _data_->_tmp18_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->query;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_->result;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = tracker_sparql_cursor_get_string (_data_->_tmp20_, 1, NULL);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
			_data_->uri = _data_->_tmp22_;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->self->item_factory;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->id;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->uri;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->query;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->_tmp26_->result;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = rygel_tracker_item_factory_create (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->self, _data_->_tmp27_, &_data_->_inner_error_);
			_data_->item = _data_->_tmp28_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_free0 (_data_->uri);
				_g_free0 (_data_->id);
				_rygel_tracker_query_unref0 (_data_->query);
				_g_object_unref0 (_data_->results);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->results;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->item;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp29_, (RygelMediaObject*) _data_->_tmp30_);
			_g_object_unref0 (_data_->item);
			_g_free0 (_data_->uri);
			_g_free0 (_data_->id);
		}
	}
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->results;
	_data_->_tmp32_ = 0;
	_data_->_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp31_);
	_data_->_tmp33_ = 0;
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->total_matches = (guint) _data_->_tmp33_;
	_data_->result = _data_->results;
	_rygel_tracker_query_unref0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_rygel_tracker_query_unref0 (_data_->query);
	_g_object_unref0 (_data_->results);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data) {
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerFindObjectData, _data_);
}


static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerFindObjectData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_tracker_search_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerSearchContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = rygel_tracker_search_container_is_our_child (_data_->self, _data_->_tmp0_);
	if (!_data_->_tmp1_) {
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp3_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->expression;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strdup ("@id");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp4_)->operand1);
	((RygelSearchExpression*) _data_->_tmp4_)->operand1 = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->expression;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
	_g_free0 (((RygelSearchExpression*) _data_->_tmp6_)->operand2);
	((RygelSearchExpression*) _data_->_tmp6_)->operand2 = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->expression;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->cancellable;
	_data_->_tmp11_ = 0U;
	_data_->_state_ = 1;
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->_tmp9_, "", (guint) 0, (guint) 1, _data_->_tmp10_, rygel_tracker_search_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp11_;
	_data_->results = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->results;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp13_);
	_data_->_tmp15_ = 0;
	_data_->_tmp15_ = _data_->_tmp14_;
	if (_data_->_tmp15_ > 0) {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->results;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp16_, 0);
		_data_->result = (RygelMediaObject*) _data_->_tmp17_;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->results);
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (urn != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ",", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = urn;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	result = _tmp6_;
	return result;
}


gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id) {
	gchar* _vala_parent_id = NULL;
	gchar* result = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp0_ = item_id;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 2);
	tokens = _tmp2_;
	tokens_length1 = _vala_array_length (_tmp1_);
	_tokens_size_ = tokens_length1;
	_tmp4_ = tokens;
	_tmp4__length1 = tokens_length1;
	_tmp5_ = _tmp4_[0];
	if (_tmp5_ != NULL) {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = tokens;
		_tmp6__length1 = tokens_length1;
		_tmp7_ = _tmp6_[1];
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp8_ = tokens;
		_tmp8__length1 = tokens_length1;
		_tmp9_ = _tmp8_[0];
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_vala_parent_id);
		_vala_parent_id = _tmp10_;
		_tmp11_ = tokens;
		_tmp11__length1 = tokens_length1;
		_tmp12_ = _tmp11_[1];
		_tmp13_ = g_strdup (_tmp12_);
		result = _tmp13_;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (parent_id) {
			*parent_id = _vala_parent_id;
		} else {
			_g_free0 (_vala_parent_id);
		}
		return result;
	} else {
		_g_free0 (_vala_parent_id);
		_vala_parent_id = NULL;
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (parent_id) {
			*parent_id = _vala_parent_id;
		} else {
			_g_free0 (_vala_parent_id);
		}
		return result;
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (parent_id) {
		*parent_id = _vala_parent_id;
	} else {
		_g_free0 (_vala_parent_id);
	}
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, _data_);
}


void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->query;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = rygel_tracker_selection_query_new_clone (_data_->_tmp0_);
		_data_->query = _data_->_tmp1_;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->query;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (_data_->_tmp2_->variables);
		_data_->_tmp2_->variables = _data_->_tmp3_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->variables;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, "COUNT(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") AS x");
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->query;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_tmp7_, rygel_tracker_search_container_get_children_count_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_rygel_tracker_query_unref0 (_data_->query);
			goto __catch5_g_error;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->query;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_->result;
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = tracker_sparql_cursor_next (_data_->_tmp10_, NULL, &_data_->_inner_error_);
		_data_->_tmp8_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_rygel_tracker_query_unref0 (_data_->query);
			goto __catch5_g_error;
		}
		if (_data_->_tmp8_) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->query;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_->result;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = tracker_sparql_cursor_get_string (_data_->_tmp13_, 0, NULL);
			_data_->_tmp15_ = 0;
			_data_->_tmp15_ = atoi (_data_->_tmp14_);
			rygel_media_container_set_child_count ((RygelMediaContainer*) _data_->self, _data_->_tmp15_);
			rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		}
		_rygel_tracker_query_unref0 (_data_->query);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Error getting item count under category '%s': %s");
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->self->item_factory;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_tmp17_->category;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_error_;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_critical (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp20_);
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = id;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ",", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_str_has_prefix (_tmp0_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, const gchar* sort_criteria) {
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	RygelTrackerSelectionQuery* query = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	RygelRelationalExpression* _tmp15_ = NULL;
	gconstpointer _tmp16_ = NULL;
	RygelTrackerSelectionQuery* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	RygelTrackerSelectionQuery* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp1_ = expression;
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
		RygelTrackerItemFactory* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelRelationalExpression* _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = self->item_factory;
		_tmp4_ = _tmp3_->upnp_class;
		_tmp5_ = expression;
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand2;
		_tmp7_ = g_str_has_prefix (_tmp4_, (const gchar*) _tmp6_);
		_tmp0_ = !_tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp9_ = sort_criteria;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = sort_criteria;
		_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
	}
	if (_tmp8_) {
		RygelTrackerSelectionQuery* _tmp11_ = NULL;
		RygelTrackerSelectionQuery* _tmp12_ = NULL;
		_tmp11_ = self->query;
		_tmp12_ = rygel_tracker_selection_query_new_clone (_tmp11_);
		_rygel_tracker_query_unref0 (query);
		query = _tmp12_;
	} else {
		const gchar* _tmp13_ = NULL;
		RygelTrackerSelectionQuery* _tmp14_ = NULL;
		_tmp13_ = sort_criteria;
		_tmp14_ = rygel_tracker_search_container_create_sorted_query (self, _tmp13_);
		_rygel_tracker_query_unref0 (query);
		query = _tmp14_;
	}
	_tmp15_ = expression;
	_tmp16_ = ((RygelSearchExpression*) _tmp15_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp16_, "@parentID") == 0) {
		RygelRelationalExpression* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		_tmp17_ = expression;
		_tmp18_ = rygel_media_object_get_id ((RygelMediaObject*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = rygel_relational_expression_compare_string (_tmp17_, _tmp19_);
		if (!_tmp20_) {
			result = NULL;
			_rygel_tracker_query_unref0 (query);
			return result;
		}
	} else {
		RygelRelationalExpression* _tmp21_ = NULL;
		gconstpointer _tmp22_ = NULL;
		_tmp21_ = expression;
		_tmp22_ = ((RygelSearchExpression*) _tmp21_)->operand1;
		if (g_strcmp0 ((const gchar*) _tmp22_, "upnp:class") != 0) {
			gchar* filter = NULL;
			RygelRelationalExpression* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp23_ = expression;
			_tmp24_ = rygel_tracker_search_container_create_filter_for_child (self, _tmp23_);
			filter = _tmp24_;
			_tmp25_ = filter;
			if (_tmp25_ != NULL) {
				RygelTrackerSelectionQuery* _tmp26_ = NULL;
				GeeArrayList* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				_tmp26_ = query;
				_tmp27_ = _tmp26_->filters;
				_tmp28_ = filter;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp27_, 0, _tmp28_);
			} else {
				result = NULL;
				_g_free0 (filter);
				_rygel_tracker_query_unref0 (query);
				return result;
			}
			_g_free0 (filter);
		}
	}
	_tmp29_ = query;
	_tmp30_ = offset;
	_tmp29_->offset = _tmp30_;
	_tmp31_ = query;
	_tmp32_ = max_count;
	_tmp31_->max_count = _tmp32_;
	result = query;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self, const gchar* sort_criteria) {
	RygelTrackerSelectionQuery* result = NULL;
	RygelTrackerUPnPPropertyMap* key_chain_map = NULL;
	RygelTrackerUPnPPropertyMap* _tmp0_ = NULL;
	gchar** sort_props = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint sort_props_length1 = 0;
	gint _sort_props_size_ = 0;
	gchar* order = NULL;
	gchar* _tmp4_ = NULL;
	GeeArrayList* variables = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	RygelTrackerSelectionQuery* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	RygelTrackerSelectionQuery* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	const gchar* _tmp37_ = NULL;
	GeeArrayList* _tmp41_ = NULL;
	RygelTrackerSelectionQuery* _tmp42_ = NULL;
	RygelTrackerQueryTriplets* _tmp43_ = NULL;
	RygelTrackerQueryTriplets* _tmp44_ = NULL;
	RygelTrackerQueryTriplets* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	RygelTrackerSelectionQuery* _tmp48_ = NULL;
	RygelTrackerSelectionQuery* _tmp49_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_tracker_upn_pproperty_map_get_property_map ();
	key_chain_map = _tmp0_;
	_tmp1_ = sort_criteria;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
	sort_props = _tmp3_;
	sort_props_length1 = _vala_array_length (_tmp2_);
	_sort_props_size_ = sort_props_length1;
	_tmp4_ = g_strdup ("");
	order = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	variables = _tmp5_;
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	filters = _tmp6_;
	_tmp7_ = variables;
	_tmp8_ = self->query;
	_tmp9_ = _tmp8_->variables;
	gee_array_list_add_all (_tmp7_, (GeeCollection*) _tmp9_);
	_tmp10_ = filters;
	_tmp11_ = self->query;
	_tmp12_ = _tmp11_->filters;
	gee_array_list_add_all (_tmp10_, (GeeCollection*) _tmp12_);
	_tmp13_ = sort_props;
	_tmp13__length1 = sort_props_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp13_;
		s_collection_length1 = _tmp13__length1;
		for (s_it = 0; s_it < _tmp13__length1; s_it = s_it + 1) {
			gchar* _tmp14_ = NULL;
			gchar* s = NULL;
			_tmp14_ = g_strdup (s_collection[s_it]);
			s = _tmp14_;
			{
				gchar* key = NULL;
				RygelTrackerUPnPPropertyMap* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				_tmp15_ = key_chain_map;
				_tmp16_ = s;
				_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) (-1));
				_tmp18_ = _tmp17_;
				_tmp19_ = rygel_tracker_upn_pproperty_map_get (_tmp15_, _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				key = _tmp20_;
				_tmp21_ = key;
				_tmp22_ = string_index_of (_tmp21_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, 0);
				if (_tmp22_ == 0) {
					_g_free0 (key);
					_g_free0 (s);
					continue;
				}
				_tmp23_ = s;
				_tmp24_ = g_str_has_prefix (_tmp23_, "-");
				if (_tmp24_) {
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					_tmp25_ = order;
					_tmp26_ = key;
					_tmp27_ = g_strconcat ("DESC (", _tmp26_, NULL);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat (_tmp28_, ") ", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strconcat (_tmp25_, _tmp30_, NULL);
					_g_free0 (order);
					order = _tmp31_;
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
				} else {
					const gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					_tmp32_ = order;
					_tmp33_ = key;
					_tmp34_ = g_strconcat (_tmp33_, " ", NULL);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
					_g_free0 (order);
					order = _tmp36_;
					_g_free0 (_tmp35_);
				}
				_g_free0 (key);
				_g_free0 (s);
			}
		}
	}
	_tmp37_ = order;
	if (g_strcmp0 (_tmp37_, "") == 0) {
		RygelTrackerSelectionQuery* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp38_ = self->query;
		_tmp39_ = _tmp38_->order_by;
		_tmp40_ = g_strdup (_tmp39_);
		_g_free0 (order);
		order = _tmp40_;
	}
	_tmp41_ = variables;
	_tmp42_ = self->query;
	_tmp43_ = ((RygelTrackerQuery*) _tmp42_)->triplets;
	_tmp44_ = rygel_tracker_query_triplets_new_clone (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = filters;
	_tmp47_ = order;
	_tmp48_ = rygel_tracker_selection_query_new (_tmp41_, _tmp45_, _tmp46_, _tmp47_, 0, -1);
	_tmp49_ = _tmp48_;
	_g_object_unref0 (_tmp45_);
	result = _tmp49_;
	_g_object_unref0 (filters);
	_g_object_unref0 (variables);
	_g_free0 (order);
	sort_props = (_vala_array_free (sort_props, sort_props_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (key_chain_map);
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	GString* urn_builder = NULL;
	GString* _tmp0_ = NULL;
	const gchar* s = NULL;
	const gchar* _tmp1_ = NULL;
	GString* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (urn != NULL, NULL);
	_tmp0_ = g_string_new ("");
	urn_builder = _tmp0_;
	_tmp1_ = urn;
	s = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			const gchar* _tmp5_ = NULL;
			gunichar _tmp6_ = 0U;
			gunichar character = 0U;
			const gchar* _tmp7_ = NULL;
			gunichar _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gunichar _tmp10_ = 0U;
			gboolean _tmp11_ = FALSE;
			if (!_tmp2_) {
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				_tmp3_ = s;
				_tmp4_ = g_utf8_next_char (_tmp3_);
				s = _tmp4_;
			}
			_tmp2_ = FALSE;
			_tmp5_ = s;
			_tmp6_ = string_get_char (_tmp5_, (glong) 0);
			if (!(_tmp6_ != ((gunichar) 0))) {
				break;
			}
			_tmp7_ = s;
			_tmp8_ = string_get_char (_tmp7_, (glong) 0);
			character = _tmp8_;
			_tmp10_ = character;
			_tmp11_ = g_unichar_iscntrl (_tmp10_);
			if (_tmp11_) {
				_tmp9_ = TRUE;
			} else {
				gunichar _tmp12_ = 0U;
				gboolean _tmp13_ = FALSE;
				_tmp12_ = character;
				_tmp13_ = g_unichar_validate (_tmp12_);
				_tmp9_ = !_tmp13_;
			}
			if (!_tmp9_) {
				GString* _tmp14_ = NULL;
				gunichar _tmp15_ = 0U;
				_tmp14_ = urn_builder;
				_tmp15_ = character;
				g_string_append_unichar (_tmp14_, _tmp15_);
			}
		}
	}
	_tmp16_ = urn_builder;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_string_free0 (urn_builder);
	return result;
}


static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
	gchar* result = NULL;
	gchar* filter = NULL;
	gchar* variable = NULL;
	gchar* value = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_ = NULL;
	RygelRelationalExpression* _tmp32_ = NULL;
	gconstpointer _tmp33_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	filter = NULL;
	variable = NULL;
	value = NULL;
	_tmp0_ = expression;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp1_, "@id") == 0) {
		gchar* _tmp2_ = NULL;
		gchar* parent_id = NULL;
		gchar* urn = NULL;
		RygelRelationalExpression* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		RygelRelationalExpression* _tmp20_ = NULL;
		gconstpointer _tmp21_ = NULL;
		_tmp2_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
		_g_free0 (variable);
		variable = _tmp2_;
		_tmp3_ = expression;
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->operand2;
		_tmp6_ = rygel_tracker_search_container_get_item_info (self, (const gchar*) _tmp4_, &_tmp5_);
		_g_free0 (parent_id);
		parent_id = _tmp5_;
		urn = _tmp6_;
		_tmp7_ = urn;
		_tmp8_ = g_utf8_validate (_tmp7_, (gssize) (-1), NULL);
		if (!_tmp8_) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp9_ = urn;
			_tmp10_ = rygel_tracker_search_container_urn_to_utf8 (self, _tmp9_);
			_g_free0 (urn);
			urn = _tmp10_;
		}
		_tmp13_ = urn;
		if (_tmp13_ == NULL) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = parent_id;
			_tmp12_ = _tmp14_ == NULL;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp15_ = parent_id;
			_tmp16_ = rygel_media_object_get_id ((RygelMediaObject*) self);
			_tmp17_ = _tmp16_;
			_tmp11_ = g_strcmp0 (_tmp15_, _tmp17_) != 0;
		}
		if (_tmp11_) {
			result = NULL;
			_g_free0 (urn);
			_g_free0 (parent_id);
			_g_free0 (value);
			_g_free0 (variable);
			_g_free0 (filter);
			return result;
		}
		_tmp18_ = urn;
		_tmp19_ = rygel_tracker_query_escape_string (_tmp18_);
		_g_free0 (urn);
		urn = _tmp19_;
		_tmp20_ = expression;
		_tmp21_ = ((RygelSearchExpression*) _tmp20_)->op;
		switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp21_)) {
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
			{
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				_tmp22_ = urn;
				_tmp23_ = g_strconcat ("<", _tmp22_, NULL);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (_tmp24_, ">", NULL);
				_g_free0 (value);
				value = _tmp25_;
				_g_free0 (_tmp24_);
				break;
			}
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
			{
				RygelRelationalExpression* _tmp26_ = NULL;
				gconstpointer _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				_tmp26_ = expression;
				_tmp27_ = ((RygelSearchExpression*) _tmp26_)->operand2;
				_tmp28_ = g_strdup ((const gchar*) _tmp27_);
				_g_free0 (value);
				value = _tmp28_;
				break;
			}
			default:
			break;
		}
		_g_free0 (urn);
		_g_free0 (parent_id);
	}
	_tmp30_ = variable;
	if (_tmp30_ == NULL) {
		_tmp29_ = TRUE;
	} else {
		const gchar* _tmp31_ = NULL;
		_tmp31_ = value;
		_tmp29_ = _tmp31_ == NULL;
	}
	if (_tmp29_) {
		result = NULL;
		_g_free0 (value);
		_g_free0 (variable);
		_g_free0 (filter);
		return result;
	}
	_tmp32_ = expression;
	_tmp33_ = ((RygelSearchExpression*) _tmp32_)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp33_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			_tmp34_ = variable;
			_tmp35_ = g_strconcat (_tmp34_, " = ", NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = value;
			_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
			_g_free0 (filter);
			filter = _tmp38_;
			_g_free0 (_tmp36_);
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			gchar* regex = NULL;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			_tmp39_ = value;
			_tmp40_ = rygel_tracker_query_escape_regex (_tmp39_);
			regex = _tmp40_;
			_tmp41_ = variable;
			_tmp42_ = g_strconcat ("regex(", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, ", \"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = regex;
			_tmp47_ = g_strconcat (_tmp45_, _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat (_tmp48_, "\", \"i\")", NULL);
			_g_free0 (filter);
			filter = _tmp49_;
			_g_free0 (_tmp48_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (regex);
			break;
		}
		default:
		break;
	}
	result = filter;
	_g_free0 (value);
	_g_free0 (variable);
	return result;
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
	((RygelMediaContainerClass *) klass)->get_children = rygel_tracker_search_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = rygel_tracker_search_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = rygel_tracker_search_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer);
	_rygel_tracker_query_unref0 (self->query);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
}


/**
 * A container listing a Tracker search result.
 */
GType rygel_tracker_search_container_get_type (void) {
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



