/* rygel-video-item.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelMediaFileItemPrivate RygelMediaFileItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
};

struct _RygelMediaFileItem {
	RygelMediaItem parent_instance;
	RygelMediaFileItemPrivate * priv;
};

struct _RygelMediaFileItemClass {
	RygelMediaItemClass parent_class;
	RygelMediaResource* (*get_primary_resource) (RygelMediaFileItem* self);
	gchar* (*get_extension) (RygelMediaFileItem* self);
	void (*add_additional_resources) (RygelMediaFileItem* self, RygelHTTPServer* server);
};

struct _RygelAudioItem {
	RygelMediaFileItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaFileItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gchar* _author;
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
	GeeArrayList* _subtitles;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY,
	RYGEL_VIDEO_ITEM_AUTHOR,
	RYGEL_VIDEO_ITEM_WIDTH,
	RYGEL_VIDEO_ITEM_HEIGHT,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH,
	RYGEL_VIDEO_ITEM_THUMBNAILS,
	RYGEL_VIDEO_ITEM_SUBTITLES
};
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
static void rygel_video_item_real_constructed (GObject* base);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
void rygel_video_item_set_subtitles (RygelVideoItem* self, GeeArrayList* value);
static void rygel_video_item_real_add_uri (RygelMediaObject* base, const gchar* uri);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const gchar* uri);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self, const gchar* uri, GError** error);
GeeArrayList* rygel_video_item_get_subtitles (RygelVideoItem* self);
static RygelMediaResource* rygel_video_item_real_get_primary_resource (RygelMediaFileItem* base);
RygelMediaResource* rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self);
void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self, RygelMediaResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_video_item_get_author (RygelVideoItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gchar* rygel_video_item_get_first (RygelVideoItem* self, GList* contributors);
static void rygel_video_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_video_item_set_author (RygelVideoItem* self, const gchar* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self, RygelMediaObject* object, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
void rygel_subtitle_add_didl_node (RygelSubtitle* self, GUPnPDIDLLiteItem* didl_item);
RygelSubtitle* rygel_subtitle_new (const gchar* mime_type, const gchar* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type, const gchar* mime_type, const gchar* caption_type);
gboolean rygel_http_server_is_local (RygelHTTPServer* self);
static void rygel_video_item_real_add_additional_resources (RygelMediaFileItem* base, RygelHTTPServer* server);
void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self, RygelHTTPServer* server);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, RygelHTTPServer* http_server);
static void rygel_video_item_finalize (GObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelVideoItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = id;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = parent;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = title;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = upnp_class;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return self;
#line 444 "rygel-video-item.c"
}


RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
#line 451 "rygel-video-item.c"
}


static void rygel_video_item_real_constructed (GObject* base) {
	RygelVideoItem * self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (rygel_video_item_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL, NULL, NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = _tmp0_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (_tmp1_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL, NULL, NULL);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = _tmp2_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_set_subtitles (self, _tmp3_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (_tmp3_);
#line 481 "rygel-video-item.c"
}


static void rygel_video_item_real_add_uri (RygelMediaObject* base, const gchar* uri) {
	RygelVideoItem * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelSubtitleManager* subtitle_manager = NULL;
	RygelSubtitleManager* _tmp2_ = NULL;
	RygelSubtitleManager* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (uri != NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = uri;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = uri;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, _tmp1_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = rygel_subtitle_manager_get_default ();
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	subtitle_manager = _tmp2_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = subtitle_manager;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp3_ != NULL) {
#line 513 "rygel-video-item.c"
		{
			GeeArrayList* subtitles = NULL;
			RygelSubtitleManager* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GeeArrayList* _tmp6_ = NULL;
			GeeArrayList* _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp4_ = subtitle_manager;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp5_ = uri;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp6_ = rygel_subtitle_manager_get_subtitles (_tmp4_, _tmp5_, &_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			subtitles = _tmp6_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 531 "rygel-video-item.c"
				goto __catch5_g_error;
			}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp7_ = self->priv->_subtitles;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp8_ = subtitles;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			gee_array_list_add_all (_tmp7_, (GeeCollection*) _tmp8_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_object_unref0 (subtitles);
#line 542 "rygel-video-item.c"
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* err = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			err = _inner_error_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_error_free0 (err);
#line 554 "rygel-video-item.c"
		}
		__finally5:
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_object_unref0 (subtitle_manager);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			g_clear_error (&_inner_error_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			return;
#line 567 "rygel-video-item.c"
		}
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (subtitle_manager);
#line 572 "rygel-video-item.c"
}


static RygelMediaResource* rygel_video_item_real_get_primary_resource (RygelMediaFileItem* base) {
	RygelVideoItem * self;
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_video_item_parent_class)->get_primary_resource ((RygelMediaFileItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem));
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	res = _tmp0_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_set_visual_resource_properties ((RygelVisualItem*) self, res);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = res;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 593 "rygel-video-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 600 "rygel-video-item.c"
}


static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelVideoItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelVideoItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelVideoItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = media_object;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		result = 1;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return result;
#line 630 "rygel-video-item.c"
	}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = media_object;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp1_) : NULL);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	item = _tmp2_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = property;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = _tmp3_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("upnp:author")))) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		switch (0) {
#line 648 "rygel-video-item.c"
			default:
			{
				const gchar* _tmp7_ = NULL;
				RygelVideoItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp7_ = self->priv->_author;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp8_ = item;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp9_ = _tmp8_->priv->_author;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				result = _tmp10_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_object_unref0 (item);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				return result;
#line 669 "rygel-video-item.c"
			}
		}
	} else {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		switch (0) {
#line 675 "rygel-video-item.c"
			default:
			{
				RygelVideoItem* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp11_ = item;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp12_ = property;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp13_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp11_, _tmp12_);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				result = _tmp13_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_object_unref0 (item);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				return result;
#line 693 "rygel-video-item.c"
			}
		}
	}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (item);
#line 699 "rygel-video-item.c"
}


static gchar* rygel_video_item_get_first (RygelVideoItem* self, GList* contributors) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	gchar* _tmp6_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = contributors;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp0_ != NULL) {
#line 713 "rygel-video-item.c"
		GList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp1_ = contributors;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp2_ = _tmp1_->data;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp3_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp2_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp4_ = _tmp3_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		result = _tmp5_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return result;
#line 733 "rygel-video-item.c"
	}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp6_ = g_strdup ("");
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp6_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 741 "rygel-video-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 748 "rygel-video-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_list_free (self);
#line 757 "rygel-video-item.c"
}


static void rygel_video_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = didl_object;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = didl_object;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_authors (_tmp1_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = rygel_video_item_get_first (self, _tmp3_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp5_ = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_set_author (self, _tmp5_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_free0 (_tmp5_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	__g_list_free__g_object_unref0_0 (_tmp3_);
#line 793 "rygel-video-item.c"
}


static gpointer _rygel_subtitle_ref0 (gpointer self) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return self ? rygel_subtitle_ref (self) : NULL;
#line 800 "rygel-video-item.c"
}


static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	RygelSerializer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp4_ = NULL;
	GUPnPDIDLLiteItem* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = serializer;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp2_ = http_server;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp3_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp1_, _tmp2_, &_inner_error_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = _tmp3_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_propagate_error (error, _inner_error_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		return NULL;
#line 839 "rygel-video-item.c"
	}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp4_ = _tmp0_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp4_) : NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp5_ == NULL) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_g_object_unref0 (_tmp4_);
#line 851 "rygel-video-item.c"
	}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	didl_item = _tmp5_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp7_ = self->priv->_author;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp7_ != NULL) {
#line 859 "rygel-video-item.c"
		const gchar* _tmp8_ = NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp8_ = self->priv->_author;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
#line 865 "rygel-video-item.c"
	} else {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp6_ = FALSE;
#line 869 "rygel-video-item.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (_tmp6_) {
#line 873 "rygel-video-item.c"
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteItem* _tmp9_ = NULL;
		GUPnPDIDLLiteContributor* _tmp10_ = NULL;
		GUPnPDIDLLiteContributor* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp9_ = didl_item;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp10_ = gupnp_didl_lite_object_add_author ((GUPnPDIDLLiteObject*) _tmp9_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		contributor = _tmp10_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp11_ = contributor;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp12_ = self->priv->_author;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp11_, _tmp12_);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_g_object_unref0 (contributor);
#line 893 "rygel-video-item.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp13_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp14_ = _tmp13_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	if (!_tmp14_) {
#line 901 "rygel-video-item.c"
		RygelSubtitle* main_subtitle = NULL;
		gpointer _tmp15_ = NULL;
		RygelSubtitle* _tmp16_ = NULL;
		RygelSubtitle* _tmp74_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp15_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp16_ = _rygel_subtitle_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_SUBTITLE) ? ((RygelSubtitle*) _tmp15_) : NULL);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		main_subtitle = _tmp16_;
#line 912 "rygel-video-item.c"
		{
			GeeArrayList* _subtitle_list = NULL;
			GeeArrayList* _tmp17_ = NULL;
			GeeArrayList* _tmp18_ = NULL;
			gint _subtitle_size = 0;
			GeeArrayList* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _subtitle_index = 0;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp17_ = self->priv->_subtitles;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_list = _tmp18_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp19_ = _subtitle_list;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp21_ = _tmp20_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_size = _tmp21_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_subtitle_index = -1;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			while (TRUE) {
#line 940 "rygel-video-item.c"
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				RygelSubtitle* subtitle = NULL;
				GeeArrayList* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gpointer _tmp27_ = NULL;
				gchar* protocol = NULL;
				RygelHTTPServer* _tmp37_ = NULL;
				RygelSubtitle* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				gboolean _tmp68_ = FALSE;
				RygelHTTPServer* _tmp69_ = NULL;
				gboolean _tmp70_ = FALSE;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp22_ = _subtitle_index;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_subtitle_index = _tmp22_ + 1;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp23_ = _subtitle_index;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp24_ = _subtitle_size;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (!(_tmp23_ < _tmp24_)) {
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					break;
#line 968 "rygel-video-item.c"
				}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp25_ = _subtitle_list;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp26_ = _subtitle_index;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				subtitle = (RygelSubtitle*) _tmp27_;
#line 978 "rygel-video-item.c"
				{
					gchar* _tmp28_ = NULL;
					RygelSubtitle* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp29_ = subtitle;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp30_ = _tmp29_->uri;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp31_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp30_, &_inner_error_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp28_ = _tmp31_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 995 "rygel-video-item.c"
						goto __catch6_g_error;
					}
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp32_ = _tmp28_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp28_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (protocol);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					protocol = _tmp32_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (_tmp28_);
#line 1008 "rygel-video-item.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					RygelSubtitle* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					e = _inner_error_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_inner_error_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp33_ = subtitle;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp34_ = _tmp33_->uri;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp35_ = g_strconcat ("Could not determine protocol for ", _tmp34_, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp36_ = _tmp35_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					g_message ("rygel-video-item.vala:155: %s", _tmp36_);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (_tmp36_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_error_free0 (e);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (protocol);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_rygel_subtitle_unref0 (subtitle);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					continue;
#line 1042 "rygel-video-item.c"
				}
				__finally6:
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					g_propagate_error (error, _inner_error_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (protocol);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_rygel_subtitle_unref0 (subtitle);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_object_unref0 (_subtitle_list);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_rygel_subtitle_unref0 (main_subtitle);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_object_unref0 (didl_item);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_object_unref0 (_tmp0_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					return NULL;
#line 1063 "rygel-video-item.c"
				}
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp37_ = http_server;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp38_ = subtitle;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp39_ = _tmp38_->uri;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp40_ = rygel_http_server_need_proxy (_tmp37_, _tmp39_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (_tmp40_) {
#line 1075 "rygel-video-item.c"
					gchar* uri = NULL;
					RygelSubtitle* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gint index = 0;
					GeeArrayList* _tmp44_ = NULL;
					RygelSubtitle* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					RygelSubtitle* _tmp47_ = NULL;
					RygelHTTPServer* _tmp48_ = NULL;
					gint _tmp49_ = 0;
					gchar* _tmp50_ = NULL;
					RygelSubtitle* _tmp51_ = NULL;
					GUPnPDIDLLiteItem* _tmp52_ = NULL;
					RygelSubtitle* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					gchar* _tmp55_ = NULL;
					RygelSubtitle* _tmp56_ = NULL;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp41_ = subtitle;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp42_ = _tmp41_->uri;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp43_ = g_strdup (_tmp42_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					uri = _tmp43_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp44_ = self->priv->_subtitles;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp45_ = subtitle;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp46_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp44_, _tmp45_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					index = _tmp46_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp47_ = subtitle;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp48_ = http_server;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp49_ = index;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp50_ = rygel_http_server_create_uri_for_object (_tmp48_, (RygelMediaObject*) self, -1, _tmp49_, NULL);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (_tmp47_->uri);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp47_->uri = _tmp50_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp51_ = subtitle;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp52_ = didl_item;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					rygel_subtitle_add_didl_node (_tmp51_, _tmp52_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp53_ = subtitle;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp54_ = uri;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp55_ = g_strdup (_tmp54_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (_tmp53_->uri);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp53_->uri = _tmp55_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp56_ = main_subtitle;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					if (_tmp56_ == NULL) {
#line 1142 "rygel-video-item.c"
						RygelSubtitle* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
						RygelSubtitle* _tmp59_ = NULL;
						const gchar* _tmp60_ = NULL;
						RygelSubtitle* _tmp61_ = NULL;
						RygelSubtitle* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
						gchar* _tmp64_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp57_ = subtitle;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp58_ = _tmp57_->mime_type;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp59_ = subtitle;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp60_ = _tmp59_->caption_type;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp61_ = rygel_subtitle_new (_tmp58_, _tmp60_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_rygel_subtitle_unref0 (main_subtitle);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						main_subtitle = _tmp61_;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp62_ = main_subtitle;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp63_ = uri;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp64_ = g_strdup (_tmp63_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_g_free0 (_tmp62_->uri);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp62_->uri = _tmp64_;
#line 1175 "rygel-video-item.c"
					}
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_g_free0 (uri);
#line 1179 "rygel-video-item.c"
				} else {
					RygelSubtitle* _tmp65_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp65_ = main_subtitle;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					if (_tmp65_ == NULL) {
#line 1186 "rygel-video-item.c"
						RygelSubtitle* _tmp66_ = NULL;
						RygelSubtitle* _tmp67_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp66_ = subtitle;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp67_ = _rygel_subtitle_ref0 (_tmp66_);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_rygel_subtitle_unref0 (main_subtitle);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						main_subtitle = _tmp67_;
#line 1197 "rygel-video-item.c"
					}
				}
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp69_ = http_server;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_tmp70_ = rygel_http_server_is_local (_tmp69_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (_tmp70_) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp68_ = TRUE;
#line 1208 "rygel-video-item.c"
				} else {
					const gchar* _tmp71_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp71_ = protocol;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp68_ = g_strcmp0 (_tmp71_, "internal") != 0;
#line 1215 "rygel-video-item.c"
				}
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				if (_tmp68_) {
#line 1219 "rygel-video-item.c"
					RygelSubtitle* _tmp72_ = NULL;
					GUPnPDIDLLiteItem* _tmp73_ = NULL;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp72_ = subtitle;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp73_ = didl_item;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					rygel_subtitle_add_didl_node (_tmp72_, _tmp73_);
#line 1228 "rygel-video-item.c"
				}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_g_free0 (protocol);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				_rygel_subtitle_unref0 (subtitle);
#line 1234 "rygel-video-item.c"
			}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_g_object_unref0 (_subtitle_list);
#line 1238 "rygel-video-item.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_tmp74_ = main_subtitle;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		if (_tmp74_ != NULL) {
#line 1244 "rygel-video-item.c"
			GList* resources = NULL;
			GUPnPDIDLLiteItem* _tmp75_ = NULL;
			GList* _tmp76_ = NULL;
			GList* _tmp77_ = NULL;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp75_ = didl_item;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp76_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp75_);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			resources = _tmp76_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			_tmp77_ = resources;
#line 1257 "rygel-video-item.c"
			{
				GList* resource_collection = NULL;
				GList* resource_it = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				resource_collection = _tmp77_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
				for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
#line 1265 "rygel-video-item.c"
					GUPnPDIDLLiteResource* _tmp78_ = NULL;
					GUPnPDIDLLiteResource* resource = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					_tmp78_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
					resource = _tmp78_;
#line 1272 "rygel-video-item.c"
					{
						GUPnPDIDLLiteResource* _tmp79_ = NULL;
						GUPnPProtocolInfo* _tmp80_ = NULL;
						GUPnPProtocolInfo* _tmp81_ = NULL;
						GUPnPDLNAFlags _tmp82_ = 0;
						GUPnPDLNAFlags _tmp83_ = 0;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp79_ = resource;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp80_ = gupnp_didl_lite_resource_get_protocol_info (_tmp79_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp81_ = _tmp80_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp82_ = gupnp_protocol_info_get_dlna_flags (_tmp81_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_tmp83_ = _tmp82_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						if ((_tmp83_ & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) != 0) {
#line 1291 "rygel-video-item.c"
							GUPnPDIDLLiteResource* _tmp84_ = NULL;
							RygelSubtitle* _tmp85_ = NULL;
							const gchar* _tmp86_ = NULL;
							gchar* _tmp87_ = NULL;
							gchar* _tmp88_ = NULL;
							GUPnPDIDLLiteResource* _tmp89_ = NULL;
							RygelSubtitle* _tmp90_ = NULL;
							const gchar* _tmp91_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp84_ = resource;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp85_ = main_subtitle;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp86_ = _tmp85_->caption_type;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp87_ = g_utf8_strup (_tmp86_, (gssize) (-1));
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp88_ = _tmp87_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							gupnp_didl_lite_resource_set_subtitle_file_type (_tmp84_, _tmp88_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_g_free0 (_tmp88_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp89_ = resource;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp90_ = main_subtitle;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							_tmp91_ = _tmp90_->uri;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
							gupnp_didl_lite_resource_set_subtitle_file_uri (_tmp89_, _tmp91_);
#line 1322 "rygel-video-item.c"
						}
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
						_g_object_unref0 (resource);
#line 1326 "rygel-video-item.c"
					}
				}
			}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
			__g_list_free__g_object_unref0_0 (resources);
#line 1332 "rygel-video-item.c"
		}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		_rygel_subtitle_unref0 (main_subtitle);
#line 1336 "rygel-video-item.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = (GUPnPDIDLLiteObject*) didl_item;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (_tmp0_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1344 "rygel-video-item.c"
}


static void rygel_video_item_real_add_additional_resources (RygelMediaFileItem* base, RygelHTTPServer* server) {
	RygelVideoItem * self;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (server != NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = server;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_video_item_parent_class)->add_additional_resources ((RygelMediaFileItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = server;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, _tmp1_);
#line 1364 "rygel-video-item.c"
}


const gchar* rygel_video_item_get_author (RygelVideoItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_author;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1379 "rygel-video-item.c"
}


void rygel_video_item_set_author (RygelVideoItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_free0 (self->priv->_author);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_author = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "author");
#line 1398 "rygel-video-item.c"
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_width;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1414 "rygel-video-item.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_width = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "width");
#line 1429 "rygel-video-item.c"
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_height;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1445 "rygel-video-item.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_height = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "height");
#line 1460 "rygel-video-item.c"
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_color_depth;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1476 "rygel-video-item.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_color_depth = _tmp0_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "color-depth");
#line 1491 "rygel-video-item.c"
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_thumbnails;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1507 "rygel-video-item.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = (RygelVideoItem*) base;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->priv->_thumbnails);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_thumbnails = _tmp1_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "thumbnails");
#line 1527 "rygel-video-item.c"
}


GeeArrayList* rygel_video_item_get_subtitles (RygelVideoItem* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = self->priv->_subtitles;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	result = _tmp0_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	return result;
#line 1542 "rygel-video-item.c"
}


void rygel_video_item_set_subtitles (RygelVideoItem* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp0_ = value;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->priv->_subtitles);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_subtitles = _tmp1_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_notify ((GObject *) self, "subtitles");
#line 1561 "rygel-video-item.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((GObjectClass *) klass)->constructed = rygel_video_item_real_constructed;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((RygelMediaObjectClass *) klass)->add_uri = rygel_video_item_real_add_uri;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((RygelMediaFileItemClass *) klass)->get_primary_resource = rygel_video_item_real_get_primary_resource;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((RygelMediaObjectClass *) klass)->compare_by_property = rygel_video_item_real_compare_by_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_video_item_real_apply_didl_lite;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((RygelMediaObjectClass *) klass)->serialize = rygel_video_item_real_serialize;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	((RygelMediaFileItemClass *) klass)->add_additional_resources = rygel_video_item_real_add_additional_resources;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_video_item_get_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_video_item_set_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_AUTHOR, g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1592 "rygel-video-item.c"
	/**
	     * The width of the item source content (this.uri) in pixels
	     * A value of -1 means that the width is unknown
	     */
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1599 "rygel-video-item.c"
	/**
	     * The height of the item source content (this.uri) in pixels
	     * A value of -1 means that the height is unknown
	     */
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1606 "rygel-video-item.c"
	/**
	     * The number of bits per pixel in the source video resource (this.uri)
	     * A value of -1 means that the color depth is unknown
	     */
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1613 "rygel-video-item.c"
	/**
	     * Thumbnail pictures to represent the video.
	     */
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_SUBTITLES, g_param_spec_object ("subtitles", "subtitles", "subtitles", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1621 "rygel-video-item.c"
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_width = rygel_video_item_real_get_width;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_width = rygel_video_item_real_set_width;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_height = rygel_video_item_real_get_height;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_height = rygel_video_item_real_set_height;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
#line 1644 "rygel-video-item.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_width = -1;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_height = -1;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self->priv->_color_depth = -1;
#line 1657 "rygel-video-item.c"
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_free0 (self->priv->_author);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->priv->_thumbnails);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	_g_object_unref0 (self->priv->_subtitles);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 1673 "rygel-video-item.c"
}


/**
 * Represents a video item.
 */
GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_AUTHOR:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_string (value, rygel_video_item_get_author (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_WIDTH:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_HEIGHT:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_SUBTITLES:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		g_value_set_object (value, rygel_video_item_get_subtitles (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1735 "rygel-video-item.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1741 "rygel-video-item.c"
	}
}


static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_AUTHOR:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_video_item_set_author (self, g_value_get_string (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_WIDTH:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_HEIGHT:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		case RYGEL_VIDEO_ITEM_SUBTITLES:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		rygel_video_item_set_subtitles (self, g_value_get_object (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1787 "rygel-video-item.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-video-item.vala"
		break;
#line 1793 "rygel-video-item.c"
	}
}



